/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedger;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedgerAssist;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.app.AbstractGLReportSubsidiaryLedgerAssistControllerBean;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class GLReportSubsidiaryLedgerAssistControllerBean
extends AbstractGLReportSubsidiaryLedgerAssistControllerBean {
    private static final long serialVersionUID = -6230504915824951904L;

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedgerAssist condition = (ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition();
        partner.setTempTableName(partner.createTempTableAsynchronism("GLSL", this.getTempTableStruct(partner)));
        if (!partner.getAccountViewInfo().isIsLeaf()) {
            condition.setAsstAccountId(null);
        }
        HashMap map = this.getStartBalance(partner);
        this.insertStartBalance(map, partner);
        this.insertVoucher(partner);
        if (condition.getOptionDailyTotal()) {
            this.insertDailySum(partner);
        }
        this.insertPeriodSum(partner);
        this.insertYearSum(map, partner);
        ReportConditionSubsidiaryLedger cc = (ReportConditionSubsidiaryLedger)partner.getCondition().get("GLFixCondition");
        if (cc.getOptionAmountZero()) {
            String suffix = null;
            switch (partner.getCurrencyType()) {
                case 0: {
                    suffix = "for";
                    break;
                }
                case 1: {
                    suffix = "local";
                    break;
                }
                default: {
                    suffix = "for";
                }
            }
            String delSql = "delete from " + partner.getTempTableName() + " where not exists(select top 1 * from " + partner.getTempTableName() + " where (FCredit" + suffix + "<>0 or FDebit" + suffix + "<>0 ))";
            DbUtil.execute((Context)partner.getContext(), (String)delSql);
        } else if (cc.getOptionBalanceAndAmountZero()) {
            String suffix = null;
            switch (partner.getCurrencyType()) {
                case 0: {
                    suffix = "for";
                    break;
                }
                case 1: {
                    suffix = "local";
                    break;
                }
                default: {
                    suffix = "for";
                }
            }
            String delSql = "delete from " + partner.getTempTableName() + " where not exists(select top 1 * from " + partner.getTempTableName() + " where (FCredit" + suffix + "<>0 or FDebit" + suffix + "<>0))";
            DbUtil.execute((Context)partner.getContext(), (String)delSql);
        }
        this.addSeqColToTable(partner);
    }

    @Override
    protected HashMap getStartBalance(ReportPartner partner) throws BOSException, EASBizException {
        IRowSet rs;
        HashMap<String, Object> map;
        block40: {
            ReportConditionSubsidiaryLedgerAssist condition = (ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition();
            int baltype = new Integer(condition.getOptionPosting() ? 1 : 5);
            String asstAccountId = condition.getAsstAccountId();
            String currencyId = condition.getCurrencyID();
            boolean isForCurrency = false;
            boolean isLocalCurrency = false;
            boolean isRptCurrency = false;
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
                isLocalCurrency = true;
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                isRptCurrency = true;
            } else {
                isForCurrency = true;
            }
            StringBuffer sql = new StringBuffer();
            String local = "_" + partner.getContext().getLocale().getLanguage();
            sql.append("SELECT \r\n");
            boolean isLeafAsst = condition.getAssistItemId() != null && condition.getAssistItemId().indexOf(",") == -1;
            boolean isAfterPeriod = this.isAfterPeriod(partner);
            if (isLeafAsst) {
                sql.append("\tbd.FNumber,");
                sql.append("\tbd.FName").append(local).append(" FName,");
            } else {
                sql.append("\t'' FNumber,");
                sql.append("\t'' FName,");
            }
            sql.append("\tTP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber, \r\n");
            if (isAfterPeriod) {
                Context ctx = partner.getContext();
                PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()));
                int curPeriod = currentPeriod.getNumber();
                if (isForCurrency) {
                    this.appendAfterPeriodSql(sql, "For", "For", condition, curPeriod);
                    this.appendAfterPeriodSql(sql, "Local", "Local", condition, curPeriod);
                    this.appendAfterPeriodSql(sql, "Rpt", "Rpt", condition, curPeriod);
                } else if (isLocalCurrency) {
                    this.appendAfterPeriodSql(sql, "Local", "For", condition, curPeriod);
                    this.appendAfterPeriodSql(sql, "Local", "Local", condition, curPeriod);
                    this.appendAfterPeriodSql(sql, "Local", "Rpt", condition, curPeriod);
                } else if (isRptCurrency) {
                    this.appendAfterPeriodSql(sql, "Rpt", "For", condition, curPeriod);
                    this.appendAfterPeriodSql(sql, "Rpt", "Local", condition, curPeriod);
                    this.appendAfterPeriodSql(sql, "Rpt", "Rpt", condition, curPeriod);
                }
                this.appendAfterPeriodSql(sql, "Qty", "Qty", condition, curPeriod);
                sql.deleteCharAt(sql.lastIndexOf(","));
            } else {
                if (isForCurrency) {
                    sql.append("\tSUM(TB.FBeginBalanceFor) FBeginBalanceFor, \r\n");
                    sql.append("\tSUM(TB.FYearDebitFor - TB.FDebitFor) FYearDebitFor, \r\n");
                    sql.append("\tSUM(TB.FYearCreditFor - TB.FCreditFor) FYearCreditFor, \r\n");
                    sql.append("\tSUM(TB.FBeginBalanceLocal) FBeginBalanceLocal, \r\n");
                    sql.append("\tSUM(TB.FYearDebitLocal - TB.FDebitLocal) FYearDebitLocal, \r\n");
                    sql.append("\tSUM(TB.FYearCreditLocal - TB.FCreditLocal) FYearCreditLocal, \r\n");
                    sql.append("\tSUM(TB.FBeginBalanceRpt) FBeginBalanceRpt, \r\n");
                    sql.append("\tSUM(TB.FYearDebitRpt - TB.FDebitRpt) FYearDebitRpt, \r\n");
                    sql.append("\tSUM(TB.FYearCreditRpt - TB.FCreditRpt) FYearCreditRpt, \r\n");
                } else if (isLocalCurrency) {
                    sql.append("\tSUM(TB.FBeginBalanceLocal) FBeginBalanceFor, \r\n");
                    sql.append("\tSUM(TB.FYearDebitLocal - TB.FDebitLocal) FYearDebitFor, \r\n");
                    sql.append("\tSUM(TB.FYearCreditLocal - TB.FCreditLocal) FYearCreditFor, \r\n");
                    sql.append("\tSUM(TB.FBeginBalanceLocal) FBeginBalanceLocal, \r\n");
                    sql.append("\tSUM(TB.FYearDebitLocal - TB.FDebitLocal) FYearDebitLocal, \r\n");
                    sql.append("\tSUM(TB.FYearCreditLocal - TB.FCreditLocal) FYearCreditLocal, \r\n");
                    sql.append("\tSUM(TB.FBeginBalanceLocal) FBeginBalanceRpt, \r\n");
                    sql.append("\tSUM(TB.FYearDebitLocal - TB.FDebitLocal) FYearDebitRpt, \r\n");
                    sql.append("\tSUM(TB.FYearCreditLocal - TB.FCreditLocal) FYearCreditRpt, \r\n");
                } else if (isRptCurrency) {
                    sql.append("\tSUM(TB.FBeginBalanceRpt) FBeginBalanceFor, \r\n");
                    sql.append("\tSUM(TB.FYearDebitRpt - TB.FDebitRpt) FYearDebitFor, \r\n");
                    sql.append("\tSUM(TB.FYearCreditRpt - TB.FCreditRpt) FYearCreditFor, \r\n");
                    sql.append("\tSUM(TB.FBeginBalanceRpt) FBeginBalanceLocal, \r\n");
                    sql.append("\tSUM(TB.FYearDebitRpt - TB.FDebitRpt) FYearDebitLocal, \r\n");
                    sql.append("\tSUM(TB.FYearCreditRpt - TB.FCreditRpt) FYearCreditLocal, \r\n");
                    sql.append("\tSUM(TB.FBeginBalanceRpt) FBeginBalanceRpt, \r\n");
                    sql.append("\tSUM(TB.FYearDebitRpt - TB.FDebitRpt) FYearDebitRpt, \r\n");
                    sql.append("\tSUM(TB.FYearCreditRpt - TB.FCreditRpt) FYearCreditRpt, \r\n");
                }
                sql.append("\tSUM(TB.FBeginQty) FBeginQty, \r\n");
                sql.append("\tSUM(TB.FYearDebitQty - TB.FDebitQty) FYearDebitQty, \r\n");
                sql.append("\tSUM(TB.FYearCreditQty - TB.FCreditQty) FYearCreditQty \r\n");
            }
            sql.append("\tFROM T_BD_AssistantHG HG \r\n");
            sql.append("\tJOIN " + GLBalanceUtils.getAssistBalanceTable(baltype, currencyId) + " TB ON TB.FASSISTGRPID = HG.FID ");
            sql.append("\tAND TB.FOrgUnitID = '").append(partner.getCompanyId()).append("' ");
            if (partner.getAccountViewInfo().isIsLeaf()) {
                sql.append("\tAND TB.FAccountID = '").append(condition.getAccountId()).append("'  ");
            } else {
                sql.append("\tAND TB.FAccountID IN (");
                sql.append(this.getChildAccountIds(partner, partner.getAccountViewInfo()));
                sql.append(") \r\n");
            }
            if (isForCurrency) {
                sql.append("\tAND TB.FCurrencyID = '").append(condition.getCurrencyID()).append("'");
            }
            sql.append("\tJOIN T_BD_Period TP on TP.FNumber = TB.FPeriod \r\n");
            sql.append("\tAND TP.FTypeID = '").append(partner.getCompany().getAccountPeriodType().getId().toString()).append("' \r\n");
            sql.append(" INNER JOIN ").append(partner.getAsstActTypeInfo().getRealtionDataObject()).append(" bd on ");
            sql.append(" bd.fid = ").append(" hg. ").append(partner.getAsstActTypeInfo().getMappingFieldName());
            sql.append("\r\n");
            int startPeriod = condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
            sql.append(" WHERE \r\n");
            if (isAfterPeriod) {
                sql.append(" TB.FPeriod <= ").append(startPeriod);
            } else {
                sql.append(" TB.FPeriod = ").append(startPeriod);
            }
            sql.append(" AND HG.");
            sql.append(partner.getAsstActTypeInfo().getMappingFieldName());
            sql.append(" in ('" + condition.getAssistItemId() + "') \r\n");
            if (asstAccountId != null) {
                sql.append(" and HG.FAsstAccountID = '" + asstAccountId + "' \n");
            }
            if (isLeafAsst) {
                sql.append("GROUP BY bd.FNumber, bd.FName").append(local).append(", TP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber \r\n");
            } else {
                sql.append("GROUP BY TP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber \r\n");
            }
            sql.append("ORDER BY TP.FBeginDate DESC");
            map = new HashMap<String, Object>();
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql.toString());
                BigDecimal beginBalanceFor = new BigDecimal(0);
                BigDecimal beginBalanceLocal = new BigDecimal(0);
                BigDecimal beginBalanceRpt = new BigDecimal(0);
                BigDecimal beginQty = new BigDecimal(0);
                BigDecimal yearDebitFor = ZERO;
                BigDecimal yearCreditFor = ZERO;
                BigDecimal yearDebitLocal = ZERO;
                BigDecimal yearCreditLocal = ZERO;
                BigDecimal yearDebitRpt = ZERO;
                BigDecimal yearCreditRpt = ZERO;
                BigDecimal yearDebitQty = ZERO;
                BigDecimal yearCreditQty = ZERO;
                String number = "";
                String name = "";
                Boolean isResult = false;
                while (rs.next()) {
                    if (!isResult.booleanValue()) {
                        number = rs.getString("FNumber");
                        name = rs.getString("FName");
                        map.put("FPeriodYear", rs.getInt("FPeriodYear"));
                        map.put("FPeriodNumber", rs.getInt("FPeriodNumber"));
                    }
                    isResult = true;
                    int period = rs.getInt("FPeriodYear") * 100 + rs.getInt("FPeriodNumber");
                    if (isAfterPeriod && (!isAfterPeriod || period >= startPeriod)) continue;
                    BigDecimal val = rs.getBigDecimal("FBeginBalanceFor");
                    beginBalanceFor = beginBalanceFor.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginBalanceLocal");
                    beginBalanceLocal = beginBalanceLocal.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginBalanceRpt");
                    beginBalanceRpt = beginBalanceRpt.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginQty");
                    beginQty = beginQty.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitFor");
                    yearDebitFor = yearDebitFor.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditFor");
                    yearCreditFor = yearCreditFor.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitLocal");
                    yearDebitLocal = yearDebitLocal.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditLocal");
                    yearCreditLocal = yearCreditLocal.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitRpt");
                    yearDebitRpt = yearDebitRpt.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditRpt");
                    yearCreditRpt = yearCreditRpt.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitQty");
                    yearDebitQty = yearDebitQty.add(val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditQty");
                }
                if (isResult.booleanValue()) {
                    map.put("FBeginBalanceFor", beginBalanceFor);
                    map.put("FBeginBalanceLocal", beginBalanceLocal);
                    map.put("FBeginBalanceRpt", beginBalanceRpt);
                    map.put("FBeginQty", beginQty);
                    map.put("FYearDebitFor", yearDebitFor);
                    map.put("FYearCreditFor", yearCreditFor);
                    map.put("FYearDebitLocal", yearDebitLocal);
                    map.put("FYearCreditLocal", yearCreditLocal);
                    map.put("FYearDebitRpt", yearDebitRpt);
                    map.put("FYearCreditRpt", yearCreditRpt);
                    map.put("FYearDebitQty", yearDebitQty);
                    map.put("FYearCreditQty", yearCreditQty);
                    if (condition.getAssistItemId().split(",").length > 1) {
                        map.put("FNumber", "");
                        map.put("FName", "");
                    } else {
                        map.put("FNumber", number);
                        map.put("FName", name);
                    }
                    break block40;
                }
                SQLUtils.cleanup((ResultSet)rs);
                sql = new StringBuffer();
                sql.append("SELECT \r\n");
                sql.append("\tTP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber \r\n");
                sql.append("FROM T_BD_Period TP \r\n");
                sql.append("WHERE \r\n");
                sql.append("\tTP.FTypeID = '").append(partner.getCompany().getAccountPeriodType().getId().toString()).append("' AND \r\n");
                sql.append("\tTP.FPeriodYear = ").append(condition.getPeriodYearStart()).append(" AND \r\n");
                sql.append("\tTP.FPeriodNumber = ").append(condition.getPeriodNumberStart()).append("  \r\n");
                rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql.toString());
                if (rs.next()) {
                    map.put("FBeginDate", rs.getTimestamp("FBeginDate"));
                    map.put("FPeriodYear", new Integer(rs.getInt("FPeriodYear")));
                    map.put("FPeriodNumber", new Integer(rs.getInt("FPeriodNumber")));
                    map.put("FBeginBalanceFor", ZERO);
                    map.put("FBeginBalanceLocal", ZERO);
                    map.put("FBeginBalanceRpt", ZERO);
                    map.put("FBeginQty", ZERO);
                    map.put("FYearDebitFor", ZERO);
                    map.put("FYearCreditFor", ZERO);
                    map.put("FYearDebitLocal", ZERO);
                    map.put("FYearCreditLocal", ZERO);
                    map.put("FYearDebitRpt", ZERO);
                    map.put("FYearCreditRpt", ZERO);
                    map.put("FYearDebitQty", ZERO);
                    map.put("FYearCreditQty", ZERO);
                    if (condition.getAssistItemId().split(",").length > 1) {
                        map.put("FNumber", "");
                        map.put("FName", "");
                    } else {
                        SQLUtils.cleanup((ResultSet)rs);
                        sql = new StringBuffer();
                        sql.append("SELECT \r\n");
                        sql.append("\tbd.FNumber,");
                        sql.append("\tbd.FName").append(local).append(" FName ");
                        sql.append("FROM ").append(partner.getAsstActTypeInfo().getRealtionDataObject()).append(" bd ");
                        sql.append("\r\n");
                        sql.append("WHERE bd.fid in ('" + condition.getAssistItemId() + "') \r\n");
                        rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql.toString());
                        if (rs.next()) {
                            String fNumber = rs.getString("FNumber");
                            map.put("FNumber", fNumber);
                            String fName = rs.getString("FName");
                            map.put("FName", fName);
                        } else {
                            map.put("FNumber", "");
                            map.put("FName", "");
                        }
                    }
                    break block40;
                }
                throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
            }
            catch (SQLException sqle) {
                try {
                    sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    private void appendAfterPeriodSql(StringBuffer sql, String balSuffix, String selectSuffix, ReportConditionSubsidiaryLedgerAssist cond, int curPeriod) {
        int endYear = cond.getPeriodYearEnd();
        int startPeriod = cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart();
        int endPeriod = endYear * 100 + cond.getPeriodNumberEnd();
        String balStr = "Qty".equalsIgnoreCase(balSuffix) ? "" : "Balance";
        sql.append(" sum(case ");
        sql.append(" when ").append(startPeriod).append(" <= ").append(curPeriod).append(" and TB.FPeriod = ").append(startPeriod).append(" then TB.FBegin").append(balStr).append(balSuffix).append(" \r\n");
        sql.append(" when ").append(startPeriod).append(" > ").append(curPeriod).append(" and TB.FPeriod = ").append(curPeriod).append(" then TB.FEnd").append(balStr).append(balSuffix).append(" \r\n");
        sql.append(" when ").append(startPeriod).append(" > ").append(curPeriod).append(" and TB.FPeriod > ").append(curPeriod).append(" and TB.FPeriod < ").append(startPeriod).append(" then TB.FDebit").append(balSuffix).append(" - TB.FCredit").append(balSuffix).append(" \r\n");
        sql.append(" else 0 end) FBegin").append(balStr).append(selectSuffix).append(", \r\n");
        sql.append(" sum(case ");
        sql.append(" when ").append(endPeriod).append(" <= ").append(curPeriod).append(" and TB.FPeriod = ").append(endPeriod).append(" then TB.FYearDebit").append(balSuffix).append(" \r\n");
        sql.append(" when ").append(endPeriod).append(" > ").append(curPeriod).append(" and TB.FPeriod = ").append(curPeriod).append(" and TO_INT(TB.FPeriod/100) = ").append(endYear).append(" then TB.FYearDebit").append(balSuffix).append(" \r\n");
        sql.append(" when ").append(endPeriod).append(" > ").append(curPeriod).append(" and TB.FPeriod> ").append(curPeriod).append(" and TO_INT(TB.FPeriod/100) = ").append(endYear).append(" then TB.FDebit").append(balSuffix).append(" \r\n");
        sql.append(" else 0 end) FYearDebit").append(selectSuffix).append(", \r\n");
        sql.append(" sum(case ");
        sql.append(" when ").append(endPeriod).append(" <= ").append(curPeriod).append(" and TB.FPeriod = ").append(endPeriod).append(" then TB.FYearCredit").append(balSuffix).append(" \r\n");
        sql.append(" when ").append(endPeriod).append(" > ").append(curPeriod).append(" and TB.FPeriod = ").append(curPeriod).append(" and TO_INT(TB.FPeriod/100) = ").append(endYear).append(" then TB.FYearCredit").append(balSuffix).append(" \r\n");
        sql.append(" when ").append(endPeriod).append(" > ").append(curPeriod).append(" and TB.FPeriod > ").append(curPeriod).append(" and TO_INT(TB.FPeriod/100) = ").append(endYear).append(" then TB.FCredit").append(balSuffix).append(" \r\n");
        sql.append(" else 0 end) FYearCredit").append(selectSuffix).append(", \r\n");
    }

    protected void insertVoucher(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedgerAssist condition = (ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition();
        String asstAccountId = condition.getAsstAccountId();
        boolean isShowQuantity = false;
        boolean isQtyAsst = partner.getParmQtyAsst();
        if (partner.getAccountViewInfo().isIsQty() && !isQtyAsst) {
            isShowQuantity = true;
        } else if (partner.getAccountViewInfo().isIsQty() && isQtyAsst) {
            if (partner.getAccountViewInfo().getCAA() != null) {
                IAsstAccount iasstAccount = AsstAccountFactory.getLocalInstance((Context)partner.getContext());
                AsstAccountInfo actaccount = iasstAccount.getAsstAccountInfo((IObjectPK)new ObjectUuidPK(partner.getAccountViewInfo().getCAA().getId().toString()));
                if (actaccount.isIsQty()) {
                    isShowQuantity = true;
                }
            } else {
                isShowQuantity = true;
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(fcreatetime,FDate, FBizDate,FVoucherNumber,FVoucherTypeNumber ,FVoucherTypeName ,  FDescription, \r\n");
        if (partner.getAccountViewInfo().isAC() || partner.getAccountViewInfo().isIsBank()) {
            sql.append(" FSettlementType,FSettlementCode,FBizNumber, \r\n");
        }
        sql.append("\t FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FLocalRate,FRptRate, \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt, \r\n");
        if (isShowQuantity) {
            sql.append(" FDebitUnitId,FCreditUnitId, \r\n");
            sql.append(" FDebitQty,FCreditQty,\r\n");
            sql.append(" FDebitQtyDefault,FCreditQtyDefault, \r\n");
            sql.append(" FDebitPrice,FCreditPrice, \r\n");
        }
        if (isShowQuantity && this.getPar(partner) && condition.getOptionOnlyAsst()) {
            sql.append(" FDebitAssistUnit,\r\n");
            sql.append(" FCreditAssistUnit ,\r\n");
            sql.append(" FDebitAssistPrice , \r\n");
            sql.append(" FCreditAssistPrice, \r\n");
            sql.append(" FDebitAssistQty , \r\n");
            sql.append(" FCreditAssistQty , \r\n");
        }
        sql.append("\tFBalanceUnitId,FLineType,FVoucherID, FPeriodYear, FPeriodNumber,FSeq) \r\n");
        sql.append("SELECT TV.fcreatetime,TV.FBookedDate,");
        if (condition.getOptionOnlyAsst()) {
            sql.append("TVAR.FBizDate,");
        } else {
            sql.append("TV.FBizDate,");
        }
        sql.append("TV.FNumber,TVT.fnumber,TVT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(" , \r\n");
        sql.append("(CASE WHEN TVAR.FDescription is not null THEN TVAR.FDescription ELSE TVE.FDescription END ) FDescription, \r\n");
        if (partner.getAccountViewInfo().isAC() || partner.getAccountViewInfo().isIsBank()) {
            sql.append("\tTST.FName");
            sql.append(partner.getFieldNameExtend());
            sql.append(" FSettlementType,");
            sql.append(" TVAR.FSettlementCode,");
            sql.append(" TVAR.FBizNumber, \r\n");
        }
        if (partner.getCurrencyType() == 1) {
            this.addDebitCreditFieldSQL(sql, "TVAR.FLocalAmount", "0", "For");
        } else if (partner.getCurrencyType() == 2) {
            this.addDebitCreditFieldSQL(sql, "TVAR.FReportingAmount", "0", "For");
        } else {
            this.addDebitCreditFieldSQL(sql, "TVAR.FOriginalAmount", "0", "For");
        }
        sql.append(" TVE.FLocalExchangeRate FLocalRate,\r\n");
        sql.append(" TVE.FReportingExchangeRate FRptRate,\r\n");
        this.addDebitCreditFieldSQL(sql, "TVAR.FLocalAmount", "0", "Local");
        this.addDebitCreditFieldSQL(sql, "TVAR.FReportingAmount", "0", "Rpt");
        if (isShowQuantity) {
            this.addDebitCreditFieldSQL(sql, "TVAR.FMeasureUnitID", "NULL", "UnitId");
            this.addDebitCreditFieldSQL(sql, "TVAR.FQuantity", "0", "Qty");
            this.addDebitCreditFieldSQL(sql, "TVAR.FStandardQuantity", "0", "QtyDefault");
            this.addDebitCreditFieldSQL(sql, "TVAR.FPrice", "NULL", "Price");
            if (condition.getOptionOnlyAsst() && this.getPar(partner)) {
                this.addDebitCreditFieldSQL(sql, "MUI.fname_l2", "NULL", "AssistUnit");
                this.addDebitCreditFieldSQL(sql, "TVAR.FAssistPrice", "0", "AssistPrice");
                this.addDebitCreditFieldSQL(sql, "TVAR.FAssistQty", "0", "AssistQty");
            }
        }
        if (partner.getAccountViewInfo().isIsQty()) {
            sql.append("(CASE WHEN MUG.fdefaultunitid IS NOT NULL THEN MUG.fdefaultunitid ELSE AV.FMeasureUnitID END ) FBalanceUnitId, \r\n");
        } else {
            sql.append("(CASE WHEN MUG.fdefaultunitid IS NOT NULL THEN MUG.fdefaultunitid ELSE TVAR.FMeasureUnitID END ) FBalanceUnitId, \r\n");
        }
        sql.append("\t0 FLineType,TV.FID FVoucherID, \r\n");
        sql.append("\tTP.FPeriodYear  FPeriodYear,TP.FPeriodNumber FPeriodNumber ,TVE.FSeq FSeq\r\n");
        sql.append("FROM T_GL_Voucher TV \r\n");
        sql.append("\tINNER JOIN T_BD_VoucherTypes TVT \r\n ");
        sql.append("\tON TV.FVoucherTypeID = TVT.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherEntry TVE \r\n");
        sql.append("\tON TV.FID = TVE.FBillID \r\n");
        sql.append("\tINNER JOIN T_BD_Period TP \r\n");
        sql.append("\tON TV.FPeriodID = TP.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherAssistRecord TVAR  \r\n");
        sql.append("\tON TVE.FID = TVAR.FentryID \r\n");
        sql.append("\tINNER JOIN T_BD_AssistantHG HG \r\n");
        sql.append("\tON TVAR.FAssGrpID = HG.FID \r\n");
        if (partner.getAccountViewInfo().isAC() || partner.getAccountViewInfo().isIsBank()) {
            sql.append("\tLEFT OUTER JOIN T_BD_SettlementType TST  \r\n");
            sql.append("\tON TST.FID = TVAR.FSettlementTypeID \r\n");
        }
        sql.append("\tINNER JOIN T_BD_AccountView AV \r\n");
        sql.append("\tON TVE.FAccountID =AV.FID \r\n");
        sql.append("\tLEFT JOIN t_bd_measureunitgroup MUG ON AV.FMeasureUnitGroupID=MUG.fid \r\n");
        if (isShowQuantity && condition.getOptionOnlyAsst() && this.getPar(partner)) {
            sql.append("\tLEFT JOIN t_bd_measureunit MUI ON TVAR.FAssistUnit=MUI.fid \r\n");
        }
        sql.append("WHERE TV.FCompanyID = '").append(partner.getCompanyId()).append("' AND \r\n");
        if (condition.getOptionPosting()) {
            sql.append("\t(TV.FBizStatus = ");
            sql.append(1);
            sql.append(" OR TV.FBizStatus = ");
            sql.append(3);
            sql.append(" OR TV.FBizStatus = ");
            sql.append(5);
            sql.append(" ) AND \r\n");
        } else {
            sql.append("\tTV.FBizStatus = ");
            sql.append(5);
            sql.append(" AND \r\n");
        }
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sql.append("\tTVE.FAccountID = '");
            sql.append(partner.getAccountViewInfo().getId().toString());
            sql.append("' AND \r\n");
        } else {
            sql.append("\tTVE.FAccountID IN (");
            sql.append(this.getChildAccountIds(partner, partner.getAccountViewInfo()));
            sql.append(") AND \r\n");
        }
        if (partner.getCurrencyType() == 0) {
            sql.append("\tTVE.FCurrencyID = '").append(condition.getCurrencyID()).append("' AND \r\n");
        }
        int[] periodRange = new int[]{condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()};
        sql.append(SQLUtil.getPeriodCondition("TP.FPeriodYear", "TP.FPeriodNumber", periodRange));
        sql.append(" and TP.FTypeID = '").append(partner.getCompany().getAccountPeriodType().getId().toString()).append("' AND \r\n");
        sql.append("\tHG.");
        sql.append(partner.getAsstActTypeInfo().getMappingFieldName());
        sql.append(" in ('" + condition.getAssistItemId() + "') \r\n");
        if (asstAccountId != null) {
            sql.append(" and HG.FAsstAccountID = '" + asstAccountId + "' \n");
        }
        this.execute(partner.getContext(), sql.toString());
    }

    @Override
    protected boolean isAfterPeriod(ReportPartner partner) throws EASBizException, BOSException {
        Context ctx = partner.getContext();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()));
        int curPeriod = currentPeriod.getNumber();
        ReportConditionBase condition = partner.getFixCondition();
        int peroidYeayStart = condition.getPeriodYearStart();
        int peroidNumber = condition.getPeriodNumberStart();
        return curPeriod < peroidYeayStart * 100 + peroidNumber;
    }
}

