/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.GLSmartEditResourceConstant;
import com.kingdee.eas.fi.gl.app.AbstractGLSmartEngineFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLSmartActionFactory;
import com.kingdee.eas.fi.gl.app.GLSmartTextAnalysisUtils;
import com.kingdee.eas.fi.gl.app.ISmartAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLSmartEngineFacadeControllerBean
extends AbstractGLSmartEngineFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLSmartEngineFacadeControllerBean");
    private ISmartAction smartActionService = null;

    @Override
    protected Map _smartTextAnalysis(Context ctx, Map param) throws BOSException {
        Map<String, String> retMap = new HashMap<String, String>();
        try {
            String commandText = (String)param.get("commanText");
            String function = (String)param.get("function");
            this.smartActionService = GLSmartActionFactory.getInstance(function);
            commandText = commandText.replace(";", "").replace("\uff1b", "");
            retMap = this.commandWordMatch(commandText, function);
            retMap.put("flag", "success");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            retMap.put("flag", "fail");
            retMap.put("error", "fail:\n" + e.getMessage());
        }
        return retMap;
    }

    protected Map commandWordMatch(String commonText, String function) {
        HashMap<String, Object> srcOperObject = new HashMap<String, Object>();
        srcOperObject.put("rowTarget", null);
        srcOperObject.put("columnTarget", null);
        HashMap<String, Object> targetOperObject = new HashMap<String, Object>();
        targetOperObject.put("rowTarget", null);
        targetOperObject.put("columnTarget", null);
        ArrayList<String> targetValues = new ArrayList<String>();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("srcOperObject", srcOperObject);
        retMap.put("targetOperObject", targetOperObject);
        List<String> columns = new ArrayList<String>();
        String error = null;
        String action = GLSmartTextAnalysisUtils.actionMatch(commonText);
        List<String> target = null;
        if (action.equals("add")) {
            this.actionAdd(commonText, target, targetValues, targetOperObject, retMap);
        } else if (action.equals("edit")) {
            this.actionEdit(commonText, target, targetValues, targetOperObject, columns, retMap);
        } else if (action.equals("copy")) {
            this.actionCopy(commonText, target, targetValues, targetOperObject, retMap);
        } else if (action.equals("replace")) {
            this.actionReplace(commonText, target, targetValues, targetOperObject, columns, retMap);
        } else if (action.equals("delete")) {
            this.deleteFunction(commonText, target, targetValues, targetOperObject, columns, retMap);
        } else if (action.equals("function")) {
            this.actionFunction(commonText, target, targetValues, retMap);
        } else if (action.equals("query")) {
            // empty if block
        }
        List<Object> list = columns = targetOperObject.get("columnTarget") == null ? new ArrayList() : (List)targetOperObject.get("columnTarget");
        if (retMap.get("action") == null) {
            error = GLSmartEditResourceConstant.NOT_SUPPORT;
            retMap.put("error", error);
        } else if (columns.size() == 0 && !retMap.get("action").toString().equals("delete")) {
            error = GLSmartEditResourceConstant.TEXT_ANALY_ERROR;
            retMap.put("error", error);
        }
        return retMap;
    }

    protected JSONObject baiduSmartWordAnalysis(Map param) {
        return null;
    }

    protected void actionAdd(String commonText, List<String> target, List<String> targetValues, Map<String, Object> targetOperObject, Map<String, Object> retMap) {
        this.smartActionService.actionAdd(commonText, target, targetValues, targetOperObject, retMap);
    }

    protected void actionEdit(String commonText, List<String> target, List<String> targetValues, Map<String, Object> targetOperObject, List<String> columns, Map<String, Object> retMap) {
        this.smartActionService.actionEdit(commonText, target, targetValues, targetOperObject, columns, retMap);
    }

    protected void actionCopy(String commonText, List<String> target, List<String> targetValues, Map<String, Object> targetOperObject, Map<String, Object> retMap) {
        this.smartActionService.actionCopy(commonText, target, targetValues, targetOperObject, retMap);
    }

    protected void actionReplace(String commonText, List<String> target, List<String> targetValues, Map<String, Object> targetOperObject, List<String> columns, Map<String, Object> retMap) {
        this.smartActionService.actionReplace(commonText, target, targetValues, targetOperObject, columns, retMap);
    }

    protected void deleteFunction(String commonText, List<String> target, List<String> targetValues, Map<String, Object> targetOperObject, List<String> columns, Map<String, Object> retMap) {
        this.smartActionService.deleteFunction(commonText, target, targetValues, targetOperObject, columns, retMap);
    }

    protected void actionFunction(String commonText, List<String> target, List<String> targetValues, Map<String, Object> retMap) {
        if (commonText.contains("\u4fdd\u5b58")) {
            targetValues.add("save");
        } else if (commonText.contains("\u63d0\u4ea4")) {
            targetValues.add("submit");
        } else if (commonText.contains("\u5ba1\u6838")) {
            targetValues.add("audit");
        } else if (commonText.contains("\u8fc7\u8d26")) {
            targetValues.add("post");
        }
        retMap.put("targetValues", targetValues);
        retMap.put("action", "function");
    }
}

