/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GLTempTableUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLTempTableUtil");
    public static final String TTB_PREFIX = "GLT";
    private static Map<String, List<String>> sysTmpTableNames = new ConcurrentHashMap<String, List<String>>();
    private static ThreadLocal<Map> ctxThreadLocal = new ThreadLocal<Map>(){

        @Override
        protected Map initialValue() {
            return new HashMap();
        }
    };

    public static String createTempTable(Context ctx, String struct) throws BOSException {
        String createTableSql = "create table gl_temp_table (" + struct + ")";
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    public static String createDBSysTempTable(Context ctx, String struct) throws BOSException {
        return GLTempTableUtil.createDBSysTempTable(ctx, struct, null);
    }

    public static String createDBSysTempTable(Context ctx, String struct, String indexColNames) throws BOSException {
        String string;
        String tableName = null;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            ArrayList<String> tableNames;
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            if (GLTempTableUtil.isOracle(dbType) && !GLTempTableUtil.isDebug()) {
                ArrayList<String> sysTempTables;
                tableNames = sysTmpTableNames.get(struct);
                if (tableNames == null) {
                    tableNames = new ArrayList<String>();
                    sysTmpTableNames.put(struct, tableNames);
                }
                for (int i = 0; i < tableNames.size(); ++i) {
                    String tbName = (String)tableNames.get(i);
                    st = conn.createStatement();
                    rs = st.executeQuery("select 1 from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='" + tbName + "'");
                    if (rs.next()) {
                        if (GLTempTableUtil.containsDBSysTempTable(tbName)) continue;
                        tableName = tbName;
                        break;
                    }
                    tableNames.remove(i--);
                }
                if (tableName == null) {
                    Method method = GLTempTableUtil.class.getMethod("createOracleSysTmpTable", Context.class, String.class);
                    EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(null);
                    tableName = (String)txInvoker.invoke(method, new Object[]{ctx, struct}, 4);
                    tableNames.add(tableName);
                }
                if ((sysTempTables = (ArrayList<String>)ctxThreadLocal.get().get("sysTempTables")) == null) {
                    sysTempTables = new ArrayList<String>();
                    ctxThreadLocal.get().put("sysTempTables", sysTempTables);
                }
                sysTempTables.add(tableName);
            } else {
                tableName = GLTempTableUtil.createTempTable(ctx, struct);
                tableNames = (ArrayList<String>)ctxThreadLocal.get().get("tempTableName");
                if (tableNames == null) {
                    tableNames = new ArrayList();
                    ctxThreadLocal.get().put("tempTableName", tableNames);
                }
                tableNames.add(tableName);
                if (!StringUtils.isEmpty((String)indexColNames)) {
                    TempTablePool.getInstance((Context)ctx).createIndex(tableName, indexColNames, false, false);
                }
            }
            string = tableName;
        }
        catch (Throwable e) {
            try {
                throw new BOSException("create database system tempTable error!", e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)st, (Connection)conn);
        return string;
    }

    private static boolean containsDBSysTempTable(String tableName) {
        List tableNames = (List)ctxThreadLocal.get().get("sysTempTables");
        if (tableNames != null) {
            return tableNames.contains(tableName);
        }
        return false;
    }

    public static String createOracleSysTmpTable(Context ctx, String struct) throws BOSException {
        String string;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String tableName = new UUTN(false, TTB_PREFIX).toString();
            String createTableSql = TransUtil.Translate((String)("create table " + tableName + " (" + struct + ")"), (int)KSqlUtil.getDbType((Connection)conn)).trim();
            if (createTableSql.endsWith("NOLOGGING")) {
                createTableSql = createTableSql.substring(0, createTableSql.length() - 9);
            }
            createTableSql = createTableSql.replaceFirst("CREATE TABLE", "CREATE GLOBAL TEMPORARY TABLE");
            createTableSql = "/*dialect*/" + createTableSql + " ON COMMIT DELETE ROWS";
            stmt = conn.createStatement();
            stmt.execute(createTableSql);
            string = tableName;
        }
        catch (Exception e) {
            try {
                throw new BOSException("create database system tempTable error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return string;
    }

    public static void createOracleSysTmpTableIndex(Context ctx, String tableName, String indexColNames) throws BOSException {
        if (StringUtils.isEmpty((String)indexColNames)) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.execute("/*dialect*/CREATE INDEX " + GLTempTableUtil.createIndexName() + " ON " + tableName + " (" + indexColNames + ")");
        }
        catch (Exception e) {
            try {
                throw new BOSException("create database system tempTable index error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private static String createIndexName() {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 17);
        return "I" + name;
    }

    public static void dropTempTable(Context ctx, String tableName) {
        if (tableName == null) {
            return;
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
        catch (Exception e) {
            logger.error((Object)"Release tempTable error!", (Throwable)e);
        }
    }

    public static void dropDBSysTempTable(Context ctx) {
        List tempTables = (List)ctxThreadLocal.get().get("tempTableName");
        if (tempTables != null) {
            Iterator it = tempTables.iterator();
            while (it.hasNext()) {
                GLTempTableUtil.dropDBSysTempTable(ctx, (String)it.next());
            }
        }
        GLTempTableUtil.clearContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropDBSysTempTable(Context ctx, String tableName) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!GLTempTableUtil.isOracle(conn)) {
                if (!GLTempTableUtil.isDebug()) {
                    GLTempTableUtil.dropTempTable(ctx, tableName);
                }
            } else {
                TempTablePool.getInstance((Context)ctx).releaseDBSystemTempTable(tableName, conn);
            }
        }
        catch (Exception e) {
            logger.error((Object)"release database sytem tempTable error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void setContextObject(Object key, Object value) {
        ctxThreadLocal.get().put(key, value);
    }

    public static Object getContextObject(Object key) {
        return ctxThreadLocal.get().get(key);
    }

    public static void setTransactionRequired(boolean isRequried) {
        ctxThreadLocal.get().put("requried", isRequried);
    }

    public static boolean isTransactionRequired() {
        Object requried = ctxThreadLocal.get().get("requried");
        return requried != null && (Boolean)requried != false;
    }

    public static List<String> getTempTables() {
        if (GLTempTableUtil.isDebug()) {
            List tempTables = (List)ctxThreadLocal.get().get("tempTableName");
            return tempTables;
        }
        return null;
    }

    public static void setCondition(GLRptBaseCondition condition) {
        ctxThreadLocal.get().put("condition", condition);
    }

    public static GLRptBaseCondition getCondition() {
        return (GLRptBaseCondition)ctxThreadLocal.get().get("condition");
    }

    public static boolean isDebug() {
        GLRptBaseCondition condition = GLTempTableUtil.getCondition();
        if (condition != null) {
            String debug = condition.getExtendParam("Debug");
            return debug != null && "true".equalsIgnoreCase(debug.trim());
        }
        return false;
    }

    public static void clearContext() {
        ctxThreadLocal.remove();
    }

    public static boolean isOracle(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            boolean bl = GLTempTableUtil.isOracle(conn);
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    public static boolean isOracle(Connection conn) {
        try {
            int dbType = KSqlUtil.getDbType((Connection)conn);
            return GLTempTableUtil.isOracle(dbType);
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
            return false;
        }
    }

    private static boolean isOracle(int dbType) {
        return (2 == dbType || 8 == dbType || 7 == dbType) && GLTempTableUtil.isTransactionRequired();
    }

    public static Map<String, String> getDataTypes(Context ctx, String function, String tableName) throws BOSException {
        HashMap<String, String> dataTypes = new HashMap<String, String>();
        if (function != null && tableName != null) {
            function = function.trim();
            tableName = tableName.trim();
            if (function.length() > 0 && tableName.length() > 0) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FFieldName, FDataType from T_GL_TempTableDefine where FFunction = ? and FTableName = ?", (Object[])new String[]{function, tableName});
                try {
                    while (rs.next()) {
                        String fieldName = rs.getString("FFieldName");
                        if (fieldName == null || fieldName.trim().length() <= 0) continue;
                        dataTypes.put(fieldName.trim().toUpperCase(), rs.getString("FDataType"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return dataTypes;
    }

    public static String getDataType(String fieldName, Map<String, String> dataTypes, String defaultDataType) {
        String dataType;
        if (fieldName != null && fieldName.trim().length() > 0 && (dataType = dataTypes.get((fieldName = fieldName.trim()).toUpperCase())) != null && dataType.trim().length() > 0) {
            return fieldName + " " + dataType.trim();
        }
        return fieldName + " " + defaultDataType;
    }

    public static String FieldDef(String fieldName, Map<String, String> dataTypes, String defaultDataType) {
        String dataType;
        if (fieldName != null && fieldName.trim().length() > 0 && (dataType = dataTypes.get((fieldName = fieldName.trim()).toUpperCase())) != null && dataType.trim().length() > 0) {
            return dataType.trim();
        }
        return defaultDataType;
    }

    public static String getDataTypeWithoutFieldName(String fieldName, Map<String, String> dataTypes, String defaultDataType) {
        String dataType;
        if (fieldName != null && fieldName.trim().length() > 0 && (dataType = dataTypes.get((fieldName = fieldName.trim()).toUpperCase())) != null && dataType.trim().length() > 0) {
            return dataType.trim();
        }
        return defaultDataType;
    }
}

