/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GetAsstActTypeService {
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    protected Map params = null;
    protected HashMap<String, Object> result = null;
    protected List<String> errs = null;
    protected List rows = null;

    /*
     * Unable to fully structure code
     */
    public Map getAsstActTypes(Context ctx, Map params) throws EASBizException, BOSException {
        this.init(ctx, params);
        if (!this.checkUsePermission(ctx, params)) {
            return this.result;
        }
        aa = null;
        asstAccountNumber = (String)params.get("asstAccountNumber");
        if (asstAccountNumber != null && asstAccountNumber.trim().length() > 0) {
            aa = this.getAsstAccount(ctx, asstAccountNumber = asstAccountNumber.trim());
            if (aa == null) {
                this.appendErr("asstAccountNumber", asstAccountNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"AsstAccount_NotFound", (Locale)ctx.getLocale()));
                return this.result;
            }
            this.doGetAsstActTypes(ctx, aa);
            return this.result;
        }
        accountNumber = (String)params.get("accountNumber");
        if (accountNumber != null && accountNumber.trim().length() > 0) {
            company = null;
            companyNumber = (String)params.get("companyNumber");
            if (companyNumber != null && companyNumber.trim().length() > 0 && (company = this.getCompany(ctx, companyNumber = companyNumber.trim())) == null) {
                this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"companyNotFound", (Locale)ctx.getLocale()));
                return this.result;
            }
            if (company == null) {
                company = this.getCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getNumber());
            }
            if (company.getAccountTable() == null) {
                this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"noSetAccountTable", (Locale)ctx.getLocale()));
                return this.result;
            }
            account = this.getAccount(ctx, company, accountNumber = accountNumber.trim());
            if (account == null) {
                this.appendErr("accountNumber", accountNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"account_notFound", (Locale)ctx.getLocale()));
                return this.result;
            }
            if (!company.isIsBizUnit() || !account.isIsLeaf()) {
                aa = account.getCAA();
            } else {
                periodNumber = (String)params.get("periodNumber");
                if (periodNumber != null && periodNumber.trim().length() > 0) {
                    periodNumber = periodNumber.trim();
                    try {
                        pn = Integer.parseInt(periodNumber);
                        if (pn <= 198000 || pn > 209913) {
                            this.appendErr("periodNumber", periodNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"periodSetError", (Locale)ctx.getLocale()));
                            return this.result;
                        }
                        aaId = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAIdByPeriod(account.getId().toString(), pn);
                        if (aaId == null) ** GOTO lbl58
                        aa = new AsstAccountInfo();
                        aa.setId(BOSUuid.read((String)aaId));
                    }
                    catch (Exception e) {
                        this.appendErr("periodNumber", periodNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"periodSetError", (Locale)ctx.getLocale()));
                        return this.result;
                    }
                } else {
                    current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(company.getId()));
                    if (current == null) {
                        aa = account.getCAA();
                    } else {
                        aaId = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAIdByPeriod(account.getId().toString(), current.getNumber());
                        if (aaId != null) {
                            aa = new AsstAccountInfo();
                            aa.setId(BOSUuid.read((String)aaId));
                        }
                    }
                }
            }
        } else {
            this.appendErr("asstAccountNumber", asstAccountNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"NeedAsstAccount_FoundEmpty", (Locale)ctx.getLocale()));
        }
lbl58:
        // 6 sources

        if (aa != null) {
            this.doGetAsstActTypes(ctx, aa);
        }
        return this.result;
    }

    protected boolean checkUsePermission(Context ctx, Map params) throws EASBizException, BOSException {
        boolean isInterfaceInvoke = (Boolean)params.get("isInterfaceInvoke");
        if (isInterfaceInvoke) {
            boolean r;
            boolean isCheckUsePerm = false;
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcUsePerm_Enable");
                if (p != null && Boolean.valueOf(p.toString()).booleanValue()) {
                    isCheckUsePerm = true;
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (isCheckUsePerm && !(r = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), null, "gl_ifc_baseData"))) {
                this.appendErr("", "", MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"NO_IfcBaseData_UsePerm", (Locale)ctx.getLocale()), ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()));
                return false;
            }
        }
        return true;
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    public void init(Context ctx, Map params) throws EASBizException, BOSException {
        this.params = params;
        this.result = new HashMap();
        this.errs = new ArrayList<String>();
        this.rows = new LinkedList();
        this.result.put("errs", this.errs);
        this.result.put("rows", this.rows);
    }

    protected AsstAccountInfo getAsstAccount(Context ctx, String number) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        AsstAccountCollection coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)number));
        view.setFilter(filter);
        coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)number));
        view.setFilter(filter);
        coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    protected CompanyOrgUnitInfo getCompany(Context ctx, String companyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isBizUnit");
        selector.add("accountTable.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        view.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (companys != null && companys.size() > 0) {
            return companys.get(0);
        }
        return null;
    }

    protected AccountViewInfo getAccount(Context ctx, CompanyOrgUnitInfo company, String accountNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isLeaf");
        selector.add("CAA.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
        view.setFilter(filter);
        AccountViewCollection accounts = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (accounts != null && accounts.size() > 0) {
            return accounts.get(0);
        }
        return null;
    }

    protected void doGetAsstActTypes(Context ctx, AsstAccountInfo aa) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        sic.add(new SelectorItemInfo("asstActType.isQty"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.number"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.name"));
        sic.add(new SelectorItemInfo("asstActType.measureUnit.id"));
        sic.add(new SelectorItemInfo("asstActType.measureUnit.number"));
        sic.add(new SelectorItemInfo("asstActType.measureUnit.name"));
        sic.add(new SelectorItemInfo("asstActType.company.id"));
        sic.add(new SelectorItemInfo("asstActType.company.number"));
        sic.add(new SelectorItemInfo("asstActType.company.name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)aa.getId().toString()));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        for (int i = 0; i < asstcol.size(); ++i) {
            CompanyOrgUnitInfo company;
            MeasureUnitInfo mu;
            AsstActTypeInfo aat = asstcol.get(i).getAsstActType();
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aat.getId().toString());
            row.put("number", aat.getNumber());
            row.put("name", aat.getName());
            row.put("isMultilevel", String.valueOf(aat.isIsMultilevel()));
            row.put("useLongNumber", String.valueOf(aat.isUseLongNumber()));
            row.put("isQty", String.valueOf(aat.isIsQty()));
            row.put("asstHGAttribute", aat.getAsstHGAttribute());
            row.put("realtionDataObject", aat.getRealtionDataObject());
            row.put("mappingFieldName", aat.getMappingFieldName());
            row.put("groupTableName", aat.getGroupTableName());
            row.put("groupMappingFieldName", aat.getGroupMappingFieldName());
            GeneralAsstActTypeGroupInfo ga = aat.getGlAsstActTypeGrp();
            if (ga != null) {
                row.put("glAsstActTypeGrp.id", ga.getId().toString());
                row.put("glAsstActTypeGrp.number", ga.getNumber());
                row.put("glAsstActTypeGrp.name", ga.getName());
            }
            if ((mu = aat.getMeasureUnit()) != null) {
                row.put("measureUnit.id", mu.getId().toString());
                row.put("measureUnit.number", mu.getNumber());
                row.put("measureUnit.name", mu.getName());
            }
            if ((company = aat.getCompany()) != null) {
                row.put("company.id", company.getId().toString());
                row.put("company.number", company.getNumber());
                row.put("company.name", company.getName());
            }
            this.rows.add(row);
        }
    }
}

