/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.eas.fi.gl.common.GLResUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ImplementBuilder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.ImplementBuilder");
    private String implementInterface;
    private String extendsClass;
    private String outputClass;
    private String proxyObject;
    private String proxyVar;
    private List attributes = new ArrayList();

    public void reset() {
        this.attributes.clear();
        this.extendsClass = null;
    }

    public void addAttributeDefine(String defineString) {
        this.attributes.add(defineString);
    }

    public void setImplementInterface(String implementInterface) {
        this.implementInterface = implementInterface;
    }

    public void setExtendsClass(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public void setProxyObject(String proxyObject, String proxyVar) {
        this.proxyObject = proxyObject;
        this.proxyVar = proxyVar;
    }

    public void build() throws Exception {
        this.build(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(boolean force) throws Exception {
        String filename = this.getOutputFilename();
        if (new File(filename).exists() && !force) {
            logger.debug((Object)(GLResUtil.getRes("file_create_faild") + "\"" + filename + "\" " + GLResUtil.getRes("for_exist_delOrUse_ahead") + "force=true" + GLResUtil.getRes("params")));
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildHeader());
        sb.append(this.buildAttributes());
        sb.append(this.buildConstructor());
        Method[] mm = Class.forName(this.implementInterface).getMethods();
        for (int i = 0; i < mm.length; ++i) {
            sb.append(this.buildMethod(mm[i]));
        }
        sb.append(this.buildFooter());
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            bw.write(sb.toString());
            bw.flush();
            logger.debug((Object)("[" + GLResUtil.getRes("out_impl_file") + "] " + filename));
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String buildAttributes() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.attributes.size(); ++i) {
            sb.append("\t").append(this.attributes.get(i)).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private String buildMethod(Method mm) {
        int i;
        StringBuffer sb = new StringBuffer();
        String name = mm.getName();
        int modifier = mm.getModifiers();
        Class<?> returnType = mm.getReturnType();
        Class<?>[] params = mm.getParameterTypes();
        Class<?>[] exceptionTypes = mm.getExceptionTypes();
        sb.append("\r\n\r\n\t").append("public ");
        if (returnType.isArray()) {
            sb.append(this.getTrimClassName(returnType.getComponentType())).append("[]");
        } else {
            sb.append(this.getTrimClassName(returnType));
        }
        sb.append(" ").append(name);
        sb.append("(");
        for (i = 0; i < params.length; ++i) {
            if (params[i].isArray()) {
                sb.append(this.getTrimClassName(params[i].getComponentType())).append("[]");
            } else {
                sb.append(this.getTrimClassName(params[i]));
            }
            sb.append(" p").append(i);
            if (i == params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (exceptionTypes.length > 0) {
            sb.append(" throws ");
            for (i = 0; i < exceptionTypes.length; ++i) {
                sb.append(this.getTrimClassName(exceptionTypes[i]));
                if (i == exceptionTypes.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("{\r\n");
        sb.append("\t\t");
        if (!"void".equals(returnType.getName())) {
            sb.append("return ");
        }
        sb.append("this.").append(this.proxyVar).append(".").append(name);
        sb.append("(");
        for (i = 0; i < params.length; ++i) {
            sb.append("p").append(i);
            if (i == params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(");\r\n\t}");
        return sb.toString();
    }

    private String getTrimClassName(Class cc) {
        String buf = cc.getName();
        if (buf.startsWith("java.lang.")) {
            return buf.substring("java.lang.".length());
        }
        return buf;
    }

    private String buildConstructor() {
        StringBuffer constructor = new StringBuffer();
        constructor.append("\tpublic ").append(this.getClassName()).append("(").append(this.implementInterface).append(" ").append(this.proxyVar).append("){\r\n").append("\t\tthis.").append(this.proxyVar).append("=").append(this.proxyVar).append(";\r\n\t}\r\n");
        return constructor.toString();
    }

    private String buildHeader() {
        StringBuffer header = new StringBuffer();
        String packageName = this.getPackageName();
        if (packageName != null) {
            header.append("package ").append(packageName).append(";\r\n\r\n");
        }
        header.append("public class ").append(this.getClassName());
        if (this.extendsClass != null) {
            header.append(" extends ").append(this.extendsClass);
        }
        header.append(" implements ").append(this.implementInterface);
        header.append("{\r\n\r\n");
        header.append("\tprivate ").append(this.proxyObject).append(" ").append(this.proxyVar).append("=null;\r\n\r\n");
        return header.toString();
    }

    private String buildFooter() {
        return "\r\n\r\n}";
    }

    private String getOutputFilename() {
        String filename = this.outputClass.replace('.', '/');
        return (new File("").getAbsolutePath() + "/" + filename + ".java").replace('\\', '/');
    }

    private String getClassName() {
        int dotIndex = this.outputClass.lastIndexOf(46);
        if (dotIndex >= 0) {
            return this.outputClass.substring(dotIndex + 1);
        }
        return this.outputClass;
    }

    private String getPackageName() {
        int dotIndex = this.outputClass.lastIndexOf(46);
        if (dotIndex >= 0) {
            return this.outputClass.substring(0, dotIndex);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            ImplementBuilder ib = new ImplementBuilder();
            ib.reset();
            ib.setOutputClass("com.kingdee.eas.fi.gl.app.TraceConnection");
            ib.setExtendsClass("com.kingdee.eas.fi.gl.app.TraceAncestor");
            ib.setImplementInterface("java.sql.Connection");
            ib.setProxyObject("java.sql.Connection", "con");
            ib.build();
            ib.reset();
            ib.setOutputClass("com.kingdee.eas.fi.gl.app.TraceStatement");
            ib.setExtendsClass("com.kingdee.eas.fi.gl.app.TraceAncestor");
            ib.setImplementInterface("java.sql.Statement");
            ib.setProxyObject("java.sql.Statement", "stmt");
            ib.build();
            ib.reset();
            ib.setOutputClass("com.kingdee.eas.fi.gl.app.TracePreparedStatement");
            ib.setExtendsClass("com.kingdee.eas.fi.gl.app.TraceAncestor");
            ib.setImplementInterface("java.sql.PreparedStatement");
            ib.setProxyObject("java.sql.PreparedStatement", "rs");
            ib.build();
            ib.reset();
            ib.setOutputClass("com.kingdee.eas.fi.gl.app.TraceCallableStatement");
            ib.setExtendsClass("com.kingdee.eas.fi.gl.app.TraceAncestor");
            ib.setImplementInterface("java.sql.CallableStatement");
            ib.setProxyObject("java.sql.CallableStatement", "rs");
            ib.build();
            ib.reset();
            ib.setOutputClass("com.kingdee.eas.fi.gl.app.TraceResultSet");
            ib.setExtendsClass("com.kingdee.eas.fi.gl.app.TraceAncestor");
            ib.setImplementInterface("java.sql.ResultSet");
            ib.setProxyObject("java.sql.ResultSet", "rs");
            ib.build();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

