/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistInitFacade;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractInitAssistBalanceControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class InitAssistBalanceControllerBean
extends AbstractInitAssistBalanceControllerBean {
    private static final long serialVersionUID = -213276291558569084L;

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InitAssistBalanceInfo info = (InitAssistBalanceInfo)model;
        if (!info.isFromExcel()) {
            IObjectPK pk = super._addnew(ctx, model);
            return pk;
        }
        info.put("persist_status", "new");
        IAssistInitFacade assistInitFacade = AssistInitFacadeFactory.getLocalInstance(ctx);
        InitAssistBalanceCollection col = new InitAssistBalanceCollection();
        info.setFromExcel(false);
        col.add(info);
        HashMap<String, Boolean> otherCtx = new HashMap<String, Boolean>();
        otherCtx.put("ISUSEREPORT", Boolean.TRUE);
        otherCtx.put("COMPANY", (Boolean)ContextUtil.getCurrentFIUnit((Context)ctx));
        assistInitFacade.save(col, otherCtx);
        return null;
    }

    @Override
    protected IRowSet _getSum(Context ctx, String[] fieldInfo, String companyId, String accountId, String currencyId, String caaId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        int length = fieldInfo.length - 1;
        for (int i = 0; i < length; ++i) {
            sql.append("SUM(INITASSISTBALANCE.F").append(fieldInfo[i]).append(")   AS ").append(fieldInfo[i]).append(",");
        }
        sql.append("SUM(INITASSISTBALANCE.F").append(fieldInfo[fieldInfo.length - 1]).append(")   AS ").append(fieldInfo[fieldInfo.length - 1]);
        sql.append(" FROM T_GL_InitAssistBalance AS INITASSISTBALANCE");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNT");
        sql.append(" ON INITASSISTBALANCE.FAccountID = ACCOUNT.FID");
        if (!StringUtils.isEmpty((String)caaId)) {
            sql.append(" left join t_bd_assistantHg hg on hg.fid = INITASSISTBALANCE.FAssistGrpID ");
        }
        sql.append(" WHERE INITASSISTBALANCE.FOrgUnitID = '").append(companyId).append("'");
        if (StringUtils.isEmpty((String)currencyId)) {
            currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        }
        sql.append(" AND INITASSISTBALANCE.FCurrencyID ='" + currencyId + "'");
        if (!StringUtils.isEmpty((String)accountId)) {
            sql.append(" AND INITASSISTBALANCE.FAccountID = '").append(accountId).append("'");
        }
        if (!StringUtils.isEmpty((String)caaId)) {
            sql.append(" AND hg.fasstaccountid = '").append(caaId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected AsstAccountCollection sorterAsstAccount(Object[] obj) {
        int size = obj.length;
        AsstAccountCollection allAsstAccount = new AsstAccountCollection();
        if (size > 0) {
            int i;
            for (i = 0; i < size; ++i) {
                AsstAccountInfo infoPre = (AsstAccountInfo)obj[i];
                String numberPre = infoPre.getNumber();
                for (int j = i + 1; j < size; ++j) {
                    AsstAccountInfo info = (AsstAccountInfo)obj[j];
                    String number = info.getNumber();
                    if (numberPre.compareTo(number) <= 0) continue;
                    AsstAccountInfo temp = infoPre;
                    obj[i] = info;
                    infoPre = info;
                    numberPre = infoPre.getNumber();
                    obj[j] = temp;
                }
            }
            for (i = 0; i < size; ++i) {
                AsstAccountInfo info = (AsstAccountInfo)obj[i];
                info.setName(info.getNumber() + " " + info.getName());
                allAsstAccount.add(info);
            }
        }
        return allAsstAccount;
    }

    @Override
    protected Map _getPageInitData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)paramMap.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        String companyid = company.getId().toString();
        if (company.getAccountTable() == null) {
            throw new GLException(GLException.NO_ACCOUNTTABLE);
        }
        AccountTableInfo accouttable = company.getAccountTable();
        CurrencyInfo curCurrency = new CurrencyInfo();
        curCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
        String cuid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit().getId().toString();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        otherCtx.put("COMPANY", company);
        otherCtx.put("CUID", cuid);
        otherCtx.put("ACCOUNTTABLEID", accouttable.getId().toString());
        otherCtx.put("isCover", Boolean.FALSE);
        otherCtx.put("curAsstAccountid", "");
        ArrayList al = AssistInitFacadeFactory.getLocalInstance(ctx).findInitData(otherCtx);
        int index = 0;
        int qtyScale = (Integer)al.get(index++);
        paramMap.put("GL_002", qtyScale);
        Boolean b = (Boolean)al.get(index++);
        boolean isForeignCurrency = b;
        paramMap.put("GL_008", isForeignCurrency);
        b = (Boolean)al.get(index++);
        boolean isUsingReport = b;
        paramMap.put("G001", isUsingReport);
        CurrencyCollection newAllCurrency = new CurrencyCollection();
        CurrencyCollection allCurrency = (CurrencyCollection)al.get(index++);
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalReportCurrency = null;
        String bookCurrency = EASResource.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)"bookCurrency", (Locale)ctx.getOriginLocale());
        int count = allCurrency.size();
        for (int i = 0; i < count; ++i) {
            CurrencyInfo cur = allCurrency.get(i);
            if (cur.isGeneralLocalCurrency()) {
                generalLocalCurrency = cur;
                continue;
            }
            if (cur.isGeneralReportCurrency()) {
                generalReportCurrency = cur;
                continue;
            }
            if (cur.getId().equals((Object)curCurrency.getId())) {
                if (!cur.getName().contains(bookCurrency)) {
                    cur.setName(cur.getName() + bookCurrency);
                }
                newAllCurrency.add(cur);
                if (curCurrency.getName().contains(bookCurrency)) continue;
                curCurrency.setName(curCurrency.getName() + bookCurrency);
                continue;
            }
            newAllCurrency.add(cur);
        }
        if (!isForeignCurrency) {
            if (generalLocalCurrency != null) {
                newAllCurrency.add(generalLocalCurrency);
                paramMap.put("generalLocalCurrency", generalLocalCurrency);
            }
            if (isUsingReport && generalReportCurrency != null) {
                newAllCurrency.add(generalReportCurrency);
                paramMap.put("generalReportCurrency", generalReportCurrency);
            }
        }
        PeriodInfo startPeriod = (PeriodInfo)al.get(index++);
        PeriodInfo currentPeriod = (PeriodInfo)al.get(index++);
        PeriodInfo firstPeriod = (PeriodInfo)al.get(index++);
        Object[] obj = ((AsstAccountCollection)al.get(index++)).toArray();
        AsstAccountCollection allAsstAccount = this.sorterAsstAccount(obj);
        paramMap.put("allAsstAccount", allAsstAccount);
        String[] closedAccount = (String[])al.get(index++);
        if (closedAccount == null) {
            closedAccount = new String[]{};
        }
        AccountTableCollection allAccouttable = (AccountTableCollection)al.get(index++);
        allAccouttable = InitHelp.getAccountTableCollection(ctx, company.getId().toString());
        b = (Boolean)al.get(index++);
        boolean qtyByAsst = b;
        b = Boolean.valueOf((String)al.get(index++));
        boolean allowCussent = b;
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        boolean isSettleByLocal = true;
        isSettleByLocal = 3 == company.getReportConvertMode().getValue();
        CurrencyInfo reportCur = company.getReportCurrency();
        CurrencyInfo localCur = company.getBaseCurrency();
        VoucherInfo.ExchangeRateWithValue rexLocalToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        if (isUsingReport && isSettleByLocal) {
            if (reportCur == null) {
                throw new GLException(GLException.NOREPORTINGCUR);
            }
            if (isForeignCurrency || reportCur.getId().toString().equals(localCur.getId().toString())) {
                // empty if block
            }
            String rebTable = null;
            if (company.getBaseExchangeTable() != null) {
                rebTable = company.getBaseExchangeTable().getId().toString();
            }
            if (company.getReportExchangeTable() == null) {
                throw new GLException(GLException.NOREPORTINGEXTABLE);
            }
            rexLocalToRpt = GlUtils.getLocalToReportingExchangeRate(reportCur, company.getReportExchangeTable().getId().toString(), localCur, rebTable, startPeriod.getBeginDate(), startPeriod, isForeignCurrency, null);
            if (rexLocalToRpt == null) {
                throw new GLException(GLException.NOLOCALTORPT);
            }
            BigDecimal curExRate2Report = rexLocalToRpt.getValue();
            paramMap.put("curExRate2Report", curExRate2Report);
        }
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        String ACCOUNT_SHOW_LONGNAME = pc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "GL_012");
        paramMap.put("GL_012", ACCOUNT_SHOW_LONGNAME);
        String RPT_GENERALASSTACT_SHOWLONGNAME = pc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "GL_066");
        paramMap.put("GL_066", RPT_GENERALASSTACT_SHOWLONGNAME);
        String PARAM_QTYASST = pc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "G010");
        paramMap.put("G010", PARAM_QTYASST);
        paramMap.put("allCurrency", newAllCurrency);
        paramMap.put("allAccouttable", allAccouttable);
        paramMap.put("curCurrency", curCurrency);
        paramMap.put("curAccouttable", accouttable);
        paramMap.put("closedAccount", closedAccount);
        paramMap.put("STARTPERIOD", startPeriod);
        paramMap.put("company", company);
        paramMap.put("CURRENTPERIOD", currentPeriod);
        paramMap.put("FIRSTPERIOD", firstPeriod);
        paramMap.put("IS_SETTLEBYLOCAL", isSettleByLocal);
        paramMap.put("IS_FIRSTPERIOD", isFirstPeriod);
        paramMap.put("IS_USINGREPORT", isUsingReport);
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("ISFOREIGN", isForeignCurrency);
        para.put("ISUSEREPORT", isUsingReport);
        para.put("COMPANY", company);
        para.put("CUID", company.getCU().getId().toString());
        para.put("ACCOUNTTABLEID", accouttable.getId().toString());
        IAssistInitFacade assistInitFacade = AssistInitFacadeFactory.getLocalInstance(ctx);
        ArrayList arr = assistInitFacade.getCanClosedAndCancelAccounts(null, new HashMap(para));
        boolean isAllClosed = false;
        isAllClosed = (Boolean)arr.get(2);
        if (isAllClosed) {
            paramMap.put("ISALLCLOSED", true);
        } else {
            paramMap.put("ISALLCLOSED", false);
        }
        boolean isNonClosed = false;
        isNonClosed = (Boolean)arr.get(3);
        if (isNonClosed) {
            paramMap.put("ISNONCLOSED", true);
        } else {
            paramMap.put("ISNONCLOSED", false);
        }
        return paramMap;
    }

    protected static String toCurrencyString(CurrencyInfo currency) {
        StringBuffer currencyStr = new StringBuffer();
        currencyStr.append(currency.getId());
        currencyStr.append(";").append(currency.getNumber());
        return currencyStr.toString();
    }
}

