/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagCollection;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussent;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.PostVoucherCheckReturn;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fm.im.IMIntObjectCheckFacadeFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InitHelp {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.InitHelp");
    public static final BigDecimal zero = new BigDecimal("0");
    public static final BigDecimal one = new BigDecimal("1");
    public static final BigDecimal negone = new BigDecimal("-1");
    public static final String initPeriodID = "AAAAAAAAAAAAAAAAAAAAAII4jEw=";
    private static boolean useAsstQty;
    public static final int LINETYPE_INIT = -6;
    public static final int LINETYPE_BEGINBALANCE = -3;
    public static final int LINETYPE_VOUCHER = 0;
    public static final int LINETYPE_MONTHTOTAL = 3;
    public static final int LINETYPE_YEARTOTAL = 6;
    public static final int LINETYPE_TOTAL = 9;

    public static BigDecimal nvl(BigDecimal b) {
        return b == null ? zero : b;
    }

    public static Map getInitParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)company.getId().toString()));
        HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
        hmNumAndOrgId.put("G001", null);
        hmNumAndOrgId.put("GL_002", comPK);
        hmNumAndOrgId.put("GL_003", comPK);
        hmNumAndOrgId.put("GL_008", comPK);
        hmNumAndOrgId.put("GL_028", comPK);
        hmNumAndOrgId.put("GL_055", comPK);
        hmNumAndOrgId.put("G010", null);
        hmNumAndOrgId.put("GL_059", comPK);
        hmNumAndOrgId.put("GL_102", comPK);
        hmNumAndOrgId.put("GL_103", comPK);
        hmNumAndOrgId.put("GL_012", comPK);
        hmNumAndOrgId.put("GL_111", comPK);
        hmNumAndOrgId.put("Gl_IsCheckOut Check", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmNumAndOrgId);
        Integer qtyscale = null;
        try {
            qtyscale = new Integer(hmAllParam.get("GL_002").toString());
            hmAllParam.put("GL_002", qtyscale);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_002"});
        }
        Boolean foreignCurrencySU = null;
        try {
            foreignCurrencySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
            hmAllParam.put("GL_008", foreignCurrencySU);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_008"});
        }
        Boolean useReportingCurrency = null;
        try {
            useReportingCurrency = Boolean.valueOf(hmAllParam.get("G001").toString());
            hmAllParam.put("G001", useReportingCurrency);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        if (Boolean.TRUE.equals(useReportingCurrency)) {
            if (company.getReportCurrency() == null) {
                throw new GLException(GLException.NOREPORTINGCUR);
            }
            if (company.getReportExchangeTable() == null) {
                throw new GLException(GLException.NOREPORTINGEXTABLE);
            }
        }
        Boolean isAccountInit = null;
        try {
            isAccountInit = Boolean.valueOf(hmAllParam.get("GL_055").toString());
            hmAllParam.put("GL_055", isAccountInit);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_055"});
        }
        Boolean qtyAsst = Boolean.FALSE;
        try {
            qtyAsst = Boolean.valueOf(hmAllParam.get("G010").toString());
            hmAllParam.put("G010", qtyAsst);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G010"});
        }
        Boolean rptBalanceAcct = Boolean.TRUE;
        try {
            if (hmAllParam.get("GL_059") == null) {
                hmAllParam.put("GL_059", rptBalanceAcct);
            } else {
                rptBalanceAcct = Boolean.valueOf(hmAllParam.get("GL_059").toString());
                hmAllParam.put("GL_059", rptBalanceAcct);
            }
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_059"});
        }
        Integer ASSISTREQUIRED = 1;
        try {
            ASSISTREQUIRED = Integer.parseInt(hmAllParam.get("GL_102").toString());
            hmAllParam.put("GL_102", ASSISTREQUIRED);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_102"});
        }
        Boolean commonVoucherProcess = false;
        try {
            commonVoucherProcess = Boolean.valueOf(hmAllParam.get("GL_111").toString());
            hmAllParam.put("GL_111", commonVoucherProcess);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_111"});
        }
        return hmAllParam;
    }

    public static Object[] fetchExchangeRate(Context ctx, Object[] info) throws BOSException, EASBizException {
        BigDecimal rate;
        ConvertModeEnum cm;
        Date invailTime;
        Date availTime;
        ExchangeTypeEnum type;
        String cur;
        String table;
        ExchangeAuxInfo aux;
        ExchangeRateInfo ex;
        Object[] result = new Object[2];
        String localTable = (String)info[0];
        String repTable = (String)info[1];
        String orgCur = (String)info[2];
        String localCur = (String)info[3];
        String repCur = (String)info[4];
        Date prdBegin = (Date)info[6];
        EntityViewInfo view = new EntityViewInfo();
        view.setTopCount(1);
        SorterItemCollection sorter = view.getSorter();
        SorterItemInfo siNum = new SorterItemInfo("availTime");
        siNum.setSortType(SortType.DESCEND);
        sorter.add(siNum);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("exchangeAux.exchangeTable.id"));
        sic.add(new SelectorItemInfo("exchangeAux.targetCurrency.id"));
        sic.add(new SelectorItemInfo("exchangeAux.convertMode"));
        sic.add(new SelectorItemInfo("exchangeAux.exchangeRateType"));
        sic.add(new SelectorItemInfo("exchangeAux.precision"));
        sic.add(new SelectorItemInfo("convertRate"));
        sic.add(new SelectorItemInfo("availTime"));
        sic.add(new SelectorItemInfo("invalidTime"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)localTable));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)orgCur));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)localCur));
        fic.add(new FilterItemInfo("availTime", (Object)prdBegin, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("invalidTime", (Object)prdBegin, CompareType.GREATER_EQUALS));
        filter.setMaskString("(#0 ) AND #1 AND #2 AND ((#3 AND #4) )");
        IExchangeRate exCtrl = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateCollection exCol = exCtrl.getExchangeRateCollection(view);
        VoucherInfo.ExchangeRateWithValue lex = null;
        VoucherInfo.ExchangeRateWithValue rex = null;
        Iterator itrEx = exCol.iterator();
        if (itrEx.hasNext()) {
            ex = (ExchangeRateInfo)itrEx.next();
            aux = ex.getExchangeAux();
            table = aux.getExchangeTable().get("id").toString();
            cur = aux.getTargetCurrency().get("id").toString();
            type = aux.getExchangeRateType();
            availTime = ex.getAvailTime();
            invailTime = ex.getInvalidTime();
            cm = aux.getConvertMode();
            rate = ex.getConvertRate();
            if (table.equals(localTable) && localCur.equals(cur) && prdBegin.compareTo(availTime) >= 0 && prdBegin.compareTo(invailTime) <= 0) {
                lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
            }
        }
        if (repCur != null) {
            filter = new FilterInfo();
            view.setFilter(filter);
            fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)repTable));
            fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)orgCur));
            fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)repCur));
            fic.add(new FilterItemInfo("availTime", (Object)prdBegin, CompareType.LESS_EQUALS));
            fic.add(new FilterItemInfo("invalidTime", (Object)prdBegin, CompareType.GREATER_EQUALS));
            filter.setMaskString("(#0 ) AND #1 AND #2 AND ((#3 AND #4) )");
            exCol = exCtrl.getExchangeRateCollection(view);
            itrEx = exCol.iterator();
            if (itrEx.hasNext()) {
                ex = (ExchangeRateInfo)itrEx.next();
                aux = ex.getExchangeAux();
                table = aux.getExchangeTable().get("id").toString();
                cur = aux.getTargetCurrency().get("id").toString();
                type = aux.getExchangeRateType();
                availTime = ex.getAvailTime();
                invailTime = ex.getInvalidTime();
                cm = aux.getConvertMode();
                rate = ex.getConvertRate();
                if (table.equals(localTable) && localCur.equals(cur) && prdBegin.compareTo(availTime) >= 0 && prdBegin.compareTo(invailTime) <= 0) {
                    lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                }
                if (table.equals(repTable) && cur.equals(repCur) && prdBegin.compareTo(availTime) >= 0 && prdBegin.compareTo(invailTime) <= 0) {
                    rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                }
            }
        }
        result[0] = lex;
        result[1] = rex;
        return result;
    }

    public static PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo[] periods = new PeriodInfo[3];
        periods[0] = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        periods[2] = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (periods[0] == null) {
            throw new ReportException(ReportException.PERIOD_ERROR);
        }
        if (periods[2] == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        if (periods[0].getPeriodNumber() == 1) {
            periods[1] = periods[0];
        } else {
            periods[1] = (PeriodInfo)InitHelp.getPeriodInfo(ctx, periods[0].getPeriodYear(), 1, company.getAccountPeriodType().getId().toString());
            if (periods[1] == null) {
                throw new InitException(InitException.NOFIRSTPERIOD);
            }
        }
        return periods;
    }

    public static PeriodInfo getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo p = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (p == null) {
            throw new ReportException(ReportException.PERIOD_ERROR);
        }
        return p;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo p = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (p == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        return p;
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String companyid) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        SelectorItemCollection sic = GlUtils.getCompanySic();
        try {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)), sic);
            if (company == null) {
                throw new GLException(GLException.NOCOMPANY);
            }
        }
        catch (Exception e) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (GlUtils.isCompanyUnion(company)) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return company;
    }

    public static HashMap getPeriodRange(Context ctx, PeriodInfo startPeriod, PeriodInfo endPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<Object, int[]> map = new HashMap<Object, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear FYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        sql.append("\tAND ((TP.FPeriodYear=? and TP.FPeriodNumber >= ?) or (TP.FPeriodYear>?))  \r\n");
        sql.append("\tAND ((TP.FPeriodYear=? and TP.FPeriodNumber <= ?) or (TP.FPeriodYear<?))  \r\n");
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = InitHelp.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            int index = 1;
            ps.setString(index++, company.getAccountPeriodType().getId().toString());
            int startYear = startPeriod.getPeriodYear();
            int startNumber = startPeriod.getPeriodNumber();
            int endYear = endPeriod.getPeriodYear();
            int endNumber = endPeriod.getPeriodNumber();
            ps.setInt(index++, startYear);
            ps.setInt(index++, startNumber);
            ps.setInt(index++, startYear);
            ps.setInt(index++, endYear);
            ps.setInt(index++, endNumber);
            ps.setInt(index++, endYear);
            rs = ps.executeQuery();
            index = 1;
            int year = -1;
            while (rs.next()) {
                year = rs.getInt("FYear");
                if (index++ == 1) {
                    startYear = year;
                }
                int min = rs.getInt("MinNumber");
                int max = rs.getInt("MaxNumber");
                map.put(new Integer(year), new int[]{min, max});
            }
            endYear = year;
            if (endYear == -1) {
                throw new ReportException(ReportException.TODO_UNTYPE);
            }
            map.put("YearRange", new int[]{startYear, endYear});
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return map;
    }

    public static IObjectValue fillHGId(Context ctx, IObjectValue hg, String[] propNames) throws BOSException, EASBizException {
        AssistantHGInfo assGrp = (AssistantHGInfo)hg;
        String asstAccountId = assGrp.getAsstAccount().getId().toString();
        AsstActTypeCollection types = new AsstActTypeCollection();
        for (int i = 0; i < propNames.length; ++i) {
            AsstActTypeInfo t = new AsstActTypeInfo();
            types.add(t);
            t.setAsstHGAttribute(propNames[i]);
        }
        return AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(assGrp, asstAccountId, types);
    }

    public static void checkAsstEqualGL(Context ctx, AccountViewInfo info, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        int qtyScale = 2;
        Object QTYSCALE = otherCtx.get("QTYSCALE");
        qtyScale = QTYSCALE instanceof Double ? ((Double)QTYSCALE).intValue() : ((Integer)QTYSCALE).intValue();
        int amountScale = (Integer)otherCtx.get("AMOUNTSCALE");
        boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        Map asstRecords = InitHelp.getAsstistRecordsByAccount(ctx, info, startPeriod);
        boolean isAsstRecords = null == asstRecords.get(info.getId().toString());
        String accountId = info.getId().toString();
        String glcid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String glrid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        String asstSql = "select fcurrencyid,sum(fbeginbalancefor) amountfor,sum(fbeginbalancelocal) amountlocal,sum(fbeginbalancerpt) amountreport,sum(fstandardbeginqty) qty ,sum(fyeardebitfor) yeardebitfor,sum(fyeardebitlocal) yeardebitlocal,sum(fyeardebitrpt) yeardebitreport,sum(fstandardyeardebitqty) yeardebitqty ,sum(fyearcreditfor) yearcreditfor,sum(fyearcreditlocal) yearcreditlocal,sum(fyearcreditrpt) yearcreditreport,sum(fstandardyearcreditqty) yearcreditqty ,sum(fyearpnlfor) yearpnlfor,sum(fyearpnllocal) yearpnllocal,sum(fyearpnlrpt) yearpnlreport from t_gl_initassistbalance where faccountid=? and forgunitid=? and fcurrencyid<>'" + glcid + "' and fcurrencyid<>'" + glrid + "'  group by fcurrencyid";
        String glSql = "select fcurrencyid,sum(fbeginbalancefor) amountfor,sum(fbeginbalancelocal) amountlocal,sum(fbeginbalancerpt) amountreport,sum(fbeginqty) qty ,sum(fyeardebitfor) yeardebitfor,sum(fyeardebitlocal) yeardebitlocal,sum(fyeardebitrpt) yeardebitreport,sum(fyeardebitqty) yeardebitqty ,sum(fyearcreditfor) yearcreditfor,sum(fyearcreditlocal) yearcreditlocal,sum(fyearcreditrpt) yearcreditreport,sum(fyearcreditqty) yearcreditqty ,sum(fyearpnlfor) yearpnlfor,sum(fyearpnllocal) yearpnllocal,sum(fyearpnlrpt) yearpnlreport from t_gl_initaccountbalance where faccountid=? and forgunitid=? and fcurrencyid<>'" + glcid + "' and fcurrencyid<>'" + glrid + "'  group by fcurrencyid";
        HashMap map1 = new HashMap();
        HashMap map2 = new HashMap();
        HashSet<String> keySet = new HashSet<String>();
        Connection con = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        boolean isqty = false;
        String currencyid = null;
        if (otherCtx.get("G010") != null && ((Boolean)otherCtx.get("G010")).booleanValue()) {
            if (info.isIsQty() && info.getCAA() != null && info.getCAA().isIsQty()) {
                isqty = true;
            }
        } else if (info.isIsQty()) {
            isqty = true;
        }
        boolean ispl = info.getAccountTypeID().getProperty().getValue() == 4;
        try {
            ArrayList<BigDecimal> al;
            con = InitHelp.getConnection(ctx);
            ps1 = con.prepareStatement(glSql);
            ps2 = con.prepareStatement(asstSql);
            ps1.setString(1, accountId);
            ps1.setString(2, orgUnitId);
            ps2.setString(1, accountId);
            ps2.setString(2, orgUnitId);
            rs1 = ps1.executeQuery();
            rs2 = ps2.executeQuery();
            while (rs1.next()) {
                al = new ArrayList<BigDecimal>(3);
                currencyid = rs1.getString("fcurrencyid");
                if (isqty) {
                    al.add(rs1.getBigDecimal("qty"));
                    if (!isFirstPeriod) {
                        al.add(rs1.getBigDecimal("yeardebitqty"));
                        al.add(rs1.getBigDecimal("yearcreditqty"));
                    }
                }
                al.add(rs1.getBigDecimal("amountfor"));
                if (!isFirstPeriod) {
                    al.add(rs1.getBigDecimal("yeardebitfor"));
                    al.add(rs1.getBigDecimal("yearcreditfor"));
                }
                if (ispl) {
                    al.add(rs1.getBigDecimal("yearpnlfor"));
                }
                if (!isForeign) {
                    al.add(rs1.getBigDecimal("amountlocal"));
                    if (!isFirstPeriod) {
                        al.add(rs1.getBigDecimal("yeardebitlocal"));
                        al.add(rs1.getBigDecimal("yearcreditlocal"));
                    }
                    if (ispl) {
                        al.add(rs1.getBigDecimal("yearpnllocal"));
                    }
                    if (isUseReport) {
                        al.add(rs1.getBigDecimal("amountreport"));
                        if (!isFirstPeriod) {
                            al.add(rs1.getBigDecimal("yeardebitreport"));
                            al.add(rs1.getBigDecimal("yearcreditreport"));
                        }
                        if (ispl) {
                            al.add(rs1.getBigDecimal("yearpnlreport"));
                        }
                    }
                }
                map1.put(currencyid, al);
                keySet.add(currencyid);
            }
            while (rs2.next()) {
                al = new ArrayList(3);
                currencyid = rs2.getString("fcurrencyid");
                if (isqty) {
                    al.add(rs2.getBigDecimal("qty"));
                    if (!isFirstPeriod) {
                        al.add(rs2.getBigDecimal("yeardebitqty"));
                        al.add(rs2.getBigDecimal("yearcreditqty"));
                    }
                }
                al.add(rs2.getBigDecimal("amountfor"));
                if (!isFirstPeriod) {
                    al.add(rs2.getBigDecimal("yeardebitfor"));
                    al.add(rs2.getBigDecimal("yearcreditfor"));
                }
                if (ispl) {
                    al.add(rs2.getBigDecimal("yearpnlfor"));
                }
                if (!isForeign) {
                    al.add(rs2.getBigDecimal("amountlocal"));
                    if (!isFirstPeriod) {
                        al.add(rs2.getBigDecimal("yeardebitlocal"));
                        al.add(rs2.getBigDecimal("yearcreditlocal"));
                    }
                    if (ispl) {
                        al.add(rs2.getBigDecimal("yearpnllocal"));
                    }
                    if (isUseReport) {
                        al.add(rs2.getBigDecimal("amountreport"));
                        if (!isFirstPeriod) {
                            al.add(rs2.getBigDecimal("yeardebitreport"));
                            al.add(rs2.getBigDecimal("yearcreditreport"));
                        }
                        if (ispl) {
                            al.add(rs2.getBigDecimal("yearpnlreport"));
                        }
                    }
                }
                map2.put(currencyid, al);
                keySet.add(currencyid);
            }
            Iterator iter = keySet.iterator();
            BigDecimal zero = new BigDecimal("0");
            boolean exception = false;
            String key = null;
            int index = -1;
            BigDecimal gl = null;
            BigDecimal asst = null;
            block6: while (!exception && iter.hasNext()) {
                BigDecimal c;
                BigDecimal a;
                Iterator iter2;
                index = -1;
                key = (String)iter.next();
                ArrayList glValues = (ArrayList)map1.get(key);
                ArrayList asstValues = (ArrayList)map2.get(key);
                if (isAsstRecords) continue;
                if (asstValues == null && glValues != null) {
                    iter2 = glValues.iterator();
                    while (iter2.hasNext()) {
                        ++index;
                        a = (BigDecimal)iter2.next();
                        if (a.compareTo(c = zero) == 0) continue;
                        gl = a;
                        asst = c;
                        exception = true;
                        continue block6;
                    }
                    continue;
                }
                if (glValues == null && asstValues != null) {
                    iter2 = asstValues.iterator();
                    while (iter2.hasNext()) {
                        ++index;
                        a = (BigDecimal)iter2.next();
                        if (a.compareTo(c = zero) == 0) continue;
                        gl = c;
                        asst = a;
                        exception = true;
                        continue block6;
                    }
                    continue;
                }
                iter2 = asstValues.iterator();
                Iterator iter3 = glValues.iterator();
                while (iter2.hasNext() && iter3.hasNext()) {
                    BigDecimal c2;
                    ++index;
                    BigDecimal a2 = (BigDecimal)iter2.next();
                    if (a2.compareTo(c2 = (BigDecimal)iter3.next()) == 0) continue;
                    asst = a2;
                    gl = c2;
                    exception = true;
                    continue block6;
                }
            }
            if (exception) {
                String strAsst;
                String strGl;
                CurrencyInfo cur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read(key)));
                ArrayList<String> columns = new ArrayList<String>();
                if (isqty) {
                    columns.add("monthBeginQty");
                    if (!isFirstPeriod) {
                        columns.add("yearDebitQty");
                        columns.add("yearCreditQty");
                    }
                }
                columns.add("monthBeginFor");
                if (!isFirstPeriod) {
                    columns.add("yearDebitFor");
                    columns.add("yearCreditFor");
                }
                if (ispl) {
                    columns.add("pnlFor");
                }
                if (!isForeign) {
                    columns.add("monthBeginLocal");
                    if (!isFirstPeriod) {
                        columns.add("yearDebitLocal");
                        columns.add("yearCreditLocal");
                    }
                    if (ispl) {
                        columns.add("pnlLocal");
                    }
                    if (isUseReport) {
                        columns.add("monthBeginReport");
                        if (!isFirstPeriod) {
                            columns.add("yearDebitReport");
                            columns.add("yearCreditReport");
                        }
                        if (ispl) {
                            columns.add("pnlReport");
                        }
                    }
                }
                String column = (String)columns.get(index);
                boolean exceptionIsQty = column.endsWith("Qty");
                column = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)column, (Locale)ctx.getLocale());
                if (exceptionIsQty) {
                    strGl = GlUtils.formatNumber(gl, qtyScale);
                    strAsst = GlUtils.formatNumber(asst, qtyScale);
                } else {
                    strGl = GlUtils.formatNumber(gl, amountScale);
                    strAsst = GlUtils.formatNumber(asst, amountScale);
                }
                throw new InitException(InitException.ASST_GL_CHECK_NOTEQUAL, new Object[]{info.getNumber() + "-" + info.getName(), cur.getName(), column, strGl, strAsst});
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs1, ps1);
                SQLUtils.cleanup(rs2, ps2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
        SQLUtils.cleanup((ResultSet)rs2, (Statement)ps2, (Connection)con);
    }

    private static Map getAsstistRecordsByAccount(Context ctx, AccountViewInfo info, PeriodInfo startPeriod) {
        HashSet<String> accounts = new HashSet<String>();
        accounts.add(info.getId().toString());
        try {
            IAccountFacade localInstance = AccountFacadeFactory.getLocalInstance((Context)ctx);
            return localInstance.getCAAIdsByPeriod(accounts, startPeriod.getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public static void checkAsstEqualGL(Context ctx, AccountViewCollection accountColl, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        int amountScale = (Integer)otherCtx.get("AMOUNTSCALE");
        boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        String glcid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String glrid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        StringBuffer accountids = new StringBuffer();
        for (int i = 0; i < accountColl.size(); ++i) {
            if (i > 0) {
                accountids.append(",");
            }
            accountids.append("'").append(accountColl.get(i).getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( \r\n");
        sql.append(" select cy.fname_").append(ctx.getLocale().toString()).append(" currencyName,av.fnumber accountNumber,av.fname_").append(ctx.getLocale().toString()).append(" accountName,");
        sql.append(" isnull(gl.fbeginbalancefor,0.00) glbeginbalancefor, isnull(asst.asstbeginbalancefor,0.00) asstbeginbalancefor,");
        sql.append(" isnull(gl.fbeginbalancelocal,0.00) glbeginbalancelocal, isnull(asst.asstbeginbalancelocal,0.00) asstbeginbalancelocal,");
        sql.append(" isnull(gl.fbeginbalancerpt,0.00) glbeginbalancerpt, isnull(asst.asstbeginbalancerpt,0.00) asstbeginbalancerpt,");
        sql.append(" isnull(gl.fbeginqty,0.00) glstandardbeginqty, isnull(asst.asststandardbeginqty,0.00) asststandardbeginqty ");
        if (!isFirstPeriod) {
            sql.append(", isnull(gl.fyeardebitfor,0.00) glyeardebitfor, isnull(asst.asstyeardebitfor,0.00) asstyeardebitfor,");
            sql.append(" isnull(gl.fyeardebitlocal,0.00) glyeardebitlocal, isnull(asst.asstyeardebitlocal,0.00) asstyeardebitlocal,");
            sql.append(" isnull(gl.fyeardebitrpt,0.00) glyeardebitrpt, isnull(asst.asstyeardebitrpt,0.00) asstyeardebitrpt,");
            sql.append(" isnull(gl.fyeardebitqty,0.00) glstandardyeardebitqty, isnull(asst.asststandardyeardebitqty,0.00) asststandardyeardebitqty, ");
            sql.append(" isnull(gl.fyearcreditfor,0.00) glyearcreditfor, isnull(asst.asstyearcreditfor,0.00) asstyearcreditfor,");
            sql.append(" isnull(gl.fyearcreditlocal,0.00) glyearcreditlocal, isnull(asst.asstyearcreditlocal,0.00) asstyearcreditlocal,");
            sql.append(" isnull(gl.fyearcreditrpt,0.00) glyearcreditrpt, isnull(asst.asstyearcreditrpt,0.00) asstyearcreditrpt,");
            sql.append(" isnull(gl.fyearcreditqty,0.00) glstandardyearcreditqty, isnull(asst.asststandardyearcreditqty,0.00) asststandardyearcreditqty, ");
            sql.append(" isnull(gl.fyearpnlfor,0.00) glyearpnlfor, isnull(asst.asstyearpnlfor,0.00) asstyearpnlfor,");
            sql.append(" isnull(gl.fyearpnllocal,0.00) glyearpnllocal, isnull(asst.asstyearpnllocal,0.00) asstyearpnllocal,");
            sql.append(" isnull(gl.fyearpnlrpt,0.00) glyearpnlrpt, isnull(asst.asstyearpnlrpt,0.00) asstyearpnlrpt ");
        }
        sql.append(" from t_bd_accountview av \r\n");
        sql.append(" inner join t_org_company cp on cp.fid = av.fcompanyid \r\n");
        sql.append(" inner join t_bd_currency cy on 1 =1 \r\n");
        sql.append(" left outer join (select forgunitid,faccountid,fcurrencyid,");
        sql.append(" sum(fbeginbalancefor) asstbeginbalancefor,sum(fbeginbalancelocal) asstbeginbalancelocal,sum(fbeginbalancerpt) asstbeginbalancerpt,sum(fstandardbeginqty) asststandardbeginqty ");
        if (!isFirstPeriod) {
            sql.append(" ,sum(fyeardebitfor) asstyeardebitfor,sum(fyeardebitlocal) asstyeardebitlocal,sum(fyeardebitrpt) asstyeardebitrpt,sum(fstandardyeardebitqty) asststandardyeardebitqty,");
            sql.append(" sum(fyearcreditfor) asstyearcreditfor,sum(fyearcreditlocal) asstyearcreditlocal,sum(fyearcreditrpt) asstyearcreditrpt,sum(fstandardyearcreditqty) asststandardyearcreditqty,");
            sql.append(" sum(fyearpnlfor) asstyearpnlfor,sum(fyearpnllocal) asstyearpnllocal,sum(fyearpnlrpt) asstyearpnlrpt");
        }
        sql.append(" from t_gl_initassistbalance where forgunitid = ? group by forgunitid,faccountid,fcurrencyid) asst on cp.fid = asst.forgunitid and av.fid = asst.faccountid and cy.fid = asst.fcurrencyid \r\n");
        sql.append(" left outer join t_gl_initaccountbalance gl on gl.faccountid = av.fid and gl.forgunitid = cp.fid and gl.fcurrencyid = cy.fid \r\n");
        sql.append(" where cp.fid=? and av.fid in (").append(accountids.toString()).append(") and cy.fid<>'" + glcid + "' and cy.fid<>'" + glrid + "' ");
        sql.append(" ) t \r\n ");
        sql.append(" where glbeginbalancefor - asstbeginbalancefor <> 0 ");
        sql.append(" or glstandardbeginqty - asststandardbeginqty <>0 ");
        if (!isForeign) {
            sql.append(" or glbeginbalancelocal - asstbeginbalancelocal <> 0 ");
            if (isUseReport) {
                sql.append(" or glbeginbalancerpt - asstbeginbalancerpt <> 0 ");
            }
        }
        if (!isFirstPeriod) {
            sql.append(" or glyeardebitfor - asstyeardebitfor <>0 ");
            sql.append(" or glstandardyeardebitqty - asststandardyeardebitqty <>0 ");
            sql.append(" or glyearcreditfor - asstyearcreditfor<>0 ");
            sql.append(" or glstandardyearcreditqty - asststandardyearcreditqty <>0 ");
            sql.append(" or glyearpnlfor - asstyearpnlfor <>0 ");
            if (!isForeign) {
                sql.append(" or glyeardebitlocal - asstyeardebitlocal <> 0 ");
                sql.append(" or glyearcreditlocal - asstyearcreditfor <> 0 ");
                sql.append(" or glyearpnllocal - asstyearpnllocal <> 0 ");
                if (isUseReport) {
                    sql.append(" or glyeardebitrpt - asstyeardebitrpt <> 0 ");
                    sql.append(" or glyearcreditrpt - asstyearcreditfor <> 0 ");
                    sql.append(" or glyearpnlrpt - asstyearpnlrpt <> 0 ");
                }
            }
        }
        sql.append(" order by accountNumber,currencyName ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitId, orgUnitId});
        try {
            String column = null;
            BigDecimal gl = null;
            BigDecimal asst = null;
            while (rs.next()) {
                if (rs.getBigDecimal("glbeginbalancefor").doubleValue() - rs.getBigDecimal("asstbeginbalancefor").doubleValue() != 0.0) {
                    column = "monthBeginFor";
                    gl = rs.getBigDecimal("glbeginbalancefor");
                    asst = rs.getBigDecimal("asstbeginbalancefor");
                    break;
                }
                if (rs.getBigDecimal("glstandardbeginqty").doubleValue() - rs.getBigDecimal("asststandardbeginqty").doubleValue() != 0.0) {
                    column = "monthBeginQty";
                    gl = rs.getBigDecimal("glstandardbeginqty");
                    asst = rs.getBigDecimal("asststandardbeginqty");
                    break;
                }
                if (!isForeign) {
                    if (rs.getBigDecimal("glbeginbalancelocal").doubleValue() - rs.getBigDecimal("asstbeginbalancelocal").doubleValue() != 0.0) {
                        column = "monthBeginLocal";
                        gl = rs.getBigDecimal("glbeginbalancelocal");
                        asst = rs.getBigDecimal("asstbeginbalancelocal");
                        break;
                    }
                    if (isUseReport && rs.getBigDecimal("glbeginbalancerpt").doubleValue() - rs.getBigDecimal("asstbeginbalancerpt").doubleValue() != 0.0) {
                        column = "monthBeginReport";
                        gl = rs.getBigDecimal("glbeginbalancerpt");
                        asst = rs.getBigDecimal("asstbeginbalancerpt");
                        break;
                    }
                }
                if (isFirstPeriod) continue;
                if (rs.getBigDecimal("glyeardebitfor").doubleValue() - rs.getBigDecimal("asstyeardebitfor").doubleValue() != 0.0) {
                    column = "yearDebitFor";
                    gl = rs.getBigDecimal("glyeardebitfor");
                    asst = rs.getBigDecimal("asstyeardebitfor");
                    break;
                }
                if (rs.getBigDecimal("glyearcreditfor").doubleValue() - rs.getBigDecimal("asstyearcreditfor").doubleValue() != 0.0) {
                    column = "yearCreditFor";
                    gl = rs.getBigDecimal("glyearcreditfor");
                    asst = rs.getBigDecimal("asstyearcreditfor");
                    break;
                }
                if (rs.getBigDecimal("glstandardyeardebitqty").doubleValue() - rs.getBigDecimal("asststandardyeardebitqty").doubleValue() != 0.0) {
                    column = "yearDebitQty";
                    gl = rs.getBigDecimal("glstandardyeardebitqty");
                    asst = rs.getBigDecimal("asststandardyeardebitqty");
                    break;
                }
                if (rs.getBigDecimal("glstandardyearcreditqty").doubleValue() - rs.getBigDecimal("asststandardyearcreditqty").doubleValue() != 0.0) {
                    column = "yearCreditQty";
                    gl = rs.getBigDecimal("glstandardyearcreditqty");
                    asst = rs.getBigDecimal("asststandardyearcreditqty");
                    break;
                }
                if (rs.getBigDecimal("glyearpnlfor").doubleValue() - rs.getBigDecimal("asstyearpnlfor").doubleValue() != 0.0) {
                    column = "pnlFor";
                    gl = rs.getBigDecimal("glyearpnlfor");
                    asst = rs.getBigDecimal("asstyearpnlfor");
                    break;
                }
                if (isForeign) continue;
                if (rs.getBigDecimal("glyeardebitlocal").doubleValue() - rs.getBigDecimal("asstyeardebitlocal").doubleValue() != 0.0) {
                    column = "yearDebitLocal";
                    gl = rs.getBigDecimal("glyeardebitlocal");
                    asst = rs.getBigDecimal("asstyeardebitlocal");
                    break;
                }
                if (rs.getBigDecimal("glyearcreditlocal").doubleValue() - rs.getBigDecimal("asstyearcreditlocal").doubleValue() != 0.0) {
                    column = "yearCreditLocal";
                    gl = rs.getBigDecimal("glyearcreditlocal");
                    asst = rs.getBigDecimal("asstyearcreditlocal");
                    break;
                }
                if (rs.getBigDecimal("glyearpnllocal").doubleValue() - rs.getBigDecimal("asstyearpnllocal").doubleValue() != 0.0) {
                    column = "pnlLocal";
                    gl = rs.getBigDecimal("glyearpnllocal");
                    asst = rs.getBigDecimal("asstyearpnllocal");
                    break;
                }
                if (!isUseReport) continue;
                if (rs.getBigDecimal("glyeardebitrpt").doubleValue() - rs.getBigDecimal("asstyeardebitrpt").doubleValue() != 0.0) {
                    column = "yearDebitReport";
                    gl = rs.getBigDecimal("glyeardebitrpt");
                    asst = rs.getBigDecimal("asstyeardebitrpt");
                    break;
                }
                if (rs.getBigDecimal("glyearcreditrpt").doubleValue() - rs.getBigDecimal("asstyearcreditrpt").doubleValue() != 0.0) {
                    column = "yearCreditReport";
                    gl = rs.getBigDecimal("glyearcreditrpt");
                    asst = rs.getBigDecimal("asstyearcreditrpt");
                    break;
                }
                if (rs.getBigDecimal("glyearpnlrpt").doubleValue() - rs.getBigDecimal("asstyearpnlrpt").doubleValue() == 0.0) continue;
                column = "pnlReport";
                gl = rs.getBigDecimal("glyearpnlrpt");
                asst = rs.getBigDecimal("asstyearpnlrpt");
                break;
            }
            if (column != null) {
                String strAsst;
                String strGl;
                String colTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.InitResource", column, (Locale)ctx.getLocale());
                boolean exceptionIsQty = column.endsWith("Qty");
                if (exceptionIsQty) {
                    strGl = GlUtils.formatNumber(gl);
                    strAsst = GlUtils.formatNumber(asst);
                } else {
                    strGl = GlUtils.formatNumber(gl, amountScale);
                    strAsst = GlUtils.formatNumber(asst, amountScale);
                }
                throw new InitException(InitException.ASST_GL_CHECK_NOTEQUAL, new Object[]{rs.getString("accountNumber") + "-" + rs.getString("accountName"), rs.getString("currencyName"), colTitle, strGl, strAsst});
            }
        }
        catch (SQLException ex) {
            throw new BOSException("SQL ERROR", (Throwable)ex);
        }
    }

    public static void checkAsstEqualCussent(Context ctx, AccountViewCollection accountColl, HashMap otherCtx) throws BOSException, EASBizException {
        boolean isEnableACPeriod;
        boolean bl = isEnableACPeriod = otherCtx.get("isEnableACPeriod") != null && (Boolean)otherCtx.get("isEnableACPeriod") != false;
        if (isEnableACPeriod) {
            int i;
            boolean isAfterAcPeriod = otherCtx.get("isAfterAcPeriod") == null ? false : (Boolean)otherCtx.get("isAfterAcPeriod");
            PeriodInfo period = isAfterAcPeriod ? (PeriodInfo)otherCtx.get("CURRENTPERIOD") : (PeriodInfo)otherCtx.get("ACPeriod");
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    c.FAccountID, c.FAfterID \n");
            sql.append("from T_BD_AsstAccountChange c \n");
            sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
            if (accountColl.size() == 1) {
                sql.append("where c.FAccountID = ? \n");
            } else if (accountColl.size() > 1) {
                sql.append("where c.FAccountID in ( \n");
                for (int i2 = 0; i2 < accountColl.size(); ++i2) {
                    sql.append("'" + accountColl.get(i2).getId().toString() + "',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") \n");
            } else {
                sql.append(" where 1=1 ");
            }
            sql.append("    and p.FNumber = ? \n");
            Object[] param = accountColl.size() == 1 ? new Object[]{accountColl.get(0).getId().toString(), new Integer(period.getNumber())} : new Object[]{new Integer(period.getNumber())};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rs.size() == 0) {
                InitHelp.doCheckAsstEqualCussent(ctx, accountColl, otherCtx, false);
                return;
            }
            HashMap<String, String> ids = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    ids.put(rs.getString("FAccountID"), rs.getString("FAfterID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            AccountViewCollection noColl = new AccountViewCollection();
            AccountViewCollection hasColl = new AccountViewCollection();
            for (i = 0; i < accountColl.size(); ++i) {
                AccountViewInfo av = accountColl.get(i);
                if (ids.containsKey(av.getId().toString())) {
                    hasColl.add(av);
                    continue;
                }
                noColl.add(av);
            }
            if (noColl.size() > 0) {
                InitHelp.doCheckAsstEqualCussent(ctx, noColl, otherCtx, false);
            }
            for (i = 0; i < hasColl.size(); ++i) {
                AccountViewCollection single = new AccountViewCollection();
                AccountViewInfo av = hasColl.get(i);
                String afterId = (String)ids.get(av.getId().toString());
                if (afterId == null) continue;
                av.put("afterID", (Object)afterId);
                single.add(av);
                InitHelp.doCheckAsstEqualCussent(ctx, single, otherCtx, true);
                av.remove("afterID");
            }
        } else {
            InitHelp.doCheckAsstEqualCussent(ctx, accountColl, otherCtx, false);
        }
    }

    public static void doCheckAsstEqualCussent(Context ctx, AccountViewCollection accountColl, HashMap otherCtx, boolean hasChange) throws BOSException, EASBizException {
        if (accountColl.size() == 0) {
            return;
        }
        InitHelp.setUseAsstQty(GlUtils.getQtyAsstParam(ctx));
        GLResUtil.setLocale(ctx.getLocale());
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        Integer amountScale = (Integer)otherCtx.get("AMOUNTSCALE");
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        String glcid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String glrid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        StringBuffer accountids = new StringBuffer();
        for (int i = 0; i < accountColl.size(); ++i) {
            if (i > 0) {
                accountids.append(",");
            }
            accountids.append("'").append(accountColl.get(i).getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        boolean isEnableACPeriod = otherCtx.get("isEnableACPeriod") != null && (Boolean)otherCtx.get("isEnableACPeriod") != false;
        PeriodInfo period = null;
        sql.append("select cy.fname_").append(ctx.getLocale().toString()).append(" currencyName,av.fid accountid,av.fnumber accountNumber,av.fname_").append(ctx.getLocale().toString()).append(" accountName,");
        sql.append("    t.*,endMU.fcoefficient \n");
        sql.append("from ( \n");
        sql.append("select \n");
        sql.append("    case when cussent.faccountid is not null then cussent.faccountid else asst.FAccountID end FAccountID, \n");
        sql.append("    case when cussent.fcurrencyid is not null then cussent.fcurrencyid else asst.fcurrencyid end fcurrencyid, \n");
        sql.append("    case when cussent.fassgrpid is not null then cussent.fassgrpid else asst.fassgrpid end hgid, \n");
        sql.append("    isnull(acoriginalamount,0.00) acoriginalamount, \n");
        sql.append("    isnull(aclocalamount,0.00) aclocalamount, \n");
        sql.append("    isnull(acreportingamount,0.00) acreportingamount, \n");
        sql.append("    isnull(acstandardquantity,0.00) acstandardquantity, \n");
        sql.append("    isnull(asstbeginbalancefor,0.00) asstbeginbalancefor, \n");
        sql.append("    isnull(asstbeginbalancelocal,0.00) asstbeginbalancelocal, \n");
        sql.append("    isnull(asstbeginbalancerpt,0.00) asstbeginbalancerpt, \n");
        sql.append("    isnull(asststandardbeginqty,0.00) asststandardbeginqty \n");
        sql.append("from ( \n");
        sql.append("    select ac.faccountid,ac.fcurrencyid,r.fassgrpid, \n");
        sql.append(" sum(R.foriginalamount) acoriginalamount,sum(R.flocalamount) aclocalamount,sum(R.freportingamount) acreportingamount,sum(R.fstandardquantity) acstandardquantity ");
        sql.append(" from t_gl_acctcussent ac  \r\n");
        sql.append(" inner join t_gl_voucherassistrecord r on ac.fvchassistrecordid=r.fid \r\n");
        sql.append(" where ac.fisinit=1 and ac.fcompanyid = ? \r\n");
        sql.append(" and ac.faccountid in (").append(accountids.toString()).append(") \n");
        sql.append(" group by ac.fcompanyid,ac.faccountid,ac.fcurrencyid,r.fassgrpid \r\n");
        sql.append(") cussent \n");
        sql.append("full join ( \n");
        if (isEnableACPeriod) {
            boolean isAfterAcPeriod = otherCtx.get("isAfterAcPeriod") == null ? false : (Boolean)otherCtx.get("isAfterAcPeriod");
            PeriodInfo periodInfo = period = isAfterAcPeriod ? (PeriodInfo)otherCtx.get("CURRENTPERIOD") : (PeriodInfo)otherCtx.get("ACPeriod");
            if (hasChange) {
                String afterId = accountColl.get(0).get("afterId").toString();
                sql.append(" select ve.faccountid,ve.fcurrencyid,r.fassgrpid, \n");
                sql.append(" sum(R.foriginalamount) asstbeginbalancefor,sum(R.flocalamount) asstbeginbalancelocal,sum(R.freportingamount) asstbeginbalancerpt,sum(R.fstandardquantity) asststandardbeginqty ");
                sql.append(" from t_gl_voucher v  \r\n");
                sql.append(" join t_gl_voucherentry ve on ve.fbillid = v.fid \r\n");
                sql.append(" join t_gl_voucherassistrecord r on r.fentryid = ve.fid \r\n");
                sql.append(" where v.fcompanyid = ? \r\n");
                sql.append(" and v.fperiodid = '" + period.getId().toString() + "' \n");
                sql.append(" and v.fSourceType = 11 \r\n");
                sql.append(" and ve.FAccountID in (").append(accountids.toString()).append(") \n");
                sql.append(" and ve.fcaa = '" + afterId + "' \n");
                sql.append(" group by ve.faccountid,ve.fcurrencyid,r.fassgrpid \r\n");
            } else {
                sql.append("select af.FAccountID, af.FCurrencyID, af.fassistgrpid fassgrpid, \n");
                sql.append(" isnull(af.fbeginbalancefor,0.00)*(case when acv.fdc=-1 then -1 else 1 end) asstbeginbalancefor,");
                sql.append(" isnull(af.fbeginbalancelocal,0.00)*(case when acv.fdc=-1 then -1 else 1 end) asstbeginbalancelocal,");
                sql.append(" isnull(af.fbeginbalancerpt,0.00)*(case when acv.fdc=-1 then -1 else 1 end) asstbeginbalancerpt,");
                sql.append(" isnull(af.fbeginqty,0.00)*(case when acv.fdc=-1 then -1 else 1 end) asststandardbeginqty ");
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(1) + " af inner join t_bd_accountview acv on af.faccountid = acv.fid \n");
                sql.append("where af.forgunitid = ? \n");
                sql.append("and af.fperiod = ").append(period.getNumber()).append(" \r\n");
                sql.append("and af.FAccountID in (").append(accountids.toString()).append(") \n");
            }
        } else {
            period = (PeriodInfo)otherCtx.get("STARTPERIOD");
            sql.append("select FAccountID, FCurrencyID, fassistgrpid fassgrpid, \n");
            sql.append(" isnull(fbeginbalancefor,0.00) asstbeginbalancefor,");
            sql.append(" isnull(fbeginbalancelocal,0.00) asstbeginbalancelocal,");
            sql.append(" isnull(fbeginbalancerpt,0.00) asstbeginbalancerpt,");
            sql.append(" isnull(fstandardbeginqty,0.00) asststandardbeginqty ");
            sql.append(" from t_gl_initassistbalance ");
            sql.append("where forgunitid = ? \n");
            sql.append("and FAccountID in (").append(accountids.toString()).append(") \n");
            sql.append("and FCurrencyID <> '" + glcid + "' \n");
            sql.append("and FCurrencyID <> '" + glrid + "' \n");
        }
        sql.append(") asst on asst.FAccountID = cussent.FAccountID \n");
        sql.append("and asst.FCurrencyID = cussent.FCurrencyID \n");
        sql.append("and asst.fassgrpid = cussent.fassgrpid \n");
        sql.append("where (isnull(acoriginalamount,0.00) - isnull(asstbeginbalancefor,0.00) <> 0 ");
        sql.append(" or isnull(acstandardquantity,0.00) - isnull(asststandardbeginqty,0.00) <>0 ");
        if (!isForeign) {
            sql.append(" or isnull(aclocalamount,0.00) - isnull(asstbeginbalancelocal,0.00) <> 0 ");
            if (isUseReport) {
                sql.append(" or isnull(acreportingamount,0.00) - isnull(asstbeginbalancerpt,0.00) <> 0 ");
            }
        }
        sql.append(")");
        sql.append(") t \n");
        sql.append("join t_bd_currency cy on cy.fid = t.fcurrencyid \n");
        sql.append("join t_bd_accountview av on av.fid = t.faccountid \n");
        sql.append("left join t_bd_measureunit endMU on endMU.fid = av.FMeasureUnitID");
        sql.append(" order by accountNumber,currencyName ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitId, orgUnitId});
        HashSet<String> accIds = new HashSet<String>();
        try {
            while (rs.next()) {
                accIds.add(rs.getString("FAccountID"));
            }
            rs.beforeFirst();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        Map<String, AsstAccountInfo> caas = GLAsstAccountUtils.getCAAs(ctx, accIds, period.getId().toString(), null);
        HashSet<String> caaIds = new HashSet<String>();
        for (AsstAccountInfo caa : caas.values()) {
            caaIds.add(caa.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("asstActGpDt.id"));
        view.getSelector().add(new SelectorItemInfo("asstActGpDt.asstActType.id"));
        view.getSelector().add(new SelectorItemInfo("asstActGpDt.asstActType.name"));
        view.getSelector().add(new SelectorItemInfo("asstActGpDt.asstActType.asstHGAttribute"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", caaIds, CompareType.INCLUDE));
        view.setFilter(filter);
        AsstAccountCollection coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
        HashMap<String, AsstAccountInfo> aas = new HashMap<String, AsstAccountInfo>();
        for (AsstAccountInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        try {
            String column = null;
            BigDecimal cussent = null;
            BigDecimal asst = null;
            while (rs.next()) {
                if (rs.getBigDecimal("acoriginalamount").doubleValue() - rs.getBigDecimal("asstbeginbalancefor").doubleValue() != 0.0) {
                    column = "amountFor";
                    cussent = rs.getBigDecimal("acoriginalamount");
                    asst = rs.getBigDecimal("asstbeginbalancefor");
                    break;
                }
                BigDecimal fcoefficient = rs.getBigDecimal("fcoefficient");
                if (!InitHelp.isUseAsstQty() && fcoefficient != null) {
                    if (rs.getBigDecimal("acstandardquantity").subtract(rs.getBigDecimal("asststandardbeginqty").divide(fcoefficient)).compareTo(new BigDecimal("0")) != 0) {
                        column = "quantity";
                        cussent = rs.getBigDecimal("acstandardquantity");
                        asst = rs.getBigDecimal("asststandardbeginqty");
                        break;
                    }
                } else if (rs.getBigDecimal("acstandardquantity").doubleValue() - rs.getBigDecimal("asststandardbeginqty").doubleValue() != 0.0) {
                    column = "quantity";
                    cussent = rs.getBigDecimal("acstandardquantity");
                    asst = rs.getBigDecimal("asststandardbeginqty");
                    break;
                }
                if (isForeign) continue;
                if (rs.getBigDecimal("aclocalamount").doubleValue() - rs.getBigDecimal("asstbeginbalancelocal").doubleValue() != 0.0) {
                    column = "amountLocal";
                    cussent = rs.getBigDecimal("aclocalamount");
                    asst = rs.getBigDecimal("asstbeginbalancelocal");
                    break;
                }
                if (!isUseReport || rs.getBigDecimal("acreportingamount").doubleValue() - rs.getBigDecimal("asstbeginbalancerpt").doubleValue() == 0.0) continue;
                column = "amountReport";
                cussent = rs.getBigDecimal("acreportingamount");
                asst = rs.getBigDecimal("asstbeginbalancerpt");
                break;
            }
            if (column != null) {
                for (int i = 0; i < accountColl.size(); ++i) {
                    String strAsst;
                    String strCussent;
                    AsstAccountInfo aa;
                    if (!rs.getString("accountid").equals(accountColl.get(i).getId().toString()) || accountColl.get(i).isIsCFreeze() || (aa = caas.get(rs.getString("accountid"))) == null || (aa = (AsstAccountInfo)aas.get(aa.getId().toString())) == null) continue;
                    AsstActGroupDetailCollection tcol = aa.getAsstActGpDt();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    for (int j = 0; j < tcol.size(); ++j) {
                        selector.add(new SelectorItemInfo("id"));
                        selector.add(new SelectorItemInfo(tcol.get(j).getAsstActType().getAsstHGAttribute() + ".id"));
                        selector.add(new SelectorItemInfo(tcol.get(j).getAsstActType().getAsstHGAttribute() + ".name"));
                    }
                    AssistantHGInfo hg = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(rs.getString("hgid")), selector);
                    StringBuffer desc = new StringBuffer();
                    for (int j = 0; j < tcol.size(); ++j) {
                        DataBaseInfo db = (DataBaseInfo)hg.get(tcol.get(j).getAsstActType().getAsstHGAttribute());
                        String value = db == null ? "?" : db.getName();
                        desc.append(GLResUtil.getRes("sign_comma") + tcol.get(j).getAsstActType().getName() + GLResUtil.getRes("sign_colon") + value);
                    }
                    String colTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)column, (Locale)ctx.getLocale());
                    boolean exceptionIsQty = column.endsWith("quantity");
                    if (exceptionIsQty) {
                        strCussent = GlUtils.formatNumber(cussent);
                        strAsst = GlUtils.formatNumber(asst);
                    } else if (amountScale != null) {
                        strCussent = GlUtils.formatNumber(cussent, (int)amountScale);
                        strAsst = GlUtils.formatNumber(asst, (int)amountScale);
                    } else {
                        strCussent = GlUtils.formatNumber(cussent);
                        strAsst = GlUtils.formatNumber(asst);
                    }
                    throw new InitException(InitException.ASST_CUSSENT_CHECK_NOTEQUAL, new Object[]{rs.getString("accountNumber") + "-" + rs.getString("accountName"), rs.getString("currencyName"), desc.toString(), colTitle, strAsst, strCussent});
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    public static void checkCancelInitForCussent(Context ctx, AccountViewCollection accounts, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        InitHelp.checkAcctCussentCancelInit(ctx, orgUnitId);
        InitHelp.checkAcctCussentBeHolded(ctx, accounts, orgUnitId);
    }

    public static boolean acAccountInitPeriodIsCurrentPeriod(Context ctx, AccountViewInfo account, String orgUnitId, PeriodInfo currentPeriod) throws BOSException {
        PeriodInfo initPeriod;
        return account == null || (initPeriod = InitHelp.getCussentInitPeriod(ctx, account.getId().toString(), orgUnitId)) == null || initPeriod.getId().toString().equals(currentPeriod.getId().toString());
    }

    public static AccountViewCollection getInitPeriodIsCurrentPeriodAccounts(Context ctx, AccountViewCollection accounts, String orgUnitId, PeriodInfo currentPeriod, boolean isCloseInit) throws BOSException {
        AccountViewCollection accountViewCol = new AccountViewCollection();
        if (accounts != null && accounts.size() > 0) {
            HashMap<String, AccountViewInfo> accountMap = new HashMap<String, AccountViewInfo>();
            for (int i = 0; i < accounts.size(); ++i) {
                accountMap.put(accounts.get(i).getId().toString(), accounts.get(i));
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("key", new HashSet(accountMap.keySet()), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("value", (Object)Boolean.toString(!isCloseInit), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", (Object)currentPeriod.getId().toString(), CompareType.EQUALS));
            if (isCloseInit) {
                filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", null));
                int index = 0;
                StringBuilder maskString = new StringBuilder("(");
                maskString.append("#").append(index++).append(" and #").append(index++).append(" and #").append(index++).append(" and #").append(index++);
                maskString.append(" and (#").append(index++).append(" or #").append(index++).append(")");
                maskString.append(")");
                filter.setMaskString(maskString.toString());
            }
            view.setFilter(filter);
            GLFlagCollection col = GLFlagFactory.getLocalInstance(ctx).getCollection(view);
            if (col.size() > 0) {
                for (int j = 0; j < col.size(); ++j) {
                    String accountId = col.get(j).getKey();
                    if (!accountMap.containsKey(accountId)) continue;
                    accountViewCol.add((AccountViewInfo)accountMap.get(accountId));
                }
            }
        }
        return accountViewCol;
    }

    public static PeriodInfo getCussentInitPeriod(Context ctx, String accountId, String orgUnitId) throws BOSException {
        PeriodInfo initPeriod = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)accountId, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("initPeriod.*"));
        GLFlagCollection col = GLFlagFactory.getLocalInstance(ctx).getCollection(view);
        if (col.size() > 0) {
            GLFlagInfo flag = col.get(0);
            initPeriod = flag.getInitPeriod();
        }
        return initPeriod;
    }

    public static void checkCancelInit(Context ctx, AccountViewCollection accounts, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        if (!startPeriod.getId().toString().equals(currentPeriod.getId().toString())) {
            throw new InitException(InitException.CHECK_CANCELINIT);
        }
        InitHelp.checkBooksHasCloseInit(ctx, orgUnitId);
    }

    public static void checkCancelInit(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        String startPeriodId = null;
        String currPeriodId = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ssc.fid,ssc.fstartperiodid,ssc.fcurrentperiodid from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid ");
        sql.append(" where ssc.fcompanyid = ? and ss.fname = ").append(6);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitId});
        try {
            if (rs.next()) {
                startPeriodId = rs.getString("fstartperiodid");
                currPeriodId = rs.getString("fcurrentperiodid");
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        if (startPeriodId != null && !startPeriodId.equals(currPeriodId)) {
            throw new InitException(InitException.CHECK_CANCELINIT);
        }
        InitHelp.checkBooksHasCloseInit(ctx, orgUnitId);
    }

    public static void checkAcctCussentCancelInit(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        PeriodInfo startPeriod = null;
        PeriodInfo acPeriod = null;
        PeriodInfo currentPeriod = null;
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select startPeriod.*,currentPeriod.*,acPeriod.* where systemStatus.name=6 and company.id='" + orgUnitId + "'");
        if (ctrols.size() > 0) {
            startPeriod = ctrols.get(0).getStartPeriod();
            acPeriod = ctrols.get(0).getAcPeriod() != null ? ctrols.get(0).getAcPeriod() : startPeriod;
            currentPeriod = ctrols.get(0).getCurrentPeriod();
        }
        if (currentPeriod != null && acPeriod != null && currentPeriod.getNumber() < acPeriod.getNumber()) {
            throw new InitException(InitException.CHECK_CANCELINIT);
        }
        InitHelp.checkBooksHasCloseInit(ctx, orgUnitId);
    }

    public static void checkBooksHasCloseInit(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        if (BooksUtil.isMasterBook((Context)ctx) && BooksUtil.canCreateBook((Context)ctx)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 1 where exists          \t\t\r\n");
            sql.append("(select 1 from t_GL_Flag          \t\r\n");
            sql.append("where FOrgUnitID = ?                \r\n");
            sql.append("    and FName = 'glinit'            \r\n");
            sql.append("\tand FValue = 'true'            \t\r\n");
            sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(";");
            Map bookList = BookUtil._getBookList(ctx, orgUnitId);
            Set keys = bookList.keySet();
            for (String transferOrg : keys) {
                if (!InitHelp.checkHasCloseInit(ctx, transferOrg, sql.toString())) continue;
                String bookid = (String)bookList.get(transferOrg);
                AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookid));
                throw new InitException(InitException.OTHERBOOKSCLOSED, new Object[]{book.getName()});
            }
        }
    }

    public static boolean checkHasCloseInit(Context ctx, String curCompanyID, String sql) throws BOSException {
        boolean isColsed = false;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID});
        try {
            if (set.next()) {
                isColsed = true;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return isColsed;
    }

    public static void checkAcctCussentBeHolded(Context ctx, AccountViewCollection colAccount, String orgUnitId) throws BOSException, EASBizException {
        if (colAccount == null || colAccount.size() == 0) {
            return;
        }
        StringBuffer inAccount = new StringBuffer(" in (");
        int size = colAccount.size();
        for (int i = 0; i < size; ++i) {
            inAccount.append("'").append(colAccount.get(i).getId().toString()).append("'");
            if (i >= size - 1) continue;
            inAccount.append(",");
        }
        inAccount.append(")");
        String sql = "select top 1 cuss.faccountid, cur.fname_" + ctx.getLocale().toString() + " from t_gl_AcctCussent cuss, t_gl_VoucherAssistRecord ast, t_bd_Currency cur  where ast.FVerifiedCussentID = cuss.FID and cuss.fcurrencyid = cur.fid and cuss.FIsInit = 1 and ast.fisvierified=1 and  cuss.fcompanyid=? and cuss.FAccountID " + inAccount.toString();
        String sql2 = "select top 1 cuss.faccountid, cur.fname_" + ctx.getLocale().toString() + " from t_gl_AcctCussent cuss, T_GL_AcctCussentHistory ast, t_bd_Currency cur  where ast.FCussentidID = cuss.FID and ast.fcurrencyid = cur.fid and cuss.FIsInit = 1 and cuss.fcompanyid=? and cuss.FAccountID " + inAccount.toString();
        try {
            IRowSet rs2;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
            if (rs.next()) {
                String id = rs.getString(1);
                String currency = rs.getString(2);
                int size2 = colAccount.size();
                for (int i = 0; i < size2; ++i) {
                    AccountViewInfo info = colAccount.get(i);
                    if (!info.getId().toString().equals(id)) continue;
                    InitException e = new InitException(InitException.ACCT_BEHOLDED, new Object[]{info.getNumber() + " " + info.getName(), currency});
                    throw e;
                }
            }
            if ((rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{orgUnitId})).next()) {
                String id = rs2.getString(1);
                String currency = rs2.getString(2);
                int size3 = colAccount.size();
                for (int i = 0; i < size3; ++i) {
                    AccountViewInfo info = colAccount.get(i);
                    if (!info.getId().toString().equals(id)) continue;
                    InitException e = new InitException(InitException.ACCT_BEHOLDED, new Object[]{info.getNumber() + " " + info.getName(), currency});
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    protected static IObjectValue getPeriodInfo(Context ctx, int PeriodYear, int PeriodNumber, String periodType) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        IPeriod iPeriod = null;
        iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear)));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(PeriodNumber)));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType));
        evi.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(evi);
        if (periodCollection.size() > 0) {
            periodInfo = periodCollection.get(0);
        }
        return periodInfo;
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static String[] getPropOql(Context ctx, String prex, BOSObjectType type) {
        ArrayList<String> result = new ArrayList<String>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(type);
        PropertyCollection propCol = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo prop : propCol) {
            if (prop instanceof LinkPropertyInfo) {
                result.add(prex + prop.getName() + ".id");
                continue;
            }
            result.add(prex + prop.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public static IAcctCussent getAcctCussentCtrl(Context ctx) throws BOSException {
        return AcctCussentFactory.getLocalInstance(ctx);
    }

    public static IAssistantHG getHGCtrl(Context ctx) throws BOSException {
        return AssistantHGFactory.getLocalInstance((Context)ctx);
    }

    public static IGLFlag getFlagCtrl(Context ctx) throws BOSException {
        return GLFlagFactory.getLocalInstance(ctx);
    }

    public static String createTempTable(Context ctx, String sql, String desc) throws BOSException {
        long time = System.currentTimeMillis();
        String tableName = null;
        tableName = desc;
        sql = "create table " + tableName + " " + sql;
        try {
            tableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        time = System.currentTimeMillis() - time;
        logger.info((Object)(GLResUtil.getRes("create_tempTable") + tableName + GLResUtil.getRes("use_time2") + time + GLResUtil.getRes("millisecond")));
        return tableName;
    }

    public static void dropTempTable(Context ctx, String tableName) throws BOSException {
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void truncate(Connection con, String tableName) throws BOSException {
        PreparedStatement ps = null;
        try {
            String sql = "delete from " + tableName;
            ps = con.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    public static String getBigDecimalTrim0(BigDecimal bd) {
        if (bd == null) {
            return "";
        }
        String temp = bd.toString();
        int dot = temp.indexOf(".");
        if (dot == -1) {
            return temp;
        }
        int pos = -1;
        for (int i = temp.length() - 1; i > dot; --i) {
            if (temp.charAt(i) == '0') continue;
            pos = i + 1;
            break;
        }
        if (pos != -1) {
            return temp.substring(0, pos);
        }
        return temp.substring(0, dot);
    }

    public static void checkModifyStartPeriod(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        String sql = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = InitHelp.getConnection(ctx);
            sql = "select top 1 forgunitid from t_gl_initaccountbalance where forgunitid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new GLException(GLException.CANTMODIFYPERIOD);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 forgunitid from t_gl_initassistbalance where forgunitid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new GLException(GLException.CANTMODIFYPERIOD);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 fid from t_gl_acctcussent where fcompanyid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new GLException(GLException.CANTMODIFYPERIOD);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 fid from t_gl_voucher where fcompanyid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, orgUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new GLException(GLException.CANTMODIFYPERIOD);
            }
            IMIntObjectCheckFacadeFactory.getLocalInstance((Context)ctx).checkExistGLAcctIntObject(orgUnitId);
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
    }

    public static AsstActTypeCollection getAsstActTypes(Context ctx, AsstAccountInfo asstAccount, HashMap otherCtx) throws BOSException {
        IAsstActGroupDetail aa = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccount.getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("asstActType.id"));
        selector.add(new SelectorItemInfo("asstActType.name"));
        selector.add(new SelectorItemInfo("asstActType.number"));
        selector.add(new SelectorItemInfo("asstActType.*"));
        selector.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selector.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        selector.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        selector.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        SorterItemCollection sorter = view.getSorter();
        sorter.add(new SorterItemInfo("asstAccount.id"));
        AsstActGroupDetailCollection col = aa.getAsstActGroupDetailCollection(view);
        AsstActTypeCollection result = new AsstActTypeCollection();
        for (int i = 0; i < col.size(); ++i) {
            AsstActGroupDetailInfo detail = col.get(i);
            AsstActTypeInfo type = detail.getAsstActType();
            result.add(type);
        }
        return result;
    }

    public static Date beginDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date endDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static void doColseInit(Context ctx, String curCompanyID, String accountTableid) throws BOSException, SQLException {
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select startPeriod.*,currentPeriod.*,acPeriod.* where systemStatus.name=6 and company.id='" + curCompanyID + "'");
        StringBuffer sql = new StringBuffer();
        StringBuffer accountIDs = new StringBuffer();
        IRowSet set = null;
        if (ctrols.size() <= 0 || !ctrols.get(0).getCurrentPeriod().equals((Object)ctrols.get(0).getStartPeriod())) {
            sql.append(" select a.fid from t_bd_accountview a  ");
            sql.append(" left join t_gl_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='astinit' ");
            sql.append(" where( b.fvalue is null or b.fvalue='false') and a.fisleaf=1 and a.fcaa is not null and a.fcompanyid=? and a.faccounttableid=? ");
            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, accountTableid});
            while (set.next()) {
                if (!set.isFirst()) {
                    accountIDs.append(",");
                }
                accountIDs.append("'").append(set.getString("fid")).append("'");
            }
            if (accountIDs.length() > 0) {
                sql = new StringBuffer();
                sql.append(" delete from t_gl_flag where fname='astinit' and forgunitid = ? and fkey in (").append(accountIDs).append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID});
                sql = new StringBuffer();
                sql.append(" insert into t_gl_flag (fid, fname, fvalue, forgunitid, fkey) ");
                sql.append(" select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("'),");
                sql.append(" 'astinit','true','").append(curCompanyID).append("'").append(",av.fid \r\n");
                sql.append(" from t_bd_accountview av where av.fid in (").append(accountIDs).append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        sql = new StringBuffer();
        sql.append(" select a.fid from t_bd_accountview a ");
        sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = a.fcompanyid ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = 6 ");
        sql.append(" left join t_gl_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='cussentinit'  ");
        sql.append(" where( b.fvalue is null or b.fvalue='false') ");
        sql.append(" and a.fisleaf=1 and a.fcaa is not null  and a.fac=1  ");
        sql.append(" and a.fcompanyid=? and a.faccounttableid=? ");
        sql.append(" and (b.finitperiodid = ssc.fcurrentperiodid or b.finitperiodid is null) ");
        accountIDs = new StringBuffer();
        set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, accountTableid});
        while (set.next()) {
            if (!set.isFirst()) {
                accountIDs.append(",");
            }
            accountIDs.append("'").append(set.getString("fid")).append("'");
        }
        if (accountIDs.length() > 0) {
            if (ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod() != null) {
                PeriodInfo currentPeriod = ctrols.get(0).getCurrentPeriod();
                PeriodInfo acPeriod = ctrols.get(0).getAcPeriod();
                if (currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber() < acPeriod.getPeriodYear() * 100 + acPeriod.getPeriodNumber()) {
                    return;
                }
            }
            sql.setLength(0);
            sql.append(" delete from t_gl_flag where fname='cussentinit' and forgunitid = ? and fkey in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID});
            sql.setLength(0);
            sql.append(" insert into t_gl_flag ");
            sql.append(" select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("'),");
            sql.append(" 'cussentinit','true','").append(curCompanyID).append("'").append(",av.fid, \r\n");
            sql.append(" '").append(ctrols.get(0).getCurrentPeriod().getId().toString()).append("' ");
            sql.append(" from t_bd_accountview av where av.fid in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("UPDATE T_Gl_AcctCussent SET FISINITCLOSED = 1  WHERE  FISINIT =1 and FACCOUNTID in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public static AccountTableCollection getAccountTableCollection(Context ctx) throws BOSException {
        ArrayList<String> tableIdList = new ArrayList<String>();
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance((Context)ctx);
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance((Context)ctx);
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        AccountTableCollection tableInfosNew = new AccountTableCollection();
        for (AccountTableInfo tableInfo : tableInfos) {
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            tableInfosNew.add(tableInfo);
        }
        return tableInfosNew;
    }

    public static AccountTableCollection getAccountTableCollection(Context ctx, String companyId) throws BOSException {
        ArrayList<String> tableIdList = new ArrayList<String>();
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance((Context)ctx);
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)companyId));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance((Context)ctx);
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        AccountTableCollection tableInfosNew = new AccountTableCollection();
        for (AccountTableInfo tableInfo : tableInfos) {
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            tableInfosNew.add(tableInfo);
        }
        return tableInfosNew;
    }

    public static AccountViewCollection getInitedAsstAccountViewCollection(Context ctx, String[] accountIds, String orgUnitId, boolean isAllInitAsst) throws BOSException {
        if (accountIds == null || accountIds.length == 0) {
            return new AccountViewCollection();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < accountIds.length; ++i) {
            idSet.add(accountIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"astinit"));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("key", idSet, CompareType.INCLUDE));
        if (!isAllInitAsst) {
            filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true"));
        }
        view.setFilter(filter);
        GLFlagCollection flagColl = GLFlagFactory.getLocalInstance(ctx).getCollection(view);
        if (flagColl.size() == 0) {
            return new AccountViewCollection();
        }
        idSet.clear();
        for (int i = 0; i < flagColl.size(); ++i) {
            idSet.add(flagColl.get(i).getKey());
        }
        view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("iscfreeze"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.asstHGAttribute"));
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
    }

    public static AccountViewCollection getInitedAsstAccountViewCollection(Context ctx, String[] accountIds, String orgUnitId) throws BOSException {
        return InitHelp.getInitedAsstAccountViewCollection(ctx, accountIds, orgUnitId, false);
    }

    public static AccountViewCollection getInitedCussentAccountViewCollection(Context ctx, String[] accountIds, String orgUnitId) throws BOSException {
        if (accountIds == null || accountIds.length == 0) {
            return new AccountViewCollection();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < accountIds.length; ++i) {
            idSet.add(accountIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit"));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("key", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true"));
        view.setFilter(filter);
        GLFlagCollection flagColl = GLFlagFactory.getLocalInstance(ctx).getCollection(view);
        if (flagColl.size() == 0) {
            return new AccountViewCollection();
        }
        idSet.clear();
        for (int i = 0; i < flagColl.size(); ++i) {
            idSet.add(flagColl.get(i).getKey());
        }
        view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.asstHGAttribute"));
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
    }

    private static String[] getNotNeedCheckInitClosedAccounts(Context ctx, String orgUnitId, PeriodInfo periodInfo) throws BOSException {
        String sql = "select fkey from t_gl_flag where forgunitid = ? and fname='cussentinit' and fvalue='true' and finitperiodid = ?  union select flag.fkey from t_gl_flag flag inner join t_bd_period bp on flag.finitperiodid = bp.fid where forgunitid = ? and fname='cussentinit' and bp.fnumber > ?";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId, periodInfo.getId().toString(), orgUnitId, periodInfo.getNumber()});
        ArrayList<String> accountIds = new ArrayList<String>();
        try {
            while (result.next()) {
                String accountId = result.getString(1);
                accountIds.add(accountId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query cussent flag exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return accountIds.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectCollection getCanCloseInitAcctCussentAccount(Context ctx, HashMap otherCtx) throws BOSException {
        AccountViewCollection accountViewCollection;
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("currentPeriod");
        AccountViewCollection accountIds = InitHelp.getNotNeedCheckInitClosedAccounts(ctx, orgUnitId, currentPeriod);
        String tempTable = null;
        try {
            if (accountIds != null) {
                if (((String[])accountIds).length < 500) {
                    HashSet<String> idSet = new HashSet<String>();
                    for (String id : accountIds) {
                        idSet.add(id);
                    }
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.NOTINCLUDE));
                } else {
                    String createTableSql = "create table gl_temp_table (id varchar(44))";
                    ArrayList<String[]> paramsList = new ArrayList<String[]>();
                    try {
                        tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                        for (String id : accountIds) {
                            paramsList.add(new String[]{id});
                        }
                        String insertSql = "insert into " + tempTable + " values(?)";
                        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
                        filter.getFilterItems().add(new FilterItemInfo("id not in (select id from " + tempTable + " )"));
                    }
                    catch (Exception exception) {
                        logger.error((Object)(exception.getMessage() + "createTableSql : " + createTableSql));
                        throw new BOSException(exception.getMessage() + "createTableSql : " + createTableSql);
                    }
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgUnitId));
            filter.getFilterItems().add(new FilterItemInfo("AC", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttable));
            view.setFilter(filter);
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("iscfreeze"));
            sic.add(new SelectorItemInfo("caa.id"));
            sic.add(new SelectorItemInfo("accountTypeID.property"));
            sic.add(new SelectorItemInfo("accountTypeID.id"));
            accountViewCollection = av.getAccountViewCollection(view);
        }
        catch (Throwable throwable) {
            if (!StringUtils.isEmpty(tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
            throw throwable;
        }
        if (!StringUtils.isEmpty((String)tempTable)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        return accountViewCollection;
    }

    public static IObjectCollection getCanCloseInitAcAccountWhenCurrentPeriod(Context ctx, HashMap otherCtx) throws BOSException {
        return null;
    }

    public static boolean isVoucherExist(Context ctx, IObjectPK[] removePKList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        boolean returnValue = false;
        IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < removePKList.length; ++i) {
            fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
            fic.add(new FilterItemInfo("period.id", (Object)removePKList[i].toString()));
            filter.setMaskString("#0 and #1");
            boolean existsPosted = vchCtrl.exists(filter);
            if (existsPosted) {
                returnValue = true;
            }
            Iterator iter = fic.iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }
        return returnValue;
    }

    public static boolean isVoucherExist(Context ctx, String removePK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        boolean returnValue = false;
        IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
        fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
        fic.add(new FilterItemInfo("period.id", (Object)removePK));
        filter.setMaskString("#0 and #1");
        boolean existsPosted = vchCtrl.exists(filter);
        if (existsPosted) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean existVoucherBeforeRemove(Context ctx, IObjectPK[] updatePeriodPKList, PeriodCollection periodc) throws EASBizException, BOSException {
        PeriodInfo oldInfo = null;
        IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < updatePeriodPKList.length; ++i) {
            fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
            fic.add(new FilterItemInfo("period.id", (Object)updatePeriodPKList[i].toString()));
            filter.setMaskString("#0 and #1");
            boolean existsPosted = vchCtrl.exists(filter);
            if (existsPosted) {
                oldInfo = iPeriod.getPeriodInfo(updatePeriodPKList[i]);
                for (int j = 0; j < periodc.size(); ++j) {
                    if (periodc.get(j).getId() == null || !oldInfo.getId().toString().equals(periodc.get(j).getId().toString()) || oldInfo.getPeriodNumber() == periodc.get(j).getPeriodNumber()) continue;
                    return true;
                }
            }
            Iterator iter = fic.iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }
        return false;
    }

    public static void addRongYu4AcctCussent(Context ctx, AcctCussentInfo as, VoucherAssistRecordInfo var) throws BOSException {
        as.setVoucher(var.getBill());
        as.setEntry(var.getEntry());
        as.setIsVierified(var.isIsVierified());
        as.setAssGrp(var.getAssGrp());
        as.setVARBizDate(var.getBizDate());
        as.setEndDate(var.getEndDate());
        as.setQuantity(var.getQuantity());
        as.setOriginalAmount(var.getOriginalAmount());
        as.setLocalAmount(var.getLocalAmount());
        as.setReportingAmount(var.getReportingAmount());
        as.setSettlementCode(var.getSettlementCode());
        as.setBizNumber(var.getBizNumber());
        as.put("customer", var.get("customer"));
        as.put("supplier", var.get("supplier"));
        as.put("orgUnit", var.get("orgUnit"));
        as.put("material", var.get("material"));
        as.put("settlementType", var.get("settlementType"));
        as.put("handler", var.get("handler"));
        as.setTicketNumber(var.getTicketNumber());
        as.setInvoiceNumber(var.getInvoiceNumber());
        as.setFeeType(var.getFeeType());
        as.setDescription(var.getDescription());
        if (as.isIsInit()) {
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)initPeriodID));
            SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select startPeriod.id,startPeriod.number,startPeriod.beginDate,currentPeriod.id,currentPeriod.number,currentPeriod.beginDate,acPeriod.id,acPeriod.number,acPeriod.beginDate where systemStatus.name=6 and company.id='" + as.getCompany().getId().toString() + "'");
            if (ctrols.size() > 0 && ctrols.get(0).getCurrentPeriod() != null) {
                PeriodInfo acPeriod;
                PeriodInfo startPeriod = ctrols.get(0).getStartPeriod();
                PeriodInfo currentPeriod = ctrols.get(0).getCurrentPeriod();
                PeriodInfo periodInfo = acPeriod = ctrols.get(0).getAcPeriod() == null ? startPeriod : ctrols.get(0).getAcPeriod();
                if (currentPeriod.getNumber() > acPeriod.getNumber()) {
                    as.setBookedDate(currentPeriod.getBeginDate());
                    period = currentPeriod;
                }
            }
            as.setPeriod(period);
            as.setIsPost(true);
        }
    }

    public static boolean isUseAsstQty() {
        return useAsstQty;
    }

    public static void setUseAsstQty(boolean useAsstQty) {
    }

    public static SystemStatusCtrolCollection checkIsAlia(Context ctx, PeriodInfo period, String companyId) throws EASBizException, BOSException {
        Integer iYear = new Integer(period.getPeriodYear());
        Integer iMonth = new Integer(period.getPeriodNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)companyId));
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue()), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("isStart", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isRelatedAccount", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("relatedPeriod.periodYear", (Object)iYear));
        fic.add(new FilterItemInfo("relatedPeriod.periodNumber", (Object)iMonth));
        filter.setMaskString("#0 and #1 and #2 and #3  and #4 and #5");
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        return col;
    }

    public static boolean existsAsstOrAcctcussentNotInit(Context ctx, String curCompanyID, String accountTableid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        boolean allowCussent = GlUtils.getDefaultGLParam(ctx, curCompanyID, "GL_028");
        if (!allowCussent) {
            return false;
        }
        sql = new StringBuffer();
        sql.append(" select a.fid from t_bd_accountview a ");
        sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = a.fcompanyid ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = 6 ");
        sql.append(" left join t_gl_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='cussentinit'  ");
        sql.append(" where( b.fvalue is null or b.fvalue='false') ");
        sql.append(" and a.fisleaf=1 and a.fcaa is not null  and a.fac=1  ");
        sql.append(" and a.fcompanyid=? and a.faccounttableid=? ");
        sql.append(" and b.finitperiodid = ssc.fcurrentperiodid ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, accountTableid});
        try {
            return set.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static StringBuffer checkCanCloseInitAbountAcctCussent(Context ctx, String curCompanyID, String accounttableid, Connection con) throws BOSException {
        StringBuffer stringBuffer;
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.fid as FAccountID, ");
        sql.append(" a.FNumber as FAccountNumber, ");
        sql.append(" a.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" as FAccountName ");
        sql.append(" from t_bd_accountview a ");
        sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = a.fcompanyid ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = 6 ");
        sql.append(" left join t_gl_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='cussentinit'  ");
        sql.append(" where(b.fvalue is null or b.fvalue='false')");
        sql.append(" and a.fisleaf=1 and a.fcaa is not null  and a.fac=1");
        sql.append(" and a.fcompanyid=? and a.faccounttableid=?");
        sql.append(" and (b.finitperiodid = ssc.fcurrentperiodid or b.finitperiodid is null)");
        sql.append(" order by FAccountNumber");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
            rs = stmt.executeQuery();
            StringBuffer errMsg = new StringBuffer();
            while (rs.next()) {
                errMsg.append(rs.getString("FAccountNumber"));
                errMsg.append(" ");
                errMsg.append(rs.getString("FAccountName"));
                errMsg.append(";");
            }
            stringBuffer = errMsg;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"check acctcussent account can closeinit exception.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return stringBuffer;
    }

    public static IObjectCollection getNotCloseInitAcctAccountInCurrentPeriod(Context ctx, HashMap otherCtx) throws BOSException {
        int index;
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"false", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", (Object)currentPeriod.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        GLFlagCollection flagCollection = flag.getCollection(view);
        String[] accountIds = null;
        int size = flagCollection.size();
        if (size > 0) {
            accountIds = new String[size];
            for (int i = 0; i < size; ++i) {
                GLFlagInfo flagInfo = flagCollection.get(i);
                accountIds[i] = flagInfo.getKey();
            }
        } else {
            return new AccountViewCollection();
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        if (accountIds != null) {
            for (int i = 0; i < accountIds.length; ++i) {
                mask.append("#").append(i);
                if (i != accountIds.length - 1) {
                    mask.append(" or ");
                }
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIds[i], CompareType.EQUALS));
            }
            if (mask.length() != 0) {
                filter.setMaskString("(" + mask.toString() + ")");
            }
        }
        if ((index = filter.getFilterItems().size()) > 0) {
            mask.append(" and ");
        }
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgUnitId));
        mask.append("#" + index++);
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)new Integer(1)));
        mask.append(" and #" + index++);
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        mask.append(" and #" + index++);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttable));
        mask.append(" and #" + index++);
        filter.setMaskString(mask.toString());
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("caa.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        return av.getAccountViewCollection(view);
    }

    public static PostVoucherCheckReturn[] getCussentInitInPeriod(Context ctx, String curCompanyID) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.fnumber from t_bd_accountview a");
        sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = a.fcompanyid");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = 6");
        sql.append(" left join t_gl_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='cussentinit'");
        sql.append(" where b.fvalue='true'");
        sql.append(" and a.fisleaf=1 and a.fcaa is not null  and a.fac=1");
        sql.append(" and a.fcompanyid=?");
        sql.append(" and b.finitperiodid = ssc.fcurrentperiodid");
        StringBuffer accountNumber = new StringBuffer();
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID});
        while (set.next()) {
            if (!set.isFirst()) {
                accountNumber.append(",");
            }
            accountNumber.append(set.getString("fnumber"));
        }
        if (!accountNumber.toString().isEmpty()) {
            PostVoucherCheckReturn ret = new PostVoucherCheckReturn();
            ret.setAccountNumber(accountNumber.toString());
            return new PostVoucherCheckReturn[]{ret};
        }
        return null;
    }

    public static String[] getCussentInitAccount(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currentPeriod, boolean isClose) throws BOSException {
        String orgUnitId = company.getId().toString();
        String periodId = currentPeriod.getId().toString();
        String value = isClose ? "true" : "false";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)value));
        filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", (Object)periodId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = GLFlagFactory.getLocalInstance(ctx).getCollection(view);
        String[] results = null;
        int size = col.size();
        if (size > 0) {
            results = new String[size];
            for (int i = 0; i < size; ++i) {
                GLFlagInfo flagInfo = col.get(i);
                results[i] = flagInfo.getKey();
            }
        }
        return results;
    }

    public static IObjectCollection getCanCloseInitAcctCussentAccountCurrentPeriod(Context ctx, HashMap otherCtx) throws BOSException {
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"false", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", (Object)currentPeriod.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", null));
        int index = 0;
        StringBuilder maskString = new StringBuilder("(");
        maskString.append("#").append(index++).append(" and #").append(index++).append(" and #").append(index++);
        maskString.append(" and (#").append(index++).append(" or #").append(index++).append(")");
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        GLFlagCollection flagCollection = flag.getCollection(view);
        String[] accountIds = null;
        int size = flagCollection.size();
        if (size > 0) {
            accountIds = new String[size];
            for (int i = 0; i < size; ++i) {
                GLFlagInfo flagInfo = flagCollection.get(i);
                accountIds[i] = flagInfo.getKey();
            }
        } else {
            return new AccountViewCollection();
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        if (accountIds != null) {
            for (int i = 0; i < accountIds.length; ++i) {
                mask.append("#").append(i);
                if (i != accountIds.length - 1) {
                    mask.append(" or ");
                }
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIds[i], CompareType.EQUALS));
            }
            if (mask.length() != 0) {
                filter.setMaskString("(" + mask.toString() + ")");
            }
        }
        if ((index = filter.getFilterItems().size()) > 0) {
            mask.append(" and ");
        }
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgUnitId));
        mask.append("#" + index++);
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)new Integer(1)));
        mask.append(" and #" + index++);
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        mask.append(" and #" + index++);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttable));
        mask.append(" and #" + index++);
        filter.setMaskString(mask.toString());
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("caa.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        return av.getAccountViewCollection(view);
    }

    public static void checkAcctCussentInit(Context ctx, CompanyOrgUnitInfo company, Map hmParamValue, boolean isAllInitAsst) throws BOSException, GLException, EASBizException {
        Boolean allowCussent = Boolean.valueOf((String)hmParamValue.get("GL_028"));
        Boolean foreignCurrencySU = Boolean.valueOf(String.valueOf(hmParamValue.get("GL_008")));
        if (allowCussent.booleanValue()) {
            Boolean useReportingCurrency = Boolean.valueOf(String.valueOf(hmParamValue.get("G001")));
            HashMap<String, Object> otherCtx = new HashMap<String, Object>();
            otherCtx.put("COMPANY", company);
            otherCtx.put("ACCOUNTTABLEID", company.getAccountTable().getId().toString());
            otherCtx.put("ISUSEREPORT", useReportingCurrency);
            otherCtx.put("ISFOREIGN", foreignCurrencySU);
            otherCtx.put("isAllInitAsst", isAllInitAsst);
            SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select startPeriod.*,currentPeriod.*,acPeriod.* where systemStatus.name=6 and company.id='" + company.getId().toString() + "'");
            if (ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod() != null) {
                if (ctrols.get(0).getCurrentPeriod().getId().toString().equals(ctrols.get(0).getAcPeriod().getId().toString())) {
                    try {
                        StringBuffer sql2 = new StringBuffer();
                        sql2.append("select cussent.fid from t_gl_acctcussent cussent where cussent.fisinit=1 and cussent.FIsInitClosed=0 and cussent.fcompanyid=?");
                        sql2.append(" and exists (select 1 from t_gl_flag flag where cussent.FACCOUNTID = flag.fkey and flag.fname='cussentinit' and flag.finitperiodid = ?)");
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])new Object[]{company.getId().toString(), ctrols.get(0).getCurrentPeriod().getId().toString()});
                        if (rs2.next()) {
                            throw new GLException(GLException.INIT_CUSSENT_WHEN_PERIODCLOSE);
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                    otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                    otherCtx.put("ACPeriod", ctrols.get(0).getAcPeriod());
                    otherCtx.put("currentPeriod", ctrols.get(0).getCurrentPeriod());
                    IObjectCollection col = InitHelp.getCanCloseInitAcctCussentAccount(ctx, otherCtx);
                    if (col != null && col.size() > 0) {
                        AccountViewCollection avCol = (AccountViewCollection)col;
                        int size = avCol.size();
                        String[] accounts = new String[size];
                        for (int i = 0; i < size; ++i) {
                            AccountViewInfo info = avCol.get(i);
                            accounts[i] = info.getId().toString();
                        }
                        avCol = InitHelp.getInitedAsstAccountViewCollection(ctx, accounts, company.getId().toString());
                        InitHelp.checkAsstEqualCussent(ctx, avCol, otherCtx);
                    }
                } else if (ctrols.get(0).getCurrentPeriod().getNumber() > ctrols.get(0).getAcPeriod().getNumber()) {
                    otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                    otherCtx.put("ACPeriod", ctrols.get(0).getAcPeriod());
                    otherCtx.put("isAfterAcPeriod", Boolean.TRUE);
                    otherCtx.put("CURRENTPERIOD", ctrols.get(0).getCurrentPeriod());
                    IObjectCollection col = InitHelp.getNotCloseInitAcctAccountInCurrentPeriod(ctx, otherCtx);
                    InitHelp.doCheckCussentInit(ctx, col, otherCtx);
                }
            } else if (ctrols.size() > 0 && ctrols.get(0).getAcPeriod() == null) {
                if (ctrols.get(0).getCurrentPeriod().getId().toString().equals(ctrols.get(0).getStartPeriod().getId().toString())) {
                    otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                    otherCtx.put("ACPeriod", ctrols.get(0).getStartPeriod());
                    otherCtx.put("CURRENTPERIOD", ctrols.get(0).getCurrentPeriod());
                } else {
                    otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                    otherCtx.put("ACPeriod", ctrols.get(0).getStartPeriod());
                    otherCtx.put("isAfterAcPeriod", Boolean.TRUE);
                    otherCtx.put("CURRENTPERIOD", ctrols.get(0).getCurrentPeriod());
                }
                IObjectCollection col = InitHelp.getNotCloseInitAcctAccountInCurrentPeriod(ctx, otherCtx);
                InitHelp.doCheckCussentInit(ctx, col, otherCtx);
            }
        }
    }

    private static void doCheckCussentInit(Context ctx, IObjectCollection col, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        if (col != null && col.size() > 0) {
            AccountViewCollection avCol = (AccountViewCollection)col;
            int size = avCol.size();
            String[] accounts = new String[size];
            for (int i = 0; i < size; ++i) {
                AccountViewInfo info = avCol.get(i);
                accounts[i] = info.getId().toString();
            }
            avCol = InitHelp.getInitedAsstAccountViewCollection(ctx, accounts, orgUnitId, otherCtx.containsKey("isAllInitAsst") && (Boolean)otherCtx.get("isAllInitAsst") != false);
            InitHelp.checkAsstEqualCussent(ctx, avCol, otherCtx);
        }
    }
}

