/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PLVoucherEntrySplitStrategy
implements ITAccountSplitStrategy {
    protected static final Logger logger = Logger.getLogger(PLVoucherEntrySplitStrategy.class);
    public static final String cashflowAccountDiff = "cashflowAccountDiff";
    public static final String cashflowRecords = "cashflowRecords";
    public static final String cashflowSplitRecords = "cashflowSplitRecords";

    private PLVoucherEntrySplitStrategy() {
    }

    public static ITAccountSplitStrategy getInstance() {
        return new PLVoucherEntrySplitStrategy();
    }

    @Override
    public CashflowSplitRecordCollection split(Context ctx, VoucherInfo voucherInfo, Map<String, Object> params) throws EASBizException, BOSException {
        long currTime = System.currentTimeMillis();
        if (voucherInfo.getSourceType() == SourceType.PROFIT_AND_LOSS) {
            return new CashflowSplitRecordCollection();
        }
        Map cfAccountDiffMap = null;
        if (params != null) {
            cfAccountDiffMap = (Map)params.get(cashflowAccountDiff);
        }
        if (cfAccountDiffMap == null) {
            cfAccountDiffMap = CashFlowUtils.getDifferenceMap(ctx, voucherInfo.getCompany().getId().toString());
        }
        if (!this.hasPLAccount(ctx, voucherInfo, cfAccountDiffMap)) {
            return new CashflowSplitRecordCollection();
        }
        CashflowRecordCollection cfColl = null;
        CashflowSplitRecordCollection splitColl = null;
        if (params != null) {
            cfColl = (CashflowRecordCollection)params.get(cashflowRecords);
            splitColl = (CashflowSplitRecordCollection)params.get(cashflowSplitRecords);
        }
        VoucherEntryCollection newEtryColl = this.deductCashflow(voucherInfo, cfColl, splitColl);
        VoucherEntryCollection[] entryColls = this.groupVoucherEntry(voucherInfo, newEtryColl, cfAccountDiffMap);
        boolean isAutoDispose = GlUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_0151");
        if (isAutoDispose) {
            this.disposePL(ctx, voucherInfo, entryColls[1], entryColls[2]);
        }
        CashflowSplitRecordCollection plSplitColl = this.splitPL(ctx, voucherInfo, entryColls[0], entryColls[1], entryColls[2]);
        logger.info((Object)("PL split take " + (System.currentTimeMillis() - currTime) + " ms."));
        return plSplitColl;
    }

    private VoucherEntryCollection deductCashflow(VoucherInfo voucherInfo, CashflowRecordCollection cfColl, CashflowSplitRecordCollection splitColl) {
        VoucherEntryInfo oppEntry;
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        VoucherEntryCollection cfEntryColl = new VoucherEntryCollection();
        HashMap<BOSUuid, VoucherEntryInfo> voucherEntryMap = new HashMap<BOSUuid, VoucherEntryInfo>();
        Iterator itEntry = entryColl.iterator();
        VoucherEntryInfo voucherEntryInfo = null;
        while (itEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)itEntry.next();
            if (voucherEntryInfo.getId() == null) continue;
            voucherEntryMap.put(voucherEntryInfo.getId(), voucherEntryInfo);
        }
        if (cfColl != null) {
            for (CashflowRecordInfo cfRecordInfo : cfColl) {
                VoucherEntryInfo entry = cfRecordInfo.getEntry();
                entry = (VoucherEntryInfo)voucherEntryMap.get(entry.getId());
                BigDecimal[] amount = new BigDecimal[]{cfRecordInfo.getOriginalAmount(), cfRecordInfo.getLocalAmount(), cfRecordInfo.getReportingAmount()};
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry);
                if (cfRecordInfo.getItemFlag() == ItemFlag.DISPOSE) continue;
                oppEntry = cfRecordInfo.getOpposingAccountEntry();
                oppEntry = (VoucherEntryInfo)voucherEntryMap.get(oppEntry.getId());
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry, oppEntry);
            }
        }
        if (splitColl != null) {
            for (CashflowSplitRecordInfo splitInfo : splitColl) {
                BigDecimal[] amount = new BigDecimal[]{splitInfo.getOriginalAmount(), splitInfo.getLocalAmount(), splitInfo.getReportingAmount()};
                VoucherEntryInfo entry = splitInfo.getEntry();
                if (entry.getId() != null) {
                    entry = this.getVoucherEntryInfo(entryColl, entry.getId());
                    this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry);
                }
                if ((oppEntry = splitInfo.getOpposingAccountEntry()).getId() == null) continue;
                oppEntry = this.getVoucherEntryInfo(entryColl, oppEntry.getId());
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry, oppEntry);
            }
        }
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        Iterator entryIt = entryColl.iterator();
        VoucherEntryInfo tmpEntry = null;
        while (entryIt.hasNext()) {
            tmpEntry = (VoucherEntryInfo)entryIt.next();
            if (CashFlowUtils.isCashAccount(tmpEntry.getAccount()) || tmpEntry.getAccount().isBudget()) continue;
            VoucherEntryInfo newEntry = cfEntryColl.get((Object)tmpEntry.getId());
            if (newEntry == null) {
                newEntry = new VoucherEntryInfo();
                newEntry.setId(tmpEntry.getId());
                newEntry.setAccount(tmpEntry.getAccount());
                newEntry.setBill(voucherInfo);
                newEntry.setCurrency(tmpEntry.getCurrency());
                newEntry.setLocalAmount(tmpEntry.getLocalAmount());
                newEntry.setOriginalAmount(tmpEntry.getOriginalAmount());
                newEntry.setReportingAmount(tmpEntry.getReportingAmount());
                newEntry.setEntryDC(tmpEntry.getEntryDC());
                newEntry.setSeq(tmpEntry.getSeq());
                newEntry.setLocalExchangeRate(tmpEntry.getLocalExchangeRate());
                newEntry.setPrimaryItem(tmpEntry.getPrimaryItem());
                newEntry.setSupplementaryItem(tmpEntry.getSupplementaryItem());
            }
            if (newEntry.getLocalAmount().doubleValue() == 0.0) continue;
            newEntryColl.add(newEntry);
        }
        return newEntryColl;
    }

    private VoucherEntryInfo getVoucherEntryInfo(VoucherEntryCollection entryColl, BOSUuid entryId) {
        VoucherEntryInfo entry2 = entryColl.get((Object)entryId);
        if (entry2 != null) {
            return entry2;
        }
        for (VoucherEntryInfo entry2 : entryColl) {
            if (!entry2.getId().equals((Object)entryId)) continue;
            return entry2;
        }
        return null;
    }

    private void deductCashflow(VoucherInfo voucherInfo, VoucherEntryCollection entryColl, VoucherEntryCollection cfEntryColl, BigDecimal[] amount, VoucherEntryInfo entry, VoucherEntryInfo oppEntry) {
        if (oppEntry != null && !CashFlowUtils.isCashAccount(oppEntry.getAccount())) {
            VoucherEntryInfo newEntry = (VoucherEntryInfo)cfEntryColl.getObject((Object)oppEntry.getId());
            if (newEntry == null) {
                newEntry = new VoucherEntryInfo();
                newEntry.setId(oppEntry.getId());
                newEntry.setAccount(oppEntry.getAccount());
                newEntry.setBill(voucherInfo);
                newEntry.setCurrency(oppEntry.getCurrency());
                newEntry.setLocalAmount(oppEntry.getLocalAmount());
                newEntry.setOriginalAmount(oppEntry.getOriginalAmount());
                newEntry.setReportingAmount(oppEntry.getReportingAmount());
                newEntry.setEntryDC(oppEntry.getEntryDC());
                newEntry.setSeq(oppEntry.getSeq());
                newEntry.setLocalExchangeRate(oppEntry.getLocalExchangeRate());
                newEntry.setPrimaryItem(oppEntry.getPrimaryItem());
                newEntry.setSupplementaryItem(oppEntry.getSupplementaryItem());
                cfEntryColl.add(newEntry);
            }
            BigDecimal origAmount = amount[0];
            BigDecimal localAmount = amount[1];
            BigDecimal rptAmount = amount[2];
            if (entry.getEntryDC() == oppEntry.getEntryDC()) {
                origAmount = origAmount.negate();
                localAmount = localAmount.negate();
                rptAmount = rptAmount.negate();
            }
            newEntry.setLocalAmount(newEntry.getLocalAmount().subtract(localAmount));
            newEntry.setOriginalAmount(newEntry.getOriginalAmount().subtract(origAmount));
            newEntry.setReportingAmount(newEntry.getReportingAmount().subtract(rptAmount));
        }
    }

    private void deductCashflow(VoucherInfo voucherInfo, VoucherEntryCollection entryColl, VoucherEntryCollection cfEntryColl, BigDecimal[] amount, VoucherEntryInfo entry) {
        if (entry != null && !CashFlowUtils.isCashAccount(entry.getAccount())) {
            VoucherEntryInfo newEntry = (VoucherEntryInfo)cfEntryColl.getObject((Object)entry.getId());
            if (newEntry == null) {
                newEntry = new VoucherEntryInfo();
                newEntry.setId(entry.getId());
                newEntry.setAccount(entry.getAccount());
                newEntry.setBill(voucherInfo);
                newEntry.setCurrency(entry.getCurrency());
                newEntry.setLocalAmount(entry.getLocalAmount());
                newEntry.setOriginalAmount(entry.getOriginalAmount());
                newEntry.setReportingAmount(entry.getReportingAmount());
                newEntry.setEntryDC(entry.getEntryDC());
                newEntry.setSeq(entry.getSeq());
                newEntry.setLocalExchangeRate(entry.getLocalExchangeRate());
                newEntry.setPrimaryItem(entry.getPrimaryItem());
                newEntry.setSupplementaryItem(entry.getSupplementaryItem());
                cfEntryColl.add(newEntry);
            }
            newEntry.setOriginalAmount(newEntry.getOriginalAmount().subtract(amount[0]));
            newEntry.setLocalAmount(newEntry.getLocalAmount().subtract(amount[1]));
            newEntry.setReportingAmount(newEntry.getReportingAmount().subtract(amount[2]));
        }
    }

    private CashflowSplitRecordCollection splitPL(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection newEntryColl, VoucherEntryCollection debitEntryColl, VoucherEntryCollection creditEntryColl) {
        CashflowSplitRecordCollection splitColl = new CashflowSplitRecordCollection();
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, debitEntryColl, false));
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, creditEntryColl, false));
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, debitEntryColl, true));
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, creditEntryColl, true));
        splitColl.addCollection(this.disposePLSplitColl(ctx, voucherInfo, debitEntryColl, creditEntryColl));
        return splitColl;
    }

    private CashflowSplitRecordCollection splitPL(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection newEntryColl, VoucherEntryCollection plEntryColl, boolean isSameDC) {
        CashflowSplitRecordCollection splitColl = new CashflowSplitRecordCollection();
        Iterator plEntryIt = plEntryColl.iterator();
        int plEntrySize = plEntryColl.size();
        block0: while (plEntryIt.hasNext()) {
            VoucherEntryInfo plEntry = (VoucherEntryInfo)plEntryIt.next();
            Iterator newEntryIt = newEntryColl.iterator();
            while (newEntryIt.hasNext()) {
                VoucherEntryInfo newEntry = (VoucherEntryInfo)newEntryIt.next();
                if (isSameDC) {
                    if (newEntry.getEntryDC() == plEntry.getEntryDC() && newEntry.getLocalAmount().signum() != plEntry.getLocalAmount().signum()) {
                        splitColl.add(this.splitSingleDC(ctx, voucherInfo, plEntryIt, plEntry, newEntryIt, newEntry));
                    }
                } else if (newEntry.getEntryDC() != plEntry.getEntryDC() && newEntry.getLocalAmount().signum() == plEntry.getLocalAmount().signum()) {
                    splitColl.add(this.splitDebitAndCredit(ctx, voucherInfo, plEntryIt, plEntry, newEntryIt, newEntry));
                }
                if (plEntryColl.size() >= plEntrySize) continue;
                plEntrySize = plEntryColl.size();
                continue block0;
            }
        }
        return splitColl;
    }

    private CashflowSplitRecordInfo splitSingleDC(Context ctx, VoucherInfo voucherInfo, Iterator plEntryIt, VoucherEntryInfo plEntry, Iterator newEntryIt, VoucherEntryInfo newEntry) {
        BigDecimal minLocValue = plEntry.getLocalAmount();
        BigDecimal minOrgValue = plEntry.getOriginalAmount();
        BigDecimal minRptValue = plEntry.getReportingAmount();
        if (minLocValue.abs().compareTo(newEntry.getLocalAmount().abs()) < 0) {
            plEntryIt.remove();
            if (newEntry.getLocalExchangeRate().compareTo(BigDecimal.ZERO) != 0) {
                int scale = newEntry.getOriginalAmount().scale() != 0 ? newEntry.getOriginalAmount().scale() : (newEntry.getCurrency() != null && newEntry.getCurrency().getPrecision() > 0 ? newEntry.getCurrency().getPrecision() : 4);
                newEntry.setOriginalAmount(newEntry.getOriginalAmount().add(plEntry.getOriginalAmount().multiply(plEntry.getLocalExchangeRate()).divide(newEntry.getLocalExchangeRate(), scale, 4)));
            }
            newEntry.setLocalAmount(newEntry.getLocalAmount().add(plEntry.getLocalAmount()));
            newEntry.setReportingAmount(newEntry.getReportingAmount().add(plEntry.getReportingAmount()));
        } else if (plEntry.getLocalAmount().abs().compareTo(newEntry.getLocalAmount().abs()) > 0) {
            newEntryIt.remove();
            minLocValue = newEntry.getLocalAmount().negate();
            minOrgValue = newEntry.getOriginalAmount().negate();
            minRptValue = newEntry.getReportingAmount().negate();
            if (plEntry.getLocalExchangeRate().compareTo(BigDecimal.ZERO) != 0) {
                int scale = plEntry.getOriginalAmount().scale() != 0 ? plEntry.getOriginalAmount().scale() : (plEntry.getCurrency() != null && plEntry.getCurrency().getPrecision() > 0 ? plEntry.getCurrency().getPrecision() : 4);
                plEntry.setOriginalAmount(plEntry.getOriginalAmount().add(newEntry.getOriginalAmount().multiply(newEntry.getLocalExchangeRate()).divide(plEntry.getLocalExchangeRate(), scale, 4)));
            }
            plEntry.setLocalAmount(plEntry.getLocalAmount().add(newEntry.getLocalAmount()));
            plEntry.setReportingAmount(plEntry.getReportingAmount().add(newEntry.getReportingAmount()));
        } else {
            newEntryIt.remove();
            plEntryIt.remove();
        }
        return this.createCashflowSplitRecordInfo(ctx, voucherInfo, plEntry, newEntry, minLocValue, minOrgValue, minRptValue);
    }

    private CashflowSplitRecordInfo createCashflowSplitRecordInfo(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entry, VoucherEntryInfo oppEntry, BigDecimal locAmount, BigDecimal orgAmount, BigDecimal rptAmount) {
        CashflowSplitRecordInfo splitInfo = new CashflowSplitRecordInfo();
        splitInfo.setVoucher(voucherInfo);
        splitInfo.setEntry(entry);
        splitInfo.setAccount(entry.getAccount());
        splitInfo.setCurrency(entry.getCurrency());
        splitInfo.setEntryDC(entry.getEntryDC());
        splitInfo.setOpposingAccountEntry(oppEntry);
        splitInfo.setOppAccount(oppEntry.getAccount());
        splitInfo.setOppEntryDC(oppEntry.getEntryDC());
        splitInfo.setIsSupItem(voucherInfo.isHasCashAccount());
        splitInfo.setItemFlag(ItemFlag.SUPPLEMENTARY);
        splitInfo.setSourceType(1);
        splitInfo.setOriginalAmount(orgAmount);
        splitInfo.setLocalAmount(locAmount);
        splitInfo.setReportingAmount(rptAmount);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        splitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitInfo.setCreateTime(nowTime);
        splitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitInfo.setLastUpdateTime(nowTime);
        return splitInfo;
    }

    private CashflowSplitRecordInfo splitDebitAndCredit(Context ctx, VoucherInfo voucherInfo, Iterator plEntryIt, VoucherEntryInfo plEntry, Iterator newEntryIt, VoucherEntryInfo newEntry) {
        BigDecimal minLocValue = plEntry.getLocalAmount();
        BigDecimal minOrgValue = plEntry.getOriginalAmount();
        BigDecimal minRptValue = plEntry.getReportingAmount();
        if (minLocValue.abs().compareTo(newEntry.getLocalAmount().abs()) < 0) {
            plEntryIt.remove();
            if (newEntry.getLocalExchangeRate().compareTo(BigDecimal.ZERO) != 0) {
                int scale = newEntry.getOriginalAmount().scale() != 0 ? newEntry.getOriginalAmount().scale() : (newEntry.getCurrency() != null && newEntry.getCurrency().getPrecision() > 0 ? newEntry.getCurrency().getPrecision() : 4);
                newEntry.setOriginalAmount(newEntry.getOriginalAmount().subtract(plEntry.getOriginalAmount().multiply(plEntry.getLocalExchangeRate()).divide(newEntry.getLocalExchangeRate(), scale, 4)));
            }
            newEntry.setLocalAmount(newEntry.getLocalAmount().subtract(plEntry.getLocalAmount()));
            newEntry.setReportingAmount(newEntry.getReportingAmount().subtract(plEntry.getReportingAmount()));
        } else if (plEntry.getLocalAmount().abs().compareTo(newEntry.getLocalAmount().abs()) > 0) {
            newEntryIt.remove();
            minLocValue = newEntry.getLocalAmount();
            minOrgValue = newEntry.getOriginalAmount();
            minRptValue = newEntry.getReportingAmount();
            if (plEntry.getLocalExchangeRate().compareTo(BigDecimal.ZERO) != 0) {
                int scale = plEntry.getOriginalAmount().scale() != 0 ? plEntry.getOriginalAmount().scale() : (plEntry.getCurrency() != null && plEntry.getCurrency().getPrecision() > 0 ? plEntry.getCurrency().getPrecision() : 4);
                plEntry.setOriginalAmount(plEntry.getOriginalAmount().subtract(newEntry.getOriginalAmount().multiply(newEntry.getLocalExchangeRate()).divide(plEntry.getLocalExchangeRate(), scale, 4)));
            }
            plEntry.setLocalAmount(plEntry.getLocalAmount().subtract(newEntry.getLocalAmount()));
            plEntry.setReportingAmount(plEntry.getReportingAmount().subtract(newEntry.getReportingAmount()));
        } else {
            newEntryIt.remove();
            plEntryIt.remove();
        }
        return this.createCashflowSplitRecordInfo(ctx, voucherInfo, plEntry, newEntry, minLocValue, minOrgValue, minRptValue);
    }

    private void disposePL(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection debitEntryColl, VoucherEntryCollection creditEntryColl) throws EASBizException, BOSException {
        CashflowRecordCollection disposeColl = this.disposePLColl(ctx, voucherInfo, debitEntryColl, creditEntryColl);
        if (disposeColl.size() > 0) {
            boolean canAddNew = true;
            for (int i = 1; i <= disposeColl.size(); ++i) {
                CashflowRecordInfo record = disposeColl.get(i - 1);
                record.setSeq(i);
                if (record.getOpposingAccountEntry().getId() != null) continue;
                canAddNew = false;
                logger.error((Object)"PL split opportunity is not right! VoucherEntryId is not yet created");
            }
            if (canAddNew) {
                CashflowRecordFactory.getLocalInstance(ctx).addNewBatch(disposeColl);
            }
        }
    }

    private CashflowRecordCollection disposePLColl(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection debitEntryColl, VoucherEntryCollection creditEntryColl) {
        CashflowRecordCollection disposeColl = new CashflowRecordCollection();
        disposeColl.addCollection(this.disposeDebitAndCredit(ctx, voucherInfo, debitEntryColl, creditEntryColl));
        disposeColl.addCollection(this.disposeSingleDC(ctx, voucherInfo, debitEntryColl));
        disposeColl.addCollection(this.disposeSingleDC(ctx, voucherInfo, creditEntryColl));
        return disposeColl;
    }

    private CashflowSplitRecordCollection disposePLSplitColl(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection debitEntryColl, VoucherEntryCollection creditEntryColl) {
        CashflowRecordCollection disposeColl = this.disposePLColl(ctx, voucherInfo, debitEntryColl, creditEntryColl);
        CashflowSplitRecordCollection disposeSplitColl = new CashflowSplitRecordCollection();
        for (CashflowRecordInfo cfInfo : disposeColl) {
            CashflowSplitRecordInfo cfSplitInfo = new CashflowSplitRecordInfo();
            cfSplitInfo.putAll((IObjectValue)cfInfo);
            disposeSplitColl.add(cfSplitInfo);
        }
        return disposeSplitColl;
    }

    private CashflowRecordCollection disposeSingleDC(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection entryColl) {
        CashflowRecordCollection disposeColl = new CashflowRecordCollection();
        Iterator entryIt = entryColl.iterator();
        VoucherEntryInfo firstEntry = null;
        VoucherEntryInfo entry = null;
        VoucherEntryInfo tmpEntry = null;
        while (entryIt.hasNext()) {
            entry = (VoucherEntryInfo)entryIt.next();
            if (firstEntry == null) {
                firstEntry = entry;
                continue;
            }
            if (!entry.getCurrency().getId().equals((Object)firstEntry.getCurrency().getId()) || firstEntry.getLocalAmount().signum() == entry.getLocalAmount().signum()) continue;
            int entrySig = entry.getLocalAmount().signum();
            int firstESig = firstEntry.getLocalAmount().signum();
            BigDecimal minLocValue = firstEntry.getLocalAmount().abs();
            BigDecimal minOrgValue = firstEntry.getOriginalAmount().abs();
            BigDecimal minRptValue = firstEntry.getReportingAmount().abs();
            if (minLocValue.compareTo(entry.getLocalAmount().abs()) < 0) {
                entryColl.remove(firstEntry);
                entry.setOriginalAmount(entry.getOriginalAmount().add(firstEntry.getOriginalAmount()));
                entry.setLocalAmount(entry.getLocalAmount().add(firstEntry.getLocalAmount()));
                entry.setReportingAmount(entry.getReportingAmount().add(firstEntry.getReportingAmount()));
                tmpEntry = firstEntry;
                firstEntry = null;
                entryIt = entryColl.iterator();
            } else if (minLocValue.compareTo(entry.getLocalAmount().abs()) > 0) {
                minLocValue = entry.getLocalAmount().abs();
                minOrgValue = entry.getOriginalAmount().abs();
                minRptValue = entry.getReportingAmount().abs();
                entryIt.remove();
                firstEntry.setOriginalAmount(firstEntry.getOriginalAmount().add(entry.getOriginalAmount()));
                firstEntry.setLocalAmount(firstEntry.getLocalAmount().add(entry.getLocalAmount()));
                firstEntry.setReportingAmount(firstEntry.getReportingAmount().add(entry.getReportingAmount()));
                tmpEntry = firstEntry;
            } else {
                entryIt.remove();
                entryColl.remove(firstEntry);
                tmpEntry = firstEntry;
                firstEntry = null;
                entryIt = entryColl.iterator();
                if (entrySig == -1) {
                    disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, tmpEntry, minLocValue.negate(), minOrgValue.negate(), minRptValue.negate()));
                } else {
                    disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, tmpEntry, minLocValue, minOrgValue, minRptValue));
                }
                if (firstESig == -1) {
                    disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, tmpEntry, entry, minLocValue.negate(), minOrgValue.negate(), minRptValue.negate()));
                } else {
                    disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, tmpEntry, entry, minLocValue, minOrgValue, minRptValue));
                }
            }
            if (minLocValue.compareTo(entry.getLocalAmount().abs()) == 0) continue;
            if (entrySig == -1) {
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, tmpEntry, minLocValue.negate(), minOrgValue.negate(), minRptValue.negate()));
            } else {
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, tmpEntry, minLocValue, minOrgValue, minRptValue));
            }
            if (firstESig == -1) {
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, tmpEntry, entry, minLocValue.negate(), minOrgValue.negate(), minRptValue.negate()));
                continue;
            }
            disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, tmpEntry, entry, minLocValue, minOrgValue, minRptValue));
        }
        return disposeColl;
    }

    private CashflowRecordCollection disposeDebitAndCredit(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection debitEntryColl, VoucherEntryCollection creditEntryColl) {
        CashflowRecordCollection disposeColl = new CashflowRecordCollection();
        Iterator plDebitEntryIt = debitEntryColl.iterator();
        VoucherEntryInfo debitEntry = null;
        VoucherEntryInfo creditEntry = null;
        block0: while (plDebitEntryIt.hasNext()) {
            debitEntry = (VoucherEntryInfo)plDebitEntryIt.next();
            Iterator plCreditEntryIt = creditEntryColl.iterator();
            while (plCreditEntryIt.hasNext()) {
                VoucherEntryInfo entry = null;
                if (debitEntry == null) continue block0;
                creditEntry = (VoucherEntryInfo)plCreditEntryIt.next();
                if (!debitEntry.getCurrency().getId().equals((Object)creditEntry.getCurrency().getId()) || debitEntry.getLocalAmount().signum() != creditEntry.getLocalAmount().signum()) continue;
                BigDecimal minLocValue = debitEntry.getLocalAmount();
                BigDecimal minOrgValue = debitEntry.getOriginalAmount();
                BigDecimal minRptValue = debitEntry.getReportingAmount();
                if (minLocValue.abs().compareTo(creditEntry.getLocalAmount().abs()) < 0) {
                    plDebitEntryIt.remove();
                    creditEntry.setOriginalAmount(creditEntry.getOriginalAmount().subtract(minOrgValue));
                    creditEntry.setLocalAmount(creditEntry.getLocalAmount().subtract(minLocValue));
                    creditEntry.setReportingAmount(creditEntry.getReportingAmount().subtract(minRptValue));
                    entry = debitEntry;
                    debitEntry = null;
                } else if (minLocValue.abs().compareTo(creditEntry.getLocalAmount().abs()) > 0) {
                    minLocValue = creditEntry.getLocalAmount();
                    minOrgValue = creditEntry.getOriginalAmount();
                    minRptValue = creditEntry.getReportingAmount();
                    plCreditEntryIt.remove();
                    debitEntry.setOriginalAmount(debitEntry.getOriginalAmount().subtract(minOrgValue));
                    debitEntry.setLocalAmount(debitEntry.getLocalAmount().subtract(minLocValue));
                    debitEntry.setReportingAmount(debitEntry.getReportingAmount().subtract(minRptValue));
                    entry = debitEntry;
                } else {
                    plDebitEntryIt.remove();
                    plCreditEntryIt.remove();
                    debitEntry.setOriginalAmount(debitEntry.getOriginalAmount().subtract(minOrgValue));
                    debitEntry.setLocalAmount(debitEntry.getLocalAmount().subtract(minLocValue));
                    debitEntry.setReportingAmount(debitEntry.getReportingAmount().subtract(minRptValue));
                    entry = debitEntry;
                    debitEntry = null;
                }
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, creditEntry, minLocValue, minOrgValue, minRptValue));
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, creditEntry, entry, minLocValue, minOrgValue, minRptValue));
            }
        }
        return disposeColl;
    }

    private CashflowRecordInfo createCashflowRecord(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entry, VoucherEntryInfo oppEntry, BigDecimal locAmount, BigDecimal orgAmount, BigDecimal rptAmount) {
        CashflowRecordInfo cf = new CashflowRecordInfo();
        cf.setVoucher(voucherInfo);
        cf.setEntry(entry);
        cf.setEntryDC(entry.getEntryDC());
        cf.setAccount(entry.getAccount());
        cf.setCurrency(entry.getCurrency());
        cf.setOpposingAccountEntry(oppEntry);
        cf.setOppEntryDC(oppEntry.getEntryDC());
        cf.setOppAccount(oppEntry.getAccount());
        cf.setOriginalAmount(orgAmount);
        cf.setLocalAmount(locAmount);
        cf.setReportingAmount(rptAmount);
        cf.setIsSupItem(voucherInfo.isHasCashAccount());
        cf.setSupplementaryCoefficient(1);
        cf.setType(CashflowTypeEnum.NONE);
        cf.setItemFlag(ItemFlag.DISPOSE);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        cf.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        cf.setCreateTime(nowTime);
        cf.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        cf.setLastUpdateTime(nowTime);
        return cf;
    }

    private VoucherEntryCollection[] groupVoucherEntry(VoucherInfo voucher, VoucherEntryCollection entryColl, Map cfAccountDiffMap) {
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        VoucherEntryCollection debitEntryColl = new VoucherEntryCollection();
        VoucherEntryCollection creditEntryColl = new VoucherEntryCollection();
        for (VoucherEntryInfo entry : entryColl) {
            if (!CashFlowUtils.isCashAccount(entry.getAccount()) && (entry.getAccount().getPLType() == AccountPLType.NONE || cfAccountDiffMap.containsKey(entry.getAccount().getId().toString()))) {
                newEntryColl.add(entry);
                continue;
            }
            if (entry.getEntryDC() == EntryDC.CREDIT) {
                creditEntryColl.add(entry);
                continue;
            }
            debitEntryColl.add(entry);
        }
        VoucherEntryCollection[] entryColls = new VoucherEntryCollection[]{newEntryColl, debitEntryColl, creditEntryColl};
        return entryColls;
    }

    private boolean hasPLAccount(Context ctx, VoucherInfo voucher, Map cfAccountDiffMap) throws BOSException {
        Iterator entryIt = voucher.getEntries().iterator();
        while (entryIt.hasNext()) {
            AccountViewInfo account = ((VoucherEntryInfo)entryIt.next()).getAccount();
            if (account == null || account.getPLType() == AccountPLType.NONE || account.isBudget() || cfAccountDiffMap.containsKey(account.getId().toString())) continue;
            return true;
        }
        return false;
    }
}

