/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.fi.gl.app.AbstractPeriodBatchFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLClosePeriodUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeriodBatchFacadeControllerBean
extends AbstractPeriodBatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.PeriodBatchFacadeControllerBean");

    @Override
    protected List _getInitData(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection permCompany = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.Company, null, "gl_closePeriod");
        ArrayList result = new ArrayList();
        if (permCompany == null || permCompany.size() == 0) {
            return result;
        }
        StringBuffer strFilter = new StringBuffer();
        if (permCompany != null) {
            int length = permCompany.size();
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    strFilter.append("'").append(permCompany.get(i).getId().toString()).append("'");
                    continue;
                }
                strFilter.append(",'").append(permCompany.get(i).getId().toString()).append("'");
            }
        }
        String sql = "select a.fid comId,b.fcurrentperiodid periodId,d.fnumber fperiodnumber,a.fnumber ,a.fname_l2 fname,a.fcontrolunitid cuid,\t\t\t\t\t\t\t\t\r\n\t\td.fperiodyear curYear,d.fperiodnumber  curPeriod ,a.FaccounttableId accounttableid,d.FbeginDate,d.FendDate ,d.fid periodId \t \r\n\t\tfrom t_org_company a \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fcompanyid \t\t\t\t\t\r\n\t\tinner join t_bd_systemstatus c on c.fid=b.fsystemstatusid\t\t\t\t\t\r\n\t\tinner join t_bd_period d on d.fid=b.fcurrentperiodid \t\t\t\t\t\t\r\n\t\twhere c.fname=6 and a.fisbizunit=1 and a.fissealup = 0 and a.flongnumber like '" + company.getLongNumber() + "%'\t\t\t\t\r\n\t\tand a.fid in (" + strFilter.toString() + ")\t\t\t\t\t\t\t\t\t\t\r\n\t\tand a.fmainorgid is null  order by a.fnumber\t\t\t\t\t\t\t\t\t\r\n";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (set != null && set.next()) {
                boolean voucherNumber;
                String comId = set.getString("comId");
                String periodId = set.getString("periodId");
                String number = set.getString("fnumber");
                String name = set.getString("fname");
                String curPeriod = set.getString("curYear") + "." + set.getString("curPeriod");
                String cuid = set.getString("cuid");
                String accounttableid = set.getString("accounttableid");
                PeriodInfo curPeriodInfo = new PeriodInfo();
                curPeriodInfo.setId(BOSUuid.read((String)periodId));
                curPeriodInfo.setPeriodYear(set.getInt("curYear"));
                curPeriodInfo.setPeriodNumber(set.getInt("curPeriod"));
                HashMap<String, Object> idMap = new HashMap<String, Object>();
                idMap.put("id", comId);
                idMap.put("periodId", periodId);
                idMap.put("number", number);
                idMap.put("name", name);
                idMap.put("curPeriod", curPeriod);
                idMap.put("cuid", cuid);
                idMap.put("accounttableid", accounttableid);
                boolean checkCussent = GlUtils.getDefaultGLParam(ctx, comId, "GL_028");
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                ParamItemInfo paramCashflow = pc.getParamItemByNumberAndOrg("GL_070", comId);
                boolean cashflow = false;
                boolean cashFlowIsCheck = false;
                if (paramCashflow == null || "false".equals(paramCashflow.getValue())) {
                    cashflow = true;
                    cashFlowIsCheck = true;
                } else {
                    ParamItemInfo paramClose = pc.getParamItemByNumberAndOrg("GL_071", comId);
                    if ("2".equals(paramClose.getValue())) {
                        cashflow = true;
                        cashFlowIsCheck = true;
                    } else {
                        cashflow = false;
                        String msg = CFRequisitionFactory.getLocalInstance(ctx).checkCanClosePeriod((IObjectPK)new ObjectUuidPK(comId), (IObjectPK)new ObjectUuidPK(periodId), set.getInt("fperiodnumber"));
                        if (msg != null) {
                            cashFlowIsCheck = false;
                            idMap.put("cashFlowMsg", msg);
                        } else {
                            cashFlowIsCheck = true;
                        }
                    }
                }
                idMap.put("cashflow", cashflow);
                idMap.put("cashFlowIsCheck", cashFlowIsCheck);
                boolean isClose = GLClosePeriodUtils.checkCloseInit(ctx, comId, cuid, accounttableid, true, true, checkCussent);
                idMap.put("colseInit", isClose);
                boolean unPost = GLClosePeriodUtils.checkCanAdjRate(ctx, comId, periodId);
                idMap.put("unPost", unPost);
                HashMap hmAllParam = GLClosePeriodUtils.getDefaultGLParam(ctx, comId);
                boolean saveVoucher = Boolean.valueOf(hmAllParam.get("G011").toString());
                if (!saveVoucher) {
                    saveVoucher = !GLClosePeriodUtils.checkSaveVoucher(ctx, comId, periodId);
                }
                idMap.put("saveVoucher", saveVoucher);
                boolean plAccount = Boolean.valueOf(hmAllParam.get("GL_011").toString());
                plAccount = plAccount ? !GLClosePeriodUtils.checkPlAccount(ctx, comId, set.getInt("fperiodnumber")) : !plAccount;
                idMap.put("plAccount", plAccount);
                boolean notice = false;
                int re = Integer.valueOf(hmAllParam.get("GL_026").toString());
                if (2 == re) {
                    notice = true;
                }
                if (!notice) {
                    Date endDate;
                    Date beginDate = set.getDate("FbeginDate");
                    notice = !GLClosePeriodUtils.checkNotice(ctx, comId, beginDate, endDate = set.getDate("FendDate"));
                }
                idMap.put("notice", notice);
                boolean bl = voucherNumber = Integer.parseInt(hmAllParam.get("GL_051").toString()) != 2;
                if (!voucherNumber) {
                    PeriodInfo period = new PeriodInfo();
                    period.setPeriodNumber(set.getInt("curPeriod"));
                    period.setPeriodYear(set.getInt("curYear"));
                    period.setId(BOSUuid.read((String)set.getString("periodId")));
                    period.setBeginDate((java.util.Date)set.getDate("FbeginDate"));
                    voucherNumber = !GLClosePeriodUtils.voucherNumber(ctx, comId, period, cuid);
                }
                idMap.put("voucherNumber", voucherNumber);
                PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(periodId));
                boolean system = GLClosePeriodUtils.checkPeriod(ctx, comId, curPeriodInfo, nextPeriod);
                idMap.put("system", system);
                boolean fcSU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
                boolean isUserReportCurr = Boolean.valueOf(hmAllParam.get("G001").toString());
                Boolean isCheckBalance = Boolean.valueOf(hmAllParam.get("GL_103").toString());
                boolean isbalanceCorrect = false;
                if (isCheckBalance.booleanValue()) {
                    isbalanceCorrect = GLPeriodEndFacadeFactory.getLocalInstance(ctx).checkBalanceCorrect(fcSU, comId, periodId, isUserReportCurr);
                }
                idMap.put("isCheckBalance", isCheckBalance);
                idMap.put("balanceCorrect", isbalanceCorrect);
                result.add(idMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _closeBatch(Context ctx, List companyList) throws BOSException, EASBizException {
        return PeriodTransFacadeFactory.getLocalInstance(ctx).closePeriodBatch(companyList);
    }
}

