/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BalanceFunEnum;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLBalanceFacade;
import com.kingdee.eas.fi.gl.app.AbstractPeriodTransFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLBalanceTransfer;
import com.kingdee.eas.fi.gl.app.GlAcctCussentGlFlagDeal;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeriodTransFacadeControllerBean
extends AbstractPeriodTransFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.PeriodTransFacadeControllerBean");
    static final String GENERAL_LOCAL_CURRENCY = "11111111-1111-1111-1111-111111111111DEB58FDC";
    static final String GENERAL_REPORT_CURRENCY = "22222222-2222-2222-2222-222222222222DEB58FDC";
    private static final int ACCOUNT_BALANCE = 1;
    private static final int ASSIST_BALANCE = 2;
    private static final int MEASURE_BALANCE = 3;

    @Override
    protected IObjectCollection _fetchPeriod(Context ctx, String type, Date bookDate) throws BOSException {
        bookDate = new Date(bookDate.getYear(), bookDate.getMonth(), bookDate.getDate());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)type));
        fic.add(new FilterItemInfo("beginDate", (Object)bookDate, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)bookDate, CompareType.GREATER_EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        view.setSorter(sorter);
        sorter.add(new SorterItemInfo("number"));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        return prdCtrl.getPeriodCollection(view);
    }

    @Override
    protected void _checkCanClosePeriod(Context ctx, int iClose) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, company.getId().toString());
        String periodID = null;
        int periodNumber = 0;
        if (curPeriod.isIsAdjustPeriod()) {
            periodID = curPeriod.getId().toString();
            periodNumber = curPeriod.getNumber();
        } else {
            String periodSql = "select p.fid, p.FNumber from t_bd_period p , t_org_company com where com.fid = ? and p.FTypeID = com.FAccountPeriodID and p.fperiodyear=?  order by p.fnumber desc";
            try {
                IRowSet periodRS = DbUtil.executeQuery((Context)ctx, (String)periodSql, (Object[])new Object[]{company.getId().toString(), curPeriod.getPeriodYear() - 1});
                if (periodRS.next()) {
                    periodID = periodRS.getString("FID");
                    periodNumber = periodRS.getInt("FNumber");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (StringUtil.isEmptyString((String)periodID)) {
            return;
        }
        HashMap hmAllParam = GlUtils.getDefaultGLParam(ctx, company.getId().toString());
        boolean notYearClose = Boolean.valueOf(hmAllParam.get("GL_080").toString());
        Object pa = hmAllParam.get("GL_010");
        StringBuffer sql = new StringBuffer();
        String acctID = "";
        if (!notYearClose && pa != null && pa.toString().length() > 0) {
            boolean useRpt = Boolean.valueOf(hmAllParam.get("G001").toString());
            acctID = pa.toString();
            sql.append(" select 1 where exists ( \r\n");
            sql.append(" select * from " + GLBalanceUtils.getAccountBalanceTable(5) + "  \r\n ");
            sql.append(" where FOrgUnitID = ?  and FPeriod = ? and FAccountID = ? \r\n");
            sql.append(" and (FEndBalanceFor <> 0 or FEndBalanceLocal <> 0");
            if (useRpt) {
                sql.append(" or FEndBalanceRpt <> 0");
            }
            sql.append(") \r\n ) ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), periodNumber, acctID});
                if (rs != null && rs.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.ENDBALANCE_NOT_ZORE_YEARCLOSE);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (periodID != null && this.isPNLAcctMustZero(ctx, company)) {
            this.annualPLAccountBalanceZero(ctx, company.getId().toString(), periodNumber);
        }
    }

    private void annualPLAccountBalanceZero(Context ctx, String curCompanyID, int curPeriodNumber) throws EASBizException, BOSException {
        boolean useGovAccSystem;
        String propertySql = "= 4";
        Object param = VoucherProcessCache.getParam(ctx, null, AccountConstant.GovermentAccountingSystem);
        if (param != null && (useGovAccSystem = Boolean.valueOf(param.toString()).booleanValue())) {
            propertySql = "in (4,12,13)";
        }
        BigDecimal minQtyByPrecision = GlUtils.getMinQtyByPrecision(ctx, curCompanyID);
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        try {
            con = this.getConnection(ctx);
            sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
            sql.append("From " + GLBalanceUtils.getAccountBalanceTable(5) + " bal,                                                             \r\n");
            sql.append("\tt_bd_accountview acct,                                                                \r\n");
            sql.append("\tt_BD_AccountType aType                                                                \r\n");
            sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
            sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
            sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
            sql.append("\tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 ) \t\t\t\t\t\t  \r\n");
            sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
            sql.append("\tand bal.FOrgUnitID = acct.FCompanyId                                                         \r\n");
            sql.append("\tand aType.FID = acct.FAccountTypeID                                                   \r\n");
            sql.append("\tand aType.FProperty " + propertySql + "                                                      \r\n");
            sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
            sql.append("\tand acct.FCAA is null                                                               \r\n");
            sql.append("    and acct.fbw = 0                         \r\n");
            sql.append(")                                               \t\t\t\t\t\t\r\n");
            sql.append("; \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, curPeriodNumber);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("Select 1 where exists (Select 1                                                               \t\t\t\r\n");
            sql.append("From " + GLBalanceUtils.getAccountBalanceTable(5) + " bal,                                                             \r\n");
            sql.append("\tt_bd_accountview acct,                                                                \r\n");
            sql.append("\tt_BD_AccountType aType                                                                \r\n");
            sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
            sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
            sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
            sql.append("\tand ( ").append(strQtyBalNotZero).append(") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
            sql.append("\tand bal.FOrgUnitID = acct.FCompanyId                                                         \r\n");
            sql.append("\tand aType.FID = acct.FAccountTypeID                                                   \r\n");
            sql.append("\tand aType.FProperty " + propertySql + "                                                      \r\n");
            sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
            sql.append("\tand acct.FCAA is null                                                               \r\n");
            sql.append("    and acct.fbw = 0                            \r\n");
            sql.append(")                                               \t\t\t\t\t\t\r\n");
            sql.append("; \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, curPeriodNumber);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO_QTY);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
            sql.append("From " + GLBalanceUtils.getAssistBalanceTable(5) + " bal,                                                             \r\n");
            sql.append("\tt_bd_accountview acct,                                                                \r\n");
            sql.append("\tt_BD_AccountType aType                                                                \r\n");
            sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
            sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
            sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
            sql.append("\tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 ) \t\t\t\t\t\t  \r\n");
            sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
            sql.append("\tand bal.FOrgUnitID = acct.FCompanyId                                                         \r\n");
            sql.append("\tand aType.FID = acct.FAccountTypeID                                                   \r\n");
            sql.append("\tand aType.FProperty " + propertySql + "                                                      \r\n");
            sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
            sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
            sql.append("    and acct.fbw = 0                            \r\n");
            sql.append(")                                               \t\t\t\t\t\t\r\n");
            sql.append("; \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, curPeriodNumber);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO_ASST);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            boolean isAsstQty = GlUtils.getDefaultGLParam(ctx, null, "G010");
            sql = new StringBuffer();
            if (isAsstQty) {
                sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
                sql.append("From " + GLBalanceUtils.getAssistMeasureBalanceTable(5) + " bal,                                                             \r\n");
                sql.append("\tt_bd_accountview acct,                                                                \r\n");
                sql.append("\tt_BD_AccountType aType,                                                                \r\n");
                sql.append("    T_BD_AsstAccount asst \r\n");
                sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
                sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("\tand ( ").append(strQtyBalNotZero).append(" ) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
                sql.append("\tand aType.FID = acct.FAccountTypeID and acct.FCAA = asst.FID      \r\n");
                sql.append("\tand aType.FProperty " + propertySql + "                                                      \r\n");
                sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
                sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
                sql.append("    and acct.fbw = 0                            \r\n");
                sql.append(" and acct.fisqty=1 and  asst.fisqty=1  \r\n");
                sql.append(" and acct.fnumber in(  \r\n");
                sql.append(" select acct.fnumber  \r\n");
                sql.append("  from " + GLBalanceUtils.getAssistBalanceTable(5) + " bal  \r\n");
                sql.append("  \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID  \r\n");
                sql.append("  \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty " + propertySql + " \r\n");
                sql.append("  \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA  \r\n");
                sql.append("  \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID  \r\n");
                sql.append("  where  \r\n");
                sql.append("  \tbal.FOrgUnitID = ?  \r\n");
                sql.append("  \tand bal.FPeriod = ?  \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("  \tand (acct.FCAA is not null)  \r\n");
                sql.append("  \tand acct.FIsLeaf = 1  \r\n");
                sql.append("  \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0  \r\n");
                sql.append("  \t or bal.FEndBalanceRpt <> 0\t or ").append(strQtyBalNotZero).append(" )  \r\n");
                sql.append("  )  \r\n");
                sql.append(")                                               \t\t\t\t\t\t\r\n");
                sql.append("; \r\n");
            } else {
                sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
                sql.append("From " + GLBalanceUtils.getAssistBalanceTable(5) + " bal,                                                             \r\n");
                sql.append("\tt_bd_accountview acct,                                                                \r\n");
                sql.append("\tt_BD_AccountType aType                                                                \r\n");
                sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
                sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("\tand ( ").append(strQtyBalNotZero).append(" ) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
                sql.append("\tand aType.FID = acct.FAccountTypeID                                                   \r\n");
                sql.append("\tand aType.FProperty " + propertySql + "                                                      \r\n");
                sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
                sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
                sql.append("    and acct.fbw = 0                            \r\n");
                sql.append(")                                               \t\t\t\t\t\t\r\n");
                sql.append("; \r\n");
            }
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            if (isAsstQty) {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                stmt.setInt(index++, curPeriodNumber);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                stmt.setInt(index++, curPeriodNumber);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            } else {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                stmt.setInt(index++, curPeriodNumber);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            }
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO_ASST_QTY);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    private boolean isPNLAcctMustZero(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(company.getId());
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_011", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = new Boolean(false);
        try {
            bParam = Boolean.valueOf(hmAllParam.get("GL_011").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_011"});
        }
        return bParam;
    }

    private void checkCanClosePeriod(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, int iClose) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (iClose == 1) {
            sql.append("Select 1 where exists (Select * From t_GL_Voucher                                       \r\n");
            sql.append("Where FCompanyID = ?\t                                                             \r\n");
            sql.append("\tand FPeriodID = ?                                                                \r\n");
            sql.append("\tand FBizStatus <> 5   and FBizStatus <> 2  and   FBizStatus <>0    and FIsClose=0           \r\n");
            sql.append(")                                               \t\t\t\t\t\t\r\n");
            sql.append("; \r\n");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), period.getId().toString()});
            try {
                if (set != null && set.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.ADJHAS_VOUCHER_NOT_POSTED);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _closePeriod(Context ctx, boolean post) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.closePeriodFun(ctx, company.getId().toString(), post);
    }

    @Override
    protected void _closePeriod(Context ctx, String companyId, boolean post) throws BOSException, EASBizException {
        this.closePeriodFun(ctx, companyId, post);
    }

    protected void closePeriodFun(Context ctx, String companyId, boolean post) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, companyId, GlUtils.getCompanySic(), true);
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, company.getId().toString());
        String curPeriodID = aryPrd[1].getId().toString();
        PeriodInfo period = PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)aryPrd[1]);
        if (period == null) {
            return;
        }
        if (post) {
            this.checkCanClosePeriod(ctx, period, company, 1);
        }
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("GL_Close_SplitAccount", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        boolean splitAccount = false;
        Object pv = hmAllParam.get("GL_Close_SplitAccount");
        if (pv != null && "true".equals(pv.toString())) {
            splitAccount = true;
        }
        if (splitAccount) {
            GLBalanceTransfer.toNextYear(ctx, company, period, aryPrd[1], null);
        } else {
            IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
            updateBalance.transBalanceToNextYear(company.getId().toString(), period.getId().toString(), curPeriodID, null);
        }
        if (period.isIsAdjustPeriod()) {
            String sql = "update t_GL_Voucher set FIsClose=1 where FCompanyID = ? and FPeriodID = ? and FIsClose=0 ";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), period.getId().toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unClosePeriod(Context ctx) throws BOSException, EASBizException {
        MutexParameter mp;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, company.getId().toString());
        String curPeriodID = aryPrd[1].getId().toString();
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, company.getId().toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_UncloseYear", String.valueOf(aryPrd[1].getNumber())));
        if (current != null) {
            throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
        }
        try {
            PeriodInfo period = PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)aryPrd[1]);
            this.checkCanClosePeriod(ctx, period, company, 0);
            HashMap hmAllParam = GlUtils.getDefaultGLParam(ctx, company.getId().toString());
            boolean useReport = Boolean.valueOf(hmAllParam.get("G001").toString());
            String sql = " and vch.FCompanyID = ? and vch.FPeriodID = ? and vch.FIsClose=1 ";
            if (period.isIsAdjustPeriod()) {
                sql = "update t_GL_Voucher set FIsClose=0 where FCompanyID = ? and FPeriodID = ? and FIsClose=1 ";
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), period.getId().toString()});
            }
        }
        finally {
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    @Override
    protected void _submitMeasureBatch(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected String _check(Context ctx, Map param) throws BOSException, EASBizException {
        String table = (String)param.get("table");
        String company = (String)param.get("company");
        BalanceFunEnum balenum = (BalanceFunEnum)((Object)param.get("function"));
        PeriodInfo periodfrom = (PeriodInfo)param.get("periodfrom");
        PeriodInfo periodto = (PeriodInfo)param.get("periodto");
        String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(company));
        Object[] initParam = this.getInitParam(ctx, company, table, start);
        boolean isNewAccount = (Boolean)initParam[0];
        int year = (Integer)initParam[1];
        int number = (Integer)initParam[2];
        String result = null;
        if (BalanceFunEnum.CURAMOUNT.equals((Object)balenum)) {
            if (periodfrom.getPeriodYear() < start.getPeriodYear() || periodfrom.getPeriodYear() == start.getPeriodYear() && periodfrom.getPeriodNumber() < start.getPeriodNumber()) {
                return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"497_PeriodTransFacadeControllerBean", (Locale)ctx.getLocale()) + start.getPeriodYear() + "." + start.getPeriodNumber();
            }
            if (isNewAccount && (periodfrom.getPeriodYear() < year || periodfrom.getPeriodYear() == year && periodfrom.getPeriodNumber() < number) && (periodto.getPeriodYear() > year || periodto.getPeriodYear() == year && periodto.getPeriodNumber() > number)) {
                return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"498_PeriodTransFacadeControllerBean", (Locale)ctx.getLocale()) + year + "." + number;
            }
            result = this.checkCur(ctx, company, table, periodfrom, periodto.getId().toString());
        } else {
            if (isNewAccount) {
                if (periodfrom.getPeriodYear() != year || periodfrom.getPeriodNumber() != number) {
                    return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"499_PeriodTransFacadeControllerBean", (Locale)ctx.getLocale()) + year + "." + number;
                }
                String disableTable = (String)initParam[3];
                result = this.checkAccount(ctx, company, table, disableTable);
            } else if (periodfrom.getPeriodYear() != start.getPeriodYear() || periodfrom.getPeriodNumber() != start.getPeriodNumber()) {
                return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"500_PeriodTransFacadeControllerBean", (Locale)ctx.getLocale()) + start.getPeriodYear() + "." + start.getPeriodNumber();
            }
            if (result == null) {
                result = this.checkIint(ctx, company, table, periodfrom, periodto.getId().toString());
            }
        }
        return result;
    }

    protected String checkCur(Context ctx, String company, String table, PeriodInfo periodfrom, String periodto) throws BOSException, EASBizException {
        String result = null;
        return result;
    }

    protected String checkIint(Context ctx, String company, String table, PeriodInfo periodfrom, String periodto) throws BOSException, EASBizException {
        String result = null;
        return result;
    }

    protected Object[] getInitParam(Context ctx, String companyid, String table, PeriodInfo start) throws BOSException, EASBizException {
        Object[] initParam = new Object[4];
        boolean isNewAccount = false;
        int year = 0;
        int number = 0;
        String disableTable = null;
        String sql = "select b.fperiodyear,b.fperiodnumber,a.fdisabledaccttableid from T_BD_AcctRefContrast a inner join t_bd_period b on a.fenabledperiodid=b.fid  where a.fenabledaccttableid=? and a.fcompanyid=? and a.fisenabled=1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{table, companyid});
        try {
            if (rs != null && rs.next()) {
                isNewAccount = true;
                year = rs.getInt("fperiodyear");
                number = rs.getInt("fperiodnumber");
                disableTable = rs.getString("fdisabledaccttableid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (isNewAccount && (year < start.getPeriodYear() || year == start.getPeriodYear() && number < start.getPeriodNumber())) {
            isNewAccount = false;
        }
        initParam[0] = isNewAccount;
        initParam[1] = new Integer(year);
        initParam[2] = new Integer(number);
        initParam[3] = disableTable;
        return initParam;
    }

    @Override
    protected String _doOK(Context ctx, Map param) throws BOSException, EASBizException {
        boolean useReport;
        String acctIDs = null;
        if (((List)param.get("selectedAV")).size() > 0) {
            List accounts = (List)param.get("selectedAV");
            StringBuffer accountIDs = new StringBuffer();
            Iterator ie = accounts.iterator();
            while (ie.hasNext()) {
                accountIDs.append(",'").append(ie.next()).append("'");
            }
            accountIDs.deleteCharAt(0);
            StringBuffer sql = new StringBuffer();
            sql.append("select b.fid from t_bd_accountview a \r\n");
            sql.append("inner join t_bd_accountview b \r\n");
            sql.append("on (charindex(a.flongnumber||'!',b.flongnumber)=1 or a.fid = b.fid) and a.fcompanyid=b.fcompanyid and a.faccounttableid=b.faccounttableid \r\n");
            sql.append("where a.fid in (").append(accountIDs).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    accountIDs.append(",'").append(rs.getString(1)).append("'");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            acctIDs = accountIDs.toString();
        }
        String table = (String)param.get("table");
        String company = (String)param.get("company");
        BalanceFunEnum balenum = (BalanceFunEnum)((Object)param.get("function"));
        PeriodInfo periodfrom = (PeriodInfo)param.get("periodfrom");
        PeriodInfo periodto = (PeriodInfo)param.get("periodto");
        StringBuffer instanceDeatil = new StringBuffer();
        String companyNumber = (String)param.get("companyNumber");
        if (companyNumber == null) {
            companyNumber = company;
        }
        instanceDeatil.append(companyNumber + " ");
        if (BalanceFunEnum.CURAMOUNT.equals((Object)balenum)) {
            instanceDeatil.append("current");
        } else if (BalanceFunEnum.INITClOSE.equals((Object)balenum)) {
            instanceDeatil.append("init");
        } else {
            instanceDeatil.append("clear");
        }
        instanceDeatil.append("(old) ");
        instanceDeatil.append("period:");
        instanceDeatil.append("periodfrom-");
        instanceDeatil.append("periodto");
        String selectedAVNumbers = (String)param.get("selectedAVNumbers");
        if (selectedAVNumbers != null) {
            instanceDeatil.append(",account:");
            instanceDeatil.append(selectedAVNumbers);
        }
        String logItemName = "gl_BalanceRepair_Manu";
        String beforeDetail = instanceDeatil.toString().replace("periodfrom", String.valueOf(periodfrom.getNumber()));
        beforeDetail = beforeDetail.replace("periodto", String.valueOf(periodto.getNumber()));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"repairCompany", (BOSObjectType)new BOSObjectType("FAC9B7EE"), (IObjectPK)new ObjectUuidPK(company), (String)beforeDetail, (String)logItemName);
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G001", null);
        hmParamIn.put("G010", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        try {
            useReport = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        boolean isQtyAsst = Boolean.valueOf(hmAllParam.get("G010").toString());
        String result = null;
        result = BalanceFunEnum.CURAMOUNT.equals((Object)balenum) ? this.doCur(ctx, company, table, periodfrom, periodto.getId().toString(), useReport, isQtyAsst, acctIDs) : (BalanceFunEnum.INITClOSE.equals((Object)balenum) ? this.doIint(ctx, company, table, periodfrom, periodto.getId().toString(), useReport, isQtyAsst, acctIDs) : this.doClear(ctx, company, table, periodfrom, periodto.getId().toString(), useReport, acctIDs));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return result;
    }

    protected String checkAccount(Context ctx, String companyid, String table, String disableTable) throws BOSException {
        String result = null;
        String sql = "select 1 from t_bd_acctrefcontrastentry refacct \tinner join t_bd_acctrefcontrast rast on rast.fid=refacct.facctrefcontrastid \tinner join t_bd_accountview oldv on oldv.fid=refacct.foldacctid \tinner join t_bd_accounttable oldtable on oldv.faccounttableid=oldtable.fid \tinner join t_bd_accountview newv on newv.fid=refacct.fnewacctid \tinner join t_bd_accounttable newtable on newv.faccounttableid=newtable.fid \twhere oldv.fisleaf<>newv.fisleaf and oldv.flevel=newv.flevel  and rast.Fcompanyid = ? and rast.FEnabledAcctTableID=? and rast.FDisabledAcctTableID=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyid, table, disableTable});
        try {
            if (set != null && set.next()) {
                result = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"501_PeriodTransFacadeControllerBean", (Locale)ctx.getLocale());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected String doClear(Context ctx, String company, String table, PeriodInfo periodfrom, String periodto, boolean useReport, String acctIDs) throws BOSException, EASBizException {
        String result = "Success";
        String periodnext = null;
        PeriodInfo periodnextinfo = null;
        String periodfromId = periodfrom.getId().toString();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            boolean isLastPeriod = true;
            do {
                if (periodnext != null) {
                    periodfromId = periodnext;
                    periodfrom = periodnextinfo;
                } else {
                    this.clearCurPeriodBalance(con, company, periodfrom, table, acctIDs);
                }
                isLastPeriod = periodto.equals(periodfromId);
                if (isLastPeriod) continue;
                periodnextinfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(periodfromId));
                periodnext = periodnextinfo.getId().toString();
                this.clearCurPeriodBalance(con, company, periodnextinfo, table, acctIDs);
            } while (!isLastPeriod);
        }
        catch (Exception sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return result;
    }

    protected String doCur(Context ctx, String company, String table, PeriodInfo periodfrom, String periodto, boolean useReport, boolean isQtyAsst, String acctIDs) throws BOSException, EASBizException {
        String result = "Success";
        String periodnext = null;
        PeriodInfo periodnextinfo = null;
        String periodfromId = periodfrom.getId().toString();
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            do {
                if (periodnext != null) {
                    periodfromId = periodnext;
                    periodfrom = periodnextinfo;
                } else {
                    this.clearCurPeriodBalance(con, company, periodfrom, table, acctIDs);
                }
                this.updateCurPeriodBalance2(ctx, company, periodfrom, table, useReport, isQtyAsst, 1, acctIDs);
                this.updateCurPeriodBalance2(ctx, company, periodfrom, table, useReport, isQtyAsst, 5, acctIDs);
                if (periodto.equals(periodfromId)) continue;
                periodnextinfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(periodfromId));
                periodnext = periodnextinfo.getId().toString();
                boolean nextYear = periodnextinfo.getPeriodYear() != periodfrom.getPeriodYear();
                this.clearNextPeriod(ctx, con, company, periodnext, table, 1, acctIDs);
                this.clearNextPeriod(ctx, con, company, periodnext, table, 5, acctIDs);
                IGLBalanceFacade bf = GLBalanceFacadeFactory.getLocalInstance(ctx);
                bf.transBalanceToNextPeriod(company, periodfromId, periodnext, nextYear, acctIDs);
            } while (!periodfromId.equals(periodto));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return result;
    }

    protected String doIint(Context ctx, String company, String table, PeriodInfo periodfrom, String periodto, boolean useReport, boolean isQtyAsst, String acctIDs) throws BOSException, EASBizException {
        String result = "Success";
        String periodfromId = periodfrom.getId().toString();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            this.clearNextPeriod(ctx, con, company, periodfromId, table, 1, acctIDs);
            this.clearNextPeriod(ctx, con, company, periodfromId, table, 5, acctIDs);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("periodYear");
            selector.add("periodNumber");
            selector.add("periodType.id");
            periodfrom = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodfromId), selector);
            PeriodInfo firstPeriod = PeriodTransFacadeControllerBean.getFirstPeriod(ctx, periodfrom.getPeriodYear(), 1, periodfrom.getPeriodType().getId().toString());
            if (firstPeriod == null) {
                firstPeriod = periodfrom;
            }
            IGLBalanceFacade bf = GLBalanceFacadeFactory.getLocalInstance(ctx);
            bf.initAccountBalance(company, periodfromId, firstPeriod.getId().toString(), acctIDs);
            bf.initAssistBalance(company, null, periodfromId, firstPeriod.getId().toString(), acctIDs);
            bf.initAssistMeasureBalance(company, null, periodfromId, firstPeriod.getId().toString(), acctIDs);
            this.updateCurPeriodBalance2(ctx, company, periodfrom, table, useReport, isQtyAsst, 1, acctIDs);
            this.updateCurPeriodBalance2(ctx, company, periodfrom, table, useReport, isQtyAsst, 5, acctIDs);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return result;
    }

    protected static PeriodInfo getFirstPeriod(Context ctx, int PeriodYear, int PeriodNumber, String periodType) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("periodYear");
        selector.add("periodNumber");
        evi.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear)));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(PeriodNumber)));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType));
        evi.setFilter(filter);
        PeriodCollection periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        if (periodCollection.size() > 0) {
            return periodCollection.get(0);
        }
        return null;
    }

    private void clearCurPeriodBalance(Connection conn, String curCompanyID, PeriodInfo curPeriod, String tableId, String acctIDs) throws BOSException {
        try {
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 1, 1, null, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 1, 1, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 1, 1, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 1, 5, null, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 1, 5, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 1, 5, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 2, 1, null, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 2, 1, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 2, 1, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 2, 5, null, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 2, 5, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 2, 5, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 3, 1, null, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 3, 1, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 3, 1, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 3, 5, null, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 3, 5, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearCurPeriodBalance(conn, curCompanyID, curPeriod, tableId, 3, 5, GENERAL_REPORT_CURRENCY, acctIDs);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCurPeriodBalance(Connection conn, String curCompanyID, PeriodInfo curPeriod, String tableId, int tableType, int balType, String currencyId, String acctIDs) throws SQLException {
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(tableType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if (GENERAL_LOCAL_CURRENCY.equals(currencyId)) {
            isLocalCurrency = true;
        } else if (GENERAL_REPORT_CURRENCY.equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update " + T_BalanceTable + " set       \r\n");
        if (isForCurrency) {
            sql.append("    FDebitFor = 0,                                \t\r\n");
            sql.append("\tFYearDebitFor = FYearDebitFor -FDebitFor,                     \t\t\r\n");
            sql.append("\tFCreditFor =0,                          \t\t\r\n");
            sql.append("\tFYearCreditFor = FYearCreditFor - FCreditFor,                   \t\t\r\n");
            sql.append("\tFEndBalanceFor = FBeginBalanceFor ,\t\t\t\t\t\t\r\n");
            sql.append("\tFMonthPnLFor = 0,\t\t\t\t\t\t\t\r\n");
            sql.append("\tFYearPnLFor = FYearPnLFor -FMonthPnLFor ,\t\t\t\t\t\t\t\t\r\n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("\tFDebitLocal = 0,                       \t\t\r\n");
            sql.append("\tFYearDebitLocal = FYearDebitLocal-FDebitLocal,               \t\t\r\n");
            sql.append("\tFCreditLocal =0,                    \t\t\r\n");
            sql.append("\tFYearCreditLocal = FYearCreditLocal-FCreditLocal,             \t\t\r\n");
            sql.append("\tFEndBalanceLocal = FBeginBalanceLocal ,\t\t\t\t\t\r\n");
            sql.append("\tFMonthPnLLocal =0 ,\t\t\t\t\t\t\r\n");
            sql.append("\tFYearPnLLocal = FYearPnLLocal -FMonthPnLLocal,\t\t\t\t\t\t\t\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("\tFDebitRpt = 0 ,                             \t\t\r\n");
            sql.append("\tFYearDebitRpt = FYearDebitRpt -FDebitRpt,                     \t\t\r\n");
            sql.append("\tFCreditRpt = 0,                         \t\t\r\n");
            sql.append("\tFYearCreditRpt = FYearCreditRpt-FCreditRpt,                   \t\t\r\n");
            sql.append("\tFEndBalanceRpt = FBeginBalanceRpt,               \t\t\t\r\n");
            sql.append("\tFMonthPnLRpt = 0,\t\t\t\t\t\t\t\r\n");
            sql.append("\tFYearPnLRpt = FYearPnLRpt -FMonthPnLRpt,\t\t\t\t\t\t\t\t\r\n");
        }
        sql.append("\tFDebitQty = 0,                             \t\t\r\n");
        sql.append("\tFYearDebitQty = FYearDebitQty -FDebitQty,                     \t\t\r\n");
        sql.append("\tFCreditQty =0,                          \t\t\r\n");
        sql.append("\tFYearCreditQty = FYearCreditQty - FCreditQty ,                  \t\t\r\n");
        sql.append("\tFEndQty = FBeginQty,                \t\t\t\t\t\t\r\n");
        sql.append("\tFMonthPnLQty = 0,\t\t\t\t\t\t\t\r\n");
        sql.append("\tFYearPnLQty = isNull(FYearPnLQty,0) - isNull(FMonthPnLQty,0) ,\t\t\t\t\t\t\t\t\r\n");
        sql.append("    FDetailCount = 0           \r\n");
        sql.append("where FOrgUnitID = ?                                            \t\r\n");
        sql.append("\tand FPeriod = ?                         \r\n");
        if (acctIDs != null && !"".equals(acctIDs)) {
            sql.append(" and FAccountid in (" + acctIDs + ")  \r\n");
        } else {
            sql.append("\tand FAccountid in (select fid from t_bd_accountview where fcompanyid=? and FAccounttableId=? )\t\r\n");
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql.toString());
            int index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, curPeriod.getNumber());
            if (acctIDs == null || acctIDs.length() == 0) {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)tableId);
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    private void clearNextPeriod(Context ctx, Connection con, String curCompanyID, String nextPeriodID, String tableId, int baltype, String acctIDs) throws BOSException {
        PeriodInfo nextPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            nextPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(nextPeriodID), selector);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 1, baltype, null, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 1, baltype, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 1, baltype, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 2, baltype, null, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 2, baltype, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 2, baltype, GENERAL_REPORT_CURRENCY, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 3, baltype, null, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 3, baltype, GENERAL_LOCAL_CURRENCY, acctIDs);
            this.doClearNextPeriod(ctx, con, curCompanyID, nextPeriod, tableId, 3, baltype, GENERAL_REPORT_CURRENCY, acctIDs);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearNextPeriod(Context ctx, Connection con, String curCompanyID, PeriodInfo nextPeriod, String tableId, int tableType, int baltype, String currencyId, String acctIDs) throws SQLException {
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(tableType, baltype, currencyId);
        StringBuffer sql = new StringBuffer();
        sql.append("Delete from " + T_BalanceTable + "                                 \r\n");
        sql.append("    Where FOrgUnitID = ?                                        \r\n");
        sql.append("    and FPeriod = ?                     \r\n");
        sql.append(" and FAccountid in (select fid from t_bd_accountview where FCompanyid=? and FAccounttableId=? )                                     \r\n");
        if (acctIDs != null && !"".equals(acctIDs)) {
            sql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, nextPeriod.getNumber());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)tableId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closePeriodBatch(Context ctx, List companyMap) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (companyMap != null) {
            for (int i = 0; i < companyMap.size(); ++i) {
                MutexParameter mp;
                Map map = (Map)companyMap.get(i);
                String companyId = (String)map.get("id");
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, "GL_Close"));
                if (current != null) {
                    throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
                }
                try {
                    Map iresult = this._closePeriodSingle(ctx, map);
                    result.putAll(iresult);
                    continue;
                }
                finally {
                    mutex.releaseMutex(mp.getRequestId());
                }
            }
        }
        return result;
    }

    @Override
    protected Map _closePeriodSingle(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            Map idMap = map;
            String comId = (String)idMap.get("id");
            String cuid = (String)idMap.get("cuid");
            String table = (String)idMap.get("accounttableid");
            String curperiod = (String)idMap.get("periodId");
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("description"));
            PeriodInfo curPeriodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curperiod), selectorItemCollection);
            String logDetail = idMap.get("name") + " - " + curPeriodInfo.getDescription();
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)new BOSObjectType("7967A563"), null, (String)logDetail, (String)"gl_PeriodEnd_batch");
            PeriodInfo periodfrom = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curperiod));
            PeriodInfo periodnextinfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(curperiod));
            if (periodnextinfo == null || periodnextinfo.getId() == null) {
                throw new GLPeriodEndException(GLPeriodEndException.NO_NEXT_PERIOD_ORG, new Object[]{idMap.get("name")});
            }
            String periodnext = periodnextinfo.getId().toString();
            boolean nextYear = periodnextinfo.getPeriodYear() != periodfrom.getPeriodYear();
            HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
            hmParamIn.put("GL_Close_SplitAccount", null);
            HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
            boolean splitAccount = false;
            Object pv = hmAllParam.get("GL_Close_SplitAccount");
            if (pv != null && "true".equals(pv.toString())) {
                splitAccount = true;
            }
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)comId));
            if (splitAccount) {
                GLBalanceTransfer.toNextPeriod(ctx, company, periodfrom, periodnextinfo, null);
            } else {
                IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
                updateBalance.transBalanceToNextPeriod(comId, curperiod, periodnext, nextYear, null);
            }
            FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(comId, "YxDBp4PaQEe3UWEr9OKHjM4XzhY=", curperiod, false);
            ISystemStatusCtrol sysStatus = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            sysStatus.nextPeriod(SystemEnum.GENERALLEDGER, (OrgUnitInfo)company);
            this.autoSetACParam(ctx, company);
            String periodnumber = periodnextinfo.getPeriodYear() + "." + periodnextinfo.getPeriodNumber();
            StringBuffer sql = new StringBuffer();
            sql.append("update t_gl_flag set fkey=? where forgunitid=? and fname='glinit' and fvalue='true'");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{periodnumber, comId});
            result.put(comId, periodnextinfo.getPeriodYear() + "." + periodnextinfo.getPeriodNumber());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return result;
    }

    private void autoSetACParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        try {
            StringBuffer updateACParam = new StringBuffer();
            updateACParam.append("select fid from t_bas_paramitem where fkeyid =(select fid from t_bas_param where fnumber='GL_028') and forgunitid=?                                        \r\n");
            updateACParam.append(" and exists (select fid from t_bd_systemstatusctrol where fcompanyid =? and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)         \r\n");
            updateACParam.append("             and facperiodid is not null and facperiodid=fcurrentperiodid)");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)updateACParam.toString(), (Object[])new Object[]{company.getId().toString(), company.getId().toString()});
            if (rs.next()) {
                IParamItem iParam = ParamItemFactory.getLocalInstance((Context)ctx);
                ParamItemInfo paramItem = iParam.getParamItemInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
                paramItem.setValue("true");
                paramItem.setValueAlias("true");
                iParam.update((IObjectPK)new ObjectUuidPK(paramItem.getId()), (CoreBaseInfo)paramItem);
                GlAcctCussentGlFlagDeal glActCusGlFlagDeal = new GlAcctCussentGlFlagDeal();
                glActCusGlFlagDeal.closePeriodWhenGl028ToTrue(ctx, company.getId().toString(), false);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateCurPeriodBalance2(Context ctx, String companyId, PeriodInfo period, String tableId, boolean useRpt, boolean isQtyAsst, int balType, String acctIDs) throws SQLException, BOSException, EASBizException {
        String tempTableMeasure;
        String tempTableAssist;
        block18: {
            String periodId = period.getId().toString();
            String filter = " and vch.Fcompanyid='" + companyId + "' and vch.fperiodid='" + periodId + "' and vch.FbizStatus<>0 and vch.FbizStatus<>2  ";
            if (balType == 5) {
                filter = filter + " and vch.FbizStatus=5 ";
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                filter = filter + " and ve.FAccountID in (" + acctIDs + ")  \r\n";
            }
            String companyfilter = " and acct.Fcompanyid='" + companyId + "' and acct.FAccounttableId='" + tableId + "'   ";
            String tempTableAccount = null;
            tempTableAssist = null;
            tempTableMeasure = null;
            try {
                try {
                    tempTableAccount = this.createBalanceTempTable(ctx, 1);
                    tempTableAssist = this.createBalanceTempTable(ctx, 2);
                    if (isQtyAsst) {
                        tempTableMeasure = this.createBalanceTempTable(ctx, 3);
                    }
                }
                catch (Exception e) {
                    throw new BOSException("Create TempTable fail! ", (Throwable)e);
                }
                try {
                    DbUtil.execute((Context)ctx, (String)("insert into " + tempTableAccount + this.getAccountSql2(filter, companyfilter)));
                    this.insertGenaCurrencyAmount(ctx, tempTableAccount, balType, 1);
                    DbUtil.execute((Context)ctx, (String)("insert into " + tempTableAssist + this.getAssistSql(filter, companyfilter)));
                    this.insertGenaCurrencyAmount(ctx, tempTableAssist, balType, 2);
                    if (isQtyAsst) {
                        DbUtil.execute((Context)ctx, (String)("insert into " + tempTableMeasure + this.getAssistMeasureSql(filter, companyfilter)));
                        this.insertGenaCurrencyAmount(ctx, tempTableMeasure, balType, 3);
                    }
                }
                catch (Exception e) {
                    throw new BOSException("insert TempTable fail! ", (Throwable)e);
                }
                this.insertEmptyBalanceRecord(ctx, tempTableAccount, companyId, period, balType, useRpt, 1);
                this.updateBalanceRecord(ctx, tempTableAccount, companyId, period, balType, 1);
                this.insertEmptyBalanceRecord(ctx, tempTableAssist, companyId, period, balType, useRpt, 2);
                this.updateBalanceRecord(ctx, tempTableAssist, companyId, period, balType, 2);
                if (isQtyAsst) {
                    this.insertEmptyBalanceRecord(ctx, tempTableMeasure, companyId, period, balType, useRpt, 3);
                    this.updateBalanceRecord(ctx, tempTableMeasure, companyId, period, balType, 3);
                }
                if (tempTableAccount == null) break block18;
            }
            catch (BOSException e) {
                try {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"316_PeriodTransFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (tempTableAccount != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableAccount);
                    }
                    if (tempTableAssist != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableAssist);
                    }
                    if (tempTableMeasure != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableMeasure);
                    }
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableAccount);
        }
        if (tempTableAssist != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableAssist);
        }
        if (tempTableMeasure != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableMeasure);
        }
    }

    private void insertGenaCurrencyAmount(Context ctx, String tmpTableName, int balType, int balanceType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.accountid, '").append(GENERAL_LOCAL_CURRENCY).append("' currencyid, ");
        if (balanceType == 2) {
            sql.append("t.assistgrpid, ");
        } else if (balanceType == 3) {
            sql.append("t.assistgrpid, t.measureunitid, ");
        }
        sql.append(" sum(t.DebitLocal) DebitFor, sum(t.CreditLocal) CreditFor, ");
        sql.append(" sum(t.DebitLocal) DebitLocal, sum(t.CreditLocal) CreditLocal, ");
        sql.append(" sum(t.DebitLocal) DebitRpt, sum(t.CreditLocal) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLLocal) MonthPnLFor, sum(t.MonthPnLLocal) MonthPnLLocal, sum(t.MonthPnLLocal) MonthPnLRpt, ");
        sql.append(" sum(t.MonthPnLQty) MonthPnLQty, ");
        sql.append(" sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by t.accountid");
        if (balanceType == 2) {
            sql.append(",t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(",t.assistgrpid, t.measureunitid ");
        }
        sql.append(" union all ");
        sql.append(" select t.accountid, '").append(GENERAL_REPORT_CURRENCY).append("' currencyid, ");
        if (balanceType == 2) {
            sql.append("t.assistgrpid, ");
        } else if (balanceType == 3) {
            sql.append("t.assistgrpid, t.measureunitid, ");
        }
        sql.append(" sum(t.DebitRpt) DebitFor, sum(t.CreditRpt) CreditFor,");
        sql.append(" sum(t.DebitRpt) DebitLocal, sum(t.CreditRpt) CreditLocal, ");
        sql.append(" sum(t.DebitRpt) DebitRpt, sum(t.CreditRpt) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLRpt) MonthPnLFor, sum(t.MonthPnLRpt) MonthPnLLocal, sum(t.MonthPnLRpt) MonthPnLRpt, ");
        sql.append(" sum(t.MonthPnLQty) MonthPnLQty, ");
        sql.append(" sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by t.accountid");
        if (balanceType == 2) {
            sql.append(",t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(",t.assistgrpid, t.measureunitid ");
        }
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()));
    }

    private String createBalanceTempTable(Context ctx, int balanceType) throws Exception {
        String tableAlias = balanceType == 1 ? "T_GL_ACCBALTMPTABLE" : (balanceType == 2 ? "T_GL_ASSTBALTMPTABLE" : "T_GL_MUBALTMPTABLE");
        StringBuffer sql = new StringBuffer();
        sql.append(" create table ").append(tableAlias);
        sql.append(" (");
        sql.append(" ACCOUNTID         VARCHAR(44),");
        sql.append(" CURRENCYID        VARCHAR(44),");
        if (balanceType == 2) {
            sql.append(" ASSISTGRPID       VARCHAR(44),");
        } else if (balanceType == 3) {
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            sql.append(" MEASUREUNITID     VARCHAR(44),");
        }
        sql.append(" DEBITFOR          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITFOR         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITLOCAL        NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITRPT          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITRPT         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITQTY          NUMERIC(28,10) DEFAULT 0,");
        sql.append(" CREDITQTY         NUMERIC(28,10) DEFAULT 0,");
        sql.append(" MONTHPNLFOR       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLLOCAL     NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLRPT       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLQTY       NUMERIC(28,10) DEFAULT 0");
        sql.append(" ,FLOGCOUNT INT");
        sql.append(")");
        String tmpTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        try {
            String indexStr = "accountid, currencyid";
            if (balanceType == 2) {
                indexStr = indexStr + ", assistgrpid";
            } else if (balanceType == 3) {
                indexStr = indexStr + ", assistgrpid, measureunitid";
            }
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, indexStr, false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Update voucher balance create index error!", (Throwable)e);
        }
        return tmpTableName;
    }

    private String getAccountSql2(String filter, String companyFilter) {
        String sql = " select \n /*+ LEADING(vch,ve) USE_HASH(vch,ve) */                                                                \r\n     \tpacct.FID AccountID, ve.FCurrencyID CurrencyID,\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \r\n sum(ve.FOriginalAmount * ve.FEntryDC) FDebitForV,                                                       \r\n\t sum(ve.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV,                                                \r\n\t sum(ve.FLocalAmount * ve.FEntryDC) FDebitLocalV,                                                        \r\n\t sum(ve.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV,                                                 \r\n\t sum(ve.FReportingAmount * ve.FEntryDC) FDebitRptV,                                                      \r\n\t sum(ve.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV,                                               \r\n\t sum(ve.FStandardQuantity * ve.FEntryDC)  FDebitQtyV,                                                    \r\n\t sum(ve.FStandardQuantity * (1 - ve.FEntryDC))  FCreditQtyV,                                             \r\n\t sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.foriginalamount else 0 end) FMonthPnLForV, sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.flocalamount else 0 end) FMonthPnLLocalV, sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.freportingamount else 0 end) FMonthPnLRptV,  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FStandardQuantity else 0 end) FMonthPnLQtyV  ,count(ve.fid) FVeCount      \r\n    from T_GL_Voucher vch                                                                           \t\t\r\n inner join T_GL_VoucherEntry ve on vch.FID = ve.FBillID                                         \t\t\r\n   and ve.FCompanyID = vch.FCompanyID and ve.FPeriodID = vch.FPeriodID                              \t\t\r\n inner join t_BD_AccountView acct on ve.FAccountID = acct.FID                                \t\t\t\r\n inner join t_BD_AccountView pacct on pacct.Fcompanyid = acct.Fcompanyid and pacct.faccounttableid = acct.faccounttableid and (charindex(pacct.FLongNumber||'!', acct.FLongNumber) = 1 or pacct.fid = acct.fid) \r\n" + companyFilter + " inner join T_BD_AccountType acctType on pacct.FAccountTypeID = acctType.FID \r\n where 1 = 1 " + filter + " group by vch.FCompanyID, vch.FPeriodID, pacct.fid, ve.FCurrencyID \r\n";
        return sql;
    }

    private String getAssistSql(String filter, String companyFilter) {
        String sql = " select \n /*+ LEADING(vch,ve,vast) USE_HASH(vch,ve,vast) */                                                       \r\n    \tve.FAccountID AccountID, ve.FCurrencyID CurrencyID, vast.FAssGrpID AssistGrpID,\t\t\t\t\t\t\t\r\n sum(vast.FOriginalAmount * ve.FEntryDC) FDebitForV,                                                     \r\n\t sum(vast.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV,                                              \r\n\t sum(vast.FLocalAmount * ve.FEntryDC) FDebitLocalV,                                                      \r\n\t sum(vast.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV,                                               \r\n\t sum(vast.FReportingAmount * ve.FEntryDC) FDebitRptV,                                                    \r\n\t sum(vast.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV,                                             \r\n\t sum(vast.FStandardQuantity * ve.FEntryDC)  FDebitQtyV,                                                  \r\n\t sum(vast.FStandardQuantity * (1 - ve.FEntryDC))  FCreditQtyV,                                           \r\n\t sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.foriginalamount else 0 end) FMonthPnLForV, sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.flocalamount else 0 end) FMonthPnLLocalV, sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.freportingamount else 0 end) FMonthPnLRptV,  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.FStandardQuantity else 0 end) FMonthPnLQtyV  ,count(vast.fid) FVeCount                                                                               \r\n from T_GL_Voucher vch                                                                                   \r\n inner join T_GL_VoucherEntry ve  on vch.FID = ve.FBillID                                                \r\n   and ve.FCompanyID = vch.FCompanyID and ve.FPeriodID = vch.FPeriodID                              \t\t\r\n inner join T_GL_VoucherAssistRecord vast\t  on ve.FID = vast.FEntryID\t                                \r\n   and vast.FCompanyID = vch.FCompanyID and vast.FPeriodID = vch.FPeriodID                              \t\r\n inner join t_BD_AccountView acct on ve.FAccountID = acct.FID                                            \r\n" + companyFilter + " inner join T_BD_AccountType acctType on acct.FAccountTypeID = acctType.FID                  \t\t\t\r\n where vast.FAssGrpID is not null                                             \t\t                    \r\n" + filter + " group by vch.FCompanyID, vch.FPeriodID, ve.FAccountID, ve.FCurrencyID, vast.FAssGrpID\t\t\t\t\t\r\n";
        return sql;
    }

    private String getAssistMeasureSql(String filter, String companyFilter) {
        String sql = " select  /*+ LEADING(vch,ve,vast) USE_HASH(vch,ve,vast) */                                                       \r\n    \tve.FAccountID AccountID, ve.FCurrencyID CurrencyID, vast.FAssGrpID AssistGrpID,  case when vast.FMeasureUnitId is null then '00000000-0000-0000-0000-0000000000005B825C57' else vast.FMeasureUnitId end MeasureUnitid ,  \r\n sum(vast.FOriginalAmount * ve.FEntryDC) FDebitForV,                                                     \r\n\t sum(vast.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV,                                              \r\n\t sum(vast.FLocalAmount * ve.FEntryDC) FDebitLocalV,                                                      \r\n\t sum(vast.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV,                                               \r\n\t sum(vast.FReportingAmount * ve.FEntryDC) FDebitRptV,                                                    \r\n\t sum(vast.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV,                                             \r\n\t sum(vast.FQuantity * ve.FEntryDC)  FDebitQtyV,                                                  \r\n\t sum(vast.FQuantity * (1 - ve.FEntryDC))  FCreditQtyV,                                           \r\n\t sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.foriginalamount else 0 end) FMonthPnLForV, sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.flocalamount else 0 end) FMonthPnLLocalV, sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.freportingamount else 0 end) FMonthPnLRptV,  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and acct.FPLType <> 0)) and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.FQuantity else 0 end) FMonthPnLQtyV  ,count(vast.fid) FVeCount                                                                               \r\n from T_GL_Voucher vch                                                                                   \r\n inner join T_GL_VoucherEntry ve on vch.FID = ve.FBillID                   \t                        \t\r\n   and ve.FCompanyID = vch.FCompanyID and ve.FPeriodID = vch.FPeriodID                              \t\t\r\n inner join T_GL_VoucherAssistRecord vast on ve.FID = vast.FEntryID\t                                    \r\n   and vast.FCompanyID = vch.FCompanyID and vast.FPeriodID = vch.FPeriodID                              \t\r\n inner join t_BD_AccountView acct on ve.FAccountID = acct.FID and acct.fisqty=1                          \r\n" + companyFilter + " inner join t_bd_asstaccount ac on ac.fid = acct.fcaa and ac.fisqty = 1 \t\t\t\t\t\t\t\t\t\r\n inner join T_BD_AccountType acctType on acct.FAccountTypeID = acctType.FID \t\t\t\t\t\t\t\t\r\n where vast.FAssGrpID is not null                                                                        \r\n" + filter + " group by vch.FCompanyID, vch.FPeriodID, ve.FAccountID, ve.FCurrencyID,vast.FMeasureUnitid, vast.FAssGrpID\t\r\n";
        return sql;
    }

    private void insertEmptyBalanceRecord(Context ctx, String tempTableName, String companyId, PeriodInfo period, int balType, boolean useRpt, int balanceType) throws BOSException {
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, companyId, period, balanceType, balType, null, useRpt);
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, companyId, period, balanceType, balType, GENERAL_LOCAL_CURRENCY, useRpt);
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, companyId, period, balanceType, balType, GENERAL_REPORT_CURRENCY, useRpt);
    }

    private void doInsertEmptyBalanceRecord(Context ctx, String tempTableName, String companyId, PeriodInfo period, int balanceType, int balType, String currencyId, boolean useRpt) throws BOSException {
        String balanceTableName = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = !GENERAL_LOCAL_CURRENCY.equals(currencyId) && !GENERAL_REPORT_CURRENCY.equals(currencyId);
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(balanceTableName);
        sql.append("(forgunitid, fperiod, ");
        if (isForCurrency) {
            sql.append("fcurrencyid, ");
        }
        sql.append("faccountid");
        if (balanceType == 2) {
            sql.append(", fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", fassistgrpid ");
            sql.append(", fmeasureunitid ");
        }
        sql.append(") ");
        sql.append(" select distinct '" + companyId + "', " + period.getNumber() + ", \n");
        if (isForCurrency) {
            sql.append("t.currencyid, ");
        }
        sql.append("t.accountid");
        if (balanceType == 2) {
            sql.append(", t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", t.assistgrpid ");
            sql.append(", t.measureunitid ");
        }
        sql.append(" from ").append(tempTableName).append(" t ");
        if (isForCurrency) {
            sql.append("where t.currencyid <> '").append(GENERAL_LOCAL_CURRENCY).append("' \n");
            sql.append("and t.currencyid <> '").append(GENERAL_REPORT_CURRENCY).append("' \n");
        } else {
            sql.append("where t.currencyid = '").append(currencyId).append("' \n");
        }
        sql.append(" and not exists ( ");
        sql.append(" select 1 from ").append(balanceTableName).append(" b ");
        sql.append(" where b.forgunitid = '" + companyId + "' ");
        sql.append(" and b.FPeriod = " + period.getNumber() + " \n");
        if (isForCurrency) {
            sql.append(" and b.fcurrencyid = t.currencyid ");
        }
        sql.append(" and b.faccountid = t.accountid ");
        if (balanceType == 2) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
            sql.append(" and b.fmeasureunitid = t.measureunitid ");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateBalanceRecord(Context ctx, String tempTableName, String companyId, PeriodInfo period, int balType, int balanceType) throws BOSException {
        this.doUpdateBalanceRecord(ctx, tempTableName, companyId, period, balanceType, balType, null);
        this.doUpdateBalanceRecord(ctx, tempTableName, companyId, period, balanceType, balType, GENERAL_LOCAL_CURRENCY);
        this.doUpdateBalanceRecord(ctx, tempTableName, companyId, period, balanceType, balType, GENERAL_REPORT_CURRENCY);
    }

    private void doUpdateBalanceRecord(Context ctx, String tempTableName, String companyId, PeriodInfo period, int balanceType, int balType, String currencyId) throws BOSException {
        String balanceTableName = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if (GENERAL_LOCAL_CURRENCY.equals(currencyId)) {
            isLocaCurrency = true;
        } else if (GENERAL_REPORT_CURRENCY.equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update /*+ NOT_GEN_EXISTS*/ ").append(balanceTableName).append(" set ( ");
        if (isForCurrency) {
            sql.append(" FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor,");
            sql.append(" FMonthPnLFor, FYearPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, FEndBalanceLocal,");
            sql.append(" FMonthPnLLocal, FYearPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, FEndBalanceRpt,");
            sql.append(" FMonthPnLRpt, FYearPnLRpt, ");
        }
        sql.append(" FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty,");
        sql.append(" FMonthPnLQty, FYearPnLQty ");
        sql.append(" ,FDetailCount ");
        sql.append(") = ( select ");
        if (isForCurrency) {
            sql.append(" FDebitFor + t.DebitFor, FYearDebitFor + t.DebitFor,FCreditFor + t.CreditFor, FYearCreditFor + t.CreditFor,FEndBalanceFor + t.DebitFor - t.CreditFor,");
            sql.append(" FMonthPnLFor + t.MonthPnLFor, FYearPnLFor + t.MonthPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal + t.DebitLocal,  FYearDebitLocal + t.DebitLocal, FCreditLocal + t.CreditLocal, FYearCreditLocal + t.CreditLocal, FEndBalanceLocal + t.DebitLocal - t.CreditLocal, ");
            sql.append(" FMonthPnLLocal + t.MonthPnLLocal, FYearPnLLocal + t.MonthPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt + t.DebitRpt, FYearDebitRpt + t.DebitRpt, FCreditRpt + t.CreditRpt, FYearCreditRpt + t.CreditRpt, FEndBalanceRpt + t.DebitRpt - t.CreditRpt, ");
            sql.append(" FMonthPnLRpt + t.MonthPnLRpt, FYearPnLRpt + t.MonthPnLRpt, ");
        }
        sql.append(" FDebitQty + t.DebitQty, FYearDebitQty + t.DebitQty, FCreditQty + t.CreditQty, FYearCreditQty + t.CreditQty, FEndQty + t.DebitQty - t.CreditQty, ");
        sql.append(" isNull(FMonthPnLQty,0) + t.MonthPnLQty, isNull(FYearPnLQty,0) + t.MonthPnLQty ");
        sql.append(" ,case when FDetailCount is null then null else (FDetailCount+ t.FLogCount) end ");
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" ) ");
        sql.append(" where forgunitid = '" + companyId + "' \n");
        sql.append(" and FPeriod = " + period.getNumber() + " \n");
        sql.append(" and exists ( ");
        sql.append(" select 1 from ").append(tempTableName).append(" t ");
        sql.append(" where t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int _clearEmptyBalance(Context ctx, String companyId, String periodId) throws BOSException {
        PeriodInfo period;
        int count = 0;
        Connection conn = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId), selector);
            conn = EJBFactory.getConnection((Context)ctx);
            count += this.doClearEmptyBalance(ctx, conn, companyId, period, 1, null);
            count += this.doClearEmptyBalance(ctx, conn, companyId, period, 1, GENERAL_LOCAL_CURRENCY);
            count += this.doClearEmptyBalance(ctx, conn, companyId, period, 1, GENERAL_REPORT_CURRENCY);
            count += this.doClearEmptyBalance(ctx, conn, companyId, period, 5, null);
            count += this.doClearEmptyBalance(ctx, conn, companyId, period, 5, GENERAL_LOCAL_CURRENCY);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException((Throwable)exc);
                catch (EASBizException exc2) {
                    throw new BOSException((Throwable)exc2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return count += this.doClearEmptyBalance(ctx, conn, companyId, period, 5, GENERAL_REPORT_CURRENCY);
    }

    private int doClearEmptyBalance(Context ctx, Connection conn, String companyId, PeriodInfo period, int balType, String currencyId) throws BOSException {
        int n;
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(2, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if (GENERAL_LOCAL_CURRENCY.equals(currencyId)) {
            isLocalCurrency = true;
        } else if (GENERAL_REPORT_CURRENCY.equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from " + T_BalanceTable + " where forgunitid = ? and fperiod = ? ");
        if (isForCurrency) {
            sql.append(" and fbeginbalancefor = 0 ");
            sql.append(" and fdebitfor=0 and fcreditfor=0 ");
            sql.append(" and fyeardebitfor=0 and fyearcreditfor=0 ");
            sql.append(" and fyearpnlfor=0 and fmonthpnlfor=0 ");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append(" and fbeginbalancelocal=0 ");
            sql.append(" and fdebitlocal=0 and fcreditlocal=0 ");
            sql.append(" and fyeardebitlocal=0 and fyearcreditlocal=0 ");
            sql.append(" and fyearpnllocal=0 and fmonthpnllocal=0 ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" and fbeginbalancerpt=0 ");
            sql.append(" and fyeardebitrpt=0 and fyearcreditrpt=0 ");
        }
        sql.append(" and fbeginqty=0 ");
        sql.append(" and fyeardebitqty=0 and fyearcreditqty=0 ");
        sql.append(" and fyearpnlqty=0 and fmonthpnlqty=0 ");
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, companyId);
            ps.setInt(2, period.getNumber());
            n = ps.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                sb.append("param 1").append(" is:").append(companyId);
                sb.append("param 2").append(" is:").append(period.getNumber());
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        return n;
    }
}

