/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ProgressTaskEntryCollection;
import com.kingdee.eas.fi.gl.ProgressTaskEntryInfo;
import com.kingdee.eas.fi.gl.ProgressTaskInfo;
import com.kingdee.eas.fi.gl.app.AbstractProgressTaskControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProgressTaskControllerBean
extends AbstractProgressTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.ProgressTaskControllerBean");

    @Override
    protected IObjectPK _addTask(Context ctx, IObjectValue task) throws BOSException, EASBizException {
        String id;
        String sql = "insert into T_GL_ProgressTask (FID, FNumber, FName, FOrgUnitID, FProgress, FStatus, FInfo, FCreatorID, FBeginTime, FEndTime) values (?, ?, ?, ?, ?, ?, ?, ?, getdate(), getdate())";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            ProgressTaskInfo info = (ProgressTaskInfo)task;
            int index = 0;
            id = info.getId() != null ? info.getId().toString() : BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
            pstmt.setString(++index, id);
            pstmt.setString(++index, info.getNumber());
            pstmt.setString(++index, info.getName());
            String orgUnitId = null;
            orgUnitId = info.getOrgUnit() != null && info.getOrgUnit().getId() != null ? info.getOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            pstmt.setString(++index, orgUnitId);
            pstmt.setInt(++index, info.getProgress());
            pstmt.setInt(++index, info.getStatus());
            pstmt.setString(++index, info.getInfo());
            String userId = null;
            userId = info.getCreator() != null && info.getCreator().getId() != null ? info.getCreator().getId().toString() : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            pstmt.setString(++index, userId);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return new ObjectUuidPK(id);
    }

    @Override
    protected void _updateTask(Context ctx, IObjectValue task) throws BOSException, EASBizException {
        this._update(ctx, (IObjectPK)new ObjectUuidPK(((ProgressTaskInfo)task).getId()), task);
    }

    @Override
    protected void _addEntries(Context ctx, IObjectCollection entries) throws BOSException, EASBizException {
        String sql = "insert into T_GL_ProgressTaskEntry (FID, FParentID, FSeq, FProgress, FStatus, FLevel, FAppend, FInfo, FBeginTime, FEndTime) values (?, ?, ?, ?, ?, ?, ?, ?, getdate(), getdate())";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            int count = 0;
            for (ProgressTaskEntryInfo info : entries) {
                if (info.getParent() == null || info.getParent().getId() == null) continue;
                int index = 0;
                String id = info.getId() != null ? info.getId().toString() : BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                pstmt.setString(++index, id);
                pstmt.setString(++index, info.getParent().getId().toString());
                pstmt.setInt(++index, info.getSeq());
                pstmt.setInt(++index, info.getProgress());
                pstmt.setInt(++index, info.getStatus());
                pstmt.setInt(++index, info.getLevel());
                pstmt.setInt(++index, info.getAppend());
                pstmt.setString(++index, info.getInfo());
                pstmt.addBatch();
                if (++count % 500 != 0) continue;
                pstmt.executeBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected IObjectValue _getTask(Context ctx, Map params) throws BOSException, EASBizException {
        String id = (String)params.get("id");
        if (id == null) {
            return null;
        }
        Object param = params.get("task");
        boolean forTask = param == null || "true".equalsIgnoreCase(param.toString());
        param = params.get("entry");
        boolean forEntry = param != null && "true".equalsIgnoreCase(param.toString());
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Integer count;
            Integer seq;
            StringBuffer sql;
            conn = EJBFactory.getConnection((Context)ctx);
            ProgressTaskInfo task = null;
            if (forTask) {
                sql = new StringBuffer();
                String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                sql.append("select \n");
                sql.append("    t.FNumber, t.FName, t.FProgress, t.FStatus, t.FInfo, t.FBeginTime, t.FEndTime, \n");
                sql.append("    o.FID FOrgUnitID, o.FNumber FOrgNumber, o.FName_" + loc + " FOrgName, \n");
                sql.append("    u.FID FCreatorID, u.FNumber FCreatorNumber, u.FName_" + loc + " FCreatorName \n");
                sql.append("from T_GL_ProgressTask t \n");
                sql.append("left join T_ORG_FullOrgUnit o on o.FID = t.FOrgUnitID \n");
                sql.append("left join T_PM_User u on u.FID = t.FCreatorID \n");
                sql.append("where t.FID = ? \n");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, id);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    task = new ProgressTaskInfo();
                    task.setId(BOSUuid.read((String)id));
                    task.setNumber(rs.getString("FNumber"));
                    task.setNumber(rs.getString("FName"));
                    String orgUnitId = rs.getString("FOrgUnitID");
                    if (orgUnitId != null) {
                        FullOrgUnitInfo org = new FullOrgUnitInfo();
                        org.setId(BOSUuid.read((String)orgUnitId));
                        org.setNumber(rs.getString("FOrgNumber"));
                        org.setNumber(rs.getString("FOrgName"));
                        task.setOrgUnit(org);
                    }
                    task.setProgress(rs.getInt("FProgress"));
                    task.setStatus(rs.getInt("FStatus"));
                    task.setInfo(rs.getString("FInfo"));
                    String creatorId = rs.getString("FCreatorID");
                    if (creatorId != null) {
                        UserInfo creator = new UserInfo();
                        creator.setId(BOSUuid.read((String)creatorId));
                        creator.setNumber(rs.getString("FCreatorNumber"));
                        creator.setNumber(rs.getString("FCreatorName"));
                        task.setCreator(creator);
                    }
                    task.setBeginTime(rs.getTimestamp("FBeginTime"));
                    task.setBeginTime(rs.getTimestamp("FEndTime"));
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                }
            }
            if (!forEntry) {
                sql = task;
                return sql;
            }
            if (task == null) {
                task = new ProgressTaskInfo();
                task.setId(BOSUuid.read((String)id));
            }
            if ((seq = (Integer)params.get("seq")) == null) {
                seq = 0;
            }
            if ((count = (Integer)params.get("count")) == null || count == 0) {
                count = 500;
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("select * \n");
            sql2.append("from T_GL_ProgressTaskEntry \n");
            sql2.append("where FParentID = ? \n");
            sql2.append("and FSeq >= ? and FSeq < ? \n");
            sql2.append("order by FSeq \n");
            ProgressTaskEntryCollection entries = task.getEntries();
            pstmt = conn.prepareStatement(sql2.toString());
            pstmt.setString(1, id);
            pstmt.setInt(2, seq);
            pstmt.setInt(3, seq + count);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ProgressTaskEntryInfo entry = new ProgressTaskEntryInfo();
                entry.setId(BOSUuid.read((String)rs.getString("FID")));
                entry.setSeq(rs.getInt("FSeq"));
                entry.setLevel(rs.getInt("FProgress"));
                entry.setLevel(rs.getInt("FStatus"));
                entry.setLevel(rs.getInt("FLevel"));
                entry.setAppend(rs.getInt("FAppend"));
                entry.setInfo(rs.getString("FInfo"));
                if (entry.getInfo() == null) {
                    entry.setInfo("");
                }
                entry.setBeginTime(rs.getTimestamp("FBeginTime"));
                entry.setBeginTime(rs.getTimestamp("FEndTime"));
                entries.add(entry);
            }
            ProgressTaskInfo progressTaskInfo = task;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return progressTaskInfo;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
    }
}

