/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.IProgressTask;
import com.kingdee.eas.fi.gl.ProgressTaskEntryCollection;
import com.kingdee.eas.fi.gl.ProgressTaskEntryInfo;
import com.kingdee.eas.fi.gl.ProgressTaskFactory;
import com.kingdee.eas.fi.gl.ProgressTaskInfo;
import java.util.ArrayList;
import java.util.List;

public class ProgressTaskProcessor {
    protected Context ctx;
    protected ProgressTaskInfo task = null;
    protected ProgressTaskEntryCollection entries = null;
    protected int bufferSize;
    protected int seq = 0;
    protected IProgressTask iProgressTask = null;

    public ProgressTaskProcessor(Context ctx, ProgressTaskInfo task) {
        this(ctx, task, 1);
    }

    public ProgressTaskProcessor(Context ctx, ProgressTaskInfo task, int seq) {
        this(ctx, task, seq, 20);
    }

    public ProgressTaskProcessor(Context ctx, ProgressTaskInfo task, int seq, int bufferSize) {
        this.ctx = ctx;
        this.task = task;
        this.entries = new ProgressTaskEntryCollection();
        if (seq <= 0) {
            seq = 1;
        }
        this.seq = seq;
        if (bufferSize <= 0) {
            bufferSize = 10;
        }
        this.bufferSize = bufferSize;
    }

    protected IProgressTask getInterface() throws BOSException {
        return ProgressTaskFactory.getLocalInstance(this.ctx);
    }

    public List<String> split(String msg, int size) {
        ArrayList<String> strs = new ArrayList<String>();
        if (msg == null) {
            msg = "";
        }
        if (msg.length() <= size) {
            strs.add(msg);
            return strs;
        }
        while (msg.length() > size) {
            strs.add(msg.substring(0, size));
            msg = msg.substring(size);
        }
        if (msg.length() > 0) {
            strs.add(msg);
        }
        return strs;
    }

    public void debug(String msg) {
        this.log(msg, 0);
    }

    public void info(String msg) {
        this.log(msg, 1);
    }

    public void warn(String msg) {
        this.log(msg, 2);
    }

    public void error(String msg) {
        this.log(msg, 3);
    }

    public void exec(String msg) {
        this.log(msg, 4);
    }

    public void log(String msg, int level) {
        List<String> strs = this.split(msg, 256);
        for (int i = 0; i < strs.size(); ++i) {
            ProgressTaskEntryInfo entry = new ProgressTaskEntryInfo();
            entry.setParent(this.task);
            entry.setSeq(this.seq++);
            entry.setAppend(i);
            entry.setLevel(level);
            entry.setInfo(strs.get(i));
            this.add(entry);
        }
    }

    protected void add(ProgressTaskEntryInfo entry) {
        this.entries.add(entry);
        if (this.entries.size() >= this.bufferSize) {
            try {
                this.getInterface().addEntries(this.entries);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.entries.clear();
        }
    }

    public void close() {
        if (this.entries.size() > 0) {
            try {
                this.getInterface().addEntries(this.entries);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.entries.clear();
        }
    }

    public static void main(String[] args) {
        int time = 200;
        System.out.println(200);
        for (int i = 0; i < 10; ++i) {
            time = (int)((double)time + (double)time * 0.6);
            System.out.println(time);
        }
    }
}

