/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.fi.gl.app.GLQuartzJob;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RefreshDSJob
extends GLQuartzJob {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RefreshDSJob");

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        try {
            ArrayList newList = DCManager.getInstance().getDCList();
            Vector ctxs = (Vector)ctx.getJobDetail().getJobDataMap().get((Object)"ctxs");
            this.refreshContextList(newList, ctxs);
        }
        catch (Exception ex) {
            logger.error((Object)"refresh DS error!", (Throwable)ex);
        }
    }

    private void refreshContextList(List newList, Vector ctxs) throws BOSException {
        this.addContext(newList, ctxs);
        this.removeContext(newList, ctxs);
    }

    private void addContext(List newList, Vector ctxs) throws BOSException {
        for (int i = 0; i < newList.size(); ++i) {
            Context ctx;
            DCInfo info = (DCInfo)newList.get(i);
            boolean isFound = false;
            for (int j = 0; j < ctxs.size(); ++j) {
                if (!info.getNumber().equals(((Context)ctxs.get(j)).getAIS())) continue;
                isFound = true;
                break;
            }
            if (isFound || !this.isContextUsable(ctx = this.createContext(info), "GL refresh ds error,")) continue;
            ctxs.add(ctx);
            this.initTranStatus(ctx);
        }
    }

    private void removeContext(List newList, Vector ctxs) {
        if (ctxs.size() > newList.size()) {
            for (int i = 0; i < ctxs.size(); ++i) {
                boolean isFound = false;
                for (int j = 0; j < newList.size(); ++j) {
                    if (!((Context)ctxs.get(i)).getAIS().equals(((DCInfo)newList.get(j)).getNumber())) continue;
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                ctxs.remove(i);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTranStatus(Context ctx) {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            conn.setAutoCommit(true);
            statement.execute("update t_bas_transaction set ftimecount = 0, fisupdating=0 where fnumber = 'updatebalance' and fsystype = 6");
            if ("Oracle".equals(ctx.get((Object)"dbType"))) {
                rs = statement.executeQuery("/*dialect*/select table_name from user_tables where table_name like 'GLT%'");
                HashSet<String> tableSet = new HashSet<String>();
                while (rs.next()) {
                    tableSet.add(rs.getString("table_name"));
                }
                Iterator tableIt = tableSet.iterator();
                while (tableIt.hasNext()) {
                    try {
                        statement.execute("/*dialect*/drop table " + (String)tableIt.next());
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"clean gl temp table fail!", (Throwable)ex);
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"initTranStatus error!", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
        }
    }

    private Context createContext(DCInfo dc) {
        Context ctx = new Context(null, dc.getSolutionName(), dc.getNumber(), null);
        ctx.setUserName(dc.getUserName());
        ctx.put((Object)"dbType", (Object)this.getDBType(dc.getDBType()));
        return ctx;
    }

    private String getDBType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2";
            }
        }
        return "Oracle";
    }
}

