/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.RegisteredServiceCollection;
import com.kingdee.eas.fi.gl.RegisteredServiceFactory;
import com.kingdee.eas.fi.gl.RegisteredServiceInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RegisteredServiceUtil {
    private static final Logger logger = Logger.getLogger(RegisteredServiceUtil.class);

    public static void invokeService(Context ctx, String serviceName, Map<String, Object> param) throws BOSException {
        RegisteredServiceCollection services = RegisteredServiceFactory.getLocalInstance(ctx).getRegisteredServices(serviceName);
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            RegisteredServiceInfo service = (RegisteredServiceInfo)iter.next();
            try {
                Class<?> serviceClass = Class.forName(service.getClassName());
                Method serviceMethod = serviceClass.getMethod(service.getMethodName(), Map.class);
                Object serviceInstance = serviceClass.newInstance();
                serviceMethod.invoke(serviceInstance, param);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)("\u8c03\u7528\u6ce8\u518c\u670d\u52a1(" + serviceName + ")\u5931\u8d25"));
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }
}

