/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeNewUtils;
import com.kingdee.eas.fi.gl.app.dataProcess.CompareType;
import com.kingdee.eas.fi.gl.app.dataProcess.DataProcessEngine;
import com.kingdee.eas.fi.gl.app.dataProcess.FieldType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.Field;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumFieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.WhereExpresion;
import com.kingdee.eas.fi.gl.app.dataProcess.function.CommonFunction;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptAgeCalculation {
    private static Logger logger = Logger.getLogger((String)RptAgeCalculation.class.getClass().getName());
    private Map<String, List<Map<String, Object>>> sourceDataMap = new HashMap<String, List<Map<String, Object>>>();
    private Map<String, CurrencyRateConvertInfo> exchRateMap = null;
    public static Map<String, Map<String, CurrencyRateConvertInfo>> exchRateMapCache = new HashMap<String, Map<String, CurrencyRateConvertInfo>>();

    public List<Map<String, Object>> queryRptAge(AccountAgeParam paramAge, String acTable) throws EASBizException, BOSException {
        paramAge.setRptQuery(true);
        if (!this.beforeVerifyRpt(paramAge)) {
            return null;
        }
        DataProcessEngine dataProcess = new DataProcessEngine(paramAge.getCtx(), acTable);
        try {
            if (this.sourceDataMap.containsKey(acTable)) {
                dataProcess.sourceData = this.sourceDataMap.get(acTable);
            } else {
                dataProcess.queryData();
                this.sourceDataMap.put(acTable, dataProcess.sourceData);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query temp data error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.afterVerifyRpt(paramAge, dataProcess);
        return this.dealRptResult(dataProcess);
    }

    private boolean beforeVerifyRpt(AccountAgeParam paramAge) throws BOSException, EASBizException {
        GLAcctAgeNewUtils.dealwithRpt_Param(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AmountField(paramAge);
        GLAcctAgeNewUtils.getRptSql_ByAcctBal_Param_AlDates(paramAge);
        GLAcctAgeNewUtils.prepareTempTableAdjExch(paramAge);
        if (paramAge.isGeneralCy()) {
            this.exchRateMap = this.getExchRateData(paramAge);
        }
        GLAcctAgeNewUtils.getRptSql_ByAcctBal_SelectHgJoin(paramAge);
        return true;
    }

    private Map<String, CurrencyRateConvertInfo> getExchRateData(AccountAgeParam paramAge) throws BOSException {
        String exchRateTmp = paramAge.getTempTableExchRate();
        if (!StringUtils.isEmpty((String)exchRateTmp)) {
            if (exchRateMapCache.containsKey(exchRateTmp)) {
                return exchRateMapCache.get(exchRateTmp);
            }
            String sql = "select FID, FCONVERTRATEA, FPRECISION from " + exchRateTmp;
            IRowSet result = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql);
            try {
                HashMap<String, CurrencyRateConvertInfo> map = new HashMap<String, CurrencyRateConvertInfo>(3);
                while (result.next()) {
                    CurrencyRateConvertInfo currRateInfo = new CurrencyRateConvertInfo();
                    String currId = result.getString("FID");
                    currRateInfo.setCurrid(currId);
                    currRateInfo.setConvertRate(result.getBigDecimal("FCONVERTRATEA"));
                    BigDecimal precision = result.getBigDecimal("FPRECISION");
                    currRateInfo.setPrecision(precision == null ? 1 : precision.intValue());
                    map.put(currId, currRateInfo);
                }
                exchRateMapCache.put(exchRateTmp, map);
                return map;
            }
            catch (SQLException e) {
                logger.error((Object)"query exchRate temp table error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private void afterVerifyRpt(AccountAgeParam paramAge, DataProcessEngine dataProcess) {
        this.queryAgePeriodData(paramAge, dataProcess);
        if (paramAge.isGeneralCy()) {
            this.calculateLocalAmt4GeneralCy(dataProcess);
            this.insertTotalSumLines4GeneralCurency(paramAge, dataProcess);
        }
        this.calculateSumOverdue(dataProcess);
    }

    private void calculateLocalAmt4GeneralCy(DataProcessEngine dataProcess) {
        if (this.exchRateMap == null) {
            return;
        }
        List<Map<String, Object>> tmpData = dataProcess.getTmpData();
        for (Map<String, Object> rowData : tmpData) {
            String currid = (String)rowData.get("fcurrid");
            BigDecimal sum0 = (BigDecimal)rowData.get("sum0");
            BigDecimal sumunoverdue = (BigDecimal)rowData.get("sumunoverdue");
            CurrencyRateConvertInfo currencyRateConvertInfo = this.exchRateMap.get(currid);
            if (currencyRateConvertInfo == null) continue;
            BigDecimal convertRate = currencyRateConvertInfo.getConvertRate();
            int precision = currencyRateConvertInfo.getPrecision();
            sum0 = sum0 == null ? BigDecimal.ZERO : sum0.multiply(convertRate).setScale(precision, 4);
            sumunoverdue = sumunoverdue == null ? BigDecimal.ZERO : sumunoverdue.multiply(convertRate).setScale(precision, 4);
            rowData.put("sum0", sum0);
            rowData.put("sumunoverdue", sumunoverdue);
        }
    }

    private void insertTotalSumLines4GeneralCurency(AccountAgeParam paramAge, DataProcessEngine dataProcess) {
        String selecthgoutsiderealNoCy = paramAge.isIncludeVerifyVch() ? paramAge.getSqlSelecthgoutsideReal().toString().trim() : paramAge.getSqlSelecthgoutside().toString().trim();
        String strCy = "fcurrid,fcurrname,";
        selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.replace(strCy, "");
        String[] groupBy = selecthgoutsiderealNoCy.split(",");
        ArrayList<Field> groupByFields = new ArrayList<Field>(groupBy.length);
        for (String fieldName : groupBy) {
            Field groupByField = FieldObjectFactory.getInstance(fieldName, FieldType.String, fieldName);
            groupByFields.add(groupByField);
        }
        ArrayList<FunctionField> sumFields = new ArrayList<FunctionField>(2);
        SumField sum0 = SumFieldObjectFactory.getInstance("sum0", FieldType.BigDecimal, "sum0");
        sumFields.add(sum0);
        SumField sumunoverdue = SumFieldObjectFactory.getInstance("sumunoverdue", FieldType.BigDecimal, "sumunoverdue");
        sumFields.add(sumunoverdue);
        CommonFunction sumFunction = new CommonFunction(groupByFields, sumFields);
        HashMap<String, Object> defaultCol = new HashMap<String, Object>(2);
        defaultCol.put("fcurrid", "11111111-1111-1111-1111-111111111111DEB58FDC");
        defaultCol.put("fcurrname", "(" + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"general_locale_currency", (Locale)Locale.getDefault()) + ")");
        dataProcess.sum(sumFunction, defaultCol);
        ArrayList<WhereExpresion> whereExps = new ArrayList<WhereExpresion>(1);
        WhereExpresion whereExp = new WhereExpresion("fcurrid", CompareType.NOTEQUALS, paramAge.getCurrency().getId().toString());
        whereExps.add(whereExp);
        dataProcess.delete(whereExps);
    }

    private void queryAgePeriodData(AccountAgeParam paramAge, DataProcessEngine dataProcess) {
        StringBuffer selectFields = paramAge.getSqlSelecthgoutside();
        String[] fieldArray = selectFields.toString().split(",");
        ArrayList<WhereExpresion> whereExps = new ArrayList<WhereExpresion>();
        Object[] companyIds = paramAge.getCompanyId().replace("'", "").split(",");
        HashSet companyIdSet = new HashSet(Arrays.asList((Object[])companyIds));
        WhereExpresion companyIdWhere = new WhereExpresion("fcompanyid", CompareType.INCLUDE, companyIdSet);
        whereExps.add(companyIdWhere);
        Object[] accountIds = paramAge.getAccountid().replace("'", "").split(",");
        HashSet accountIdSet = new HashSet(Arrays.asList((Object[])accountIds));
        WhereExpresion accountIdWhere = new WhereExpresion("faccountid", CompareType.INCLUDE, accountIdSet);
        whereExps.add(accountIdWhere);
        if (paramAge.isSetCurrency()) {
            WhereExpresion curridExp = new WhereExpresion("fcurrid", CompareType.EQUALS, paramAge.getCurrencyid());
            whereExps.add(curridExp);
        }
        if (paramAge.getAsstActNumbers() != null && paramAge.getAsstActNumbers().size() > 0) {
            List<String[][]> asstActNumbers = paramAge.getAsstActNumbers();
            for (String[][] asstActInfo : asstActNumbers) {
                if (asstActInfo[0][0] != null) {
                    WhereExpresion asstActWhere1 = new WhereExpresion(asstActInfo[0][0], CompareType.GREATER_EQUALS, asstActInfo[0][1]);
                    whereExps.add(asstActWhere1);
                }
                if (asstActInfo[1][0] == null) continue;
                WhereExpresion asstActWhere2 = new WhereExpresion(asstActInfo[1][0], CompareType.LESS_EQUALS, asstActInfo[1][1]);
                whereExps.add(asstActWhere2);
            }
        }
        ArrayList<Field> groupByFields = new ArrayList<Field>(fieldArray.length);
        for (String fieldName : fieldArray) {
            Field groupByField = FieldObjectFactory.getInstance(fieldName, FieldType.String, fieldName);
            groupByFields.add(groupByField);
        }
        ArrayList dateList = paramAge.getAlDates();
        ArrayList<FunctionField> sumFields = new ArrayList<FunctionField>(2);
        if (dateList.size() > 0) {
            String dateFiled = paramAge.getStrDateType_AC();
            dateFiled = "fenddate".equalsIgnoreCase(dateFiled.toLowerCase()) ? "fenddate" : "fbizdate";
            ArrayList<WhereExpresion> caseWhen1 = new ArrayList<WhereExpresion>(1);
            WhereExpresion whereExp = new WhereExpresion(dateFiled, CompareType.GREATER_EQUALS, new Timestamp(((Date)dateList.get(0)).getTime()));
            caseWhen1.add(whereExp);
            SumField sumUnOverDue = SumFieldObjectFactory.getInstance("funverifiedamtfor", FieldType.BigDecimal, "sumunoverdue", caseWhen1);
            sumFields.add(sumUnOverDue);
            if (paramAge.isShowUmexpired()) {
                if (paramAge.getUndaylen() == 1) {
                    ArrayList<WhereExpresion> caseWhen2 = new ArrayList<WhereExpresion>(1);
                    WhereExpresion whereExp1 = new WhereExpresion(dateFiled, CompareType.GREATER_EQUALS, new Timestamp(((Date)dateList.get(1)).getTime()));
                    caseWhen2.add(whereExp1);
                    SumField sum0 = SumFieldObjectFactory.getInstance("funverifiedamtfor", FieldType.BigDecimal, "sum0", caseWhen2);
                    sumFields.add(sum0);
                } else {
                    ArrayList<WhereExpresion> caseWhen2 = new ArrayList<WhereExpresion>(2);
                    WhereExpresion whereExp1 = new WhereExpresion(dateFiled, CompareType.GREATER_EQUALS, new Timestamp(((Date)dateList.get(1)).getTime()));
                    caseWhen2.add(whereExp1);
                    WhereExpresion whereExp2 = new WhereExpresion(dateFiled, CompareType.LESS_EQUALS, new Timestamp(((Date)dateList.get(2)).getTime()));
                    caseWhen2.add(whereExp2);
                    SumField sum0 = SumFieldObjectFactory.getInstance("funverifiedamtfor", FieldType.BigDecimal, "sum0", caseWhen2);
                    sumFields.add(sum0);
                }
            } else {
                ArrayList<WhereExpresion> caseWhen3 = new ArrayList<WhereExpresion>(2);
                WhereExpresion whereExp1 = new WhereExpresion(dateFiled, CompareType.LESS, new Timestamp(((Date)dateList.get(1)).getTime()));
                caseWhen3.add(whereExp1);
                WhereExpresion whereExp2 = new WhereExpresion(dateFiled, CompareType.GREATER_EQUALS, new Timestamp(((Date)dateList.get(2)).getTime()));
                caseWhen3.add(whereExp2);
                SumField sum0 = SumFieldObjectFactory.getInstance("funverifiedamtfor", FieldType.BigDecimal, "sum0", caseWhen3);
                sumFields.add(sum0);
            }
        }
        CommonFunction sumFunction = new CommonFunction(groupByFields, sumFields);
        HashMap<String, Object> defaultCol = new HashMap<String, Object>(1);
        defaultCol.put("sumoverdue", BigDecimal.ZERO);
        dataProcess.where(whereExps).sum(sumFunction, defaultCol).getTmpData();
    }

    private void calculateSumOverdue(DataProcessEngine dataProcess) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(1);
        fieldMap.put("sumoverdue", "sum0");
        dataProcess.updateByField(fieldMap);
    }

    private List<Map<String, Object>> dealRptResult(DataProcessEngine dataProcess) throws BOSException, EASBizException {
        ArrayList<String> selectFields = new ArrayList<String>(3);
        selectFields.add("sumunoverdue");
        selectFields.add("sumoverdue");
        selectFields.add("sum0");
        return dataProcess.select(selectFields, FieldType.BigDecimal);
    }

    public static class CurrencyRateConvertInfo {
        private String currid = null;
        private BigDecimal convertRate = null;
        private int precision = 0;

        public String getCurrid() {
            return this.currid;
        }

        public void setCurrid(String currid) {
            this.currid = currid;
        }

        public BigDecimal getConvertRate() {
            return this.convertRate;
        }

        public void setConvertRate(BigDecimal convertRate) {
            this.convertRate = convertRate;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }
    }
}

