/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractRptAsstactGDControllerBean;
import com.kingdee.eas.fi.gl.app.ColumnAttributeInfo;
import com.kingdee.eas.fi.gl.app.ColumnAttributeList;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RptAsstactGDControllerBean
extends AbstractRptAsstactGDControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactGDControllerBean");
    private static final long serialVersionUID = 1593494507643006540L;
    private static final int ROW_TYPE_INIT = 0;
    private static final int ROW_TYPE_DATA = 1;
    private static final int ROW_TYPE_PERIOD = 2;
    private static final int ROW_TYPE_YEAR = 3;
    private static final int ROW_TYPE_SUBTOTAL = 4;
    protected String accountFrom = null;
    protected String accountTo = null;
    protected String asstAccountID = null;
    protected String currencyId = null;
    protected String measureUnitID = null;
    protected boolean noDisplayZero = false;
    protected boolean noDisplayAllZero = false;
    protected boolean noDisplayZeroTotal = false;
    protected boolean displayAmount = false;
    protected boolean sumByMeasureUnit = false;
    protected boolean exchangeStandardUnit = false;
    protected MeasureUnitInfo standardUnit = null;
    protected boolean includeUnPost = false;
    protected boolean displayAttribute = false;
    protected int beginPeriod = -1;
    protected int endPeriod = -1;
    protected int levelFrom = -1;
    protected int levelTo = -1;
    protected boolean onlyEndPeriod = false;
    protected boolean isPrint = false;
    protected String balanceTempTable = null;
    protected int beginYear = -1;
    protected int beginNumber = -1;
    protected int endYear = -1;
    protected int endNumber = -1;
    protected int periodYear = -1;
    protected int periodNumber = -1;
    protected boolean showSum = false;
    private String subTotal = null;
    private boolean showAsstUnitAndQty = false;
    private final String[] amtColumn = new String[]{"fdebit_for", "fdebit_local", "fdebit_rpt", "fcredit_for", "fcredit_local", "fcredit_rpt", "fbalance_for", "fbalance_local", "fbalance_rpt"};
    private final String[] others = new String[]{"fdescription", "frowtype", "fprecision"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.initFilterItem(ctx, params);
        RptParams rpt = new RptParams();
        String tempTableName = this.insertVoucherDetail(ctx, params);
        params.setString("tempTableName", tempTableName);
        if (this.onlyEndPeriod) {
            this.getYearAndPeriod(ctx, params);
        }
        try {
            if (this.sumByMeasureUnit) {
                this.insertSumMeasureUnit(ctx, params, tempTableName);
            }
            SqlParams sp = new SqlParams();
            StringBuffer fromWhere = this.getBalanceFromAndWhereSQL(ctx, params, sp, false);
            boolean isNull = false;
            isNull = this.getTableIsNull(ctx, tempTableName);
            this.insertPeriodBeginBalance(ctx, params, tempTableName, fromWhere, sp);
            if (!(isNull && this.noDisplayZeroTotal && this.onlyEndPeriod)) {
                this.insertPeiordAndYearBalance(ctx, params, tempTableName, fromWhere, sp);
            }
            StringBuffer sql1 = new StringBuffer();
            sql1.append(" select GL.FYearDebitFor FYearDebitFor, GL.FYearDebitLocal FYearDebitLocal,GL.FYearDebitRpt FYearDebitRpt,");
            sql1.append("GL.FYearCreditFor FYearCreditFor,GL.FYearCreditLocal FYearCreditLocal,GL.FYearCreditRpt FYearCreditRpt,");
            sql1.append("GL.FEndBalanceFor FEndBalanceFor,GL.FEndBalanceLocal FEndBalanceLocal,GL.FEndBalanceRpt FEndBalanceRpt,");
            sql1.append("GL.FDebitFor FDebit_for,GL.FDebitLocal FDebit_local, GL.FDebitRpt FDebit_rpt,");
            sql1.append("GL.FCreditFor FCredit_for,GL.FCreditLocal FCredit_local,GL.FCreditRpt FCredit_rpt,");
            sql1.append("AV.Fid FAccount,AV.Fnumber FAccountNumber,");
            sql1.append("PE.FID FPeriodID, PE.FNumber FPeriod, PE.FPeriodYear, PE.FPeriodNumber");
            sql1.append(fromWhere);
            sql1.append("\t order by AV.Fnumber,PE.Fnumber");
            RptRowSet rsTaoda = this.executeQuery(sql1.toString(), sp, ctx);
            if (this.onlyEndPeriod) {
                this.doUpdatePeriodData(ctx, tempTableName);
            }
            if (this.showAsstUnitAndQty) {
                this.setAssCou(ctx, tempTableName);
            }
            if (this.showSum) {
                this.insertSumResultNew(ctx, tempTableName, params);
            }
            StringBuffer querySQL = new StringBuffer();
            querySQL.append(" select * from ").append(tempTableName);
            SorterItemCollection sorters = null;
            EntityViewInfo conditionClone = (EntityViewInfo)params.getObject("selfCond");
            if (conditionClone != null) {
                sorters = conditionClone.getSorter();
                for (int i = 0; i < sorters.size(); ++i) {
                    SorterItemInfo sorterItem = sorters.get(i);
                    String propertyName = sorterItem.getPropertyName();
                    if ("number".equalsIgnoreCase(propertyName)) {
                        sorterItem.setPropertyName("FVoucherNo");
                        continue;
                    }
                    if ("voucherType.number".equalsIgnoreCase(propertyName)) {
                        sorterItem.setPropertyName("FVoucherTypeNumber");
                        continue;
                    }
                    if ("assistRecords.bizDate".equalsIgnoreCase(propertyName)) {
                        sorterItem.setPropertyName("FBizDate");
                        continue;
                    }
                    if ("bookedDate".equalsIgnoreCase(propertyName)) {
                        sorterItem.setPropertyName("FBookedDate");
                        continue;
                    }
                    if ("assistRecords.settlementCode".equalsIgnoreCase(propertyName)) {
                        sorterItem.setPropertyName("FSettlementCode");
                        continue;
                    }
                    if ("settlementType.number".equalsIgnoreCase(propertyName)) {
                        sorterItem.setPropertyName("settleName");
                        continue;
                    }
                    if (!"assistRecords.bizNumber".equalsIgnoreCase(propertyName)) continue;
                    sorterItem.setPropertyName("FBizNumber");
                }
            }
            querySQL.append(" order by ");
            boolean isFirstPeriod = false;
            Object isFirstPeriodObj = params.getObjectElement("rdFirstPeriod.value");
            if (isFirstPeriodObj != null) {
                isFirstPeriod = (Boolean)isFirstPeriodObj;
            }
            if (isFirstPeriod) {
                querySQL.append("FPeriodYear, FPeriodNumber, ");
            }
            querySQL.append(" FAccountNumber, ");
            if (this.currencyId == null) {
                querySQL.append("FCurrencyNumber,");
            }
            if (!isFirstPeriod) {
                querySQL.append(" FPeriodYear, FPeriodNumber,");
            }
            querySQL.append(" FRowType,");
            if (sorters != null && sorters.size() > 0) {
                querySQL.append(sorters.toString());
                querySQL.append(",");
            }
            querySQL.append("FCreateTime, FSeq ");
            if (this.displayAmount) {
                querySQL.append(",FMeasureUnitNumber");
                if (this.sumByMeasureUnit) {
                    querySQL.append(",isSumMU");
                }
            }
            RptRowSet rs = this.executeQuery(querySQL.toString(), null, ctx);
            rpt.setObject("rs", (Object)rs);
            rpt.setObject("rsTaoda", (Object)rsTaoda);
        }
        finally {
            this.dropPoolTempTable(ctx, tempTableName);
        }
        return rpt;
    }

    protected void initFilterItem(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        if (params.getObjectElement("jbxCurrency.value.id") != null) {
            this.currencyId = params.getObjectElement("jbxCurrency.value.id").toString();
        }
        if (params.getObjectElement("jcbDisplayAmount.value") != null) {
            this.displayAmount = (Boolean)params.getObjectElement("jcbDisplayAmount.value");
        }
        if (params.getObjectElement("jcbDisplayAttribute.value") != null) {
            this.displayAttribute = (Boolean)params.getObjectElement("jcbDisplayAttribute.value");
        }
        if (params.getObjectElement("jcbShowSum.value") != null) {
            this.showSum = (Boolean)params.getObjectElement("jcbShowSum.value");
        }
        this.subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal", (Locale)ctx.getLocale());
        if (params.getObjectElement("jebMeasureUnit.value") != null) {
            this.measureUnitID = ((MeasureUnitInfo)params.getObjectElement("jebMeasureUnit.value")).getId().toString();
        }
        if (params.getObjectElement("jcbSumByMeasureUnit.value") != null) {
            this.sumByMeasureUnit = (Boolean)params.getObjectElement("jcbSumByMeasureUnit.value");
        }
        if (params.getObjectElement("jcbExchangeStandardUnit.value") != null) {
            this.exchangeStandardUnit = (Boolean)params.getObjectElement("jcbExchangeStandardUnit.value");
        }
        this.standardUnit = (MeasureUnitInfo)params.getObject("standardUnitValue");
        if (!this.displayAmount || this.standardUnit == null) {
            this.exchangeStandardUnit = false;
        }
        if (this.measureUnitID != null) {
            this.standardUnit = null;
            this.exchangeStandardUnit = false;
        }
        if (params.getObjectElement("jcbNoDisplayZero.value") != null) {
            this.noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        }
        if (params.getObjectElement("jcbNoDisplayAllZero.value") != null) {
            this.noDisplayAllZero = (Boolean)params.getObjectElement("jcbNoDisplayAllZero.value");
        }
        if (params.getObjectElement("jcbNoDisplayZeroTotal.value") != null) {
            this.noDisplayZeroTotal = (Boolean)params.getObjectElement("jcbNoDisplayZeroTotal.value");
        }
        if (params.getObjectElement("jcbEndPeriod.value") != null) {
            this.onlyEndPeriod = (Boolean)params.getObjectElement("jcbEndPeriod.value");
        }
        if (params.getObjectElement("jspLevelFrom.value") != null) {
            this.levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
        }
        if (params.getObjectElement("jspLevelTo.value") != null) {
            this.levelTo = (Integer)params.getObjectElement("jspLevelTo.value");
        }
        this.accountFrom = (String)params.getObjectElement("jebAccountFrom.value.number");
        this.accountTo = (String)params.getObjectElement("jebAccountTo.value.number");
        this.asstAccountID = (String)params.getObjectElement("jebAcct.value.id.toString");
        this.beginPeriod = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
        int endPeriodYear = (Integer)params.getObjectElement("jspYearTo.value");
        int endPeriodNumber = (Integer)params.getObjectElement("jspPeriodTo.value");
        this.endPeriod = endPeriodYear * 100 + endPeriodNumber;
        this.beginYear = (Integer)params.getObjectElement("jspYearFrom.value");
        this.beginNumber = (Integer)params.getObjectElement("jspPeriodFrom.value");
        this.endYear = endPeriodYear;
        this.endNumber = endPeriodNumber;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        boolean isUnit = GlUtils.isCompanyUnion(company);
        if (isUnit) {
            AccountTableInfo accountTableInfo = (AccountTableInfo)params.getObjectElement("bpAccount.value");
            company.setAccountTable(accountTableInfo);
        } else {
            company = RptServerUtil.getCompany(ctx, company, endPeriodYear, endPeriodNumber);
        }
        params.setObject("company", (Object)company);
        this.isAsstAccountHasMaterial(ctx, this.asstAccountID, params);
    }

    public Map queryPeriodMap(String periodTypeId, int[] periodRange, Context ctx) throws BOSException, EASBizException {
        String sql = "select FPeriodYear, FPeriodNumber, FBeginDate, FEndDate from T_BD_Period where FTypeID=? and FNumber>=? and FNumber<=? order by FNumber";
        SqlParams sp = new SqlParams();
        sp.addString(periodTypeId).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[2] * 100 + periodRange[3]);
        RptRowSet rs = this.executeQuery("select FPeriodYear, FPeriodNumber, FBeginDate, FEndDate from T_BD_Period where FTypeID=? and FNumber>=? and FNumber<=? order by FNumber", sp, ctx);
        HashMap<String, Object[]> periodMap = new HashMap<String, Object[]>();
        while (rs.next()) {
            periodMap.put(String.valueOf(rs.getInt("FPeriodYear") * 100 + rs.getInt("FPeriodNumber")), new Object[]{rs.getObject("FBeginDate"), rs.getObject("FEndDate")});
        }
        return periodMap;
    }

    @Override
    protected String getParentUIName() {
        return "com.kingdee.eas.fi.gl.client.RptAsstactGDUI";
    }

    @Override
    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.RptAsstactGDQuery";
    }

    protected StringBuffer getSelectSQL(Context ctx, RptParams params, int type) throws EASBizException, BOSException {
        String loc = this.getLoc(ctx);
        String tempTableName = params.getString("tempTableName");
        boolean isonlyEndPeriod = false;
        RptParams sysParams = (RptParams)params.getObject("sysParams");
        boolean isAccountShowLongName = sysParams.getBoolean("GL_012");
        boolean isShowAsstNumber = sysParams.getBoolean("GL_004");
        String accountName = this.getAccountName(ctx, isAccountShowLongName) + loc;
        StringBuffer selectSQL = new StringBuffer(" select ");
        if (params.getBoolean("isExportToExcel")) {
            boolean isShowLongNumber = sysParams.getBoolean("GL_064");
            List itemList = (List)params.getObject("actList");
            int itemCount = itemList.size();
            for (int i = 0; i < itemCount; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)itemList.get(i);
                selectSQL.append("T.FID").append(i).append(",");
                if (at.getHgAttribute().startsWith("general")) {
                    if (isShowLongNumber) {
                        if (isShowAsstNumber) {
                            selectSQL.append("replace(T.FLongNumber").append(i).append(",'!','.')||' '||").append("T.FName").append(i).append(" ASSTITEM").append(i).append(",");
                            continue;
                        }
                        selectSQL.append("replace(T.FLongNumber").append(i).append(",'!','.')||' '||").append("T.FName").append(i).append(" ASSTITEM").append(i).append(",");
                        continue;
                    }
                    if (isShowAsstNumber) {
                        selectSQL.append("T.FNumber").append(i).append("||' '||").append("T.FName").append(i).append(" ASSTITEM").append(i).append(",");
                        continue;
                    }
                    selectSQL.append("T.FNumber").append(i).append("||' '||").append("T.FName").append(i).append(" ASSTITEM").append(i).append(",");
                    continue;
                }
                if (isShowAsstNumber) {
                    selectSQL.append("T.FNumber").append(i).append("||").append("T.FName").append(i).append(" ASSTITEM").append(i).append(",");
                    continue;
                }
                selectSQL.append("T.FNumber").append(i).append("||' '||").append("T.FName").append(i).append(" ASSTITEM").append(i).append(",");
            }
        }
        selectSQL.append("AV.FID FAccountID,AV.FNumber FAccountNumber,").append(accountName).append(" FAccountName,AV.FDC,\n");
        switch (type) {
            case 1: {
                selectSQL.append("B.FID FVoucherID,A.FSeq FSeq, B.FBookedDate, B.FCreateTime, C.FBizDate,");
                selectSQL.append("D.FNumber FVoucherTypeNumber, D.FName_").append(loc).append(" FVoucherType, B.FNumber FVoucherNo,\n");
                selectSQL.append(this.getVoucherDescription(ctx, params));
                selectSQL.append("A.FLocalExchangeRate,A.FReportingExchangeRate,");
                selectSQL.append("case A.FEntryDC when 1 then C.FOriginalAmount else to_decimal(0.0,28,4) end FDebit_for,\n");
                selectSQL.append("case A.FEntryDC when 1 then C.FLocalAmount else to_decimal(0.0,28,4) end FDebit_local,\n");
                selectSQL.append("case A.FEntryDC when 1 then C.FReportingAmount else to_decimal(0.0,28,4) end FDebit_rpt,\n");
                selectSQL.append("case A.FEntryDC when 0 then C.FOriginalAmount else to_decimal(0.0,28,4) end FCredit_for,\n");
                selectSQL.append("case A.FEntryDC when 0 then C.FLocalAmount else to_decimal(0.0,28,4) end FCredit_local,\n");
                selectSQL.append("case A.FEntryDC when 0 then C.FReportingAmount else to_decimal(0.0,28,4) end FCredit_rpt,\n");
                selectSQL.append(" to_decimal(0.0,28,4) FBalance_for, to_decimal(0.0,28,4) FBalance_local,to_decimal(0.0,28,4) FBalance_rpt,\n");
                if (this.displayAmount) {
                    if (this.exchangeStandardUnit) {
                        selectSQL.append("case A.FEntryDC when 1 then C.FStandardQuantity ").append(" else to_decimal(0.0,28,4) end FDebitQty,\n");
                        selectSQL.append("case A.FEntryDC when 1 then (case C.FStandardQuantity when 0 then to_decimal(0.0,28,4) else C.FOriginalAmount/C.FStandardQuantity/MU.FCoefficient end) ").append(" else to_decimal(0.0,28,4) end FDebitPrice,\n");
                        selectSQL.append("case A.FEntryDC when 0 then C.FStandardQuantity").append(" else to_decimal(0.0,28,4) end FCreditQty,\n");
                        selectSQL.append("case A.FEntryDC when 0 then (case C.FStandardQuantity when 0 then to_decimal(0.0,28,4) else C.FOriginalAmount/C.FStandardQuantity/MU.FCoefficient end) ").append(" else to_decimal(0.0,28,4) end FCreditPrice,\n");
                        selectSQL.append("to_decimal(0.0,28,4) FEndQty, to_decimal(0.0,28,4) FBalancePrice,");
                        selectSQL.append("'" + this.standardUnit.getId() + "' FMUID,'" + this.standardUnit.getNumber() + "' FMeasureUnitNumber,'" + this.standardUnit.getName() + "' FMeasureUnitName, " + this.standardUnit.getCoefficient() + " FCoefficient ,\n");
                    } else {
                        selectSQL.append("case A.FEntryDC when 1 then C.FQuantity ").append(" else to_decimal(0.0,28,4) end FDebitQty,\n");
                        selectSQL.append("case A.FEntryDC when 1 then (case C.FQuantity when 0 then to_decimal(0.0,28,4) else C.FOriginalAmount/C.FQuantity end) ").append(" else to_decimal(0.0,28,4) end FDebitPrice,\n");
                        selectSQL.append("case A.FEntryDC when 0 then C.FQuantity").append(" else to_decimal(0.0,28,4) end FCreditQty,\n");
                        selectSQL.append("case A.FEntryDC when 0 then (case C.FQuantity when 0 then to_decimal(0.0,28,4) else C.FOriginalAmount/C.FQuantity end) ").append(" else to_decimal(0.0,28,4) end FCreditPrice,\n");
                        selectSQL.append("to_decimal(0.0,28,4) FEndQty, to_decimal(0.0,28,4) FBalancePrice,");
                        selectSQL.append("MU.FID FMUID,MU.FNumber FMeasureUnitNumber,MU.FName_" + loc + " FMeasureUnitName,MU.FCoefficient FCoefficient,\n");
                    }
                    if (this.sumByMeasureUnit) {
                        selectSQL.append("0 isSumMU,");
                    }
                    if (this.showAsstUnitAndQty) {
                        selectSQL.append("MUN.FName_" + loc + " FAssistUnitName, ");
                        selectSQL.append("case A.FEntryDC when 1 then C.FAssistQty ").append(" else to_decimal(0.0,28,4) end FDebitAssistQty,\n");
                        selectSQL.append("case A.FEntryDC when 1 then C.FAssistPrice ").append(" else to_decimal(0.0,28,4) end FDebitAssistPrice,\n");
                        selectSQL.append("case A.FEntryDC when 0 then C.FAssistQty ").append(" else to_decimal(0.0,28,4) end FCreditAssistQty,\n");
                        selectSQL.append("case A.FEntryDC when 0 then C.FAssistPrice ").append(" else to_decimal(0.0,28,4) end FCreditAssistPrice,\n");
                        selectSQL.append("case A.FEntryDC when 1 then MUN.FName_" + loc).append(" else to_char(null) end FDebitAssistUnitName,\n");
                        selectSQL.append("case A.FEntryDC when 0 then MUN.FName_" + loc).append(" else to_char(null) end FCreditAssistUnitName,\n");
                    }
                }
                if (!this.displayAttribute) break;
                selectSQL.append("C.FBizNumber,C.FInvoiceNumber,C.FSettlementCode,settle.FName_").append(loc).append(" settleName , C.FTicketNumber,");
                break;
            }
            case 0: {
                String description = GLResUtil.getRes("balance_period_begin", ctx);
                selectSQL.append("to_char(null) FVoucherID,to_int(null) FSeq,PE.FBeginDate FBookedDate,to_date(null) FCreateTime,to_date(null) FBizDate,");
                selectSQL.append("to_char(null) FVoucherTypeNumber,to_char(null) FVoucherType,to_char(null) FVoucherNo,N'").append(description).append("' FDescription,");
                selectSQL.append("to_decimal(null) FLocalExchangeRate,to_decimal(null) FReportingExchangeRate,");
                selectSQL.append("to_decimal(0.0,28,4) FDebit_for, to_decimal(0.0,28,4) FDebit_local, to_decimal(0.0,28,4) FDebit_rpt,");
                selectSQL.append("to_decimal(0.0,28,4) FCredit_for,to_decimal(0.0,28,4) FCredit_local,to_decimal(0.0,28,4) FCredit_rpt,");
                selectSQL.append("sum(GL.FBeginBalanceFor) FBalance_for,sum(GL.FBeginBalanceLocal) FBalance_local,sum(GL.FBeginBalanceRpt) FBalance_rpt,\n");
                if (this.displayAmount) {
                    selectSQL.append("to_decimal(0.0,28,4) FDebitQty, to_decimal(0.0,28,4) FDebitPrice, \n");
                    selectSQL.append("to_decimal(0.0,28,4) FCreditQty,to_decimal(0.0,28,4) FCreditPrice,\n");
                    selectSQL.append("sum(GL.FBeginQty) FEndQty, to_decimal(0.0,28,4) FBalancePrice,\n");
                    selectSQL.append("to_char(null) FMUID,to_char(null) FMeasureUnitNumber, to_char(null) FMeasureUnitName,to_int(null) FCoefficient,\n");
                    if (this.sumByMeasureUnit) {
                        selectSQL.append("0 isSumMU,");
                    }
                    if (this.showAsstUnitAndQty) {
                        selectSQL.append("to_char(null) FAssistUnitName, to_decimal(0.0,28,4) FDebitAssistQty ,  to_decimal(0.0,28,4) FDebitAssistPrice, to_decimal(0.0,28,4) FCreditAssistQty ,  to_decimal(0.0,28,4) FCredittAssistPrice, \n");
                        selectSQL.append("to_char(null) FDebitAssistUnitName, to_char(null) FCreditAssistUnitName ,");
                    }
                }
                if (!this.displayAttribute) break;
                selectSQL.append("to_char(null) FBizNumber,to_char(null) FInvoiceNumber,to_char(null) FSettlementCode,to_char(null) settleName, to_char(null) FTicketNumber,");
                break;
            }
            case 2: {
                isonlyEndPeriod = true;
                String description = GLResUtil.getRes("period_total", ctx);
                selectSQL.append("to_char(null) FVoucherID,to_int(null) FSeq,");
                if (this.onlyEndPeriod) {
                    selectSQL.append(" to_char(null) FBookedDate ");
                } else {
                    selectSQL.append(" PE.FEndDate FBookedDate ");
                }
                selectSQL.append(" ,to_date(null) FCreateTime,to_date(null) FBizDate, \r\n");
                selectSQL.append(" to_char(null) FVoucherTypeNumber,to_char(null) FVoucherType,to_char(null) FVoucherNo, N'").append(description).append("' FDescription, \r\n");
                selectSQL.append(" to_decimal(null) FLocalExchangeRate,to_decimal(null) FReportingExchangeRate, \r\n");
                selectSQL.append(" sum(GL.FDebitFor) FDebit_for, \r\n");
                selectSQL.append(" sum(GL.FDebitLocal) FDebit_local, \r\n");
                selectSQL.append(" sum(GL.FDebitRpt) FDebit_rpt, \r\n");
                selectSQL.append(" sum(GL.FCreditFor) FCredit_for, \r\n");
                selectSQL.append(" sum(GL.FCreditLocal) FCredit_local, \r\n");
                selectSQL.append(" sum(GL.FCreditRpt) FCredit_rpt, \r\n");
                selectSQL.append(" sum(GL.FEndBalanceFor) FBalance_for, \r\n");
                selectSQL.append(" sum(GL.FEndBalanceLocal) FBalance_local, \r\n");
                selectSQL.append(" sum(GL.FEndBalanceRpt) FBalance_rpt, \r\n ");
                if (this.displayAmount) {
                    selectSQL.append(" sum(GL.FDebitQty) FDebitQty, to_decimal(0.0,28,4) FDebitPrice, \r\n");
                    selectSQL.append(" sum(GL.FCreditQty) FCreditQty,to_decimal(0.0,28,4) FCreditPrice, \r\n");
                    selectSQL.append(" sum(GL.FEndQty) FEndQty,to_decimal(0.0,28,4) FBalancePrice, \r\n");
                    if (this.standardUnit != null) {
                        selectSQL.append("'" + this.standardUnit.getId() + "' FMUID,'" + this.standardUnit.getNumber() + "' FMeasureUnitNumber,'" + this.standardUnit.getName() + "' FMeasureUnitName,to_int(1) FCoefficient, \r\n");
                    } else {
                        selectSQL.append("to_char(null) FMUID,to_char(null) FMeasureUnitNumber, to_char(null) FMeasureUnitName, to_int(null) FCoefficient, \r\n");
                    }
                    if (this.sumByMeasureUnit) {
                        selectSQL.append("0 isSumMU,");
                    }
                    if (this.showAsstUnitAndQty) {
                        selectSQL.append("to_char(null) FAssistUnitName, to_decimal(0.0,28,4) FDebitAssistQty ,  to_decimal(0.0,28,4) FDebitAssistPrice, to_decimal(0.0,28,4) FCreditAssistQty ,  to_decimal(0.0,28,4) FCredittAssistPrice, \n");
                        selectSQL.append("to_char(null) FDebitAssistUnitName, to_char(null) FCreditAssistUnitName ,");
                    }
                }
                if (!this.displayAttribute) break;
                selectSQL.append("to_char(null) FBizNumber,to_char(null) FInvoiceNumber,to_char(null) FSettlementCode,to_char(null) settleName, to_char(null) FTicketNumber,");
                break;
            }
            case 3: {
                String description = GLResUtil.getRes("sum_year", ctx);
                selectSQL.append(" to_char(null) FVoucherID,to_int(null) FSeq,");
                if (this.onlyEndPeriod) {
                    selectSQL.append(" to_char(null) FBookedDate ");
                } else {
                    selectSQL.append(" PE.FEndDate FBookedDate ");
                }
                selectSQL.append(" ,to_date(null) FCreateTime,to_date(null) FBizDate, \r\n");
                selectSQL.append(" to_char(null) FVoucherTypeNumber,to_char(null) FVoucherType,to_char(null) FVoucherNo, N'").append(description).append("' FDescription, \r\n");
                selectSQL.append(" to_decimal(null) FLocalExchangeRate,to_decimal(null) FReportingExchangeRate, \r\n");
                selectSQL.append(" sum(GL.FYearDebitFor) FDebit_for, \r\n");
                selectSQL.append(" sum(GL.FYearDebitLocal) FDebit_local, \r\n");
                selectSQL.append(" sum(GL.FYearDebitRpt) FDebit_rpt, \r\n");
                selectSQL.append(" sum(GL.FYearCreditFor) FCredit_for, \r\n");
                selectSQL.append(" sum(GL.FYearCreditLocal) FCredit_local, \r\n");
                selectSQL.append(" sum(GL.FYearCreditRpt) FCredit_rpt, \r\n");
                selectSQL.append(" sum(GL.FEndBalanceFor) FBalance_for, \r\n");
                selectSQL.append(" sum(GL.FEndBalanceLocal) FBalance_local, \r\n");
                selectSQL.append(" sum(GL.FEndBalanceRpt) FBalance_rpt, \r\n ");
                if (this.displayAmount) {
                    selectSQL.append(" sum(GL.FYearDebitQty) FDebitQty, to_decimal(0.0,28,4) FDebitPrice, \r\n");
                    selectSQL.append(" sum(GL.FYearCreditQty) FCreditQty,to_decimal(0.0,28,4) FCreditPrice, \r\n");
                    selectSQL.append(" sum(GL.FEndQty) FEndQty,to_decimal(0.0,28,4) FBalancePrice, \r\n");
                    if (this.standardUnit != null) {
                        selectSQL.append("'" + this.standardUnit.getId() + "' FMUID,'" + this.standardUnit.getNumber() + "' FMeasureUnitNumber,'" + this.standardUnit.getName() + "' FMeasureUnitName,to_int(1) FCoefficient,\n");
                    } else {
                        selectSQL.append("to_char(null) FMUID,to_char(null) FMeasureUnitNumber, to_char(null) FMeasureUnitName,to_int(null) FCoefficient,\n");
                    }
                    if (this.sumByMeasureUnit) {
                        selectSQL.append("0 isSumMU,");
                    }
                    if (this.showAsstUnitAndQty) {
                        selectSQL.append("to_char(null) FAssistUnitName, to_decimal(0.0,28,4) FDebitAssistQty ,  to_decimal(0.0,28,4) FDebitAssistPrice, to_decimal(0.0,28,4) FCreditAssistQty ,  to_decimal(0.0,28,4) FCredittAssistPrice, \n");
                        selectSQL.append("to_char(null) FDebitAssistUnitName, to_char(null) FCreditAssistUnitName ,");
                    }
                }
                if (!this.displayAttribute) break;
                selectSQL.append("to_char(null) FBizNumber,to_char(null) FInvoiceNumber,to_char(null) FSettlementCode,to_char(null) settleName, to_char(null) FTicketNumber,");
                break;
            }
            case 4: {
                String description = GLResUtil.getRes("subtotal", ctx);
                selectSQL.append("to_char(null) FVoucherID,to_int(null) FSeq, PE.FEndDate FBookedDate,to_date(null) FCreateTime,to_date(null) FBizDate,\n");
                selectSQL.append("to_char(null) FVoucherTypeNumber,to_char(null) FVoucherType,to_char(null) FVoucherNo, N'").append(description).append("' FDescription,\n");
                selectSQL.append("to_decimal(null) FLocalExchangeRate,to_decimal(null) FReportingExchangeRate,\n");
                selectSQL.append("sum(GL.FDebitFor) FDebit_for, sum(GL.FDebitLocal) FDebit_local, sum(GL.FDebitRpt) FDebit_rpt,");
                selectSQL.append("sum(GL.FCreditFor) FCredit_for,sum(GL.FCreditLocal) FCredit_local,sum(GL.FCreditRpt) FCredit_rpt,");
                selectSQL.append("sum(GL.FEndBalanceFor) FBalance_for,sum(GL.FEndBalanceLocal) FBalance_local,sum(GL.FEndBalanceRpt) FBalance_rpt,\n ");
                if (this.exchangeStandardUnit) {
                    selectSQL.append("sum(GL.FDebitQty*MU.FCoefficient) FDebitQty, to_decimal(0.0,28,4) FDebitPrice, \n");
                    selectSQL.append("sum(GL.FCreditQty*MU.FCoefficient) FCreditQty,to_decimal(0.0,28,4) FCreditPrice,\n");
                    selectSQL.append("sum(GL.FEndQty*MU.FCoefficient) FEndQty,to_decimal(0.0,28,4) FBalancePrice,\n");
                    selectSQL.append("'" + this.standardUnit.getId() + "' FMUID,'" + this.standardUnit.getNumber() + "' FMeasureUnitNumber,'" + this.standardUnit.getName() + "' FMeasureUnitName,to_int(null) FCoefficient,1 isSumMU,\n");
                } else {
                    selectSQL.append("sum(GL.FDebitQty) FDebitQty, to_decimal(0.0,28,4) FDebitPrice, \n");
                    selectSQL.append("sum(GL.FCreditQty) FCreditQty,to_decimal(0.0,28,4) FCreditPrice,\n");
                    selectSQL.append("sum(GL.FEndQty) FEndQty,to_decimal(0.0,28,4) FBalancePrice,\n");
                    selectSQL.append("MU.FID FMUID,MU.FNumber FMeasureUnitNumber,MU.FName_").append(loc).append(" FMeasureUnitName,MU.FCoefficient FCoefficient,1 isSumMU,\n");
                }
                if (this.showAsstUnitAndQty) {
                    selectSQL.append("to_char(null) FAssistUnitName, to_decimal(0.0,28,4) FDebitAssistQty ,  to_decimal(0.0,28,4) FDebitAssistPrice, to_decimal(0.0,28,4) FCreditAssistQty ,  to_decimal(0.0,28,4) FCredittAssistPrice, \n");
                    selectSQL.append("to_char(null) FDebitAssistUnitName, to_char(null) FCreditAssistUnitName ,");
                }
                if (!this.displayAttribute) break;
                selectSQL.append("to_char(null) FBizNumber,to_char(null) FInvoiceNumber,to_char(null) FSettlementCode,to_char(null) settleName, to_char(null) FTicketNumber,");
            }
        }
        if (this.currencyId == null) {
            selectSQL.append("currency.Fid FCurrencyId,currency.Fnumber FCurrencyNumber,currency.FName_").append(loc).append(" FCurrencyName,currency.FPrecision FPrecision, \n");
        } else if ("11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyId)) {
            if (1 == type) {
                selectSQL.append("currency.Fid FCurrencyId,currency.Fnumber FCurrencyNumber,currency.FName_").append(loc).append(" FCurrencyName,currency.FPrecision FPrecision, \n");
            } else {
                selectSQL.append("to_char(null) FCurrencyId,to_char(null) FCurrencyNumber,to_char(null) FCurrencyName,to_int(null) FPrecision, \n");
            }
        }
        if (this.onlyEndPeriod && isonlyEndPeriod) {
            selectSQL.append(" (select FID from T_BD_Period where Fnumber in ( \r\n");
            selectSQL.append(" select max(PE.Fnumber) from T_BD_Period PE \r\n");
            selectSQL.append(" inner join ").append(tempTableName).append(" TL on PE.FID=TL.FperiodID \r\n");
            selectSQL.append(" where ((PE.FperiodYear = ").append(this.endYear).append(" and PE.Fperiodnumber <=").append(this.endNumber).append(" ) \r\n");
            selectSQL.append(" or (PE.FperiodYear = ").append(this.beginYear).append(" and PE.Fperiodnumber >=").append(this.beginNumber).append(" ) \r\n");
            selectSQL.append(" or (PE.FperiodYear >= ").append(this.beginYear + 1).append(" and PE.Fperiodnumber <=").append(this.endYear - 1).append(" )) \r\n");
            selectSQL.append(" ) and FtypeID=(select top 1 FtypeID from T_BD_Period PE ");
            selectSQL.append(" inner join ").append(tempTableName).append(" TL on PE.FID=TL.FPeriodID)) as FPeriodID, ");
            selectSQL.append(this.periodYear * 100 + this.periodNumber + " as FPeriod, ");
            selectSQL.append(this.periodYear + " as FPeriodYear, ");
            selectSQL.append(this.periodNumber + " as FPeriodNumber");
        }
        if (!this.onlyEndPeriod || !isonlyEndPeriod) {
            selectSQL.append("PE.FID FPeriodID, PE.FNumber FPeriod, PE.FPeriodYear, PE.FPeriodNumber");
        }
        return selectSQL;
    }

    protected String getVoucherDescription(Context ctx, RptParams params) {
        return "CASE WHEN C.FDescription is not null THEN C.FDescription ELSE A.FDescription END FDescription,";
    }

    private String insertVoucherDetail(Context ctx, RptParams params) throws EASBizException, BOSException {
        int currencyType;
        HashMap tableValue;
        StringBuffer sql = this.getSelectSQL(ctx, params, 1);
        sql.append(",").append(1).append(" FRowType");
        sql.append("\n from t_GL_voucherEntry A ");
        sql.append("\n inner join t_GL_voucher B on A.FBillID=B.FID ");
        sql.append("\n inner join t_GL_voucherAssistRecord C on C.FEntryId=A.FID and C.Fbillid = B.fid ");
        sql.append("\n inner join t_bd_voucherTypes D on B.FVoucherTypeID=D.FID");
        sql.append("\n inner join T_BD_Period PE on PE.FID=B.FPeriodID");
        if (this.displayAttribute) {
            sql.append("\n  left outer join T_BD_SettlementType  settle on C.FSettlementTypeID= settle.fid");
        }
        if (this.displayAmount) {
            sql.append("\n left outer join T_BD_MeasureUnit MU on MU.FID = C.FMeasureUnitID ");
            if (this.showAsstUnitAndQty) {
                sql.append("\n left outer join T_BD_MeasureUnit MUN on MUN.FID = C.FAssistUnit ");
            }
        }
        if (this.currencyId == null || "11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyId)) {
            sql.append("\n inner join T_BD_Currency currency on currency.fid = a.fcurrencyid ");
        }
        sql.append("\n inner join T_BD_AccountView AV on AV.FID=A.FAccountID ");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("AV", params.getString("userId"), company.getId().toString(), ctx));
        SqlParams sp = new SqlParams();
        sql.append(this.getJoinActSQL(ctx, params, true, "C.FAssGrpID", sp));
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("VOUCHER", "B");
        table.put("ENTRIES", "A");
        table.put("VOUCHERTYPE", "D");
        table.put("ASSISTRECORDS", "C");
        table.put("PERIOD", "TE");
        table.put("ACCOUNTVIEW", "AV");
        if (this.displayAttribute) {
            table.put("SETTLEMENTTYPE", "settle");
        }
        if ((tableValue = RptServerUtil.getRptSelfCongdition(ctx, (EntityViewInfo)params.getObject("selfCond"), table, true, this.displayAttribute)) != null && tableValue.get("join") != null) {
            sql.append(tableValue.get("join").toString());
        }
        sql.append("\n where B.fcompanyid = ? ");
        sp.addString(company.getId().toString());
        if (this.includeUnPost) {
            sql.append(" and B.fBizStatus in(1,3,4,5)");
        } else {
            sql.append(" and B.fBizStatus=5");
        }
        boolean includeNoTransPLVoucher = false;
        if (params.getObjectElement("jcbincludeNoTransPLVoucher.value") != null) {
            includeNoTransPLVoucher = (Boolean)params.getObjectElement("jcbincludeNoTransPLVoucher.value");
        }
        if (includeNoTransPLVoucher) {
            sql.append(" and B.fsourcetype <> ").append(1);
        }
        if (this.currencyId != null && (currencyType = RptServerUtil.getCurrencyType(this.currencyId)) != 1 && currencyType != 2) {
            sql.append(" and A.FCurrencyId=?");
            sp.addString(this.currencyId);
        }
        if (tableValue != null && tableValue.get("cond") != null) {
            String strFilter = tableValue.get("cond").toString();
            sql.append("  and " + strFilter.replaceAll("B.FBizDate", "C.FBizDate"));
        }
        sql.append(this.getSameWhereSQL(params, sp));
        return this.executeCreateTableAsSelectInto("select * into TEMP_GL_GD_Voucher from ( " + sql.toString() + ") a", sp, ctx).getTempTable();
    }

    private void insertPeriodBeginBalance(Context ctx, RptParams params, String tempTableName, StringBuffer fromWhere, SqlParams sp) throws EASBizException, BOSException {
        int i;
        String loc = this.getLoc(ctx);
        SqlParams sqlParams = new SqlParams();
        RptParams sysParams = (RptParams)params.getObject("sysParams");
        boolean isAccountShowLongName = sysParams.getBoolean("GL_012");
        boolean isShowAsstNumber = sysParams.getBoolean("GL_004");
        String accountName = this.getAccountName(ctx, isAccountShowLongName) + loc;
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTableName).append("\n");
        sql.append("select A.*,").append(0).append(" FRowType from (");
        sql.append(this.getSelectSQL(ctx, params, 0));
        sql.append(fromWhere);
        sqlParams.addParams(sp);
        sql.append("\n group by ");
        if (params.getBoolean("isExportToExcel")) {
            List itemList = (List)params.getObject("actList");
            int itemCount = itemList.size();
            for (int i2 = 0; i2 < itemCount; ++i2) {
                sql.append("T.FID").append(i2).append(",");
                sql.append("T.FNumber").append(i2).append(",");
                sql.append("T.FLongNumber").append(i2).append(",");
                sql.append("T.FName").append(i2).append(",");
            }
        }
        boolean isFirstPeriod = false;
        Object isFirstPeriodObj = params.getObjectElement("rdFirstPeriod.value");
        if (isFirstPeriodObj != null) {
            isFirstPeriod = (Boolean)isFirstPeriodObj;
        }
        if (isFirstPeriod) {
            sql.append("PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FBeginDate,");
        }
        sql.append("AV.FID,AV.FNumber,").append(accountName).append(",AV.FDC");
        if (this.currencyId == null) {
            sql.append(",currency.FID,currency.FNumber,currency.FName_").append(loc).append(",currency.FPrecision");
        }
        if (!isFirstPeriod) {
            sql.append(",PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FBeginDate");
        }
        sql.append(") A ");
        if (!isFirstPeriod) {
            sql.append(" inner join ( \n");
            sql.append("select AV.FID FAccountID,min(PE.FNumber) FMinPeriod ");
            if (this.currencyId == null) {
                sql.append(",currency.FID FCurrencyID");
            }
            if (params.getBoolean("isExportToExcel")) {
                boolean isShowLongNumber = sysParams.getBoolean("GL_064");
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (int i3 = 0; i3 < itemCount; ++i3) {
                    AsstactTypeEntity at = (AsstactTypeEntity)itemList.get(i3);
                    sql.append(",");
                    sql.append("T.FID").append(i3).append(",");
                    if (at.getHgAttribute().startsWith("general")) {
                        if (isShowLongNumber) {
                            if (isShowAsstNumber) {
                                sql.append("replace(T.FLongNumber").append(i3).append(",'!','.')||' '||").append("T.FName").append(i3).append(" ASSTITEM").append(i3);
                                continue;
                            }
                            sql.append("replace(T.FLongNumber").append(i3).append(",'!','.')||' '||").append("T.FName").append(i3).append(" ASSTITEM").append(i3);
                            continue;
                        }
                        if (isShowAsstNumber) {
                            sql.append("T.FNumber").append(i3).append("||' '||").append("T.FName").append(i3).append(" ASSTITEM").append(i3);
                            continue;
                        }
                        sql.append("T.FNumber").append(i3).append("||' '||").append("T.FName").append(i3).append(" ASSTITEM").append(i3);
                        continue;
                    }
                    if (isShowAsstNumber) {
                        sql.append("T.FNumber").append(i3).append("||").append("T.FName").append(i3).append(" ASSTITEM").append(i3);
                        continue;
                    }
                    sql.append("T.FNumber").append(i3).append("||' '||").append("T.FName").append(i3).append(" ASSTITEM").append(i3);
                }
            }
            sql.append(fromWhere);
            sqlParams.addParams(sp);
            sql.append("\n group by AV.FID");
            if (this.currencyId == null) {
                sql.append(",currency.FID");
            }
            if (params.getBoolean("isExportToExcel")) {
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (i = 0; i < itemCount; ++i) {
                    sql.append(",").append("T.FID").append(i);
                    sql.append(",").append("T.FNumber").append(i);
                    sql.append(",").append("T.FLongNumber").append(i);
                    sql.append(",").append("T.FName").append(i);
                }
            }
            sql.append(") B on B.FAccountID = A.FAccountID and A.FPeriod = FMinPeriod");
            if (this.currencyId == null) {
                sql.append(" and A.FCurrencyID = B.FCurrencyID");
            }
            if (params.getBoolean("isExportToExcel")) {
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (i = 0; i < itemCount; ++i) {
                    sql.append(" and A.FID").append(i).append(" = B.FID").append(i);
                }
            }
        }
        if (this.noDisplayZero || this.noDisplayAllZero) {
            sql.append("\n inner join (select distinct FAccountID");
            if (params.getBoolean("isExportToExcel")) {
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (i = 0; i < itemCount; ++i) {
                    sql.append(", FID").append(i);
                }
            }
            if (this.currencyId == null) {
                sql.append(",FCurrencyID");
            }
            sql.append(" from ").append(tempTableName).append(") tempTable on ");
            sql.append(" tempTable.FAccountID = A.FAccountID ");
            if (params.getBoolean("isExportToExcel")) {
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (i = 0; i < itemCount; ++i) {
                    sql.append(" and A.FID").append(i).append(" = tempTable.FID").append(i);
                }
            }
            if (this.currencyId == null) {
                sql.append(" and tempTable.FCurrencyID = A.FCurrencyID");
            }
        }
        if (this.noDisplayAllZero) {
            sql.append(" union ");
            sql.append("select A.*,").append(0).append(" FRowType from (");
            sql.append(this.getSelectSQL(ctx, params, 0));
            sql.append(fromWhere);
            sqlParams.addParams(sp);
            sql.append("\n group by ");
            if (params.getBoolean("isExportToExcel")) {
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (i = 0; i < itemCount; ++i) {
                    sql.append("T.FID").append(i).append(",");
                    sql.append("T.FNumber").append(i).append(",");
                    sql.append("T.FLongNumber").append(i).append(",");
                    sql.append("T.FName").append(i).append(",");
                }
            }
            if (isFirstPeriod) {
                sql.append("PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FBeginDate,");
            }
            sql.append(" AV.FID,AV.FNumber,").append(accountName).append(",AV.FDC");
            if (this.currencyId == null) {
                sql.append(",currency.FID,currency.FNumber,currency.FName_").append(loc).append(",currency.FPrecision");
            }
            if (!isFirstPeriod) {
                sql.append(",PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FBeginDate");
            }
            sql.append(") A ");
            if (!isFirstPeriod) {
                sql.append("inner join ( \n");
                sql.append("select distinct AV.FID FAccountID,min(PE.FNumber) FMinPeriod ");
                if (this.currencyId == null) {
                    sql.append(",currency.FID FCurrencyID");
                }
                sql.append(fromWhere);
                sqlParams.addParams(sp);
                sql.append("\n group by AV.FID");
                if (this.currencyId == null) {
                    sql.append(",currency.FID");
                }
                sql.append(") B on B.FAccountID = A.FAccountID and A.FPeriod = FMinPeriod");
                if (this.currencyId == null) {
                    sql.append(" and A.FCurrencyID = B.FCurrencyID");
                }
            }
            sql.append(" where A.FBalance_for <> 0 or A.FBalance_local <> 0");
        }
        this.executeUpdate(ctx, sql.toString(), sqlParams);
    }

    private StringBuffer getPeriodEndBalanceSQL(Context ctx, RptParams params, String tempTableName, StringBuffer fromWhere) throws EASBizException, BOSException {
        String loc = this.getLoc(ctx);
        RptParams sysParams = (RptParams)params.getObject("sysParams");
        boolean isAccountShowLongName = sysParams.getBoolean("GL_012");
        String accountName = this.getAccountName(ctx, isAccountShowLongName) + loc;
        StringBuffer balanceQuery = this.getSelectSQL(ctx, params, 2);
        balanceQuery.append(",").append(2).append(" FRowType");
        balanceQuery.append(fromWhere);
        if (this.onlyEndPeriod) {
            balanceQuery.append(" where pe.fperiodyear = ").append(this.periodYear);
        }
        balanceQuery.append("\n group by ");
        if (params.getBoolean("isExportToExcel")) {
            List itemList = (List)params.getObject("actList");
            int itemCount = itemList.size();
            for (int i = 0; i < itemCount; ++i) {
                balanceQuery.append("T.FID").append(i).append(",");
                balanceQuery.append("T.FNumber").append(i).append(",");
                balanceQuery.append("T.FLongNumber").append(i).append(",");
                balanceQuery.append("T.FName").append(i).append(",");
            }
        }
        boolean isFirstPeriod = false;
        Object isFirstPeriodObj = params.getObjectElement("rdFirstPeriod.value");
        if (isFirstPeriodObj != null) {
            isFirstPeriod = (Boolean)isFirstPeriodObj;
        }
        if (isFirstPeriod) {
            balanceQuery.append("PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FEndDate,");
        }
        balanceQuery.append(" AV.FID,AV.FNumber,").append(accountName).append(",AV.FDC");
        if (this.currencyId == null) {
            balanceQuery.append(",currency.FID,currency.FNumber,currency.FName_").append(loc).append(",currency.FPrecision");
        }
        if (!isFirstPeriod && !this.onlyEndPeriod) {
            balanceQuery.append(",PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FEndDate");
        }
        return balanceQuery;
    }

    private StringBuffer getYearEndBalanceSQL(Context ctx, RptParams params, String tempTableName, StringBuffer fromWhere) throws EASBizException, BOSException {
        String loc = this.getLoc(ctx);
        RptParams sysParams = (RptParams)params.getObject("sysParams");
        boolean isAccountShowLongName = sysParams.getBoolean("GL_012");
        String accountName = this.getAccountName(ctx, isAccountShowLongName) + loc;
        StringBuffer balanceQuery = this.getSelectSQL(ctx, params, 3);
        balanceQuery.append(",").append(3).append(" FRowType");
        balanceQuery.append(fromWhere);
        balanceQuery.append("\n group by ");
        if (params.getBoolean("isExportToExcel")) {
            List itemList = (List)params.getObject("actList");
            int itemCount = itemList.size();
            for (int i = 0; i < itemCount; ++i) {
                balanceQuery.append("T.FID").append(i).append(",");
                balanceQuery.append("T.FNumber").append(i).append(",");
                balanceQuery.append("T.FLongNumber").append(i).append(",");
                balanceQuery.append("T.FName").append(i).append(",");
            }
        }
        boolean isFirstPeriod = false;
        Object isFirstPeriodObj = params.getObjectElement("rdFirstPeriod.value");
        if (isFirstPeriodObj != null) {
            isFirstPeriod = (Boolean)isFirstPeriodObj;
        }
        if (isFirstPeriod) {
            balanceQuery.append("PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FEndDate,");
        }
        balanceQuery.append(" AV.FID,AV.FNumber,").append(accountName).append(",AV.FDC");
        if (this.currencyId == null) {
            balanceQuery.append(",currency.FID,currency.FNumber,currency.FName_").append(loc).append(",currency.FPrecision");
        }
        if (!isFirstPeriod) {
            balanceQuery.append(",PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FEndDate");
        }
        if (this.onlyEndPeriod) {
            balanceQuery.append(" having PE.FNumber = " + (this.periodYear * 100 + this.periodNumber) + "\r\n");
        }
        return balanceQuery;
    }

    private void insertPeiordAndYearBalance(Context ctx, RptParams params, String tempTableName, StringBuffer fromWhere, SqlParams sp) throws EASBizException, BOSException {
        this.insertYearAndPeriod(ctx, params, tempTableName, fromWhere, sp);
        int itemCount = ((List)params.getObject("actList")).size();
        this.createTempTableIndex(ctx, tempTableName, params.getBoolean("isExportToExcel"), itemCount);
        this.updateYearData(ctx, params, tempTableName);
        this.updatePeriodData(ctx, params, tempTableName);
    }

    private void updatePeriodData(Context ctx, RptParams params, String tempTableName) throws BOSException, EASBizException {
        int i;
        this.updatePeriodForZero(ctx, tempTableName);
        int itemCount = ((List)params.getObject("actList")).size();
        StringBuffer updatePeiordSql = new StringBuffer();
        updatePeiordSql.append("update  /*+ NOT_GEN_EXISTS*/ ").append(tempTableName).append(" vt set (FDEBIT_FOR,FDEBIT_LOCAL,FDEBIT_RPT,FCREDIT_FOR,FCREDIT_LOCAL,FCREDIT_RPT");
        if (this.displayAmount) {
            updatePeiordSql.append(",FDebitQty,FCreditQty");
        }
        updatePeiordSql.append(")");
        updatePeiordSql.append("\n = (select FDEBIT_FOR,FDEBIT_LOCAL,FDEBIT_RPT,FCREDIT_FOR,FCREDIT_LOCAL,FCREDIT_RPT");
        if (this.displayAmount) {
            updatePeiordSql.append(",FDebitQty,FCreditQty ");
        }
        updatePeiordSql.append(" from (select tmp.faccountid,");
        if (!this.onlyEndPeriod) {
            updatePeiordSql.append(" tmp.fperiodid,");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updatePeiordSql.append(" tmp.FID").append(i).append(", ");
            }
        }
        if (this.currencyId == null) {
            updatePeiordSql.append(" tmp.FCurrencyID, ");
        }
        updatePeiordSql.append("sum(FDEBIT_FOR) FDEBIT_FOR,sum(FDEBIT_LOCAL) FDEBIT_LOCAL,sum(FDEBIT_RPT) FDEBIT_RPT,sum(FCREDIT_FOR) FCREDIT_FOR,sum(FCREDIT_LOCAL) FCREDIT_LOCAL,sum(FCREDIT_RPT) FCREDIT_RPT");
        if (this.displayAmount) {
            updatePeiordSql.append(",sum(FDebitQty*FCOEFFICIENT) FDebitQty,sum(FCreditQty*FCOEFFICIENT) FCreditQty ");
        }
        updatePeiordSql.append("\n from ").append(tempTableName).append(" tmp where tmp.frowtype = 1 and tmp.FVoucherID is not null group by tmp.faccountid ");
        if (!this.onlyEndPeriod) {
            updatePeiordSql.append(", tmp.fperiodid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updatePeiordSql.append(" ,tmp.FID").append(i);
            }
        }
        if (this.currencyId == null) {
            updatePeiordSql.append(" ,tmp.FCurrencyID ");
        }
        updatePeiordSql.append(") tmp \n where tmp.faccountid = vt.faccountid ");
        if (!this.onlyEndPeriod) {
            updatePeiordSql.append(" and tmp.fperiodid = vt.fperiodid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updatePeiordSql.append("\n and tmp.FID").append(i).append(" = vt.FID").append(i);
            }
        }
        if (this.currencyId == null) {
            updatePeiordSql.append("\n and tmp.FCurrencyID").append(" = vt.FCurrencyID");
        }
        updatePeiordSql.append(") where frowtype = 2 ");
        this.executeUpdate(ctx, updatePeiordSql.toString(), null);
    }

    private void updatePeriodForZero(Context ctx, String tempTableName) throws BOSException, EASBizException {
        StringBuffer updatePeiordForZero = new StringBuffer();
        updatePeiordForZero.append("update ").append(tempTableName).append(" set FDEBIT_FOR = 0,FDEBIT_LOCAL = 0,FDEBIT_RPT = 0,FCREDIT_FOR = 0,FCREDIT_LOCAL = 0,FCREDIT_RPT = 0");
        if (this.displayAmount) {
            updatePeiordForZero.append(",FDebitQty = 0,FCreditQty = 0");
        }
        updatePeiordForZero.append(" where frowtype = 2 ");
        this.executeUpdate(ctx, updatePeiordForZero.toString(), null);
    }

    private void updateYearData(Context ctx, RptParams params, String tempTableName) throws EASBizException, BOSException {
        int i;
        int itemCount = ((List)params.getObject("actList")).size();
        StringBuffer updateYearSql = new StringBuffer();
        updateYearSql.append("update /*+ NOT_GEN_EXISTS*/ ").append(tempTableName).append(" vt set (FDEBIT_FOR,FDEBIT_LOCAL,FDEBIT_RPT,FCREDIT_FOR,FCREDIT_LOCAL,FCREDIT_RPT");
        if (this.displayAmount) {
            updateYearSql.append(",FDebitQty,FCreditQty)");
        } else {
            updateYearSql.append(")");
        }
        updateYearSql.append(" = (select y.FDEBIT_FOR - (p.FDEBIT_FOR - v.FDEBIT_FOR) FDEBIT_FOR, \r\n");
        updateYearSql.append(" y.FDEBIT_LOCAL - (p.FDEBIT_LOCAL - v.FDEBIT_LOCAL) FDEBIT_LOCAL, \r\n");
        updateYearSql.append(" y.FDEBIT_RPT - (p.FDEBIT_RPT - v.FDEBIT_RPT) FDEBIT_RPT, \r\n");
        updateYearSql.append(" y.FCREDIT_FOR - (p.FCREDIT_FOR - v.FCREDIT_FOR) FCREDIT_FOR, \r\n");
        updateYearSql.append(" y.FCREDIT_LOCAL - (p.FCREDIT_LOCAL - v.FCREDIT_LOCAL) FCREDIT_LOCAL, \r\n");
        updateYearSql.append(" y.FCREDIT_RPT - (p.FCREDIT_RPT - v.FCREDIT_RPT) FCREDIT_RPT \r\n");
        if (this.displayAmount) {
            updateYearSql.append(" ,y.FDebitQty - (p.FDebitQty - v.FDebitQty) FDebitQty, \r\n");
            updateYearSql.append(" y.FCreditQty - (p.FCreditQty - v.FCreditQty) FCreditQty \r\n");
        }
        updateYearSql.append(" from ").append(tempTableName).append(" y \r\n");
        updateYearSql.append(" inner join (select TP1.FPeriodYear,TP1.FPeriodNumber,TP1.faccountid, \r\n");
        if (this.currencyId == null) {
            updateYearSql.append("TP1.fcurrencyid,");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" TP1.FID").append(i).append(", ");
            }
        }
        updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FDEBIT_FOR else 0 end) FDEBIT_FOR, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FDEBIT_LOCAL else 0 end) FDEBIT_LOCAL, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FDEBIT_RPT else 0 end) FDEBIT_RPT, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FCREDIT_FOR else 0 end) FCREDIT_FOR, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FCREDIT_LOCAL else 0 end) FCREDIT_LOCAL, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FCREDIT_RPT else 0 end) FCREDIT_RPT \r\n");
        if (this.displayAmount) {
            updateYearSql.append(",sum(case when TP2.FRowType = 2 then TP2.FDebitQty*TP2.FCOEFFICIENT else 0 end) FDebitQty, \r\n");
            updateYearSql.append(" sum(case when TP2.FRowType = 2 then TP2.FCreditQty*TP2.FCOEFFICIENT else 0 end) FCreditQty \r\n");
        }
        updateYearSql.append("\n from ").append(tempTableName).append(" TP1");
        updateYearSql.append("\n inner join ").append(tempTableName).append(" TP2 on TP1.FPeriodYear = TP2.FPeriodYear and TP1.faccountid = TP2.faccountid ");
        if (this.currencyId == null) {
            updateYearSql.append(" and TP1.fcurrencyid = TP2.fcurrencyid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" and TP1.FID").append(i).append(" = ").append(" TP2.FID").append(i);
            }
        }
        updateYearSql.append("\n where TP1.FRowType = 3 AND TP1.FPeriodNumber >= TP2.FPeriodNumber ");
        updateYearSql.append("\n GROUP BY TP1.FPeriodYear,TP1.FPeriodNumber,TP1.faccountid \r\n");
        if (this.currencyId == null) {
            updateYearSql.append(",TP1.fcurrencyid");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" ,TP1.FID").append(i);
            }
        }
        updateYearSql.append(") p ");
        updateYearSql.append("\n on y.FPeriodYear = p.FPeriodYear and p.FPeriodNumber = y.FPeriodNumber and p.faccountid = y.faccountid ");
        if (this.currencyId == null) {
            updateYearSql.append(" and p.fcurrencyid = y.fcurrencyid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" and p.FID").append(i).append(" = ").append(" y.FID").append(i);
            }
        }
        updateYearSql.append("\n inner join (select TP1.FPeriodYear,TP1.FPeriodNumber,TP1.faccountid, \r\n");
        if (this.currencyId == null) {
            updateYearSql.append("TP1.fcurrencyid,");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" TP1.FID").append(i).append(", ");
            }
        }
        updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FDEBIT_FOR else 0 end) FDEBIT_FOR, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FDEBIT_LOCAL else 0 end) FDEBIT_LOCAL, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FDEBIT_RPT else 0 end) FDEBIT_RPT, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FCREDIT_FOR else 0 end) FCREDIT_FOR, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FCREDIT_LOCAL else 0 end) FCREDIT_LOCAL, \r\n");
        updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FCREDIT_RPT else 0 end) FCREDIT_RPT \r\n");
        if (this.displayAmount) {
            updateYearSql.append(",sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FDebitQty*TP2.FCOEFFICIENT else 0 end) FDebitQty, \r\n");
            updateYearSql.append(" sum(case when TP2.FRowType = 1 and TP2.FVoucherID is not null then TP2.FCreditQty*TP2.FCOEFFICIENT else 0 end) FCreditQty \r\n");
        }
        updateYearSql.append(" from ").append(tempTableName).append(" TP1 \r\n");
        updateYearSql.append(" inner join ").append(tempTableName).append(" TP2 on TP1.FPeriodYear = TP2.FPeriodYear and TP1.faccountid = TP2.faccountid \r\n");
        if (this.currencyId == null) {
            updateYearSql.append(" and TP1.fcurrencyid = TP2.fcurrencyid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" and TP1.FID").append(i).append(" = ").append(" TP2.FID").append(i);
            }
        }
        updateYearSql.append("\n where TP1.FRowType = 3 AND TP1.FPeriodNumber >= TP2.FPeriodNumber ");
        updateYearSql.append("\n GROUP BY TP1.FPeriodYear,TP1.FPeriodNumber,TP1.faccountid");
        if (this.currencyId == null) {
            updateYearSql.append(",TP1.fcurrencyid");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(", TP1.FID").append(i);
            }
        }
        updateYearSql.append(") v ");
        updateYearSql.append("\n on v.FPeriodYear = y.FPeriodYear and v.FPeriodNumber = y.FPeriodNumber and v.faccountid = y.faccountid ");
        if (this.currencyId == null) {
            updateYearSql.append(" and v.fcurrencyid = y.fcurrencyid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" and v.FID").append(i).append(" = ").append(" y.FID").append(i);
            }
        }
        updateYearSql.append("\n where y.frowtype = 3 and y.fperiodid = vt.fperiodid and y.faccountid = vt.faccountid ");
        if (this.currencyId == null) {
            updateYearSql.append(" and vt.fcurrencyid = y.fcurrencyid ");
        }
        if (params.getBoolean("isExportToExcel")) {
            for (i = 0; i < itemCount; ++i) {
                updateYearSql.append(" and vt.FID").append(i).append(" = ").append(" y.FID").append(i);
            }
        }
        updateYearSql.append("\n ) where vt.frowtype = 3 ");
        this.executeUpdate(ctx, updateYearSql.toString(), null);
    }

    private void insertYearAndPeriod(Context ctx, RptParams params, String tempTableName, StringBuffer fromWhere, SqlParams sp) throws EASBizException, BOSException {
        int itemCount = ((List)params.getObject("actList")).size();
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTableName).append(" select t.* from (\n");
        sql.append(this.getPeriodEndBalanceSQL(ctx, params, tempTableName, fromWhere));
        sql.append(" \r\n union all \r\n");
        sql.append(this.getYearEndBalanceSQL(ctx, params, tempTableName, fromWhere));
        sql.append(") t \n");
        sql.append("where exists (select 1 from ").append(tempTableName).append(" t1 \n");
        sql.append("where t1.FAccountID=t.FAccountID ");
        if (params.getBoolean("isExportToExcel")) {
            for (int i = 0; i < itemCount; ++i) {
                sql.append(" and t1.ASSTITEM").append(i).append("=t.ASSTITEM").append(i);
            }
        }
        if (this.currencyId == null) {
            sql.append(" and t1.FCurrencyID=t.FCurrencyID ");
        }
        if (this.noDisplayZeroTotal) {
            sql.append(" and t1.FPeriodID=t.FPeriodID ");
        }
        if (this.noDisplayZeroTotal) {
            sql.append(" and t1.FRowType = ").append(1);
        }
        sql.append(")");
        SqlParams sqlParams = new SqlParams();
        sqlParams.addParams(sp);
        sqlParams.addParams(sp);
        this.executeUpdate(ctx, sql.toString(), sqlParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempTableIndex(Context ctx, String tableName, boolean isExportToExcel, int itemCount) {
        StringBuffer columns = new StringBuffer();
        if (isExportToExcel) {
            for (int i = 0; i < itemCount; ++i) {
                if (i > 0) {
                    columns.append(",");
                }
                columns.append("FID").append(i);
            }
            columns.append(",");
        }
        columns.append("faccountid");
        if (this.currencyId == null) {
            columns.append(",fcurrencyid");
        }
        columns.append(",FPeriodYear");
        columns.append(",FPeriodNumber");
        Connection conn = null;
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tableName, columns.toString(), false, false);
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tableName);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"create index error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    private void insertSumMeasureUnit(Context ctx, RptParams params, String tempTableName) throws EASBizException, BOSException {
        String loc = this.getLoc(ctx);
        RptParams sysParams = (RptParams)params.getObject("sysParams");
        boolean isAccountShowLongName = sysParams.getBoolean("GL_012");
        String accountName = this.getAccountName(ctx, isAccountShowLongName) + loc;
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTableName).append("\n");
        sql.append(this.getSelectSQL(ctx, params, 4));
        sql.append(",").append(1).append(" FRowType");
        SqlParams sp = new SqlParams();
        sql.append(this.getBalanceFromAndWhereSQL(ctx, params, sp, true));
        sql.append("\n group by ");
        if (params.getBoolean("isExportToExcel")) {
            List itemList = (List)params.getObject("actList");
            int itemCount = itemList.size();
            for (int i = 0; i < itemCount; ++i) {
                sql.append("T.FNumber").append(i).append(",");
                sql.append("T.FLongNumber").append(i).append(",");
                sql.append("T.FName").append(i).append(",");
            }
        }
        boolean isFirstPeriod = false;
        Object isFirstPeriodObj = params.getObjectElement("rdFirstPeriod.value");
        if (isFirstPeriodObj != null) {
            isFirstPeriod = (Boolean)isFirstPeriodObj;
        }
        if (isFirstPeriod) {
            sql.append("PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FEndDate,");
        }
        sql.append("AV.FID,AV.FNumber,").append(accountName).append(",AV.FDC,");
        if (this.currencyId == null) {
            sql.append("currency.FID,currency.FNumber,currency.FName_").append(loc).append(",currency.FPrecision,");
        }
        if (!isFirstPeriod) {
            sql.append("PE.FID,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, PE.FEndDate,");
        }
        if (!this.exchangeStandardUnit) {
            sql.append("MU.FID,MU.FNumber,MU.FName_").append(loc).append(",MU.FCoefficient,");
        }
        this.executeUpdate(ctx, sql.toString().substring(0, sql.toString().length() - 1), sp);
    }

    private StringBuffer getBalanceFromAndWhereSQL(Context ctx, RptParams params, SqlParams sp, boolean isSumByMU) throws BOSException, EASBizException {
        StringBuffer sql = this.getBalanceFromSQL(ctx, params, sp, isSumByMU);
        if (isSumByMU) {
            sql.append(this.getBalanceWhereSQL(ctx, params, sp));
        }
        return sql;
    }

    private boolean getTableIsNull(Context ctx, String tempTableName) {
        try {
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from " + tempTableName));
            while (rst.next()) {
                if (rst.getInt(1) <= 0) continue;
                return false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void doUpdatePeriodData(Context ctx, String tempTableName) {
        try {
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)("select FAccountID from " + tempTableName + " group by FAccountID"));
            while (rst.next()) {
                if (this.displayAmount) {
                    this.executeUpdate(ctx, "update " + tempTableName + " set FBalance_for=(select FBalance_for from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "'), FBalance_local=(select FBalance_local from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "'), FBalance_rpt = (select FBalance_rpt from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "'), FEndQty = (select FEndQty from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "') where FRowType = " + 2 + " and FAccountID ='" + rst.getString(1) + "'", null);
                    continue;
                }
                this.executeUpdate(ctx, "update " + tempTableName + " set FBalance_for=(select FBalance_for from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "'), FBalance_local=(select FBalance_local from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "'), FBalance_rpt = (select FBalance_rpt from " + tempTableName + " where FRowType=" + 3 + " and FAccountID ='" + rst.getString(1) + "') where FRowType = " + 2 + " and FAccountID ='" + rst.getString(1) + "'", null);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void getYearAndPeriod(Context ctx, RptParams params) {
        String tempTableName = params.getString("tempTableName");
        IRowSet rst = null;
        try {
            if (this.endYear == this.beginYear) {
                rst = DbUtil.executeQuery((Context)ctx, (String)("select top 1 PE.FPeriodYear,PE.FperiodNumber,PE.Fnumber from T_BD_Period PE," + tempTableName + " TL where PE.FID=TL.FperiodID and PE.FperiodYear<= " + this.endYear + " and PE.FperiodNumber<= " + this.endNumber + " and PE.FperiodYear>= " + this.beginYear + " and PE.FperiodNumber>= " + this.beginNumber + " order by PE.FperiodYear desc,PE.FperiodNumber desc"));
            } else if (this.endNumber >= this.beginNumber) {
                rst = DbUtil.executeQuery((Context)ctx, (String)("select top 1 PE.FPeriodYear,PE.FperiodNumber,PE.Fnumber from T_BD_Period PE," + tempTableName + " TL where PE.FID=TL.FperiodID and PE.FperiodYear<= " + this.endYear + " and PE.FperiodYear>= " + this.beginYear + " order by PE.FperiodYear desc,PE.FperiodNumber desc"));
            } else if (this.endNumber < this.beginNumber) {
                rst = DbUtil.executeQuery((Context)ctx, (String)("select top 1 PE.FPeriodYear,PE.FperiodNumber,PE.Fnumber from T_BD_Period PE," + tempTableName + " TL where PE.FID=TL.FperiodID and PE.Fnumber<= " + (this.endYear * 100 + this.endNumber) + " and PE.Fnumber>= " + (this.beginYear * 100 + this.beginNumber) + " order by PE.Fnumber desc"));
            }
            while (rst.next()) {
                this.periodYear = rst.getInt("FPeriodYear");
                this.periodNumber = rst.getInt("FperiodNumber");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getBalanceFromSQL(Context ctx, RptParams params, SqlParams sp, boolean isSumByMU) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String balanceTempTable = null;
        if (isSumByMU) {
            boolean includeNoTransPLVoucher = false;
            if (params.getObjectElement("jcbincludeNoTransPLVoucher.value") != null) {
                includeNoTransPLVoucher = (Boolean)params.getObjectElement("jcbincludeNoTransPLVoucher.value");
            }
            if (includeNoTransPLVoucher) {
                SqlParams spExcludePL = new SqlParams();
                String plVoucherBalance = this.getPLVoucherBalance(ctx, params);
                StringBuffer sqlExcludePL = new StringBuffer("select GL.fbaltype,GL.FOrgUnitID,GL.FAccountID,GL.FPeriodID,GL.fassistgrpid,GL.FCurrencyID,");
                sqlExcludePL.append("GL.FBeginBalancelocal").append(" - isnull(t2.fbeginbalancelocal,0) FBeginBalancelocal,");
                sqlExcludePL.append("GL.FBeginBalancerpt").append(" - isnull(t2.fbeginbalancerpt,0) FBeginBalancerpt,");
                sqlExcludePL.append("GL.FBeginBalancefor").append(" - isnull(t2.fbeginbalancefor,0) FBeginBalancefor,");
                sqlExcludePL.append("GL.FYearDebitlocal - isnull(t2.FYearDebitlocal,0) FYearDebitlocal,");
                sqlExcludePL.append("GL.FYearDebitrpt - isnull(t2.FYearDebitrpt,0) FYearDebitrpt,");
                sqlExcludePL.append("GL.FYearDebitfor - isnull(t2.FYearDebitFor,0) FYearDebitfor,");
                sqlExcludePL.append("GL.FYearCreditlocal - isnull(t2.FYearCreditlocal,0) FYearCreditlocal,");
                sqlExcludePL.append("GL.FYearCreditrpt - isnull(t2.FYearCreditrpt,0) FYearCreditrpt,");
                sqlExcludePL.append("GL.FYearCreditfor - isnull(t2.FYearCreditFor,0) FYearCreditfor,");
                sqlExcludePL.append("GL.FDebitlocal - isnull(t2.fdebitlocal,0) FDebitlocal,");
                sqlExcludePL.append("GL.FDebitrpt - isnull(t2.fdebitrpt,0) FDebitrpt,");
                sqlExcludePL.append("GL.FDebitfor - isnull(t2.fdebitfor,0) FDebitfor,");
                sqlExcludePL.append("GL.FCreditlocal - isnull(t2.fcreditlocal,0) FCreditlocal,");
                sqlExcludePL.append("GL.FCreditrpt - isnull(t2.fcreditrpt,0) FCreditrpt,");
                sqlExcludePL.append("GL.FCreditfor - isnull(t2.fcreditfor,0) FCreditfor,");
                sqlExcludePL.append("GL.FEndBalancelocal - isnull(t2.FEndBalancelocal,0) FEndBalancelocal,");
                sqlExcludePL.append("GL.FEndBalancerpt - isnull(t2.FEndBalancerpt,0) FEndBalancerpt,");
                sqlExcludePL.append("GL.FEndBalancefor - isnull(t2.FEndBalanceFor,0) FEndBalancefor");
                sqlExcludePL.append(",GL.FBeginqty").append(" - isnull(t2.fbeginqty,0) FBeginqty,");
                sqlExcludePL.append("GL.FYearDebitqty - isnull(t2.FYearDebitqty,0) FYearDebitqty,");
                sqlExcludePL.append("GL.FYearCreditqty - isnull(t2.FYearCreditqty,0) FYearCreditqty,");
                sqlExcludePL.append("GL.FDebitqty - isnull(t2.fdebitqty,0) FDebitqty,");
                sqlExcludePL.append("GL.FCreditqty - isnull(t2.fcreditqty,0) FCreditqty,");
                sqlExcludePL.append("GL.FEndqty - isnull(t2.FEndqty,0) FEndqty,GL.FMeasureUnitID FMeasureUnitID");
                sqlExcludePL.append(" from t_gl_assistmeasurebalance GL \r\n");
                sqlExcludePL.append(" left outer join ").append(plVoucherBalance).append(" t2 on GL.FOrgUnitID = t2.fcompanyid ");
                sqlExcludePL.append(" and GL.FAccountID = t2.FAccountID and GL.FPeriodID = t2.FPeriodID ");
                sqlExcludePL.append(" and GL.fassistgrpid = t2.fassgrpid and GL.FCurrencyID = t2.FCurrencyID and GL.FMeasureUnitID=t2.FMeasureUnitID ");
                sqlExcludePL.append("\n inner join T_BD_Period PE on PE.FID=GL.FPeriodID ");
                sqlExcludePL.append("\n inner join T_BD_AccountView AV on AV.FID=GL.FAccountID ");
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
                sqlExcludePL.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("AV", params.getString("userId"), company.getId().toString(), ctx));
                sqlExcludePL.append("\n inner join t_bd_currency currency on gl.fcurrencyid = currency.fid ");
                sqlExcludePL.append(this.getJoinActSQL(ctx, params, isSumByMU, "GL.fassistgrpid", spExcludePL));
                sqlExcludePL.append("\n left outer join t_bd_measureunit MU on GL.fmeasureunitid = MU.fid ");
                sqlExcludePL.append(this.getBalanceWhereSQL(ctx, params, spExcludePL));
                try {
                    balanceTempTable = this.executeCreateTableAsSelectInto("select * into TEMP_GL_GD_Balance from (" + sqlExcludePL.toString() + ") as tempTable ", spExcludePL, ctx).getTempTable();
                }
                finally {
                    this.dropPoolTempTable(ctx, plVoucherBalance);
                }
            } else {
                balanceTempTable = "t_gl_assistmeasurebalance";
            }
        } else {
            balanceTempTable = this.getAssistBalanceTable(ctx, params);
        }
        sql.append("\n from ").append(balanceTempTable).append(" GL ");
        sql.append("\n inner join T_BD_Period PE on PE.FID=GL.FPeriodID ");
        sql.append("\n inner join T_BD_AccountView AV on AV.FID=GL.FAccountID ");
        if (this.levelFrom != -1 && this.levelTo != -1) {
            if (this.levelFrom == this.levelTo) {
                sql.append(" and AV.FLevel=?");
                sp.addInt(this.levelFrom);
            } else {
                sql.append(" and AV.FLevel >=? and AV.FLevel <=?");
                sp.addInt(this.levelFrom).addInt(this.levelTo);
            }
        }
        if (isSumByMU) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
            sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("AV", params.getString("userId"), company.getId().toString(), ctx));
        }
        sql.append("\n inner join t_bd_currency currency on gl.fcurrencyid = currency.fid ");
        sql.append(this.getJoinActSQL(ctx, params, isSumByMU, "GL.fassistgrpid", sp));
        if (this.displayAmount && isSumByMU) {
            sql.append("\n left outer join t_bd_measureunit MU on GL.fmeasureunitid = MU.fid ");
        }
        return sql;
    }

    private StringBuffer getBalanceWhereSQL(Context ctx, RptParams params, SqlParams sp) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" where GL.FBalType=? ");
        sp.addInt(this.includeUnPost ? 1 : 5);
        if (this.currencyId == null) {
            sql.append(" and GL.FCurrencyId not in ('22222222-2222-2222-2222-222222222222DEB58FDC',");
            sql.append(" '11111111-1111-1111-1111-111111111111DEB58FDC') ");
        } else {
            sql.append(" and GL.FCurrencyId=?");
            sp.addString(this.currencyId);
        }
        sql.append(" and GL.FOrgUnitId=?");
        sp.addString(((CompanyOrgUnitInfo)params.getObject("company")).getId().toString());
        if (this.displayAmount) {
            sql.append(" and (GL.FDebitQty != 0 or GL.FCreditQty != 0) ");
        }
        sql.append(this.getSameWhereSQL(params, sp));
        return sql;
    }

    private StringBuffer getSameWhereSQL(RptParams params, SqlParams sp) {
        StringBuffer sql = new StringBuffer();
        sql.append(" and AV.faccounttableid=?");
        sp.addString(((CompanyOrgUnitInfo)params.getObject("company")).getAccountTable().getId().toString());
        sql.append(" and AV.Fcompanyid=?");
        sp.addString(((CompanyOrgUnitInfo)params.getObject("company")).getId().toString());
        if (this.asstAccountID != null) {
            sql.append(" and AV.FCAA=?");
            sp.addString(this.asstAccountID);
        }
        if (this.levelFrom != -1 && this.levelTo != -1) {
            if (this.levelFrom == this.levelTo) {
                sql.append(" and AV.FLevel=?");
                sp.addInt(this.levelFrom);
            } else {
                sql.append(" and AV.FLevel >=? and AV.FLevel <=?");
                sp.addInt(this.levelFrom).addInt(this.levelTo);
            }
        }
        if (this.accountFrom != null) {
            sql.append(" and AV.FNumber>=?");
            sp.addString(this.accountFrom);
        }
        if (this.accountTo != null) {
            sql.append(" and AV.FNumber<=?");
            sp.addString(this.accountTo + 'z');
        }
        if (params.getObject("JoinQueryAccountid") != null) {
            sql.append(" and AV.fid =? ");
            sp.addString(params.getObject("JoinQueryAccountid").toString());
        }
        if (this.beginPeriod == this.endPeriod) {
            sql.append(" and PE.FNumber =?");
            sp.addInt(this.beginPeriod);
        } else {
            sql.append(" and PE.FNumber >= ? and PE.FNumber<=? ");
            sp.addInt(this.beginPeriod).addInt(this.endPeriod);
        }
        if (this.displayAmount && this.measureUnitID != null) {
            sql.append(" and MU.FID =? \n");
            sp.addString(this.measureUnitID);
        }
        return sql;
    }

    private StringBuffer getJoinActSQL(Context ctx, RptParams params, boolean isJoinFilter, String field, SqlParams joinActSp) throws EASBizException, BOSException {
        StringBuffer joinPermPart;
        StringBuffer joinActPart;
        block13: {
            List actList;
            block12: {
                String tempTable = params.getString("tempTable");
                joinActPart = new StringBuffer();
                joinPermPart = new StringBuffer();
                joinActPart.append("\n inner join t_bd_assistanthg HG on ").append(field).append(" = HG.FID");
                joinActPart.append("\n inner join ").append(tempTable).append(" T ");
                actList = (List)params.getObject("actList");
                if (!params.getBoolean("isExportToExcel")) break block12;
                for (int i = 0; i < actList.size(); ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
                    joinActPart.append(i == 0 ? " on " : " and ");
                    joinActPart.append(" T.FID").append(i).append("=HG.").append(at.getHgField());
                }
                ArrayList selectAsstActList = (ArrayList)params.getObject("selectedAsstAct");
                if (selectAsstActList != null) {
                    for (int i = 0; i < selectAsstActList.size(); ++i) {
                        joinActPart.append(i == 0 ? " and ((" : " or (");
                        ArrayList asstActList = (ArrayList)selectAsstActList.get(i);
                        for (int j = 0; j < asstActList.size(); ++j) {
                            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(j);
                            LabelValueBean item = (LabelValueBean)asstActList.get(j);
                            joinActPart.append(j == 0 ? "" : " and ");
                            if (item instanceof LabelValueBean) {
                                Object isLeafObj = item.getProperty("FISLeaf");
                                if (isLeafObj != null && isLeafObj instanceof Integer && (Integer)isLeafObj == 1) {
                                    joinActPart.append(" HG.").append(at.getHgField()).append(" = ? ");
                                    joinActSp.addString(item.getValue());
                                } else {
                                    joinActPart.append(" (charIndex('");
                                    joinActPart.append(item.getProperty("FLongNumber"));
                                    joinActPart.append("!',T.FLongNumber").append(j).append(")=1 or ");
                                    joinActPart.append("T.FID").append(j).append(" = ?)");
                                    joinActSp.addString(item.getValue());
                                }
                            }
                            if (j != asstActList.size() - 1) continue;
                            joinActPart.append(") ");
                        }
                        if (i != selectAsstActList.size() - 1) continue;
                        joinActPart.append(")");
                    }
                }
                if (!isJoinFilter) break block13;
                for (int i = 0; i < actList.size(); ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
                    if (!at.isEnabledPermissionLimit()) continue;
                    joinPermPart.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("HG." + at.getHgField(), at.getPermissionItem(), params.getString("userId"), params.getString("cuId"), ctx));
                }
                break block13;
            }
            List itemList = (List)params.getObject("itemList");
            for (int i = 0; i < itemList.size(); ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
                joinActPart.append(i == 0 ? " on " : " and ");
                joinActPart.append(" T.FID").append(i).append("=HG.").append(at.getHgField());
                Object item = itemList.get(i);
                if (item instanceof LabelValueBean) {
                    Object isLeafObj = ((LabelValueBean)item).getProperty("FISLeaf");
                    if (isLeafObj != null && isLeafObj instanceof Integer && (Integer)isLeafObj == 1) {
                        joinActPart.append(" and HG.").append(at.getHgField()).append(" = ? ");
                        joinActSp.addString(((LabelValueBean)item).getValue());
                    } else {
                        joinActPart.append(" and (charIndex('");
                        joinActPart.append(((LabelValueBean)item).getProperty("FLongNumber"));
                        joinActPart.append("!',T.FLongNumber").append(i).append(")=1 or ");
                        joinActPart.append("T.FID").append(i).append(" = ?)");
                        joinActSp.addString(((LabelValueBean)item).getValue());
                    }
                }
                if (!isJoinFilter || !at.isEnabledPermissionLimit()) continue;
                joinPermPart.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("HG." + at.getHgField(), at.getPermissionItem(), params.getString("userId"), params.getString("cuId"), ctx));
            }
        }
        return joinActPart.append(joinPermPart);
    }

    private void insertSumResultNew(Context ctx, String tempTableName, RptParams params) throws EASBizException, BOSException {
        this.insertSumRecordNew(ctx, tempTableName);
        this.updateSumBalance1(ctx, tempTableName, params);
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(tempTableName).append(" set fAccountNumber = '").append(this.subTotal).append("'").append(" where frowtype = 10 ");
        this.executeUpdate(ctx, sb.toString(), null);
    }

    private boolean isSumColumn(String columnName) {
        for (int i = 0; i < 9; ++i) {
            if (!columnName.equalsIgnoreCase(this.amtColumn[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDescColumn(String columnName) {
        return columnName.equalsIgnoreCase(this.others[0]);
    }

    private boolean isRowTypeColumn(String columnName) {
        return columnName.equalsIgnoreCase(this.others[1]);
    }

    private void insertSumRecordNew(Context ctx, String tempTableName) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTableName).append("\n");
        ColumnAttributeList columnAttrs = this.getAllColumnsNew(ctx, tempTableName);
        StringBuffer inner = this.genInnerSelectNew(tempTableName, columnAttrs);
        StringBuffer outer = this.genouterSelectNew(tempTableName, columnAttrs, inner);
        if (outer.toString().indexOf("'' as asstitem0") > 0 && outer.toString().indexOf("group by fperiodyear") > 0 && outer.toString().indexOf("group by frowtype") > 0) {
            outer = new StringBuffer(outer.toString().replaceAll("'' as asstitem0", "asstitem0 as asstitem0").replaceAll("group by fperiodyear", "group by fperiodyear,asstitem0").replaceAll("group by frowtype", "group by frowtype,asstitem0"));
        }
        this.executeUpdate(ctx, sql.append(outer).toString(), null);
    }

    private void updateSumBalance1(Context ctx, String tempTableName, RptParams params) throws EASBizException, BOSException {
        List itemList;
        int itemCount;
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(tempTableName).append("\n");
        sb.append("   set (fbalance_for, fbalance_local, fbalance_rpt, frowtype,fAccountNumber) = \n");
        sb.append("        (    \n");
        sb.append("        select ca,cb,cc,cd,'" + this.subTotal + "' from (     \n");
        sb.append("select ");
        if (params.getBoolean("isExportToExcel") && (itemCount = (itemList = (List)params.getObject("actList")).size()) > 0) {
            sb.append("ASSTITEM").append(0).append(",");
        }
        sb.append(" sum(fbalance_for) as ca, \n");
        sb.append("        sum(fbalance_local) as cb, \n");
        sb.append("        sum(fbalance_rpt) as cc, \n");
        sb.append("        10 as cd \n");
        sb.append("   from ( \n");
        sb.append("         select ");
        if (params.getBoolean("isExportToExcel") && (itemCount = (itemList = (List)params.getObject("actList")).size()) > 0) {
            sb.append("temp.ASSTITEM").append(0).append(",");
        }
        sb.append(" fbalance_for, \n ");
        sb.append("  fbalance_local, \n");
        sb.append("  fbalance_rpt, \n ");
        sb.append("                 10 as frowtype from \n");
        sb.append(tempTableName).append(" as temp \n");
        sb.append("   inner join  (select max(to_number(fperiod)) as fperiod, faccountid");
        if (params.getBoolean("isExportToExcel") && (itemCount = (itemList = (List)params.getObject("actList")).size()) > 0) {
            sb.append(", ASSTITEM").append(0);
        }
        sb.append(" from ").append(tempTableName);
        sb.append("\n where fperiod is not null group by faccountid ");
        if (params.getBoolean("isExportToExcel") && (itemCount = (itemList = (List)params.getObject("actList")).size()) > 0) {
            sb.append(", ASSTITEM").append(0);
        }
        sb.append(") as pe_acct on temp.faccountid = pe_acct.faccountid \n");
        if (params.getBoolean("isExportToExcel") && (itemCount = (itemList = (List)params.getObject("actList")).size()) > 0) {
            sb.append(" and  temp.").append("ASSTITEM").append(0).append(" = pe_acct.").append("ASSTITEM").append(0);
        }
        sb.append(" inner join t_bd_period pe on pe_acct.fperiod = pe.fnumber and temp.fperiodid = pe.fid \n");
        sb.append("            where temp.frowtype = 2) as b  \n");
        if (params.getBoolean("isExportToExcel")) {
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            if (itemCount > 0) {
                sb.append(" group by ");
            }
            if (itemCount > 0) {
                sb.append(" ASSTITEM").append(0).append(",");
            }
            if (itemCount > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        sb.append("      ) as c  \n");
        if (params.getBoolean("isExportToExcel")) {
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            if (itemCount > 0) {
                sb.append(" where 1 = 1 \n");
            }
            if (itemCount > 0) {
                sb.append(" and c.ASSTITEM").append(0).append(" = ").append(tempTableName).append(".asstitem").append(0).append(" \n");
            }
        }
        sb.append("        )    \n");
        sb.append(" where frowtype = 10 \n");
        this.executeUpdate(ctx, sb.toString(), null);
        this.updateWhenNoDisplayZeroTotal(ctx, tempTableName, params);
    }

    private void updateWhenNoDisplayZeroTotal(Context ctx, String tempTableName, RptParams params) throws EASBizException, BOSException {
        int i;
        int itemCount;
        List itemList;
        StringBuffer sb = new StringBuffer();
        sb.append(" select sum(tmp.fbalance_for), sum(tmp.fbalance_local), sum(tmp.fbalance_rpt)                           \n");
        if (params.getBoolean("isExportToExcel")) {
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            for (i = 0; i < itemCount; ++i) {
                sb.append(",tmp.ASSTITEM").append(i);
            }
        }
        sb.append(" from ").append(tempTableName).append(" tmp \n");
        sb.append(" inner join ( \n");
        sb.append(" select min(fperiod) fperiod,faccountid \n");
        if (params.getBoolean("isExportToExcel")) {
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            for (i = 0; i < itemCount; ++i) {
                sb.append(",ASSTITEM").append(i);
            }
        }
        sb.append(" from ").append(tempTableName).append(" where FrowType = 0 \n");
        sb.append(" group by faccountid ");
        if (params.getBoolean("isExportToExcel")) {
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            for (i = 0; i < itemCount; ++i) {
                sb.append(",ASSTITEM").append(i);
            }
        }
        sb.append(" ) p on tmp.fperiod = p.fperiod and tmp.faccountid = p.faccountid \n");
        if (params.getBoolean("isExportToExcel")) {
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            for (i = 0; i < itemCount; ++i) {
                sb.append(" and tmp.ASSTITEM").append(i).append(" = p.ASSTITEM").append(i);
            }
        }
        sb.append("  where tmp.FrowType = 0                                                                        \n");
        if (params.getBoolean("isExportToExcel")) {
            sb.append(" group by ");
            itemList = (List)params.getObject("actList");
            itemCount = itemList.size();
            if (itemCount > 0) {
                sb.append("tmp.ASSTITEM").append(0);
            }
            for (i = 1; i < itemCount; ++i) {
                sb.append(",tmp.ASSTITEM").append(i);
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean needUpdate = false;
        try {
            while (rs.next()) {
                int i2;
                int itemCount2;
                List itemList2;
                BigDecimal fbalance_for = GlUtils.zero;
                BigDecimal fbalance_local = GlUtils.zero;
                BigDecimal fbalance_rpt = GlUtils.zero;
                Object[] itemIds = null;
                if (params.getBoolean("isExportToExcel")) {
                    itemList2 = (List)params.getObject("actList");
                    itemCount2 = itemList2.size();
                    itemIds = new Object[itemCount2 + 3];
                } else {
                    itemIds = new Object[3];
                }
                needUpdate = true;
                fbalance_for = fbalance_for.add(rs.getBigDecimal(1) == null ? GlUtils.zero : rs.getBigDecimal(1));
                fbalance_local = fbalance_local.add(rs.getBigDecimal(2) == null ? GlUtils.zero : rs.getBigDecimal(2));
                fbalance_rpt = fbalance_rpt.add(rs.getBigDecimal(3) == null ? GlUtils.zero : rs.getBigDecimal(3));
                itemIds[0] = fbalance_for;
                itemIds[1] = fbalance_local;
                itemIds[2] = fbalance_rpt;
                if (params.getBoolean("isExportToExcel")) {
                    itemList2 = (List)params.getObject("actList");
                    itemCount2 = itemList2.size();
                    for (i2 = 0; i2 < itemCount2; ++i2) {
                        itemIds[i2 + 3] = rs.getString("ASSTITEM" + i2);
                    }
                }
                if (!needUpdate) continue;
                sb = new StringBuffer();
                sb.append("update ").append(tempTableName).append("  set \n");
                sb.append("  fbalance_for = fdebit_for + -1 * fcredit_for + ?    , \n");
                sb.append("  fbalance_local = fdebit_local + -1 * fcredit_local +? ,\n");
                sb.append("  fbalance_rpt = fdebit_rpt + -1 * fcredit_rpt + ?    \n");
                sb.append("  where frowtype = 10  \n");
                if (params.getBoolean("isExportToExcel")) {
                    itemList2 = (List)params.getObject("actList");
                    itemCount2 = itemList2.size();
                    for (i2 = 0; i2 < itemCount2; ++i2) {
                        sb.append("  and ASSTITEM").append(i2).append(" = ? ");
                    }
                }
                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])itemIds);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer genouterSelectNew(String tempTableName, ColumnAttributeList columnAttrs, StringBuffer inner) {
        StringBuffer sbOuter = new StringBuffer();
        sbOuter.append("select ");
        int columnCount = columnAttrs.size();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = columnAttrs.getIndex(i).getColumnName();
            int columnType = columnAttrs.getIndex(i).getSqlType();
            if (this.isSumColumn(columnName)) {
                sbOuter.append(" sum(").append(columnName.toLowerCase()).append(") as fdebit_for ");
            } else if (this.isDescColumn(columnName)) {
                sbOuter.append(" '" + this.subTotal + "' as ").append(columnName.toLowerCase());
            } else if (this.isRowTypeColumn(columnName)) {
                sbOuter.append(" 10 as ").append(columnName.toLowerCase());
            } else if (3 == columnType || 4 == columnType) {
                if (columnName.equalsIgnoreCase("fperiod")) {
                    sbOuter.append(" 999912 as ").append(columnName.toLowerCase());
                } else if (columnName.equalsIgnoreCase("fperiodyear")) {
                    sbOuter.append(" 9999 as ").append(columnName.toLowerCase());
                } else if (columnName.equalsIgnoreCase("fperiodnumber")) {
                    sbOuter.append(" 12 as ").append(columnName.toLowerCase());
                } else {
                    sbOuter.append(" 0 as ").append(columnName.toLowerCase());
                }
            } else if (12 == columnType) {
                sbOuter.append(" '' as ").append(columnName.toLowerCase());
            } else {
                sbOuter.append(" null as ").append(columnName.toLowerCase());
            }
            if (i != columnCount - 1) {
                sbOuter.append(", \n");
                continue;
            }
            sbOuter.append(" \n");
        }
        sbOuter.append(" from \n");
        sbOuter.append(" ( \n");
        sbOuter.append(inner);
        sbOuter.append(" ) as a\n");
        sbOuter.append("  group by frowtype\n");
        return sbOuter;
    }

    private StringBuffer genInnerSelectNew(String tempTableName, ColumnAttributeList columnAttrs) {
        StringBuffer sbInner = new StringBuffer();
        sbInner.append(" \n select ");
        int columnCount = columnAttrs.size();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = columnAttrs.getIndex(i).getColumnName();
            int columnType = columnAttrs.getIndex(i).getSqlType();
            if (this.isSumColumn(columnName)) {
                sbInner.append(" sum(").append(columnName.toLowerCase()).append(") as  ").append(columnName.toLowerCase());
            } else if (this.isDescColumn(columnName)) {
                sbInner.append(" '" + this.subTotal + "' as ").append(columnName.toLowerCase());
            } else if (this.isRowTypeColumn(columnName)) {
                sbInner.append(" 10 as ").append(columnName.toLowerCase());
            } else if (3 == columnType || 4 == columnType) {
                if (columnName.equalsIgnoreCase("fperiod")) {
                    sbInner.append(" 999912 as ").append(columnName.toLowerCase());
                } else if (columnName.equalsIgnoreCase("fperiodyear")) {
                    sbInner.append(" 9999 as ").append(columnName.toLowerCase());
                } else if (columnName.equalsIgnoreCase("fperiodnumber")) {
                    sbInner.append(" 12 as ").append(columnName.toLowerCase());
                } else {
                    sbInner.append(" 0 as ").append(columnName.toLowerCase());
                }
            } else if (12 == columnType) {
                sbInner.append(" '' as ").append(columnName.toLowerCase());
            } else {
                sbInner.append(" null as ").append(columnName.toLowerCase());
            }
            if (i != columnCount - 1) {
                sbInner.append(", \n");
                continue;
            }
            sbInner.append(" \n");
        }
        sbInner.append(" from ").append(tempTableName).append("\n");
        sbInner.append("  where (frowType=2 or frowType=0) \n");
        sbInner.append("  group by fperiodyear \n");
        return sbInner;
    }

    private ColumnAttributeList getAllColumnsNew(Context ctx, String tempTableName) throws BOSException {
        ColumnAttributeList ret = new ColumnAttributeList();
        String columnName = "";
        int columnType = -999;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 *  from " + tempTableName));
        try {
            IRowSetMetaData rsmd = rs.getRowSetMetaData();
            int columnCount = rsmd.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                columnName = rsmd.getColumnName(i + 1);
                columnType = rsmd.getColumnType(i + 1);
                ret.add(new ColumnAttributeInfo(columnName, columnType));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    @Override
    protected String[][] getHeadAndFields(Context ctx, RptParams params) {
        ArrayList<String> head1 = new ArrayList<String>();
        ArrayList<String> head2 = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        List itemList = (List)params.getObject("actList");
        int itemCount = itemList.size();
        for (int i = 0; i < itemCount; ++i) {
            fields.add("ASSTITEM" + i);
            AsstactTypeEntity at = (AsstactTypeEntity)itemList.get(i);
            head1.add(at.getName());
            head2.add(at.getName());
        }
        fields.add("FAccountNumber");
        fields.add("FAccountName");
        fields.add("FBookedDate");
        fields.add("FPeriod");
        fields.add("FVoucherType");
        fields.add("FVoucherNo");
        fields.add("FBizDate");
        fields.add("FDescription");
        head1.add(GLResUtil.getRes("accountView_number", ctx));
        head1.add(GLResUtil.getRes("accountView_name", ctx));
        head1.add(GLResUtil.getRes("bookedDate", ctx));
        head1.add(GLResUtil.getRes("period", ctx));
        head1.add(GLResUtil.getRes("voucherType", ctx));
        head1.add(GLResUtil.getRes("voucherNumber", ctx));
        head1.add(GLResUtil.getRes("bizDate", ctx));
        head1.add(GLResUtil.getRes("abstract_description", ctx));
        head2.add(GLResUtil.getRes("accountView_number", ctx));
        head2.add(GLResUtil.getRes("accountView_name", ctx));
        head2.add(GLResUtil.getRes("bookedDate", ctx));
        head2.add(GLResUtil.getRes("period", ctx));
        head2.add(GLResUtil.getRes("voucherType", ctx));
        head2.add(GLResUtil.getRes("voucherNumber", ctx));
        head2.add(GLResUtil.getRes("bizDate", ctx));
        head2.add(GLResUtil.getRes("abstract_description", ctx));
        String currencyId = null;
        if (params.getObjectElement("jbxCurrency.value.id") != null) {
            currencyId = params.getObjectElement("jbxCurrency.value.id").toString();
        }
        CompanyOrgUnitInfo currCompany = (CompanyOrgUnitInfo)params.getObject("company");
        String baseCurrencyId = currCompany.getBaseCurrency().getId().toString();
        String rptCurrencyId = currCompany.getReportCurrency() != null ? currCompany.getReportCurrency().getId().toString() : baseCurrencyId;
        String RES_PATH = "com.kingdee.eas.fi.gl.GLRes";
        if (currencyId == null) {
            fields.add("FCurrencyName");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"currency", (Locale)ctx.getLocale()));
            head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency", (Locale)ctx.getLocale()));
        }
        if (currencyId == null || currencyId != null && !currencyId.equals(baseCurrencyId) && !currencyId.equals(rptCurrencyId)) {
            fields.add("FLocalExchangeRate");
            head1.add(GLResUtil.getRes("localExchangeRate", ctx));
            head2.add(GLResUtil.getRes("localExchangeRate", ctx));
        }
        if (this.displayAmount) {
            fields.add("FMeasureUnitName");
            head1.add(GLResUtil.getRes("MeasureUnit", ctx));
            head2.add(GLResUtil.getRes("MeasureUnit", ctx));
            if (this.showAsstUnitAndQty) {
                fields.add("FASSISTUNITNAME");
                head1.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"235_VoucherEditBaseUI", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"235_VoucherEditBaseUI", (Locale)ctx.getLocale()));
            }
        }
        if (this.displayAmount) {
            fields.add("FDebitQty");
            fields.add("FDebitPrice");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("asst_quantity", ctx));
            head2.add(GLResUtil.getRes("price", ctx));
            if (this.showAsstUnitAndQty) {
                fields.add("FDebitAssistQty");
                fields.add("FDebitAssistPrice");
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"237_VoucherEditBaseUI", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"236_VoucherEditBaseUI", (Locale)ctx.getLocale()));
            }
        }
        if (currencyId == null || currencyId != null && !currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            fields.add("FDebit_FOR");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("currency_for", ctx));
            if (currencyId != null) {
                if (!currencyId.equals(baseCurrencyId)) {
                    fields.add("FDebit_LOCAL");
                    head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
                    head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
                }
                if (!currencyId.equals(rptCurrencyId)) {
                    fields.add("FDebit_RPT");
                    head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
                    head2.add(GLResUtil.getRes("currency_rpt", ctx));
                }
            } else {
                fields.add("FDebit_LOCAL");
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
            }
        } else if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            fields.add("FDebit_LOCAL");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
            head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
        } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            fields.add("FDebit_RPT");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("currency_rpt", ctx));
        }
        if (this.displayAmount) {
            fields.add("FCreditQty");
            fields.add("FCreditPrice");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("asst_quantity", ctx));
            head2.add(GLResUtil.getRes("price", ctx));
            if (this.showAsstUnitAndQty) {
                fields.add("FCreditAssistQty");
                fields.add("FCreditAssistPrice");
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"237_VoucherEditBaseUI", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"236_VoucherEditBaseUI", (Locale)ctx.getLocale()));
            }
        }
        if (currencyId == null || currencyId != null && !currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            fields.add("FCredit_FOR");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("currency_for", ctx));
            if (currencyId != null) {
                if (!currencyId.equals(baseCurrencyId)) {
                    fields.add("FCredit_LOCAL");
                    head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
                    head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
                }
                if (!currencyId.equals(rptCurrencyId)) {
                    fields.add("FCredit_RPT");
                    head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
                    head2.add(GLResUtil.getRes("currency_rpt", ctx));
                }
            } else {
                fields.add("FCredit_LOCAL");
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
            }
        } else if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            fields.add("FCredit_LOCAL");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
            head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
        } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            fields.add("FCredit_RPT");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("currency_rpt", ctx));
        }
        if (this.displayAmount) {
            fields.add("FEndQty");
            fields.add("FBalancePRICE");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("asst_quantity", ctx));
            head2.add(GLResUtil.getRes("price", ctx));
        }
        fields.add("FDC");
        head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
        head2.add(ResourceBase.getString((String)RES_PATH, (String)"direction", (Locale)ctx.getLocale()));
        if (currencyId == null || currencyId != null && !currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            fields.add("FBalance_FOR");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("currency_for", ctx));
            if (currencyId != null) {
                if (!currencyId.equals(baseCurrencyId)) {
                    fields.add("FBalance_LOCAL");
                    head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
                    head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
                }
                if (!currencyId.equals(rptCurrencyId)) {
                    fields.add("FBalance_RPT");
                    head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
                    head2.add(GLResUtil.getRes("currency_rpt", ctx));
                }
            } else {
                fields.add("FBalance_LOCAL");
                head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
                head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
            }
        } else if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            fields.add("FBalance_LOCAL");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
            head2.add(ResourceBase.getString((String)RES_PATH, (String)"currency_local", (Locale)ctx.getLocale()));
        } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            fields.add("FBalance_RPT");
            head1.add(ResourceBase.getString((String)RES_PATH, (String)"balance", (Locale)ctx.getLocale()));
            head2.add(GLResUtil.getRes("currency_rpt", ctx));
        }
        if (this.displayAttribute) {
            fields.add("FBizNumber");
            fields.add("FInvoiceNumber");
            fields.add("FSettlementCode");
            fields.add("settleName");
            fields.add("FTicketNumber");
            head1.add(GLResUtil.getRes("acctviewAttri", ctx));
            head1.add(GLResUtil.getRes("acctviewAttri", ctx));
            head1.add(GLResUtil.getRes("acctviewAttri", ctx));
            head1.add(GLResUtil.getRes("acctviewAttri", ctx));
            head1.add(GLResUtil.getRes("acctviewAttri", ctx));
            head2.add(GLResUtil.getRes("bizNumber", ctx));
            head2.add(GLResUtil.getRes("invoiceNo", ctx));
            head2.add(GLResUtil.getRes("settleNo", ctx));
            head2.add(GLResUtil.getRes("settleType", ctx));
            head2.add(GLResUtil.getRes("exchangeChequeNo", ctx));
        }
        fields.add("FRowType");
        if (this.displayAmount) {
            fields.add("FCoefficient");
        }
        if (this.sumByMeasureUnit) {
            fields.add("isSumMU");
        }
        fields.add("FPeriodYear");
        fields.add("FPeriodNumber");
        if (currencyId == null) {
            fields.add("FCurrencyNumber");
        }
        head1.add("FRowType");
        if (this.displayAmount) {
            head1.add("FCoefficient");
        }
        if (this.sumByMeasureUnit) {
            head1.add("isSumMU");
        }
        head1.add("FPeriodYear");
        head1.add("FPeriodNumber");
        if (currencyId == null) {
            head1.add("FCurrencyNumber");
        }
        head2.add("FRowType");
        if (this.displayAmount) {
            head2.add("FCoefficient");
        }
        if (this.sumByMeasureUnit) {
            head2.add("isSumMU");
        }
        head2.add("FPeriodYear");
        head2.add("FPeriodNumber");
        if (currencyId == null) {
            head2.add("FCurrencyNumber");
        }
        String[][] headAndFields = new String[][]{fields.toArray(new String[fields.size()]), head1.toArray(new String[head1.size()]), head2.toArray(new String[head2.size()])};
        return headAndFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRowSet getExportData(Context ctx, RptParams params) throws BOSException, EASBizException {
        IRowSet iRowSet;
        String tempTableName = null;
        try {
            this.initFilterItem(ctx, params);
            tempTableName = this.insertVoucherDetail(ctx, params);
            params.setString("tempTableName", tempTableName);
            if (this.onlyEndPeriod) {
                this.getYearAndPeriod(ctx, params);
            }
            if (this.sumByMeasureUnit) {
                this.insertSumMeasureUnit(ctx, params, tempTableName);
            }
            SqlParams sp = new SqlParams();
            StringBuffer fromWhere = this.getBalanceFromAndWhereSQL(ctx, params, sp, false);
            boolean isNull = false;
            isNull = this.getTableIsNull(ctx, tempTableName);
            this.insertPeriodBeginBalance(ctx, params, tempTableName, fromWhere, sp);
            if (!(isNull && this.noDisplayZeroTotal && this.onlyEndPeriod)) {
                this.insertPeiordAndYearBalance(ctx, params, tempTableName, fromWhere, sp);
            }
            if (this.onlyEndPeriod) {
                this.doUpdatePeriodData(ctx, tempTableName);
            }
            if (this.showAsstUnitAndQty) {
                this.setAssCou(ctx, tempTableName);
            }
            if (this.showSum) {
                this.insertSumResultNew(ctx, tempTableName, params);
            }
            StringBuffer querySQL = new StringBuffer();
            querySQL.append(" select * from ").append(tempTableName);
            querySQL.append("\n order by ");
            if (params.getBoolean("isExportToExcel")) {
                List itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (int i = 0; i < itemCount; ++i) {
                    querySQL.append("ASSTITEM").append(i).append(",");
                }
            }
            querySQL.append(" FAccountNumber, ");
            if (this.currencyId == null) {
                querySQL.append("FCurrencyNumber,");
            }
            querySQL.append("FPeriodYear, FPeriodNumber, FRowType,");
            querySQL.append("FBookedDate, FVoucherNO, FSeq");
            if (this.displayAmount) {
                querySQL.append(",FMeasureUnitNumber");
                if (this.sumByMeasureUnit) {
                    querySQL.append(",isSumMU");
                }
            }
            iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySQL.toString());
        }
        catch (Throwable throwable) {
            this.dropPoolTempTable(ctx, tempTableName);
            throw throwable;
        }
        this.dropPoolTempTable(ctx, tempTableName);
        return iRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPLVoucherBalance(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        String currencyID = String.valueOf(params.getObjectElement("jbxCurrency.value.id"));
        boolean includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        SqlParams sp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        sql.append(" select pd.fperiodyear,pd.fperiodnumber,pd.fnumber,v.fcompanyid,v.fperiodid,ve.faccountid,r.fassgrpid,r.FMeasureUnitID,");
        if (currencyID == null) {
            sql.append("ve.fcurrencyid,");
        } else {
            sql.append("'").append(currencyID).append("' fcurrencyid,");
        }
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FLocalAmount else 0 end) fdebitlocal, \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FLocalAmount else 0 end) fcreditlocal, \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FReportingAmount else 0 end) fdebitrpt,  \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FReportingAmount else 0 end) fcreditrpt, \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FOriginalAmount else 0 end) fdebitfor,   \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FOriginalAmount else 0 end) fcreditfor,  \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FStandardQuantity else 0 end) fdebitqty,   \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FStandardQuantity else 0 end) fcreditqty,  \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitlocal,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitrpt,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitfor,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitqty,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditlocal,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditrpt,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditfor,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditqty,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginbalancelocal, \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginbalancerpt, \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginbalancefor, \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginqty, \r\n");
        sql.append(" to_decimal(0.00,19,4) fendbalancelocal,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fendbalancerpt,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fendbalancefor,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fendqty    \r\n");
        sql.append(" from t_gl_voucher v \r\n");
        sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid \r\n");
        sql.append(" inner join t_gl_voucherassistrecord r on r.fbillid = v.fid and r.fentryid = ve.fid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid \r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        sql.append(" where v.fbizstatus ").append(includeUnPost ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        if (GlUtils.isCompanyUnion(company)) {
            sql.append(" and v.fcompanyid in (").append(company.getDescription()).append(")");
        } else {
            sql.append(" and v.fcompanyid = ?");
            sp.addString(company.getId().toString());
        }
        sql.append(" and av.faccounttableid = ? ");
        sp.addString(((CompanyOrgUnitInfo)params.getObject("company")).getAccountTable().getId().toString());
        sql.append(" and pd.ftypeid = ?");
        sp.addString(company.getAccountPeriodType().getId().toString());
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
        int fromNumber = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
        int toNumber = (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value");
        sp.addInt(fromNumber);
        sp.addInt(toNumber);
        if (currencyID != null && !currencyID.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyID.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append(" and ve.fcurrencyid = ?");
            sp.addString(currencyID);
        }
        sql.append("\r\n group by v.fcompanyid,v.fperiodid,ve.faccountid,r.fassgrpid,r.FMeasureUnitID,ve.fcurrencyid,pd.fnumber,pd.fperiodyear,pd.fperiodnumber");
        String plVoucherTempTable = this.executeCreateTableAsSelectInto("select * into TEMP_GL_GG_PLVOUCHER from (" + sql.toString() + ") as tempTable ", sp, ctx).getTempTable();
        sql = new StringBuffer();
        sql.append("insert into ").append(plVoucherTempTable).append(" select pd.fperiodyear,pd.fperiodnumber,pd.fnumber,");
        sql.append(" t1.fcompanyid,pd.fid,t1.faccountid,t1.fassgrpid,t1.FMeasureUnitID,t1.fcurrencyid,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ");
        sql.append(" from (select distinct fcompanyid,faccountid,fassgrpid,FMeasureUnitID,fcurrencyid from ").append(plVoucherTempTable).append(")");
        sql.append(" t1 inner join t_bd_period pd on 1 = 1 ");
        sql.append(" where pd.fnumber >= ").append(fromNumber).append(" and pd.fnumber <=").append(toNumber);
        sql.append(" and not exists (select 1 from ").append(plVoucherTempTable).append(" t2 where ");
        sql.append(" t2.fcompanyid = t1.fcompanyid and t2.fperiodid = pd.fid and t2.faccountid =t1.faccountid and t2.fassgrpid = t1.fassgrpid and t2.fcurrencyid = t1.fcurrencyid and t2.FMeasureUnitID=t1.FMeasureUnitID)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(plVoucherTempTable, "fcompanyid,fperiodid,faccountid,fassgrpid,fcurrencyid", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Create Index ERROR", (Throwable)e);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, plVoucherTempTable);
        }
        catch (Exception e) {
            logger.error((Object)"Analye Table ERROR", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.setLength(0);
        sql.append("update ").append(plVoucherTempTable);
        sql.append(" set (fyeardebitlocal,fyeardebitrpt,fyeardebitfor,fyearcreditlocal,fyearcreditrpt,fyearcreditfor,fyeardebitqty,fyearcreditqty,fendbalancelocal,fendbalancerpt,fendbalancefor,fendqty) \r\n");
        sql.append(" = (select t.fyeardebitlocal,t.fyeardebitrpt,t.fyeardebitfor,t.fyearcreditlocal,t.fyearcreditrpt,t.fyearcreditfor,t.fyeardebitqty,fyearcreditqty,t.fendbalancelocal,t.fendbalancerpt,t.fendbalancefor,t.fendqty \r\n");
        sql.append(" from (select t1.fcompanyid companyid,t1.fperiodid periodid,t1.faccountid accountid,t1.fassgrpid assgrpid,t1.fcurrencyid currencyid,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitlocal else 0 end) fyeardebitlocal,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitrpt else 0 end) fyeardebitrpt,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitfor else 0 end) fyeardebitfor,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditlocal else 0 end) fyearcreditlocal, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditrpt else 0 end) fyearcreditrpt, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditfor else 0 end) fyearcreditfor, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitqty else 0 end) fyeardebitqty, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditqty else 0 end) fyearcreditqty, ");
        sql.append(" sum(t2.fdebitlocal - t2.fcreditlocal) fendbalancelocal, ");
        sql.append(" sum(t2.fdebitrpt - t2.fcreditrpt) fendbalancerpt, ");
        sql.append(" sum(t2.fdebitfor - t2.fcreditfor) fendbalancefor, ");
        sql.append(" sum(t2.fdebitqty - t2.fcreditqty) fendqty ");
        sql.append(" from ").append(plVoucherTempTable).append(" t1 inner join ").append(plVoucherTempTable).append(" t2 on t1.fcompanyid = t2.fcompanyid and t1.faccountid = t2.faccountid and t1.fassgrpid = t2.fassgrpid and t1.fcurrencyid = t2.fcurrencyid ");
        sql.append(" where t1.fnumber>=t2.fnumber ");
        sql.append(" group by t1.fcompanyid,t1.fperiodid,t1.faccountid,t1.fassgrpid,t1.fcurrencyid) t where t.companyid = fcompanyid and t.periodid = fperiodid and t.accountid = faccountid and t.assgrpid = fassgrpid and t.currencyid = fcurrencyid) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update ").append(plVoucherTempTable);
        sql.append(" set fbeginbalancelocal = fendbalancelocal + fcreditlocal - fdebitlocal");
        sql.append(",fbeginbalancerpt = fendbalancerpt + fcreditrpt - fdebitrpt");
        sql.append(",fbeginbalancefor = fendbalancefor + fcreditfor - fdebitfor");
        sql.append(",fbeginqty = fendqty + fcreditqty - fdebitqty");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return plVoucherTempTable;
    }

    @Override
    protected ArrayList exportTransmit(Context ctx, IRowSet rs, RptParams params, String[] fields) throws BOSException {
        HashMap map;
        Object obj;
        ArrayList data = super.exportTransmit(ctx, rs, params, fields);
        if (this.showSum && data.size() >= 2 && (obj = data.get(0)) instanceof HashMap && "10".equals(String.valueOf((map = (HashMap)obj).get("FROWTYPE")))) {
            Object removeObj = data.remove(0);
            data.add(removeObj);
        }
        return data;
    }

    private void isAsstAccountHasMaterial(Context ctx, String asstAccountID, RptParams params) throws BOSException, EASBizException {
        block2: {
            block3: {
                if (asstAccountID == null) break block3;
                Vector vor = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(asstAccountID));
                for (AsstActTypeInfo asst : vor) {
                    if (!asst.getAsstHGAttribute().equals("material") || !this.displayAmount || !this.getPar(ctx)) continue;
                    this.showAsstUnitAndQty = true;
                    break block2;
                }
                break block2;
            }
            List actList = (List)params.getObject("actList");
            if (actList == null) break block2;
            for (int i = 0; i < actList.size(); ++i) {
                AsstactTypeEntity act = (AsstactTypeEntity)actList.get(i);
                if (!act.getHgAttribute().equals("material") || !this.displayAmount || !this.getPar(ctx)) continue;
                this.showAsstUnitAndQty = true;
                break;
            }
        }
    }

    private boolean getPar(Context ctx) {
        boolean re = true;
        String curComId = (String)ctx.get((Object)"CurCompanyId");
        try {
            GlParam param = GlParam.getGlParams((Context)ctx, (String)"GL_098", (String)curComId);
            re = param.getBoolean("GL_098");
        }
        catch (Exception err) {
            re = false;
            logger.error((Object)err);
        }
        return re;
    }

    protected void setAssCou(Context ctx, String tempTable) throws EASBizException, BOSException {
        String selectSql = " select faccountid,fperiodid,sum(FDebitAssistQty) FDebitAssistQty ,sum(fcreditAssistqty)fcreditAssistqty from " + tempTable + " where frowtype = 1 group by faccountid,fperiodid";
        IRowSet rss = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            while (rss.next()) {
                StringBuffer updateSql = new StringBuffer();
                updateSql.append("update " + tempTable + "  set FDebitAssistQty =" + rss.getBigDecimal("FDebitAssistQty"));
                updateSql.append(", fcreditAssistqty=" + rss.getDouble("fcreditAssistqty"));
                if (rss.getBigDecimal("FDebitAssistQty") == null || rss.getBigDecimal("FDebitAssistQty").compareTo(GlUtils.zero) == 0) {
                    updateSql.append(",FDebitAssistPrice=null");
                } else {
                    updateSql.append(",FDebitAssistPrice=FDebit_for/" + rss.getDouble("FDebitAssistQty"));
                }
                if (rss.getBigDecimal("fcreditAssistqty") == null || rss.getBigDecimal("fcreditAssistqty").compareTo(GlUtils.zero) == 0) {
                    updateSql.append(",FCreditAssistPrice=null");
                } else {
                    updateSql.append(",FCreditAssistPrice=FCredit_for/" + rss.getDouble("fcreditAssistqty"));
                }
                updateSql.append(" where faccountid='" + rss.getString("faccountid") + "'");
                updateSql.append(" and fperiodid='" + rss.getString("fperiodid") + "'");
                updateSql.append(" and (frowtype = 2 or frowtype =3 )");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
        }
        String sql = "select FPeriodNumber,count(FDebitAssistUnitName) co from( select FPeriodNumber,FDebitAssistUnitName from " + tempTable + " \r\n where FPeriodNumber in \r\n (select FPeriodNumber from " + tempTable + "  where fRowtype=2 group by FPeriodNumber) \r\n and FDebitAssistUnitName is not null group by FDebitAssistUnitName,FPeriodNumber \r\n ) group by FPeriodNumber";
        String ids = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                int cou = rs.getInt("co");
                if (cou == 1) continue;
                ids = ids + rs.getString("FPeriodNumber") + "','";
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 3);
            String sql2 = "update " + tempTable + " set FDebitAssistQty=null,FDebitAssistPrice=null where FPeriodNumber in('" + ids + "') and (fRowtype=2 or fRowtype=3)";
            DbUtil.execute((Context)ctx, (String)sql2);
        }
        String updateCreditSql = "select FPeriodNumber,count(FCreditAssistUnitName) co from( select FPeriodNumber,FCreditAssistUnitName from " + tempTable + " \r\n where FPeriodNumber in \r\n (select FPeriodNumber from " + tempTable + "  where fRowtype=2 group by FPeriodNumber) \r\n and FCreditAssistUnitName is not null group by FCreditAssistUnitName,FPeriodNumber \r\n ) group by FPeriodNumber";
        String ids2 = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)updateCreditSql);
            while (rs.next()) {
                int cou = rs.getInt("co");
                if (cou == 1) continue;
                ids2 = ids2 + rs.getString("FPeriodNumber") + "','";
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (ids2.length() > 0) {
            ids = ids2.substring(0, ids2.length() - 3);
            String sql2 = "update " + tempTable + " set FCreditAssistQty=null,FCreditAssistPrice=null where FPeriodNumber in('" + ids2 + "') and (fRowtype=2 or fRowtype=3)";
            DbUtil.execute((Context)ctx, (String)sql2);
        }
    }
}

