/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractRptAsstactGSControllerBean;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class RptAsstactGSControllerBean
extends AbstractRptAsstactGSControllerBean {
    private static final long serialVersionUID = 7005601304940365803L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactGSControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams pp = new RptParams();
        pp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        pp.setObject("currency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        pp.setObject("maxLevel", (Object)new Integer(RptServerUtil.getMaxAccountLevel(ctx, company.getId().toString())));
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        if (Boolean.TRUE.equals(params.getObjectElement("rbAccountBalance.value"))) {
            return this.createAccountBalanceTempTable(ctx, params);
        }
        return this.createAsstBalanceTempTable(ctx, params);
    }

    protected RptParams createAccountBalanceTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = "asstact_gs_table";
        String loc = this.getLoc(ctx);
        String companyId = params.getString("companyId");
        RptParams param = RptClientUtil.loadSystemParams(companyId, ctx);
        boolean parmForeignCurrencySu = Boolean.parseBoolean(param.getObject("GL_008").toString());
        boolean parmAllowCussent = Boolean.parseBoolean(param.getObject("GL_028").toString());
        boolean includeNoPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        boolean noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        String currencyId = params.getObjectElement("jbxCurrency.value.id") == null ? null : params.getObjectElement("jbxCurrency.value.id").toString();
        int[] periodRange = new int[]{(Integer)params.getObjectElement("jspYearFrom.value"), (Integer)params.getObjectElement("jspPeriodFrom.value"), (Integer)params.getObjectElement("jspYearTo.value"), (Integer)params.getObjectElement("jspPeriodTo.value")};
        int periodStart = periodRange[0] * 100 + periodRange[1];
        int periodEnd = periodRange[2] * 100 + periodRange[3];
        int levelFrom = (Integer)params.getObjectElement("spnAccountLevelBegin.value");
        int levelTo = (Integer)params.getObjectElement("spnAccountLevelEnd.value");
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        String accountName = this.getAccountName(ctx, companyId);
        sql.append("select C.FID FAccountID, C.FNumber FAccountNumber, C.").append(accountName).append(loc).append(" FAccountName, D.FName_").append(loc).append(" FCurrencyName, D.fnumber fcurrenctnumber,C.FDC, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FBeginBalanceFor else 0 end) FBeginBalanceFor, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FBeginBalanceLocal else 0 end) FBeginBalanceLocal, ").append("\n sum(B.FDebitFor) FDebitFor, sum(B.FDebitLocal) FDebitLocal, sum(B.FCreditFor) FCreditFor, sum(B.FCreditLocal) FCreditLocal, ").append("\n sum(case when B.FPeriod=? then B.FYearDebitFor else 0 end) FYearDebitFor, ").append("\n sum(case when B.FPeriod=? then B.FYearDebitLocal else 0 end) FYearDebitLocal, ").append("\n sum(case when B.FPeriod=? then B.FYearCreditFor else 0 end) FYearCreditFor, ").append("\n sum(case when B.FPeriod=? then B.FYearCreditLocal else 0 end) FYearCreditLocal, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FEndBalanceFor else 0 end) FEndBalanceFor, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FEndBalanceLocal else 0 end) FEndBalanceLocal, ");
        if (parmAllowCussent) {
            sql.append("\n case when C.FCAA is null then '' else (case when C.FAC=0 then '" + GLResUtil.getRes("asst_account", ctx) + "' else '" + GLResUtil.getRes("asst_and_current_account", ctx) + "' end) end FMemo, ");
        } else {
            sql.append("\n case when C.FCAA is null then '' else ( '" + GLResUtil.getRes("asst_account", ctx) + "') end FMemo, ");
        }
        sql.append("\n D.FPrecision, '0' as FNO ");
        int balType = includeNoPost ? 1 : 5;
        sql.append("\n from " + GLBalanceUtils.getAccountBalanceTable(balType) + " B ").append("\n inner join t_bd_accountview C on C.FID=B.FAccountID");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("C", userID, companyID, ctx)).append("\n");
        sql.append("\n inner join t_bd_currency D on D.FID=B.FCurrencyID ").append("\n where B.FOrgUnitId=? and C.fisProfitCenter <> 1 and C.FLevel>=? and C.FLevel<=?").append("\n and B.FPeriod in ").append(SQLUtil.buildPeriodNumbersInSql(periodRange[0], periodRange[1], periodRange[2], periodRange[3]));
        sp.addInt(periodStart).addInt(periodStart).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd);
        sp.addString(companyId).addInt(levelFrom).addInt(levelTo);
        if (currencyId != null) {
            sql.append("\n and B.FCurrencyID=?");
            sp.addString(currencyId);
        }
        sql.append(" and C.Faccounttableid=?");
        sp.addString(params.getString("accountTableId"));
        sql.append("\n group by C.FID, C.FNumber, C.").append(accountName).append(loc).append(", D.FName_").append(loc).append(", D.fnumber, C.FDC, C.FCAA, C.FAC, D.FPrecision");
        if (noDisplayZero) {
            sql.append("\n having sum(B.FDebitFor) <> 0 or sum(B.FDebitLocal) <> 0 or sum(B.FCreditFor) <> 0 or sum(B.FCreditLocal) <> 0 ").append(" or C.FDC*sum(case when B.FPeriod=? then B.FEndBalanceFor else 0 end) <> 0 ").append(" or C.FDC*sum(case when B.FPeriod=? then B.FEndBalanceLocal else 0 end) <> 0 ");
            sp.addInt(periodEnd).addInt(periodEnd);
        }
        StringBuffer tbl = new StringBuffer();
        tbl.append("FACCOUNTID\tvarchar(44),").append("FACCOUNTNUMBER\tvarchar(80),").append("FACCOUNTNAME\tvarchar(255),");
        tbl.append("FCURRENCYNAME\tvarchar(255),");
        tbl.append("FCURRENCTNUMBER\tvarchar(80),").append("FDC\tint,").append("FBEGINBALANCEFOR\tdecimal(28,10),");
        tbl.append("FBEGINBALANCELOCAL\tdecimal(28,10),").append("FDEBITFOR\tdecimal(28,10),").append("FDEBITLOCAL\tdecimal(28,10),");
        tbl.append("FCREDITFOR\tdecimal(28,10),").append("FCREDITLOCAL\tdecimal(28,10),").append("FYEARDEBITFOR\tdecimal(28,10),");
        tbl.append("FYEARDEBITLOCAL\tdecimal(28,10),").append("FYEARCREDITFOR\tdecimal(28,10),").append("FYEARCREDITLOCAL\tdecimal(28,10),");
        tbl.append("FENDBALANCEFOR\tdecimal(28,10),").append("FENDBALANCELOCAL\tdecimal(28,10),").append("FMEMO\tvarchar(80),");
        tbl.append("FPRECISION\tint,").append("FNO\tvarchar(80)");
        tempTable = GLTempTableUtil.createDBSysTempTable(ctx, tbl.toString());
        Object[] tempParam = sp.getParams();
        DbUtil.execute((Context)ctx, (String)("INSERT  INTO " + tempTable + "  " + sql.toString()), (Object[])tempParam);
        if (!noDisplayZero) {
            this.insertNotUseAccountForVirtual(params, tempTable, ctx);
        }
        if (currencyId == null) {
            StringBuffer ssql = new StringBuffer();
            ssql.append("insert into ").append(tempTable).append("\n select Faccountid,FAccountNumber, FAccountName, '" + GLResUtil.getRes("subtotal", ctx) + "','', FDC,").append("\n 0 FBeginBalanceFor, sum(FBeginBalanceLocal), 0 FDebitFor, sum(FDebitLocal),").append("\n 0 FCreditFor, sum(FCreditLocal), 0 FYearDebitFor, sum(FYearDebitLocal),").append("\n 0 FYearCreditFor, sum(FYearCreditLocal), 0 FEndBalanceFor, sum(FEndBalanceLocal), ").append("\n FMemo, max(FPrecision), '1'").append("\n from ").append(tempTable).append("\n group by Faccountid,FAccountNumber, FAccountName,  FDC, FMemo");
            this.executeUpdate(ssql.toString(), null, ctx);
        }
        RptTableHeader head = new RptTableHeader();
        int colCount = 20;
        for (int i = 0; i < colCount; ++i) {
            RptTableColumn col = new RptTableColumn("A" + i);
            col.setWidth(100);
            head.addColumn(col);
            if (i < 4 || i > 16) continue;
            col.setAligment(2);
            if (!parmForeignCurrencySu || i % 2 == 0) continue;
            col.setHided(true);
        }
        head.getColumn(2).setWidth(80);
        head.getColumn(3).setWidth(-1);
        head.getColumn(3).setHided(true);
        head.getColumn(4).setWidth(40);
        head.getColumn(4).setAligment(1);
        head.getColumn(18).setHided(true);
        head.getColumn(19).setHided(true);
        if (parmForeignCurrencySu) {
            head.getColumn(6).setHided(true);
            head.getColumn(6).setWidth(-1);
            head.getColumn(8).setHided(true);
            head.getColumn(8).setWidth(-1);
            head.getColumn(10).setHided(true);
            head.getColumn(10).setWidth(-1);
            head.getColumn(12).setHided(true);
            head.getColumn(12).setWidth(-1);
            head.getColumn(14).setHided(true);
            head.getColumn(14).setWidth(-1);
            head.getColumn(16).setHided(true);
            head.getColumn(16).setWidth(-1);
        }
        head.setLabels((Object[][])new Object[][]{{GLResUtil.getRes("accountView_number", ctx), GLResUtil.getRes("accountView_name", ctx), GLResUtil.getRes("currency", ctx), GLResUtil.getRes("currencyNumber", ctx), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("balance_period_begin", ctx), GLResUtil.getRes("balance_period_begin", ctx), GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("debit_year_sum", ctx), GLResUtil.getRes("debit_year_sum", ctx), GLResUtil.getRes("debit_period_sum", ctx), GLResUtil.getRes("debit_period_sum", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("memo", ctx), GLResUtil.getRes("precision", ctx), GLResUtil.getRes("row_subtotal", ctx)}, {GLResUtil.getRes("accountView_number", ctx), GLResUtil.getRes("accountView_name", ctx), GLResUtil.getRes("currency", ctx), GLResUtil.getRes("currencyNumber", ctx), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("memo", ctx), GLResUtil.getRes("precision", ctx), GLResUtil.getRes("row_subtotal", ctx)}}, true);
        if (parmForeignCurrencySu) {
            head.setLabels(CellMatrix.removeRows((Object[][])head.getLabels(), (int[])new int[]{1}));
        }
        RptParams pp = new RptParams();
        pp.setObject("head", (Object)head);
        pp.setString("tempTable", tempTable);
        RptRowSet crs = this.executeQuery("select count(1) c from " + tempTable, null, ctx);
        crs.next();
        pp.setInt("count", crs.getInt("c"));
        pp.setInt("acctCount", 0);
        return pp;
    }

    private String getAccountName(Context ctx, String companyId) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", companyId);
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "FLongName_" : "FName_";
    }

    protected void insertNotUseAccountForVirtual(RptParams params, String tempTable, Context ctx) throws BOSException, EASBizException {
        String loc = this.getLoc(ctx);
        String accountName = this.getAccountName(ctx, params.getString("companyId"));
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        int levelFrom = (Integer)params.getObjectElement("spnAccountLevelBegin.value");
        int levelTo = (Integer)params.getObjectElement("spnAccountLevelEnd.value");
        sql.append("INSERT INTO ");
        sql.append(tempTable);
        sql.append(" \r\n");
        sql.append("select C.FID, C.FNumber FAccountNumber, C.FName").append(" FAccountName, '' FCurrencyName,'' fcurrenctnumber, C.FDC, 0.0 FBeginBalanceFor, 0.0 FBeginBalanceLocal,  0.0 FDebitFor, 0.0 FDebitLocal,0.0 FCreditFor, 0.0 FCreditLocal,  0.0 FYearDebitFor,  0.0 FYearDebitLocal,  0.0 FYearCreditFor,  0.0 FYearCreditLocal,  0.0 FEndBalanceFor, 0.0 FEndBalanceLocal,   ''  FMemo,  0.0 FPrecision, '0' as FNO ");
        sql.append("FROM \r\n");
        sql.append("   (SELECT TAC.FID,TAC.FNumber,").append(accountName).append(loc).append(" FName,FCompanyId ,FDC ,FLevel \r\n");
        sql.append("\tFROM T_BD_AccountView  TAC \r\n");
        sql.append(RptServerUtil.innerJoinAccountPermissionSql("TAC", userID, companyID, ctx));
        sql.append("\tWHERE fisProfitCenter <> 1 and FAccountTableId = ? \r\n ");
        sql.append("\tAND fcompanyid = ?\t\r\n");
        sql.append("\t) AS C \r\n");
        sql.append("\tLEFT OUTER JOIN ");
        sql.append(tempTable);
        sql.append(" AS T \r\n");
        sql.append("\tON C.FID = T.FAccountID \r\n");
        sql.append("WHERE T.FAccountID is null and C.FLevel>=? and C.FLevel<=?\r\n");
        SqlParams sp = new SqlParams();
        sp.addString(params.getString("accountTableId"));
        sp.addString(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        sp.addInt(levelFrom);
        sp.addInt(levelTo);
        this.executeUpdate(sql.toString(), sp, ctx);
    }

    protected RptParams createAsstBalanceTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        int i;
        int n;
        int i2;
        String alis;
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = "asstact_gs_balance_table";
        String loc = this.getLoc(ctx);
        String companyId = params.getString("companyId");
        RptParams param = RptClientUtil.loadSystemParams(companyId, ctx);
        boolean parmForeignCurrencySu = Boolean.valueOf(param.getObject("GL_008").toString());
        boolean parmAllowCussent = Boolean.valueOf(param.getObject("GL_028").toString());
        Object strAsstShowLongNumber = param.getObject("GL_064");
        boolean asstShowLongNumber = strAsstShowLongNumber == null ? false : Boolean.valueOf((String)strAsstShowLongNumber);
        boolean includeNoPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        boolean noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        String currencyId = params.getObjectElement("jbxCurrency.value.id") == null ? null : params.getObjectElement("jbxCurrency.value.id").toString();
        int[] periodRange = new int[]{(Integer)params.getObjectElement("jspYearFrom.value"), (Integer)params.getObjectElement("jspPeriodFrom.value"), (Integer)params.getObjectElement("jspYearTo.value"), (Integer)params.getObjectElement("jspPeriodTo.value")};
        int periodStart = periodRange[0] * 100 + periodRange[1];
        int periodEnd = periodRange[2] * 100 + periodRange[3];
        String accountFrom = (String)params.getObjectElement("jebAccountFrom.value.number");
        String accountTo = (String)params.getObjectElement("jebAccountTo.value.number");
        String asstId = params.getObjectElement("jebAcct.value.id").toString();
        String asstName = (String)params.getObjectElement("jebAcct.value.name");
        List actList = RptServerUtil.queryAsstAct(asstId, params.getString("cuId"), ctx);
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        String accountName = this.getAccountName(ctx, companyId) + loc;
        sql.append("select C.FNumber FAccountNumber,C.").append(accountName).append(" FAccountName, ").append('\'').append(asstName).append("' FAsstAccountName, ");
        int n2 = actList.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            boolean useLongNumber;
            alis = "T_" + i3;
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i3);
            boolean bl = useLongNumber = asstShowLongNumber && at.isGeneralActType() && at.isMultilevel() || !at.isGeneralActType() && at.isUseLongNumber();
            if (useLongNumber) {
                sql.append("replace(").append(alis).append(".FLongNumber,'!','.')");
            } else {
                sql.append(alis).append(".FNumber");
            }
            sql.append(" FActNumber").append(i3).append(',');
            sql.append(alis).append(".FName_").append(loc).append(" FActName").append(i3).append(',');
        }
        sql.append(" D.FName_").append(loc).append(" FCurrencyName,D.fnumber fcurrenctnumber, C.FDC, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FBeginBalanceFor else 0 end) FBeginBalanceFor, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FBeginBalanceLocal else 0 end) FBeginBalanceLocal, ").append("\n sum(B.FDebitFor) FDebitFor, sum(B.FDebitLocal) FDebitLocal, sum(B.FCreditFor) FCreditFor, sum(B.FCreditLocal) FCreditLocal, ").append("\n sum(case when B.FPeriod=? then B.FYearDebitFor else 0 end) FYearDebitFor, ").append("\n sum(case when B.FPeriod=? then B.FYearDebitLocal else 0 end) FYearDebitLocal, ").append("\n sum(case when B.FPeriod=? then B.FYearCreditFor else 0 end) FYearCreditFor, ").append("\n sum(case when B.FPeriod=? then B.FYearCreditLocal else 0 end) FYearCreditLocal, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FEndBalanceFor else 0 end) FEndBalanceFor, ").append("\n C.FDC*sum(case when B.FPeriod=? then B.FEndBalanceLocal else 0 end) FEndBalanceLocal, ");
        if (parmAllowCussent) {
            sql.append("\n case when C.FCAA is null then '' else (case when C.FAC=0 then '' else '" + GLResUtil.getRes("current_account", ctx) + "' end) end FMemo, ");
        } else {
            sql.append("\n ' ' FMemo, ");
        }
        sql.append("\n D.FPrecision, '0' as FNO ");
        int balType = includeNoPost ? 1 : 5;
        sql.append("\n from " + GLBalanceUtils.getAssistBalanceTable(balType) + " B ").append("\n inner join t_bd_accountview C on C.FID=B.FAccountID").append("\n inner join t_bd_currency D on D.FID=B.FCurrencyID ").append("\n inner join t_bd_assistAntHG E on E.FID=B.FAssistGrpID");
        sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("C", userID, companyID, ctx)).append("\n");
        int n3 = actList.size();
        for (i2 = 0; i2 < n3; ++i2) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i2);
            alis = "T_" + i2;
            sql.append("\n inner join ").append(at.getTableName()).append(' ').append(alis).append(" on E.").append(at.getHgField()).append("=").append(alis).append(".FID");
        }
        n3 = actList.size();
        for (i2 = 0; i2 < n3; ++i2) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i2);
            if (at.getPermissionItem() == null) continue;
            boolean isPermissionByCu = RptServerUtil.checkIfPermissionByCU(ctx, at.getPermissionItem());
            sql.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("E." + at.getHgField(), at.getPermissionItem(), userID, isPermissionByCu ? cuId : companyID, ctx)).append("\n");
        }
        sql.append("\n where B.FOrgUnitId=? and C.fisProfitCenter <> 1 and C.FCAA=?").append("\n and B.FPeriod in ").append(SQLUtil.buildPeriodNumbersInSql(periodRange[0], periodRange[1], periodRange[2], periodRange[3]));
        sp.addInt(periodStart).addInt(periodStart).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd).addInt(periodEnd);
        sp.addString(companyId).addString(asstId);
        if (accountFrom != null) {
            sql.append("\n and C.FNumber>=?");
            sp.addString(accountFrom);
        }
        if (accountTo != null) {
            sql.append("\n and C.FNumber<=?");
            sp.addString(accountTo + "~");
        }
        if (currencyId != null) {
            sql.append("\n and B.FCurrencyID=?");
            sp.addString(currencyId);
        }
        if (noDisplayZero) {
            sql.append("\n and (B.FEndBalanceFor<>0 or B.FEndBalanceLocal<>0 or B.FDebitFor<>0 or B.FDebitLocal<>0 or B.FCreditFor<>0 or B.FCreditLocal<>0)");
        }
        sql.append(" and C.Faccounttableid=?");
        sp.addString(params.getString("accountTableId"));
        sql.append("\n group by  C.FNumber, C.").append(accountName).append(", D.FName_").append(loc).append(", D.fnumber, C.FDC, C.FCAA, C.FAC, D.FPrecision, ");
        n3 = actList.size();
        for (i2 = 0; i2 < n3; ++i2) {
            boolean useLongNumber;
            alis = "T_" + i2;
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i2);
            boolean bl = useLongNumber = asstShowLongNumber && at.isGeneralActType() && at.isMultilevel() || !at.isGeneralActType() && at.isUseLongNumber();
            if (useLongNumber) {
                sql.append(alis).append(".FLongNumber,");
            } else {
                sql.append(alis).append(".FNumber,");
            }
            sql.append(alis).append(".FName_").append(loc).append(',');
        }
        sql.deleteCharAt(sql.length() - 1);
        StringBuffer tbl = new StringBuffer();
        tbl.append("FACCOUNTNUMBER\tvarchar(80),").append("FACCOUNTNAME\tvarchar(255),").append("FASSTACCOUNTNAME\tvarchar(255),");
        int n4 = actList.size();
        for (int i4 = 0; i4 < n4; ++i4) {
            tbl.append("FACTNUMBER" + i4 + "\tvarchar(80),").append("FACTNAME" + i4 + "\tvarchar(255),");
        }
        tbl.append("FCURRENCYNAME\tvarchar(255),");
        tbl.append("FCURRENCTNUMBER\tvarchar(80),").append("FDC\tint,").append("FBEGINBALANCEFOR\tdecimal(28,10),");
        tbl.append("FBEGINBALANCELOCAL\tdecimal(28,10),").append("FDEBITFOR\tdecimal(28,10),").append("FDEBITLOCAL\tdecimal(28,10),");
        tbl.append("FCREDITFOR\tdecimal(28,10),").append("FCREDITLOCAL\tdecimal(28,10),").append("FYEARDEBITFOR\tdecimal(28,10),");
        tbl.append("FYEARDEBITLOCAL\tdecimal(28,10),").append("FYEARCREDITFOR\tdecimal(28,10),").append("FYEARCREDITLOCAL\tdecimal(28,10),");
        tbl.append("FENDBALANCEFOR\tdecimal(28,10),").append("FENDBALANCELOCAL\tdecimal(28,10),").append("FMEMO\tvarchar(80),");
        tbl.append("FPRECISION\tint,").append("FNO\tvarchar(80)");
        tempTable = GLTempTableUtil.createDBSysTempTable(ctx, tbl.toString());
        Object[] tempParam = sp.getParams();
        DbUtil.execute((Context)ctx, (String)("INSERT  INTO " + tempTable + "  " + sql.toString()), (Object[])tempParam);
        if (currencyId == null) {
            StringBuffer ssql = new StringBuffer();
            ssql.append("insert into ").append(tempTable).append("\n select FAccountNumber, FAccountName, FAsstAccountName,");
            n = actList.size();
            for (i = 0; i < n; ++i) {
                ssql.append(" FActNumber").append(i).append(',');
                ssql.append(" FActName").append(i).append(',');
            }
            ssql.append("\n  '" + GLResUtil.getRes("subtotal", ctx) + "','', FDC, to_decimal(null), sum(FBeginBalanceLocal), to_decimal(null), sum(FDebitLocal),").append("\n to_decimal(null), sum(FCreditLocal), to_decimal(null), sum(FYearDebitLocal),").append("\n to_decimal(null), sum(FYearCreditLocal), to_decimal(null), sum(FEndBalanceLocal), ").append("\n FMemo, max(FPrecision), '1'").append("\n from ").append(tempTable).append("\n group by FAccountNumber, FAccountName, FAsstAccountName, FDC, FMemo, ");
            n = actList.size();
            for (i = 0; i < n; ++i) {
                ssql.append(" FActNumber").append(i).append(',');
                ssql.append(" FActName").append(i).append(',');
            }
            ssql.deleteCharAt(ssql.length() - 1);
            this.executeUpdate(ssql.toString(), null, ctx);
        }
        StringBuffer ssql = new StringBuffer();
        ssql.append("insert into ").append(tempTable).append("\n select FAccountNumber, FAccountName,'").append(GlUtils.getMaxChar(ctx)).append("' FAsstAccountName,");
        n = actList.size();
        for (i = 0; i < n; ++i) {
            ssql.append("'").append(GlUtils.getMaxChar(ctx)).append("', ");
            ssql.append("'").append(GlUtils.getMaxChar(ctx)).append("', ");
        }
        if (currencyId == null) {
            ssql.append("\n  '','', FDC, to_decimal(null), sum(FBeginBalanceLocal), to_decimal(null), sum(FDebitLocal),").append("\n to_decimal(null), sum(FCreditLocal), to_decimal(null), sum(FYearDebitLocal),").append("\n to_decimal(null), sum(FYearCreditLocal), to_decimal(null), sum(FEndBalanceLocal), ");
        } else {
            ssql.append("\n  '','', FDC, sum( FBeginBalanceFor), sum(FBeginBalanceLocal), sum( FDebitFor), sum(FDebitLocal),").append("\n sum( FCreditFor), sum(FCreditLocal), sum( FYearDebitFor), sum(FYearDebitLocal),").append("\n sum( FYearCreditFor), sum(FYearCreditLocal), sum( FEndBalanceFor ), sum(FEndBalanceLocal), ");
        }
        ssql.append("\n '' FMemo, max(FPrecision), '2'").append("\n from ").append(tempTable);
        ssql.append("\n where FNO='0' ").append("\n group by FAccountNumber, FAccountName,  FDC ");
        this.executeUpdate(ssql.toString(), null, ctx);
        RptTableHeader head = new RptTableHeader();
        n = actList.size() * 2 + 1;
        int colCount = 20 + n;
        for (int i5 = 0; i5 < colCount; ++i5) {
            RptTableColumn col = new RptTableColumn("A" + i5);
            col.setWidth(100);
            head.addColumn(col);
            if (i5 < 4 + n || i5 > 16 + n) continue;
            col.setAligment(2);
        }
        head.getColumn(2).setWidth(80);
        head.getColumn(3 + n).setWidth(-1);
        head.getColumn(3 + n).setHided(true);
        head.getColumn(4 + n).setWidth(40);
        head.getColumn(4 + n).setAligment(1);
        head.getColumn(18 + n).setHided(true);
        head.getColumn(19 + n).setHided(true);
        if (parmForeignCurrencySu) {
            head.getColumn(6 + n).setHided(true);
            head.getColumn(11).setWidth(-1);
            head.getColumn(8 + n).setHided(true);
            head.getColumn(13).setWidth(-1);
            head.getColumn(10 + n).setHided(true);
            head.getColumn(15).setWidth(-1);
            head.getColumn(12 + n).setHided(true);
            head.getColumn(17).setWidth(-1);
            head.getColumn(14 + n).setHided(true);
            head.getColumn(19).setWidth(-1);
            head.getColumn(16 + n).setHided(true);
            head.getColumn(21).setWidth(-1);
        }
        ArrayList<String> hList = new ArrayList<String>();
        hList.add(GLResUtil.getRes("accountView_number", ctx));
        hList.add(GLResUtil.getRes("accountView_name", ctx));
        hList.add(GLResUtil.getRes("asst_account", ctx));
        int num = actList.size();
        for (int i6 = 0; i6 < num; ++i6) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i6);
            hList.add(GLResUtil.getRes("act_item_number", ctx));
            hList.add(at.getName());
        }
        Object[][] h1 = new Object[][]{hList.toArray()};
        Object[][] h2 = new Object[][]{{GLResUtil.getRes("currency", ctx), GLResUtil.getRes("currencyNumber", ctx), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("balance_period_begin", ctx), GLResUtil.getRes("balance_period_begin", ctx), GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("debit_year_sum", ctx), GLResUtil.getRes("debit_year_sum", ctx), GLResUtil.getRes("debit_period_sum", ctx), GLResUtil.getRes("debit_period_sum", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("memo", ctx), GLResUtil.getRes("precision", ctx), GLResUtil.getRes("row_subtotal", ctx)}, {GLResUtil.getRes("currency", ctx), GLResUtil.getRes("currencyNumber", ctx), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("memo", ctx), GLResUtil.getRes("precision", ctx), GLResUtil.getRes("row_subtotal", ctx)}};
        head.setLabels(CellMatrix.descartesProduct((Object[][])h1, (Object[][])h2), true);
        if (parmForeignCurrencySu) {
            head.setLabels(CellMatrix.removeRows((Object[][])head.getLabels(), (int[])new int[]{1}));
        }
        RptParams pp = new RptParams();
        pp.setObject("head", (Object)head);
        pp.setString("tempTable", tempTable);
        RptRowSet crs = this.executeQuery("select count(1) c from " + tempTable, null, ctx);
        crs.next();
        pp.setInt("count", crs.getInt("c"));
        pp.setInt("acctCount", actList.size());
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        int acctCount = params.getInt("acctCount");
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(tempTable).append("\n order by FAccountNumber, ");
        for (int i = 0; i < acctCount; ++i) {
            sql.append("FActNumber").append(i).append(',');
        }
        sql.append(" FNO,FCURRENCYNAME");
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams rp = new RptParams();
        rp.setObject("rs", (Object)rs);
        return rp;
    }

    protected boolean hasUserCustomConfig(Context ctx) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_fw_usercustomconfig where fuserid =  '").append(userId).append("' and fuiclassname =  'com.kingdee.eas.fi.gl.client.RptAsstactGSUI' ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        return rs.next();
    }
}

