/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CommonSchemaInfo;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.RptCommonSchemaFactory;
import com.kingdee.eas.fi.gl.app.AbstractRptAsstactMultiColumnControllerBean;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class RptAsstactMultiColumnControllerBean
extends AbstractRptAsstactMultiColumnControllerBean {
    private static final long serialVersionUID = -6354344149370519309L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactMultiColumnControllerBean");

    @Override
    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        String companyId = company.getId().toString();
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        CurrencyCollection cc = this._getAllCurrency(ctx);
        initMap.put("getAllCurrency", cc);
        initMap.put("getCurrencyScaleMap", this._getCurrencyScaleMap(ctx, cc, company));
        initMap.put("periodRange", this._getPeriodRange(ctx, company));
        initMap.put("getMaxAccountLevel", new Integer(this._getMaxAccountLevel(ctx, companyId)));
        return initMap;
    }

    @Override
    protected RptRowSet _queryAsstactType(Context ctx, RptParams params) throws BOSException, ReportBizException, EASBizException {
        String loc = this._getLocaleString(ctx);
        String accountId = params.getString("accountId");
        String accountLongNumber = params.getString("accountLongNumber");
        String accountTableId = params.getString("accountTableId");
        String companyId = params.getString("companyId");
        if (accountLongNumber == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("longNumber");
            AccountViewInfo info = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
            accountLongNumber = info.getLongNumber();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("  B.FMappingFieldName fieldName, B.FDefaultQueryName queryName, B.FName_").append(loc).append(" FName, \n");
        sql.append("  B.FIsForCompany, B.FGLAsstActTypeGrpID, B.FAsstHGAttribute, \n");
        sql.append("  case when  B.FGroupTableName is null and B.FIsMultiLevel=1 then 1 else 0 end FIsMultiLevel, \n");
        sql.append("  B.FIsMultiLevel FISLevel, B.FGroupTableName, B.frealtiondataobject, B.fisqty, mu.fname_").append(loc).append(" muname, \n");
        sql.append("  1 FmaxLevel, B.FUseLongNumber \n");
        sql.append("from t_bd_asstactgroupdetail A \n");
        sql.append("inner join t_bd_asstacttype B on B.FID=A.FAsstActTypeId \n");
        sql.append("left join T_BD_MeasureUnitGroup mug on  mug.fid = b.FMeasureUnitGroupID \n");
        sql.append("left join t_bd_measureunit mu on mu.fid = mug.FDefaultUnitID \n");
        sql.append("where A.FAsstAccountId in ( \n");
        sql.append("  select D.FCAA \n");
        sql.append("  from T_BD_AccountView D \n");
        sql.append("  where D.FCompanyID = ? and D.FAccountTableID = ? \n");
        sql.append("    and (D.FID = ? or D.FLongNumber like '" + accountLongNumber + "!%') \n");
        sql.append("    and D.fisleaf = 1 \n");
        sql.append("  union \n");
        sql.append("  select FBeforeID \n");
        sql.append("  from T_BD_AsstAccountChange aac \n");
        sql.append("  join T_BD_AccountView D on D.FID = aac.FAccountID \n");
        sql.append("  where D.FCompanyID = ? and D.FAccountTableID = ? \n");
        sql.append("    and (D.FID = ? or D.FLongNumber like '" + accountLongNumber + "!%') \n");
        sql.append("    and D.fisleaf = 1 \n");
        sql.append(") \n");
        SqlParams pp = new SqlParams().setString(1, companyId);
        pp.setString(2, accountTableId);
        pp.setString(3, accountId);
        pp.setString(4, companyId);
        pp.setString(5, accountTableId);
        pp.setString(6, accountId);
        RptRowSet rst = this.executeQuery(sql.toString(), pp, ctx);
        this.setMaxLevel(ctx, rst);
        return rst;
    }

    @Override
    protected RptParams _querySchema(Context ctx, RptParams params) throws BOSException, ReportBizException, EASBizException {
        return null;
    }

    private void delLastChar(StringBuffer sb) {
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    @Override
    protected RptParams _createAsstactMultiColumnTempTable(Context ctx, RptParams params) throws BOSException, ReportBizException, EASBizException {
        CommonSchemaInfo csi = (CommonSchemaInfo)params.getObject("schema");
        CommonSchema cs = RptCommonSchemaFactory.getLocalInstance(ctx).getSchema(csi.getId().toString());
        this.decodeCommSchmaInfo(cs);
        if (cs == null) {
            throw new ReportBizException(ReportBizException.MULTI_ACCOUNT_SCHEMA_NOT_EXISTS);
        }
        if (!cs.isMatchVersion()) {
            throw new ReportBizException(ReportBizException.MULTI_ACCOUNT_SCHEMA_UNMATCH_VERSION);
        }
        String accViewId = cs.getParams().getString("accountViewID");
        boolean isAccountColumnType = cs.getParams().getBoolean("isAccountColumnType");
        AccountViewInfo accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accViewId));
        if (accountView.isIsLeaf() || !isAccountColumnType) {
            return this.createAsstactMultiColumnTempTable(ctx, params, cs);
        }
        return this.createAccountMultiColumnTempTable(ctx, params, cs);
    }

    private void decodeCommSchmaInfo(CommonSchema cs) throws BOSException {
        Object[][] md = (Object[][])cs.getParams().getObject("md");
        for (int i = 0; i < md.length; ++i) {
            if (md[i][1] instanceof Map) {
                md[i][1] = this.map2Object((Map)md[i][1]);
            }
            if (!(md[i][0] instanceof Integer)) continue;
            md[i][0] = BalanceDirectionEnum.getEnum((int)((Integer)md[i][0]));
        }
        List list = (List)cs.getParams().getObject("asstact_type_list");
        for (int i = 0; i < list.size(); ++i) {
            Object objValue = list.get(i);
            if (!(objValue instanceof Map)) continue;
            list.set(i, this.map2Object((Map)objValue));
        }
    }

    private Object map2Object(Map value) throws BOSException {
        LabelValueBean lvb = new LabelValueBean();
        try {
            BeanUtils.populate((Object)lvb, (Map)value);
            lvb.setProperty(value.get("property"));
        }
        catch (Exception e) {
            BOSException bosEx = new BOSException((Throwable)e);
            throw bosEx;
        }
        return lvb;
    }

    protected RptParams createAccountMultiColumnTempTable(Context ctx, RptParams params, CommonSchema cs) throws BOSException, ReportBizException, EASBizException {
        int i;
        int i2;
        int n;
        int i3;
        Object[] zeros;
        int i4;
        int i5;
        String accountItemId;
        CurrencyInfo ci;
        String currencyId;
        ArrayList<String> sumFileldList;
        ArrayList<String> mcFieldList;
        int mcItemSize;
        int debitSize;
        ArrayList<LabelValueBean> itemList;
        HashMap accountMap;
        ArrayList<LabelValueBean> creditList;
        ArrayList<LabelValueBean> debitList;
        int currencySize;
        ArrayList<CurrencyInfo> currencyList;
        CurrencyCollection cc;
        int accountDc;
        AccountViewInfo accountView;
        String hgFieldName;
        String asstactTypeItemId;
        boolean hideOrigine;
        boolean displayAmount;
        boolean isAccountUpLevel;
        boolean displayEndBalance;
        boolean noDisplayNoCol;
        boolean includeNoTransPLVoucher;
        int[] periodRange;
        int balType;
        String tempTableName;
        String periodType;
        CompanyOrgUnitInfo company;
        String companyId;
        block201: {
            int i6;
            String loc = this._getLocaleString(ctx);
            companyId = params.getString("companyID");
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            periodType = company.getAccountPeriodType().getId().toString();
            tempTableName = params.getString("tempTableName");
            String balTypes = params.getBoolean("includeNoPosting") ? "(1,3,4,5)" : "(5)";
            balType = params.getBoolean("includeNoPosting") ? 1 : 5;
            periodRange = new int[]{params.getInt("yearFrom"), params.getInt("periodFrom"), params.getInt("yearTo"), params.getInt("periodTo")};
            includeNoTransPLVoucher = params.getBoolean("includeNoTransPLVoucher");
            noDisplayNoCol = params.getBoolean("noDisplayNoCol");
            displayEndBalance = params.getBoolean("displayEndBalance");
            isAccountUpLevel = cs.getParams().getBoolean("isAccountUpLevel");
            int fromAccountLevel = 1;
            displayAmount = params.getBoolean("displayAmount");
            boolean displayOneLineBiz = params.getBoolean("displayOneLineBiz");
            hideOrigine = !params.getBoolean("displayOrigine");
            boolean isQtyAsst = cs.getParams().getBoolean("isQtyAsst");
            asstactTypeItemId = null;
            hgFieldName = null;
            if (params.getObject("asstactTypeItemId") != null) {
                asstactTypeItemId = params.getObject("asstactTypeItemId").toString();
            }
            if (params.getObject("actAttributes") != null) {
                hgFieldName = (String)((Object[])params.getObject("actAttributes"))[0];
            }
            String accViewId = cs.getParams().getString("accountViewID");
            accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accViewId));
            accountDc = accountView.getDC().getValue();
            cc = this.getCurrencyCollection(ctx, (HashSet)cs.getParams().getObject("selectedCurrencyIDSet"), company);
            currencyList = new ArrayList<CurrencyInfo>();
            for (int i7 = 0; i7 < cc.size(); ++i7) {
                currencyList.add(cc.get(i7));
            }
            currencySize = cc.size();
            Object[][] md = (Object[][])cs.getParams().getObject("md");
            debitList = new ArrayList<LabelValueBean>();
            creditList = new ArrayList<LabelValueBean>();
            accountMap = new HashMap();
            IRowSet iRowSet = null;
            accountMap = this.sortAccountMd(ctx, md, fromAccountLevel, isQtyAsst);
            accountMap.put("isAccountUpLevel", new Boolean(isAccountUpLevel));
            iRowSet = (IRowSet)accountMap.get("iRowSet");
            for (int i8 = 0; i8 < md.length; ++i8) {
                String actItemId = md[i8][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)md[i8][1]).getId().toString() : ((LabelValueBean)md[i8][1]).getValue();
                if (BalanceDirectionEnum.DEBIT.equals(md[i8][0])) {
                    debitList.add(new LabelValueBean(actItemId, (String)md[i8][2]));
                    continue;
                }
                creditList.add(new LabelValueBean(actItemId, (String)md[i8][2]));
            }
            itemList = new ArrayList<LabelValueBean>();
            itemList.addAll(debitList);
            itemList.addAll(creditList);
            debitSize = debitList.size();
            int creditSize = creditList.size();
            mcItemSize = itemList.size();
            StringBuffer accountIds = new StringBuffer();
            for (int i9 = 0; i9 < mcItemSize; ++i9) {
                accountIds.append(",'");
                accountIds.append(((LabelValueBean)itemList.get(i9)).getValue().toString());
                accountIds.append("'");
            }
            if (tempTableName != null) {
                this.dropTable(ctx, tempTableName);
            }
            tempTableName = "RptAsstActMultiColumn";
            mcFieldList = new ArrayList<String>();
            sumFileldList = new ArrayList<String>();
            StringBuffer select = new StringBuffer();
            StringBuffer selectSameBiz = new StringBuffer();
            StringBuffer createTempTable = new StringBuffer();
            SqlParams pp = new SqlParams();
            int pi = 1;
            select.append("SELECT 0 no,A.FID voucherId, A.FSourcetype, B.FEntryDC ActDC, F.FID FPeriodID,F.FPeriodYear,F.FPeriodNumber ,A.FBookedDate bizDate, C.FName_").append(loc).append("||'-'||IsNull(A.FNumber,'') voucherTypeName, B.FDescription description,\n");
            selectSameBiz.append("SELECT  no, voucherId, FSourcetype, ActDC,  FPeriodID,FPeriodYear,FPeriodNumber , bizDate, voucherTypeName, max(description)  description,\n");
            createTempTable.append("create table RptAsstActMultiColumn (").append(" no int,").append("voucherId varchar(44),").append(" ActDC int,").append("FPeriodID varchar(44),").append(" FPeriodYear varchar(10),").append("FPeriodNumber varchar(10),").append(" bizDate datetime,").append("voucherTypeName varchar(10),").append("description varchar(255),");
            for (i6 = 0; i6 < currencySize; ++i6) {
                if (displayAmount) {
                    String glField = "DebitMu_" + i6;
                    select.append("'").append(accountMap.get("jdyMu")).append("' ").append(glField).append(",");
                    selectSameBiz.append("'           ' ").append(glField).append(",");
                    sumFileldList.add(glField);
                    glField = "DebitQty_" + i6;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                    glField = "DebitPrice_" + i6;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                }
                String glField = "DebitFor_" + i6;
                select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                sumFileldList.add(glField);
                glField = "DebitLocal_" + i6;
                select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                sumFileldList.add(glField);
            }
            select.append("TO_DECIMAL(0.0,19,4) Debit_Sum,");
            selectSameBiz.append("sum(").append("Debit_Sum").append(") Debit_Sum,");
            sumFileldList.add("Debit_Sum");
            for (i6 = 0; i6 < currencySize; ++i6) {
                if (displayAmount) {
                    String glField = "CreditMu_" + i6;
                    select.append("'").append(accountMap.get("jdyMu")).append("' ").append(glField).append(",");
                    selectSameBiz.append("'           ' ").append(glField).append(",");
                    sumFileldList.add(glField);
                    glField = "CreditQty_" + i6;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                    glField = "CreditPrice_" + i6;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                }
                String glField = "CreditFor_" + i6;
                select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                sumFileldList.add(glField);
                glField = "CreditLocal_" + i6;
                select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                sumFileldList.add(glField);
            }
            select.append("TO_DECIMAL(0.0,19,4) Credit_Sum,");
            selectSameBiz.append("sum(").append("Credit_Sum").append(") Credit_Sum,");
            sumFileldList.add("Credit_Sum");
            if (displayAmount) {
                select.append("'           ' Balance_Mu,");
                selectSameBiz.append("'           ' Balance_Mu,");
                sumFileldList.add("Balance_Mu");
                select.append("TO_DECIMAL(0.0,19,4) Balance_Qty,");
                selectSameBiz.append("sum(").append("Balance_Qty").append(") Balance_Qty,");
                sumFileldList.add("Balance_Qty");
                select.append("TO_DECIMAL(0.0,19,4) Balance_Price,");
                selectSameBiz.append("sum(").append("Balance_Price").append(") Balance_Price,");
                sumFileldList.add("Balance_Price");
            }
            select.append(" case ").append(accountDc).append(" when 1 then ").append("'").append(GLResUtil.getRes("debit", ctx)).append("' else '").append(GLResUtil.getRes("credit", ctx)).append("' end Orginal_DC,");
            selectSameBiz.append("Orginal_DC,");
            sumFileldList.add("Orginal_DC");
            select.append("TO_DECIMAL(0.0,19,4) Balance_Amount,");
            selectSameBiz.append("sum(").append("Balance_Amount").append(") Balance_Amount,");
            sumFileldList.add("Balance_Amount");
            for (int i10 = 0; i10 < itemList.size(); ++i10) {
                for (int j = 0; j < currencyList.size(); ++j) {
                    String glField;
                    currencyId = ((CurrencyInfo)currencyList.get(j)).getId().toString();
                    String accountID = ((LabelValueBean)itemList.get(i10)).getValue();
                    String glCase = new StringBuffer().append("\n case when av.flongnumber like'").append((String)accountMap.get(accountID)).append("%' and B.FCurrencyID='").append(currencyId).append("' ").toString();
                    if (i10 < debitSize) {
                        if (displayAmount) {
                            String glField2 = new StringBuffer().append(" DebitMu_").append(i10).append("_").append(j).toString();
                            mcFieldList.add(glField2);
                            if (isQtyAsst) {
                                select.append(glCase).append(" then '").append((String)accountMap.get(accountID + "_mu") == null ? "           " : (String)accountMap.get(accountID + "_mu")).append("' else null end ").append(glField2).append(",");
                            } else {
                                select.append(glCase).append(" then mu.fname_").append(loc).append(" else null end ").append(glField2).append(",");
                            }
                            selectSameBiz.append("'           ' " + glField2).append(",");
                            glField2 = new StringBuffer().append(" DebitQty_").append(i10).append("_").append(j).toString();
                            mcFieldList.add(glField2);
                            if (isQtyAsst) {
                                if (asstactTypeItemId != null) {
                                    select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then VA.FStandardQuantity else 0-VA.FStandardQuantity end,0) else 0 end ").append(glField2).append(",");
                                } else {
                                    select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then b.FStandardQuantity else 0-b.FStandardQuantity end,0) else 0 end ").append(glField2).append(",");
                                }
                            } else if (asstactTypeItemId != null) {
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then VA.FQuantity else 0-VA.FQuantity end,0) else 0 end ").append(glField2).append(",");
                            } else {
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then b.fquantity else 0-b.fquantity end,0) else 0 end ").append(glField2).append(",");
                            }
                            selectSameBiz.append("sum(").append(glField2).append(") ").append(glField2).append(",");
                            glField2 = new StringBuffer().append(" DebitStdQty_").append(i10).append("_").append(j).toString();
                            if (isQtyAsst) {
                                if (asstactTypeItemId != null) {
                                    select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then VA.FStandardQuantity else 0-VA.FStandardQuantity end,0) else 0 end ").append(glField2).append(",");
                                } else {
                                    select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then b.FStandardQuantity else 0-b.FStandardQuantity end,0) else 0 end ").append(glField2).append(",");
                                }
                            } else if (asstactTypeItemId != null) {
                                select.append(glCase).append(" then  mu.FCoefficient*IsNull(case B.FEntryDC when 1 then VA.FQuantity else 0-VA.FQuantity end,0) else 0 end ").append(glField2).append(",");
                            } else {
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then b.FStandardQuantity else 0-b.FStandardQuantity end,0) else 0 end ").append(glField2).append(",");
                            }
                            selectSameBiz.append("sum(").append(glField2).append(") ").append(glField2).append(",");
                            glField2 = new StringBuffer().append(" DebitPrice_").append(i10).append("_").append(j).toString();
                            mcFieldList.add(glField2);
                            if (asstactTypeItemId != null) {
                                select.append(glCase).append(" then va.fprice else 0 end ").append(glField2).append(",");
                            } else {
                                select.append(glCase).append(" then b.fprice else 0 end ").append(glField2).append(",");
                            }
                            selectSameBiz.append("sum(").append(glField2).append(") ").append(glField2).append(",");
                        }
                        glField = new StringBuffer().append(" DebitFor_").append(i10).append("_").append(j).toString();
                        mcFieldList.add(glField);
                        if (asstactTypeItemId != null) {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then VA.FOriginalAmount else 0-VA.FOriginalAmount end,0) else 0 end ").append(glField).append(",");
                        } else {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then B.FOriginalAmount else 0-B.FOriginalAmount end,0) else 0 end ").append(glField).append(",");
                        }
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        glField = new StringBuffer().append(" DebitLocal_").append(i10).append("_").append(j).toString();
                        mcFieldList.add(glField);
                        if (asstactTypeItemId != null) {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then VA.FLocalAmount else 0-VA.FLocalAmount end,0) else 0 end ").append(glField).append(",");
                        } else {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then B.FLocalAmount else 0-B.FLocalAmount end,0) else 0 end ").append(glField).append(",");
                        }
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        continue;
                    }
                    if (displayAmount) {
                        String glField3 = new StringBuffer().append(" creditMu_").append(i10).append("_").append(j).toString();
                        mcFieldList.add(glField3);
                        if (isQtyAsst) {
                            select.append(glCase).append(" then '").append((String)accountMap.get(accountID + "_mu") == null ? "           " : (String)accountMap.get(accountID + "_mu")).append("' else null end ").append(glField3).append(",");
                        } else {
                            select.append(glCase).append(" then mu.fname_").append(loc).append(" else null end ").append(glField3).append(",");
                        }
                        selectSameBiz.append("'           ' " + glField3).append(",");
                        glField3 = new StringBuffer().append(" creditQty_").append(i10).append("_").append(j).toString();
                        mcFieldList.add(glField3);
                        if (isQtyAsst) {
                            if (asstactTypeItemId != null) {
                                select.append(glCase).append(" then IsNull(case B.FEntryDC when 0 then va.FStandardQuantity  else 0-va.FStandardQuantity end,0) else 0 end ").append(glField3).append(",");
                            } else {
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 0 then b.FStandardQuantity  else 0-b.FStandardQuantity end,0)  else 0 end ").append(glField3).append(",");
                            }
                        } else if (asstactTypeItemId != null) {
                            select.append(glCase).append(" then mu.FCoefficient*IsNull(case B.FEntryDC when 1 then va.FQuantity  else 0-va.FQuantity end,0) else 0 end ").append(glField3).append(",");
                        } else {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then b.fquantity  else 0-b.fquantity end,0) else 0 end ").append(glField3).append(",");
                        }
                        selectSameBiz.append("sum(").append(glField3).append(") ").append(glField3).append(",");
                        glField3 = new StringBuffer().append(" creditStdQty_").append(i10).append("_").append(j).toString();
                        if (isQtyAsst) {
                            if (asstactTypeItemId != null) {
                                select.append(glCase).append(" then IsNull(case B.FEntryDC when 0 then va.FStandardQuantity  else 0-va.FStandardQuantity end,0) else 0 end ").append(glField3).append(",");
                            } else {
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 0 then b.FStandardQuantity  else 0-b.FStandardQuantity end,0)  else 0 end ").append(glField3).append(",");
                            }
                        } else if (asstactTypeItemId != null) {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then va.FStandardQuantity  else 0-va.FStandardQuantity end,0) else 0 end ").append(glField3).append(",");
                        } else {
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then b.FStandardQuantity  else 0-b.FStandardQuantity end,0) else 0 end ").append(glField3).append(",");
                        }
                        selectSameBiz.append("sum(").append(glField3).append(") ").append(glField3).append(",");
                        glField3 = new StringBuffer().append(" creditPrice_").append(i10).append("_").append(j).toString();
                        mcFieldList.add(glField3);
                        if (asstactTypeItemId != null) {
                            select.append(glCase).append(" then va.fprice else 0 end ").append(glField3).append(",");
                        } else {
                            select.append(glCase).append(" then b.fprice else 0 end ").append(glField3).append(",");
                        }
                        selectSameBiz.append("sum(").append(glField3).append(") ").append(glField3).append(",");
                    }
                    glField = new StringBuffer().append(" CreditFor_").append(i10).append("_").append(j).toString();
                    mcFieldList.add(glField);
                    if (asstactTypeItemId != null) {
                        select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then 0-VA.FOriginalAmount else VA.FOriginalAmount end,0) else 0 end ").append(glField).append(",");
                    } else {
                        select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then 0-B.FOriginalAmount else B.FOriginalAmount end,0) else 0 end ").append(glField).append(",");
                    }
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    glField = new StringBuffer().append(" CreditLocal_").append(i10).append("_").append(j).toString();
                    mcFieldList.add(glField);
                    if (asstactTypeItemId != null) {
                        select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then 0-VA.FLocalAmount else VA.FLocalAmount end,0) else 0 end ").append(glField).append(",");
                    } else {
                        select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then 0-B.FLocalAmount else B.FLocalAmount end,0) else 0 end ").append(glField).append(",");
                    }
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                }
            }
            this.delLastChar(select);
            this.delLastChar(selectSameBiz);
            if (!displayOneLineBiz) {
                select.append("\n into ").append(tempTableName);
            } else {
                selectSameBiz.append("\n\n into ").append(tempTableName);
            }
            select.append("\n from t_gl_voucher A  ").append("\n inner join t_gl_voucherentry B on A.fid = B.fbillid ");
            select.append("\n inner join t_bd_accountview av on av.fid = b.faccountid ");
            if (asstactTypeItemId != null) {
                select.append("\n INNER JOIN T_GL_VoucherAssistRecord VA ON A.FID = VA.FBillID and B.FID = VA.FEntryID ").append("\n INNER JOIN  T_BD_AssistantHg HG ON VA.FAssGrpID = HG.FID ");
                if (displayAmount) {
                    select.append("\n left join t_bd_measureunit mu on va.FMeasureUnitID = mu.fid ");
                }
            } else if (displayAmount) {
                select.append("\n left join t_bd_measureunit mu on B.FMeasureUnitID = mu.fid ");
            }
            select.append("\n inner join t_bd_vouchertypes C  on A.fvouchertypeid = C.fid").append("\n inner join t_bd_period F  on A.fperiodid = F.fid").append(null == this.getGovAccountDetailJoinTable(ctx, params) ? "" : this.getGovAccountDetailJoinTable(ctx, params)).append("\n where A.FCompanyId=? and AV.FCompanyId=? and  A.FBizStatus in ").append(balTypes);
            if (asstactTypeItemId != null) {
                select.append("\n and HG.").append(hgFieldName).append(" = '").append(asstactTypeItemId).append("'\n");
            }
            if (includeNoTransPLVoucher) {
                select.append(" and A.FSourcetype <> 1 ");
            }
            select.append(" and F.FTypeID=?").append("\n and ").append(SQLUtil.getPeriodCondition("F.fperiodYear", "F.fperiodNumber", periodRange));
            pp.setString(pi++, companyId);
            pp.setString(pi++, companyId);
            pp.setString(pi++, periodType);
            try {
                iRowSet.beforeFirst();
                StringBuffer tmpStr = new StringBuffer();
                while (iRowSet.next()) {
                    tmpStr.append(" or av.flongnumber like '").append(iRowSet.getString("flongnumber")).append("%'");
                }
                if (tmpStr.toString().indexOf("or") != -1) {
                    select.append("\n and (");
                    select.append(tmpStr.substring(4));
                    select.append(")");
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            select.append("\n and B.FCurrencyID in(");
            for (int i11 = 0; i11 < currencySize; ++i11) {
                ci = (CurrencyInfo)currencyList.get(i11);
                select.append("?,");
                pp.setString(pi++, ci.getId().toString());
            }
            this.delLastChar(select);
            select.append(")");
            select.append(null == this.getGovAccountDetailFilter(ctx, params) ? "" : this.getGovAccountDetailFilter(ctx, params));
            try {
                if (displayOneLineBiz) {
                    selectSameBiz.append(" from (").append(select).append("\n)").append("  tempp ").append("group by no, voucherId,  ActDC, FSourcetype,  FPeriodID,FPeriodYear,FPeriodNumber , bizDate, voucherTypeName,  Orginal_DC ");
                    tempTableName = this.executeSelectInto(selectSameBiz.toString(), pp, ctx).getTempTable();
                } else {
                    tempTableName = this.executeSelectInto(select.toString(), pp, ctx).getTempTable();
                }
            }
            catch (Exception e) {
                if (!(e instanceof BOSException)) break block201;
                if (e.getCause() instanceof SQLException) {
                    if (((SQLException)e.getCause()).getSQLState().equals("S1000") || ((SQLException)e.getCause()).getSQLState().equals("42000")) {
                        throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
                    }
                    throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
                }
                throw (BOSException)((Object)e);
            }
        }
        StringBuffer updateBC = new StringBuffer();
        updateBC.append("update ").append(tempTableName).append(" set ");
        for (int i12 = 0; i12 < currencySize; ++i12) {
            String glField;
            String accountID;
            int j;
            updateBC.append("\nDebitFor_").append(i12).append("=");
            for (j = 0; j < mcItemSize; ++j) {
                accountID = ((LabelValueBean)itemList.get(j)).getValue();
                if (isAccountUpLevel && "true".equals(accountMap.get(accountID + "hasChild"))) continue;
                glField = (j < debitSize ? "DebitFor_" : "CreditFor_") + j + "_" + i12;
                if (j < debitSize) {
                    updateBC.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                    continue;
                }
                updateBC.append("case ActDC when 1 then 0-").append(glField).append(" else 0 end +");
            }
            this.delLastChar(updateBC);
            updateBC.append(",");
            updateBC.append("DebitLocal_").append(i12).append("=");
            for (j = 0; j < mcItemSize; ++j) {
                accountID = ((LabelValueBean)itemList.get(j)).getValue();
                if (isAccountUpLevel && "true".equals(accountMap.get(accountID + "hasChild"))) continue;
                glField = (j < debitSize ? "DebitLocal_" : "CreditLocal_") + j + "_" + i12;
                if (j < debitSize) {
                    updateBC.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                    continue;
                }
                updateBC.append("case ActDC when 1 then 0-").append(glField).append(" else 0 end +");
            }
            this.delLastChar(updateBC);
            updateBC.append(",");
            updateBC.append("CreditFor_").append(i12).append("=");
            for (j = 0; j < mcItemSize; ++j) {
                accountID = ((LabelValueBean)itemList.get(j)).getValue();
                if (isAccountUpLevel && "true".equals(accountMap.get(accountID + "hasChild"))) continue;
                glField = (j < debitSize ? "DebitFor_" : "CreditFor_") + j + "_" + i12;
                if (j < debitSize) {
                    updateBC.append("case ActDC when 1 then 0 else 0-").append(glField).append(" end +");
                    continue;
                }
                updateBC.append("case ActDC when 1 then 0 else ").append(glField).append(" end +");
            }
            this.delLastChar(updateBC);
            updateBC.append(",");
            updateBC.append("CreditLocal_").append(i12).append("=");
            for (j = 0; j < mcItemSize; ++j) {
                accountID = ((LabelValueBean)itemList.get(j)).getValue();
                if (isAccountUpLevel && "true".equals(accountMap.get(accountID + "hasChild"))) continue;
                glField = (j < debitSize ? "DebitLocal_" : "CreditLocal_") + j + "_" + i12;
                if (j < debitSize) {
                    updateBC.append("case ActDC when 1 then 0 else 0-").append(glField).append(" end +");
                    continue;
                }
                updateBC.append("case ActDC when 1 then 0 else ").append(glField).append(" end +");
            }
            this.delLastChar(updateBC);
            if (displayAmount) {
                updateBC.append(",");
                updateBC.append("DebitQty_").append(i12).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    accountID = ((LabelValueBean)itemList.get(j)).getValue();
                    if (isAccountUpLevel && "true".equals(accountMap.get(accountID + "hasChild"))) continue;
                    glField = (j < debitSize ? "DebitStdQty_" : "CreditStdQty_") + j + "_" + i12;
                    if (j < debitSize) {
                        updateBC.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                        continue;
                    }
                    updateBC.append("case ActDC when 1 then 0-").append(glField).append(" else 0 end +");
                }
                this.delLastChar(updateBC);
                updateBC.append(",");
                updateBC.append("CreditQty_").append(i12).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    accountID = ((LabelValueBean)itemList.get(j)).getValue();
                    if (isAccountUpLevel && "true".equals(accountMap.get(accountID + "hasChild"))) continue;
                    glField = (j < debitSize ? "DebitStdQty_" : "CreditStdQty_") + j + "_" + i12;
                    if (j < debitSize) {
                        updateBC.append("case ActDC when 1 then 0 else 0-").append(glField).append(" end +");
                        continue;
                    }
                    updateBC.append("case ActDC when 1 then 0 else ").append(glField).append(" end +");
                }
                this.delLastChar(updateBC);
            }
            updateBC.append(",");
        }
        this.delLastChar(updateBC);
        updateBC.append("\n where no=0");
        this.executeUpdate(updateBC.toString(), null, ctx);
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql1Year = new StringBuffer();
        StringBuffer sql1YearCredit = new StringBuffer();
        SqlParams sp1 = new SqlParams();
        StringBuffer balanceAmount = new StringBuffer(accountDc + "*sum(");
        StringBuffer balanceQty = new StringBuffer("sum(");
        StringBuffer debitQtySum = new StringBuffer("sum(");
        StringBuffer creditQtySum = new StringBuffer("sum(");
        StringBuffer debitSum = new StringBuffer("sum(");
        StringBuffer creditSum = new StringBuffer("sum(");
        int pi1 = 1;
        ArrayList<String> qcFieldList = new ArrayList<String>();
        sql1.append("select -1 no," + accountDc + " ActDC, P.FID FPeriodID, P.FPeriodYear, P.FPeriodNumber, P.FBeginDate BizDate, '" + GLResUtil.getRes("balance_period_begin", ctx) + "' Description, ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("insert into ").append(tempTableName).append("(no,ActDC,FPeriodID,FPeriodYear,FPeriodNumber,BizDate,Description,");
        qcFieldList.addAll(Arrays.asList("no,ActDC,FPeriodID,FPeriodYear,FPeriodNumber,BizDate,Description".split(",")));
        for (int i13 = 0; i13 < currencySize; ++i13) {
            currencyId = ((CurrencyInfo)currencyList.get(i13)).getId().toString();
            String glCase = " case when GL.FCurrencyId='" + currencyId + "' then ";
            if (displayAmount) {
                sql1.append("\n '").append(accountMap.get("jdyMu")).append("' DebitMu_").append(i13).append(",");
                sql1.append("\nsum(").append(glCase).append("GL.FYearDebitQty - GL.FDebitQty").append(" else 0 end) DebitQty_").append(i13).append(",");
            }
            sql1.append("\nsum(").append(glCase).append(this.getSubcol(true, "Debit", "For")).append(" else 0 end) DebitFor_").append(i13).append(",");
            sql1.append("\nsum(").append(glCase).append(this.getSubcol(true, "Debit", "Local")).append("  else 0 end) DebitLocal_").append(i13).append(",");
            if (displayAmount) {
                sql1.append("\n '").append(accountMap.get("jdyMu")).append("' CreditMu_").append(i13).append(",");
                sql1.append("\nsum(").append(glCase).append("GL.FYearCreditQty - GL.FCreditQty").append(" else 0 end) CreditQty_").append(i13).append(",");
            }
            sql1.append("\nsum(").append(glCase).append(this.getSubcol(true, "Credit", "For")).append("  else 0 end) CreditFor_").append(i13).append(",");
            sql1.append("\nsum(").append(glCase).append(this.getSubcol(true, "Credit", "Local")).append(" else 0 end) CreditLocal_").append(i13).append(",");
            if (displayAmount) {
                qcFieldList.add("DebitMu_" + i13);
                qcFieldList.add("DebitQty_" + i13);
            }
            qcFieldList.add("DebitFor_" + i13);
            qcFieldList.add("DebitLocal_" + i13);
            if (displayAmount) {
                qcFieldList.add("CreditMu_" + i13);
                qcFieldList.add("CreditQty_" + i13);
            }
            qcFieldList.add("CreditFor_" + i13);
            qcFieldList.add("CreditLocal_" + i13);
            if (displayAmount) {
                sql2.append("DebitMu_" + i13).append(",");
                sql2.append("DebitQty_" + i13).append(",");
            }
            sql2.append("DebitFor_" + i13).append(",DebitLocal_" + i13);
            if (displayAmount) {
                sql2.append(",CreditMu_" + i13);
                sql2.append(",CreditQty_" + i13);
            }
            sql2.append(",CreditFor_" + i13).append(",CreditLocal_" + i13).append(',');
        }
        sql1Year.append(sql1);
        sql1YearCredit.append(sql1);
        boolean _includeNoTransPLVoucher = false;
        for (int i14 = 0; i14 < mcItemSize; ++i14) {
            accountItemId = ((LabelValueBean)itemList.get(i14)).getValue().toString();
            for (int j = 0; j < currencyList.size(); ++j) {
                currencyId = ((CurrencyInfo)currencyList.get(j)).getId().toString();
                String glCase = new StringBuffer().append("case when PC.FID='").append(accountItemId).append("' and GL.FCurrencyID='").append(currencyId).append("' ").toString();
                if (i14 < debitSize) {
                    if (displayAmount) {
                        sql1Year.append("  '").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("'  ").append(" DebitMu_").append(i14).append("_").append(j).append(",");
                        sql1Year.append("\nsum(").append(glCase).append(" then (").append("GL.FYearDebitQty - GL.FDebitQty ").append(") else 0 end)").append(" DebitQty_").append(i14).append("_").append(j).append(",");
                    }
                    sql1Year.append("\nsum(").append(glCase).append(" then (").append(this.getSubcol(_includeNoTransPLVoucher, "Debit", "For")).append(") else 0 end)").append(" DebitFor_").append(i14).append("_").append(j).append(",");
                    sql1Year.append("\nsum(").append(glCase).append(" then (").append(this.getSubcol(_includeNoTransPLVoucher, "Debit", "Local")).append(") else 0 end)").append(" DebitLocal_").append(i14).append("_").append(j).append(",");
                    if (displayAmount) {
                        sql1YearCredit.append("  '").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("'  CreditMu_").append(i14).append("_").append(j).append(",");
                        sql1YearCredit.append("\nsum(").append(glCase).append(" then (").append("GL.FYearCreditQty - GL.FCreditQty ").append(") else 0 end)").append(" CreditQty_").append(i14).append("_").append(j).append(",");
                    }
                    sql1YearCredit.append("\nsum(").append(glCase).append(" then (").append(this.getSubcol(_includeNoTransPLVoucher, "Credit", "For")).append(") else 0 end)").append(" CreditFor_").append(i14).append("_").append(j).append(",");
                    sql1YearCredit.append("\nsum(").append(glCase).append(" then (").append(this.getSubcol(_includeNoTransPLVoucher, "Credit", "Local")).append(") else 0 end)").append(" CreditLocal_").append(i14).append("_").append(j).append(",");
                    if (displayAmount) {
                        sql1.append("  '").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("' ").append(" BalanceMu_").append(i14).append("_").append(j).append(",");
                        sql1.append("\nsum(").append(glCase).append(" then (").append("GL.FBeginQty").append(") else 0 end)").append(" BalanceQty_").append(i14).append('_').append(j).append(',');
                    }
                    sql1.append("\nsum(").append(glCase).append(" then (").append(this.getSubbegincol(includeNoTransPLVoucher, "For")).append(") else 0 end)").append(" BalanceFor_").append(i14).append('_').append(j).append(',');
                    sql1.append("\nsum(").append(glCase).append(" then (").append(this.getSubbegincol(includeNoTransPLVoucher, "Local")).append(") else 0 end)").append(" BalanceLocal_").append(i14).append('_').append(j).append(',');
                    if (displayAmount) {
                        sql2.append(" DebitMu_").append(i14).append('_').append(j).append(',');
                        sql2.append(" DebitQty_").append(i14).append('_').append(j).append(',');
                    }
                    sql2.append(" DebitFor_").append(i14).append('_').append(j).append(',');
                    sql2.append(" DebitLocal_").append(i14).append('_').append(j).append(',');
                } else {
                    if (displayAmount) {
                        sql1Year.append("  '").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("'  DebitMu_").append(i14).append("_").append(j).append(",");
                        sql1Year.append("\nsum(").append(glCase).append(" then -1*(").append("GL.FYearDebitQty - GL.FDebitQty ").append(") else 0 end)").append(" DebitQty_").append(i14).append("_").append(j).append(",");
                    }
                    sql1Year.append("\nsum(").append(glCase).append(" then -1*(").append(this.getSubcol(_includeNoTransPLVoucher, "Debit", "For")).append(") else 0 end)").append(" DebitFor_").append(i14).append("_").append(j).append(",");
                    sql1Year.append("\nsum(").append(glCase).append(" then -1*(").append(this.getSubcol(_includeNoTransPLVoucher, "Debit", "Local")).append(") else 0 end)").append(" DebitLocal_").append(i14).append("_").append(j).append(",");
                    if (displayAmount) {
                        sql1YearCredit.append("  '").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("'  ").append(" CreditMu_").append(i14).append("_").append(j).append(",");
                        sql1YearCredit.append("\nsum(").append(glCase).append(" then -1*(").append("GL.FYearCreditQty - GL.FCreditQty ").append(") else 0 end)").append(" CreditQty_").append(i14).append("_").append(j).append(",");
                    }
                    sql1YearCredit.append("\nsum(").append(glCase).append(" then -1*(").append(this.getSubcol(_includeNoTransPLVoucher, "Credit", "For")).append(") else 0 end)").append(" CreditFor_").append(i14).append("_").append(j).append(",");
                    sql1YearCredit.append("\nsum(").append(glCase).append(" then -1*(").append(this.getSubcol(_includeNoTransPLVoucher, "Credit", "Local")).append(") else 0 end)").append(" CreditLocal_").append(i14).append("_").append(j).append(",");
                    if (displayAmount) {
                        sql1.append("  '").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("'  ").append(" BalanceMu_").append(i14).append("_").append(j).append(",");
                        sql1.append("\nsum(").append(glCase).append(" then -1*(").append("GL.FBeginQty").append(") else 0 end)").append(" BalanceQty_").append(i14).append('_').append(j).append(',');
                    }
                    sql1.append("\nsum(").append(glCase).append(" then -1*(").append(this.getSubbegincol(includeNoTransPLVoucher, "For")).append(") else 0 end)").append(" BalanceFor_").append(i14).append('_').append(j).append(',');
                    sql1.append("\nsum(").append(glCase).append(" then -1*(").append(this.getSubbegincol(includeNoTransPLVoucher, "Local")).append(") else 0 end)").append(" BalanceLocal_").append(i14).append('_').append(j).append(',');
                    if (displayAmount) {
                        sql2.append(" CreditMu_").append(i14).append('_').append(j).append(',');
                        sql2.append(" CreditQty_").append(i14).append('_').append(j).append(',');
                    }
                    sql2.append(" CreditFor_").append(i14).append('_').append(j).append(',');
                    sql2.append(" CreditLocal_").append(i14).append('_').append(j).append(',');
                }
                if (displayAmount) {
                    qcFieldList.add("BalanceMu_" + i14 + "_" + j);
                    qcFieldList.add("BalanceQty_" + i14 + "_" + j);
                }
                qcFieldList.add("BalanceFor_" + i14 + "_" + j);
                qcFieldList.add("BalanceLocal_" + i14 + "_" + j);
                if (isAccountUpLevel && "true".equals(accountMap.get(accountItemId + "hasChild"))) continue;
                balanceAmount.append('\n').append(glCase).append(" then GL.FbeginbalanceLocal else 0 end +");
                debitSum.append('\n').append(glCase).append(" then (case when C.FDC=1 then GL.FbeginbalanceLocal else 0 end) else 0 end +");
                creditSum.append('\n').append(glCase).append(" then (case when C.FDC=1 then 0 else GL.FbeginbalanceLocal end) else 0 end +");
                if (!displayAmount) continue;
                balanceQty.append('\n').append(glCase).append(" then GL.Fbeginqty else 0 end +");
                debitQtySum.append('\n').append(glCase).append(" then (case when C.FDC=1 then GL.Fbeginqty else 0 end) else 0 end +");
                creditQtySum.append('\n').append(glCase).append(" then (case when C.FDC=1 then 0 else GL.Fbeginqty end) else 0 end +");
            }
        }
        if (displayAmount) {
            this.delLastChar(balanceQty);
            sql1.append("\n").append(balanceQty).append(") Balance_Qty,");
            qcFieldList.add("Balance_Qty");
            sql2.append("Balance_Qty,");
        }
        this.delLastChar(balanceAmount);
        this.delLastChar(sql1YearCredit);
        sql1.append("\n").append(balanceAmount).append(") Balance_Amount,");
        sql1Year.append("\n").append(balanceAmount).append(") Balance_Amount,");
        this.delLastChar(debitSum);
        sql1.append("\n").append(debitSum).append(") Debit_Sum,");
        sql1Year.append("\n").append(debitSum).append(") Debit_Sum,");
        this.delLastChar(creditSum);
        sql1.append("\n").append(creditSum).append(") Credit_Sum ");
        sql1Year.append("\n").append(creditSum).append(") Credit_Sum ");
        qcFieldList.add("Balance_Amount");
        qcFieldList.add("Debit_Sum");
        qcFieldList.add("Credit_Sum");
        sql2.append("Balance_Amount,Debit_Sum,Credit_Sum)");
        StringBuffer sql1FromWhere = new StringBuffer();
        if (asstactTypeItemId != null) {
            sql1FromWhere.append("\nfrom  T_BD_Period P ").append("\ninner join " + this.getAssistBalanceTable(ctx, includeNoTransPLVoucher) + " GL ON GL.FPeriodID = P.FID ").append("\r\ninner join T_BD_AssistantHG HG on GL.FAssistGrpID=HG.FID and HG.").append(hgFieldName).append(" = '").append(asstactTypeItemId).append("'\n").append("\ninner join T_BD_AccountView C ON C.FID = GL.FAccountID and C.FCompanyID=GL.FOrgUnitID").append(" and GL.FBalType = ? and GL.FOrgUnitID=?");
            sp1.setInt(pi1++, balType);
            sp1.setString(pi1++, companyId);
            sql1FromWhere.append("\r\n inner join T_BD_AccountView PC on (charindex(pc.flongnumber||'!',c.flongnumber)=1 or pc.flongnumber=c.flongnumber) \r\n");
            sql1FromWhere.append(" inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid");
            sql1FromWhere.append(" inner join t_bd_systemstatusctrol b on gl.forgunitid=b.fcompanyid");
            sql1FromWhere.append(" inner join t_bd_systemstatus d on d.fid=b.fsystemstatusid");
            sql1FromWhere.append(" \n where d.fname=6 and P.FTypeID=?").append("\n and P.FPeriodYear=").append(periodRange[0]).append(" and P.FPeriodNumber=").append(periodRange[1]);
            sp1.setString(pi1++, periodType);
            sql1FromWhere.append("\n and PC.FID in(");
            for (i5 = 0; i5 < mcItemSize; ++i5) {
                sql1FromWhere.append("?,");
                sp1.setString(pi1++, ((LabelValueBean)itemList.get(i5)).getValue().toString());
            }
            this.delLastChar(sql1FromWhere);
            sql1FromWhere.append(")\n and GL.FCurrencyID in(");
            for (i5 = 0; i5 < currencySize; ++i5) {
                ci = (CurrencyInfo)currencyList.get(i5);
                sql1FromWhere.append("?,");
                sp1.setString(pi1++, ci.getId().toString());
            }
            this.delLastChar(sql1FromWhere);
            sql1FromWhere.append(") \r\n");
            sql1FromWhere.append("GROUP BY P.FID,P.FBeginDate,P.FPeriodYear,P.FPeriodNumber");
        } else {
            sql1FromWhere.append("\nfrom  T_BD_Period P ").append("\ninner join " + this.getAccountBalanceTable(ctx, false) + " GL ON GL.FPeriodID = P.FID ").append("\ninner join T_BD_AccountView C ON C.FID = GL.FAccountID and C.FCompanyID=GL.FOrgUnitID").append(" and GL.FBalType = ? and GL.FOrgUnitID=?");
            sp1.setInt(pi1++, balType);
            sp1.setString(pi1++, companyId);
            sql1FromWhere.append("\r\n inner join T_BD_AccountView PC on c.fid=pc.fid \r\n");
            sql1FromWhere.append(" inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid");
            sql1FromWhere.append(" inner join t_bd_systemstatusctrol b on gl.forgunitid=b.fcompanyid");
            sql1FromWhere.append(" inner join t_bd_systemstatus d on d.fid=b.fsystemstatusid");
            sql1FromWhere.append("\n where d.fname=6 and P.FTypeID=?").append("\n and P.FPeriodYear=").append(periodRange[0]).append(" and P.FPeriodNumber=").append(periodRange[1]);
            sp1.setString(pi1++, periodType);
            sql1FromWhere.append("\n and GL.FAccountID in(");
            for (i5 = 0; i5 < mcItemSize; ++i5) {
                sql1FromWhere.append("?,");
                sp1.setString(pi1++, ((LabelValueBean)itemList.get(i5)).getValue().toString());
            }
            this.delLastChar(sql1FromWhere);
            sql1FromWhere.append(")\n and GL.FCurrencyID in(");
            for (i5 = 0; i5 < currencySize; ++i5) {
                ci = (CurrencyInfo)currencyList.get(i5);
                sql1FromWhere.append("?,");
                sp1.setString(pi1++, ci.getId().toString());
            }
            this.delLastChar(sql1FromWhere);
            sql1FromWhere.append(") \r\n");
            sql1FromWhere.append("\n GROUP BY P.FID,P.FBeginDate,P.FPeriodYear,P.FPeriodNumber");
        }
        sql1.append(sql1FromWhere);
        sql1Year.append(sql1FromWhere);
        sql1YearCredit.append(sql1FromWhere);
        RptRowSet qcRst = null;
        RptRowSet qcRstYear = null;
        RptRowSet qcRstYearCredit = null;
        try {
            qcRst = this.executeQuery(sql1.toString(), sp1, ctx);
            qcRstYear = this.executeQuery(sql1Year.toString(), sp1, ctx);
            qcRstYearCredit = this.executeQuery(sql1YearCredit.toString(), sp1, ctx);
        }
        catch (SQLDataException e) {
            throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
        }
        if (qcRst.next()) {
            SqlParams sp2 = new SqlParams();
            int pi2 = 1;
            sql2.append("\nvalues(");
            int n2 = qcFieldList.size();
            for (i4 = 0; i4 < n2; ++i4) {
                sql2.append("?,");
                sp2.setObject(pi2++, qcRst.getObject((String)qcFieldList.get(i4)));
            }
            this.delLastChar(sql2);
            sql2.append(")");
            this.executeUpdate(sql2.toString(), sp2, ctx);
        } else {
            sql2.setLength(0);
            sql2.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, BizDate, Description)").append("\n select -1," + accountDc + ", P.FID,P.FPeriodYear,P.FPeriodNumber, P.FBeginDate,'" + GLResUtil.getRes("balance_period_begin", ctx) + "' from T_BD_Period P").append("\n where P.FPeriodYear=").append(periodRange[0]).append(" and P.FPeriodNumber=").append(periodRange[1]).append(" and P.FTypeID='").append(periodType).append("'");
            this.executeUpdate(sql2.toString(), null, ctx);
            zeros = new Object[qcRst.getColumnCount()];
            Arrays.fill(zeros, RptConstant.ZERO);
            qcRst.addRow(zeros);
            qcRst.reset();
            qcRst.next();
        }
        if (!qcRstYear.next()) {
            zeros = new Object[qcRstYear.getColumnCount()];
            Arrays.fill(zeros, RptConstant.ZERO);
            qcRstYear.addRow(zeros);
            qcRstYear.reset();
            qcRstYear.next();
        }
        if (!qcRstYearCredit.next()) {
            zeros = new Object[qcRstYearCredit.getColumnCount()];
            Arrays.fill(zeros, RptConstant.ZERO);
            qcRstYearCredit.addRow(zeros);
            qcRstYearCredit.reset();
            qcRstYearCredit.next();
        }
        StringBuffer sql3 = new StringBuffer();
        sql3.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, bizDate,description, ");
        int n3 = mcFieldList.size();
        for (i3 = 0; i3 < n3; ++i3) {
            sql3.append(mcFieldList.get(i3)).append(",");
        }
        for (i3 = 0; i3 < currencySize; ++i3) {
            if (displayAmount) {
                sql3.append("DebitMu_").append(i3).append(",");
                sql3.append("DebitQty_").append(i3).append(",");
            }
            sql3.append("DebitFor_").append(i3).append(",");
            sql3.append("DebitLocal_").append(i3).append(",");
            if (displayAmount) {
                sql3.append("CreditMu_").append(i3).append(",");
                sql3.append("CreditQty_").append(i3).append(",");
            }
            sql3.append("CreditFor_").append(i3).append(",");
            sql3.append("CreditLocal_").append(i3).append(",");
        }
        sql3.append("Debit_Sum,Credit_Sum,");
        this.delLastChar(sql3);
        sql3.append(") \n select 1," + accountDc + ", P.FID,P.FPeriodYear,P.FPeriodNumber, P.FEndDate, '" + GLResUtil.getRes("period_total", ctx) + "', ");
        n3 = mcFieldList.size();
        for (i3 = 0; i3 < n3; ++i3) {
            if (!mcFieldList.get(i3).toString().startsWith(" creditMu_") && !mcFieldList.get(i3).toString().startsWith(" DebitMu_")) {
                String sss = mcFieldList.get(i3).toString();
                if (sss.startsWith(" DebitQty")) {
                    sss = sss.replaceAll(" DebitQty", " DebitStdQty");
                }
                if (sss.startsWith(" creditQty")) {
                    sss = sss.replaceAll(" creditQty", " CreditStdQty");
                }
                sql3.append("sum(case when fsourcetype=1 then 0 else ").append(sss).append(" end),");
                continue;
            }
            accountItemId = ((LabelValueBean)itemList.get(i3 / (5 * currencySize))).getValue().toString();
            sql3.append("'").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("',");
        }
        for (i3 = 0; i3 < currencySize; ++i3) {
            if (displayAmount) {
                sql3.append("\n '").append(accountMap.get("jdyMu")).append("' ,");
                sql3.append("sum(IsNull(DebitQty_").append(i3).append(",0)),");
            }
            sql3.append("sum(IsNull(DebitFor_").append(i3).append(",0)),");
            sql3.append("sum(IsNull(DebitLocal_").append(i3).append(",0)),");
            if (displayAmount) {
                sql3.append("\n '").append(accountMap.get("jdyMu")).append("' ,");
                sql3.append("sum(IsNull(CreditQty_").append(i3).append(",0)),");
            }
            sql3.append("sum(IsNull(CreditFor_").append(i3).append(",0)),");
            sql3.append("sum(IsNull(CreditLocal_").append(i3).append(",0)),");
        }
        sql3.append("sum(IsNull(Debit_Sum,0)),");
        sql3.append("sum(IsNull(Credit_Sum,0)),");
        this.delLastChar(sql3);
        sql3.append(" \n from T_BD_Period P \n left join ").append(tempTableName).append(" TEMP on P.FID=TEMP.FPeriodID  and TEMP.no=0").append("\n where  P.FTypeID='").append(periodType).append("'").append("\n and ").append(SQLUtil.getPeriodCondition("P.fperiodYear", "P.fperiodNumber", periodRange)).append("\n group by P.FID,P.FPeriodYear,P.FPeriodNumber, P.FEndDate");
        try {
            this.executeUpdate(sql3.toString(), null, ctx);
        }
        catch (Exception e) {
            if (e instanceof BOSException && e.getCause() instanceof SQLException) {
                throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
            }
            throw (BOSException)((Object)e);
        }
        StringBuffer sql4 = new StringBuffer();
        sql4.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, bizDate,description, ");
        for (i4 = 0; i4 < mcItemSize; ++i4) {
            for (int j = 0; j < currencySize; ++j) {
                String glField;
                if (displayAmount) {
                    glField = new StringBuffer().append(i4 < debitSize ? " DebitMu_" : " CreditMu_").append(i4).append("_").append(j).toString();
                    sql4.append(glField).append(",");
                    glField = new StringBuffer().append(i4 < debitSize ? " DebitQty_" : " CreditQty_").append(i4).append("_").append(j).toString();
                    sql4.append(glField).append(",");
                }
                glField = new StringBuffer().append(i4 < debitSize ? " DebitFor_" : " CreditFor_").append(i4).append("_").append(j).toString();
                sql4.append(glField).append(",");
                glField = new StringBuffer().append(i4 < debitSize ? " DebitLocal_" : " CreditLocal_").append(i4).append("_").append(j).toString();
                sql4.append(glField).append(",");
            }
        }
        for (i4 = 0; i4 < currencySize; ++i4) {
            if (displayAmount) {
                sql4.append("DebitMu_").append(i4).append(",");
                sql4.append("DebitQty_").append(i4).append(",");
            }
            sql4.append("DebitFor_").append(i4).append(",");
            sql4.append("DebitLocal_").append(i4).append(",");
            if (displayAmount) {
                sql4.append("CreditMu_").append(i4).append(",");
                sql4.append("CreditQty_").append(i4).append(",");
            }
            sql4.append("CreditFor_").append(i4).append(",");
            sql4.append("CreditLocal_").append(i4).append(",");
        }
        sql4.append("Debit_Sum,Credit_Sum,");
        this.delLastChar(sql4);
        sql4.append(") \n select 2," + accountDc + ", GL1.FPeriodID,GL1.FPeriodYear,GL1.FPeriodNumber, GL1.BizDate, '" + GLResUtil.getRes("sum_year", ctx) + "', ");
        for (i4 = 0; i4 < mcItemSize; ++i4) {
            boolean isDebit = i4 < debitSize;
            for (int j = 0; j < currencySize; ++j) {
                String glField;
                if (isDebit) {
                    if (displayAmount) {
                        accountItemId = ((LabelValueBean)itemList.get(i4)).getValue().toString();
                        sql4.append("'").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("',");
                        glField = "(case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitQty_" + i4 + "_" + j)) + ",19,4),0)-IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYearCredit.getBigDecimal("CreditQty_" + i4 + "_" + j)) + ",19,4),0) else 0 end)";
                        sql4.append(glField).append("+sum(IsNull(GL2.DebitQty_").append(i4).append("_").append(j).append(",0)),");
                    }
                    glField = "(case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitFor_" + i4 + "_" + j)) + ",19,4),0)-IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYearCredit.getBigDecimal("CreditFor_" + i4 + "_" + j)) + ",19,4),0) else 0 end)";
                    sql4.append(glField).append("+sum(IsNull(GL2.DebitFor_").append(i4).append("_").append(j).append(",0)),");
                    glField = "(case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitLocal_" + i4 + "_" + j)) + ",19,4),0)-IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYearCredit.getBigDecimal("CreditLocal_" + i4 + "_" + j)) + ",19,4),0) else 0 end)";
                    sql4.append(glField).append("+sum(IsNull(GL2.DebitLocal_").append(i4).append("_").append(j).append(",0)),");
                    continue;
                }
                if (displayAmount) {
                    accountItemId = ((LabelValueBean)itemList.get(i4)).getValue().toString();
                    sql4.append("'").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("',");
                    glField = "(case when GL1.FPeriodYear=" + periodRange[0] + " then -1*(IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYearCredit.getBigDecimal("CreditQty_" + i4 + "_" + j)) + ",19,4),0)-IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitQty_" + i4 + "_" + j)) + ",19,4),0)) else 0 end)";
                    sql4.append(glField).append("+sum(IsNull(GL2.CreditQty_").append(i4).append("_").append(j).append(",0)),");
                }
                glField = "(case when GL1.FPeriodYear=" + periodRange[0] + " then -1*(IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYearCredit.getBigDecimal("CreditFor_" + i4 + "_" + j)) + ",19,4),0)-IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitFor_" + i4 + "_" + j)) + ",19,4),0)) else 0 end)";
                sql4.append(glField).append("+sum(IsNull(GL2.CreditFor_").append(i4).append("_").append(j).append(",0)),");
                glField = "(case when GL1.FPeriodYear=" + periodRange[0] + " then -1*(IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYearCredit.getBigDecimal("CreditLocal_" + i4 + "_" + j)) + ",19,4),0)-IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitLocal_" + i4 + "_" + j)) + ",19,4),0)) else 0 end)";
                sql4.append(glField).append("+sum(IsNull(GL2.CreditLocal_").append(i4).append("_").append(j).append(",0)),");
            }
        }
        for (i4 = 0; i4 < currencySize; ++i4) {
            String glField;
            if (displayAmount) {
                sql4.append("\n '").append(accountMap.get("jdyMu")).append("' ,");
                glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitQty_" + i4)) + ",19,4),0) else 0 end,";
                sql4.append("\nsum(IsNull(GL2.DebitQty_").append(i4).append(",0))").append(glField);
            }
            glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitFor_" + i4)) + ",19,4),0) else 0 end,";
            sql4.append("\nsum(IsNull(GL2.DebitFor_").append(i4).append(",0))").append(glField);
            glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("DebitLocal_" + i4)) + ",19,4),0) else 0 end,";
            sql4.append("\nsum(IsNull(GL2.DebitLocal_").append(i4).append(",0))").append(glField);
            if (displayAmount) {
                sql4.append("\n '").append(accountMap.get("jdyMu")).append("' ,");
                glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("Creditqty_" + i4)) + ",19,4),0) else 0 end,";
                sql4.append("\nsum(IsNull(GL2.Creditqty_").append(i4).append(",0))").append(glField);
            }
            glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("CreditFor_" + i4)) + ",19,4),0) else 0 end,";
            sql4.append("\nsum(IsNull(GL2.CreditFor_").append(i4).append(",0))").append(glField);
            glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("CreditLocal_" + i4)) + ",19,4),0) else 0 end,";
            sql4.append("\nsum(IsNull(GL2.CreditLocal_").append(i4).append(",0))").append(glField);
        }
        String glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("Debit_Sum")) + ",19,4),0) else 0 end,";
        sql4.append("\nsum(IsNull(GL2.Debit_Sum,0))").append(glField);
        glField = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(qcRstYear.getBigDecimal("Credit_Sum")) + ",19,4),0) else 0 end,";
        sql4.append("\nsum(IsNull(GL2.Credit_Sum,0))").append(glField);
        this.delLastChar(sql4);
        sql4.append(" \nfrom ").append(tempTableName).append(" GL1 \ninner join ").append(tempTableName).append(" GL2 on GL1.FPeriodYear=GL2.FPeriodYear and GL1.no=GL2.no and GL1.no=1 ").append("\n where  GL2.FPeriodNumber<=GL1.FPeriodNumber ").append("\n group by  GL1.FPeriodID,GL1.FPeriodYear,GL1.FPeriodNumber, GL1.BizDate");
        this.executeUpdate(sql4.toString(), null, ctx);
        if (displayEndBalance) {
            StringBuffer sqleb = new StringBuffer();
            sqleb.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, bizDate,description, ");
            int n4 = mcFieldList.size();
            for (int i15 = 0; i15 < n4; ++i15) {
                sqleb.append(mcFieldList.get(i15)).append(",");
            }
            sqleb.append("Debit_Sum,Credit_Sum,");
            this.delLastChar(sqleb);
            String endRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"487_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale());
            sqleb.append(") \n select 3," + accountDc + ", '',GL1.FPeriodYear,GL1.FPeriodNumber, GL1.BizDate, '" + endRes + "', ");
            n = mcFieldList.size();
            for (i2 = 0; i2 < n; ++i2) {
                if (!mcFieldList.get(i2).toString().startsWith(" creditMu_") && !mcFieldList.get(i2).toString().startsWith(" DebitMu_")) {
                    sqleb.append("IsNull(GL1.").append(mcFieldList.get(i2)).append(",0) +\u3000IsNull(GL2.").append(mcFieldList.get(i2)).append(",0),\r\n");
                    continue;
                }
                accountItemId = ((LabelValueBean)itemList.get(i2 / (5 * currencySize))).getValue().toString();
                sqleb.append("'").append((String)accountMap.get(accountItemId + "_mu") == null ? "" : (String)accountMap.get(accountItemId + "_mu")).append("',");
            }
            sqleb.append("IsNull(GL1.Debit_Sum,0)+IsNull(GL2.Debit_Sum,0),\r\n");
            sqleb.append("IsNull(GL1.Credit_Sum,0)+IsNull(GL2.Credit_Sum,0)\r\n");
            sqleb.append("from \r\n(select max(GL11.BizDate) BizDate,");
            sqleb.append("GL11.FPeriodYear,GL11.FPeriodNumber,\r\n");
            n = mcFieldList.size();
            for (i2 = 0; i2 < n; ++i2) {
                if (mcFieldList.get(i2).toString().startsWith(" creditMu_") || mcFieldList.get(i2).toString().startsWith(" DebitMu_")) continue;
                sqleb.append("sum(IsNull(GL22.").append(mcFieldList.get(i2)).append(",0)) ").append(mcFieldList.get(i2)).append(",");
            }
            sqleb.append("sum(IsNull(GL22.Debit_Sum,0)) Debit_Sum,");
            sqleb.append("sum(IsNull(GL22.Credit_Sum,0)) Credit_Sum,");
            this.delLastChar(sqleb);
            sqleb.append(" \n from ").append(tempTableName).append(" GL11 \ninner join ").append(tempTableName).append(" GL22 on 1=1 ").append("\n where  GL11.no=1 and GL22.no=0 and GL22.fperiodyear*100+ GL22.FPeriodNumber<= GL11.fperiodyear*100+GL11.FPeriodNumber  ").append("\n group by  GL11.FPeriodID  ,GL11.FPeriodYear,GL11.FPeriodNumber");
            sqleb.append(") GL1 \r\n").append(" inner join ").append(tempTableName).append(" GL2 on 1=1 ").append(" \r\nwhere GL2.no = -1");
            this.executeUpdate(sqleb.toString(), null, ctx);
        }
        StringBuffer updateBCSum = new StringBuffer();
        updateBCSum.append("update ").append(tempTableName);
        updateBCSum.append(" set Debit_Sum=");
        for (i = 0; i < currencySize; ++i) {
            updateBCSum.append("DebitLocal_").append(i).append("+");
        }
        this.delLastChar(updateBCSum);
        updateBCSum.append(",\nCredit_Sum=");
        for (i = 0; i < currencySize; ++i) {
            updateBCSum.append("CreditLocal_").append(i).append("+");
        }
        this.delLastChar(updateBCSum);
        if (displayAmount) {
            if (accountMap.get("jdyMu") != null) {
                updateBCSum.append(",\nBalance_mu = '").append(accountMap.get("jdyMu")).append("'");
            }
            for (i = 0; i < currencySize; ++i) {
                updateBCSum.append(",\nDebitPrice_").append(i).append(" = case when DebitQty_").append(i).append(" = 0 then 0 else DebitLocal_").append(i).append("/DebitQty_").append(i).append(" end ");
            }
            for (i = 0; i < currencySize; ++i) {
                updateBCSum.append(",\nCreditPrice_").append(i).append(" = case when CreditQty_").append(i).append(" = 0 then 0 else CreditLocal_").append(i).append("/CreditQty_").append(i).append(" end ");
            }
        }
        this.executeUpdate(updateBCSum.toString(), null, ctx);
        if (displayAmount) {
            int j;
            StringBuffer sql7 = new StringBuffer();
            sql7.append("update ").append(tempTableName);
            sql7.append(" set \n");
            for (i2 = 0; i2 < mcItemSize; ++i2) {
                for (j = 0; j < currencySize; ++j) {
                    if (i2 < debitSize) {
                        sql7.append("\nDebitPrice_").append(i2).append("_").append(j).append("=").append(" case when DebitQty_").append(i2).append("_").append(j).append(" = 0 then 0 else DebitLocal_").append(i2).append("_").append(j).append("/DebitQty_").append(i2).append("_").append(j).append(" end ,");
                        continue;
                    }
                    sql7.append("\nCreditPrice_").append(i2).append("_").append(j).append("=").append(" case when CreditQty_").append(i2).append("_").append(j).append(" = 0 then 0 else CreditLocal_").append(i2).append("_").append(j).append("/CreditQty_").append(i2).append("_").append(j).append(" end ,");
                }
            }
            this.delLastChar(sql7);
            sql7.append("\n where no <> 0");
            this.executeUpdate(sql7.toString(), null, ctx);
            sql7.setLength(0);
            sql7.append("update ").append(tempTableName);
            sql7.append(" set \n");
            for (i2 = 0; i2 < mcItemSize; ++i2) {
                for (j = 0; j < currencySize; ++j) {
                    if (i2 < debitSize) {
                        sql7.append("\nDebitPrice_").append(i2).append("_").append(j).append("=").append(" case when DebitPrice_").append(i2).append("_").append(j).append(" > 0 then DebitPrice_").append(i2).append("_").append(j).append(" else -1*DebitPrice_").append(i2).append("_").append(j).append("  end ,");
                        continue;
                    }
                    sql7.append("\nCreditPrice_").append(i2).append("_").append(j).append("=").append(" case when CreditPrice_").append(i2).append("_").append(j).append(" > 0 then CreditPrice_").append(i2).append("_").append(j).append(" else -1*CreditPrice_").append(i2).append("_").append(j).append("  end ,");
                }
            }
            this.delLastChar(sql7);
            sql7.append("\n where no <> 0");
            this.executeUpdate(sql7.toString(), null, ctx);
        }
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update ").append(tempTableName).append(" set ");
        n = mcFieldList.size();
        for (i2 = 0; i2 < n; ++i2) {
            String fieldName = mcFieldList.get(i2).toString();
            if (fieldName.toLowerCase().trim().startsWith("creditqty")) {
                sqlUpdate.append(fieldName.toLowerCase().replaceFirst("creditqty", "CreditStdQty")).append(" = null,");
            } else if (fieldName.toLowerCase().trim().startsWith("debitqty")) {
                sqlUpdate.append(fieldName.toLowerCase().replaceFirst("debitqty", "DebitStdQty")).append(" = null,");
            }
            sqlUpdate.append(mcFieldList.get(i2)).append(" = null,");
        }
        this.delLastChar(sqlUpdate);
        sqlUpdate.append(" where FSourceType = 1");
        this.executeUpdate(sqlUpdate.toString(), null, ctx);
        ArrayList<Integer> hidemcField = new ArrayList<Integer>();
        if (noDisplayNoCol) {
            RptRowSet psRst = null;
            StringBuffer sqlend = new StringBuffer();
            int forIndex = 0;
            if (displayAmount) {
                forIndex = 3;
            }
            int hidemcIndex = -1;
            for (int i16 = 0; i16 < mcItemSize; ++i16) {
                for (int j = 0; j < currencyList.size(); ++j) {
                    for (int k = 0; k < 2 + forIndex; ++k) {
                        ++hidemcIndex;
                        sqlend.setLength(0);
                        sqlend.append("select count(");
                        if (k == 0 + forIndex) {
                            if (i16 < debitSize) {
                                sqlend.append(" DebitFor_").append(i16).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditFor_").append(i16).append("_").append(j).toString();
                            }
                        } else if (k == 1 + forIndex) {
                            if (i16 < debitSize) {
                                sqlend.append(" DebitLocal_").append(i16).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditLocal_").append(i16).append("_").append(j).toString();
                            }
                        }
                        sqlend.append(")  hasdatacount from ").append(tempTableName).append(" where ");
                        if (k == 0 + forIndex) {
                            if (i16 < debitSize) {
                                sqlend.append(" DebitFor_").append(i16).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditFor_").append(i16).append("_").append(j).toString();
                            }
                        } else if (k == 1 + forIndex) {
                            if (i16 < debitSize) {
                                sqlend.append(" DebitLocal_").append(i16).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditLocal_").append(i16).append("_").append(j).toString();
                            }
                        }
                        sqlend.append("  <> to_decimal(0.0,19,4) --is not null \n");
                        sqlend.append("  and voucherid is not null ");
                        if (k < forIndex || k > forIndex + 1) continue;
                        try {
                            psRst = this.executeQuery(sqlend.toString(), null, ctx);
                            psRst.next();
                            if (psRst.getInt("hasdatacount") != 0) continue;
                            hidemcField.add(new Integer(hidemcIndex));
                            if (!displayAmount || k != 1 + forIndex) continue;
                            hidemcField.add(new Integer(hidemcIndex - 2));
                            hidemcField.add(new Integer(hidemcIndex - 3));
                            hidemcField.add(new Integer(hidemcIndex - 4));
                            continue;
                        }
                        catch (SQLDataException e) {
                            logger.error((Object)e);
                        }
                    }
                }
            }
        }
        if (hideOrigine) {
            int hidemcIndex = -1;
            for (int i17 = 0; i17 < mcItemSize; ++i17) {
                for (int j = 0; j < currencyList.size(); ++j) {
                    int k;
                    if (displayAmount) {
                        for (k = 0; k < 5; ++k) {
                            ++hidemcIndex;
                            if (k != 3) continue;
                            hidemcField.add(new Integer(hidemcIndex));
                        }
                        continue;
                    }
                    for (k = 0; k < 2; ++k) {
                        ++hidemcIndex;
                        if (k != 0) continue;
                        hidemcField.add(new Integer(hidemcIndex));
                    }
                }
            }
        }
        RptParams re = this.setHeaderAndReturn(debitList, creditList, sumFileldList, mcFieldList, hidemcField, company, mcItemSize, cc, accountView, tempTableName, displayAmount, hideOrigine, accountMap, ctx);
        return re;
    }

    private HashMap sortAccountMd(Context ctx, Object[][] md, int fromAccountLevel, boolean isQtyAsst) throws BOSException {
        StringBuffer accountIds = new StringBuffer();
        String actItemId = null;
        for (int i = 0; i < md.length; ++i) {
            actItemId = md[i][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)md[i][1]).getId().toString() : ((LabelValueBean)md[i][1]).getValue();
            accountIds.append(",'");
            accountIds.append(actItemId);
            accountIds.append("'");
        }
        String sql = "select distinct av.fid,av.flongnumber,av.flevel,mu.fname_" + ctx.getLocale() + " fmuname, case when childav.fid is null then 'false' else 'true' end hasChild from t_bd_accountview av \nleft join (select fid, fparentid from t_bd_accountview where fid in (" + accountIds.substring(1) + "))\r\nchildav on childav.fparentid = av.fid";
        sql = isQtyAsst ? sql + "\n left join T_BD_AsstAccount aa on aa.fid = av.fcaa\n left join T_BD_MeasureUnitGroup mug on aa.FMeasureUnitGroupID = mug.fid" : sql + "\n left join T_BD_MeasureUnitGroup mug on av.FMeasureUnitGroupID = mug.fid";
        sql = sql + "\n left join T_BD_MeasureUnit mu on mu.fid = mug.FDefaultUnitID\n where av.fid in (" + accountIds.substring(1) + ")";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Object> accountMap = new HashMap<String, Object>();
        accountMap.put("iRowSet", iRowSet);
        try {
            int maxAccountLevel = -1;
            int minAccountLevel = -1;
            String jdyMu = " ";
            while (iRowSet.next()) {
                accountMap.put(iRowSet.getString("fid"), iRowSet.getString("flongnumber"));
                accountMap.put(iRowSet.getString("fid") + "hasChild", iRowSet.getString("hasChild"));
                accountMap.put(iRowSet.getString("fid") + "level", iRowSet.getString("flevel"));
                if (iRowSet.getInt("flevel") < minAccountLevel || minAccountLevel < 0) {
                    minAccountLevel = iRowSet.getInt("flevel");
                }
                if (iRowSet.getInt("flevel") > maxAccountLevel || maxAccountLevel < 0) {
                    maxAccountLevel = iRowSet.getInt("flevel");
                }
                accountMap.put(iRowSet.getString("fid") + "_mu", iRowSet.getString("fmuname"));
                if (iRowSet.getString("fmuname") == null || jdyMu == null) continue;
                if (jdyMu.equals(" ")) {
                    jdyMu = iRowSet.getString("fmuname");
                    continue;
                }
                if (jdyMu.equals(iRowSet.getString("fmuname"))) continue;
                jdyMu = null;
            }
            accountMap.put("minAccountLevel", new Integer(minAccountLevel));
            accountMap.put("maxAccountLevel", new Integer(maxAccountLevel));
            accountMap.put("jdyMu", jdyMu == null ? "           " : jdyMu);
        }
        catch (SQLException ex) {
            throw new BOSException("Error sql: " + sql, (Throwable)ex);
        }
        int index = 0;
        boolean hasSwap = false;
        int i = 0;
        while (i < md.length) {
            hasSwap = false;
            index = i;
            String uperactItemId = md[i][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)md[i][1]).getId().toString() : ((LabelValueBean)md[i][1]).getValue();
            String uperlongNumber = (String)accountMap.get(uperactItemId);
            for (int k = i + 1; k < md.length; ++k) {
                String childactItemId = md[k][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)md[k][1]).getId().toString() : ((LabelValueBean)md[k][1]).getValue();
                String childlongNumber = (String)accountMap.get(childactItemId);
                if (!childlongNumber.startsWith(uperlongNumber)) continue;
                Object[] temp = md[index];
                md[index] = md[k];
                md[k] = temp;
                index = k;
                hasSwap = true;
            }
            if (hasSwap) continue;
            ++i;
        }
        return accountMap;
    }

    private String getSubbegincol(boolean includeNoTransPLVoucher, String cur) {
        StringBuffer resl = new StringBuffer();
        resl.append("GL.FBeginBalance" + cur);
        return resl.toString();
    }

    private String getSubcol(boolean includeNoTransPLVoucher, String dc, String cur) {
        StringBuffer resl = new StringBuffer();
        if (includeNoTransPLVoucher) {
            resl.append("GL.FYear").append(dc).append(cur).append(" - ").append("GL.F").append(dc).append(cur).append(" ");
        } else if (dc.equalsIgnoreCase("Debit")) {
            resl.append("case when avt.fproperty<>4 then GL.FYEARDEBIT").append(cur);
            resl.append(" else case when (b.FStartPeriodID = GL.fperiodid and 1 = 2) then (CASE WHEN GL.Fmonthpnl").append(cur);
            resl.append("-(GL.FDEBIT").append(cur).append(" -GL.FCREDIT").append(cur);
            resl.append(") < 0 then GL.Fmonthpnl").append(cur).append("-(GL.FDEBIT").append(cur);
            resl.append(" -GL.FCREDIT").append(cur).append(") + GL.FYEARDEBIT").append(cur);
            resl.append(" else GL.FYEARDEBIT").append(cur);
            resl.append(" end ) else (CASE WHEN GL.Fyearpnl").append(cur).append("-(GL.FDEBIT").append(cur);
            resl.append(" -GL.FCREDIT").append(cur).append(") < 0 then GL.Fyearpnl").append(cur);
            resl.append(" + GL.FYEARCREDIT").append(cur).append(" else GL.FYEARDEBIT").append(cur);
            resl.append(" end ) end end");
            resl.append(" - ");
            resl.append("case when avt.fproperty<>4 then GL.FDEBIT").append(cur);
            resl.append(" else (CASE WHEN GL.Fmonthpnl").append(cur).append("-(GL.FDEBIT").append(cur);
            resl.append(" -GL.FCREDIT").append(cur).append(") < 0 then GL.Fmonthpnl").append(cur);
            resl.append("-(GL.FDEBIT").append(cur).append(" -GL.FCREDIT").append(cur);
            resl.append(") + GL.FDEBIT").append(cur).append(" else GL.FDEBIT").append(cur).append(" end ) end");
        } else {
            resl.append("case when avt.fproperty<>4 then GL.FYEARCREDIT").append(cur);
            resl.append(" else case when (b.FStartPeriodID = GL.fperiodid and 1 = 2) then (CASE WHEN GL.Fmonthpnl").append(cur);
            resl.append("-(GL.FDEBIT").append(cur).append(" -GL.FCREDIT").append(cur);
            resl.append(") < 0 then GL.FYEARCREDIT").append(cur).append(" else GL.FYEARCREDIT").append(cur);
            resl.append("- (GL.Fmonthpnl").append(cur).append("-(GL.FDEBIT").append(cur);
            resl.append(" -GL.FCREDIT").append(cur).append(")) end ) else (CASE WHEN GL.Fyearpnl").append(cur);
            resl.append("-(GL.FDEBIT").append(cur).append(" -GL.FCREDIT").append(cur);
            resl.append(") < 0 then GL.FYEARCREDIT").append(cur).append(" else GL.FYEARDEBIT").append(cur);
            resl.append(" - GL.Fyearpnl").append(cur).append(" end ) end end");
            resl.append(" - ");
            resl.append("case when avt.fproperty<>4 then GL.FCREDIT").append(cur);
            resl.append(" else (CASE WHEN GL.Fmonthpnl").append(cur).append("-(GL.FDEBIT").append(cur);
            resl.append(" -GL.FCREDIT").append(cur).append(") < 0 then GL.FCREDIT").append(cur);
            resl.append(" else GL.FCREDIT").append(cur).append("- (GL.Fmonthpnl").append(cur);
            resl.append("-(GL.FDEBIT").append(cur).append(" -GL.FCREDIT").append(cur);
            resl.append(")) end ) end");
        }
        return resl.toString();
    }

    protected RptParams createAsstactMultiColumnTempTable(Context ctx, RptParams params, CommonSchema cs) throws BOSException, ReportBizException, EASBizException {
        int i;
        int i2;
        int n;
        int i3;
        int i4;
        int i5;
        int r;
        StringBuffer sql2;
        String currencyId;
        String glField;
        ArrayList<String> sumFileldList;
        ArrayList<String> mcFieldList;
        HashMap<String, ArrayList> actChild;
        String hgFieldName;
        int mcItemSize;
        int debitSize;
        ArrayList<LabelValueBean> itemList;
        ArrayList<LabelValueBean> creditList;
        ArrayList<LabelValueBean> debitList;
        int currencySize;
        CurrencyCollection cc;
        int accountDc;
        String accountId;
        String baseMuName;
        boolean isQtyAsst;
        boolean hideOrigine;
        boolean displayAmount;
        boolean displayEndBalance;
        AccountViewInfo accountView;
        boolean noDisplayNoCol;
        int[] periodRange;
        int balType;
        String tempTableName;
        String periodType;
        CompanyOrgUnitInfo company;
        String companyId;
        block175: {
            int i6;
            int i7;
            String selectInto;
            SqlParams pp;
            boolean includeNoTransPLVoucher;
            block174: {
                int i8;
                int i9;
                String actItemId;
                String loc = this._getLocaleString(ctx);
                companyId = params.getString("companyID");
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                periodType = company.getAccountPeriodType().getId().toString();
                tempTableName = params.getString("tempTableName");
                String balTypes = params.getBoolean("includeNoPosting") ? "(1,3,4,5)" : "(5)";
                balType = params.getBoolean("includeNoPosting") ? 1 : 5;
                periodRange = new int[]{params.getInt("yearFrom"), params.getInt("periodFrom"), params.getInt("yearTo"), params.getInt("periodTo")};
                includeNoTransPLVoucher = params.getBoolean("includeNoTransPLVoucher");
                noDisplayNoCol = params.getBoolean("noDisplayNoCol");
                String accViewId = cs.getParams().getString("accountViewID");
                accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accViewId));
                displayEndBalance = params.getBoolean("displayEndBalance");
                displayAmount = params.getBoolean("displayAmount");
                boolean displayOneLineBiz = params.getBoolean("displayOneLineBiz");
                hideOrigine = !params.getBoolean("displayOrigine");
                isQtyAsst = cs.getParams().getBoolean("isQtyAsst");
                baseMuName = cs.getParams().getString("baseMuName");
                if (!isQtyAsst) {
                    String sql = "select av.fid,av.flongnumber ,mu.fname_" + loc + " fmuname from t_bd_accountview av ";
                    sql = sql + "\n left join T_BD_MeasureUnitGroup mug on av.FMeasureUnitGroupID = mug.fid";
                    sql = sql + "\n left join T_BD_MeasureUnit mu on mu.fid = mug.FDefaultUnitID\n where av.fid = '" + accViewId + "'";
                    IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        while (iRowSet.next()) {
                            baseMuName = iRowSet.getString("fmuname");
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)ex);
                    }
                }
                if (baseMuName == null) {
                    baseMuName = "";
                }
                accountId = accountView.getId().toString();
                accountDc = accountView.getDC().getValue();
                cc = this.getCurrencyCollection(ctx, (HashSet)cs.getParams().getObject("selectedCurrencyIDSet"), company);
                currencySize = cc.size();
                Object[][] md = (Object[][])cs.getParams().getObject("md");
                debitList = new ArrayList<LabelValueBean>();
                creditList = new ArrayList<LabelValueBean>();
                for (int i10 = 0; i10 < md.length; ++i10) {
                    actItemId = md[i10][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)md[i10][1]).getId().toString() : ((LabelValueBean)md[i10][1]).getValue();
                    if (BalanceDirectionEnum.DEBIT.equals(md[i10][0])) {
                        debitList.add(new LabelValueBean(actItemId, (String)md[i10][2]));
                        continue;
                    }
                    creditList.add(new LabelValueBean(actItemId, (String)md[i10][2]));
                }
                itemList = new ArrayList<LabelValueBean>();
                itemList.addAll(debitList);
                itemList.addAll(creditList);
                debitSize = debitList.size();
                mcItemSize = itemList.size();
                LabelValueBean actType = (LabelValueBean)((List)cs.getParams().getObject("asstact_type_list")).get(cs.getParams().getInt("asstact_type_index"));
                Object[] actAttributes = (Object[])actType.getProperty();
                hgFieldName = (String)actAttributes[0];
                boolean isMultiLevel = (Integer)actAttributes[5] == 1;
                String realtiondataobjectTable = null;
                if (actAttributes.length >= 10) {
                    realtiondataobjectTable = (String)actAttributes[9];
                }
                actChild = null;
                if (isMultiLevel && realtiondataobjectTable != null) {
                    actChild = new HashMap<String, ArrayList>();
                    StringBuffer actIds = new StringBuffer();
                    actItemId = null;
                    for (int i11 = 0; i11 < md.length; ++i11) {
                        actItemId = md[i11][1] instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)md[i11][1]).getId().toString() : ((LabelValueBean)md[i11][1]).getValue();
                        actIds.append(",'");
                        actIds.append(actItemId);
                        actIds.append("'");
                    }
                    try {
                        String generalAsstFilter = "";
                        if ("T_BD_GeneralAsstActType".equalsIgnoreCase(realtiondataobjectTable)) {
                            generalAsstFilter = "and parent.fgroupid = child.fgroupid ";
                        }
                        String sql = "select distinct parent.fid actpid,child.fid actcid from " + realtiondataobjectTable + " child \n inner join " + realtiondataobjectTable + " parent on charindex(parent.FLongNumber ||'!',child.FLongNumber ||\t '!') = 1 \n where parent.fid in (" + actIds.substring(1) + " ) and parent.fid <> child.fid " + generalAsstFilter + "order by parent.fid ";
                        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        while (iRowSet.next()) {
                            ArrayList al;
                            if (actChild.get(iRowSet.getString("actpid")) == null) {
                                al = new ArrayList();
                                al.add(iRowSet.getString("actcid"));
                                actChild.put(iRowSet.getString("actpid"), al);
                                continue;
                            }
                            al = (ArrayList)actChild.get(iRowSet.getString("actpid"));
                            al.add(iRowSet.getString("actcid"));
                        }
                    }
                    catch (SQLException generalAsstFilter) {
                        // empty catch block
                    }
                }
                if (tempTableName != null) {
                    this.dropTable(ctx, tempTableName);
                }
                tempTableName = "RptAsstActMulti_Temptable";
                mcFieldList = new ArrayList<String>();
                sumFileldList = new ArrayList<String>();
                StringBuffer select = new StringBuffer();
                StringBuffer selectSameBiz = new StringBuffer();
                StringBuffer groupMuSameBiz = new StringBuffer();
                select.append("SELECT 0 no,A.FID voucherId, A.FSourcetype, B.FEntryDC ActDC, F.FID FPeriodID,F.FPeriodYear,F.FPeriodNumber ,A.FBookedDate bizDate, D.FName_").append(loc).append("||'-'||IsNull(A.FNumber,'') voucherTypeName, C.FDescription description,\n");
                selectSameBiz.append("SELECT  no, voucherId,FSourcetype, ActDC,  FPeriodID,FPeriodYear,FPeriodNumber , bizDate, voucherTypeName, max(description)  description,\n");
                for (i9 = 0; i9 < currencySize; ++i9) {
                    if (displayAmount) {
                        glField = "DebitMu_" + i9;
                        select.append("'           ' ").append(glField).append(",");
                        selectSameBiz.append("'           ' ").append(glField).append(",");
                        sumFileldList.add(glField);
                        glField = "DebitQty_" + i9;
                        select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        sumFileldList.add(glField);
                        glField = "DebitPrice_" + i9;
                        select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        sumFileldList.add(glField);
                    }
                    glField = "DebitFor_" + i9;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                    glField = "DebitLocal_" + i9;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                }
                select.append("TO_DECIMAL(0.0,19,4) Debit_Sum,");
                selectSameBiz.append("sum(").append("Debit_Sum").append(") ").append("Debit_Sum").append(",");
                sumFileldList.add("Debit_Sum");
                for (i9 = 0; i9 < currencySize; ++i9) {
                    if (displayAmount) {
                        glField = "CreditMu_" + i9;
                        select.append("'           ' ").append(glField).append(",");
                        selectSameBiz.append("'           ' ").append(glField).append(",");
                        sumFileldList.add(glField);
                        glField = "CreditQty_" + i9;
                        select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        sumFileldList.add(glField);
                        glField = "CreditPrice_" + i9;
                        select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        sumFileldList.add(glField);
                    }
                    glField = "CreditFor_" + i9;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                    glField = "CreditLocal_" + i9;
                    select.append("TO_DECIMAL(0.0,19,4) ").append(glField).append(",");
                    selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    sumFileldList.add(glField);
                }
                select.append("TO_DECIMAL(0.0,19,4) Credit_Sum,");
                selectSameBiz.append("sum(").append("Credit_Sum").append(") ").append("Credit_Sum").append(",");
                sumFileldList.add("Credit_Sum");
                if (displayAmount) {
                    select.append("'           ' Balance_Mu,");
                    selectSameBiz.append("'           ' Balance_Mu,");
                    sumFileldList.add("Balance_Mu");
                    select.append("TO_DECIMAL(0.0,19,4) Balance_Qty,");
                    selectSameBiz.append("sum(").append("Balance_Qty").append(") ").append("Balance_Qty").append(",");
                    sumFileldList.add("Balance_Qty");
                    select.append("TO_DECIMAL(0.0,19,4) Balance_Price,");
                    sumFileldList.add("Balance_Price");
                    selectSameBiz.append("sum(").append("Balance_Price").append(") ").append("Balance_Price").append(",");
                }
                select.append(" case ").append(accountDc).append(" when 1 then ").append("'").append(GLResUtil.getRes("debit", ctx)).append("' else '").append(GLResUtil.getRes("credit", ctx)).append("' end Orginal_DC,");
                selectSameBiz.append("Orginal_DC,");
                sumFileldList.add("Orginal_DC");
                select.append("TO_DECIMAL(0.0,19,4) Balance_Amount,");
                selectSameBiz.append("sum(").append("Balance_Amount").append(") ").append("Balance_Amount").append(",");
                sumFileldList.add("Balance_Amount");
                for (int i12 = 0; i12 < mcItemSize; ++i12) {
                    for (int j = 0; j < cc.size(); ++j) {
                        currencyId = cc.get(j).getId().toString();
                        String glCase = new StringBuffer().append("\n case when GL.FCurrencyId='").append(currencyId).append("' and (HG.").append(hgFieldName).append("='").append(((LabelValueBean)itemList.get(i12)).getValue()).append("' ").toString();
                        if (actChild != null && actChild.get(((LabelValueBean)itemList.get(i12)).getValue()) != null) {
                            ArrayList al = (ArrayList)actChild.get(((LabelValueBean)itemList.get(i12)).getValue());
                            for (int ial = al.size() - 1; ial >= 0; --ial) {
                                glCase = glCase + " or HG." + hgFieldName + " = '" + al.get(ial) + "' ";
                            }
                        }
                        glCase = glCase + ") ";
                        if (i12 < debitSize) {
                            if (displayAmount) {
                                glField = new StringBuffer().append(" DebitMu_").append(i12).append("_").append(j).toString();
                                mcFieldList.add(glField);
                                select.append(glCase).append(" then mu.fname_").append(loc).append(" else null end ").append(glField).append(",");
                                selectSameBiz.append(glField).append(",");
                                groupMuSameBiz.append(glField).append(",");
                                glField = new StringBuffer().append(" DebitQty_").append(i12).append("_").append(j).toString();
                                mcFieldList.add(glField);
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then C.FQuantity else 0-C.FQuantity end,0) else 0 end ").append(glField).append(",");
                                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                                glField = new StringBuffer().append(" DebitStdQty_").append(i12).append("_").append(j).toString();
                                if (isQtyAsst) {
                                    select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then C.FStandardQuantity else 0-C.FStandardQuantity end,0) else 0 end ").append(glField).append(",");
                                } else {
                                    select.append(glCase).append(" then  mu.FCoefficient*IsNull(case B.FEntryDC when 1 then C.FQuantity else 0-C.FQuantity end,0) else 0 end ").append(glField).append(",");
                                }
                                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                                glField = new StringBuffer().append(" DebitPrice_").append(i12).append("_").append(j).toString();
                                mcFieldList.add(glField);
                                select.append(glCase).append(" then C.FPrice else null end ").append(glField).append(",");
                                selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                            }
                            glField = new StringBuffer().append(" DebitFor_").append(i12).append("_").append(j).toString();
                            mcFieldList.add(glField);
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then C.FOriginalAmount else 0-C.FOriginalAmount end,0) else 0 end ").append(glField).append(",");
                            selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                            glField = new StringBuffer().append(" DebitLocal_").append(i12).append("_").append(j).toString();
                            mcFieldList.add(glField);
                            select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then C.FLocalAmount else 0-C.FLocalAmount end,0) else 0 end ").append(glField).append(",");
                            selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                            continue;
                        }
                        if (displayAmount) {
                            glField = new StringBuffer().append(" CreditMu_").append(i12).append("_").append(j).toString();
                            mcFieldList.add(glField);
                            select.append(glCase).append(" then mu.fname_").append(loc).append(" else null end ").append(glField).append(",");
                            selectSameBiz.append(glField).append(",");
                            groupMuSameBiz.append(glField).append(",");
                            glField = new StringBuffer().append(" CreditQty_").append(i12).append("_").append(j).toString();
                            mcFieldList.add(glField);
                            select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then 0-C.FQuantity else C.FQuantity end,0) else 0 end ").append(glField).append(",");
                            selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                            glField = new StringBuffer().append(" CreditStdQty_").append(i12).append("_").append(j).toString();
                            if (isQtyAsst) {
                                select.append(glCase).append(" then  IsNull(case B.FEntryDC when 1 then 0-C.FStandardQuantity else C.FStandardQuantity end,0) else 0 end ").append(glField).append(",");
                            } else {
                                select.append(glCase).append(" then  mu.FCoefficient*IsNull(case B.FEntryDC when 1 then 0-C.FQuantity else C.FQuantity end,0) else 0 end ").append(glField).append(",");
                            }
                            selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                            glField = new StringBuffer().append(" CreditPrice_").append(i12).append("_").append(j).toString();
                            mcFieldList.add(glField);
                            select.append(glCase).append(" then C.FPrice else null end ").append(glField).append(",");
                            selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        }
                        glField = new StringBuffer().append(" CreditFor_").append(i12).append("_").append(j).toString();
                        mcFieldList.add(glField);
                        select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then 0-C.FOriginalAmount else C.FOriginalAmount end,0) else 0 end ").append(glField).append(",");
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                        glField = new StringBuffer().append(" CreditLocal_").append(i12).append("_").append(j).toString();
                        mcFieldList.add(glField);
                        select.append(glCase).append(" then IsNull(case B.FEntryDC when 1 then 0-C.FLocalAmount else C.FLocalAmount end,0) else 0 end ").append(glField).append(",");
                        selectSameBiz.append("sum(").append(glField).append(") ").append(glField).append(",");
                    }
                }
                select.deleteCharAt(select.length() - 1);
                selectSameBiz.deleteCharAt(selectSameBiz.length() - 1);
                pp = new SqlParams();
                int pi = 1;
                StringBuffer fromWhere = new StringBuffer();
                fromWhere.append("\n FROM T_GL_Voucher A ").append("\n INNER JOIN T_GL_VoucherAssistRecord C ON A.FID = C.FBillID");
                if (displayAmount) {
                    fromWhere.append("\n LEFT JOIN t_bd_measureunit mu on mu.fid = c.FMeasureUnitID ");
                }
                fromWhere.append("\n INNER JOIN T_GL_VoucherEntry B ON A.FID = B.FBillID AND C.FEntryID = B.FID").append("\n INNER JOIN T_BD_AssistantHG HG ON C.FAssGrpID = HG.FID ").append("\n INNER JOIN T_BD_VoucherTypes D ON A.FVoucherTypeID = D.FID").append("\n INNER JOIN t_bd_period F on F.FID=A.FPeriodID").append("\n inner join " + this.getAssistBalanceTable(ctx, includeNoTransPLVoucher) + " GL on GL.FAssistGrpID=HG.FID and GL.FPeriodID=F.FID and GL.FAccountID=B.FAccountID and GL.FCurrencyID=B.FCurrencyID ").append(null == this.getGovAsstactDetailJoinTable(ctx, params) ? "" : this.getGovAsstactDetailJoinTable(ctx, params)).append("\n where " + this.getChildAcctID("B.FAccountID") + " and GL.FOrgUnitID=? and GL.FBalType=?").append("\n and ").append(SQLUtil.getPeriodCondition("F.fperiodYear", "F.fperiodNumber", periodRange));
                pp.setString(pi++, accountId);
                pp.setString(pi++, companyId);
                pp.setString(pi++, companyId);
                pp.setInt(pi++, balType);
                fromWhere.append("\n and GL.FCurrencyID in (");
                for (i8 = 0; i8 < currencySize; ++i8) {
                    currencyId = cc.get(i8).getId().toString();
                    fromWhere.append("?");
                    pp.setString(pi++, currencyId);
                    if (i8 >= currencySize - 1) continue;
                    fromWhere.append(",");
                }
                fromWhere.append(")");
                fromWhere.append("\n and HG.").append(hgFieldName).append(" in (");
                for (i8 = 0; i8 < mcItemSize; ++i8) {
                    fromWhere.append("?");
                    pp.setString(pi++, ((LabelValueBean)itemList.get(i8)).getValue());
                    if (actChild != null && actChild.get(((LabelValueBean)itemList.get(i8)).getValue()) != null) {
                        ArrayList al = (ArrayList)actChild.get(((LabelValueBean)itemList.get(i8)).getValue());
                        for (int ial = al.size() - 1; ial >= 0; --ial) {
                            fromWhere.append(",?");
                            pp.setString(pi++, al.get(ial).toString());
                        }
                    }
                    if (i8 >= mcItemSize - 1) continue;
                    fromWhere.append(",");
                }
                fromWhere.append(")");
                fromWhere.append("\n and A.FBizStatus in ").append(balTypes);
                if (includeNoTransPLVoucher) {
                    fromWhere.append("\n and A.FSourcetype <> 1 ");
                }
                if (balType == 5) {
                    fromWhere.append("\n and (GL.FDebitFor<>0 or GL.FDebitLocal<>0 or GL.FCreditFor<>0 or GL.FCreditLocal<>0)");
                }
                selectInto = null;
                selectInto = !displayOneLineBiz ? select + "\n into " + tempTableName + fromWhere + (this.getGovAsstactDetailFilter(ctx, params) == null ? "" : this.getGovAsstactDetailFilter(ctx, params)) : selectSameBiz + "\n into " + tempTableName + " from (\n" + select + fromWhere + (this.getGovAsstactDetailFilter(ctx, params) == null ? "" : this.getGovAsstactDetailFilter(ctx, params)) + ") tempp group by " + groupMuSameBiz + " no, voucherId,  FSourcetype, ActDC, FPeriodID,FPeriodYear,FPeriodNumber , bizDate, voucherTypeName,  Orginal_DC";
                try {
                    tempTableName = this.executeSelectInto(selectInto, pp, ctx).getTempTable();
                }
                catch (Exception e) {
                    if (!(e instanceof BOSException)) break block174;
                    if (e.getCause() instanceof SQLException) {
                        if (((SQLException)e.getCause()).getSQLState().equals("S1000") || ((SQLException)e.getCause()).getSQLState().equals("42000")) {
                            throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
                        }
                        throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
                    }
                    throw (BOSException)((Object)e);
                }
            }
            try {
                pp.sql((Object)selectInto);
            }
            catch (SQLException e1) {
                logger.error((Object)e1);
            }
            StringBuffer sql4 = new StringBuffer();
            sql4.append("update ").append(tempTableName).append(" set ");
            for (int i13 = 0; i13 < currencySize; ++i13) {
                int j;
                sql4.append("\nDebitFor_").append(i13).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    glField = (j < debitSize ? "DebitFor_" : "CreditFor_") + j + "_" + i13;
                    if (j < debitSize) {
                        sql4.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                        continue;
                    }
                    sql4.append("case ActDC when 1 then 0-").append(glField).append(" else 0 end +");
                }
                this.delLastChar(sql4);
                sql4.append(",");
                sql4.append("DebitLocal_").append(i13).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    glField = (j < debitSize ? "DebitLocal_" : "CreditLocal_") + j + "_" + i13;
                    if (j < debitSize) {
                        sql4.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                        continue;
                    }
                    sql4.append("case ActDC when 1 then 0-").append(glField).append(" else 0 end +");
                }
                this.delLastChar(sql4);
                sql4.append(",");
                sql4.append("CreditFor_").append(i13).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    glField = (j < debitSize ? "DebitFor_" : "CreditFor_") + j + "_" + i13;
                    if (j < debitSize) {
                        sql4.append("case ActDC when 1 then 0 else 0-").append(glField).append(" end +");
                        continue;
                    }
                    sql4.append("case ActDC when 1 then 0 else ").append(glField).append(" end +");
                }
                this.delLastChar(sql4);
                sql4.append(",");
                sql4.append("CreditLocal_").append(i13).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    glField = (j < debitSize ? "DebitLocal_" : "CreditLocal_") + j + "_" + i13;
                    if (j < debitSize) {
                        sql4.append("case ActDC when 1 then 0 else 0-").append(glField).append(" end +");
                        continue;
                    }
                    sql4.append("case ActDC when 1 then 0 else ").append(glField).append(" end +");
                }
                this.delLastChar(sql4);
                sql4.append(",");
                if (!displayAmount) continue;
                sql4.append("DebitQty_").append(i13).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    glField = (j < debitSize ? "DebitStdQty_" : "CreditStdQty_") + j + "_" + i13;
                    if (j < debitSize) {
                        sql4.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                        continue;
                    }
                    sql4.append("case ActDC when 1 then ").append(glField).append(" else 0 end +");
                }
                this.delLastChar(sql4);
                sql4.append(",");
                sql4.append("CreditQty_").append(i13).append("=");
                for (j = 0; j < mcItemSize; ++j) {
                    glField = (j < debitSize ? "DebitStdQty_" : "CreditStdQty_") + j + "_" + i13;
                    if (j < debitSize) {
                        sql4.append("case ActDC when 1 then 0 else 0-").append(glField).append(" end +");
                        continue;
                    }
                    sql4.append("case ActDC when 1 then 0 else ").append(glField).append(" end +");
                }
                this.delLastChar(sql4);
                sql4.append(",");
                sql4.append("Debitmu_").append(i13).append("='").append(baseMuName).append("',");
                sql4.append("Creditmu_").append(i13).append("='").append(baseMuName).append("',");
            }
            this.delLastChar(sql4);
            sql4.append("\n where no=0");
            this.executeUpdate(sql4.toString(), null, ctx);
            sql2 = new StringBuffer();
            StringBuffer balanceAmount = new StringBuffer().append(accountDc).append("*(");
            StringBuffer balanceQty = new StringBuffer();
            SqlParams pp2 = new SqlParams();
            int pi2 = 1;
            sql2.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, BizDate, Description, ");
            for (i7 = 0; i7 < mcItemSize; ++i7) {
                for (int j = 0; j < currencySize; ++j) {
                    if (displayAmount) {
                        sql2.append(i7 < debitSize ? " DebitMu_" : " CreditMu_").append(i7).append("_").append(j).append(",");
                        sql2.append(i7 < debitSize ? " DebitQty_" : " CreditQty_").append(i7).append("_").append(j).append(",");
                        sql2.append(i7 < debitSize ? " DebitPrice_" : " CreditPrice_").append(i7).append("_").append(j).append(",");
                    }
                    sql2.append(i7 < debitSize ? " DebitFor_" : " CreditFor_").append(i7).append("_").append(j).append(",");
                    sql2.append(i7 < debitSize ? " DebitLocal_" : " CreditLocal_").append(i7).append("_").append(j).append(",");
                }
            }
            if (displayAmount) {
                sql2.append("Balance_Mu,");
                sql2.append("Balance_Qty,");
                sql2.append("Balance_Price,");
            }
            sql2.append("Balance_Amount,");
            for (i7 = 0; i7 < currencySize; ++i7) {
                if (displayAmount) {
                    sql2.append("DebitMu_").append(i7).append(",");
                    sql2.append("DebitQty_").append(i7).append(",");
                    sql2.append("DebitPrice_").append(i7).append(",");
                }
                sql2.append("DebitFor_").append(i7).append(",");
                sql2.append("DebitLocal_").append(i7).append(",");
                if (displayAmount) {
                    sql2.append("CreditMu_").append(i7).append(",");
                    sql2.append("CreditQty_").append(i7).append(",");
                    sql2.append("CreditPrice_").append(i7).append(",");
                }
                sql2.append("CreditFor_").append(i7).append(",");
                sql2.append("CreditLocal_").append(i7).append(",");
            }
            this.delLastChar(sql2);
            sql2.append(")\n select -1," + accountDc + ", P.FID,P.FPeriodYear,P.FPeriodNumber, P.FBeginDate,'" + GLResUtil.getRes("balance_period_begin", ctx) + "', ");
            boolean isForeignCurrencySU = false;
            HashMap<String, String> paramKeyMap = new HashMap<String, String>();
            paramKeyMap.put("GL_008", companyId);
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            String strForeignCurrencySU = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_008");
            if (strForeignCurrencySU != null && strForeignCurrencySU.trim().length() > 0) {
                isForeignCurrencySU = Boolean.valueOf(strForeignCurrencySU.trim());
            }
            for (int i14 = 0; i14 < mcItemSize; ++i14) {
                int dc = i14 < debitSize ? 1 : -1;
                for (int j = 0; j < currencySize; ++j) {
                    currencyId = cc.get(j).getId().toString();
                    String glCase = new StringBuffer().append("case when GL.FCurrencyId='").append(currencyId).append("' and (HG.").append(hgFieldName).append("='").append(((LabelValueBean)itemList.get(i14)).getValue()).append("' ").toString();
                    if (actChild != null && actChild.get(((LabelValueBean)itemList.get(i14)).getValue()) != null) {
                        ArrayList al = (ArrayList)actChild.get(((LabelValueBean)itemList.get(i14)).getValue());
                        for (int ial = al.size() - 1; ial >= 0; --ial) {
                            glCase = glCase + " or HG." + hgFieldName + " = '" + al.get(ial) + "' ";
                        }
                    }
                    glCase = glCase + ") ";
                    if (displayAmount) {
                        glField = new StringBuffer().append(" BeginBalanceMu_").append(i14).append("_").append(j).toString();
                        sql2.append("'").append(baseMuName).append("' ").append(glField).append(",");
                        glField = new StringBuffer().append(" BeginBalanceQty_").append(i14).append("_").append(j).toString();
                        sql2.append("\nsum(").append(glCase).append(" then IsNull(GL.FBeginQty,0) else 0 end) ").append(glField).append(",");
                        glField = new StringBuffer().append(" BeginBalancePrice_").append(i14).append("_").append(j).toString();
                        sql2.append("TO_DECIMAL(0.0,19,4)  ").append(glField).append(",");
                    }
                    glField = new StringBuffer().append(" BeginBalanceFor_").append(i14).append("_").append(j).toString();
                    sql2.append("\nsum(").append(glCase).append(" then IsNull(").append(dc).append("*(").append(this.getSubbegincol(includeNoTransPLVoucher, "For")).append("),0) else 0 end) ").append(glField).append(",");
                    glField = new StringBuffer().append(" BeginBalanceLocal_").append(i14).append("_").append(j).toString();
                    if (isForeignCurrencySU) {
                        sql2.append("\nsum(").append(glCase).append(" then IsNull(").append(dc).append("*(").append(this.getSubbegincol(includeNoTransPLVoucher, "For")).append("),0) else 0 end) ").append(glField).append(",");
                        balanceAmount.append("\nsum(").append(glCase).append(" then IsNull(GL.FBeginBalanceFor,0) else 0 end)+");
                    } else {
                        sql2.append("\nsum(").append(glCase).append(" then IsNull(").append(dc).append("*(").append(this.getSubbegincol(includeNoTransPLVoucher, "Local")).append("),0) else 0 end) ").append(glField).append(",");
                        balanceAmount.append("\nsum(").append(glCase).append(" then IsNull(GL.FbeginbalanceLocal,0) else 0 end)+");
                    }
                    balanceQty.append("\nsum(").append(glCase).append(" then IsNull(GL.FbeginQty,0) else 0 end)+");
                }
            }
            if (displayAmount) {
                sql2.append("'").append(baseMuName).append("' ").append("Balance_Mu,\n");
                this.delLastChar(balanceQty);
                sql2.append("\n").append(balanceQty).append(" Balance_Qty,\n");
                sql2.append("TO_DECIMAL(0.0,19,4)  ").append("Balance_Price").append(",\n");
            }
            this.delLastChar(balanceAmount);
            sql2.append("\n").append(balanceAmount).append(") Balance_Amount,\n");
            boolean _includeNoTransPLVoucher = true;
            for (i6 = 0; i6 < currencySize; ++i6) {
                currencyId = cc.get(i6).getId().toString();
                String glCase = " case when GL.FCurrencyId='" + currencyId + "' then ";
                if (displayAmount) {
                    sql2.append("'").append(baseMuName).append("' ").append(",\n");
                    sql2.append("\nsum(").append(glCase).append("  IsNull(GL.FYearDebitQty-GL.FDebitQty,0)").append(" else 0 end),");
                    sql2.append("TO_DECIMAL(0.0,19,4)  ").append("").append(",\n");
                }
                sql2.append("\nsum(").append(glCase).append(this.getSubcol(_includeNoTransPLVoucher, "Debit", "For")).append(" else 0 end),");
                sql2.append("\nsum(").append(glCase).append(this.getSubcol(_includeNoTransPLVoucher, "Debit", "Local")).append(" else 0 end),");
                if (displayAmount) {
                    sql2.append("'").append(baseMuName).append("' ").append(",\n");
                    sql2.append("\nsum(").append(glCase).append("  IsNull(GL.FYearCreditQty-GL.FCreditQty,0)").append(" else 0 end),");
                    sql2.append("TO_DECIMAL(0.0,19,4)  ").append("").append(",\n");
                }
                sql2.append("\nsum(").append(glCase).append(this.getSubcol(_includeNoTransPLVoucher, "Credit", "For")).append(" else 0 end),");
                sql2.append("\nsum(").append(glCase).append(this.getSubcol(_includeNoTransPLVoucher, "Credit", "Local")).append(" else 0 end),");
            }
            this.delLastChar(sql2);
            sql2.append("\n from " + this.getAssistBalanceTable(ctx, false) + " GL ").append("\n inner join T_BD_Period P on P.FID=GL.FPeriodID ").append("\n inner join T_BD_AssistantHG HG on GL.FAssistGrpID=HG.FID ");
            sql2.append(" inner join t_bd_accountview c on c.fid=GL.FAccountID");
            sql2.append(" inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid");
            sql2.append(" inner join t_bd_systemstatusctrol b on GL.forgunitid=b.fcompanyid");
            sql2.append(" inner join t_bd_systemstatus d on d.fid=b.fsystemstatusid");
            sql2.append("\n where d.fname=6 and P.FTypeID=? and P.FPeriodYear=? and P.FPeriodNumber=? ").append("\n and GL.FBalType=? and GL.FOrgUnitID=? and ").append(this.getChildAcctID("GL.FAccountID"));
            pp2.setString(pi2++, periodType).setInt(pi2++, periodRange[0]).setInt(pi2++, periodRange[1]).setInt(pi2++, balType).setString(pi2++, companyId).setString(pi2++, accountId).setString(pi2++, companyId);
            sql2.append("\n and GL.FCurrencyID in (");
            for (i6 = 0; i6 < currencySize; ++i6) {
                currencyId = cc.get(i6).getId().toString();
                sql2.append("?,");
                pp2.setString(pi2++, currencyId);
            }
            this.delLastChar(sql2);
            sql2.append(")\n and HG.").append(hgFieldName).append(" in (");
            for (i6 = 0; i6 < mcItemSize; ++i6) {
                sql2.append("?,");
                pp2.setString(pi2++, ((LabelValueBean)itemList.get(i6)).getValue());
                if (actChild == null || actChild.get(((LabelValueBean)itemList.get(i6)).getValue()) == null) continue;
                ArrayList al = (ArrayList)actChild.get(((LabelValueBean)itemList.get(i6)).getValue());
                for (int ial = al.size() - 1; ial >= 0; --ial) {
                    sql2.append("?,");
                    pp2.setString(pi2++, al.get(ial).toString());
                }
            }
            this.delLastChar(sql2);
            sql2.append(")\n group by P.FID,P.FPeriodYear,P.FPeriodNumber, P.FBeginDate");
            r = 0;
            try {
                r = this.executeUpdate(sql2.toString(), pp2, ctx);
            }
            catch (Exception e) {
                if (!(e instanceof BOSException)) break block175;
                if (e.getCause() instanceof SQLException) {
                    throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
                }
                throw (BOSException)((Object)e);
            }
        }
        if (r == 0) {
            sql2.setLength(0);
            sql2.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, BizDate, Description)").append("\n select -1," + accountDc + ", P.FID,P.FPeriodYear,P.FPeriodNumber, P.FBeginDate,'" + GLResUtil.getRes("balance_period_begin", ctx) + "' from T_BD_Period P").append("\n where P.FPeriodYear=").append(periodRange[0]).append(" and P.FPeriodNumber=").append(periodRange[1]).append(" and P.FTypeID='").append(periodType).append("'");
            this.executeUpdate(sql2.toString(), null, ctx);
        }
        StringBuffer sql1 = new StringBuffer();
        sql1.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, bizDate,description, ");
        int n2 = mcFieldList.size();
        for (i5 = 0; i5 < n2; ++i5) {
            sql1.append(mcFieldList.get(i5)).append(",");
        }
        for (i5 = 0; i5 < currencySize; ++i5) {
            if (displayAmount) {
                sql1.append("DebitMu_").append(i5).append(",");
                sql1.append("DebitQty_").append(i5).append(",");
            }
            sql1.append("DebitFor_").append(i5).append(",");
            sql1.append("DebitLocal_").append(i5).append(",");
            if (displayAmount) {
                sql1.append("CreditMu_").append(i5).append(",");
                sql1.append("CreditQty_").append(i5).append(",");
            }
            sql1.append("CreditFor_").append(i5).append(",");
            sql1.append("CreditLocal_").append(i5).append(",");
        }
        sql1.append("Debit_Sum,Credit_Sum,");
        this.delLastChar(sql1);
        sql1.append(") \n select 1," + accountDc + ", P.FID,P.FPeriodYear,P.FPeriodNumber, P.FEndDate, '" + GLResUtil.getRes("period_total", ctx) + "', ");
        n2 = mcFieldList.size();
        for (i5 = 0; i5 < n2; ++i5) {
            if (!mcFieldList.get(i5).toString().startsWith(" CreditMu_") && !mcFieldList.get(i5).toString().startsWith(" DebitMu_")) {
                String sss = mcFieldList.get(i5).toString();
                if (sss.startsWith(" DebitQty")) {
                    sss = sss.replaceAll(" DebitQty", " DebitStdQty");
                }
                if (sss.startsWith(" CreditQty")) {
                    sss = sss.replaceAll(" CreditQty", " CreditStdQty");
                }
                sql1.append("sum(case when fsourcetype=1 then 0 else ").append(sss).append(" end),");
                continue;
            }
            sql1.append("'").append(baseMuName).append("',");
        }
        for (i5 = 0; i5 < currencySize; ++i5) {
            if (displayAmount) {
                sql1.append("'").append(baseMuName).append("',");
                sql1.append("sum(IsNull(DebitQty_").append(i5).append(",0)),");
            }
            sql1.append("sum(IsNull(DebitFor_").append(i5).append(",0)),");
            sql1.append("sum(IsNull(DebitLocal_").append(i5).append(",0)),");
            if (displayAmount) {
                sql1.append("'").append(baseMuName).append("',");
                sql1.append("sum(IsNull(CreditQty_").append(i5).append(",0)),");
            }
            sql1.append("sum(IsNull(CreditFor_").append(i5).append(",0)),");
            sql1.append("sum(IsNull(CreditLocal_").append(i5).append(",0)),");
        }
        sql1.append("sum(IsNull(Debit_Sum,0)),");
        sql1.append("sum(IsNull(Credit_Sum,0)),");
        this.delLastChar(sql1);
        sql1.append(" \n from T_BD_Period P \n left join ").append(tempTableName).append(" TEMP on P.FID=TEMP.FPeriodID  and TEMP.no=0").append("\n where  P.FTypeID='").append(periodType).append("'").append("\n and ").append(SQLUtil.getPeriodCondition("P.fperiodYear", "P.fperiodNumber", periodRange)).append("\n group by P.FID,P.FPeriodYear,P.FPeriodNumber, P.FEndDate");
        try {
            this.executeUpdate(sql1.toString(), null, ctx);
        }
        catch (Exception e) {
            if (e instanceof BOSException && e.getCause() instanceof SQLException) {
                throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
            }
            throw (BOSException)((Object)e);
        }
        StringBuffer sql3 = new StringBuffer();
        SqlParams pp3 = new SqlParams();
        int pi3 = 1;
        sql3.append("select ");
        for (i4 = 0; i4 < mcItemSize; ++i4) {
            int dc = i4 < debitSize ? 1 : -1;
            for (int j = 0; j < currencySize; ++j) {
                currencyId = cc.get(j).getId().toString();
                String glCase = new StringBuffer().append("case when GL.FCurrencyId='").append(currencyId).append("' and (HG.").append(hgFieldName).append("='").append(((LabelValueBean)itemList.get(i4)).getValue()).append("' ").toString();
                if (actChild != null && actChild.get(((LabelValueBean)itemList.get(i4)).getValue()) != null) {
                    ArrayList al = (ArrayList)actChild.get(((LabelValueBean)itemList.get(i4)).getValue());
                    for (int ial = al.size() - 1; ial >= 0; --ial) {
                        glCase = glCase + " or HG." + hgFieldName + " = '" + al.get(ial) + "' ";
                    }
                }
                glCase = glCase + ") ";
                if (displayAmount) {
                    glField = new StringBuffer().append(" INIT_YearQty_").append(i4).append("_").append(j).toString();
                    sql3.append("\nsum(").append(glCase).append(" then IsNull(").append(dc).append("*(").append("GL.FYearDebitQty - GL.FDebitQty ").append("-(").append("GL.FYearCreditQty- GL.FCreditQty ").append(")),0) else 0 end) ").append(glField).append(",");
                }
                glField = new StringBuffer().append(" INIT_YearFor_").append(i4).append("_").append(j).toString();
                sql3.append("\nsum(").append(glCase).append(" then IsNull(").append(dc).append("*(").append(this.getSubcol(false, "Debit", "For")).append("-(").append(this.getSubcol(false, "Credit", "For")).append(")),0) else 0 end) ").append(glField).append(",");
                glField = new StringBuffer().append(" INIT_YearLocal_").append(i4).append("_").append(j).toString();
                sql3.append("\nsum(").append(glCase).append(" then IsNull(").append(dc).append("*(").append(this.getSubcol(false, "Debit", "Local")).append("-(").append(this.getSubcol(false, "Credit", "Local")).append(")),0) else 0 end) ").append(glField).append(",");
            }
        }
        this.delLastChar(sql3);
        sql3.append("\n from " + this.getAssistBalanceTable(ctx, false) + " GL ").append("\n inner join T_BD_Period P on P.FID=GL.FPeriodID ").append("\n inner join T_BD_AssistantHG HG on GL.FAssistGrpID=HG.FID ");
        sql3.append(" inner join t_bd_accountview c on c.fid=GL.FAccountID");
        sql3.append(" inner join t_bd_accounttype avt on c.FAccountTypeID = avt.fid");
        sql3.append(" inner join t_bd_systemstatusctrol b on GL.forgunitid=b.fcompanyid");
        sql3.append(" inner join t_bd_systemstatus d on d.fid=b.fsystemstatusid");
        sql3.append("\n where d.fname=6 and P.FTypeID=? and P.FPeriodYear=? and P.FPeriodNumber=? ").append("\n and GL.FBalType=? and GL.FOrgUnitID=? and ").append(this.getChildAcctID("GL.FAccountID"));
        pp3.setString(pi3++, periodType).setInt(pi3++, periodRange[0]).setInt(pi3++, periodRange[1]).setInt(pi3++, balType).setString(pi3++, companyId).setString(pi3++, accountId).setString(pi3++, companyId);
        sql3.append("\n and GL.FCurrencyID in (");
        for (i4 = 0; i4 < currencySize; ++i4) {
            currencyId = cc.get(i4).getId().toString();
            sql3.append("?,");
            pp3.setString(pi3++, currencyId);
        }
        this.delLastChar(sql3);
        sql3.append(")\n group by P.FID,P.FPeriodYear,P.FPeriodNumber, P.FBeginDate");
        RptRowSet initYear = null;
        try {
            initYear = this.executeQuery(sql3.toString(), pp3, ctx);
        }
        catch (Exception e) {
            if (e instanceof BOSException && e.getCause() instanceof SQLException) {
                throw new ReportBizException(ReportBizException.COLUMNTOMUCH, e, null);
            }
            throw (BOSException)((Object)e);
        }
        Object[] initValues = null;
        if (initYear.next()) {
            initValues = initYear.toArray()[0];
        } else {
            initValues = new Object[initYear.getColumnCount()];
            Arrays.fill(initValues, "0");
        }
        StringBuffer ss = new StringBuffer();
        ss.append("select ");
        for (int i15 = 0; i15 < currencySize; ++i15) {
            if (displayAmount) {
                ss.append("DebitQty_").append(i15).append(",");
            }
            ss.append("DebitFor_").append(i15).append(",");
            ss.append("DebitLocal_").append(i15).append(",");
            if (displayAmount) {
                ss.append("CreditQty_").append(i15).append(",");
            }
            ss.append("CreditFor_").append(i15).append(",");
            ss.append("CreditLocal_").append(i15).append(",");
        }
        ss.append("Debit_Sum,Credit_Sum").append("\nfrom ").append(tempTableName).append(" where no=-1");
        RptRowSet ssRst = this.executeQuery(ss.toString(), null, ctx);
        ssRst.next();
        sql3.setLength(0);
        sql3.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, bizDate,description, ");
        for (i3 = 0; i3 < mcItemSize; ++i3) {
            for (int j = 0; j < currencySize; ++j) {
                if (displayAmount) {
                    glField = new StringBuffer().append(i3 < debitSize ? " DebitMu_" : " CreditMu_").append(i3).append("_").append(j).toString();
                    sql3.append(glField).append(",");
                    glField = new StringBuffer().append(i3 < debitSize ? " DebitQty_" : " CreditQty_").append(i3).append("_").append(j).toString();
                    sql3.append(glField).append(",");
                }
                glField = new StringBuffer().append(i3 < debitSize ? " DebitFor_" : " CreditFor_").append(i3).append("_").append(j).toString();
                sql3.append(glField).append(",");
                glField = new StringBuffer().append(i3 < debitSize ? " DebitLocal_" : " CreditLocal_").append(i3).append("_").append(j).toString();
                sql3.append(glField).append(",");
            }
        }
        for (i3 = 0; i3 < currencySize; ++i3) {
            if (displayAmount) {
                sql3.append("DebitMu_").append(i3).append(",");
                sql3.append("DebitQty_").append(i3).append(",");
            }
            sql3.append("DebitFor_").append(i3).append(",");
            sql3.append("DebitLocal_").append(i3).append(",");
            if (displayAmount) {
                sql3.append("CreditMu_").append(i3).append(",");
                sql3.append("CreditQty_").append(i3).append(",");
            }
            sql3.append("CreditFor_").append(i3).append(",");
            sql3.append("CreditLocal_").append(i3).append(",");
        }
        sql3.append("Debit_Sum,Credit_Sum,");
        this.delLastChar(sql3);
        sql3.append(") \n select 2," + accountDc + ", GL1.FPeriodID,GL1.FPeriodYear,GL1.FPeriodNumber, GL1.BizDate, '" + GLResUtil.getRes("sum_year", ctx) + "', ");
        int initI = 0;
        for (int i16 = 0; i16 < mcItemSize; ++i16) {
            for (int j = 0; j < currencySize; ++j) {
                if (displayAmount) {
                    sql3.append("'").append(baseMuName).append("',");
                    glField = new StringBuffer().append(i16 < debitSize ? " GL2.DebitQty_" : " GL2.CreditQty_").append(i16).append("_").append(j).toString();
                    sql3.append("sum(IsNull(").append(glField).append(",0))+case when GL1.FPeriodYear=").append(periodRange[0]).append(" then IsNull(TO_DECIMAL(" + (initValues[initI] instanceof BigDecimal ? String.valueOf(((BigDecimal)initValues[initI]).doubleValue()) : initValues[initI]) + ",19,4),0) else 0 end,");
                    ++initI;
                }
                glField = new StringBuffer().append(i16 < debitSize ? " GL2.DebitFor_" : " GL2.CreditFor_").append(i16).append("_").append(j).toString();
                sql3.append("sum(IsNull(").append(glField).append(",0))+case when GL1.FPeriodYear=").append(periodRange[0]).append(" then ").append(initValues[initI++]).append(" else 0 end,");
                glField = new StringBuffer().append(i16 < debitSize ? " GL2.DebitLocal_" : " GL2.CreditLocal_").append(i16).append("_").append(j).toString();
                sql3.append("sum(IsNull(").append(glField).append(",0))+case when GL1.FPeriodYear=").append(periodRange[0]).append(" then ").append(initValues[initI++]).append(" else 0 end,");
            }
        }
        String bb = null;
        int ssi = 0;
        for (int i17 = 0; i17 < currencySize; ++i17) {
            if (displayAmount) {
                sql3.append("'").append(baseMuName).append("',");
                bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
                sql3.append("sum(IsNull(GL2.DebitQty_").append(i17).append(",0))").append(bb);
            }
            bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
            sql3.append("sum(IsNull(GL2.DebitFor_").append(i17).append(",0))").append(bb);
            bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
            sql3.append("sum(IsNull(GL2.DebitLocal_").append(i17).append(",0))").append(bb);
            if (displayAmount) {
                sql3.append("'").append(baseMuName).append("',");
                bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
                sql3.append("sum(IsNull(GL2.CreditQty_").append(i17).append(",0))").append(bb);
            }
            bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
            sql3.append("sum(IsNull(GL2.CreditFor_").append(i17).append(",0))").append(bb);
            bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
            sql3.append("sum(IsNull(GL2.CreditLocal_").append(i17).append(",0))").append(bb);
        }
        bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
        sql3.append("sum(IsNull(GL2.Debit_Sum,0))").append(bb);
        bb = "+ case when GL1.FPeriodYear=" + periodRange[0] + " then IsNull(TO_DECIMAL(" + RptServerUtil.bigdecimalToString(ssRst.getBigDecimal(ssi++)) + ",19,4),0) else 0 end,";
        sql3.append("sum(IsNull(GL2.Credit_Sum,0))").append(bb);
        this.delLastChar(sql3);
        sql3.append(" \nfrom ").append(tempTableName).append(" GL1 \ninner join ").append(tempTableName).append(" GL2 on GL1.FPeriodYear=GL2.FPeriodYear and GL1.no=GL2.no and GL1.no=1 ").append("\n where  GL2.FPeriodNumber<=GL1.FPeriodNumber ").append("\n group by  GL1.FPeriodID,GL1.FPeriodYear,GL1.FPeriodNumber, GL1.BizDate");
        this.executeUpdate(sql3.toString(), null, ctx);
        if (displayEndBalance) {
            StringBuffer sqleb = new StringBuffer();
            sqleb.append("insert into ").append(tempTableName).append("(no, ActDC, FPeriodID,FPeriodYear,FPeriodNumber, bizDate,description, ");
            int n3 = mcFieldList.size();
            for (int i18 = 0; i18 < n3; ++i18) {
                sqleb.append(mcFieldList.get(i18)).append(",");
            }
            sqleb.append("Debit_Sum,Credit_Sum,");
            this.delLastChar(sqleb);
            String endRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"487_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale());
            sqleb.append(") \n select 3," + accountDc + ", '',GL1.FPeriodYear,GL1.FPeriodNumber, GL1.BizDate, '" + endRes + "', ");
            n = mcFieldList.size();
            for (i2 = 0; i2 < n; ++i2) {
                if (!mcFieldList.get(i2).toString().startsWith(" CreditMu_") && !mcFieldList.get(i2).toString().startsWith(" DebitMu_")) {
                    sqleb.append("IsNull(GL1.").append(mcFieldList.get(i2)).append(",0) +\u3000IsNull(GL2.").append(mcFieldList.get(i2)).append(",0),\r\n");
                    continue;
                }
                sqleb.append("'").append(baseMuName).append("',");
            }
            sqleb.append("IsNull(GL1.Debit_Sum,0)+IsNull(GL2.Debit_Sum,0),\r\n");
            sqleb.append("IsNull(GL1.Credit_Sum,0)+IsNull(GL2.Credit_Sum,0)\r\n");
            sqleb.append("from \r\n(select max(GL11.BizDate) BizDate,");
            sqleb.append("GL11.FPeriodYear,GL11.FPeriodNumber,\r\n");
            n = mcFieldList.size();
            for (i2 = 0; i2 < n; ++i2) {
                if (mcFieldList.get(i2).toString().startsWith(" CreditMu_") || mcFieldList.get(i2).toString().startsWith(" DebitMu_")) continue;
                sqleb.append("sum(IsNull(GL22.").append(mcFieldList.get(i2)).append(",0)) ").append(mcFieldList.get(i2)).append(",");
            }
            sqleb.append("sum(IsNull(GL22.Debit_Sum,0)) Debit_Sum,");
            sqleb.append("sum(IsNull(GL22.Credit_Sum,0)) Credit_Sum,");
            this.delLastChar(sqleb);
            sqleb.append(" \n from ").append(tempTableName).append(" GL11 \ninner join ").append(tempTableName).append(" GL22 on 1=1 ").append("\n where  GL11.no=1 and GL22.no=0 and GL22.fperiodyear*100+ GL22.FPeriodNumber<= GL11.fperiodyear*100+GL11.FPeriodNumber  ").append("\n group by  GL11.FPeriodID ,GL11.FPeriodYear,GL11.FPeriodNumber ");
            sqleb.append(") GL1 \r\n").append(" inner join ").append(tempTableName).append(" GL2 on 1=1 ").append(" \r\nwhere GL2.no = -1");
            this.executeUpdate(sqleb.toString(), null, ctx);
        }
        StringBuffer sql5 = new StringBuffer();
        sql5.append("update ").append(tempTableName);
        sql5.append(" set Debit_Sum=");
        for (i = 0; i < currencySize; ++i) {
            sql5.append("DebitLocal_").append(i).append("+");
        }
        this.delLastChar(sql5);
        sql5.append(",\nCredit_Sum=");
        for (i = 0; i < currencySize; ++i) {
            sql5.append("CreditLocal_").append(i).append("+");
        }
        this.delLastChar(sql5);
        if (displayAmount) {
            if (baseMuName != null) {
                sql5.append(",\nBalance_mu = '").append(baseMuName).append("'");
            }
            for (i = 0; i < currencySize; ++i) {
                sql5.append(",\nDebitPrice_").append(i).append(" = case when DebitQty_").append(i).append(" = 0 then 0 else DebitLocal_").append(i).append("/DebitQty_").append(i).append(" end ");
            }
            for (i = 0; i < currencySize; ++i) {
                sql5.append(",\nCreditPrice_").append(i).append(" = case when CreditQty_").append(i).append(" = 0 then 0 else CreditLocal_").append(i).append("/CreditQty_").append(i).append(" end ");
            }
        }
        this.executeUpdate(sql5.toString(), null, ctx);
        if (displayAmount) {
            int j;
            StringBuffer sql7 = new StringBuffer();
            sql7.append("update ").append(tempTableName);
            sql7.append(" set \n");
            for (i2 = 0; i2 < mcItemSize; ++i2) {
                for (j = 0; j < currencySize; ++j) {
                    if (i2 < debitSize) {
                        sql7.append("\nDebitPrice_").append(i2).append("_").append(j).append("=").append(" case when DebitQty_").append(i2).append("_").append(j).append(" = 0 then 0 else DebitLocal_").append(i2).append("_").append(j).append("/DebitQty_").append(i2).append("_").append(j).append(" end ,");
                        continue;
                    }
                    sql7.append("\nCreditPrice_").append(i2).append("_").append(j).append("=").append(" case when CreditQty_").append(i2).append("_").append(j).append(" = 0 then 0 else CreditLocal_").append(i2).append("_").append(j).append("/CreditQty_").append(i2).append("_").append(j).append(" end ,");
                }
            }
            this.delLastChar(sql7);
            sql7.append("\n where no <> 0");
            this.executeUpdate(sql7.toString(), null, ctx);
            sql7.setLength(0);
            sql7.append("update ").append(tempTableName);
            sql7.append(" set \n");
            for (i2 = 0; i2 < mcItemSize; ++i2) {
                for (j = 0; j < currencySize; ++j) {
                    if (i2 < debitSize) {
                        sql7.append("\nDebitPrice_").append(i2).append("_").append(j).append("=").append(" case when DebitPrice_").append(i2).append("_").append(j).append(" > 0 then DebitPrice_").append(i2).append("_").append(j).append(" else -1*DebitPrice_").append(i2).append("_").append(j).append("  end ,");
                        continue;
                    }
                    sql7.append("\nCreditPrice_").append(i2).append("_").append(j).append("=").append(" case when CreditPrice_").append(i2).append("_").append(j).append(" > 0 then CreditPrice_").append(i2).append("_").append(j).append(" else -1*CreditPrice_").append(i2).append("_").append(j).append("  end ,");
                }
            }
            this.delLastChar(sql7);
            sql7.append("\n where no <> 0");
            this.executeUpdate(sql7.toString(), null, ctx);
        }
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update ").append(tempTableName).append(" set ");
        n = mcFieldList.size();
        for (i2 = 0; i2 < n; ++i2) {
            String fieldName = mcFieldList.get(i2).toString();
            if (fieldName.toLowerCase().trim().startsWith("creditqty")) {
                sqlUpdate.append(fieldName.toLowerCase().replaceFirst("creditqty", "CreditStdQty")).append(" = null,");
            } else if (fieldName.toLowerCase().trim().startsWith("debitqty")) {
                sqlUpdate.append(fieldName.toLowerCase().replaceFirst("debitqty", "DebitStdQty")).append(" = null,");
            }
            sqlUpdate.append(mcFieldList.get(i2)).append(" = null,");
        }
        this.delLastChar(sqlUpdate);
        sqlUpdate.append(" where FSourceType = 1");
        this.executeUpdate(sqlUpdate.toString(), null, ctx);
        ArrayList<Integer> hidemcField = new ArrayList<Integer>();
        if (noDisplayNoCol) {
            RptRowSet qcRst = null;
            StringBuffer sqlend = new StringBuffer();
            int hidemcIndex = -1;
            int forIndex = 0;
            if (displayAmount) {
                forIndex = 3;
            }
            for (int i19 = 0; i19 < mcItemSize; ++i19) {
                for (int j = 0; j < cc.size(); ++j) {
                    for (int k = 0; k < 2 + forIndex; ++k) {
                        ++hidemcIndex;
                        sqlend.setLength(0);
                        sqlend.append("select count(");
                        if (k == 0 + forIndex) {
                            if (i19 < debitSize) {
                                sqlend.append(" DebitFor_").append(i19).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditFor_").append(i19).append("_").append(j).toString();
                            }
                        } else if (k == 1 + forIndex) {
                            if (i19 < debitSize) {
                                sqlend.append(" DebitLocal_").append(i19).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditLocal_").append(i19).append("_").append(j).toString();
                            }
                        }
                        sqlend.append(")  hasdatacount from ").append(tempTableName).append(" where ");
                        if (k == 0 + forIndex) {
                            if (i19 < debitSize) {
                                sqlend.append(" DebitFor_").append(i19).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditFor_").append(i19).append("_").append(j).toString();
                            }
                        } else if (k == 1 + forIndex) {
                            if (i19 < debitSize) {
                                sqlend.append(" DebitLocal_").append(i19).append("_").append(j).toString();
                            } else {
                                sqlend.append(" CreditLocal_").append(i19).append("_").append(j).toString();
                            }
                        }
                        sqlend.append("  <> to_decimal(0.0,19,4) --is not null \n");
                        sqlend.append("  and voucherid is not null ");
                        if (!isQtyAsst && displayAmount && k == 0) {
                            hidemcField.add(new Integer(hidemcIndex));
                        }
                        if (k < forIndex || k > forIndex + 1) continue;
                        try {
                            qcRst = this.executeQuery(sqlend.toString(), null, ctx);
                            qcRst.next();
                            if (qcRst.getInt("hasdatacount") != 0) continue;
                            hidemcField.add(new Integer(hidemcIndex));
                            if (!displayAmount || k != 1 + forIndex) continue;
                            hidemcField.add(new Integer(hidemcIndex - 2));
                            hidemcField.add(new Integer(hidemcIndex - 3));
                            hidemcField.add(new Integer(hidemcIndex - 4));
                            continue;
                        }
                        catch (SQLDataException e) {
                            logger.error((Object)e);
                        }
                    }
                }
            }
        }
        if (hideOrigine) {
            int hidemcIndex = -1;
            for (int i20 = 0; i20 < mcItemSize; ++i20) {
                for (int j = 0; j < cc.size(); ++j) {
                    int k;
                    if (displayAmount) {
                        for (k = 0; k < 5; ++k) {
                            ++hidemcIndex;
                            if (k != 3) continue;
                            hidemcField.add(new Integer(hidemcIndex));
                        }
                        continue;
                    }
                    for (k = 0; k < 2; ++k) {
                        ++hidemcIndex;
                        if (k != 0) continue;
                        hidemcField.add(new Integer(hidemcIndex));
                    }
                }
            }
        }
        RptParams re = this.setHeaderAndReturn(debitList, creditList, sumFileldList, mcFieldList, hidemcField, company, mcItemSize, cc, accountView, tempTableName, displayAmount, hideOrigine, null, ctx);
        return re;
    }

    private String getChildAcctID(String pacctIDFilde) {
        StringBuffer ss = new StringBuffer();
        ss.append(" (");
        ss.append(pacctIDFilde).append(" in ( ");
        ss.append("\r\nselect childav.fid from T_BD_AccountView---\r\n childav inner join T_BD_AccountView---\r\n parentav ");
        ss.append("on charindex(parentav.FLongNumber ||'!',childav.FLongNumber ||\t '!') = 1 and CHILDAV.Fcompanyid = parentav.fcompanyid and CHILDAV.Faccounttableid = PARENTAV.Faccounttableid ");
        ss.append(" where parentav.fid = ? and childav.fcompanyid = ? and childav.fisleaf = 1 )");
        ss.append(" )");
        return ss.toString();
    }

    private void setMaxLevel(Context ctx, RptRowSet rs) {
        rs.reset();
        while (rs.next()) {
            try {
                RptRowSet levelRst;
                String levelSql;
                if (rs.getInt("FISLevel") != 1) continue;
                if (rs.getString("FGroupTableName") != null) {
                    levelSql = " select max(flevel) flevel from " + rs.getString("FGroupTableName");
                    levelRst = this.executeQuery(levelSql, null, ctx);
                    levelRst.next();
                    rs.setValue("FmaxLevel", (Object)new Integer(levelRst.getInt("flevel") + 1));
                    continue;
                }
                levelSql = " select max(flevel) flevel from " + rs.getString("frealtiondataobject");
                if (rs.getString("FGLAsstActTypeGrpID") != null) {
                    levelSql = levelSql + " where fgroupid='" + rs.getString("FGLAsstActTypeGrpID") + "'";
                }
                levelRst = this.executeQuery(levelSql, null, ctx);
                levelRst.next();
                rs.setValue("FmaxLevel", (Object)new Integer(levelRst.getInt("flevel")));
            }
            catch (Exception exception) {}
        }
    }

    private CurrencyCollection getCurrencyCollection(Context ctx, HashSet idSet, CompanyOrgUnitInfo company) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        CurrencyCollection cc = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(ev);
        CurrencyInfo c0 = cc.get(0);
        int n = cc.size();
        for (int i = 1; i < n; ++i) {
            CurrencyInfo ci = cc.get(i);
            if (!ci.getId().toString().equals(company.getBaseCurrency().getId().toString())) continue;
            cc.set(0, ci);
            cc.add(c0);
            break;
        }
        return cc;
    }

    @Override
    protected RptRowSet _queryAsstactMultiColumn(Context ctx, RptParams params) throws BOSException, ReportBizException, EASBizException {
        String tableName = params.getString("tempTableName");
        int from = params.getInt("from");
        int length = params.getInt("length");
        List queryFields = (List)params.getObject("queryFields");
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        int n = queryFields.size();
        for (int i = 0; i < n; ++i) {
            sql.append(queryFields.get(i)).append(',');
        }
        this.delLastChar(sql);
        sql.append("\nfrom ").append(tableName);
        sql.append("\n order by bizdate,FPeriodNumber,no,voucherTypeName");
        RptRowSet rst = this.executeQuery(sql.toString(), null, from, length, ctx);
        if (from == 0) {
            String countSql = "select count(1) from " + tableName;
            int count = this.executeQueryCount(countSql, null, ctx);
            rst.setVirtualRowCount(count);
        }
        while (rst.next()) {
            if (-1 != rst.getInt("no") || rst.getRow() == 0) continue;
            rst.moveRow(rst.getRow(), 0);
            break;
        }
        rst.reset();
        return rst;
    }

    private RptParams setHeaderAndReturn(List debitList, List creditList, List sumFileldList, List mcFieldList, List hidemcField, CompanyOrgUnitInfo company, int mcItemSize, CurrencyCollection cc, AccountViewInfo accountView, String tempTableName, boolean displayAmount, boolean hideOrigine, HashMap accountMap, Context ctx) throws BOSException, ReportBizException, EASBizException {
        int i;
        int i2;
        int m;
        boolean isQueryUpAccount;
        int currencySize = cc.size();
        int maxAccountLevel = -1;
        int minAccountLevel = -1;
        int uperAccountLevel = -1;
        boolean bl = isQueryUpAccount = accountMap == null ? false : (Boolean)accountMap.get("isAccountUpLevel");
        if (accountMap != null && isQueryUpAccount) {
            minAccountLevel = (Integer)accountMap.get("minAccountLevel");
            maxAccountLevel = (Integer)accountMap.get("maxAccountLevel");
            uperAccountLevel = maxAccountLevel - minAccountLevel;
        }
        KDTableHeaderModel hm = new KDTableHeaderModel();
        boolean hasDebit = debitList.size() > 0;
        boolean hasCredit = creditList.size() > 0;
        Object[][] currencyType = displayAmount ? new Object[][]{{ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx)}} : new Object[][]{{GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx)}};
        Object[][] currencyHead = new Object[][]{};
        Object[][] buf = null;
        String baseCurrencyId = company.getBaseCurrency().getId().toString();
        boolean hasBase = false;
        int baseCurrencyIndex = -1;
        int n = cc.size();
        for (int i3 = 0; i3 < n; ++i3) {
            CurrencyInfo ci = cc.get(i3);
            if (ci.getId().toString().equals(baseCurrencyId)) {
                buf = cc.size() == 1 && displayAmount ? CellMatrix.horizontalLevelProduct((Object[][])new Object[][]{{GLResUtil.getRes("money_amount", ctx)}}, (Object[][])new Object[][]{{ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("money_amount", ctx), GLResUtil.getRes("money_amount", ctx)}}) : (displayAmount ? CellMatrix.horizontalLevelProduct((Object[][])new Object[][]{{ci.getName()}}, (Object[][])new Object[][]{{ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ci.getName(), ci.getName()}}) : CellMatrix.horizontalLevelProduct((Object[][])new Object[][]{{ci.getName()}}, (Object[][])new Object[][]{{ci.getName(), ci.getName()}}));
                hasBase = true;
                baseCurrencyIndex = i3;
            } else {
                buf = CellMatrix.horizontalLevelProduct((Object[][])new Object[][]{{ci.getName()}}, (Object[][])currencyType);
            }
            currencyHead = CellMatrix.join((Object[][])currencyHead, (Object[][])buf);
        }
        Object[][] h1 = new Object[][]{{GLResUtil.getRes("date", ctx), GLResUtil.getRes("voucher_type_number", ctx), GLResUtil.getRes("abstract_description", ctx)}};
        Object[][] h6 = new Object[][]{{"No", "VoucherId", "FSourceType", "ActDC", "FPeriodID", "FPeriodYear", "FPeriodNumber"}};
        Object[][] h22 = new String[][]{{GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("dir_credit", ctx)}, {GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_debit", ctx)}};
        for (int i4 = 0; i4 < uperAccountLevel; ++i4) {
            String[][] h22t = new String[h22.length][h22[0].length + 1];
            for (int j = 0; j < h22.length; ++j) {
                h22t[j][0] = h22[j][0];
                for (int k = 0; k < h22[0].length; ++k) {
                    h22t[j][k + 1] = h22[j][k];
                }
            }
            h22 = h22t;
        }
        Object[][] h2 = CellMatrix.horizontalLevelProduct((Object[][])h22, (Object[][])CellMatrix.descartesProduct((Object[][])currencyHead, (Object[][])new Object[][]{{GLResUtil.getRes("total", ctx)}}));
        Object[][] h3 = null;
        h3 = displayAmount ? (hasBase && currencySize == 1 ? new Object[][]{{GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx)}, {ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}, {ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}, {ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}} : new Object[][]{{GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx)}, {GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx)}, {ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}, {ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"488_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"489_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"490_RptAsstactMultiColumnControllerBean", (Locale)ctx.getLocale()), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}}) : (hasBase && currencySize == 1 ? new Object[][]{{GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx)}, {GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}, {GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}, {GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}} : new Object[][]{{GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx)}, {hideOrigine ? GLResUtil.getRes("direction", ctx) : GLResUtil.getRes("balance", ctx), GLResUtil.getRes("balance", ctx)}, {GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}, {GLResUtil.getRes("direction", ctx), GLResUtil.getRes("money_amount", ctx)}});
        for (int i5 = 0; i5 < uperAccountLevel; ++i5) {
            h3 = CellMatrix.horizontalLevelProduct((Object[][])new Object[][]{{GLResUtil.getRes("balance", ctx)}}, (Object[][])h3);
        }
        Object[][] debit = new Object[][]{{GLResUtil.getRes("dir_debit", ctx)}};
        Object[][] h4 = new Object[debitList.size()][1];
        if (isQueryUpAccount && uperAccountLevel >= 1) {
            h4 = new Object[debitList.size()][uperAccountLevel + 1];
        }
        int n2 = h4.length;
        for (int i6 = 0; i6 < n2; ++i6) {
            h4[n2 - i6 - 1][0] = ((LabelValueBean)debitList.get(i6)).getLabel();
            if (!isQueryUpAccount) continue;
            String accountid = ((LabelValueBean)debitList.get(i6)).getValue();
            String accountLongNumber = (String)accountMap.get(accountid);
            if (accountMap.get(accountid + "hasChild") != null && "true".equals(accountMap.get(accountid + "hasChild"))) {
                h4[n2 - i6 - 1][0] = (String)h4[n2 - i6 - 1][0] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"86_AccountAgeUI", (Locale)ctx.getLocale());
            }
            for (int level = 1; level <= uperAccountLevel; ++level) {
                boolean hasFind = false;
                int nj = h4.length;
                for (int j = 0; j < nj; ++j) {
                    String upaccountid = ((LabelValueBean)debitList.get(j)).getValue();
                    String upaccountLongNumber = (String)accountMap.get(upaccountid);
                    if (!accountLongNumber.startsWith(upaccountLongNumber) || Integer.valueOf((String)accountMap.get(upaccountid + "level")) + level != maxAccountLevel) continue;
                    h4[n2 - i6 - 1][level] = ((LabelValueBean)debitList.get(j)).getLabel();
                    hasFind = true;
                    break;
                }
                if (hasFind) continue;
                h4[n2 - i6 - 1][level] = h4[n2 - i6 - 1][level - 1];
            }
        }
        if (isQueryUpAccount && uperAccountLevel >= 1) {
            Object[][] temp = null;
            try {
                temp = (Object[][])ObjectUtils.createCopy((Object)h4);
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)e);
            }
            for (int i7 = h4.length - 1; i7 >= 0; --i7) {
                int k = h4[0].length - 1;
                int j = 0;
                while (k >= 0) {
                    temp[i7][j] = h4[i7][k];
                    --k;
                    ++j;
                }
            }
            h4 = temp;
            h4 = CellMatrix.horizontalLevelProduct((Object[][])h4, (Object[][])currencyHead);
        } else {
            h4 = CellMatrix.horizontalLevelProduct((Object[][])h4, (Object[][])currencyHead);
        }
        h4 = CellMatrix.horizontalLevelProduct((Object[][])debit, (Object[][])h4);
        Object[][] credit = new Object[][]{{GLResUtil.getRes("dir_credit", ctx)}};
        Object[][] h5 = new Object[creditList.size()][1];
        if (isQueryUpAccount && uperAccountLevel >= 1) {
            h5 = new Object[creditList.size()][uperAccountLevel + 1];
        }
        int n3 = h5.length;
        for (int i8 = 0; i8 < n3; ++i8) {
            h5[n3 - i8 - 1][0] = ((LabelValueBean)creditList.get(i8)).getLabel();
            if (!isQueryUpAccount) continue;
            String accountid = ((LabelValueBean)creditList.get(i8)).getValue();
            String accountLongNumber = (String)accountMap.get(accountid);
            if (accountMap.get(accountid + "hasChild") != null && "true".equals(accountMap.get(accountid + "hasChild"))) {
                h5[n3 - i8 - 1][0] = (String)h5[n3 - i8 - 1][0] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"86_AccountAgeUI", (Locale)ctx.getLocale());
            }
            for (int level = 1; level <= uperAccountLevel; ++level) {
                boolean hasFind = false;
                int nj = h5.length;
                for (int j = 0; j < nj; ++j) {
                    String upaccountid = ((LabelValueBean)creditList.get(j)).getValue();
                    String upaccountLongNumber = (String)accountMap.get(upaccountid);
                    if (!accountLongNumber.startsWith(upaccountLongNumber) || Integer.valueOf((String)accountMap.get(upaccountid + "level")) + level != maxAccountLevel) continue;
                    h5[n3 - i8 - 1][level] = ((LabelValueBean)creditList.get(j)).getLabel();
                    hasFind = true;
                    break;
                }
                if (hasFind) continue;
                h5[n3 - i8 - 1][level] = h5[n3 - i8 - 1][level - 1];
            }
        }
        if (isQueryUpAccount && uperAccountLevel >= 1) {
            Object[][] temp = null;
            try {
                temp = (Object[][])ObjectUtils.createCopy((Object)h5);
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)e);
            }
            for (int i9 = h5.length - 1; i9 >= 0; --i9) {
                int k = h5[0].length - 1;
                int j = 0;
                while (k >= 0) {
                    temp[i9][j] = h5[i9][k];
                    --k;
                    ++j;
                }
            }
            h5 = temp;
            h5 = CellMatrix.horizontalLevelProduct((Object[][])h5, (Object[][])currencyHead);
        } else {
            h5 = CellMatrix.horizontalLevelProduct((Object[][])h5, (Object[][])currencyHead);
        }
        h5 = CellMatrix.horizontalLevelProduct((Object[][])credit, (Object[][])h5);
        Object[][] header = h1;
        header = CellMatrix.descartesProduct((Object[][])header, (Object[][])h2);
        header = CellMatrix.join((Object[][])header, (Object[][])h3);
        if (hasDebit) {
            header = CellMatrix.join((Object[][])header, (Object[][])h4);
        }
        if (hasCredit) {
            header = CellMatrix.join((Object[][])header, (Object[][])h5);
        }
        header = CellMatrix.join((Object[][])header, (Object[][])h6);
        ArrayList<Integer> hideFields = new ArrayList<Integer>();
        int preHideCount = 0;
        int dealFrom = preHideCount + 3;
        if (displayAmount) {
            if (hasBase && !hideOrigine) {
                m = dealFrom + baseCurrencyIndex * 2;
                hideFields.add(new Integer(m + 3));
                hideFields.add(new Integer(m + 3 + currencySize * 5 + 1));
                for (i2 = 0; i2 < mcItemSize; ++i2) {
                    m = dealFrom + (currencySize * 5 + 1) * 2 + 5 + currencySize * 5 * i2 + 4 + baseCurrencyIndex * 5;
                    hideFields.add(new Integer(m));
                }
            }
            if (hideOrigine) {
                for (i2 = 0; i2 < currencySize; ++i2) {
                    m = dealFrom + i2 * 5 + 3;
                    hideFields.add(new Integer(m));
                    m = dealFrom + i2 * 5 + 3 + 1 + currencySize * 5;
                    hideFields.add(new Integer(m));
                }
            }
            if (currencySize == 1) {
                m = dealFrom + currencySize * 5;
                hideFields.add(new Integer(m));
                hideFields.add(new Integer(m + currencySize * 5 + 1));
            }
        } else {
            if (hasBase && !hideOrigine) {
                m = dealFrom + baseCurrencyIndex * 2;
                hideFields.add(new Integer(m));
                hideFields.add(new Integer(m + currencySize * 2 + 1));
                for (i2 = 0; i2 < mcItemSize; ++i2) {
                    m = dealFrom + (currencySize * 2 + 1) * 2 + 2 + currencySize * 2 * i2 + baseCurrencyIndex * 5;
                    hideFields.add(new Integer(m));
                }
            }
            if (hideOrigine) {
                for (i2 = 0; i2 < currencySize; ++i2) {
                    m = dealFrom + i2 * 2;
                    hideFields.add(new Integer(m));
                    m = dealFrom + i2 * 2 + 1 + currencySize * 2;
                    hideFields.add(new Integer(m));
                }
            }
            if (currencySize == 1) {
                m = dealFrom + currencySize * 2;
                hideFields.add(new Integer(m));
                hideFields.add(new Integer(m + currencySize * 2 + 1));
            }
        }
        int size = header[0].length;
        hideFields.add(new Integer(size - 1));
        hideFields.add(new Integer(size - 2));
        hideFields.add(new Integer(size - 3));
        hideFields.add(new Integer(size - 4));
        hideFields.add(new Integer(size - 5));
        hideFields.add(new Integer(size - 6));
        hideFields.add(new Integer(size - 7));
        int[] hideIndexices = new int[hideFields.size() + hidemcField.size()];
        for (int i10 = 0; i10 < hideFields.size(); ++i10) {
            hideIndexices[i10] = (Integer)hideFields.get(i10);
        }
        int hidemcfrom = -1;
        hidemcfrom = displayAmount ? (hasBase ? dealFrom + ((currencySize * 5 + 1) * 2 + 5) + baseCurrencyIndex * 2 : dealFrom + ((currencySize * 5 + 1) * 2 + 5)) : (hasBase ? dealFrom + ((currencySize * 2 + 1) * 2 + 2) + baseCurrencyIndex * 2 : dealFrom + ((currencySize * 2 + 1) * 2 + 2));
        for (int i11 = 0; i11 < hidemcField.size(); ++i11) {
            hideIndexices[i11 + hideFields.size()] = (Integer)hidemcField.get(i11) + hidemcfrom;
        }
        hm.setHiddenColumnIndexices(hideIndexices);
        if (currencySize == 1) {
            header = uperAccountLevel > 0 ? (hasBase && !displayAmount ? CellMatrix.removeRows((Object[][])header, (int[])new int[]{2 + uperAccountLevel, 3 + uperAccountLevel}) : (hideOrigine && !displayAmount ? CellMatrix.removeRows((Object[][])header, (int[])new int[]{2 + uperAccountLevel, 3 + uperAccountLevel}) : CellMatrix.removeRows((Object[][])header, (int[])new int[]{2 + uperAccountLevel}))) : (hasBase && !displayAmount ? CellMatrix.removeRows((Object[][])header, (int[])new int[]{2, 3}) : (hideOrigine && !displayAmount ? CellMatrix.removeRows((Object[][])header, (int[])new int[]{2, 3}) : CellMatrix.removeRows((Object[][])header, (int[])new int[]{2})));
        }
        header = CellMatrix.convert((Object[][])header, (boolean)true);
        hm.setData((String[][])header);
        hm.setMergedRegionList(CellMatrix.parseAutoMatchMergeRegion((Object[][])header));
        int[] w = new int[header[0].length];
        for (i = 0; i < w.length; ++i) {
            w[i] = 100;
        }
        for (i = 0; i < hideIndexices.length; ++i) {
            w[hideIndexices[i]] = -1;
        }
        int m2 = dealFrom + (currencySize * 2 + 1) * 2;
        if (displayAmount) {
            m2 += 9;
        }
        w[m2] = 40;
        hm.setColumnWidths(w);
        RptParams re = new RptParams();
        re.setObject("header", (Object)hm);
        re.setString("tempTableName", tempTableName);
        re.setInt("dealFrom", dealFrom);
        re.setInt("currencySize", currencySize);
        re.setInt("preHideCount", preHideCount);
        re.setInt("mcItemSize", mcItemSize);
        re.setObject("accountView", (Object)accountView);
        int[] currencysScale = new int[cc.size()];
        int n4 = cc.size();
        for (int i12 = 0; i12 < n4; ++i12) {
            currencysScale[i12] = cc.get(i12).getPrecision();
        }
        re.setObject("currencysScale", (Object)currencysScale);
        ICurrency info = CurrencyFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
        CurrencyInfo counteryInfo = info.getCurrencyInfo((IObjectPK)pk);
        re.setObject("baseCurrencyScale", (Object)new Integer(counteryInfo.getPrecision()));
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("bizDate");
        queryFields.add("voucherTypeName");
        queryFields.add("description");
        queryFields.addAll(sumFileldList);
        queryFields.addAll(mcFieldList);
        queryFields.add("no");
        queryFields.add("voucherId");
        queryFields.add("FSourceType");
        queryFields.add("ActDC");
        queryFields.add("FPeriodId");
        queryFields.add("FPeriodYear");
        queryFields.add("FPeriodNumber");
        re.setObject("queryFields", queryFields);
        return re;
    }

    protected String getAccountBalanceTable(Context ctx, boolean includeNoTransPLVoucher) {
        if (includeNoTransPLVoucher) {
            return GLBalanceUtils.getAccountBalanceTable(5) + " ";
        }
        return GLBalanceUtils.getAccountBalanceTable(5) + " ";
    }

    protected String getAssistBalanceTable(Context ctx, boolean includeNoTransPLVoucher) {
        if (includeNoTransPLVoucher) {
            return "V_gl_assistbalancenoPL ";
        }
        return GLBalanceUtils.getAssistBalanceTable(5) + " ";
    }

    protected String getGovAsstactDetailJoinTable(Context ctx, RptParams params) {
        return null;
    }

    protected String getGovAsstactDetailFilter(Context ctx, RptParams params) {
        return null;
    }

    protected String getGovAccountDetailJoinTable(Context ctx, RptParams params) {
        return null;
    }

    protected String getGovAccountDetailFilter(Context ctx, RptParams params) {
        return null;
    }
}

