/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.app.AbstractRptBaseControllerBean;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptBaseControllerBean
extends AbstractRptBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptBaseControllerBean");
    private static final long serialVersionUID = 2556107910940349376L;
    public static final int CURRENCY_TYPE_ORIGINAL = 0;
    public static final int CURRENCY_TYPE_LOCAL = 1;
    public static final int CURRENCY_TYPE_REPORT = 2;

    @Override
    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        String companyId = company.getId().toString();
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        CurrencyCollection cc = this._getAllCurrency(ctx);
        initMap.put("getAllCurrency", cc);
        initMap.put("getCurrencyScaleMap", this._getCurrencyScaleMap(ctx, cc, company));
        initMap.put("getMaxGroupControlAccountLevel", new Integer(this._getMaxGroupControlAccountLevel(ctx, companyId)));
        initMap.put("getMaxAccountLevel", new Integer(AccountUtils.getMaxAccountLeve((Context)ctx, (IObjectPK)new ObjectUuidPK(company.getId()))));
        initMap.put("getSystemParams", this.getSystemParams(ctx, companyId));
        initMap.put("periodRange", this._getPeriodRange(ctx, company));
        return initMap;
    }

    public static boolean isGeneralLocalCurrency(String currencyId) {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId);
    }

    public static boolean isGeneralReportCurrency(String currencyId) {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId);
    }

    public static int getCurrencyType(String currencyId) {
        if (RptBaseControllerBean.isGeneralLocalCurrency(currencyId)) {
            return 1;
        }
        if (RptBaseControllerBean.isGeneralReportCurrency(currencyId)) {
            return 2;
        }
        return 0;
    }

    protected RptParams getSystemParams(Context ctx, String companyId) throws BOSException {
        ObjectUuidPK comPk = new ObjectUuidPK(companyId);
        RptParams pp = new RptParams();
        pp.setObject("G001", null);
        pp.setObject("GL_004", (Object)comPk);
        pp.setObject("GL_005", (Object)comPk);
        pp.setObject("GL_006", (Object)comPk);
        pp.setObject("GL_009", (Object)comPk);
        pp.setObject("GL_012", (Object)comPk);
        pp.setObject("GL_002", (Object)comPk);
        pp.setObject("GL_003", (Object)comPk);
        pp.setObject("GL_008", (Object)comPk);
        pp.setObject("G000", null);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
            return RptParams.parseFrom((Map)allParam);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void close(Connection con) {
        this.close(con, null, null);
    }

    public void close(Statement statement) {
        this.close(null, statement, null);
    }

    public void close(ResultSet rs) {
        this.close(null, null, rs);
    }

    public void close(Connection con, ResultSet rs) {
        this.close(con, null, rs);
    }

    public void close(Connection con, Statement statement) {
        this.close(con, statement, null);
    }

    public void close(Connection con, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)from, (int)length, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)from, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected int executeQueryCount(String countSql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rst = DBUtil.executeQuery((String)countSql, (SqlParams)parameters, (Connection)con);
            rst.next();
            int n = rst.getInt(0);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + countSql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected int executeUpdate(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            int n = DBUtil.executeUpdate((String)sql, (SqlParams)parameters, (Connection)con);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected CreateTempTableResult executeSelectInto(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            CreateTempTableResult createTempTableResult = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql, (SqlParams)parameters, (Connection)con);
            return createTempTableResult;
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
        finally {
            this.close(con);
        }
    }

    protected boolean clearTable(String tableName, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            boolean bl = DBUtil.clearTable((String)tableName, (Connection)con);
            return bl;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("clear table sql: " + tableName));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    @Override
    protected void _clearTableData(Context ctx, String tableName) throws BOSException {
        this._executeUpdate(ctx, "delete from " + tableName);
    }

    @Override
    protected String _createTable(Context ctx, String sql) throws BOSException {
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _dropTable(Context ctx, String tableName) throws BOSException {
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int _getRecordCount(Context ctx, String countSql, SqlParameter2 parameters) throws BOSException {
        Connection con = this.getConnection(ctx);
        PreparedStatement countPs = null;
        ResultSet rs = null;
        try {
            countPs = con.prepareStatement(countSql);
            if (parameters != null) {
                parameters.putToStatement(countPs);
            }
            rs = countPs.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + countSql.toString()));
            throw new SQLDataException(e);
        }
        finally {
            this.close(countPs);
            this.close(con, rs);
        }
    }

    @Override
    protected RptRowSet _executeQuery(Context ctx, String sql) throws BOSException {
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement(1004, 1007);
            rs = ps.executeQuery(sql);
            RptRowSet rptRowSet = RptRowSet.parse((ResultSet)rs);
            this.close(con, ps, rs);
            return rptRowSet;
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute query: " + sql));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                this.close(con, ps, rs);
                throw throwable;
            }
        }
    }

    protected RptRowSet _executeQuery(Context ctx, String sql, SqlParameter2 parameter, boolean addTop, int from, int length) throws BOSException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = addTop ? con.prepareStatement(SQLUtil.applyTopLimit(sql, from + length), 1004, 1007) : con.prepareStatement(sql, 1004, 1007);
            if (parameter != null) {
                parameter.putToStatement(ps);
            }
            rs = ps.executeQuery();
            RptRowSet rptRowSet = RptRowSet.parse((ResultSet)rs, (int)from, (int)length);
            this.close(con, ps, rs);
            return rptRowSet;
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute query: " + sql));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                this.close(con, ps, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int _executeUpdate(Context ctx, String sql) throws BOSException {
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = ps.executeUpdate(sql);
            this.close(con, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute update: " + sql));
                throw new SQLDataException(e);
                catch (Exception e2) {
                    int n = 1;
                    this.close(con, ps);
                    return n;
                }
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                ps.addBatch(sqls[i]);
            }
            int[] i = ps.executeBatch();
            this.close(con, ps);
            return i;
        }
        catch (SQLException e) {
            try {
                if (ps != null) {
                    e.setNextException(new SQLException("Execute batch update: " + ps));
                }
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
    }

    @Override
    protected String _getTemporaryTableName(Context ctx) throws BOSException {
        return "glTemptable";
    }

    @Override
    protected void _selectIntoTable(Context ctx, String selectIntoSql, boolean createTable) throws BOSException {
        String tableName = SQLUtil.parseSelectIntoTableName(selectIntoSql);
        String selectAllSql = SQLUtil.transSelectIntoToSelectTopSql(selectIntoSql, 0);
        Connection con = this.getConnection(ctx);
        Statement smt = null;
        ResultSet rs = null;
        try {
            smt = con.createStatement();
            rs = smt.executeQuery(selectAllSql);
            ResultSetMetaData rsm = rs.getMetaData();
            if (createTable) {
                String createSql = SQLUtil.buildCreateTableString(tableName, rsm);
                this.createTable(ctx, createSql);
            }
            this.close(smt);
            String insertSql = SQLUtil.applySelectIntoTableSql(tableName, SQLUtil.transSelectIntoToSelectTopSql(selectIntoSql, -1));
            smt = con.createStatement();
            smt.executeUpdate(insertSql);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("Execute select into sql: " + selectIntoSql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con, smt, rs);
        }
    }

    @Override
    protected CurrencyCollection _getAllCurrency(Context ctx) throws BOSException, ReportBizException {
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        return currency.getCurrencyCollection(view);
    }

    @Override
    protected Map _getCurrencyScaleMap(Context ctx, CurrencyCollection currencys, CompanyOrgUnitInfo company) throws BOSException, ReportBizException {
        HashMap<String, Integer> scaleMap = new HashMap<String, Integer>();
        CurrencyInfo baseCurrencyInfo = company.getBaseCurrency();
        scaleMap.put(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), new Integer(baseCurrencyInfo == null ? 0 : baseCurrencyInfo.getPrecision()));
        CurrencyInfo reportCurrencyInfo = company.getReportCurrency();
        scaleMap.put(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), new Integer(reportCurrencyInfo == null ? 0 : reportCurrencyInfo.getPrecision()));
        if (currencys != null && currencys.size() != 0) {
            for (int i = 0; i < currencys.size(); ++i) {
                CurrencyInfo tmpCurrencyInfo = currencys.get(i);
                scaleMap.put(tmpCurrencyInfo.getId().toString(), new Integer(tmpCurrencyInfo.getPrecision()));
            }
        }
        return scaleMap;
    }

    @Override
    protected int _getMaxGroupControlAccountLevel(Context ctx, String companyId) throws BOSException, ReportBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        try {
            int maxLevel = AccountUtils.getMaxGroupControlAccountLeve((Context)ctx, (IObjectPK)pk);
            return maxLevel > 0 ? maxLevel : 100;
        }
        catch (EASBizException e) {
            throw new ReportBizException(ReportBizException.GET_MAX_GROUPCONTROL_ACCOUNTLEVEL_FAILED, e);
        }
    }

    @Override
    protected int _getMaxAccountLevel(Context ctx, String companyId) throws BOSException, ReportBizException {
        try {
            return AccountUtils.getMaxAccountLeve((Context)ctx, (IObjectPK)new ObjectUuidPK(companyId));
        }
        catch (EASBizException e) {
            throw new ReportBizException(ReportBizException.GET_MAX_ACCOUNT_LEVEL_FAILED, e);
        }
    }

    @Override
    protected String _getLocaleString(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected Map _getPeriodRange(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        return CommRptBaseFactory.getLocalInstance((Context)ctx).getPeriodRange(company);
    }

    @Override
    protected CompanyOrgUnitInfo _getCurrentCompany(Context ctx) throws BOSException, ReportBizException, EASBizException {
        return ContextUtil.getCurrentFIUnit((Context)ctx);
    }

    @Override
    protected PeriodInfo _getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        return pi;
    }

    @Override
    protected PeriodInfo _getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        return pi;
    }

    @Override
    protected Map _getPeriodRangeNormal(Context ctx, int type, PeriodInfo startPeriod, PeriodInfo currentPeriod, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && startPeriod != null) {
            sql.append(" AND (TP.FPeriodYear>? or (TP.FPeriodYear=?  and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            sql.append(" AND (TP.FPeriodYear<? or(TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueId((CoreBaseInfo)company.getAccountPeriodType());
        if ((type == 1 || type == 3) && startPeriod != null) {
            parameter.addValue(startPeriod.getPeriodYear());
            parameter.addValue(startPeriod.getPeriodYear());
            parameter.addValue(startPeriod.getPeriodNumber());
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            parameter.addValue(currentPeriod.getPeriodYear());
            parameter.addValue(currentPeriod.getPeriodYear());
            parameter.addValue(currentPeriod.getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParameters(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < startPeriod.getPeriodYear() || yearRange[1] > currentPeriod.getPeriodYear() || map.size() <= 0) {
                throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
            }
            HashMap<Integer, int[]> hashMap = map;
            this.close(con, stmt, rs);
            return hashMap;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, rs);
                throw throwable;
            }
        }
    }

    @Override
    protected Map _getPeriodRangeUnion(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        HashMap<Integer, int[]> hashMap;
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \t\t\t\t\t\t\t\r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \t\t\t\t\t\t\t\r\n");
        sql.append("FROM T_BD_Period TP ,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("(SELECT Min(TPS.FBeginDate) FBeginDate, \t\t\t\t\t\t\r\n");
        sql.append("\t\tMin(TPC.FEndDate) FEndDate\t\t\t\t\t \t\t\t\r\n");
        sql.append(" FROM T_BD_SystemStatusCtrol TSSC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tinner join t_bd_systemstatus tsst \r\n");
        sql.append(" on TSSC.FSystemStatusID=tsst.fid and TSST.fname=?\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPS\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FStartPeriodID = TPS.FID \t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPC\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCurrentPeriodID = TPC.FID\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_BaseUnit TC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = TC.FID\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SC \t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = SC.FUnitId\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SP\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON CHARINDEX(SP.FLongNumber||'!',SC.FLongNumber) = 1\t\t\r\n");
        sql.append("\tinner join t_org_company cc on cc.fid=sc.funitId and cc.fisOnlyUnion=0 and cc.fIsCompanyOrgUnit=1 \r\n");
        sql.append(" WHERE SP.FUnitId = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPS.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPC.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t) TPRange\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("WHERE TP.FBeginDate >= TPRange.FBeginDate\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FEndDate <= TPRange.FEndDate\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("GROUP BY TP.FPeriodYear\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("ORDER BY TP.FPeriodYear \t\t\t\t\t\t\t\t\t\t\r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValue(6);
        parameter.addValueChar(company.getId().toString());
        parameter.addValueChar(company.getAccountPeriodType().getId().toString());
        parameter.addValueChar(company.getAccountPeriodType().getId().toString());
        parameter.addValueChar(company.getAccountPeriodType().getId().toString());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParameters(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new ReportException(ReportException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || map.size() <= 0) {
                throw new ReportException(ReportException.PERIOD_ERROR);
            }
            hashMap = map;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    protected String getAllParentCuIdList(String companyId, Context ctx) throws BOSException, ReportBizException, EASBizException {
        String sql = "select A.FID from t_org_baseUnit A, t_org_baseUnit B \nwhere A.FIsCU=1 and B.FID='" + companyId + "' and charindex(A.FLongNumber||'!',B.FLongNumber)=1";
        RptRowSet rst = this.executeQuery(sql, null, ctx);
        StringBuffer sb = new StringBuffer();
        while (rst.next()) {
            sb.append('\'').append(rst.getString(0)).append("',");
        }
        sb.append('\'').append(companyId).append('\'');
        return sb.toString();
    }

    @Override
    protected IObjectCollection _getAccountViewCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
    }
}

