/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;

public class ServerUtils {
    private static String resClassName = "com.kingdee.eas.fi.gl.GLResource";

    public static CompanyOrgUnitInfo getDefaultCompany(Context ctx, String companyId, String permissionName) throws BOSException, EASBizException, GLException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        CompanyOrgUnitInfo company = null;
        if (StringUtils.isEmpty((String)companyId)) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (!company.isIsBizUnit()) {
                throw new GLException(GLException.COMMUSTBEENTITY);
            }
            if (company.getAccountTable() == null) {
                throw new GLException(GLException.NO_ACCOUNTTABLE);
            }
            if (company.getAccountPeriodType() == null) {
                throw new GLException(GLException.NOPERIODTYPE);
            }
            if (company.isIsSealUp()) {
                throw new VoucherException(VoucherException.NO_MSG, new String[]{EASResource.getString((String)resClassName, (String)"sealed_org_un_addable")});
            }
            if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(company.getId()), permissionName)) {
                throw new GLException(GLException.NO_PERMISSON, new String[]{ServerUtils.getPermItemName(ctx, permissionName)});
            }
            BOSUuid cuId = company.getCU().getId();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
            company.setCU(cu);
        } else {
            String[] companyIds = companyId.split(",");
            if (PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(companyIds[0]), permissionName)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("CU.id"));
                sic.add(new SelectorItemInfo("CU.number"));
                sic.add(new SelectorItemInfo("CU.name"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("isSealUp"));
                sic.add(new SelectorItemInfo("accountPeriodType.id"));
                sic.add(new SelectorItemInfo("baseCurrency.id"));
                sic.add(new SelectorItemInfo("reportCurrency.id"));
                sic.add(new SelectorItemInfo("baseExchangeTable.id"));
                sic.add(new SelectorItemInfo("reportExchangeTable.id"));
                sic.add(new SelectorItemInfo("reportConvertMode"));
                sic.add(new SelectorItemInfo("accountTable.id"));
                sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
                if (!BOSUuid.isValid((String)companyIds[0], (boolean)true)) {
                    throw new IllegalArgumentException("parameter is [" + companyIds[0] + "]");
                }
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyIds[0]), sic);
                if (company.isIsBizUnit() && !company.isIsSealUp() && company.getAccountTable() != null) {
                    return company;
                }
            }
            StringBuffer filterSql = new StringBuffer();
            for (int i = 0; i < companyIds.length; ++i) {
                if (StringUtils.isEmpty((String)companyIds[i])) continue;
                if (!BOSUuid.isValid((String)companyIds[i], (boolean)true)) {
                    throw new IllegalArgumentException("parameter is [" + companyIds[i] + "]");
                }
                if (filterSql.length() > 0) {
                    filterSql.append(",");
                }
                filterSql.append("'").append(companyIds[i]).append("'");
            }
            company = GLGeneralFacadeFactory.getLocalInstance(ctx).getFirstCompany(permissionName, " and cp.fid in (" + filterSql.toString() + ")");
            if (company == null && (company = GLGeneralFacadeFactory.getLocalInstance(ctx).getFirstCompany(permissionName)) == null) {
                throw new GLException(GLException.NO_PERMISSON, new String[]{ServerUtils.getPermItemName(ctx, permissionName)});
            }
        }
        return company;
    }

    private static String getPermItemName(Context ctx, String permission) throws EASBizException, BOSException {
        return PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfoByNumber(permission).getAlias();
    }
}

