/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class SmartAccountCleanReportJob
implements StatefulJob {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.SmartAccountCleanReportJob");
    private static final String mutexFlag = "GL-SmartAccountReportClean-11111111";

    public void execute(JobExecutionContext jctx) throws JobExecutionException {
        JobDetail jobDetail = jctx.getJobDetail();
        Vector ctxs = (Vector)jobDetail.getJobDataMap().get((Object)"ctxs");
        int remainDays = jobDetail.getJobDataMap().getInt("remainDays");
        logger.error((Object)("smart account report clean remain Day:" + remainDays));
        if (remainDays <= 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, remainDays * -1);
        Timestamp remainDate = new Timestamp(calendar.getTime().getTime());
        logger.error((Object)("smart account clean report data remain time:" + calendar.getTime()));
        IMutexServiceControl mutextService = null;
        boolean lock = false;
        Context lockCtx = null;
        for (int i = 0; i < ctxs.size(); ++i) {
            Context ctx = (Context)ctxs.get(i);
            lockCtx = lockCtx == null ? ctx : lockCtx;
            try {
                if (!lock) {
                    mutextService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                    lock = mutextService.requestObjIDForUpdate(ctx, mutexFlag);
                }
                if (!lock) break;
                logger.error((Object)"SmartAccountReportClean start...");
                long start = System.currentTimeMillis();
                this.smartAccountCleanReport(ctx, remainDate);
                logger.error((Object)("smart report clean cost:" + (System.currentTimeMillis() - start) / 1000L + ",dc:" + ctx.getAIS()));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("SmartAccount [dc:" + ctx.getAIS() + "] repair error!"), (Throwable)e);
            }
        }
        if (mutextService != null && lockCtx != null && lock) {
            mutextService.releaseObjIDForUpdate(lockCtx, mutexFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smartAccountCleanReport(Context ctx, Timestamp remainDate) throws SQLException {
        Connection conn = null;
        PreparedStatement dertailRptStatement = null;
        PreparedStatement reportStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String cleanSql1 = "DELETE FROM t_vc_smartaccountingdetailrpt WHERE fid in (SELECT a.fid FROM t_vc_smartaccountingdetailrpt a inner join t_vc_smartaccountingreport b on a.freportid = b.fid where b.FEXESTARTTIME<=?)";
            dertailRptStatement = conn.prepareStatement(cleanSql1);
            dertailRptStatement.setTimestamp(1, remainDate);
            dertailRptStatement.execute();
            String cleanSql2 = "DELETE FROM t_vc_smartaccountingreport where FCOMPANYID = ? and FEXESTARTTIME<=?";
            reportStatement = conn.prepareStatement(cleanSql2);
            List<String> smartAccountCompanys = this.getSmartAccountCompanys(ctx);
            int count = 0;
            for (String companyId : smartAccountCompanys) {
                reportStatement.setString(1, companyId);
                reportStatement.setTimestamp(2, remainDate);
                reportStatement.addBatch();
                if (++count % 1000 != 0) continue;
                reportStatement.executeBatch();
                count = 0;
                reportStatement.clearBatch();
            }
            if (count > 0) {
                reportStatement.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(dertailRptStatement, (Connection)conn);
            SQLUtils.cleanup(reportStatement, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)dertailRptStatement, (Connection)conn);
        SQLUtils.cleanup((Statement)reportStatement, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSmartAccountCompanys(Context ctx) throws SQLException {
        Connection conn = null;
        Statement statement = null;
        ArrayList<String> companyIds = new ArrayList<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            String sql = "SELECT distinct FCOMPANYID FROM T_VC_SMARTACCOUNTINGREPORT";
            ResultSet result = statement.executeQuery(sql);
            while (result.next()) {
                companyIds.add(result.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return companyIds;
    }
}

