/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.eas.fi.gl.app.GLQuartzJob;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class SmartAccountRepairJob
extends GLQuartzJob
implements StatefulJob {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.BalanceRepairJob");

    public void execute(JobExecutionContext jctx) throws JobExecutionException {
        logger.error((Object)"SmartAccountRepairJob trigger ...");
        JobDetail jobDetail = jctx.getJobDetail();
        Vector ctxs = (Vector)jobDetail.getJobDataMap().get((Object)"ctxs");
        Date nowDate = (Date)jobDetail.getJobDataMap().get((Object)"nowDate");
        Timestamp nowTime = new Timestamp(nowDate.getTime());
        for (int i = 0; i < ctxs.size(); ++i) {
            Context ctx = (Context)ctxs.get(i);
            if (!this.isContextUsable(ctx, "SmartAccount repair error,")) continue;
            logger.error((Object)("SmartAccount [dc:" + ctx.getAIS() + "] repair start."));
            try {
                this.smartAccountRepair(ctx, nowTime);
                logger.error((Object)("SmartAccount [dc:" + ctx.getAIS() + "] repair end."));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("SmartAccount [dc:" + ctx.getAIS() + "] repair error!"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smartAccountRepair(Context ctx, Timestamp nowTime) throws Exception {
        String instanceId = Configuration.instanceId();
        String result = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"stopSeverError", (Locale)ctx.getOriginLocale());
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String repairSql = "update T_VC_SMARTACCOUNTINGREPORT set FSTATUS = 2,FRESULT=? where FSMARTACCOUNTINGID in ( SELECT distinct sm.FID FROM T_VC_SMARTACCOUNTINGSCHEMA sm  inner join T_VC_SMARTACCOUNTSCHEDULE sd on sm.FID = sd.FSMARTACCOUNTID inner join T_JOB_INST job on job.FJOBDEFID = sd.fjobdefid where sm.FSTATUS = 1 and sm.FISDELETED =0 and sd.fjobdefid is not null  and job.FHOLDERID=?) and fstatus in (0,1) and FEXESTARTTIME<?";
            statement = conn.prepareStatement(repairSql);
            statement.setString(1, result);
            statement.setString(2, instanceId);
            statement.setTimestamp(3, nowTime);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }
}

