/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriodType;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.AssistantOrgFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAssistantOrgFacade;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountRuleCollection;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.AccountRuleInfo;
import com.kingdee.eas.fi.books.AcountSchemeCollection;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.BookTypeEnum;
import com.kingdee.eas.fi.books.IAccountRule;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.fi.books.RuleEnum;
import com.kingdee.eas.fi.books.VoucherStatusEnum;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.app.AbstractSmartGenerateBooksFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SmartGenerateBooksFacadeControllerBean
extends AbstractSmartGenerateBooksFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.SmartGenerateBooksFacadeControllerBean");

    @Override
    protected Map _generateBooks(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String companyNumber = (String)params.get("companyNumber");
        if (StringUtils.isEmpty((String)companyNumber)) {
            return null;
        }
        String accountSchemeNumber = (String)params.get("accountSchemeNumber");
        if (StringUtils.isEmpty((String)accountSchemeNumber)) {
            return null;
        }
        String accountSchemeName = (String)params.get("accountSchemeName");
        if (StringUtils.isEmpty((String)accountSchemeName)) {
            return null;
        }
        String localCurrencyName = (String)params.get("localCurrencyName");
        String accountPeriodType = (String)params.get("accountPeriodType");
        String isNewAccountSchemeStr = (String)params.get("isNewAccountScheme");
        boolean isNewAccountScheme = "true".equals(isNewAccountSchemeStr);
        if (isNewAccountScheme && (StringUtils.isEmpty((String)accountPeriodType) || StringUtils.isEmpty((String)localCurrencyName))) {
            return null;
        }
        String[] companyNumberArr = companyNumber.split(",");
        HashSet<String> companyNumberSet = new HashSet<String>(Arrays.asList(companyNumberArr));
        CompanyOrgUnitCollection companyColl = this.getCompanyCollByNumberArr(ctx, companyNumberSet);
        for (int i = 0; i < companyColl.size(); ++i) {
            String number = companyColl.get(i).getNumber();
            if (!companyNumberSet.contains(number)) continue;
            companyNumberSet.remove(number);
        }
        if (companyNumberSet != null && companyNumberSet.size() != 0) {
            result.put("status", "fail");
            result.put("msg", "\u627e\u4e0d\u5230\u7ec4\u7ec7\u7f16\u7801\uff1a" + ((Object)companyNumberSet).toString() + "\uff0c\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u7f16\u7801\u8f93\u5165\u6b63\u786e");
            return result;
        }
        int notBizCount = 0;
        int bizCount = 0;
        for (int i = 0; i < companyColl.size() && notBizCount <= 1 && (bizCount <= 0 || notBizCount <= 0); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            if (!company.isIsBizUnit()) {
                ++notBizCount;
                continue;
            }
            ++bizCount;
        }
        if (bizCount > 0 && notBizCount > 0) {
            result.put("status", "fail");
            result.put("msg", "\u4e0d\u5141\u8bb8\u540c\u65f6\u8f93\u5165\u865a\u4f53\u548c\u5b9e\u4f53\u7ec4\u7ec7\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u7f16\u7801\u8f93\u5165\u6b63\u786e");
            return result;
        }
        if (notBizCount > 1) {
            result.put("status", "fail");
            result.put("msg", "\u4ec5\u652f\u6301\u5355\u4e2a\u865a\u4f53\u8f93\u5165\uff0c\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u7f16\u7801\u8f93\u5165\u6b63\u786e");
            return result;
        }
        CompanyOrgUnitCollection bizCompanyColl = null;
        bizCompanyColl = notBizCount == 1 ? this.getCompanyCollByCU(ctx, companyColl.get(0).getId().toString()) : companyColl;
        CtrlUnitInfo ctrlUnitInfo = ((CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo")).getCU();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        IAcountScheme iAcountScheme = AcountSchemeFactory.getLocalInstance((Context)ctx);
        AcountSchemeInfo acountSchemeInfo = new AcountSchemeInfo();
        ObjectUuidPK acountSchemePK = null;
        if (!isNewAccountScheme) {
            acountSchemeInfo = this.getSchemeByNumberAndName(ctx, accountSchemeNumber, accountSchemeName);
            if (acountSchemeInfo == null) {
                result.put("status", "fail");
                result.put("msg", "\u627e\u4e0d\u5230\u8d26\u7c3f\u65b9\u6848\uff1a" + accountSchemeNumber + " " + accountSchemeName + "\uff0c\u8bf7\u786e\u8ba4\u8d26\u7c3f\u65b9\u6848\u7f16\u7801\u540d\u79f0\u8f93\u5165\u6b63\u786e");
                return result;
            }
            if (!acountSchemeInfo.isIsLock()) {
                result.put("status", "fail");
                result.put("msg", "\u526f\u8d26\u7c3f\u5efa\u7acb\u5931\u8d25\uff0c\u8d26\u7c3f\u65b9\u6848" + accountSchemeNumber + " " + accountSchemeName + "\u672a\u542f\u7528");
                return result;
            }
            acountSchemePK = new ObjectUuidPK(acountSchemeInfo.getId());
        } else {
            CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx);
            if (masterCompany != null) {
                masterCompany = this.getCompanyById(ctx, masterCompany.getId().toString());
            }
            acountSchemeInfo.setCU(ctrlUnitInfo);
            acountSchemeInfo.setCreator(userInfo);
            acountSchemeInfo.setAccountTable(masterCompany.getAccountTable());
            acountSchemeInfo.setAdjRateTable(masterCompany.getAdjustExchangeTable());
            acountSchemeInfo.setRptRateTable(masterCompany.getReportExchangeTable());
            acountSchemeInfo.setReportCurrency(masterCompany.getReportCurrency());
            acountSchemeInfo.setRateTable(masterCompany.getBaseExchangeTable());
            acountSchemeInfo.setType(masterCompany.getReportConvertMode());
            acountSchemeInfo.setRule(RuleEnum.CHINA);
            acountSchemeInfo.setBookType(BookTypeEnum.FI);
            acountSchemeInfo.setName(accountSchemeName);
            acountSchemeInfo.setNumber(accountSchemeNumber);
            CurrencyInfo baseCurrency = this.getCurrencyInfoByName(ctx, localCurrencyName);
            if (baseCurrency == null) {
                result.put("status", "fail");
                result.put("msg", "\u627e\u4e0d\u5230\u5e01\u522b\uff1a" + localCurrencyName + "\uff0c\u8bf7\u786e\u8ba4\u5e01\u522b\u540d\u79f0\u8f93\u5165\u6b63\u786e\u6216\u5df2\u7ef4\u62a4\u5e01\u522b");
                return result;
            }
            PeriodTypeInfo periodTypeInfo = this.getPeriodTypeInfoByName(ctx, accountPeriodType);
            if (periodTypeInfo == null) {
                result.put("status", "fail");
                result.put("msg", "\u627e\u4e0d\u5230\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\uff1a" + accountPeriodType + "\uff0c\u8bf7\u786e\u8ba4\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u540d\u79f0\u8f93\u5165\u6b63\u786e\u6216\u5df2\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b");
                return result;
            }
            acountSchemeInfo.setCurrency(baseCurrency);
            acountSchemeInfo.setPeriodType(periodTypeInfo);
            acountSchemeInfo.setIsLock(true);
            acountSchemePK = iAcountScheme.addnew((CoreBaseInfo)acountSchemeInfo);
        }
        for (int i = 0; i < bizCompanyColl.size(); ++i) {
            String transferCompanyId;
            CompanyOrgUnitInfo bizCompany = bizCompanyColl.get(i);
            String bizCompanyId = bizCompany.getId().toString();
            IAssistantOrgFacade iAssistantOrg = AssistantOrgFacadeFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection coll = iAssistantOrg.getAssistantOrgs(bizCompanyId);
            boolean hasNoRelated = false;
            for (int j = 0; j < coll.size(); ++j) {
                CompanyOrgUnitInfo info = coll.get(j);
                if (!info.getName().endsWith(accountSchemeName) || !info.getNumber().endsWith(accountSchemeNumber)) continue;
                hasNoRelated = true;
                break;
            }
            if (hasNoRelated) {
                result.put("status", "fail");
                result.put("msg", "\u526f\u8d26\u7c3f\u5efa\u7acb\u5931\u8d25\uff0c\u8d22\u52a1\u7ec4\u7ec7 " + bizCompany.getNumber() + " " + bizCompany.getName() + " \u4e0e\u8d26\u7c3f\u65b9\u6848 " + accountSchemeNumber + " " + accountSchemeName + "\u5df2\u5efa\u7acb\u5173\u8054");
                return result;
            }
            iAssistantOrg.generateAssistantOrg((IObjectPK)new ObjectUuidPK(bizCompanyId), (IObjectPK)acountSchemePK);
            CompanyOrgUnitCollection coll1 = iAssistantOrg.getAssistantOrgs(bizCompanyId);
            CompanyOrgUnitInfo transferCompany = null;
            for (int j = 0; j < coll1.size(); ++j) {
                CompanyOrgUnitInfo info = coll1.get(j);
                if (!info.getName().endsWith(accountSchemeName) || !info.getNumber().endsWith(accountSchemeNumber)) continue;
                transferCompany = info;
                break;
            }
            String string = transferCompanyId = transferCompany != null ? transferCompany.getId().toString() : null;
            if (StringUtils.isEmpty((String)transferCompanyId)) {
                result.put("status", "fail");
                result.put("msg", "\u521b\u5efa\u526f\u8d26\u7c3f\u7ec4\u7ec7\u5931\u8d25");
                return result;
            }
            AccountRuleInfo accountRuleInfo = new AccountRuleInfo();
            String accountRuleNumber = bizCompany.getNumber() + "-" + accountSchemeNumber;
            if (this.getAccountRuleByNumberAndName(ctx, accountRuleNumber)) {
                throw new BOSException("\u526f\u8d26\u7c3f\u5efa\u7acb\u5931\u8d25\uff0c\u8d26\u7c3f\u89c4\u5219\u7f16\u7801\uff1a" + accountRuleNumber + " \u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d");
            }
            accountRuleInfo.setNumber(accountRuleNumber);
            accountRuleInfo.setName(accountSchemeName);
            accountRuleInfo.setCU(ctrlUnitInfo);
            accountRuleInfo.setCreator(userInfo);
            accountRuleInfo.setCompany(bizCompany);
            accountRuleInfo.setAccountScheme(acountSchemeInfo);
            accountRuleInfo.setValue(VoucherStatusEnum.AFTERPOST);
            accountRuleInfo.setIsCanVoucher(true);
            IAccountRule iAccountRule = AccountRuleFactory.getLocalInstance((Context)ctx);
            IObjectPK accountRulePK = iAccountRule.addnew((CoreBaseInfo)accountRuleInfo);
            ArrayList<String> addedOrgs = new ArrayList<String>();
            addedOrgs.add(transferCompanyId);
            OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgRangeType.BIZ_ORG_TYPE, null, addedOrgs, null);
            IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
            iOrgRange.saveOrgRange(orgRangeParam);
            IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getLocalInstance((Context)ctx);
            ArrayList<String> targetOrgIDList = new ArrayList<String>();
            targetOrgIDList.add(transferCompanyId);
            iUserOrgPerm.copyPermission(userInfo.getId().toString(), bizCompanyId, targetOrgIDList);
            StringBuffer deleteParamSql = new StringBuffer();
            deleteParamSql.append("delete from t_bas_paramitem where forgunitid = '").append(transferCompanyId).append("'");
            DbUtil.execute((Context)ctx, (String)deleteParamSql.toString());
            StringBuffer insertParamSql = new StringBuffer();
            insertParamSql.append("insert into t_bas_paramitem(fid,fvalue_l1,fvalue_l2,fvalue_l3,fvaluealias_l1,fvaluealias_l2,fvaluealias_l3,fiscontrolsub,");
            insertParamSql.append("fismodify,fvalue,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fkeyid,forgunitid,forgtreeid,fvaluealias,fcontrolunitid) ");
            insertParamSql.append("select newbosid('ED2A979A'),fvalue_l1,fvalue_l2,fvalue_l3,fvaluealias_l1,fvaluealias_l2,fvaluealias_l3,fiscontrolsub,");
            insertParamSql.append("fismodify,fvalue,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fkeyid,'").append(transferCompanyId);
            insertParamSql.append("',forgtreeid,fvaluealias,fcontrolunitid ");
            insertParamSql.append("from t_bas_paramitem where forgunitid = '").append(bizCompanyId).append("'");
            DbUtil.execute((Context)ctx, (String)insertParamSql.toString());
            StringBuffer insertMaterialSql = new StringBuffer();
            insertMaterialSql.append("insert into t_bd_materialcompanyinfo(fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fmaterial,");
            insertMaterialSql.append("fmaterialid,fcompanyid,fkaclassid,faccounttype,fstandardcost,feffectedstatus,fcalculatetype,ffreezeorgunit,fstatus,fcreatecobyorder,");
            insertMaterialSql.append("fislot,fisassistproperty,fisproject,fistracknumber) ");
            insertMaterialSql.append("select newbosid('D431F8BB'),fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fmaterial,");
            insertMaterialSql.append("fmaterialid,'").append(transferCompanyId).append("',fkaclassid,faccounttype,fstandardcost,feffectedstatus,fcalculatetype,");
            insertMaterialSql.append("ffreezeorgunit,fstatus,fcreatecobyorder,fislot,fisassistproperty,fisproject,fistracknumber ");
            insertMaterialSql.append("from t_bd_materialcompanyinfo where fcompanyid = '").append(bizCompanyId).append("'");
            DbUtil.execute((Context)ctx, (String)insertMaterialSql.toString());
            StringBuffer insertCustomerSql = new StringBuffer();
            insertCustomerSql.append("insert into t_bd_customercompanyinfo(fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fname_l1,");
            insertCustomerSql.append("fname_l2,fname_l3,fnumber,fdescription_l1,fdescription_l2,fdescription_l3,fsimplename,fadmincuid,fcomorgid,fsettlementcurrencyid,");
            insertCustomerSql.append("fsettlementtypeid,fpaymenttypeid,faccountclassid,fisticketfreezed,feffectedstatus,fcustomerid,ffreezeorgunitid,fcontactperson,");
            insertCustomerSql.append("fphone,fmobile,ffax,fpostalcode,femail,fbank,fbankaccount,foperationerid,fbankaddress,fadminorgunitid,fpayconditionid,fusingstatus,");
            insertCustomerSql.append("fbillinglimit) ");
            insertCustomerSql.append("select newbosid('7751B8D7'),fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fname_l1,fname_l2,fname_l3,");
            insertCustomerSql.append("fnumber,fdescription_l1,fdescription_l2,fdescription_l3,fsimplename,fadmincuid,'").append(transferCompanyId).append("',fsettlementcurrencyid,");
            insertCustomerSql.append("fsettlementtypeid,fpaymenttypeid,faccountclassid,fisticketfreezed,feffectedstatus,fcustomerid,ffreezeorgunitid,fcontactperson,");
            insertCustomerSql.append("fphone,fmobile,ffax,fpostalcode,femail,fbank,fbankaccount,foperationerid,fbankaddress,fadminorgunitid,fpayconditionid,fusingstatus,");
            insertCustomerSql.append("fbillinglimit from t_bd_customercompanyinfo where fcomorgid = '").append(bizCompanyId).append("'");
            DbUtil.execute((Context)ctx, (String)insertCustomerSql.toString());
            StringBuffer insertSupplierSql = new StringBuffer();
            insertSupplierSql.append("insert into t_bd_suppliercompanyinfo(fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fname_l1,");
            insertSupplierSql.append("fname_l2,fname_l3,fnumber,fdescription_l1,fdescription_l2,fdescription_l3,fsimplename,fadmincuid,fcomorgid,fsettlementtypeid,");
            insertSupplierSql.append("fsettlementcurrencyid,fsettlementaccount,fpaymenttypeid,faccountclassid,fisfreezepayment,fbankname,fbankaccount,feffectedstatus,");
            insertSupplierSql.append("ffreezeorgunitid,fsupplierid,fcontactperson,fcontactpersonpost,fphone,fmobile,ffax,fpostalcode,femail,fpayconditionid,fusingstatus) ");
            insertSupplierSql.append("select newbosid('F26C0EC7'),fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fname_l1,fname_l2,fname_l3,");
            insertSupplierSql.append("fnumber,fdescription_l1,fdescription_l2,fdescription_l3,fsimplename,fadmincuid,'").append(transferCompanyId).append("',fsettlementtypeid,");
            insertSupplierSql.append("fsettlementcurrencyid,fsettlementaccount,fpaymenttypeid,faccountclassid,fisfreezepayment,fbankname,fbankaccount,feffectedstatus,");
            insertSupplierSql.append("ffreezeorgunitid,fsupplierid,fcontactperson,fcontactpersonpost,fphone,fmobile,ffax,fpostalcode,femail,fpayconditionid,fusingstatus ");
            insertSupplierSql.append("from t_bd_suppliercompanyinfo where fcomorgid = '").append(bizCompanyId).append("'");
            DbUtil.execute((Context)ctx, (String)insertSupplierSql.toString());
        }
        result.put("status", "success");
        result.put("msg", "\u8d22\u52a1\u7ec4\u7ec7\uff1a" + companyNumber + " \u5bf9\u5e94\u7684\u526f\u8d26\u7c3f\u5efa\u7acb\u5b8c\u6210\uff0c\u8bf7\u81ea\u884c\u5b8c\u6210\u4ee5\u4e0b\u64cd\u4f5c\uff1a\n\n1.\u5206\u914d/\u65b0\u5efa\u526f\u8d26\u7c3f\u79d1\u76ee\u8868\n\n2.\u7ef4\u62a4\u526f\u8d26\u7c3f\u542f\u7528\u671f\u95f4\uff0c\u5e76\u542f\u7528\u526f\u8d26\u7c3f\u89c4\u5219\n\n3.\u4e3b\u526f\u8d26\u7c3f\u79d1\u76ee\u5bf9\u7167\uff08\u79d1\u76ee\u8868\u4e00\u81f4\u65e0\u9700\u5bf9\u7167\uff0c\u79d1\u76ee\u8868\u4e0d\u4e00\u81f4\u9700\u8981\u5bf9\u7167\uff09");
        return result;
    }

    private CompanyOrgUnitInfo getCompanyById(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.name"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.number"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.name"));
        sic.add(new SelectorItemInfo("reportExchangeTable.number"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        return company;
    }

    private CompanyOrgUnitCollection getCompanyCollByCU(Context ctx, String cuId) throws BOSException {
        if (StringUtils.isEmpty((String)cuId)) {
            return null;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.name"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.number"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.name"));
        sic.add(new SelectorItemInfo("reportExchangeTable.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.ID", (Object)cuId, CompareType.EQUALS));
        fic.add(new FilterItemInfo("ISASSISTANTORG", (Object)"0", CompareType.EQUALS));
        fic.add(new FilterItemInfo("ISBIZUNIT", (Object)"1", CompareType.EQUALS));
        fic.add(new FilterItemInfo("ISCU", (Object)"0", CompareType.EQUALS));
        CompanyOrgUnitCollection coll = iCompanyOrgUnit.getCompanyOrgUnitCollection(view);
        return coll;
    }

    private CompanyOrgUnitCollection getCompanyCollByNumberArr(Context ctx, Set companyNumberSet) throws BOSException {
        if (companyNumberSet == null || companyNumberSet.size() == 0) {
            return null;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.name"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.number"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.name"));
        sic.add(new SelectorItemInfo("reportExchangeTable.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)companyNumberSet, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("level", (Object)"1", CompareType.NOTEQUALS));
        CompanyOrgUnitCollection coll = iCompanyOrgUnit.getCompanyOrgUnitCollection(view);
        return coll;
    }

    private boolean getAccountRuleByNumberAndName(Context ctx, String accountRuleNumber) throws BOSException {
        if (StringUtils.isEmpty((String)accountRuleNumber)) {
            return false;
        }
        boolean result = false;
        IAccountRule iAccountRule = AccountRuleFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)accountRuleNumber));
        AccountRuleCollection arc = iAccountRule.getAccountRuleCollection(view);
        if (arc.size() > 0) {
            result = true;
        }
        return result;
    }

    private AcountSchemeInfo getSchemeByNumberAndName(Context ctx, String accountSchemeNumber, String accountSchemeName) throws BOSException {
        if (StringUtils.isEmpty((String)accountSchemeNumber) || StringUtils.isEmpty((String)accountSchemeName)) {
            return null;
        }
        AcountSchemeInfo acountSchemeInfo = null;
        IAcountScheme iAcountScheme = AcountSchemeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)accountSchemeNumber));
        fic.add(new FilterItemInfo("name", (Object)accountSchemeName));
        AcountSchemeCollection cc = iAcountScheme.getAcountSchemeCollection(view);
        if (cc.size() == 1) {
            acountSchemeInfo = cc.get(0);
        }
        return acountSchemeInfo;
    }

    private CurrencyInfo getCurrencyInfoByName(Context ctx, String currencyName) throws BOSException {
        if (StringUtils.isEmpty((String)currencyName)) {
            return null;
        }
        CurrencyInfo currencyInfo = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)currencyName));
        CurrencyCollection cc = iCurrency.getCurrencyCollection(view);
        if (cc.size() == 1) {
            currencyInfo = cc.get(0);
        }
        return currencyInfo;
    }

    private PeriodTypeInfo getPeriodTypeInfoByName(Context ctx, String periodTypeName) throws BOSException {
        if (StringUtils.isEmpty((String)periodTypeName)) {
            return null;
        }
        PeriodTypeInfo periodTypeInfo = null;
        IPeriodType iPeriodType = PeriodTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)periodTypeName));
        PeriodTypeCollection ptc = iPeriodType.getPeriodTypeCollection(view);
        if (ptc.size() == 1) {
            periodTypeInfo = ptc.get(0);
        }
        return periodTypeInfo;
    }
}

