/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.eas.fi.gl.app.GLQuartzJob;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class TempFileDeleteJob
extends GLQuartzJob
implements StatefulJob {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.TempFileDeleteJob");

    public void execute(JobExecutionContext jctx) throws JobExecutionException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir != null) {
            tmpdir = FilenameUtils.normalize((String)tmpdir);
        }
        if (tmpdir == null) {
            return;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        try {
            for (File file : dir.listFiles()) {
                long diff = System.currentTimeMillis() - file.lastModified();
                if (diff <= 86400000L) continue;
                file.delete();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"GL temporary file delete error!", (Throwable)ex);
        }
    }
}

