/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.ITemplateVoucher;
import com.kingdee.eas.fi.gl.TemplateVoucherFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherGroupCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherGroupInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.app.AbstractTemplateVoucherGroupControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import java.util.HashSet;
import java.util.Set;

public class TemplateVoucherGroupControllerBean
extends AbstractTemplateVoucherGroupControllerBean {
    private static final Set<String> presetNumbers = new HashSet<String>();

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        ObjectUuidPK sourceTreePK = new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId());
        TreeBaseInfo sourceTree = (TreeBaseInfo)sourceNode;
        sourceTree = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)sourceTreePK);
        if (sourceTree.get("parent") != null) {
            sourceNode.put("parent", sourceTree.get("parent"));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("category");
        TemplateVoucherGroupInfo sourceGroup = this.getTemplateVoucherGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId()), selector);
        if (presetNumbers.contains(sourceGroup.getNumber())) {
            throw new GLException(GLException.TEMVCHGROUP_PRESET_CANNOTMOV);
        }
        if (targetNode != null) {
            TemplateVoucherGroupInfo targetGroup = this.getTemplateVoucherGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(((TreeBaseInfo)targetNode).getId()), selector);
            if (!sourceGroup.getCategory().equals((Object)targetGroup.getCategory())) {
                throw new GLException(GLException.TEMVCHGROUP_CATEGORY_NOTEQUAL);
            }
        }
        super._moveTreeNode(ctx, sourceNode, targetNode);
    }

    protected void canMove(TreeBaseInfo tree) throws EASBizException, BOSException {
    }

    protected void canReceive(TreeBaseInfo tree) throws EASBizException, BOSException {
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        String companyId = (String)treeBaseInfo.get("company.id");
        if (companyId == null || companyId.equals("")) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        lNfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        lNfilter.setMaskString("#0 AND #1 AND #2");
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    protected void canDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id = pk.toString();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("templateVoucherGroup.id", (Object)id));
        filter.setMaskString("#0");
        ITemplateVoucher ctrl = TemplateVoucherFactory.getLocalInstance(ctx);
        boolean canDelete = ctrl.exists(filter);
        if (canDelete) {
            throw new GLException(GLException.CANTREMTMPGROUP);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("number", presetNumbers, CompareType.INCLUDE));
        boolean exists = this.exists(ctx, filter);
        if (exists) {
            throw new GLException(GLException.TEMVCHGROUP_PRESET_CANNOTDEL);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.canDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((TreeBaseInfo)model).getId() == null) {
            if (presetNumbers.contains(((DataBaseInfo)model).getNumber())) {
                throw new GLException(GLException.TEMVCHGROUP_PRESET_CANNOTUSE);
            }
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((TreeBaseInfo)model).getId()));
            filter.getFilterItems().add(new FilterItemInfo("number", presetNumbers, CompareType.INCLUDE));
            boolean exists = this.exists(ctx, filter);
            if (exists) {
                throw new GLException(GLException.TEMVCHGROUP_PRESET_CANNOTMOD);
            }
            if (presetNumbers.contains(((DataBaseInfo)model).getNumber())) {
                throw new GLException(GLException.TEMVCHGROUP_PRESET_CANNOTUSE);
            }
        }
        this.checkNameDup(ctx, (DataBaseInfo)model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        return super._submit(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("name", (Object)treeModel.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)((TemplateVoucherGroupInfo)treeModel).getCompany().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        if (treeModel.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{treeModel.getName()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)((TemplateVoucherGroupInfo)treeModel).getCompany().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        if (treeModel.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{treeModel.getNumber()});
        }
    }

    @Override
    protected void _preset(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (company == null || company.getId() == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", presetNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        TemplateVoucherGroupCollection coll = this.getTemplateVoucherGroupCollection(ctx, view);
        HashSet<String> exists = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            exists.add(coll.get(i).getNumber());
        }
        if (!exists.contains("PresetFinance")) {
            TemplateVoucherGroupInfo group = new TemplateVoucherGroupInfo();
            group.setCompany(company);
            group.setCategory(VoucherCategoryEnum.FINANCE);
            group.setNumber("PresetFinance");
            group.setName("Finance", LocaleUtils.locale_l1);
            group.setName(VoucherCategoryEnum.FINANCE.getAlias(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            group.setName(VoucherCategoryEnum.FINANCE.getAlias(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            group.setName(VoucherCategoryEnum.FINANCE.getAlias());
            this.checkNameDup(ctx, (DataBaseInfo)group);
            super._submit(ctx, (IObjectValue)group);
        }
        if (!exists.contains("PresetBudget")) {
            TemplateVoucherGroupInfo group = new TemplateVoucherGroupInfo();
            group.setCompany(company);
            group.setCategory(VoucherCategoryEnum.BUDGET);
            group.setNumber("PresetBudget");
            group.setName("Budget", LocaleUtils.locale_l1);
            group.setName(VoucherCategoryEnum.BUDGET.getAlias(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            group.setName(VoucherCategoryEnum.BUDGET.getAlias(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            group.setName(VoucherCategoryEnum.BUDGET.getAlias());
            this.checkNameDup(ctx, (DataBaseInfo)group);
            super._submit(ctx, (IObjectValue)group);
        }
        if (!exists.contains("PresetParallel")) {
            TemplateVoucherGroupInfo group = new TemplateVoucherGroupInfo();
            group.setCompany(company);
            group.setCategory(VoucherCategoryEnum.PARALLEL);
            group.setNumber("PresetParallel");
            group.setName("Parallel", LocaleUtils.locale_l1);
            group.setName(VoucherCategoryEnum.PARALLEL.getAlias(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            group.setName(VoucherCategoryEnum.PARALLEL.getAlias(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            group.setName(VoucherCategoryEnum.PARALLEL.getAlias());
            this.checkNameDup(ctx, (DataBaseInfo)group);
            super._submit(ctx, (IObjectValue)group);
        }
    }

    static {
        presetNumbers.add("PresetFinance");
        presetNumbers.add("PresetBudget");
        presetNumbers.add("PresetParallel");
    }
}

