/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CreateVoucherModeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.ITransPLProgramVoucherRef;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.PLAccountRangeEnum;
import com.kingdee.eas.fi.gl.PL_VoucherDataEnum;
import com.kingdee.eas.fi.gl.ProduceInfo;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.TransPLException;
import com.kingdee.eas.fi.gl.TransPLProgramAsstAccountCollection;
import com.kingdee.eas.fi.gl.TransPLProgramAsstAccountInfo;
import com.kingdee.eas.fi.gl.TransPLProgramCollection;
import com.kingdee.eas.fi.gl.TransPLProgramEntryCollection;
import com.kingdee.eas.fi.gl.TransPLProgramEntryInfo;
import com.kingdee.eas.fi.gl.TransPLProgramInfo;
import com.kingdee.eas.fi.gl.TransPLProgramVoucherRefFactory;
import com.kingdee.eas.fi.gl.TransPLProgramVoucherRefInfo;
import com.kingdee.eas.fi.gl.TransPlProgramFilter;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.VoucherTransPeriodEnum;
import com.kingdee.eas.fi.gl.app.AbstractTransPLProgramControllerBean;
import com.kingdee.eas.fi.gl.app.GLPeriodEndFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TransPLProgramControllerBean
extends AbstractTransPLProgramControllerBean {
    private static final long serialVersionUID = -360074176322872766L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.TransPLProgramControllerBean");
    private static final int DIVIDE_OP_CODE = 1;
    private static final int MULTIPLY_OP_CODE = 2;
    private boolean isState = false;
    public String curId2;
    private Map<String, Map<String, AsstAccountInfo>> caass = new HashMap<String, Map<String, AsstAccountInfo>>();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, String> existsVoucher = new HashMap<String, String>();
    private String T_TMP_AsstAccount = null;
    private Map<String, BigDecimal> coefficients = new HashMap<String, BigDecimal>();
    private HashMap hmLocalEx = new HashMap();
    private HashMap hmRptEx = new HashMap();

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransPLProgramInfo info = (TransPLProgramInfo)model;
        ObjectUuidPK pk = null;
        String logItemName = "gl_TransPL_addnew";
        if (info.getId() != null) {
            pk = new ObjectUuidPK(info.getId());
            logItemName = "gl_TransPL_update";
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"save", (BOSObjectType)this.getBOSType(), (IObjectPK)pk, (String)(info.getNumber() + "," + info.getName()), (String)logItemName);
        this.verifyData(ctx, model);
        pk = super._save(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("company.id");
        TransPLProgramInfo info = this.getTransPLProgramInfo(ctx, pk, selector);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)this.getBOSType(), (IObjectPK)pk, (String)(info.getNumber() + "," + info.getName()), (String)"gl_TransPL_delete", (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransPLProgramInfo info = (TransPLProgramInfo)model;
        TransPLProgramEntryCollection plProgramEntryCollection = info.getEntries();
        CompanyOrgUnitInfo companyOrgUnitInfo = info.getCompany();
        String loc = this._getLocaleString(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where number ='" + model.getString("number") + "' ");
        oql.append(" and company.id ='" + companyOrgUnitInfo.getString("id") + "' ");
        if (!GlUtils.isEmpty(model.getString("id"))) {
            oql.append(" and  id !='" + model.getString("id") + "' ");
        }
        if (this._exists(ctx, oql.toString())) {
            throw new TransPLException(TransPLException.DOUBLENUMBER);
        }
        oql = new StringBuffer();
        oql.append(" where PLAccountRange = 0 ");
        oql.append(" and company.id ='" + companyOrgUnitInfo.getString("id") + "' ");
        if (!GlUtils.isEmpty(model.getString("id"))) {
            oql.append(" and  id !='" + model.getString("id") + "' ");
        }
        StringBuffer errorMsg = new StringBuffer();
        String avNumber = "";
        String avName = "";
        String pNumber = "";
        String baseMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"DoubleAccountView", (Locale)ctx.getLocale());
        TransPLProgramCollection coll = this.getTransPLProgramCollection(ctx, oql.toString());
        if (coll.size() > 0) {
            int errCount = 0;
            for (int i = 0; i < plProgramEntryCollection.size(); ++i) {
                TransPLProgramEntryInfo entryinfo = plProgramEntryCollection.get(i);
                avNumber = entryinfo.getAccountView().getNumber();
                avName = entryinfo.getAccountView().getName();
                pNumber = coll.get(0).getNumber();
                errorMsg.append(MessageFormat.format(baseMsg, "  " + avNumber + "  " + avName + "  ", "  " + pNumber + "  "));
                if (++errCount >= 3 || errCount >= plProgramEntryCollection.size()) {
                    errorMsg.append("!\r\n");
                    break;
                }
                errorMsg.append(",\r\n");
            }
            if (plProgramEntryCollection.size() > 3) {
                errorMsg.append("...");
            }
            throw new EASBizException(new NumericExceptionSubItem("8800001", errorMsg.toString()));
        }
        Iterator items = plProgramEntryCollection.iterator();
        TransPLProgramEntryInfo entryInfo = null;
        ArrayList<String> idsList = new ArrayList<String>();
        while (items.hasNext()) {
            entryInfo = (TransPLProgramEntryInfo)items.next();
            idsList.add(entryInfo.getAccountView().getId().toString());
        }
        String ids = SQLUtil.stringListToString(idsList);
        IRowSet rowSet = null;
        Object param = null;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select av.Fnumber avNumber,av.Fname_" + loc + " avName,p.Fnumber pNumber \r\n");
        sql.append(" from T_GL_TransPLProgram p \r\n");
        sql.append(" inner join T_GL_TransPLProgramEntry pe on pe.FParentID = p.Fid \r\n");
        sql.append(" inner join t_bd_accountView av on av.Fid= pe.FAccountViewID and av.FcompanyID ='" + companyOrgUnitInfo.getString("id") + "'  \r\n");
        sql.append(" where p.FCompanyID ='" + companyOrgUnitInfo.getString("id") + "'  \r\n");
        if (!GlUtils.isEmpty(model.getString("id"))) {
            sql.append(" and  p.FID !='" + model.getString("id") + "'  \r\n");
        }
        sql.append(" and pe.FAccountViewID in (" + ids + ") \r\n");
        sql.append(" order by p.Fid,av.Fnumber");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            int errCount = 0;
            while (rowSet.next()) {
                avNumber = rowSet.getString("avNumber");
                avName = rowSet.getString("avName");
                pNumber = rowSet.getString("pNumber");
                errorMsg.append(MessageFormat.format(baseMsg, "  " + avNumber + "  " + avName + "  ", "  " + pNumber + "  "));
                if (++errCount >= 3 || errCount >= rowSet.size()) {
                    errorMsg.append("!\r\n");
                    break;
                }
                errorMsg.append(",\r\n");
            }
            if (rowSet.size() > 3) {
                errorMsg.append("...");
            }
            if (errorMsg.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("8800001", errorMsg.toString()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (CreateVoucherModeEnum.ASSTACCOUNT.equals((Object)info.getCreateVoucherMode())) {
            HashSet<String> aaID = new HashSet<String>();
            TransPLProgramAsstAccountCollection aa = info.getAsstAccounts();
            int j = aa.size();
            for (int i = 0; i < j; ++i) {
                aaID.add(aa.get(i).getAsstAccount().getId().toString());
            }
            TransPLProgramEntryCollection entryColl = info.getEntries();
            PeriodInfo p = GlUtils.getCurrentPeriod(ctx, companyOrgUnitInfo.getId().toString());
            HashSet<String> accountIds = new HashSet<String>();
            int j2 = entryColl.size();
            for (int i = 0; i < j2; ++i) {
                accountIds.add(entryColl.get(i).getAccountView().getId().toString());
            }
            Map<String, AsstAccountInfo> caas = GLAsstAccountUtils.getCAAs(ctx, accountIds, p.getId().toString(), null);
            HashSet<String> caaCache = new HashSet<String>();
            int j3 = entryColl.size();
            for (int i = 0; i < j3; ++i) {
                AccountViewInfo accView = entryColl.get(i).getAccountView();
                AsstAccountInfo caa = caas.get(accView.getId().toString());
                if (caa != null) {
                    if (caaCache.contains(caa.getId().toString())) continue;
                    FilterInfo filter = new FilterInfo();
                    StringBuffer sqlIn = new StringBuffer();
                    sqlIn.append("select fasstacttypeid from t_bd_asstactgroupdetail where fasstaccountid ='");
                    sqlIn.append(caa.getId().toString());
                    sqlIn.append("'");
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sqlIn.toString(), CompareType.INNER));
                    IObjectPK[] pks = AsstActTypeFactory.getLocalInstance((Context)ctx).getPKList(filter, null);
                    HashSet<String> assSet = new HashSet<String>();
                    int n = pks.length;
                    for (int m = 0; m < n; ++m) {
                        assSet.add(pks[m].toString());
                    }
                    if (!assSet.containsAll(aaID)) {
                        throw new TransPLException(TransPLException.ACCOUNTNOTSAME, new Object[]{accView.getNumber()});
                    }
                    caaCache.add(caa.getId().toString());
                    continue;
                }
                throw new TransPLException(TransPLException.ACCOUNTNOTSAME, new Object[]{accView.getNumber()});
            }
        }
    }

    protected String _getLocaleString(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected Map _fetchInitData(Context ctx, String curCompanyID) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        GLPeriodEndFilter initData = new GLPeriodEndFilter();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompanyID), GlUtils.getCompanySic());
        initData.setCurCompany(company);
        String[] paramList = new String[]{"G001", "GL_008", "GL_002", "GL_003", "GL_011", "GL_010", "GL_028", "GLG01", "GLG01_1", "GL_051", "G011", "GL_052", "G010", "GL_068", "GL_072"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)curCompanyID);
        HashMap paMap = (HashMap)glParam.getParamMap();
        initData.setHmGLParam(paMap);
        String prifodAcctID = (String)paMap.get("GL_010");
        if (prifodAcctID != null && prifodAcctID.length() > 0 && !"none".equalsIgnoreCase(prifodAcctID)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("longNumber"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("longName"));
            selector.add(new SelectorItemInfo("DC"));
            selector.add(new SelectorItemInfo("isQty"));
            selector.add(new SelectorItemInfo("AC"));
            selector.add(new SelectorItemInfo("isLeaf"));
            selector.add(new SelectorItemInfo("isGFreeze"));
            selector.add(new SelectorItemInfo("isCFreeze"));
            selector.add(new SelectorItemInfo("bw"));
            selector.add(new SelectorItemInfo("accountingcurrency"));
            selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
            selector.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
            selector.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
            selector.add(new SelectorItemInfo("accountingcurrency"));
            selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
            selector.add(new SelectorItemInfo("accountTypeID.property"));
            AccountViewInfo profitAcct = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(prifodAcctID), selector);
            if (profitAcct.getAccountTypeID().getProperty().equals((Object)AccountProperty.BUDGET_OUTLAYS) || profitAcct.getAccountTypeID().getProperty().equals((Object)AccountProperty.BUDGET_RECEIPTS) || profitAcct.getAccountTypeID().getProperty().equals((Object)AccountProperty.BUDGET_SURPLUS) || profitAcct.isIsGFreeze() || profitAcct.isIsCFreeze()) {
                map.put("GL_010", null);
            } else {
                map.put("GL_010", profitAcct);
            }
        }
        initData.setParamCheckNumber(glParam.getInt("GL_051"));
        initData.setParamCheckVoucherTemp(glParam.getBoolean("G011"));
        initData.setCanNotClosedAfterReport(glParam.getBoolean("GL_068"));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        FilterInfo filterVT = new FilterInfo();
        filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(company.getCU().getId().toString()), "id", "adminCU");
        view.setFilter(filterVT);
        map.put("initData", initData);
        map.put("filterVT", filterVT);
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Vector _getTransPLAcct(Context ctx, String companyID) throws BOSException, EASBizException {
        boolean isUseRptCy = this.isUseReportCurrency(ctx);
        Vector<AccountViewInfo> vec = new Vector<AccountViewInfo>();
        CompanyOrgUnitInfo company = TransPLProgramControllerBean.getCurrentCompany(ctx, companyID);
        String curCompanyID = company.getId().toString();
        PeriodInfo period = GlUtils.getCurrentPeriod(ctx, curCompanyID);
        String curPeriodID = period.getId().toString();
        BigDecimal minQtyByPrecision = GlUtils.getMinQtyByPrecision(ctx, curCompanyID);
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
        Connection con = null;
        StringBuffer sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int index = 0;
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        try {
            con = this.getConnection(ctx);
            this.T_TMP_AsstAccount = GLAsstAccountUtils.createAsstAccountTable(ctx, true);
            this.buildAsstAccountTable(ctx, curCompanyID, curPeriodID, company.getAccountTable().getId().toString(), (String)null);
            sql = new StringBuffer();
            if (isUseRptCy) {
                sql.append("select vacct.*                          \r\n");
                sql.append("from                                                                \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                     \r\n");
                sql.append("from " + GLBalanceUtils.getAccountBalanceTable(5) + " bal,                                       \r\n");
                sql.append("    " + this.T_TMP_AsstAccount + " asst,                                  \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FOrgUnitID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and asst.FAccountID = bal.FAccountID                            \r\n");
                sql.append("    and acct.FIsLeaf = 1                                    \r\n");
                sql.append("    --and acct.FCAA is null                                 \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("        or bal.FEndBalanceRpt <> 0 or ").append(strQtyBalNotZero).append(" and asst.FCAA is null)     \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("union                                                               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                     \r\n");
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(5) + " bal,                                        \r\n");
                sql.append("    " + this.T_TMP_AsstAccount + " asst,                                  \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FOrgUnitID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and asst.FAccountID = bal.FAccountID                            \r\n");
                sql.append("    and acct.FIsLeaf = 1                                  \r\n");
                sql.append("    and asst.FCAA is not null                             \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("        or bal.FEndBalanceRpt <> 0 or ").append(strQtyBalNotZero).append(")     \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append(") vacct                                                             \r\n");
                sql.append("                                                                    \r\n");
                sql.append("order by vacct.FNumber                                              \r\n");
                sql.append(";");
            } else {
                sql.append("select vacct.*                                                      \r\n");
                sql.append("from                                                                \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                           \r\n");
                sql.append("from " + GLBalanceUtils.getAccountBalanceTable(5) + " bal,                                       \r\n");
                sql.append("    " + this.T_TMP_AsstAccount + " asst,                                  \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FOrgUnitID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and asst.FAccountID = bal.FAccountID                            \r\n");
                sql.append("    and acct.FIsLeaf = 1                                  \r\n");
                sql.append("    and asst.FCAA is null                                 \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("         or ").append(strQtyBalNotZero).append(")               \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("union                                                               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                           \r\n");
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(5) + " bal,                                        \r\n");
                sql.append("    " + this.T_TMP_AsstAccount + " asst,                                  \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FOrgUnitID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and asst.FAccountID = bal.FAccountID                            \r\n");
                sql.append("    and acct.FIsLeaf = 1                                            \r\n");
                sql.append("    and asst.FCAA is not null                                       \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("         or ").append(strQtyBalNotZero).append(")               \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append(") vacct                                                             \r\n");
                sql.append("                                                                    \r\n");
                sql.append("order by vacct.FNumber                                              \r\n");
                sql.append(";");
            }
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, period.getNumber());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, period.getNumber());
            rs = stmt.executeQuery();
            while (rs.next()) {
                AccountViewInfo acct = new AccountViewInfo();
                acct.setId(BOSUuid.read((String)rs.getString("FAccountID")));
                acct.setNumber(rs.getString("FNumber"));
                acct.setName(rs.getString("FName"));
                vec.add(acct);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(this.T_TMP_AsstAccount);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.T_TMP_AsstAccount);
            return vec;
        }
        catch (Exception acct) {
            return vec;
        }
    }

    private boolean isUseReportCurrency(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G001", null);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = Boolean.valueOf(hmAllParam.get("G001").toString());
        return bParam;
    }

    private static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String curCompanyID) throws BOSException, EASBizException {
        SelectorItemCollection sic = GlUtils.getCompanySic();
        return GlUtils.getCurrentCompany(ctx, curCompanyID, sic, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransPlProgramFilter<VoucherInfo> _generalVoucherCollection(Context ctx, List idList) throws BOSException {
        try {
            this.T_TMP_AsstAccount = GLAsstAccountUtils.createAsstAccountTable(ctx, true);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        TransPlProgramFilter<VoucherInfo> result = new TransPlProgramFilter<VoucherInfo>();
        TransPlProgramFilter<Object> rtnFilter = new TransPlProgramFilter();
        ArrayList<ProduceInfo> produceList = new ArrayList<ProduceInfo>();
        try {
            int length = idList.size();
            for (int i = 0; i < length; ++i) {
                IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                MutexParameter mp = null;
                MutexParameter current = null;
                ProduceInfo produceInfo = null;
                try {
                    boolean isclose = false;
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.id"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.number"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.name"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.CAA.id"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.isQty"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.id"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.number"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.name"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.defaultUnit.id"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.defaultUnit.number"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.defaultUnit.name"));
                    sic.add(new SelectorItemInfo("yearProfitAcct.measureUnitGroupID.defaultUnit.qtyPrecision"));
                    sic.add(new SelectorItemInfo("voucherDate"));
                    sic.add(new SelectorItemInfo("vDescription"));
                    sic.add(new SelectorItemInfo("PLAccountRange"));
                    sic.add(new SelectorItemInfo("voucherType.id"));
                    sic.add(new SelectorItemInfo("voucherType.name"));
                    sic.add(new SelectorItemInfo("voucherStatus"));
                    sic.add(new SelectorItemInfo("byBalanceReverse"));
                    sic.add(new SelectorItemInfo("yearProfitByOriginal"));
                    sic.add(new SelectorItemInfo("includeNoPostVoucher"));
                    sic.add(new SelectorItemInfo("byPL"));
                    sic.add(new SelectorItemInfo("voucherTransPeriod"));
                    sic.add(new SelectorItemInfo("entries.accountView.id"));
                    sic.add(new SelectorItemInfo("entries.accountView.number"));
                    sic.add(new SelectorItemInfo("entries.accountView.name"));
                    sic.add(new SelectorItemInfo("entries.accountView.CAA.id"));
                    sic.add(new SelectorItemInfo("createVoucherMode"));
                    sic.add(new SelectorItemInfo("asstAccounts.asstAccount.id"));
                    sic.add(new SelectorItemInfo("asstAccounts.asstAccount.assistantType"));
                    sic.add(new SelectorItemInfo("asstAccounts.asstAccount.realtionDataObject"));
                    sic.add(new SelectorItemInfo("asstAccounts.asstAccount.defaultQueryName"));
                    sic.add(new SelectorItemInfo("asstAccounts.asstAccount.asstHGAttribute"));
                    sic.add(new SelectorItemInfo("asstAccounts.asstAccount.mappingFieldName"));
                    sic.add(new SelectorItemInfo("asstAccounts.acctTypeNumberFromTo"));
                    sic.add(new SelectorItemInfo("asstAccounts.actTypeNumberTo"));
                    sic.add(new SelectorItemInfo("isSplit"));
                    sic.add(new SelectorItemInfo("splitSize"));
                    sic.add(new SelectorItemInfo("isDebitFirst"));
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)idList.get(i))));
                    TransPLProgramInfo transPlProgramInfo = (TransPLProgramInfo)this._getValue(ctx, (IObjectPK)pk, sic);
                    VoucherTransPeriodEnum transPeriodEnum = transPlProgramInfo.getVoucherTransPeriod();
                    produceInfo = new ProduceInfo();
                    String voucherNumber = null;
                    String voucherWebNumber = null;
                    String voucherId = null;
                    TransPlProgramFilter<VoucherInfo> filter = this.initFilterData(ctx, transPlProgramInfo);
                    CompanyOrgUnitInfo company = filter.getCompanyOrgUnit();
                    produceInfo.setId((String)idList.get(i));
                    produceInfo.setCompany(company.getName());
                    produceInfo.setAutoTransName(transPlProgramInfo.getName());
                    produceInfo.setAutoTransNumber(transPlProgramInfo.getNumber());
                    String cuid = company.getCU().getId().toString();
                    PeriodInfo transCompanyPeriod = filter.getTransCompanyPeriod();
                    produceInfo.setPeriodId(transCompanyPeriod.getId().toString());
                    produceInfo.setPeriodNumber(transCompanyPeriod.getNumber());
                    String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                    mp = new MutexParameter();
                    Uuid requestId = Uuid.create();
                    mp.setRequestId(requestId);
                    String actionName = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLMutexResource", (String)"TransPL", (Locale)ctx.getLocale());
                    mp.setMutexName(actionName + "_" + (String)idList.get(i));
                    mp.setActionName(actionName);
                    mp.setOrgUnitID(BOSUuid.read((String)company.getId().toString()));
                    mp.setUserID(BOSUuid.read((String)userId));
                    mp.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
                    mp.setDcName(ctx.getAIS());
                    mp.setDescription(actionName);
                    current = mutex.requestMutex3(mp);
                    if (current != null) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLMutexResource", (String)"GL_TransPLMutexMessage", (Locale)ctx.getLocale());
                        throw new GLPeriodEndException(new NumericExceptionSubItem("create_voucher_conflict", msg));
                    }
                    ArrayList<String> periodIDList = new ArrayList<String>();
                    String adjustPeriodID = null;
                    if (!transCompanyPeriod.isIsAdjustPeriod()) {
                        String sql = "select p.fid from t_bd_period p , t_org_company com where com.fid = ? and p.FTypeID = com.FAccountPeriodID and p.fnumber=? and FIsAdjustPeriod=1 order by p.fnumber";
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), new Integer(transCompanyPeriod.getPeriodYear() - 1 + "13")});
                        try {
                            if (rs.next()) {
                                adjustPeriodID = rs.getString("FID");
                            }
                        }
                        catch (SQLException e) {
                            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"338_TransPLProgramControllerBean", (Locale)ctx.getLocale()));
                        }
                        if (adjustPeriodID != null && filter.isAdjustTrans()) {
                            periodIDList.add(adjustPeriodID);
                        }
                    }
                    periodIDList.add(transCompanyPeriod.getId().toString());
                    String[] companyIdArray = new String[]{company.getId().toString()};
                    IVoucher ivoucher = VoucherFactory.getLocalInstance((Context)ctx);
                    ITransPLProgramVoucherRef iTransPLProgramVoucherRef = TransPLProgramVoucherRefFactory.getLocalInstance(ctx);
                    IPeriod iperiod = PeriodFactory.getLocalInstance((Context)ctx);
                    if (adjustPeriodID != null && this.checkVchIsClosed(ctx, company.getId().toString(), adjustPeriodID) || adjustPeriodID == null) {
                        isclose = true;
                    }
                    ArrayList<VoucherInfo> voucherList = new ArrayList<VoucherInfo>();
                    boolean isAdjustPeriodError = false;
                    int size = periodIDList.size();
                    for (int j = 0; j < size; ++j) {
                        if (isAdjustPeriodError) continue;
                        PeriodInfo period = (PeriodInfo)iperiod.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)periodIDList.get(j)))));
                        filter.setTransCompanyPeriod(period);
                        GlUtils.updateBalance(ctx, companyIdArray);
                        try {
                            if (!isclose && VoucherTransPeriodEnum.CURPERIOD == transPeriodEnum) {
                                throw new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_CLOSED);
                            }
                            if (!isclose && VoucherTransPeriodEnum.ALONETRANS == transPeriodEnum && !adjustPeriodID.equals(periodIDList.get(j))) {
                                throw new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_CLOSED);
                            }
                            this.checkCanTransPL(ctx, transPlProgramInfo, cuid, company.getId().toString(), (String)periodIDList.get(j));
                            if (filter.isTransMethodByAsst()) {
                                rtnFilter = this.genVchTrans(ctx, this.checkTrans(ctx, company.getId().toString(), period.getId().toString(), filter.getHmPLAccount(), filter), transPlProgramInfo);
                            } else {
                                rtnFilter = this.genVchTrans(ctx, filter, transPlProgramInfo);
                                if (rtnFilter.getReturnVchCount() != 0) {
                                    if (rtnFilter.getReturnVch1() != null) {
                                        this.resetEntryMeasureUnit(ctx, (BaseVoucherInfo)rtnFilter.getReturnVch1(), filter);
                                    }
                                    if (rtnFilter.getReturnVch2() != null) {
                                        this.resetEntryMeasureUnit(ctx, (BaseVoucherInfo)rtnFilter.getReturnVch2(), filter);
                                    }
                                }
                            }
                            produceInfo.setSuccess(true);
                        }
                        catch (Exception e) {
                            if (period.isIsAdjustPeriod()) {
                                isAdjustPeriodError = true;
                            }
                            produceInfo.setSuccess(false);
                            if (filter.isAdjustTrans() && !isAdjustPeriodError && !period.isIsAdjustPeriod() && !filter.isAdjustNoBalance()) {
                                String errorMsg = this.getStr(ctx, "adjustPeriod_Success");
                                errorMsg = errorMsg + MessageFormat.format(this.getStr(ctx, "currentPeriod_error"), String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber()));
                                produceInfo.setErrInfo(errorMsg + e.getMessage());
                            } else {
                                produceInfo.setErrInfo(e.getMessage());
                            }
                            if (e instanceof GLPeriodEndException && "89-042".equals(((GLPeriodEndException)((Object)e)).getCode())) {
                                produceInfo.setDealFunction("showVoucher");
                            }
                            logger.error((Object)e);
                            continue;
                        }
                        try {
                            VoucherStatusEnum voucherStatus = transPlProgramInfo.getVoucherStatus();
                            VoucherInfo voucher1 = (VoucherInfo)rtnFilter.getReturnVch1();
                            VoucherInfo voucher2 = (VoucherInfo)rtnFilter.getReturnVch2();
                            IObjectPK pk1 = null;
                            ArrayList<VoucherInfo> vouchers = new ArrayList<VoucherInfo>();
                            if (transPlProgramInfo.isIsSplit() && transPlProgramInfo.getSplitSize() >= 100) {
                                if (voucher1 != null && voucher1.getEntries().size() > 0) {
                                    vouchers.addAll(this.splitVoucher(ctx, voucher1, filter, transPlProgramInfo));
                                }
                                if (voucher2 != null && voucher2.getEntries().size() > 0) {
                                    vouchers.addAll(this.splitVoucher(ctx, voucher2, filter, transPlProgramInfo));
                                }
                            } else {
                                vouchers = new ArrayList();
                                if (voucher1 != null && voucher1.getEntries().size() > 0 && (null != voucher1.getId() && !this.existsVoucher.containsKey(voucher1.getId().toString()) || null == voucher1.getId())) {
                                    vouchers.add(voucher1);
                                }
                                if (voucher2 != null && voucher2.getEntries().size() > 0) {
                                    vouchers.add(voucher2);
                                }
                            }
                            for (VoucherInfo voucherinfo : vouchers) {
                                pk1 = VoucherStatusEnum.TEMP.equals((Object)voucherStatus) || voucherStatus == null ? ivoucher.save((CoreBaseInfo)voucherinfo) : ivoucher.submit((CoreBaseInfo)voucherinfo);
                                voucherinfo.setId(BOSUuid.read((String)pk1.toString()));
                                TransPLProgramVoucherRefInfo transVchRef1 = new TransPLProgramVoucherRefInfo();
                                transVchRef1.setTransplprogram(transPlProgramInfo);
                                transVchRef1.setVoucher(voucherinfo);
                                transVchRef1.setCompany(company);
                                transVchRef1.setPeriod(filter.getTransCompanyPeriod());
                                iTransPLProgramVoucherRef.save(transVchRef1);
                                voucherList.add(voucherinfo);
                                voucherNumber = voucherNumber != null ? voucherNumber + ";" + voucherinfo.getVoucherType().getName() + "-" + voucherinfo.getNumber() : voucherinfo.getVoucherType().getName() + "-" + voucherinfo.getNumber();
                                voucherWebNumber = voucherWebNumber != null ? voucherWebNumber + ";[" + voucherinfo.getVoucherType().getName() + "]" + voucherinfo.getNumber() + "  " : "[" + voucherinfo.getVoucherType().getName() + "]" + voucherinfo.getNumber() + "  ";
                                if (voucherId != null) {
                                    voucherId = voucherId + voucherinfo.getId().toString() + ";";
                                    continue;
                                }
                                voucherId = voucherinfo.getId().toString();
                            }
                            continue;
                        }
                        catch (EASBizException e) {
                            produceInfo.setSuccess(false);
                            produceInfo.setErrInfo(e.getMessage());
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    filter.setVoucherList(voucherList);
                    filter.setReturnVchCount(voucherList.size());
                    produceInfo.setVoucherNumber(voucherNumber);
                    produceInfo.setVoucherWebNumber(voucherWebNumber);
                    produceInfo.setVoucherId(voucherId);
                    if (transCompanyPeriod.isIsAdjustPeriod() && filter.isAdjustNoBalance()) {
                        produceInfo.setSuccess(false);
                        produceInfo.setErrInfo(new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_PLBAL).getMessage());
                    }
                    produceList.add(produceInfo);
                }
                catch (GLPeriodEndException e) {
                    try {
                        produceInfo.setSuccess(false);
                        produceInfo.setErrInfo(e.getMessage());
                        produceList.add(produceInfo);
                    }
                    catch (Throwable throwable) {
                        produceList.add(produceInfo);
                        if (current == null && mutex != null && mp != null) {
                            mutex.releaseMutex(mp.getRequestId());
                        }
                        throw throwable;
                    }
                    if (current != null || mutex == null || mp == null) continue;
                    mutex.releaseMutex(mp.getRequestId());
                    continue;
                }
                if (current != null || mutex == null || mp == null) continue;
                mutex.releaseMutex(mp.getRequestId());
                continue;
            }
        }
        catch (Exception e) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"339_TransPLProgramControllerBean", (Locale)ctx.getLocale()));
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(this.T_TMP_AsstAccount);
            }
            catch (Exception exception) {}
        }
        result.setProduceList(produceList);
        return result;
    }

    private boolean getParamValueByName(Context ctx, String companyId, String paramName) {
        try {
            return Boolean.valueOf(GlUtils.getParamByKey(ctx, companyId, paramName).toString());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return false;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return this.getTransPlProgramInternal(ctx, pk, selector);
    }

    private TransPLProgramInfo getTransPlProgramInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws EASBizException, BOSException {
        return this.getTransPLProgramInternal(ctx, pk, selector);
    }

    private TransPLProgramInfo getTransPLProgramInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("asstAccounts.asstAccount.glAsstActTypeGrp.*"));
        sic.add(new SelectorItemInfo("asstAccounts.asstAccount.*"));
        sic.add(new SelectorItemInfo("asstAccounts.*"));
        sic.addObjectCollection((IObjectCollection)selector);
        TransPLProgramInfo transPLProgramInfo = null;
        try {
            transPLProgramInfo = (TransPLProgramInfo)super._getValue(ctx, pk, sic);
            for (int i = 0; i < transPLProgramInfo.getAsstAccounts().size(); ++i) {
                String to;
                TransPLProgramAsstAccountInfo entryInfo = transPLProgramInfo.getAsstAccounts().get(i);
                AsstActTypeInfo actTypeInfo = entryInfo.getAsstAccount();
                String from = entryInfo.getAcctTypeNumberFromTo();
                if (!com.kingdee.eas.basedata.master.util.StringUtil.isEmpty((String)from)) {
                    entryInfo.put("fromObject", this.getAsstActObject(ctx, actTypeInfo, from));
                }
                if (com.kingdee.eas.basedata.master.util.StringUtil.isEmpty((String)(to = entryInfo.getActTypeNumberTo()))) continue;
                entryInfo.put("toObject", this.getAsstActObject(ctx, actTypeInfo, to));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return transPLProgramInfo;
    }

    private Object getAsstActObject(Context ctx, AsstActTypeInfo actTypeInfo, String number) throws BOSException, SQLException {
        Object[] objectArray;
        if (com.kingdee.eas.basedata.master.util.StringUtil.isEmpty((String)number)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        boolean isNeedLongnumber = actTypeInfo == null ? false : actTypeInfo.isUseLongNumber();
        sql.append(" select fid,fnumber,fname_").append(ctx.getLocale()).append(" fname ");
        sql.append(" from ").append(actTypeInfo.getRealtionDataObject());
        if (isNeedLongnumber) {
            sql.append(" where flongNumber = ? ");
        } else {
            sql.append(" where fnumber = ? ");
        }
        if (actTypeInfo.getGlAsstActTypeGrp() != null) {
            sql.append(" and fgroupid = ? ");
        }
        if (isNeedLongnumber) {
            number = number.replace('.', '!');
        }
        String string = sql.toString();
        if (actTypeInfo.getGlAsstActTypeGrp() != null) {
            String[] stringArray = new String[2];
            stringArray[0] = number;
            objectArray = stringArray;
            stringArray[1] = actTypeInfo.getGlAsstActTypeGrp().getId().toString();
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = number;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)string, (Object[])objectArray);
        if (rs.next()) {
            String fid = rs.getString("fid");
            BOSUuid id = BOSUuid.read((String)fid);
            CurrencyInfo info = new CurrencyInfo();
            info.setId(id);
            info.setName(rs.getString("fname"));
            info.setNumber(rs.getString("fnumber"));
            if (isNeedLongnumber) {
                info.put("longNumber", (Object)number);
                info.put("displayLongNumber", (Object)number.replace('!', '.'));
            }
            return info;
        }
        return null;
    }

    private TransPlProgramFilter<VoucherInfo> initFilterData(Context ctx, TransPLProgramInfo transPlProgramInfo) throws EASBizException, BOSException, UuidException {
        try {
            HashMap hmUnSelectedAccount;
            HashMap<String, AccountViewInfo> hmGainAccount;
            TransPlProgramFilter<VoucherInfo> filter;
            block22: {
                AccountViewInfo gainAccount;
                TransPLProgramEntryCollection transPLProgramEntryCollection;
                block21: {
                    filter = new TransPlProgramFilter<VoucherInfo>();
                    filter.setAllAccount(PLAccountRangeEnum.ALLPLACCOUNT.equals((Object)transPlProgramInfo.getPLAccountRange()));
                    String companyId = transPlProgramInfo.getCompany().getId().toString();
                    SelectorItemCollection companySic = new SelectorItemCollection();
                    companySic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
                    CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), companySic);
                    filter.setCompanyOrgUnit(companyOrgUnit);
                    PeriodInfo transCompanyPeriod = GlUtils.getCurrentPeriod(ctx, companyId);
                    filter.setTransCompanyPeriod(transCompanyPeriod);
                    filter.setCurUser((UserInfo)ctx.get((Object)"UserInfo"));
                    String[] paramList = new String[]{"G001", "GL_008", "GL_002", "GL_003", "GL_011", "GL_010", "GL_028", "GLG01", "GLG01_1", "GL_051", "G011", "GL_052", "G010", "GL_068", "GL_072"};
                    GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyId);
                    filter.setHmGLParam((HashMap)glParam.getParamMap());
                    boolean foreignCurrencySU = glParam.getBoolean("GL_008");
                    if (!foreignCurrencySU) {
                        if (companyOrgUnit.getBaseCurrency() == null) {
                            throw new GLException(GLException.NOLOCALCUR);
                        }
                        filter.setLocalCurrency(companyOrgUnit.getBaseCurrency());
                    }
                    filter.setParamForeignCurrencySU(foreignCurrencySU);
                    boolean useReportingCurrency = glParam.getBoolean("G001");
                    if (useReportingCurrency) {
                        if (companyOrgUnit.getReportCurrency() == null) {
                            throw new GLException(GLException.NOREPORTINGCUR);
                        }
                        filter.setReportCurrency(companyOrgUnit.getReportCurrency());
                    }
                    filter.setParamUseReportCurrency(useReportingCurrency);
                    BigDecimal minQtyByPrecision = GlUtils.getMinQtyByPrecision(ctx, companyOrgUnit.getId().toString());
                    filter.setMinQtyByPrecision(minQtyByPrecision);
                    filter.setParamUseReportAdjust(glParam.getBoolean("GL_072"));
                    filter.setParamInitClosed(GLFlagFactory.getLocalInstance(ctx).getGLInitClosed(companyId));
                    filter.setQtyByAsst(glParam.getBoolean("G010"));
                    VoucherTypeInfo transVoucherType = transPlProgramInfo.getVoucherType();
                    filter.setFilterVchType(transVoucherType);
                    filter.setTransVoucherType(transVoucherType);
                    filter.setFilterTransPLByBalOppDC(transPlProgramInfo.isByBalanceReverse());
                    boolean transProfitLossSep = transPlProgramInfo.isByPL();
                    if (transProfitLossSep) {
                        filter.setFilterCountVch(2);
                        filter.setFilterVchProfitLoss(3);
                        filter.setFilterVchPLType(1);
                    } else {
                        filter.setFilterCountVch(1);
                        filter.setFilterVchPLType(2);
                        filter.setFilterVchProfitLoss(0);
                    }
                    PL_VoucherDataEnum pl_VoucherDataEnum = transPlProgramInfo.getVoucherDate();
                    filter.setVoucherDateType(pl_VoucherDataEnum.getValue());
                    filter.setFilterVchDesc(transPlProgramInfo.getVDescription());
                    filter.setParamCheckCurrency(!transPlProgramInfo.isYearProfitByOriginal());
                    VoucherTransPeriodEnum voucherTransPeriodEnum = transPlProgramInfo.getVoucherTransPeriod();
                    int voucherTransPeriod = voucherTransPeriodEnum.getValue();
                    if (voucherTransPeriod == 1) {
                        filter.setAdjustTrans(true);
                    } else {
                        filter.setAdjustTrans(false);
                    }
                    hmGainAccount = new HashMap<String, AccountViewInfo>();
                    hmUnSelectedAccount = new HashMap();
                    transPLProgramEntryCollection = transPlProgramInfo.getEntries();
                    gainAccount = transPlProgramInfo.getYearProfitAcct();
                    if (!PLAccountRangeEnum.ALLPLACCOUNT.equals((Object)transPlProgramInfo.getPLAccountRange())) break block21;
                    Connection con = null;
                    PreparedStatement stmt = null;
                    ResultSet rs = null;
                    String accounttableid = companyOrgUnit.getAccountTable().getId().toString();
                    try {
                        con = this.getConnection(ctx);
                        StringBuffer sql = new StringBuffer();
                        sql.append("select acct.fid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                        sql.append("from \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                        sql.append("\tt_BD_AccountType actype,\t\t\t\t\t\t\t\t  \t\t\r\n");
                        sql.append("  \tt_bd_accountview acct\t                                        \r\n");
                        sql.append("where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                        sql.append("\tacct.Fcompanyid = ?\t and acct.FaccountTableId=?\t\t\t\t\t\r\n");
                        sql.append("\tand actype.FID = acct.FAccountTypeID and actype.FProperty = 4\t\r\n");
                        stmt = con.prepareStatement(sql.toString());
                        int index = 1;
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyId);
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            hmGainAccount.put(rs.getString("fid"), gainAccount);
                        }
                    }
                    catch (Exception e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs, stmt, (Connection)con);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                    break block22;
                }
                for (int i = 0; i < transPLProgramEntryCollection.size(); ++i) {
                    TransPLProgramEntryInfo transPLProgramEntryInfo = transPLProgramEntryCollection.get(i);
                    String acctID = transPLProgramEntryInfo.getAccountView().getId().toString();
                    hmGainAccount.put(acctID, gainAccount);
                }
            }
            filter.setHmPLAccount(hmGainAccount);
            filter.setHmUnSelectedAccount(hmUnSelectedAccount);
            CreateVoucherModeEnum createVoucherModeEnum = transPlProgramInfo.getCreateVoucherMode();
            if (createVoucherModeEnum.getValue() == 1) {
                filter.setTransMethodByAsst(true);
                TransPLProgramAsstAccountCollection transPLProgramAsstAccountCollection = transPlProgramInfo.getAsstAccounts();
                HashMap<String, String> baseNumberFrom = new HashMap<String, String>();
                HashMap<String, String> baseNumberTo = new HashMap<String, String>();
                ArrayList<AsstActTypeInfo> asstActInfoList = new ArrayList<AsstActTypeInfo>();
                int length = transPLProgramAsstAccountCollection.size();
                for (int i = 0; i < length; ++i) {
                    TransPLProgramAsstAccountInfo transPLProgramAsstAccountInfo = transPLProgramAsstAccountCollection.get(i);
                    AsstActTypeInfo asstActInfo = transPLProgramAsstAccountInfo.getAsstAccount();
                    asstActInfoList.add(asstActInfo);
                    if (!StringUtil.isEmptyString((String)transPLProgramAsstAccountInfo.getAcctTypeNumberFromTo())) {
                        baseNumberFrom.put(asstActInfo.getAsstHGAttribute(), transPLProgramAsstAccountInfo.getAcctTypeNumberFromTo());
                    }
                    if (!StringUtil.isEmptyString((String)transPLProgramAsstAccountInfo.getActTypeNumberTo())) {
                        baseNumberTo.put(asstActInfo.getAsstHGAttribute(), transPLProgramAsstAccountInfo.getActTypeNumberTo());
                    }
                    filter.setBaseNumberFrom(baseNumberFrom);
                    filter.setBaseNumberTo(baseNumberTo);
                }
                filter.setAsstActInfoList(asstActInfoList);
            } else {
                filter.setTransMethodByAsst(false);
            }
            return filter;
        }
        catch (Exception e) {
            logger.error((Object)"\u7ed3\u8f6c\u635f\u76ca\u83b7\u53d6\u65b9\u6848\u53c2\u6570\u65f6\u51fa\u9519\u5566\uff01");
            throw new BOSException((Throwable)e);
        }
    }

    private int checkCanTransPL(Context ctx, TransPLProgramInfo transPlProgramInfo, String cuid, String companyId, String periodId) throws BOSException, EASBizException, GLPeriodEndException {
        ObjectUuidPK companyIdPk = new ObjectUuidPK(BOSUuid.read((String)companyId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)companyIdPk, sic);
        if (company.getAccountTable() == null) {
            throw new GLException(GLException.NO_ACCOUNTTABLE);
        }
        String accounttableid = company.getAccountTable().getId().toString();
        int result = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = null;
            int index = 1;
            sql = new StringBuffer();
            sql.append("select Top 1 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("from \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tt_BD_AccountType actype,\t\t\t\t\t\t\t\t  \t\t\r\n");
            sql.append("  \tt_bd_accountview acct\t                                        \r\n");
            sql.append("where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tacct.Fcompanyid = ?\t and acct.FaccountTableId=?\t\t\t\t\t\r\n");
            sql.append("\tand actype.FID = acct.FAccountTypeID and actype.FProperty = 4\t\r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_PLACCOUNT);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("select Top 1 1\t \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("from t_GL_Voucher vch \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tvch.FCompanyID = ?\t\t\t\t\t\t                    \r\n");
            sql.append("\tand vch.FPeriodID =");
            sql.append("?               \r\n");
            if (transPlProgramInfo.isIncludeNoPostVoucher()) {
                sql.append("\tand (vch.FBizStatus <> 0 and vch.FBizStatus <> 2 and vch.FBizStatus <> 1 and  vch.FBizStatus <> 3 and vch.FBizStatus <> 5 );\r\n");
            } else {
                sql.append("\tand (vch.FBizStatus <> 0 and vch.FBizStatus <> 2 and vch.FBizStatus <> 5);\r\n");
            }
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)periodId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.HAS_VOUCHER_NOT_POSTED);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            if (this.checkCloseInit(ctx, true, true, true, -1, company, periodId) != 0) {
                throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        result = 1;
        return result;
    }

    private int checkCloseInit(Context ctx, boolean isCheckAccount, boolean isCheckAssist, boolean isCheckCussent, int accountType, CompanyOrgUnitInfo company, String periodId) throws BOSException, EASBizException {
        boolean isClosed = VoucherUtil.closeInit(ctx, company);
        if (isClosed) {
            return 0;
        }
        String companyID = company.getId().toString();
        String accounttableid = company.getAccountTable().getId().toString();
        ObjectUuidPK comPK = new ObjectUuidPK(company.getId());
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer errMsg = null;
        boolean isGLAcctCussent = this.isAllowCussent(ctx, (IObjectPK)comPK);
        try {
            Object[] info;
            con = this.getConnection(ctx);
            if (isCheckAccount) {
                sql = new StringBuffer();
                sql.append("select 1 where exists          \t\t\r\n");
                sql.append("(select 1 from t_GL_Flag          \t\r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("\tand FName = 'glinit'    \t\r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyID);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            if (isCheckAssist || isCheckCussent || isGLAcctCussent) {
                String where = "av.FIsLeaf = 1 \n";
                this.buildAsstAccountTable(ctx, companyID, periodId, accounttableid, where);
            }
            if (isCheckAssist) {
                sql = new StringBuffer();
                sql.append("select top 10 v1.*\t\t\t\t\t\t\t\r\n");
                sql.append("from                                \r\n");
                sql.append("(                                   \r\n");
                sql.append("select distinct acct.FID as FAccountID,     \r\n");
                sql.append("\tacct.FNumber as FAccountNumber, \t\t\r\n");
                sql.append("\tacct.FIsGFreeze,acct.FIsCFreeze,acct.FName");
                sql.append(loc);
                sql.append(" as FAccountName\t\t\t\t\t\t\t\r\n");
                sql.append("from t_bd_accountview acct,          \t\t\r\n");
                sql.append("\tt_bd_AccountType actype,               \t\r\n");
                sql.append("\t" + this.T_TMP_AsstAccount + " asst        \t\r\n");
                sql.append("where actype.FID = acct.FAccountTypeID    \t\r\n");
                sql.append("    and asst.FAccountID = acct.FID      \t\r\n");
                sql.append("    and asst.FPeriodID = ?              \t\r\n");
                if (accountType != -1) {
                    sql.append("\tand actype.FProperty = ").append(accountType).append("   \t\r\n");
                }
                sql.append("\tand asst.FCAA is not null       \t\t\r\n");
                sql.append("\tand acct.Fcompanyid = ?   and acct.FaccountTableId=?        \t\t\r\n");
                sql.append("\tand acct.FIsLeaf = 1           \t\t\t\r\n");
                sql.append(")v1                                 \r\n");
                sql.append("left join                           \r\n");
                sql.append("(                                   \r\n");
                sql.append("select FKey from t_GL_Flag          \r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("\tand FName = 'astinit'           \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")v2                                 \r\n");
                sql.append("on v1.FAccountID = v2.FKey          \r\n");
                sql.append("                                    \r\n");
                sql.append("where v2.FKey is null               \r\n");
                sql.append(" and v1.FIsGFreeze = 0              \r\n");
                sql.append(" and v1.FIsCFreeze = 0              \r\n");
                sql.append("order by v1.FAccountNumber          \r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)periodId);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyID);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyID);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(rs.getString("FAccountNumber"));
                    errMsg.append(" ");
                    errMsg.append(rs.getString("FAccountName"));
                    errMsg.append(";");
                }
                if (errMsg.length() > 0) {
                    errMsg.delete(errMsg.length() - 1, errMsg.length());
                    info = new String[]{errMsg.toString()};
                    throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_NOT_CLOSED, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            if (isCheckCussent && isGLAcctCussent) {
                sql = new StringBuffer();
                sql.append("select top 10 v1.*\t\t\t\t\t\t\t\r\n");
                sql.append("from                                \r\n");
                sql.append("(                                   \r\n");
                sql.append("select distinct acct.FID as FAccountID,     \r\n");
                sql.append("\tacct.FNumber as FAccountNumber, \t\t\r\n");
                sql.append("\tacct.FName");
                sql.append(loc);
                sql.append(" as FAccountName\t\t\t\t\t\t\t\r\n");
                sql.append("from t_bd_accountview acct,          \t\t\r\n");
                sql.append("\tt_bd_AccountType actype,               \t\r\n");
                sql.append("\t" + this.T_TMP_AsstAccount + " asst        \t\r\n");
                sql.append("where actype.FID = acct.FAccountTypeID    \t\r\n");
                sql.append("    and asst.FAccountID = acct.FID      \t\r\n");
                sql.append("    and asst.FPeriodID = ?              \t\r\n");
                sql.append("\t--and actype.FProperty = 4              \r\n");
                sql.append("\tand asst.FCAA is not null       \t\t\r\n");
                sql.append("\tand acct.Fcompanyid = ?   and acct.FaccountTableId=?          \t\t\r\n");
                sql.append("\tand acct.FIsLeaf = 1           \t\t\t\r\n");
                sql.append("\tand acct.FAC = 1       \t\t\t\r\n");
                sql.append(")v1                                 \r\n");
                sql.append("left join                           \r\n");
                sql.append("(                                   \r\n");
                sql.append("select FKey from t_GL_Flag          \r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("\tand FName = 'cussentinit'       \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")v2                                 \r\n");
                sql.append("on v1.FAccountID = v2.FKey          \r\n");
                sql.append("                                    \r\n");
                sql.append("where v2.FKey is null               \r\n");
                sql.append("order by v1.FAccountNumber          \r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)periodId);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyID);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyID);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(rs.getString("FAccountNumber"));
                    errMsg.append(" ");
                    errMsg.append(rs.getString("FAccountName"));
                    errMsg.append(";");
                }
                if (errMsg.length() > 0) {
                    info = new String[]{errMsg.toString()};
                    throw new GLPeriodEndException(GLPeriodEndException.CUSSENT_INIT_NOT_CLOSED, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return 0;
    }

    private boolean isAllowCussent(Context ctx, IObjectPK comPK) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> hmParamIn = new HashMap<String, IObjectPK>();
        hmParamIn.put("GL_028", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        return bParam;
    }

    private TransPlProgramFilter<VoucherInfo> checkTrans(Context ctx, String companyId, String periodId, Map otherMap, TransPlProgramFilter<VoucherInfo> filter) throws BOSException, EASBizException {
        String sqlSelectAsstActtype = "select fMappingFieldname,FAsstHGAttribute from  t_bd_asstactgroupdetail b \t\t\t\r\n inner join  t_bd_asstacttype a on a.fid=b.fasstacttypeid\t\t\t\t\r\n where b.fasstaccountid=? and a.FAsstHGAttribute in(";
        String sqlSelectSql = "select fMappingFieldname,FAsstHGAttribute from  t_bd_asstactgroupdetail b \t\t\t\r\n inner join  t_bd_asstacttype a on a.fid=b.fasstacttypeid\t\t\t\t\r\n\twhere b.fasstaccountid = ? ";
        List asstActInfoList = filter.getAsstActInfoList();
        if (asstActInfoList.size() == 0) {
            return filter;
        }
        int size = asstActInfoList.size();
        for (int i = 0; i < size; ++i) {
            AsstActTypeInfo asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
            if (i > 0) {
                sqlSelectAsstActtype = sqlSelectAsstActtype + ",";
            }
            sqlSelectAsstActtype = sqlSelectAsstActtype + "'" + asstActInfo.getAsstHGAttribute() + "'";
        }
        sqlSelectAsstActtype = sqlSelectAsstActtype + ")";
        if (otherMap != null) {
            Set st = otherMap.keySet();
            Iterator it = st.iterator();
            IRowSet rows = null;
            HashMap<String, String> asstHGAttribute = new HashMap<String, String>();
            HashMap acctAsstHGAttribute = new HashMap();
            ArrayList<String[]> asstHGAttributeList = null;
            ArrayList<String> remove = new ArrayList<String>();
            try {
                String fnumber = null;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    AccountViewInfo gainAccount = (AccountViewInfo)otherMap.get(key);
                    gainAccount.setCAA(this.getCAA(ctx, companyId, periodId, gainAccount.getId().toString()));
                    fnumber = gainAccount.getNumber();
                    if (gainAccount.getCAA() != null) {
                        String[] asstbite;
                        String caa = gainAccount.getCAA().getId().toString();
                        asstHGAttribute.clear();
                        if (acctAsstHGAttribute.containsKey(gainAccount.getId().toString())) {
                            asstHGAttributeList = (ArrayList<String[]>)acctAsstHGAttribute.get(gainAccount.getId().toString());
                        } else {
                            rows = DbUtil.executeQuery((Context)ctx, (String)sqlSelectAsstActtype, (Object[])new Object[]{caa});
                            if (rows != null) {
                                asstHGAttributeList = null;
                                while (rows.next()) {
                                    if (asstHGAttributeList == null) {
                                        asstHGAttributeList = new ArrayList<String[]>();
                                    }
                                    String field = rows.getString("fMappingFieldname");
                                    asstbite = rows.getString("FAsstHGAttribute");
                                    asstHGAttributeList.add(new String[]{field, asstbite});
                                }
                            }
                            if (asstHGAttributeList != null) {
                                acctAsstHGAttribute.put(gainAccount.getId().toString(), asstHGAttributeList);
                            } else {
                                remove.add(key);
                                continue;
                            }
                        }
                        rows = DbUtil.executeQuery((Context)ctx, (String)sqlSelectSql, (Object[])new Object[]{caa});
                        while (rows != null && rows.next()) {
                            asstHGAttribute.put(rows.getString("fMappingFieldname"), caa);
                        }
                        for (int i = 0; i < asstHGAttributeList.size(); ++i) {
                            asstbite = (String[])asstHGAttributeList.get(i);
                            if (asstHGAttribute.containsKey(asstbite[0])) continue;
                            remove.add(key);
                        }
                        continue;
                    }
                    remove.add(key);
                }
                for (int i = 0; i < remove.size(); ++i) {
                    otherMap.remove(remove.get(i));
                }
                if (otherMap.size() == 0) {
                    throw new TransPLException(TransPLException.ACCOUNTNOTSAME, new Object[]{fnumber});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new SQLDataException(e);
            }
            filter.setAcctAsstHGAttribute(acctAsstHGAttribute);
        }
        return filter;
    }

    /*
     * Unable to fully structure code
     */
    private TransPlProgramFilter<VoucherInfo> genVchTrans(Context ctx, TransPlProgramFilter<VoucherInfo> filter, TransPLProgramInfo transPlProgramInfo) throws BOSException, EASBizException {
        block88: {
            block87: {
                userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
                orgPK = new ObjectUuidPK(transPlProgramInfo.getCompany().getId());
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "gl_transPnL_createVoucher");
                company = filter.getCompanyOrgUnit();
                filter.setReturnVchCount(0);
                filter.setReturnVch1(null);
                filter.setReturnVch2(null);
                isByAsstTrans = filter.isTransMethodByAsst();
                isQtyByAsst = filter.isQtyByAsst();
                this.isState = filter.isParamCheckCurrency();
                hmAllParam = filter.getHmGLParam();
                isForCySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
                qtyPre = 2;
                if (hmAllParam.get("GL_002") != null) {
                    try {
                        qtyPre = Integer.parseInt(hmAllParam.get("GL_002").toString());
                        if (qtyPre < 0) {
                            qtyPre = 2;
                        }
                    }
                    catch (Exception ignore) {
                        qtyPre = 2;
                    }
                }
                this.curId2 = filter.getCompanyOrgUnit().getBaseCurrency().getId().toString();
                if (isForCySU) {
                    return this.genVchTransPnL0(ctx, filter, transPlProgramInfo);
                }
                transCompanyId = company.getId().toString();
                curUserID = filter.getCurUser().getId().toString();
                lcId = company.getBaseCurrency().getId().toString();
                lexTableId = null;
                if (company.getBaseExchangeTable() != null) {
                    lexTableId = company.getBaseExchangeTable().getId().toString();
                }
                useReport = filter.isParamUseReportCurrency();
                rcId = null;
                if (company.getReportCurrency() != null) {
                    rcId = company.getReportCurrency().getId().toString();
                }
                rexTableId = null;
                if (company.getReportExchangeTable() != null) {
                    rexTableId = company.getReportExchangeTable().getId().toString();
                }
                isLocal = false;
                if (company.getReportConvertMode() != null) {
                    isLocal = ReportCurrencyConvertMode.Base.equals((Object)company.getReportConvertMode());
                }
                transPeriod = filter.getTransCompanyPeriod();
                filter.setTransCompanyPeriod(transPeriod);
                transPeriodID = transPeriod.getId().toString();
                curUser = new UserInfo();
                curUser.setId(BOSUuid.read((String)curUserID));
                filter.setCurUser(curUser);
                filter.setCurServerTime(filter.getFilterVchDate());
                priceScale = new Integer(hmAllParam.get("GL_003").toString());
                vchGenPLSeparate = filter.getFilterVchPLType();
                vchGenProfitOrLoss = filter.getFilterVchProfitLoss();
                hmPLAccount = filter.getHmPLAccount();
                hmUnSelectedAccount = filter.getHmUnSelectedAccount();
                vchDesc = filter.getFilterVchDesc();
                transByDC = filter.isFilterTransPLByBalOppDC();
                now = new java.sql.Date(filter.getFilterVchDate().getTime());
                con = null;
                stmt = null;
                rs = null;
                isSubAdjustPeriodBal = false;
                con = this.getConnection(ctx);
                sql = null;
                if (!filter.getTransCompanyPeriod().isIsAdjustPeriod()) {
                    adjustPeriodInfo = PeriodUtils.getAdjPeriodInfo((Context)ctx, (PeriodInfo)filter.getTransCompanyPeriod());
                    if (adjustPeriodInfo != null) {
                        currentPeriod = filter.getTransCompanyPeriod();
                        isSubAdjustPeriodBal = true;
                        currentSql = this.getVchTransPnLSql(transPlProgramInfo, filter, false);
                        if (!filter.isAdjustTrans()) {
                            currentSql = currentSql + " order by vbal.FCurrencyID, vbal.fnumber,vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n";
                            stmt = con.prepareStatement(currentSql.toString());
                        } else {
                            filter.setTransCompanyPeriod(adjustPeriodInfo);
                            adjustSql = this.getVchTransPnLSql(transPlProgramInfo, filter, false);
                            sqlSb = new StringBuffer();
                            sqlSb.append("select curr.fnumber,  curr.FAccountDC, curr.FAccountID, curr.FAssistGrpID,  curr.FCurrencyID,  curr.FIsQty,  curr.FDefaultUnitID, (curr.FEndBalanceFor -  isnull(adjust.FEndBalanceFor,0)) as FEndBalanceFor,  (curr.FEndBalanceLocal -   isnull(adjust.FEndBalanceLocal,0)) as  FEndBalanceLocal ,  (curr.FEndBalanceRpt -  isnull(adjust.FEndBalanceRpt,0)) as FEndBalanceRpt,  (curr.FEndQty -  isnull(adjust.FEndQty,0)) as FEndQty  ");
                            if (isByAsstTrans) {
                                asstActInfoList = filter.getAsstActInfoList();
                                size = asstActInfoList.size();
                                for (i = 0; i < size; ++i) {
                                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                                    sqlSb.append("  , ' ' as " + asstActInfo.getMappingFieldName());
                                }
                            }
                            sqlSb.append("  from ").append("( ").append(currentSql).append(" ) curr left join").append(" ( ").append(adjustSql).append(" ) adjust ").append(" on curr.FAccountID = adjust.FAccountID and curr.FAssistGrpID = adjust.FAssistGrpID and curr.FCurrencyID = adjust.FCurrencyID ").append(" order by curr.FCurrencyID, curr.fnumber,curr.FAccountID, curr.FAssistGrpID ");
                            filter.setTransCompanyPeriod(currentPeriod);
                            stmt = con.prepareStatement(sqlSb.toString());
                        }
                        this.buildAsstAccountTable(ctx, transCompanyId, currentPeriod.getId().toString(), company.getAccountTable().getId().toString(), filter);
                        index = 1;
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, currentPeriod.getNumber());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)currentPeriod.getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, currentPeriod.getNumber());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)currentPeriod.getId().toString());
                        if (isQtyByAsst) {
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, currentPeriod.getNumber());
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)currentPeriod.getId().toString());
                        }
                        if (filter.isAdjustTrans()) {
                            this.buildAsstAccountTable(ctx, transCompanyId, adjustPeriodInfo.getId().toString(), company.getAccountTable().getId().toString(), filter);
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, adjustPeriodInfo.getNumber());
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)adjustPeriodInfo.getId().toString());
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, adjustPeriodInfo.getNumber());
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)adjustPeriodInfo.getId().toString());
                            if (isQtyByAsst) {
                                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                                stmt.setInt(index++, adjustPeriodInfo.getNumber());
                                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)adjustPeriodInfo.getId().toString());
                            }
                        }
                    } else {
                        sql = this.getVchTransPnLSql(transPlProgramInfo, filter, true);
                    }
                } else {
                    sql = this.getVchTransPnLSql(transPlProgramInfo, filter, true);
                }
                if (!isSubAdjustPeriodBal) {
                    this.buildAsstAccountTable(ctx, transCompanyId, transPeriod.getId().toString(), company.getAccountTable().getId().toString(), filter);
                    stmt = con.prepareStatement(sql);
                    index = 1;
                    DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                    stmt.setInt(index++, transPeriod.getNumber());
                    DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transPeriod.getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                    stmt.setInt(index++, transPeriod.getNumber());
                    DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transPeriod.getId().toString());
                    if (isQtyByAsst) {
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, transPeriod.getNumber());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transPeriod.getId().toString());
                    }
                }
                rs = stmt.executeQuery();
                vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
                preVch1 = this.getNewPLVoucher(ctx, filter);
                preVch2 = this.getNewPLVoucher(ctx, filter);
                hmPLAcctSum1 = new HashMap<GLPeriodEndFacadeControllerBean.AccountCurrencyPair, BigDecimal[]>();
                hmPLAcctSum2 = new HashMap<K, V>();
                glAcctAsstMap = new HashMap<String, HashMap<K, V>>();
                filter.setGlAcctAsstMap(glAcctAsstMap);
                preEntry = null;
                preSum = null;
                acctOldId = null;
                entryDCPl = false;
                while (rs.next()) {
                    acctDC = rs.getInt("FAccountDC");
                    grpId = rs.getString("FAssistGrpID");
                    acctId = rs.getString("FAccountID");
                    newEntry = " ".equals(grpId) != false || "".equals(grpId) != false;
                    isAddEntry = false;
                    if (acctOldId != null) {
                        isAddEntry = newEntry == false && acctOldId.equals(acctId) == false;
                    }
                    acctOldId = rs.getString("FAccountID");
                    if (hmUnSelectedAccount.containsKey(acctId)) continue;
                    plAcct = (AccountViewInfo)hmPLAccount.get(acctId);
                    number = rs.getString("fnumber");
                    curId = rs.getString("FCurrencyID");
                    loc = rs.getBigDecimal("FEndBalanceLocal") == null ? GlUtils.zero : rs.getBigDecimal("FEndBalanceLocal");
                    rpt = rs.getBigDecimal("FEndBalanceRpt") == null ? GlUtils.zero : rs.getBigDecimal("FEndBalanceRpt");
                    org = rs.getBigDecimal("FEndBalanceFor") == null ? GlUtils.zero : rs.getBigDecimal("FEndBalanceFor");
                    qty = rs.getBigDecimal("FEndQty") == null ? GlUtils.zero : rs.getBigDecimal("FEndQty");
                    v0 = isQty = rs.getInt("FIsQty") != 0;
                    if (plAcct == null) {
                        if (GlUtils.zero.compareTo(loc) == 0 && GlUtils.zero.compareTo(rpt) == 0 && GlUtils.zero.compareTo(org) == 0 && GlUtils.zero.compareTo(qty) == 0 || isByAsstTrans) continue;
                        throw new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_PLACCOUNT2, new Object[]{number});
                    }
                    pl = this.getPL(new BigDecimal[]{loc, rpt, org, qty});
                    if (newEntry) {
                        entryDCPl = pl;
                    }
                    v1 = pl = acctDC == -1;
                    if (newEntry || isAddEntry) {
                        this.addPLEntry(preEntry, hmPLAccount, preSum);
                        vch = pl != false ? preVch1 : preVch2;
                        hmSum = pl != false ? hmPLAcctSum1 : hmPLAcctSum2;
                        cur = new CurrencyInfo();
                        cur.setId(BOSUuid.read((String)curId));
                        cur2 = new CurrencyInfo();
                        cur2.setId(BOSUuid.read((String)this.curId2));
                        if (!GlUtils.isAllZeroOrNull(new BigDecimal[]{org, loc, rpt, qty})) {
                            pair = this.isState != false ? new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(plAcct, cur2) : new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(plAcct, cur);
                            if (!isAddEntry) {
                                s = (BigDecimal[])hmSum.get(pair);
                                if (s == null) {
                                    hmSum.put(pair, new BigDecimal[]{org, loc, rpt});
                                } else {
                                    s[0] = s[0].add(org);
                                    s[1] = s[1].add(loc);
                                    s[2] = s[2].add(rpt);
                                }
                            } else {
                                s = (BigDecimal[])hmSum.get(pair);
                                if (s == null) {
                                    hmSum.put(pair, new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero});
                                } else {
                                    s[0] = s[0].add(GlUtils.zero);
                                    s[1] = s[1].add(GlUtils.zero);
                                    s[2] = s[2].add(GlUtils.zero);
                                }
                            }
                        }
                        preEntry = new VoucherEntryInfo();
                        preEntry.setOprStatus(1);
                        preEntry.setBill(vch);
                        preEntry.setDescription(vchDesc);
                        acct = new AccountViewInfo();
                        acct.setId(BOSUuid.read((String)acctId));
                        acct = (AccountViewInfo)AccountViewFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(acctId));
                        acct.setCAA(this.getCAA(ctx, transCompanyId, vch.getPeriod().getId().toString(), acctId));
                        preEntry.setCAA(acct.getCAA());
                        preEntry.setAccount(acct);
                        preEntry.setCurrency(cur);
                        dc = EntryDC.CREDIT;
                        el = loc;
                        er = rpt;
                        es = org;
                        eq = qty;
                        if (transByDC && entryDCPl || !transByDC && acctDC == -1) {
                            el = loc.negate();
                            er = rpt.negate();
                            es = org.negate();
                            eq = qty.negate();
                            dc = EntryDC.DEBIT;
                        }
                        preEntry.setEntryDC(dc);
                        preEntry.setOriginalAmount(es);
                        preEntry.setLocalAmount(el);
                        preEntry.setReportingAmount(er);
                        lex = this.getEx(con, this.hmLocalEx, curId, lcId, lexTableId, now);
                        preEntry.setLocalExchangeRate(lex);
                        rex = null;
                        rex = useReport ? (isLocal ? this.getEx(con, this.hmRptEx, lcId, rcId, rexTableId, now) : this.getEx(con, this.hmRptEx, curId, rcId, rexTableId, now)) : GlUtils.zero;
                        preEntry.setReportingExchangeRate(rex);
                        sourceEq = eq;
                        if (!isQtyByAsst && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                            mu = preEntry.getAccount().getMeasureUnitID();
                            if (mu == null) {
                                mu = new MeasureUnitInfo();
                                mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                            } else {
                                eq = this.setQtyByMuCft(ctx, eq, mu, qtyPre, 1);
                            }
                            preEntry.setMeasureUnit(mu);
                        }
                        if (!isQtyByAsst) {
                            preEntry.setQuantity(eq);
                            preEntry.setStandardQuantity(sourceEq);
                        } else {
                            preEntry.setQuantity(eq);
                            preEntry.setStandardQuantity(eq);
                        }
                        if (GlUtils.zero.compareTo(eq) != 0) {
                            preEntry.setPrice(org.divide(eq, priceScale, 4).abs());
                        } else {
                            preEntry.setPrice(GlUtils.zero);
                        }
                        preSum = hmSum;
                        if (isAddEntry) {
                            preEntry.setOriginalAmount(GlUtils.zero);
                            preEntry.setLocalAmount(GlUtils.zero);
                            preEntry.setReportingAmount(GlUtils.zero);
                            preEntry.setQuantity(GlUtils.zero);
                            preEntry.setStandardQuantity(GlUtils.zero);
                            preEntry.setPrice(GlUtils.zero);
                        }
                    }
                    if (newEntry && !isAddEntry) continue;
                    rec = new VoucherAssistRecordInfo();
                    if (preEntry == null) {
                        this.addPLEntry(preEntry, hmPLAccount, preSum);
                        vch = pl != false ? preVch1 : preVch2;
                        hmSum = pl != false ? hmPLAcctSum1 : hmPLAcctSum2;
                        cur = new CurrencyInfo();
                        cur.setId(BOSUuid.read((String)curId));
                        preEntry = new VoucherEntryInfo();
                        preEntry.setOprStatus(1);
                        preEntry.setBill(vch);
                        preEntry.setDescription(vchDesc);
                        acct = new AccountViewInfo();
                        acct.setId(BOSUuid.read((String)acctId));
                        acct = (AccountViewInfo)AccountViewFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(acctId));
                        preEntry.setCAA(acct.getCAA());
                        preEntry.setAccount(acct);
                        preEntry.setCurrency(cur);
                        dc = EntryDC.CREDIT;
                        if (transByDC && entryDCPl || !transByDC && acctDC == -1) {
                            dc = EntryDC.DEBIT;
                        }
                        preEntry.setEntryDC(dc);
                        preEntry.setOriginalAmount(InitHelp.zero);
                        preEntry.setLocalAmount(InitHelp.zero);
                        preEntry.setReportingAmount(InitHelp.zero);
                        lex = this.getEx(con, this.hmLocalEx, curId, lcId, lexTableId, now);
                        preEntry.setLocalExchangeRate(lex);
                        rex = null;
                        rex = useReport ? (isLocal ? this.getEx(con, this.hmRptEx, lcId, rcId, rexTableId, now) : this.getEx(con, this.hmRptEx, curId, rcId, rexTableId, now)) : GlUtils.zero;
                        preEntry.setReportingExchangeRate(rex);
                        if (!isQtyByAsst && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                            mu = preEntry.getAccount().getMeasureUnitID();
                            if (mu == null) {
                                mu = new MeasureUnitInfo();
                                mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                            }
                            preEntry.setMeasureUnit(mu);
                        }
                        preEntry.setQuantity(InitHelp.zero);
                        preEntry.setStandardQuantity(InitHelp.zero);
                        preEntry.setPrice(GlUtils.zero);
                        preSum = hmSum;
                    }
                    rec.setOprStatus(1);
                    rec.setBizDate(filter.getFilterVchDate());
                    rec.setDescription(vchDesc);
                    hg = new AssistantHGInfo();
                    hg.setId(BOSUuid.read((String)grpId));
                    rec.setAssGrp(hg);
                    rec.setEndDate(filter.getFilterVchDate());
                    al = loc;
                    ar = rpt;
                    as = org;
                    aq = qty;
                    if (EntryDC.DEBIT.equals((Object)preEntry.getEntryDC())) {
                        al = loc.negate();
                        ar = rpt.negate();
                        as = org.negate();
                        aq = qty.negate();
                    }
                    rec.setOriginalAmount(as);
                    rec.setLocalAmount(al);
                    rec.setReportingAmount(ar);
                    if (!isQtyByAsst && preEntry.getMeasureUnit() != null) {
                        rec.setQuantity(this.setQtyByMuCft(ctx, aq, preEntry.getMeasureUnit(), qtyPre, 1));
                        rec.setStandardQuantity(aq);
                    } else {
                        rec.setQuantity(aq);
                        rec.setStandardQuantity(aq);
                    }
                    if (isByAsstTrans) {
                        if (!EntryDC.DEBIT.equals((Object)preEntry.getEntryDC())) {
                            al = al.negate();
                            ar = ar.negate();
                            as = as.negate();
                            aq = aq.negate();
                        }
                        if ((keyMap = (HashMap<String, HashMap<K, V>>)glAcctAsstMap.get(key = this.isState != false ? plAcct.getId().toString() + this.curId2 : plAcct.getId().toString() + curId)) == null) {
                            keyMap = new HashMap<String, HashMap<K, V>>();
                            glAcctAsstMap.put(key, keyMap);
                        }
                        if ((asstbitemap = (HashMap<String, HashMap<K, V>>)keyMap.get("asstbitemap")) == null) {
                            asstbitemap = new HashMap<String, HashMap<K, V>>();
                            keyMap.put("asstbitemap", asstbitemap);
                        }
                        asstHGAttributeList = (List)filter.getAcctAsstHGAttribute().get(plAcct.getId().toString());
                        hgasstid = "";
                        if (asstHGAttributeList != null) {
                            idmap = new HashMap<String, String>();
                            size = asstHGAttributeList.size();
                            for (i = 0; i < size; ++i) {
                                asstbite = (String[])asstHGAttributeList.get(i);
                                mappingFieldName = asstbite[0];
                                hgasstid = hgasstid + rs.getString(mappingFieldName);
                                idmap.put(asstbite[1], rs.getString(mappingFieldName));
                            }
                            if (vchGenProfitOrLoss == 3 && vchGenPLSeparate == 1) {
                                asstbitemap.put(hgasstid + "Profit", idmap);
                                asstbitemap.put(hgasstid + "Loss", idmap);
                            } else {
                                asstbitemap.put(hgasstid, idmap);
                            }
                        }
                        if ((almap = (HashMap<String, BigDecimal>)keyMap.get("almap")) == null) {
                            almap = new HashMap<String, BigDecimal>();
                            keyMap.put("almap", almap);
                        }
                        if ((armap = (HashMap<String, BigDecimal>)keyMap.get("armap")) == null) {
                            armap = new HashMap<String, BigDecimal>();
                            keyMap.put("armap", armap);
                        }
                        if ((asmap = (HashMap<String, BigDecimal>)keyMap.get("asmap")) == null) {
                            asmap = new HashMap<String, BigDecimal>();
                            keyMap.put("asmap", asmap);
                        }
                        if ((aqmap = (HashMap<String, BigDecimal>)keyMap.get("aqmap")) == null) {
                            aqmap = new HashMap<String, BigDecimal>();
                            keyMap.put("aqmap", aqmap);
                        }
                        v2 = isAddPlRec = pl != false && vchGenProfitOrLoss == 1 || pl == false && vchGenProfitOrLoss == 2 || vchGenProfitOrLoss == 0 || vchGenProfitOrLoss == 3;
                        if (isAddPlRec) {
                            hgasstidkey = hgasstid;
                            if (vchGenProfitOrLoss == 3 && vchGenPLSeparate == 1) {
                                hgasstidkey = pl != false ? hgasstidkey + "Profit" : hgasstidkey + "Loss";
                            }
                            if (glAcctAsstMap.containsKey(key)) {
                                keyal = al;
                                keyar = ar;
                                keyas = as;
                                keyaq = aq;
                                if (almap.get(hgasstidkey) != null) {
                                    keyal = al.add((BigDecimal)almap.get(hgasstidkey));
                                    keyar = ar.add((BigDecimal)armap.get(hgasstidkey));
                                    keyas = as.add((BigDecimal)asmap.get(hgasstidkey));
                                    keyaq = aq.add((BigDecimal)aqmap.get(hgasstidkey));
                                }
                                almap.put(hgasstidkey, keyal);
                                armap.put(hgasstidkey, keyar);
                                asmap.put(hgasstidkey, keyas);
                                aqmap.put(hgasstidkey, keyaq);
                            } else {
                                almap.put(hgasstidkey, al);
                                armap.put(hgasstidkey, ar);
                                asmap.put(hgasstidkey, as);
                                aqmap.put(hgasstidkey, aq);
                            }
                        }
                    }
                    if (isQtyByAsst && isQty && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                        mu = new MeasureUnitInfo();
                        mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                        rec.setMeasureUnit(mu);
                        rec.setStandardQuantity(this.setQtyByMuCft(ctx, rec.getQuantity(), mu, qtyPre, 2));
                    }
                    if (GlUtils.zero.compareTo(aq) != 0) {
                        rec.setPrice(org.divide(aq, priceScale, 4).abs());
                    } else {
                        rec.setPrice(GlUtils.zero);
                    }
                    preEntry.getAssistRecords().add(rec);
                }
                this.addPLEntry(preEntry, hmPLAccount, preSum);
                if (vchGenProfitOrLoss == 1) {
                    hmPLAcctSum2.clear();
                    preVch2.getEntries().clear();
                } else if (vchGenProfitOrLoss == 2) {
                    hmPLAcctSum1.clear();
                    preVch1.getEntries().clear();
                }
                if (preVch1.getEntries().size() != 0 || preVch2.getEntries().size() != 0) ** GOTO lbl431
                if (!transPeriod.isIsAdjustPeriod()) break block87;
                filter.setAdjustNoBalance(true);
                acctDC = filter;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return acctDC;
            }
            try {
                throw new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_PLBAL);
lbl431:
                // 1 sources

                if (vchGenPLSeparate == 1) {
                    count = 0;
                    if (preVch1.getEntries().size() > 0) {
                        if (!transPlProgramInfo.isIsSplit()) {
                            this.genPLEntryEx(ctx, hmPLAcctSum1, preVch1, vchDesc, vchCtrl, filter, isLocal, this.hmLocalEx, this.hmRptEx, vchGenPLSeparate, true);
                            preVch1 = this.lazyLoad(ctx, preVch1, transPlProgramInfo.getYearProfitAcct());
                        }
                        if (transPlProgramInfo.isIsDebitFirst()) {
                            this.sortVoucherEntry(preVch1, transPlProgramInfo);
                        }
                        filter.setReturnVch1(preVch1);
                        this.sumAssistRecordQtyToEntry(preVch1, qtyPre, priceScale);
                        ++count;
                    }
                    if (preVch2.getEntries().size() > 0) {
                        if (!transPlProgramInfo.isIsSplit()) {
                            this.genPLEntryEx(ctx, hmPLAcctSum2, preVch2, vchDesc, vchCtrl, filter, isLocal, this.hmLocalEx, this.hmRptEx, vchGenPLSeparate, false);
                            preVch2 = this.lazyLoad(ctx, preVch2, transPlProgramInfo.getYearProfitAcct());
                        }
                        if (transPlProgramInfo.isIsDebitFirst()) {
                            this.sortVoucherEntry(preVch2, transPlProgramInfo);
                        }
                        filter.setReturnVch2(preVch2);
                        this.sumAssistRecordQtyToEntry(preVch2, qtyPre, priceScale);
                        ++count;
                    }
                    filter.setReturnVchCount(count);
                    break block88;
                }
                preVch1.getEntries().addCollection(preVch2.getEntries());
                this.combineSumEx(hmPLAcctSum1, hmPLAcctSum2);
                if (!transPlProgramInfo.isIsSplit()) {
                    this.genPLEntryEx(ctx, hmPLAcctSum1, preVch1, vchDesc, vchCtrl, filter, isLocal, this.hmLocalEx, this.hmRptEx, vchGenPLSeparate, true);
                    preVch1 = this.lazyLoad(ctx, preVch1, transPlProgramInfo.getYearProfitAcct());
                }
                if (transPlProgramInfo.isIsDebitFirst()) {
                    this.sortVoucherEntry(preVch1, transPlProgramInfo);
                }
                filter.setReturnVch1(preVch1);
                this.sumAssistRecordQtyToEntry(preVch1, qtyPre, priceScale);
                filter.setReturnVchCount(1);
            }
            catch (SQLException sqle) {
                try {
                    throw new BOSException((Throwable)sqle);
                }
                catch (Throwable var81_93) {
                    SQLUtils.cleanup(rs, stmt, (Connection)con);
                    throw var81_93;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return filter;
    }

    protected void sortVoucherEntry(VoucherInfo voucher, TransPLProgramInfo transPlProgramInfo) throws EASBizException, BOSException {
        VoucherEntryInfo insetVoucehrInfo;
        int i;
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        VoucherEntryCollection entryColl = voucher.getEntries();
        int debitRowCnt = 0;
        for (i = 0; i < entryColl.size(); ++i) {
            insetVoucehrInfo = entryColl.get(i);
            if (insetVoucehrInfo.getAccount().getId().toString().equals(transPlProgramInfo.getYearProfitAcct().getId().toString()) && insetVoucehrInfo.getEntryDC() == EntryDC.DEBIT) {
                newEntryColl.insertObject(-1, (IObjectValue)insetVoucehrInfo);
                ++debitRowCnt;
                continue;
            }
            if (insetVoucehrInfo.getEntryDC() != EntryDC.DEBIT) continue;
            newEntryColl.add(insetVoucehrInfo);
            ++debitRowCnt;
        }
        for (i = 0; i < entryColl.size(); ++i) {
            insetVoucehrInfo = entryColl.get(i);
            if (insetVoucehrInfo.getAccount().getId().toString().equals(transPlProgramInfo.getYearProfitAcct().getId().toString()) && insetVoucehrInfo.getEntryDC() == EntryDC.CREDIT) {
                newEntryColl.insertObject(debitRowCnt - 1, (IObjectValue)insetVoucehrInfo);
                continue;
            }
            if (insetVoucehrInfo.getEntryDC() != EntryDC.CREDIT) continue;
            newEntryColl.add(insetVoucehrInfo);
        }
        voucher.setEntries((AbstractObjectCollection)newEntryColl);
    }

    private BigDecimal setQtyByMuCft(Context ctx, BigDecimal eq, MeasureUnitInfo mu, int qtyPrecision, int opCode) throws BOSException, SQLException {
        String muId = mu.getId().toString();
        BigDecimal coef = null;
        if (this.coefficients.containsKey(muId)) {
            coef = this.coefficients.get(muId);
        } else {
            String sql1 = "select FCOEFFICIENT from T_BD_MeasureUnit where fid= ?";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{muId});
            if (result.next()) {
                BigDecimal coefficient = result.getBigDecimal("FCOEFFICIENT");
                this.coefficients.put(muId, coefficient);
                coef = coefficient;
            }
        }
        if (coef != null) {
            eq = opCode == 1 ? eq.divide(coef, qtyPrecision, 4) : eq.multiply(coef).setScale(qtyPrecision, 4);
        }
        return eq;
    }

    private void sumAssistRecordQtyToEntry(VoucherInfo vch, int qtyPrecision, int priceScale) {
        if (vch == null || vch.getEntries() == null || vch.getEntries().isEmpty()) {
            return;
        }
        for (VoucherEntryInfo entry : vch.getEntries()) {
            if (entry == null || entry.getAssistRecords() == null || entry.getAssistRecords().isEmpty()) continue;
            AccountViewInfo account = entry.getAccount();
            BigDecimal qty = GlUtils.zero;
            BigDecimal standardQty = GlUtils.zero;
            BigDecimal entryOriginalAmount = GlUtils.zero;
            BigDecimal entryLocalAmount = GlUtils.zero;
            BigDecimal entryReportAmount = GlUtils.zero;
            for (VoucherAssistRecordInfo assist : entry.getAssistRecords()) {
                if (!account.isIsQty()) {
                    assist.setQuantity(GlUtils.zero);
                    assist.setStandardQuantity(GlUtils.zero);
                }
                if (assist.getQuantity() != null) {
                    qty = qty.add(assist.getQuantity());
                }
                if (assist.getStandardQuantity() != null) {
                    standardQty = standardQty.add(assist.getStandardQuantity());
                }
                entryOriginalAmount = GlUtils.add(entryOriginalAmount, assist.getOriginalAmount());
                entryLocalAmount = GlUtils.add(entryLocalAmount, assist.getLocalAmount());
                entryReportAmount = GlUtils.add(entryReportAmount, assist.getReportingAmount());
            }
            entry.setOriginalAmount(entryOriginalAmount);
            entry.setLocalAmount(entryLocalAmount);
            entry.setReportingAmount(entryReportAmount);
            entry.setQuantity(qty.setScale(qtyPrecision, 4));
            entry.setStandardQuantity(standardQty.setScale(qtyPrecision, 4));
            if (entry.getOriginalAmount() == null || entry.getQuantity() == null || entry.getQuantity().compareTo(GlUtils.zero) == 0) continue;
            entry.setPrice(entry.getOriginalAmount().divide(entry.getQuantity(), priceScale, 4).abs());
        }
    }

    private void combineSumEx(HashMap hmPLAcctSum1, HashMap hmPLAcctSum2) {
        if (hmPLAcctSum2.size() == 0) {
            return;
        }
        if (hmPLAcctSum1.size() == 0) {
            hmPLAcctSum1.putAll(hmPLAcctSum2);
            return;
        }
        for (Map.Entry e : hmPLAcctSum2.entrySet()) {
            BigDecimal[] s2 = (BigDecimal[])e.getValue();
            BigDecimal[] s1 = (BigDecimal[])hmPLAcctSum1.get(e.getKey());
            if (s1 != null) {
                s1[0] = s1[0].add(s2[0]);
                s1[1] = s1[1].add(s2[1]);
                s1[2] = s1[2].add(s2[2]);
                continue;
            }
            hmPLAcctSum1.put(e.getKey(), s2);
        }
    }

    private VoucherInfo lazyLoad(Context ctx, VoucherInfo vchinfo, AccountViewInfo hmPLAccount) throws BOSException, VoucherException, EASBizException {
        IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = VoucherInfo.getDefaultSelector();
        VoucherInfo vch = new VoucherInfo();
        this.lazyLoadAssGrp(ctx, vchinfo);
        vch = vchCtrl.exteriorLazyLoad((BaseVoucherInfo)vchinfo, selector);
        VoucherEntryInfo ve = null;
        AccountViewInfo acct = null;
        VoucherEntryCollection veColl = vch.getEntries();
        VoucherEntryCollection newVeColl = new VoucherEntryCollection();
        for (int i = 0; i < veColl.size(); ++i) {
            ve = veColl.get(i);
            acct = ve.getAccount();
            if (acct.getId().toString().equals(hmPLAccount.getId().toString())) {
                newVeColl.add(ve);
                continue;
            }
            acct.setCAA(this.getCAA(ctx, vch.getCompany().getId().toString(), vch.getPeriod().getId().toString(), acct.getId().toString()));
            if (acct.getCAA() != null) {
                int rtnFlag = this.fillEntryHasAssist1(ctx, ve, acct);
                if (rtnFlag != 1) continue;
                newVeColl.add(ve);
                continue;
            }
            if (ve.getLocalAmount().doubleValue() == 0.0 && ve.getReportingAmount().doubleValue() == 0.0 && ve.getOriginalAmount().doubleValue() == 0.0 && (ve.getQuantity() == null || ve.getQuantity().doubleValue() == 0.0) && !acct.getId().toString().equals(hmPLAccount.getId().toString())) continue;
            newVeColl.add(ve);
        }
        vchinfo.setEntries((AbstractObjectCollection)newVeColl);
        return vch;
    }

    private void lazyLoadAssGrp(Context ctx, VoucherInfo vch) throws BOSException, EASBizException {
        VoucherEntryInfo ve2 = null;
        AccountViewInfo acct = null;
        for (VoucherEntryInfo ve2 : vch.getEntries()) {
            acct = ve2.getAccount();
            AsstAccountInfo caa = this.getCAA(ctx, vch.getCompany().getId().toString(), vch.getPeriod().getId().toString(), acct.getId().toString());
            acct.setCAA(caa);
            if (caa == null) continue;
            HashSet<String> ids = new HashSet<String>();
            for (VoucherAssistRecordInfo asst : ve2.getAssistRecords()) {
                if (asst.getAssGrp() == null) continue;
                ids.add(asst.getAssGrp().getId().toString());
            }
            if (ids.size() == 0) continue;
            Map<String, AssistantHGInfo> hgs = this.getAssistantHGs(ctx, ids, caa);
            for (VoucherAssistRecordInfo asst : ve2.getAssistRecords()) {
                if (asst.getAssGrp() == null) continue;
                asst.setAssGrp(hgs.get(asst.getAssGrp().getId().toString()));
            }
        }
    }

    private Map<String, AssistantHGInfo> getAssistantHGs(Context ctx, Set<String> ids, AsstAccountInfo caa) throws BOSException {
        HashMap<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("longNameGroup");
        selector.add("displaynameGroup");
        AsstActTypeCollection asstActTypes = this.getAsstActTypes(ctx, caa.getId().toString());
        for (int i = 0; i < asstActTypes.size(); ++i) {
            AsstActTypeInfo asstType = asstActTypes.get(i);
            String attribute = asstType.getAsstHGAttribute();
            selector.add(new SelectorItemInfo(attribute + ".id"));
            selector.add(new SelectorItemInfo(attribute + ".number"));
            selector.add(new SelectorItemInfo(attribute + ".name"));
            if (attribute.equalsIgnoreCase("companyOrg") || attribute.equalsIgnoreCase("saleOrg") || attribute.equalsIgnoreCase("profitOrg") || attribute.equalsIgnoreCase("purchaseOrg") || attribute.equalsIgnoreCase("storeageOrg") || attribute.equalsIgnoreCase("costOrg")) {
                selector.add(new SelectorItemInfo(attribute + ".isBizUnit"));
                continue;
            }
            if (!attribute.equalsIgnoreCase("adminOrg")) continue;
            selector.add(new SelectorItemInfo(attribute + ".isLeaf"));
        }
        view.setSelector(selector);
        HashSet<String> iids = new HashSet<String>();
        for (String id : ids) {
            iids.add(id);
            if (iids.size() <= 100) continue;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", iids, CompareType.INCLUDE));
            view.setFilter(filter);
            this.fillAssistantHGs(ctx, view, hgs, caa, asstActTypes);
            iids = new HashSet();
        }
        if (iids.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", iids, CompareType.INCLUDE));
            view.setFilter(filter);
            this.fillAssistantHGs(ctx, view, hgs, caa, asstActTypes);
        }
        return hgs;
    }

    private void fillAssistantHGs(Context ctx, EntityViewInfo view, Map<String, AssistantHGInfo> hgs, AsstAccountInfo caa, AsstActTypeCollection asstActTypes) throws BOSException {
        AssistantHGCollection coll = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGCollection(view);
        for (AssistantHGInfo hg : coll) {
            hg.setAsstAccount(caa);
            for (int i = 0; i < asstActTypes.size(); ++i) {
                DataBaseInfo info;
                AsstActTypeInfo asstType = asstActTypes.get(i);
                String attribute = asstType.getAsstHGAttribute();
                if (hg.get(attribute) == null || (info = (DataBaseInfo)hg.get(attribute)) == null || info.getString("displayName") != null) continue;
                if (info.getDisplayName() != null) {
                    info.setString("displayName", info.getDisplayName().trim());
                    continue;
                }
                info.setString("displayName", info.getName());
            }
            hgs.put(hg.getId().toString(), hg);
        }
    }

    private AsstActTypeCollection getAsstActTypes(Context ctx, String caaId) throws BOSException {
        if (this.asstActTypess.containsKey(caaId)) {
            return this.asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }

    private int fillEntryHasAssist1(Context ctx, VoucherEntryInfo ve, AccountViewInfo acct) throws BOSException, VoucherException, EASBizException {
        int rtnFlag = 0;
        if (acct.getCAA() == null) {
            return rtnFlag;
        }
        VoucherAssistRecordCollection asstColl = ve.getAssistRecords();
        Object asst = null;
        for (int i = 0; i < asstColl.size(); ++i) {
            VoucherAssistRecordInfo assistRecord = asstColl.get(i);
            if (assistRecord.getLocalAmount().doubleValue() == 0.0 && assistRecord.getReportingAmount().doubleValue() == 0.0 && assistRecord.getOriginalAmount().doubleValue() == 0.0 && assistRecord.getQuantity().doubleValue() == 0.0) continue;
            rtnFlag = 1;
        }
        return rtnFlag;
    }

    private void genPLEntryEx(Context ctx, HashMap hmPLAcctSum, VoucherInfo vch, String vchDesc, IVoucher vchCtrl, TransPlProgramFilter<VoucherInfo> filter, boolean isLocal, HashMap localEx, HashMap rptEX, int vchGenPLSeparate, boolean isProfit) throws BOSException, EASBizException {
        BigDecimal[] sum;
        HashMap<GLPeriodEndFacadeControllerBean.AccountCurrencyPair, Object> hmTemp = new HashMap<GLPeriodEndFacadeControllerBean.AccountCurrencyPair, Object>();
        for (Map.Entry e : hmPLAcctSum.entrySet()) {
            GLPeriodEndFacadeControllerBean.AccountCurrencyPair pair = (GLPeriodEndFacadeControllerBean.AccountCurrencyPair)e.getKey();
            AccountViewInfo plAcct = pair.getAccount();
            if (plAcct.getCurrencyID() != null) {
                CurrencyInfo cur = plAcct.getCurrencyID();
                GLPeriodEndFacadeControllerBean.AccountCurrencyPair newPair = new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(plAcct, cur);
                sum = (BigDecimal[])e.getValue();
                BigDecimal[] s = (BigDecimal[])hmTemp.get(newPair);
                if (s == null) {
                    hmTemp.put(pair, new BigDecimal[]{sum[1], sum[1], sum[2]});
                    continue;
                }
                s[0] = s[0].add(sum[1]);
                s[1] = s[1].add(sum[1]);
                s[2] = s[2].add(sum[2]);
                continue;
            }
            hmTemp.put(pair, e.getValue());
        }
        String baseCurId = filter.getCompanyOrgUnit().getBaseCurrency().getId().toString();
        for (Map.Entry e : hmTemp.entrySet()) {
            BigDecimal rate1;
            GLPeriodEndFacadeControllerBean.AccountCurrencyPair pair = (GLPeriodEndFacadeControllerBean.AccountCurrencyPair)e.getKey();
            AccountViewInfo plAcct = pair.getAccount();
            CurrencyInfo cur = pair.getCurrency();
            sum = (BigDecimal[])e.getValue();
            EntryDC dc = EntryDC.DEBIT;
            if (this.getPL(sum)) {
                for (int i = 0; i < sum.length; ++i) {
                    sum[i] = sum[i].negate();
                }
                dc = EntryDC.CREDIT;
            }
            VoucherEntryInfo entry = new VoucherEntryInfo();
            entry.setOriginalAmount(GlUtils.zero);
            entry.setLocalAmount(GlUtils.zero);
            entry.setReportingAmount(GlUtils.zero);
            entry.setOprStatus(1);
            entry.setDescription(vchDesc);
            entry.setAccount(plAcct);
            entry.setCAA(plAcct.getCAA());
            entry.setCurrency(cur);
            CurrencyInfo cur1 = new CurrencyInfo();
            cur1.setId(BOSUuid.read((String)baseCurId));
            if (this.isState) {
                entry.setCurrency(cur1);
                sum[0] = sum[1];
            } else {
                entry.setCurrency(cur);
            }
            if (!baseCurId.equals(cur.getId().toString())) {
                this.checkAccountAndCurrency(ctx, plAcct, cur);
            }
            entry.setEntryDC(dc);
            boolean isByAsstTrans = filter.isTransMethodByAsst();
            boolean useReport = filter.isParamUseReportCurrency();
            entry.setOriginalAmount(sum[0]);
            entry.setLocalAmount(sum[1]);
            entry.setReportingAmount(sum[2]);
            if (filter.getLocalCurrency().getId().toString().equals(cur.getId().toString()) || entry.getOriginalAmount().compareTo(GlUtils.zero) == 0) {
                entry.setLocalExchangeRate(GlUtils.one);
            } else if (this.isState) {
                rate1 = new BigDecimal("1.00");
                entry.setLocalExchangeRate(rate1);
            } else {
                entry.setLocalExchangeRate((BigDecimal)localEx.get(cur.getId().toString()));
            }
            if (filter.getReportCurrency() == null || filter.getReportCurrency().getId().toString().equals(cur.getId().toString()) || entry.getOriginalAmount().compareTo(GlUtils.zero) == 0) {
                entry.setReportingExchangeRate(GlUtils.one);
            } else if (useReport) {
                if (isLocal) {
                    entry.setReportingExchangeRate((BigDecimal)rptEX.get(filter.getLocalCurrency().getId().toString()));
                } else if (this.isState) {
                    rate1 = new BigDecimal("1.00");
                    entry.setReportingExchangeRate(rate1);
                } else {
                    entry.setReportingExchangeRate((BigDecimal)rptEX.get(cur.getId().toString()));
                }
            } else {
                entry.setReportingExchangeRate(GlUtils.one);
            }
            if (plAcct.isIsQty()) {
                if (plAcct.getMeasureUnitGroupID() != null) {
                    entry.setMeasureUnit(plAcct.getMeasureUnitGroupID().getDefaultUnit());
                }
                entry.setQuantity(GlUtils.zero);
                entry.setPrice(GlUtils.zero);
            }
            if (plAcct.getCAA() != null) {
                AsstAccountInfo newPLAsstAccountInfo = plAcct.getCAA();
                SelectorItemCollection asstSelector = new SelectorItemCollection();
                asstSelector.add(new SelectorItemInfo("asstActGpDt.id"));
                asstSelector.add(new SelectorItemInfo("asstActGpDt.asstActType.id"));
                asstSelector.add(new SelectorItemInfo("asstActGpDt.asstActType.asstHGAttribute"));
                newPLAsstAccountInfo = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(newPLAsstAccountInfo.getId()), asstSelector);
                AsstActTypeCollection types = new AsstActTypeCollection();
                int asstActTypeSize = newPLAsstAccountInfo.getAsstActGpDt().size();
                for (int k = 0; k < asstActTypeSize; ++k) {
                    AsstActTypeInfo asstActInfo = newPLAsstAccountInfo.getAsstActGpDt().get(k).getAsstActType();
                    types.add(asstActInfo);
                }
                String companyId = vch.getCompany().getId().toString();
                IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
                IAsstActTypeDefault def = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
                HashMap<String, DataBaseInfo> defaultValMap = new HashMap<String, DataBaseInfo>();
                if (!isByAsstTrans) {
                    VoucherAssistRecordInfo rec = new VoucherAssistRecordInfo();
                    rec.setBizDate(vch.getBizDate());
                    rec.setOprStatus(1);
                    rec.setDescription(vchDesc);
                    rec.setQuantity(entry.getQuantity());
                    rec.setOriginalAmount(entry.getOriginalAmount());
                    rec.setLocalAmount(entry.getLocalAmount());
                    rec.setReportingAmount(entry.getReportingAmount());
                    AssistantHGInfo hgInfo = new AssistantHGInfo();
                    for (int i = 0; i < types.size(); ++i) {
                        AsstActTypeInfo asstActTypeInfo = types.get(i);
                        AsstActTypeDefaultInfo typeDefaultVal = (AsstActTypeDefaultInfo)def.getDefaultAcctItem(companyId, (IObjectValue)asstActTypeInfo);
                        if (typeDefaultVal.getDefaultId() == null) continue;
                        DataBaseInfo data = null;
                        if (defaultValMap.containsKey(typeDefaultVal.getDefaultId())) {
                            data = (DataBaseInfo)defaultValMap.get(typeDefaultVal.getDefaultId());
                        } else {
                            try {
                                data = GlUtils.findAsstActObject(ctx, asstActTypeInfo.getAsstHGAttribute(), typeDefaultVal.getDefaultId());
                                defaultValMap.put(typeDefaultVal.getDefaultId(), data);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (data == null) continue;
                        hgInfo.put(asstActTypeInfo.getAsstHGAttribute(), (Object)data);
                    }
                    if (hgInfo.size() > 0) {
                        hgInfo = igCtrl.getAssistantHG(hgInfo, newPLAsstAccountInfo.getId().toString(), types);
                        rec.setAssGrp(hgInfo);
                    }
                    entry.getAssistRecords().add(rec);
                } else {
                    String key;
                    Map glasstMap = filter.getGlAcctAsstMap();
                    Map keyMap = (Map)glasstMap.get(key = plAcct.getId().toString() + cur.getId().toString());
                    if (keyMap != null) {
                        VoucherAssistRecordInfo rec = null;
                        ArrayList<VoucherAssistRecordInfo> vchAssistCollection = new ArrayList<VoucherAssistRecordInfo>();
                        int size = vch.getEntries().size();
                        for (int i = 0; i < size; ++i) {
                            VoucherAssistRecordCollection vchAssistRecordCollection = vch.getEntries().get(i).getAssistRecords();
                            for (int j = 0; j < vchAssistRecordCollection.size(); ++j) {
                                rec = new VoucherAssistRecordInfo();
                                VoucherAssistRecordInfo vchAssistRecordInfo = vchAssistRecordCollection.get(j);
                                rec.setOprStatus(1);
                                rec.setDescription(vchDesc);
                                if (!plAcct.isIsQty()) {
                                    rec.setQuantity(GlUtils.zero);
                                } else {
                                    rec.setQuantity(vchAssistRecordInfo.getQuantity());
                                }
                                if (null != vchAssistRecordInfo.getMeasureUnit()) {
                                    rec.setMeasureUnit(vchAssistRecordInfo.getMeasureUnit());
                                }
                                if (entry.getCurrency() != null && !entry.getCurrency().getId().toString().equals(vch.getEntries().get(i).getCurrency().getId().toString())) continue;
                                if (!vch.getEntries().get(i).getEntryDC().equals((Object)entry.getEntryDC())) {
                                    rec.setOriginalAmount(vchAssistRecordInfo.getOriginalAmount());
                                    rec.setLocalAmount(vchAssistRecordInfo.getLocalAmount());
                                    rec.setReportingAmount(vchAssistRecordInfo.getReportingAmount());
                                } else {
                                    rec.setOriginalAmount(vchAssistRecordInfo.getOriginalAmount().negate());
                                    rec.setLocalAmount(vchAssistRecordInfo.getLocalAmount().negate());
                                    rec.setReportingAmount(vchAssistRecordInfo.getReportingAmount().negate());
                                }
                                AssistantHGInfo hgInfo = vchAssistRecordInfo.getAssGrp();
                                SelectorItemCollection selector = new SelectorItemCollection();
                                selector.add(new SelectorItemInfo("*"));
                                selector.add(new SelectorItemInfo("asstAccount.id"));
                                hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgInfo.getId()), selector);
                                AsstAccountInfo asstAccountInfo = hgInfo.getAsstAccount();
                                if (newPLAsstAccountInfo != null) {
                                    if (asstAccountInfo.getId().toString().equals(newPLAsstAccountInfo.getId().toString())) {
                                        rec.setAssGrp(hgInfo);
                                    } else {
                                        AssistantHGInfo newPLhg = new AssistantHGInfo();
                                        int asstActTypeSize2 = newPLAsstAccountInfo.getAsstActGpDt().size();
                                        for (int k = 0; k < asstActTypeSize2; ++k) {
                                            AsstActTypeInfo asstActInfo = newPLAsstAccountInfo.getAsstActGpDt().get(k).getAsstActType();
                                            newPLhg.put(asstActInfo.getAsstHGAttribute(), hgInfo.get(asstActInfo.getAsstHGAttribute()));
                                        }
                                        newPLhg = igCtrl.getAssistantHG(newPLhg, newPLAsstAccountInfo.getId().toString(), types);
                                        rec.setAssGrp(newPLhg);
                                    }
                                }
                                vchAssistCollection.add(rec);
                            }
                        }
                        LinkedHashMap<String, VoucherAssistRecordInfo> vchAssitMap = new LinkedHashMap<String, VoucherAssistRecordInfo>();
                        int size1 = vchAssistCollection.size();
                        for (int i = 0; i < size1; ++i) {
                            VoucherAssistRecordInfo vchAssistRecordInfo1 = (VoucherAssistRecordInfo)vchAssistCollection.get(i);
                            String assgrpId1 = vchAssistRecordInfo1.getAssGrp().getId().toString();
                            if (vchAssitMap.containsKey(assgrpId1)) {
                                VoucherAssistRecordInfo record = (VoucherAssistRecordInfo)vchAssitMap.get(assgrpId1);
                                record.setQuantity(record.getQuantity().add(vchAssistRecordInfo1.getQuantity()));
                                record.setOriginalAmount(record.getOriginalAmount().add(vchAssistRecordInfo1.getOriginalAmount()));
                                record.setLocalAmount(record.getLocalAmount().add(vchAssistRecordInfo1.getLocalAmount()));
                                record.setReportingAmount(record.getReportingAmount().add(vchAssistRecordInfo1.getReportingAmount()));
                                continue;
                            }
                            vchAssitMap.put(assgrpId1, vchAssistRecordInfo1);
                        }
                        for (Map.Entry vchAssitMapEntry : vchAssitMap.entrySet()) {
                            VoucherAssistRecordInfo vchAssistRecordInfo = (VoucherAssistRecordInfo)vchAssitMapEntry.getValue();
                            if (vchAssistRecordInfo.getLocalAmount() == null || vchAssistRecordInfo.getLocalAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                            entry.getAssistRecords().add((VoucherAssistRecordInfo)vchAssitMapEntry.getValue());
                        }
                    }
                }
            }
            vch.getEntries().add(entry);
        }
    }

    private Map getPLAsstActInfoList(AssistantHGInfo hgInfo, AsstAccountInfo asstAccountInfo, List asstActInfoList, Map idmap) {
        AsstActGroupDetailCollection groupDetailCollection = asstAccountInfo.getAsstActGpDt();
        int size1 = groupDetailCollection.size();
        for (int i = 0; i < size1; ++i) {
            AsstActTypeInfo typeInfo = groupDetailCollection.get(i).getAsstActType();
            int size2 = asstActInfoList.size();
            for (int j = 0; j < size2; ++j) {
                AsstActTypeInfo plTypeInfo = (AsstActTypeInfo)asstActInfoList.get(j);
                if (!plTypeInfo.getId().toString().equals(typeInfo.getId().toString())) continue;
                DataBaseInfo dataBaseInfo = (DataBaseInfo)hgInfo.get(plTypeInfo.getAsstHGAttribute());
                if (null != dataBaseInfo) {
                    // empty if block
                }
                idmap.put(plTypeInfo.getAsstHGAttribute(), dataBaseInfo.getId().toString());
            }
        }
        return idmap;
    }

    private void checkAccountAndCurrency(Context ctx, AccountViewInfo acc, CurrencyInfo cur) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        acc = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acc.getId().toString()), selector);
        String accountName = null;
        String curName = null;
        accountName = acc.getName();
        if (acc.getAccountingcurrency().getValue() == 0) {
            CurrencyInfo curInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cur.getId().toString()));
            curName = curInfo.getName();
            if (!this.isState) {
                throw new GLPeriodEndException(GLPeriodEndException.NO_FORCURRENCY, new Object[]{curName, accountName, curName});
            }
        }
        if (acc.getAccountingcurrency().getValue() == 1) {
            CurrencyInfo curInfo;
            AccountCurrencyCollection cc = acc.getAccountCurrency();
            Iterator iter = cc.iterator();
            boolean hasON = false;
            while (iter.hasNext()) {
                curInfo = ((AccountCurrencyInfo)iter.next()).getCurrency();
                String curId = curInfo.getId().toString();
                if (!curId.equals(cur.getId().toString())) continue;
                hasON = true;
                break;
            }
            if (!hasON) {
                curInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cur.getId().toString()));
                curName = curInfo.getName();
                throw new GLPeriodEndException(GLPeriodEndException.NO_FORCURRENCY, new Object[]{curName, accountName, curName});
            }
        }
    }

    protected BigDecimal getEx(Connection conn, HashMap cache, String curId, String tcId, String tableId, java.sql.Date now) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        if (curId.equals(tcId)) {
            cache.put(curId, GlUtils.one);
            return GlUtils.one;
        }
        if (tableId == null) {
            cache.put(curId, GlUtils.one);
            return GlUtils.one;
        }
        BigDecimal result = (BigDecimal)cache.get(curId);
        if (result != null) {
            return result;
        }
        String sql = "select r.FConvertRate,a.fprecision from T_BD_ExchangeRate r\t\t \t\u3000inner join T_BD_ExchangeAux a\u3000on r.FExchangeAuxID = a.FID\t\t\t\t\u3000inner join T_BD_ExchangeTable t on a.FExchangeTableID = t.FID \t\t \t\twhere a.FSourceCurrencyID=? and a.FTargetCurrencyID=?\t\t\t\t\t\t and t.FID=? and r.FAvailTime<=? \torder by r.FAvailTime desc\t\t";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)curId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)2, (String)tcId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)3, (String)tableId);
            stmt.setDate(4, now);
            rs = stmt.executeQuery();
            result = GlUtils.zero;
            if (rs.next()) {
                result = rs.getBigDecimal(1);
                cache.put(curId, result);
            }
            bigDecimal = result;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return bigDecimal;
    }

    private void addPLEntry(VoucherEntryInfo preEntry, HashMap hmPLAccount, HashMap hmSum) throws EASBizException {
        if (preEntry != null && hmSum != null) {
            boolean hasAsst;
            boolean allZero = GlUtils.isAllZeroOrNull(new BigDecimal[]{preEntry.getQuantity(), preEntry.getOriginalAmount(), preEntry.getLocalAmount(), preEntry.getReportingAmount()});
            boolean bl = hasAsst = preEntry.getAssistRecords().size() > 0;
            if (!allZero || hasAsst) {
                preEntry.getBill().getEntries().add(preEntry);
                if (allZero) {
                    AccountViewInfo plAcct = (AccountViewInfo)hmPLAccount.get(preEntry.getAccount().getId().toString());
                    if (plAcct == null) {
                        return;
                    }
                    CurrencyInfo cur1 = new CurrencyInfo();
                    cur1.setId(BOSUuid.read((String)this.curId2));
                    GLPeriodEndFacadeControllerBean.AccountCurrencyPair pair = this.isState ? new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(plAcct, cur1) : new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(plAcct, preEntry.getCurrency());
                    BigDecimal[] s = (BigDecimal[])hmSum.get(pair);
                    if (s == null) {
                        hmSum.put(pair, new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero});
                    }
                }
            }
        }
    }

    private boolean getPL(BigDecimal[] bg) {
        for (int i = 0; i < bg.length; ++i) {
            if (bg[i].signum() < 0) {
                return true;
            }
            if (bg[i].signum() < 0) continue;
            return false;
        }
        return true;
    }

    private VoucherInfo getNewPLVoucher(Context ctx, TransPlProgramFilter<VoucherInfo> filter) throws BOSException, EASBizException {
        VoucherInfo vch = this.getNewVoucher(ctx, filter);
        vch.setSourceType(SourceType.PROFIT_AND_LOSS);
        return vch;
    }

    private VoucherInfo getNewVoucher(Context ctx, TransPlProgramFilter<VoucherInfo> filter) throws BOSException, EASBizException {
        VoucherInfo vch = new VoucherInfo();
        vch.setDescription(filter.getFilterVchDesc());
        vch.setBizDate(filter.getCurServerTime());
        vch.setBookedDate(filter.getCurServerTime());
        vch.setCompany(filter.getCompanyOrgUnit());
        if (filter.getVoucherDateType() == 1) {
            if (filter.getCurServerTime().compareTo(filter.getTransCompanyPeriod().getEndDate()) > 0) {
                vch.setBizDate((Date)filter.getTransCompanyPeriod().getEndDate());
                vch.setBookedDate((Date)filter.getTransCompanyPeriod().getEndDate());
            } else if (filter.getCurServerTime().compareTo(filter.getTransCompanyPeriod().getBeginDate()) < 0) {
                throw new GLPeriodEndException(GLPeriodEndException.SYSDATA_GREATER_THAN_PEIOD);
            }
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)vch.getBookedDate(), (CompanyOrgUnitInfo)filter.getCompanyOrgUnit());
            vch.setPeriod(period);
        } else {
            vch.setPeriod(filter.getTransCompanyPeriod());
        }
        vch.setCreator(filter.getCurUser());
        vch.setHandler(filter.getCurUser());
        vch.setAttachments(0);
        vch.setSourceSys(SystemEnum.GENERALLEDGER);
        VoucherTypeInfo transVoucherType = filter.getTransVoucherType();
        vch.setVoucherType(transVoucherType);
        return vch;
    }

    private String getVchTransPnLSql(TransPLProgramInfo transPlProgramInfo, TransPlProgramFilter<VoucherInfo> filter, boolean isOrderBy) {
        int balType;
        boolean useReport = filter.isParamUseReportCurrency();
        boolean isByAsstTrans = filter.isTransMethodByAsst();
        boolean isQtyByAsst = filter.isQtyByAsst();
        String accountFilterSql = this.getAccountFilterSql(filter);
        BigDecimal minQtyByPrecision = filter.getMinQtyByPrecision();
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
        Map baseNumberFrom = filter.getBaseNumberFrom();
        Map baseNumberTo = filter.getBaseNumberTo();
        List asstActInfoList = filter.getAsstActInfoList();
        StringBuffer sql = new StringBuffer();
        int n = balType = transPlProgramInfo.isIncludeNoPostVoucher() ? 1 : 5;
        if (!isByAsstTrans) {
            sql.append(" select vbal.fnumber,  vbal.FAccountDC, vbal.FAccountID, vbal.FAssistGrpID,  vbal.FCurrencyID   ,  vbal.FIsQty   ,  vbal.FDefaultUnitID  ,  vbal.FEndBalanceFor,  vbal.FEndBalanceLocal  ,  vbal.FEndBalanceRpt,  vbal.FEndQty                                                         \t\t\t\r\n");
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\t' ' as FAssistGrpID,       \t\t\t\t\t\r\n");
            sql.append(" \tbal.FCurrencyID, acct.FIsQty, mugrp.FDefaultUnitID,                                     \r\n");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty\t\t\t\t\r\n");
            sql.append(" from " + GLBalanceUtils.getAccountBalanceTable(balType) + " bal                                                               \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                  \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t                                                                \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                                    \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\t\t\t\t\t\t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" and asst.FCAA is  null)\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" union                                                                                      \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
            sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " bal                                                                \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                  \r\n");
            sql.append(" \tand (asst.FCAA is not null)\t                                             \t            \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                          \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and (acct.fisqty<>1 or asst.fisqty<>1)                                                 \r\n");
            }
            sql.append("                                                                                            \r\n");
            if (isQtyByAsst) {
                sql.append(" union                                                                                      \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
                sql.append(" from " + GLBalanceUtils.getAssistMeasureBalanceTable(balType) + "  bal                                                           \r\n");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand asst.FPeriodID = ?                                                                  \r\n");
                sql.append(" \tand (asst.FCAA is not null)\t                                                        \t\r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and (acct.fisqty=1 and  asst.fisqty=1)                                                 \r\n");
            }
            sql.append(" )vbal                                                                                      \r\n");
            if (isOrderBy) {
                sql.append(" order by vbal.FCurrencyID, vbal.fnumber,vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            }
        } else if (!(!isByAsstTrans || baseNumberFrom != null && baseNumberFrom.size() != 0 || baseNumberTo != null && baseNumberTo.size() != 0)) {
            AsstActTypeInfo asstActInfo;
            int i;
            int size;
            sql.append(" select vbal.fnumber,  vbal.FAccountDC,  vbal.FAccountID, vbal.FAssistGrpID,  vbal.FCurrencyID   ,  vbal.FIsQty   ,  vbal.FDefaultUnitID  ,  vbal.FEndBalanceFor,  vbal.FEndBalanceLocal  ,  vbal.FEndBalanceRpt,  vbal.FEndQty                                                                   \t\t\t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  , ' ' as " + asstActInfo.getMappingFieldName());
                }
            }
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\t' ' as FAssistGrpID,       \t\t\t\t\t\r\n");
            sql.append(" \tbal.FCurrencyID,  sum(acct.FIsQty) as FIsQty , mugrp.FDefaultUnitID,                                     \r\n");
            sql.append("  sum(bal.FEndBalanceFor) FEndBalanceFor, sum(bal.FEndBalanceLocal) FEndBalanceLocal, sum(bal.FEndBalanceRpt) FEndBalanceRpt, sum(bal.FEndQty   ) FEndQty \t\t\t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  , ' ' as " + asstActInfo.getMappingFieldName());
                }
            }
            sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " bal                                                               \r\n");
            if (isByAsstTrans) {
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            }
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t                                                                \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                                       \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" )\t\t\t\t\t\t\t\t\t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                }
            }
            sql.append("                                                                                            \r\n");
            sql.append(" group by acct.fnumber,acct.FDC, bal.FAccountID, bal.FCurrencyID,mugrp.FDefaultUnitID ");
            sql.append(" union                                                                                      \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  ,hg." + asstActInfo.getMappingFieldName());
                }
            }
            sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " bal                                                                \r\n");
            if (isByAsstTrans) {
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            }
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
            sql.append(" \tand (asst.FCAA is not null)\t                                             \t            \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                             \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and (acct.fisqty<>1 or asst.fisqty<>1)                                                 \r\n");
            }
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                }
            }
            sql.append("                                                                                            \r\n");
            if (isQtyByAsst) {
                sql.append(" union                                                                                      \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
                if (isByAsstTrans) {
                    size = asstActInfoList.size();
                    for (i = 0; i < size; ++i) {
                        asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                        sql.append("  ,hg." + asstActInfo.getMappingFieldName());
                    }
                }
                sql.append(" from " + GLBalanceUtils.getAssistMeasureBalanceTable(balType) + "  bal                                                           \r\n");
                if (isByAsstTrans) {
                    sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
                }
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
                sql.append(" \tand (asst.FCAA is not null)\t                                            \t            \r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and (acct.fisqty=1 and asst.fisqty=1)                                                 \r\n");
                if (isByAsstTrans) {
                    size = asstActInfoList.size();
                    for (i = 0; i < size; ++i) {
                        asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                        sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                    }
                }
            }
            sql.append(" )vbal                                                                                      \r\n");
            sql.append("                                                                                            \r\n");
            if (isOrderBy) {
                sql.append(" order by vbal.FCurrencyID, vbal.fnumber, vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            }
        } else {
            AsstActTypeInfo asstActInfo;
            int i;
            sql.append(" select vbal.*                                                                  \t\t\t\r\n");
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \t' ' as FAssistGrpID, bal.FCurrencyID, sum(acct.FIsQty) as FIsQty , mugrp.FDefaultUnitID,                   \r\n");
            sql.append(" sum(bal.FEndBalanceFor) FEndBalanceFor, sum(bal.FEndBalanceLocal) FEndBalanceLocal, sum(bal.FEndBalanceRpt) FEndBalanceRpt, sum(bal.FEndQty   ) FEndQty         \t\r\n");
            int size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append("  ,' ' as " + asstActInfo.getMappingFieldName());
            }
            sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " bal                                                                \r\n");
            sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
            sql.append(" \tand (asst.FCAA is not null)                                             \t            \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                                           \t\r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                            \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
            sql.append(" group by acct.fnumber,acct.FDC, bal.FAccountID, bal.FCurrencyID,mugrp.FDefaultUnitID ");
            sql.append(" union                                                                                      \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
            size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append("  , hg." + asstActInfo.getMappingFieldName());
            }
            sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " bal                                                                \r\n");
            sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
            sql.append(" \tand (asst.FCAA is not null)\t                                              \t\r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                             \t\r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                    \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and (acct.fisqty<>1 or asst.fisqty<>1)                                                 \r\n");
            }
            this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
            if (isQtyByAsst) {
                sql.append(" union                                                                                      \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  , hg." + asstActInfo.getMappingFieldName());
                }
                sql.append(" from " + GLBalanceUtils.getAssistMeasureBalanceTable(balType) + "  bal                                                           \r\n");
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty = 4\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
                sql.append(" \tand (asst.FCAA is not null)\t                                              \t\r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t\r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and (acct.fisqty=1 and asst.fisqty=1)                                                 \r\n");
                this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
            }
            sql.append(" )vbal                                                                                      \r\n");
            if (isOrderBy) {
                sql.append(" order by vbal.FCurrencyID, vbal.fnumber,vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            }
        }
        return sql.toString();
    }

    private void appendAssActFilter(Map baseNumberFrom, Map baseNumberTo, List asstActInfoList, StringBuffer sql) {
        int size = asstActInfoList.size();
        for (int i = 0; i < size; ++i) {
            AsstActTypeInfo asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
            String numStr = "cus" + i + (asstActInfo.isUseLongNumber() ? ".flongnumber" : ".fnumber");
            String fromNumber = (String)baseNumberFrom.get(asstActInfo.getAsstHGAttribute());
            String toNumber = (String)baseNumberTo.get(asstActInfo.getAsstHGAttribute());
            if (fromNumber != null && toNumber != null) {
                sql.append("  and (").append(numStr).append(" in ('").append(fromNumber).append("','").append(toNumber).append("')").append("  or (").append(numStr).append(">'").append(fromNumber).append("'").append("  and ").append(numStr).append("<'").append(toNumber).append("'))");
            } else if (fromNumber != null) {
                sql.append("  and ").append(numStr).append(">='").append(fromNumber).append("'");
            } else if (toNumber != null) {
                sql.append("  and ").append(numStr).append("<='").append(toNumber).append("'");
            }
            sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
        }
    }

    private String getAccountFilterSql(TransPlProgramFilter<VoucherInfo> filter) {
        String accountFilterSql = null;
        if (!filter.isAllAccount() && filter.getHmPLAccount() != null && filter.getHmPLAccount().size() > 0) {
            StringBuffer acctFilterSb = new StringBuffer();
            Set accountIdSet = filter.getHmPLAccount().keySet();
            Iterator it = accountIdSet.iterator();
            int i = 0;
            acctFilterSb.append("(");
            while (it.hasNext()) {
                String accountId = (String)it.next();
                if (i == 0) {
                    acctFilterSb.append("'").append(accountId).append("'");
                } else {
                    acctFilterSb.append(",'").append(accountId).append("'");
                }
                ++i;
            }
            acctFilterSb.append(")");
            accountFilterSql = acctFilterSb.toString();
        }
        return accountFilterSql;
    }

    protected TransPlProgramFilter<VoucherInfo> genVchTransPnL0(Context ctx, TransPlProgramFilter<VoucherInfo> filter, TransPLProgramInfo transPlProgramInfo) throws BOSException, EASBizException {
        String transCompanyID = filter.getCompanyOrgUnit().getId().toString();
        String curUserID = filter.getCurUser().getId().toString();
        PeriodInfo transPeriod = filter.getTransCompanyPeriod();
        String transPeriodID = transPeriod.getId().toString();
        UserInfo curUser = new UserInfo();
        curUser.setId(BOSUuid.read((String)curUserID));
        filter.setCurUser(curUser);
        filter.setCurServerTime(filter.getFilterVchDate());
        boolean isQtyByAsst = filter.isQtyByAsst();
        BigDecimal minQtyByPrecision = filter.getMinQtyByPrecision();
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
        HashMap hmAllParam = filter.getHmGLParam();
        int priceScale = new Integer(hmAllParam.get("GL_003").toString());
        int vchGenPLSeparate = filter.getFilterVchPLType();
        int vchGenProfitOrLoss = filter.getFilterVchProfitLoss();
        HashMap hmPLAccount = filter.getHmPLAccount();
        String vchDesc = filter.getFilterVchDesc();
        boolean transByDC = filter.isFilterTransPLByBalOppDC();
        String accountFilterSql = this.getAccountFilterSql(filter);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int vchCount = 0;
        int balType = transPlProgramInfo.isIncludeNoPostVoucher() ? 1 : 5;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" select vbal.*                                                                  \t\t\t\r\n");
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append("\t' ' as FAssistGrpID,       \t\t\t\t\t\r\n");
            sql.append(" \tbal.FCurrencyID, acct.FIsQty, mugrp.FDefaultUnitID,                                     \r\n");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndQty               \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" from " + GLBalanceUtils.getAccountBalanceTable(balType) + " bal                                                               \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID and acct.fcompanyid = bal.FOrgUnitID \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty = 4    \r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t                                                      \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                              \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" or asst.FCAA is not null)\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" union all                                                                                     \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndQty               \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " bal                                                                \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID and acct.fcompanyid = bal.FOrgUnitID \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty = 4\t\t\r\n");
            sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
            sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
            sql.append(" \tand (asst.FCAA is not null)\t                                              \t\r\n");
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                          \t\r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                             \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and acct.fisqty<>1                                                  \r\n");
            }
            sql.append("                                                                                            \r\n");
            if (isQtyByAsst) {
                sql.append(" union all                                                                                     \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndQty               \t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(" from " + GLBalanceUtils.getAssistMeasureBalanceTable(balType) + "  bal                                                           \r\n");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID and acct.fcompanyid = bal.FOrgUnitID \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty = 4\t   \r\n");
                sql.append(" \tinner join " + this.T_TMP_AsstAccount + " asst on asst.FAccountID = acct.FID                 \r\n");
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FOrgUnitID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand asst.FPeriodID = ?                                                                   \r\n");
                sql.append(" \tand (asst.FCAA is not null)\t                                              \t\r\n");
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                             \t\r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and acct.fisqty=1                                                  \r\n");
                sql.append(" and exists (");
                sql.append(" select 1 \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" from " + GLBalanceUtils.getAssistBalanceTable(balType) + " b                                                                   \r\n");
                sql.append(" where                                                                                       \r\n");
                sql.append("    bal.faccountid = b.FAccountID and bal.FCurrencyID = b.FCurrencyID and bal.FAssistGrpID = b.FAssistGrpID \r\n");
                sql.append(" \tand b.FOrgUnitID = ?                                                                      \r\n");
                sql.append(" \tand b.FPeriod = ?                                                                       \r\n");
                sql.append(" \tand (b.FEndBalanceFor <> 0 \tor abs(b.FEndQty)>=").append(minQtyByPrecision).append(" \t  )\r\n");
                sql.append(" \t                                                           \r\n");
                sql.append(")");
                sql.append("                                                                                            \r\n");
            }
            sql.append(" )vbal                                                                                      \r\n");
            sql.append(" order by vbal.FCurrencyID, vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            this.buildAsstAccountTable(ctx, transCompanyID, transPeriod.getId().toString(), filter.getCompanyOrgUnit().getAccountTable().getId().toString(), filter);
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyID);
            stmt.setInt(index++, transPeriod.getNumber());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transPeriod.getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyID);
            stmt.setInt(index++, transPeriod.getNumber());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transPeriod.getId().toString());
            if (isQtyByAsst) {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyID);
                stmt.setInt(index++, transPeriod.getNumber());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transPeriod.getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyID);
                stmt.setInt(index++, transPeriod.getNumber());
            }
            rs = stmt.executeQuery();
            IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
            VoucherInfo preVch1 = this.getNewPLVoucher(ctx, filter);
            VoucherInfo preVch2 = this.getNewPLVoucher(ctx, filter);
            HashMap<AccountViewInfo, BigDecimal> hmPLAcctSum1 = new HashMap<AccountViewInfo, BigDecimal>();
            HashMap hmPLAcctSum2 = new HashMap();
            VoucherEntryInfo preEntry = null;
            String preCurId = null;
            CurrencyInfo preCur = null;
            HashMap<AccountViewInfo, BigDecimal> preSum = null;
            HashMap hmUnSelectedAccount = filter.getHmUnSelectedAccount();
            while (rs.next()) {
                boolean newEntry;
                int acctDC = rs.getInt("FAccountDC");
                String acctId = rs.getString("FAccountID");
                String curId = rs.getString("FCurrencyID");
                String grpId = rs.getString("FAssistGrpID");
                BigDecimal sum = rs.getBigDecimal("FEndBalanceFor");
                BigDecimal qty = rs.getBigDecimal("FEndQty");
                boolean isQty = true;
                if (hmUnSelectedAccount.containsKey(acctId)) continue;
                if (!curId.equals(preCurId)) {
                    this.addPLEntry(preEntry, hmPLAccount, preSum);
                    if (vchGenProfitOrLoss == 1) {
                        hmPLAcctSum2.clear();
                        preVch2.getEntries().clear();
                    } else if (vchGenProfitOrLoss == 2) {
                        hmPLAcctSum1.clear();
                        preVch1.getEntries().clear();
                    }
                    if (vchGenPLSeparate == 1) {
                        vchCount += this.genPLEntry(ctx, hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl, filter, transPlProgramInfo);
                        vchCount += this.genPLEntry(ctx, hmPLAcctSum2, preVch2, vchDesc, preCur, vchCtrl, filter, transPlProgramInfo);
                    } else {
                        preVch1.getEntries().addCollection(preVch2.getEntries());
                        this.combineSum(hmPLAcctSum1, hmPLAcctSum2);
                        vchCount += this.genPLEntry(ctx, hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl, filter, transPlProgramInfo);
                    }
                    preVch1 = this.getNewPLVoucher(ctx, filter);
                    preVch2 = this.getNewPLVoucher(ctx, filter);
                    hmPLAcctSum1.clear();
                    hmPLAcctSum2.clear();
                    preEntry = null;
                    preCurId = curId;
                    CurrencyInfo cur = new CurrencyInfo();
                    cur.setId(BOSUuid.read((String)curId));
                    preVch1.setCurrency(cur);
                    preVch2.setCurrency(cur);
                    preCur = cur;
                    preSum = null;
                }
                boolean bl = newEntry = " ".equals(grpId) || "".equals(grpId);
                if (newEntry) {
                    HashMap<AccountViewInfo, BigDecimal> hmSum;
                    this.addPLEntry(preEntry, hmPLAccount, preSum);
                    boolean pl = this.getPL(new BigDecimal[]{sum, qty});
                    VoucherInfo vch = pl ? preVch1 : preVch2;
                    HashMap<Object, BigDecimal> hashMap = hmSum = pl ? hmPLAcctSum1 : hmPLAcctSum2;
                    if (!GlUtils.isAllZeroOrNull(new BigDecimal[]{sum, qty})) {
                        AccountViewInfo plAcct = (AccountViewInfo)hmPLAccount.get(acctId);
                        if (plAcct == null) continue;
                        BigDecimal s = (BigDecimal)hmSum.get(plAcct);
                        if (s == null) {
                            hmSum.put(plAcct, sum);
                        } else {
                            hmSum.put(plAcct, s.add(sum));
                        }
                    }
                    preEntry = new VoucherEntryInfo();
                    preEntry.setOprStatus(1);
                    preEntry.setBill(vch);
                    preEntry.setDescription(vchDesc);
                    AccountViewInfo acct = new AccountViewInfo();
                    acct.setId(BOSUuid.read((String)acctId));
                    acct = (AccountViewInfo)AccountViewFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(acctId));
                    acct.setCAA(this.getCAA(ctx, transCompanyID, vch.getPeriod().getId().toString(), acctId));
                    preEntry.setCAA(acct.getCAA());
                    preEntry.setAccount(acct);
                    preEntry.setCurrency(preCur);
                    EntryDC dc = EntryDC.CREDIT;
                    BigDecimal es = sum;
                    BigDecimal eq = qty;
                    if (transByDC && vch == preVch1 || !transByDC && acctDC == -1) {
                        es = sum.negate();
                        eq = qty.negate();
                        dc = EntryDC.DEBIT;
                    }
                    preEntry.setEntryDC(dc);
                    preEntry.setOriginalAmount(es);
                    if (isQty && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                        MeasureUnitInfo mu = new MeasureUnitInfo();
                        mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                        preEntry.setMeasureUnit(mu);
                        preEntry.setQuantity(eq);
                        preEntry.setStandardQuantity(eq);
                        if (!GlUtils.zero.equals(eq)) {
                            preEntry.setPrice(sum.divide(eq, priceScale, 4).abs());
                        } else {
                            preEntry.setPrice(GlUtils.zero);
                        }
                    }
                    preSum = hmSum;
                    continue;
                }
                VoucherAssistRecordInfo rec = new VoucherAssistRecordInfo();
                rec.setOprStatus(1);
                rec.setBizDate(filter.getFilterVchDate());
                rec.setDescription(vchDesc);
                AssistantHGInfo hg = new AssistantHGInfo();
                hg.setId(BOSUuid.read((String)grpId));
                rec.setAssGrp(hg);
                rec.setEndDate(filter.getFilterVchDate());
                BigDecimal as = sum;
                BigDecimal aq = qty;
                if (EntryDC.DEBIT.equals((Object)preEntry.getEntryDC())) {
                    as = sum.negate();
                    aq = qty.negate();
                }
                rec.setOriginalAmount(as);
                if (isQty) {
                    rec.setQuantity(aq);
                }
                if (isQtyByAsst && isQty && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                    MeasureUnitInfo mu = new MeasureUnitInfo();
                    mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                    rec.setMeasureUnit(mu);
                }
                preEntry.getAssistRecords().add(rec);
            }
            this.addPLEntry(preEntry, hmPLAccount, preSum);
            if (vchGenProfitOrLoss == 1) {
                hmPLAcctSum2.clear();
                preVch2.getEntries().clear();
            } else if (vchGenProfitOrLoss == 2) {
                hmPLAcctSum1.clear();
                preVch1.getEntries().clear();
            }
            if (vchGenPLSeparate == 1) {
                vchCount += this.genPLEntry(ctx, hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl, filter, transPlProgramInfo);
                filter.setReturnVch1(preVch1);
                vchCount += this.genPLEntry(ctx, hmPLAcctSum2, preVch2, vchDesc, preCur, vchCtrl, filter, transPlProgramInfo);
                filter.setReturnVch2(preVch2);
            } else {
                preVch1.getEntries().addCollection(preVch2.getEntries());
                this.combineSum(hmPLAcctSum1, hmPLAcctSum2);
                vchCount += this.genPLEntry(ctx, hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl, filter, transPlProgramInfo);
                filter.setReturnVch1(preVch1);
            }
            if (vchCount == 0) {
                throw new GLPeriodEndException(GLPeriodEndException.TRANSPL_NO_PLBAL);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        filter.setReturnVchCount(vchCount);
        return filter;
    }

    private void combineSum(HashMap hmPLAcctSum1, HashMap hmPLAcctSum2) {
        if (hmPLAcctSum2.size() == 0) {
            return;
        }
        if (hmPLAcctSum1.size() == 0) {
            hmPLAcctSum1.putAll(hmPLAcctSum2);
            return;
        }
        for (Map.Entry e : hmPLAcctSum2.entrySet()) {
            BigDecimal s2 = (BigDecimal)e.getValue();
            BigDecimal s1 = (BigDecimal)hmPLAcctSum1.get(e.getKey());
            if (s1 != null) {
                hmPLAcctSum1.put(e.getKey(), s1.add(s2));
                continue;
            }
            hmPLAcctSum1.put(e.getKey(), s2);
        }
    }

    private int genPLEntry(Context ctx, HashMap hmPLAcctSum, VoucherInfo vch, String vchDesc, CurrencyInfo cur, IVoucher vchCtrl, TransPlProgramFilter<VoucherInfo> filter, TransPLProgramInfo transPlProgramInfo) throws BOSException, EASBizException {
        for (Map.Entry e : hmPLAcctSum.entrySet()) {
            AccountViewInfo plAcct = null;
            BigDecimal sum = null;
            if (e.getKey() instanceof GLPeriodEndFacadeControllerBean.AccountCurrencyPair) {
                plAcct = ((GLPeriodEndFacadeControllerBean.AccountCurrencyPair)e.getKey()).getAccount();
                sum = GlUtils.zero;
            } else {
                plAcct = (AccountViewInfo)e.getKey();
                sum = (BigDecimal)e.getValue();
            }
            EntryDC dc = EntryDC.DEBIT;
            if (sum.signum() < 0) {
                sum = sum.negate();
                dc = EntryDC.CREDIT;
            }
            VoucherEntryInfo entry = new VoucherEntryInfo();
            entry.setOprStatus(1);
            entry.setDescription(vchDesc);
            entry.setAccount(plAcct);
            entry.setCAA(plAcct.getCAA());
            entry.setCurrency(cur);
            entry.setEntryDC(dc);
            entry.setOriginalAmount(sum);
            if (plAcct.isIsQty()) {
                entry.setMeasureUnit(plAcct.getMeasureUnitGroupID().getDefaultUnit());
                entry.setQuantity(GlUtils.zero);
                entry.setPrice(GlUtils.zero);
            }
            if (plAcct.getCAA() != null) {
                VoucherAssistRecordInfo rec = new VoucherAssistRecordInfo();
                rec.setOprStatus(1);
                rec.setDescription(vchDesc);
                rec.setQuantity(entry.getQuantity());
                rec.setOriginalAmount(entry.getOriginalAmount());
                entry.getAssistRecords().add(rec);
            }
            vch.getEntries().add(entry);
        }
        if (vch.getEntries().size() > 0) {
            IObjectPK id = vchCtrl.save((CoreBaseInfo)vch);
            vch.setId(BOSUuid.read((String)id.toString()));
            this.existsVoucher.put(id.toString(), id.toString());
            TransPLProgramVoucherRefInfo transVchRef2 = new TransPLProgramVoucherRefInfo();
            transVchRef2.setTransplprogram(transPlProgramInfo);
            transVchRef2.setVoucher(vch);
            transVchRef2.setCompany(filter.getCompanyOrgUnit());
            transVchRef2.setPeriod(filter.getTransCompanyPeriod());
            TransPLProgramVoucherRefFactory.getLocalInstance(ctx).save(transVchRef2);
            return 1;
        }
        return 0;
    }

    private void resetEntryMeasureUnit(Context ctx, BaseVoucherInfo voucher, TransPlProgramFilter<VoucherInfo> filter) throws EASBizException, BOSException, Exception {
        VoucherEntryCollection entries = (VoucherEntryCollection)voucher.getEntries();
        HashMap hmAllParam = filter.getHmGLParam();
        int priceScale = new Integer(hmAllParam.get("GL_003").toString());
        int qtyPre = 2;
        if (hmAllParam.get("GL_002") != null) {
            try {
                qtyPre = Integer.parseInt(hmAllParam.get("GL_002").toString());
                if (qtyPre < 0) {
                    qtyPre = 2;
                }
            }
            catch (Exception ignore) {
                qtyPre = 2;
            }
        }
        for (VoucherEntryInfo entry : entries) {
            if (!entry.getAccount().isIsQty() || entry.getAssistRecords() != null && entry.getAssistRecords().size() != 0) continue;
            MeasureUnitInfo measure = null;
            if (filter.isQtyByAsst()) {
                AccountViewInfo acct = (AccountViewInfo)AccountViewFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(entry.getAccount().getId().toString()));
                measure = acct.getMeasureUnitID();
                entry.setQuantity(this.setQtyByMuCft(ctx, entry.getQuantity(), measure, qtyPre, 1));
            } else {
                measure = this.getAccountMeasure(ctx, entry.getAccount().getMeasureUnitGroupID());
            }
            if (measure == null || entry.getMeasureUnit() != null || measure.getId() == null) continue;
            entry.setMeasureUnit(measure);
            if (entry.getQuantity() != null && entry.getQuantity().compareTo(GlUtils.zero) != 0) {
                entry.setPrice(entry.getOriginalAmount().divide(entry.getQuantity(), priceScale, 4));
                continue;
            }
            if (entry.getPrice() != null) continue;
            entry.setPrice(GlUtils.zero);
        }
    }

    private MeasureUnitInfo getAccountMeasure(Context ctx, MeasureUnitGroupInfo measureUnitGroup) throws EASBizException, BOSException, Exception {
        if (measureUnitGroup != null && measureUnitGroup.getId() != null) {
            return this.getAccountMU(ctx, measureUnitGroup.getId().toString());
        }
        return null;
    }

    protected MeasureUnitInfo getAccountMU(Context ctx, String acctDefautMUGroupId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        MeasureUnitInfo measureUnit = null;
        boolean hasDefault = false;
        String name = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append(" select measure2.* from  t_BD_MeasureUnitGroup mgroup   \r\n");
        sql.append(" inner join  t_BD_MeasureUnit measure2 on  measure2.FID=mgroup.fdefaultunitid     \r\n");
        sql.append(" where mgroup.fid=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{acctDefautMUGroupId});
        measureUnit = new MeasureUnitInfo();
        try {
            if (rs.next()) {
                measureUnit.setId(BOSUuid.read((String)rs.getString("FID")));
                measureUnit.setName(rs.getString(name));
                measureUnit.setCoefficient(rs.getBigDecimal("FCoefficient"));
                measureUnit.setIsBaseUnit(rs.getBoolean("FIsBaseUnit"));
                hasDefault = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!hasDefault) {
            sql = new StringBuffer();
            sql.append(" select measure2.* from  t_BD_MeasureUnitGroup mgroup   \r\n");
            sql.append(" inner join  t_BD_MeasureUnit measure2 on  measure2.FgroupID=mgroup.fid     \r\n");
            sql.append(" where mgroup.fid=? and measure2.fcoefficient=1");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{acctDefautMUGroupId});
            measureUnit = new MeasureUnitInfo();
            try {
                if (rs.next()) {
                    measureUnit.setId(BOSUuid.read((String)rs.getString("FID")));
                    measureUnit.setName(rs.getString(name));
                    measureUnit.setCoefficient(rs.getBigDecimal("FCoefficient"));
                    measureUnit.setIsBaseUnit(rs.getBoolean("FIsBaseUnit"));
                    hasDefault = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return measureUnit;
    }

    private boolean isInitClosed(Context ctx, String companyID) throws BOSException, EASBizException {
        IGLFlag flagCtrl = GLFlagFactory.getLocalInstance(ctx);
        return flagCtrl.getGLInitClosed(companyID);
    }

    private UserInfo getCurrentUser(Context ctx) throws BOSException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        return user;
    }

    private String getStr(Context ctx, String id) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)id, (Locale)ctx.getLocale());
    }

    private Map<String, AsstAccountInfo> getCAAs(String companyId, String periodId) {
        String key = companyId + "-" + periodId;
        Map<String, AsstAccountInfo> caas = this.caass.get(key);
        if (caas == null) {
            caas = new HashMap<String, AsstAccountInfo>();
            this.caass.put(key, caas);
        }
        return caas;
    }

    private AsstAccountInfo getCAA(Context ctx, String companyId, String periodId, String accountId) throws EASBizException, BOSException {
        Map<String, AsstAccountInfo> caas = this.getCAAs(companyId, periodId);
        return GLAsstAccountUtils.getCAA(ctx, accountId, periodId, caas);
    }

    private void buildAsstAccountTable(Context ctx, String companyId, String periodId, String accountTable, String where) throws BOSException, EASBizException {
        Map<String, AsstAccountInfo> caas = this.getCAAs(companyId, periodId);
        GLAsstAccountUtils.buildAsstAccountTable(ctx, companyId, periodId, accountTable, this.T_TMP_AsstAccount, true, caas, where);
    }

    private void buildAsstAccountTable(Context ctx, String companyId, String periodId, String accountTable, TransPlProgramFilter<VoucherInfo> filter) throws BOSException, EASBizException {
        Set<String> accountIds = null;
        if (!filter.isAllAccount() && filter.getHmPLAccount() != null && filter.getHmPLAccount().size() > 0) {
            accountIds = filter.getHmPLAccount().keySet();
        }
        if (accountIds != null) {
            Map<String, AsstAccountInfo> caas = this.getCAAs(companyId, periodId);
            Set<String> ids = GLAsstAccountUtils.filterAsstAccountTable(ctx, periodId, this.T_TMP_AsstAccount, true, accountIds);
            if (ids.size() > 0) {
                GLAsstAccountUtils.buildAsstAccountTable(ctx, periodId, this.T_TMP_AsstAccount, true, caas, ids);
            }
        } else {
            String where = "av.FIsLeaf = 1 and av.fbw = 0 and at.FProperty = 4 \n";
            this.buildAsstAccountTable(ctx, companyId, periodId, accountTable, where);
        }
    }

    private boolean checkVchIsClosed(Context ctx, String companyId, String adjustPeriodID) throws BOSException, EASBizException, GLPeriodEndException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = null;
            int index = 1;
            if (adjustPeriodID != null) {
                sql = new StringBuffer();
                sql.append("select Top 1 1\t \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("from t_GL_Voucher vch \t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tvch.FCompanyID = ?\t\t\t\t\t\t--\u53c2\u6570\uff1a\u7ec4\u7ec7ID      \r\n");
                sql.append("\tand vch.FPeriodID =");
                sql.append("?         --\u53c2\u6570\uff1a\u671f\u95f4ID      \r\n");
                sql.append("\tand vch.fisclose = 0;\r\n");
                stmt = con.prepareStatement(sql.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyId);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)adjustPeriodID);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    boolean bl = true;
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                    return bl;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return false;
    }

    private ArrayList<VoucherInfo> splitVoucher(Context ctx, VoucherInfo voucher, TransPlProgramFilter<VoucherInfo> filter, TransPLProgramInfo transPlProgramInfo) throws Exception {
        ArrayList<VoucherInfo> vouchers = new ArrayList<VoucherInfo>();
        CompanyOrgUnitInfo company = filter.getCompanyOrgUnit();
        int splitSize = transPlProgramInfo.getSplitSize();
        AccountViewInfo yearProfitAcct = transPlProgramInfo.getYearProfitAcct();
        VoucherEntryCollection entries = voucher.getEntries();
        Iterator entryIterator = entries.iterator();
        while (entryIterator.hasNext()) {
            VoucherEntryInfo entry = (VoucherEntryInfo)entryIterator.next();
            AccountViewInfo account = entry.getAccount();
            String accountID = account.getId().toString();
            if (!yearProfitAcct.getId().toString().equals(accountID)) continue;
            entryIterator.remove();
        }
        voucher.setEntries(null);
        entryIterator = entries.iterator();
        int count = 0;
        VoucherInfo newVoucher = (VoucherInfo)voucher.clone();
        VoucherEntryInfo newEntry = null;
        block1: while (entryIterator.hasNext()) {
            if (newVoucher.getEntries() == null) {
                newVoucher.setEntries((AbstractObjectCollection)new VoucherEntryCollection());
            }
            if (count < splitSize) {
                VoucherEntryInfo entry = (VoucherEntryInfo)entryIterator.next();
                if (entry.getAssistRecords() != null && entry.getAssistRecords().size() > 0) {
                    VoucherAssistRecordCollection voucherAssistRecordCollection = entry.getAssistRecords();
                    entry.setAssistRecords(null);
                    newEntry = (VoucherEntryInfo)entry.clone();
                    newVoucher.getEntries().add(newEntry);
                    Iterator recordIterator = voucherAssistRecordCollection.iterator();
                    while (recordIterator.hasNext()) {
                        if (count < splitSize) {
                            VoucherAssistRecordInfo voucherAssistRecord = (VoucherAssistRecordInfo)recordIterator.next();
                            if (newEntry.getAssistRecords() == null) {
                                newEntry.setAssistRecords((AbstractObjectCollection)new VoucherAssistRecordCollection());
                            }
                            newEntry.getAssistRecords().add(voucherAssistRecord);
                            recordIterator.remove();
                            ++count;
                            continue;
                        }
                        vouchers.add(newVoucher);
                        newVoucher = (VoucherInfo)voucher.clone();
                        count = 0;
                        if (!recordIterator.hasNext()) continue block1;
                        newEntry = (VoucherEntryInfo)entry.clone();
                        newVoucher.setEntries((AbstractObjectCollection)new VoucherEntryCollection());
                        newVoucher.getEntries().add(newEntry);
                    }
                    continue;
                }
                newVoucher.getEntries().add(entry);
                ++count;
                continue;
            }
            vouchers.add(newVoucher);
            newVoucher = (VoucherInfo)voucher.clone();
            count = 0;
        }
        if (count != 0) {
            vouchers.add(newVoucher);
        }
        int qtyScale = Integer.parseInt(filter.getHmGLParam().get("GL_002").toString());
        int priceScale = Integer.parseInt(filter.getHmGLParam().get("GL_003").toString());
        boolean isLocal = false;
        if (company.getReportConvertMode() != null) {
            isLocal = ReportCurrencyConvertMode.Base.equals((Object)company.getReportConvertMode());
        }
        for (VoucherInfo voucherInfo : vouchers) {
            this.sumAssistRecordQtyToEntry(voucherInfo, qtyScale, priceScale);
        }
        ArrayList<VoucherInfo> result = new ArrayList<VoucherInfo>();
        String vchDesc = filter.getFilterVchDesc();
        for (VoucherInfo voucherInfo : vouchers) {
            entries = voucherInfo.getEntries();
            entryIterator = entries.iterator();
            HashMap hmPLAcctSum = new HashMap();
            while (entryIterator.hasNext()) {
                VoucherEntryInfo entry = (VoucherEntryInfo)entryIterator.next();
                this.buildHmPLAcctSum(entry, yearProfitAcct, hmPLAcctSum, filter);
            }
            this.genPLEntryEx(ctx, hmPLAcctSum, voucherInfo, vchDesc, null, filter, isLocal, this.hmLocalEx, this.hmRptEx, 1, true);
            voucherInfo = this.lazyLoad(ctx, voucherInfo, yearProfitAcct);
            this.resetEntryMeasureUnit(ctx, (BaseVoucherInfo)voucherInfo, filter);
            if (transPlProgramInfo.isIsDebitFirst()) {
                this.sortVoucherEntry(voucherInfo, transPlProgramInfo);
            }
            result.add(voucherInfo);
        }
        return result;
    }

    private HashMap buildHmPLAcctSum(VoucherEntryInfo entry, AccountViewInfo yearProfitAcct, HashMap hmSum, TransPlProgramFilter<VoucherInfo> filter) {
        CurrencyInfo cur = entry.getCurrency();
        CurrencyInfo cur2 = new CurrencyInfo();
        cur2.setId(BOSUuid.read((String)this.curId2));
        BigDecimal org = entry.getOriginalAmount();
        BigDecimal loc = entry.getLocalAmount();
        BigDecimal rpt = entry.getReportingAmount();
        BigDecimal qty = entry.getQuantity();
        EntryDC entryDC = entry.getEntryDC();
        if (EntryDC.DEBIT.equals((Object)entryDC)) {
            loc = loc.negate();
            org = org.negate();
            rpt = rpt.negate();
            qty = qty.negate();
        }
        GLPeriodEndFacadeControllerBean.AccountCurrencyPair pair = this.isState ? new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(yearProfitAcct, cur2) : new GLPeriodEndFacadeControllerBean.AccountCurrencyPair(yearProfitAcct, cur);
        if (GlUtils.isAllZeroOrNull(new BigDecimal[]{org, loc, rpt, qty})) {
            BigDecimal[] s = (BigDecimal[])hmSum.get(pair);
            if (s == null) {
                hmSum.put(pair, new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero});
            } else {
                s[0] = s[0].add(GlUtils.zero);
                s[1] = s[1].add(GlUtils.zero);
                s[2] = s[2].add(GlUtils.zero);
            }
        } else {
            BigDecimal[] s = (BigDecimal[])hmSum.get(pair);
            if (s == null) {
                hmSum.put(pair, new BigDecimal[]{org, loc, rpt});
            } else {
                s[0] = s[0].add(org);
                s[1] = s[1].add(loc);
                s[2] = s[2].add(rpt);
            }
        }
        return hmSum;
    }
}

