/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.UserSettingCollection;
import com.kingdee.eas.fi.gl.UserSettingInfo;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.XmlUtil;
import com.kingdee.eas.fi.gl.app.AbstractUserSettingControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserSettingControllerBean
extends AbstractUserSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.UserSettingControllerBean");
    private static final String NULL_COMPANY_ID = "xxxxxxxx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _save(Context ctx, String companyId, String function, UserSettingObject setting) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            dao.delete(this.getFilterInfo(userId, companyId, function));
            UserSettingInfo info = new UserSettingInfo();
            info.setUserId(userId);
            if (StringUtils.isEmpty((String)companyId)) {
                companyId = NULL_COMPANY_ID;
            }
            info.setCompanyId(companyId);
            info.setFunction(function);
            info.setSetting(setting.toXML());
            dao.addnew((IObjectValue)info);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _save(Context ctx, String userId, String companyId, String function, UserSettingObject setting) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            dao.delete(this.getFilterInfo(userId, companyId, function));
            UserSettingInfo info = new UserSettingInfo();
            info.setUserId(userId);
            if (StringUtils.isEmpty((String)companyId)) {
                companyId = NULL_COMPANY_ID;
            }
            info.setCompanyId(companyId);
            info.setFunction(function);
            info.setSetting(setting.toXML());
            dao.addnew((IObjectValue)info);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UserSettingObject _getValue(Context ctx, String companyId, String function) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("setting"));
        String userId = null;
        if (ctx.get((Object)"module") != null && ctx.get((Object)"module").equals("el_rec") && !StringUtils.isEmpty((String)companyId)) {
            userId = "EL_REC_USER";
            String realId = this.getCompanyId(ctx, companyId);
            if (!StringUtils.isEmpty((String)realId)) {
                companyId = realId;
            }
        } else {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        view.setFilter(this.getFilterInfo(userId, companyId, function));
        Connection cn = null;
        String xmlStr = null;
        try {
            cn = this.getConnection(ctx);
            UserSettingCollection coll = (UserSettingCollection)this.getDAO(ctx, cn).getCollection(view);
            if (coll != null && !coll.isEmpty()) {
                xmlStr = coll.get(0).getSetting();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        try {
            if (xmlStr != null) {
                Map settingMap = XmlUtil.xml2Map(xmlStr);
                UserSettingObject setting = new UserSettingObject(settingMap);
                return setting;
            }
        }
        catch (Exception e) {
            logger.error((Object)"JDOMException", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UserSettingObject _getValue(Context ctx, String userId, String companyId, String function) throws BOSException {
        String realId = this.getCompanyId(ctx, companyId);
        if (!StringUtils.isEmpty((String)realId)) {
            companyId = realId;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("setting"));
        view.setFilter(this.getFilterInfo(userId, companyId, function));
        Connection cn = null;
        String xmlStr = null;
        try {
            cn = this.getConnection(ctx);
            UserSettingCollection coll = (UserSettingCollection)this.getDAO(ctx, cn).getCollection(view);
            if (coll != null && !coll.isEmpty()) {
                xmlStr = coll.get(0).getSetting();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        try {
            if (xmlStr != null) {
                Map settingMap = XmlUtil.xml2Map(xmlStr);
                UserSettingObject setting = new UserSettingObject(settingMap);
                return setting;
            }
        }
        catch (Exception e) {
            logger.error((Object)"JDOMException", (Throwable)e);
        }
        return null;
    }

    private FilterInfo getFilterInfo(String userId, String companyId, String function) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("function", (Object)function));
        if (StringUtils.isEmpty((String)companyId)) {
            companyId = NULL_COMPANY_ID;
        }
        filter.getFilterItems().add(new FilterItemInfo("companyId", (Object)companyId));
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCompanyId(Context ctx, String companyId) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        String result;
        block7: {
            result = null;
            CompanyOrgUnitInfo org = null;
            try {
                org = GlUtils.getCompanyById(ctx, companyId);
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            String longNumber = org.getLongNumber();
            String sql = "select T2.fid from T_GL_UserSetting T1 inner join T_ORG_Company T2 on T1.FCompanyID = T2.FID  where charindex(T2.FLONGNUMBER,'" + longNumber + "') > 0 order by T2.FLevel desc";
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                if (!rs.next()) break block7;
                result = rs.getString("fid");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    @Override
    protected void _saveCF(Context ctx, String userId, String companyId, String function, String setting) throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getValueCF(Context ctx) throws BOSException {
        String sql = "select fblockdata from T_RPTS_StorageFileData where fid in (select fid from T_RPTS_StorageTree where fpath = '/eas/EAS_Note.kdrs/FI/GL/Voucher/Voucher.bos-query')";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer result = new StringBuffer();
        BufferedInputStream is = null;
        InputStream bs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                Blob blob = rs.getBlob("fblockdata");
                bs = blob.getBinaryStream();
                is = new BufferedInputStream(bs);
                byte[] bytes = new byte[(int)blob.length()];
                int len = bytes.length;
                int read = 0;
                for (int offset = 0; offset < len && (read = is.read(bytes, offset, len - offset)) >= 0; offset += read) {
                }
                String str = new String(bytes);
                List<Map<String, String>> list = XmlUtil.xml2List(str);
                for (int i = 0; i < list.size(); ++i) {
                    Map<String, String> map = list.get(i);
                    String name = map.get("Class.Field.name").toString();
                    if (name.indexOf("#") == -1) continue;
                    result.append(name).append(",");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bs != null) {
                try {
                    bs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result.toString();
    }
}

