/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AbstractVchAmortPolicyInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVchAmortDestAccount;
import com.kingdee.eas.fi.gl.IVchAmortDestAssist;
import com.kingdee.eas.fi.gl.IVchAmortLog;
import com.kingdee.eas.fi.gl.IVchAmortPolicy;
import com.kingdee.eas.fi.gl.IVchAmortTargetAccount;
import com.kingdee.eas.fi.gl.IVchAmortTargetAssist;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VchAmortDestAccountCollection;
import com.kingdee.eas.fi.gl.VchAmortDestAccountFactory;
import com.kingdee.eas.fi.gl.VchAmortDestAccountInfo;
import com.kingdee.eas.fi.gl.VchAmortDestAssistCollection;
import com.kingdee.eas.fi.gl.VchAmortDestAssistFactory;
import com.kingdee.eas.fi.gl.VchAmortDestAssistInfo;
import com.kingdee.eas.fi.gl.VchAmortEntryOrder;
import com.kingdee.eas.fi.gl.VchAmortException;
import com.kingdee.eas.fi.gl.VchAmortLogCollection;
import com.kingdee.eas.fi.gl.VchAmortLogFactory;
import com.kingdee.eas.fi.gl.VchAmortLogInfo;
import com.kingdee.eas.fi.gl.VchAmortPolicyCollection;
import com.kingdee.eas.fi.gl.VchAmortPolicyFactory;
import com.kingdee.eas.fi.gl.VchAmortPolicyInfo;
import com.kingdee.eas.fi.gl.VchAmortSchemeFactory;
import com.kingdee.eas.fi.gl.VchAmortSchemeInfo;
import com.kingdee.eas.fi.gl.VchAmortSchemeStatusEnum;
import com.kingdee.eas.fi.gl.VchAmortTargetAccountCollection;
import com.kingdee.eas.fi.gl.VchAmortTargetAccountDC;
import com.kingdee.eas.fi.gl.VchAmortTargetAccountFactory;
import com.kingdee.eas.fi.gl.VchAmortTargetAccountInfo;
import com.kingdee.eas.fi.gl.VchAmortTargetAssistCollection;
import com.kingdee.eas.fi.gl.VchAmortTargetAssistFactory;
import com.kingdee.eas.fi.gl.VchAmortTargetAssistInfo;
import com.kingdee.eas.fi.gl.VchAmortUtils;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractVchAmortSchemeControllerBean;
import com.kingdee.eas.fi.gl.common.GLOrgUtil;
import com.kingdee.eas.fi.gl.validator.AssistCuSuStatusValidator;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VchAmortSchemeControllerBean
extends AbstractVchAmortSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VchAmortSchemeControllerBean");
    private String resClassName = "com.kingdee.eas.fi.gl.GLResource";

    @Override
    protected Map _fetchInitData(Context ctx, String currentCompanyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo curCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompanyId), GlUtils.getCompanySic());
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)curCompany.getId().toString()));
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, ex);
        }
        VoucherTypeCollection vtCol = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypes(curCompany.getCU().getId().toString());
        if (vtCol.size() == 0) {
            throw new GLException(GLException.NOVOUCHERTYPE);
        }
        VoucherTypeInfo vtDefault = vtCol.get(0);
        for (VoucherTypeInfo vt : vtCol) {
            if (!vt.isPretermit()) continue;
            vtDefault = vt;
        }
        result.put("DefaultVoucherType", vtDefault);
        result.put("VoucherTypes", vtCol);
        EntityViewInfo viewCurrency = new EntityViewInfo();
        viewCurrency.getSelector().add(new SelectorItemInfo("id"));
        viewCurrency.getSelector().add(new SelectorItemInfo("name"));
        viewCurrency.getSelector().add(new SelectorItemInfo("precision"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        viewCurrency.setFilter(filterInfo);
        ICurrency ie = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencys = ie.getCurrencyCollection(viewCurrency, true);
        result.put("Currency", currencys);
        PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, curCompany.getId().toString());
        PeriodCollection periods = this.getPeriodsNotBeforeCurrentPeriod(ctx, curPeriod, curCompany);
        result.put("Periods", periods);
        result.put("CurPeriod", curPeriod);
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_001", comPK);
        hmParamIn.put("GL_115", comPK);
        hmParamIn.put("GL_108", comPK);
        hmParamIn.put("GL_111", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean nameFirst = Boolean.FALSE;
        Boolean useProfitCenterAccount = Boolean.FALSE;
        Boolean mustNeedProfitCenter = Boolean.FALSE;
        Boolean paramCommonVoucherProcess = Boolean.FALSE;
        try {
            nameFirst = Boolean.valueOf(hmAllParam.get("GL_001").toString());
            useProfitCenterAccount = Boolean.valueOf(hmAllParam.get("GL_115").toString());
            mustNeedProfitCenter = Boolean.valueOf(hmAllParam.get("GL_108").toString());
            paramCommonVoucherProcess = Boolean.valueOf(hmAllParam.get("GL_111").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_001"});
        }
        result.put("GL_001", nameFirst);
        result.put("GL_115", useProfitCenterAccount);
        result.put("GL_108", mustNeedProfitCenter);
        result.put("GL_111", paramCommonVoucherProcess);
        return result;
    }

    @Override
    protected Map _fetchInitFilterData(Context ctx, String curCompanyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        ICurrency ie = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencys = ie.getCurrencyCollection(view, true);
        result.put("Currency", currencys);
        view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        AccountTableCollection coll = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
        result.put("accountTable", coll);
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap params = new HashMap();
        this.checkSchemeValid(ctx, model, params);
        this.processBeforePersist(ctx, model, params);
        IObjectPK objectPK = this.persistScheme(ctx, model, params);
        return objectPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Object[] params = new Object[]{pk.getKeyValue("id").toString()};
        String sqlSelect = "select top 1 s.fid,s.fnumber from t_gl_vchamortlog vlog inner join t_gl_vchamortscheme s on vlog.famortschemeid=s.fid where s.fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])params);
        try {
            if (rs.next()) {
                throw new VchAmortException(VchAmortException.SCHEME_GEN_VCH_NOT_DEL, new Object[]{rs.getString("fnumber")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String delScheme = "delete from t_gl_vchamortscheme where fid = ?";
        DbUtil.execute((Context)ctx, (String)delScheme, (Object[])params);
        this.deleteSchemeRelatedData(ctx, pk.getKeyValue("fid").toString());
    }

    private void deleteSchemeRelatedData(Context ctx, String schemeId) throws BOSException {
        Object[] params = new Object[]{schemeId};
        String delTargetAccount = "delete from t_gl_vchamorttargetaccount where famortschemeid = ?";
        DbUtil.execute((Context)ctx, (String)delTargetAccount, (Object[])params);
        String delTargetAssist = "delete from t_gl_vchamorttargetassist where famortschemeid = ?";
        DbUtil.execute((Context)ctx, (String)delTargetAssist, (Object[])params);
        String delDestAccount = "delete from t_gl_vchamortdestaccount where famortschemeid = ?";
        DbUtil.execute((Context)ctx, (String)delDestAccount, (Object[])params);
        String delDestAssist = "delete from t_gl_vchamortdestassist where famortschemeid = ?";
        DbUtil.execute((Context)ctx, (String)delDestAssist, (Object[])params);
        String delPolicy = "delete from t_gl_vchamortpolicy where famortschemeid = ?";
        DbUtil.execute((Context)ctx, (String)delPolicy, (Object[])params);
    }

    @Override
    protected Map _genVoucher(Context ctx, List amortSchemeIDs, PeriodInfo period, boolean isSumGenVchs) throws BOSException, EASBizException {
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        HashMap cachedExchangeRate = new HashMap();
        VoucherCollection vouchers = new VoucherCollection();
        HashMap vchMap = new HashMap();
        int schemeSize = amortSchemeIDs.size();
        for (int i = 0; i < schemeSize; ++i) {
            Object[] record = new Object[10];
            VchAmortSchemeInfo scheme = null;
            scheme = (VchAmortSchemeInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(amortSchemeIDs.get(i).toString()), VchAmortSchemeInfo.getEditSelector());
            CompanyOrgUnitInfo curCompany = scheme.getCompany();
            ObjectUuidPK comPK = null;
            try {
                comPK = new ObjectUuidPK(BOSUuid.read((String)curCompany.getId().toString()));
            }
            catch (Exception ex) {
                throw new GLException(GLException.NOCOMPANY, ex);
            }
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("GL_111", comPK);
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            boolean paramCommonVoucherProcess = Boolean.valueOf(hmAllParam.get("GL_111").toString());
            try {
                boolean isHasPerm;
                if (VchAmortSchemeStatusEnum.Closed.equals((Object)scheme.getStatus())) {
                    record[0] = Boolean.FALSE;
                    record[1] = scheme.getNumber();
                    record[2] = scheme.getName();
                    record[3] = scheme.getTargetAccountDesc();
                    record[4] = scheme.getTotalAmount();
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "SCHEME_CLOSED", null);
                    record[9] = curCompany.getName();
                    records.add(record);
                    continue;
                }
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (user != null && user.getId() != null && !(isHasPerm = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "gl_vchamort_gen"))) {
                    record[0] = Boolean.FALSE;
                    record[1] = null;
                    record[2] = null;
                    record[3] = null;
                    record[4] = null;
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "PERM_ERROR", new Object[]{curCompany.getName()});
                    record[9] = curCompany.getName();
                    records.add(record);
                    continue;
                }
                PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, curCompany.getId().toString());
                CurrencyInfo locCurrency = curCompany.getBaseCurrency();
                CurrencyInfo rptCurrency = curCompany.getReportCurrency();
                boolean isEnableRpt = rptCurrency != null;
                ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                locCurrency = (CurrencyInfo)iCurrency.getValue((IObjectPK)new ObjectUuidPK(locCurrency.getId()));
                if (isEnableRpt) {
                    rptCurrency = (CurrencyInfo)iCurrency.getValue((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
                }
                HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                params.put("syncProfitcenterToVoucher", paramCommonVoucherProcess);
                params.put("CurCompany", (Boolean)curCompany);
                params.put("CurPeriod", (Boolean)curPeriod);
                params.put("BaseCurrency", (Boolean)locCurrency);
                params.put("RptCurrency", (Boolean)rptCurrency);
                if (scheme == null) {
                    record[0] = Boolean.FALSE;
                    record[1] = null;
                    record[2] = null;
                    record[3] = null;
                    record[4] = null;
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "SCHEME_DELETED", null);
                    record[9] = curCompany.getName();
                    records.add(record);
                    continue;
                }
                VchAmortTargetAccountCollection targetAccount = scheme.getTargetAccounts();
                boolean isTrue = true;
                for (int j = 0; j < targetAccount.size(); ++j) {
                    AccountViewInfo tarAccNew;
                    VchAmortTargetAccountInfo tarAcc = targetAccount.get(j);
                    if (scheme.getCurrency().getId().toString().equals(locCurrency.getId().toString()) || (rptCurrency == null || scheme.getCurrency().getId().toString().equals(rptCurrency.getId().toString())) && rptCurrency != null || (tarAccNew = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(tarAcc.getAccount().getId().toString()))).getAccountingcurrency().getValue() != 0) continue;
                    isTrue = false;
                    break;
                }
                if (!isTrue) {
                    record[0] = Boolean.FALSE;
                    record[1] = scheme.getNumber();
                    record[2] = scheme.getName();
                    record[3] = scheme.getTargetAccountDesc();
                    record[4] = scheme.getTotalAmount();
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = EASResource.getString((String)this.resClassName, (String)"currency_is_foreign");
                    record[9] = curCompany.getName();
                    records.add(record);
                    continue;
                }
                if (VchAmortSchemeStatusEnum.Finished.equals((Object)scheme.getStatus())) {
                    record[0] = Boolean.FALSE;
                    record[1] = scheme.getNumber();
                    record[2] = scheme.getName();
                    record[3] = scheme.getTargetAccountDesc();
                    record[4] = scheme.getTotalAmount();
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "SCHEME_FINISHED", null);
                    record[9] = curCompany.getName();
                    records.add(record);
                    continue;
                }
                VchAmortPolicyCollection policies = scheme.getPolicies();
                AbstractVchAmortPolicyInfo policy = null;
                for (int j = 0; j < policies.size(); ++j) {
                    if (!policies.get(j).getPeriod().getId().toString().equals(curPeriod.getId().toString())) continue;
                    policy = policies.get(j);
                    break;
                }
                if (policy == null) {
                    record[0] = Boolean.FALSE;
                    record[1] = scheme.getNumber();
                    record[2] = scheme.getName();
                    record[3] = scheme.getTargetAccountDesc();
                    record[4] = scheme.getTotalAmount();
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "PERIOD_NOT_VOUCHER", null);
                    record[9] = curCompany.getName();
                } else if (policy.isIsVouchered()) {
                    record[0] = Boolean.FALSE;
                    record[1] = scheme.getNumber();
                    record[2] = scheme.getName();
                    record[3] = scheme.getTargetAccountDesc();
                    record[4] = scheme.getTotalAmount();
                    record[5] = null;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "PERIOD_GEN_VOUCHER", null);
                    record[9] = curCompany.getName();
                } else {
                    boolean isHasPerm2 = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "gl_voucher_add");
                    if (!isHasPerm2) {
                        record[0] = Boolean.FALSE;
                        record[1] = scheme.getNumber();
                        record[2] = scheme.getName();
                        record[3] = scheme.getTargetAccountDesc(ctx.getLocale());
                        record[4] = scheme.getTotalAmount();
                        record[5] = policy.getAmount();
                        record[6] = null;
                        record[7] = null;
                        record[8] = VchAmortUtils.getResource(ctx, "PERM_VOUCHER_ERROR", new Object[]{curCompany.getName()});
                        record[9] = curCompany.getName();
                        records.add(record);
                        continue;
                    }
                    isHasPerm2 = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getCU().getId().toString()), "bd_assistant_voucherType_view");
                    if (!isHasPerm2) {
                        record[0] = Boolean.FALSE;
                        record[1] = scheme.getNumber();
                        record[2] = scheme.getName();
                        record[3] = scheme.getTargetAccountDesc(ctx.getLocale());
                        record[4] = scheme.getTotalAmount();
                        record[5] = policy.getAmount();
                        record[6] = null;
                        record[7] = null;
                        record[8] = VchAmortUtils.getResource(ctx, "PERM_VCHTYPE_ERROR", new Object[]{curCompany.getName()});
                        record[9] = curCompany.getName();
                        records.add(record);
                        continue;
                    }
                    Object[] objs = this.checkAsstAccount(ctx, scheme, (VchAmortPolicyInfo)policy);
                    if (objs != null) {
                        records.add(objs);
                        continue;
                    }
                    VoucherInfo newVch = null;
                    if (isSumGenVchs) {
                        newVch = this.sumGenAmortVoucher(ctx, scheme, (VchAmortPolicyInfo)policy, params, cachedExchangeRate, vchMap);
                    } else {
                        newVch = this.generateAmortVoucher(ctx, scheme, (VchAmortPolicyInfo)policy, params, cachedExchangeRate);
                        vouchers.add(newVch);
                    }
                    record[0] = Boolean.TRUE;
                    record[1] = scheme.getNumber();
                    record[2] = scheme.getName();
                    record[3] = scheme.getTargetAccountDesc(ctx.getLocale());
                    record[4] = scheme.getTotalAmount();
                    record[5] = policy.getAmount();
                    record[6] = newVch;
                    record[7] = scheme;
                    record[8] = policy;
                    record[9] = curCompany.getName();
                }
            }
            catch (Exception e) {
                record[0] = Boolean.FALSE;
                record[1] = scheme == null ? null : scheme.getNumber();
                record[2] = scheme == null ? null : scheme.getName();
                record[3] = scheme == null ? null : scheme.getTargetAccountDesc(ctx.getLocale());
                record[4] = scheme == null ? null : scheme.getTotalAmount();
                record[5] = null;
                record[6] = null;
                record[7] = null;
                record[8] = e.getMessage().toString();
                record[9] = curCompany.getName();
            }
            records.add(record);
        }
        String sqlUpdate = "update t_gl_vchamortscheme set famortamount=famortamount + ?,fstatus=2  where fid=? and fversion=?";
        StringBuffer sbFinishedStatus = new StringBuffer();
        sbFinishedStatus.append("update t_gl_vchamortscheme set fstatus=");
        sbFinishedStatus.append("3");
        sbFinishedStatus.append(" where fid=? and famortamount=ftotalamount");
        Connection conn = null;
        PreparedStatement psUpdate = null;
        PreparedStatement psUpdateStatus = null;
        try {
            conn = this.getConnection(ctx);
            psUpdate = conn.prepareStatement(sqlUpdate);
            psUpdateStatus = conn.prepareStatement(sbFinishedStatus.toString());
            for (int i = 0; i < records.size(); ++i) {
                Object[] record = (Object[])records.get(i);
                if (record[0] == Boolean.FALSE) continue;
                VchAmortSchemeInfo schemeInfo = (VchAmortSchemeInfo)record[7];
                VchAmortPolicyInfo policy = (VchAmortPolicyInfo)record[8];
                psUpdate.setBigDecimal(1, policy.getAmount());
                DbUtil.prepareVarcharParam((PreparedStatement)psUpdate, (int)2, (String)schemeInfo.getId().toString());
                psUpdate.setInt(3, schemeInfo.getVersion());
                int count = psUpdate.executeUpdate();
                if (count != 1) {
                    VoucherInfo voucher = (VoucherInfo)record[6];
                    vouchers.remove(voucher);
                    record[0] = Boolean.FALSE;
                    record[6] = null;
                    record[7] = null;
                    record[8] = VchAmortUtils.getResource(ctx, "SCHEME_MODIFY_REFRESH_GEN_VOUCHER", null);
                    continue;
                }
                DbUtil.prepareVarcharParam((PreparedStatement)psUpdateStatus, (int)1, (String)schemeInfo.getId().toString());
                psUpdateStatus.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psUpdate);
                SQLUtils.cleanup(psUpdateStatus);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psUpdate);
        SQLUtils.cleanup((Statement)psUpdateStatus);
        SQLUtils.cleanup((Connection)conn);
        VchAmortLogCollection logs = new VchAmortLogCollection();
        for (int i = 0; i < records.size(); ++i) {
            Object[] record = (Object[])records.get(i);
            if (record[0] != Boolean.TRUE) continue;
            VchAmortLogInfo log = new VchAmortLogInfo();
            log.setId(null);
            log.setAmortScheme((VchAmortSchemeInfo)record[7]);
            log.setPeriod(((VchAmortPolicyInfo)record[8]).getPeriod());
            log.setVoucher((VoucherInfo)record[6]);
            logs.add(log);
        }
        if (isSumGenVchs) {
            Iterator it = vchMap.entrySet().iterator();
            while (it.hasNext()) {
                vouchers.add((VoucherInfo)it.next().getValue());
            }
        }
        IVoucher vchIface = VoucherFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < vouchers.size(); ++i) {
            VoucherInfo voucher = vouchers.get(i);
            vchIface.save((CoreBaseInfo)voucher);
        }
        IVchAmortLog logIface = VchAmortLogFactory.getLocalInstance(ctx);
        for (int i = 0; i < logs.size(); ++i) {
            logIface.addnew(logs.get(i));
        }
        SelectorItemCollection policyUpdateSic = new SelectorItemCollection();
        policyUpdateSic.add(new SelectorItemInfo("isVouchered"));
        IVchAmortPolicy policyIface = VchAmortPolicyFactory.getLocalInstance(ctx);
        for (int i = 0; i < records.size(); ++i) {
            Object[] record = (Object[])records.get(i);
            if (record[0] != Boolean.TRUE) continue;
            VoucherInfo voucher = (VoucherInfo)record[6];
            record[0] = Boolean.TRUE;
            record[6] = voucher.getVoucherType().getName() + "-" + voucher.getNumber();
            record[7] = voucher.getBookedDate();
            VchAmortPolicyInfo policy = (VchAmortPolicyInfo)record[8];
            policy.setIsVouchered(true);
            policyIface.updatePartial(policy, policyUpdateSic);
            record[8] = null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Records", records);
        if (amortSchemeIDs.size() == 1 && vouchers.size() > 0) {
            result.put("VoucherID", vouchers.get(0).getId().toString());
        }
        return result;
    }

    private VoucherInfo sumGenAmortVoucher(Context ctx, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy, Map params, Map cachedExchangeRete, Map vchMap) throws EASBizException, BOSException {
        String key = scheme.getCompany().getId().toString() + "_!" + scheme.getVoucherType().getId().toString();
        VoucherInfo newVch = (VoucherInfo)vchMap.get(key);
        if (newVch == null) {
            newVch = new VoucherInfo();
            vchMap.put(key, newVch);
            this.initVoucherHead(ctx, scheme, policy, params, newVch);
        } else {
            newVch.setAttachments(newVch.getAttachments() + scheme.getAttachments());
        }
        this.constructVchEntry(ctx, scheme, policy, params, cachedExchangeRete, newVch);
        return newVch;
    }

    private Object[] checkAsstAccount(Context ctx, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy) throws BOSException, EASBizException {
        String tCaa;
        BillEntryBaseInfo ai;
        int j;
        AsstAccountInfo caa;
        AbstractObjectCollection coll;
        AccountViewInfo account;
        int i;
        int i2;
        Object[] record = new Object[]{Boolean.FALSE, scheme.getNumber(), scheme.getName(), scheme.getTargetAccountDesc(ctx.getLocale()), scheme.getTotalAmount(), policy.getAmount(), null, null, "", scheme.getCompany().getName()};
        HashSet<String> accountIds = new HashSet<String>();
        for (i2 = 0; i2 < scheme.getTargetAccounts().size(); ++i2) {
            accountIds.add(scheme.getTargetAccounts().get(i2).getAccount().getId().toString());
        }
        for (i2 = 0; i2 < scheme.getDestAccounts().size(); ++i2) {
            accountIds.add(scheme.getDestAccounts().get(i2).getAccount().getId().toString());
        }
        Map<String, AsstAccountInfo> asstAccounts = GLAsstAccountUtils.getCAAs(ctx, accountIds, policy.getPeriod().getId().toString(), null);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, String> hgToCaas = new HashMap<String, String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct hg.FID, hg.FAsstAccountID \n");
            sql.append("from T_GL_VchAmortTargetAccount acc \n");
            sql.append("join T_GL_VchAmortTargetAssist ass on ass.FTargetAccountID = acc.FID \n");
            sql.append("join T_BD_AssistantHG hg on hg.FID = ass.FAssGrpID \n");
            sql.append("where acc.FAmortSchemeID = ? \n");
            sql.append("union \n");
            sql.append("select distinct hg.FID, hg.FAsstAccountID \n");
            sql.append("from T_GL_VchAmortDestAccount acc \n");
            sql.append("join T_GL_VchAmortDestAssist ass on ass.FDestAccountID = acc.FID \n");
            sql.append("join T_BD_AssistantHG hg on hg.FID = ass.FAssGrpID \n");
            sql.append("where acc.FAmortSchemeID = ? \n");
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, scheme.getId().toString());
            stmt.setString(2, scheme.getId().toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                hgToCaas.put(rs.getString("FID"), rs.getString("FAsstAccountID"));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"checkAsstAccount error!", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        for (i = 0; i < scheme.getTargetAccounts().size(); ++i) {
            VchAmortTargetAccountInfo ta = scheme.getTargetAccounts().get(i);
            account = ta.getAccount();
            coll = ta.getAssists();
            caa = asstAccounts.get(account.getId().toString());
            if (caa == null) {
                if (coll != null && coll.size() > 0) {
                    coll.clear();
                }
            } else {
                if (coll == null || coll.size() == 0) {
                    record[8] = VchAmortUtils.getResource(ctx, "TARGETENTRY_ASS_LESS", new Object[]{ta.getSeq()});
                    return record;
                }
                for (j = 0; j < coll.size(); ++j) {
                    ai = coll.get(j);
                    tCaa = (String)hgToCaas.get(ai.getAssGrp().getId().toString());
                    if (tCaa != null && tCaa.equals(caa.getId().toString())) continue;
                    record[8] = VchAmortUtils.getResource(ctx, "TARGETENTRY_ASS_ERROR", new Object[]{ta.getSeq()});
                    return record;
                }
            }
            account.setCAA(caa);
        }
        for (i = 0; i < scheme.getDestAccounts().size(); ++i) {
            VchAmortDestAccountInfo da = scheme.getDestAccounts().get(i);
            account = scheme.getDestAccounts().get(i).getAccount();
            coll = da.getAssists();
            caa = asstAccounts.get(account.getId().toString());
            if (caa == null) {
                if (coll != null && coll.size() > 0) {
                    coll.clear();
                }
            } else {
                if (coll == null || coll.size() == 0) {
                    record[8] = VchAmortUtils.getResource(ctx, "DESTENTRY_ASS_LESS", new Object[]{da.getSeq()});
                    return record;
                }
                for (j = 0; j < coll.size(); ++j) {
                    ai = coll.get(j);
                    tCaa = (String)hgToCaas.get(ai.getAssGrp().getId().toString());
                    if (tCaa != null && tCaa.equals(caa.getId().toString())) continue;
                    record[8] = VchAmortUtils.getResource(ctx, "DESTENTRY_ASS_ERROR", new Object[]{da.getSeq()});
                    return record;
                }
            }
            account.setCAA(caa);
        }
        return null;
    }

    protected VoucherInfo generateAmortVoucher(Context ctx, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy, Map params, Map cachedExchangeRate) throws BOSException, EASBizException {
        VoucherInfo newVch = new VoucherInfo();
        this.initVoucherHead(ctx, scheme, policy, params, newVch);
        this.constructVchEntry(ctx, scheme, policy, params, cachedExchangeRate, newVch);
        return newVch;
    }

    private void initVoucherHead(Context ctx, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy, Map params, VoucherInfo newVch) {
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)params.get("CurCompany");
        PeriodInfo curPeriod = policy.getPeriod();
        Timestamp time = curPeriod.getEndDate();
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        newVch.setSourceBillId(scheme.getId().toString());
        newVch.setId(null);
        newVch.setNumber(null);
        newVch.setCreator(curUser);
        newVch.setHandler(curUser);
        Date now = new Date();
        Timestamp t = new Timestamp(now.getTime());
        newVch.setCreateTime(t);
        newVch.setLastUpdateUser(curUser);
        newVch.setLastUpdateTime(t);
        newVch.setCashier(null);
        newVch.setAuditor(null);
        newVch.setPoster(null);
        newVch.setCanceller(null);
        newVch.setIsCheck(false);
        newVch.setIsCussent(false);
        newVch.setBizDate((Date)time);
        newVch.setBookedDate((Date)time);
        newVch.setPeriod(curPeriod);
        newVch.setSourceSys(SystemEnum.GENERALLEDGER);
        newVch.setSourceType(SourceType.VOUCHER_AMORT);
        newVch.setDescription(scheme.getDescription());
        newVch.setBizStatus(VoucherStatusEnum.TEMP);
        newVch.setVoucherAbstract(scheme.getAmortAbstract());
        newVch.setCompany(curCompany);
        newVch.setVoucherType(scheme.getVoucherType());
        newVch.setIsReverseVoucher(false);
        newVch.setCashflowFetched(false);
        newVch.setAttachments(scheme.getAttachments());
        newVch.setEntryCount(0);
        newVch.setLocalCreditAmount(GlUtils.zero);
        newVch.setLocalDebitAmount(GlUtils.zero);
        newVch.setReportingCreditAmount(GlUtils.zero);
        newVch.setReportingDebitAmount(GlUtils.zero);
        newVch.setEntries((AbstractObjectCollection)new VoucherEntryCollection());
    }

    private void constructVchEntry(Context ctx, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy, Map params, Map cachedExchangeRate, VoucherInfo newVch) throws EASBizException, BOSException {
        PeriodInfo curPeriod = policy.getPeriod();
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)params.get("CurCompany");
        CurrencyInfo schemeCurrency = scheme.getCurrency();
        newVch.setCurrency(schemeCurrency);
        BigDecimal policyAmt = policy.getAmount();
        CurrencyInfo locCurrency = (CurrencyInfo)params.get("BaseCurrency");
        CurrencyInfo rptCurrency = (CurrencyInfo)params.get("RptCurrency");
        boolean isEnableRpt = rptCurrency != null;
        Timestamp curPeriodEndDate = curPeriod.getEndDate();
        BigDecimal schemeToLocRate = GlUtils.one;
        BigDecimal schemeToRptRate = GlUtils.one;
        BigDecimal locToRptRate = GlUtils.one;
        String schemeToLocKey = schemeCurrency.getId().toString() + locCurrency.getId().toString();
        VoucherInfo.ExchangeRateWithValue schemeToLocRateValue = (VoucherInfo.ExchangeRateWithValue)cachedExchangeRate.get(schemeToLocKey);
        if (schemeToLocRateValue == null) {
            schemeToLocRateValue = GlUtils.getLocalCurrencyExchangeRate(ctx, schemeCurrency.getId().toString(), curCompany, curPeriod, curPeriodEndDate);
            cachedExchangeRate.put(schemeToLocKey, schemeToLocRateValue);
        }
        schemeToLocRate = schemeToLocRateValue.getValue();
        VoucherInfo.ExchangeRateWithValue schemeToRptRateValue = null;
        VoucherInfo.ExchangeRateWithValue locToRptRateValue = null;
        if (isEnableRpt) {
            String locToRptKey;
            String schemeToRptKey = schemeCurrency.getId().toString() + rptCurrency.getId().toString();
            schemeToRptRateValue = (VoucherInfo.ExchangeRateWithValue)cachedExchangeRate.get(schemeToRptKey);
            if (schemeToRptRateValue == null) {
                schemeToRptRateValue = GlUtils.getRptCurrencyExchangeRate(ctx, schemeCurrency.getId().toString(), curCompany, curPeriod, curPeriodEndDate);
                cachedExchangeRate.put(schemeToRptKey, schemeToRptRateValue);
            }
            if ((locToRptRateValue = (VoucherInfo.ExchangeRateWithValue)cachedExchangeRate.get(locToRptKey = locCurrency.getId().toString() + rptCurrency.getId().toString())) == null) {
                locToRptRateValue = GlUtils.getRptCurrencyExchangeRate(ctx, locCurrency.getId().toString(), curCompany, curPeriod, curPeriodEndDate);
                cachedExchangeRate.put(locToRptKey, locToRptRateValue);
            }
            schemeToRptRate = schemeToRptRateValue.getValue();
            locToRptRate = locToRptRateValue.getValue();
        }
        BigDecimal[] totalSchemeToLoc = this.exchangeCurrency(schemeToLocRate, locCurrency, policyAmt);
        BigDecimal leftEntryLocAmt = totalSchemeToLoc[0];
        BigDecimal leftEntryRptAmt = GlUtils.zero;
        BigDecimal totalRptComputeRate = GlUtils.one;
        if (isEnableRpt) {
            if (3 == curCompany.getReportConvertMode().getValue()) {
                BigDecimal[] locToRpt = this.exchangeCurrency(locToRptRate, rptCurrency, leftEntryLocAmt);
                leftEntryRptAmt = locToRpt[0];
                totalRptComputeRate = locToRpt[1];
            } else {
                BigDecimal[] schemeToRpt = this.exchangeCurrency(schemeToRptRate, rptCurrency, policyAmt);
                leftEntryRptAmt = schemeToRpt[0];
                totalRptComputeRate = schemeToRpt[1];
            }
        }
        VoucherEntryCollection entries = newVch.getEntries();
        int entrySeq = newVch.getEntryCount() + 1;
        this.constructVchEntryWithTargetAccount(ctx, entrySeq, leftEntryLocAmt, leftEntryRptAmt, scheme, policy, newVch, entries, isEnableRpt, schemeToLocRate, schemeToRptRate, locToRptRate, totalRptComputeRate, params);
        newVch.setEntries((AbstractObjectCollection)entries);
        newVch.setEntryCount(entries.size());
    }

    private void constructVchEntryWithTargetAccount(Context ctx, int entrySeq, BigDecimal leftEntryLocAmt, BigDecimal leftEntryRptAmt, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy, VoucherInfo newVch, VoucherEntryCollection entries, boolean isEnableRpt, BigDecimal schemeToLocRate, BigDecimal schemeToRptRate, BigDecimal locToRptRate, BigDecimal totalRptComputeRate, Map params) throws EASBizException, BOSException {
        BigDecimal policyAmt;
        CurrencyInfo schemeCurrency = scheme.getCurrency();
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        PeriodInfo curPeriod = policy.getPeriod();
        Timestamp time = curPeriod.getEndDate();
        Boolean syncProfitcenterToVoucher = (Boolean)params.get("syncProfitcenterToVoucher");
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)params.get("CurCompany");
        CurrencyInfo locCurrency = (CurrencyInfo)params.get("BaseCurrency");
        CurrencyInfo rptCurrency = (CurrencyInfo)params.get("RptCurrency");
        BigDecimal leftTargetAccountOrigAmt = policyAmt = policy.getAmount();
        BigDecimal lefTargetAccountLocAmt = leftEntryLocAmt;
        BigDecimal lefTargetAccountRptAmt = leftEntryRptAmt;
        VchAmortEntryOrder entryOrder = scheme.getEntryOrder();
        if (entryOrder == null) {
            entryOrder = VchAmortEntryOrder.DEBITFIRST;
        }
        VchAmortTargetAccountCollection targetAccounts = scheme.getTargetAccounts();
        int targetAccountSize = targetAccounts.size();
        VchAmortTargetAccountInfo targetAccount = null;
        VoucherEntryInfo newTargetAccountEntry = null;
        for (int i = 0; i < targetAccountSize; ++i) {
            boolean isLastEntry;
            targetAccount = targetAccounts.get(i);
            newTargetAccountEntry = new VoucherEntryInfo();
            newTargetAccountEntry.setId(null);
            newTargetAccountEntry.setSeq(entrySeq++);
            newTargetAccountEntry.setDescription(scheme.getAmortAbstract());
            newTargetAccountEntry.setOprStatus(1);
            newTargetAccountEntry.setIsCheck(false);
            newTargetAccountEntry.setIsHand(true);
            if (syncProfitcenterToVoucher.booleanValue()) {
                newTargetAccountEntry.setProfitCenter(targetAccount.getProfitCenter());
            }
            newTargetAccountEntry.setAccount(targetAccount.getAccount());
            newTargetAccountEntry.setCAA(targetAccount.getAccount().getCAA());
            newTargetAccountEntry.setBill(newVch);
            VchAmortTargetAccountDC vchAmortTargetAccountDC = targetAccount.getDC();
            if (vchAmortTargetAccountDC == VchAmortTargetAccountDC.CREDIT) {
                newTargetAccountEntry.setEntryDC(EntryDC.CREDIT);
            } else if (vchAmortTargetAccountDC == VchAmortTargetAccountDC.DEBIT) {
                newTargetAccountEntry.setEntryDC(EntryDC.DEBIT);
            }
            newTargetAccountEntry.setCurrency(schemeCurrency);
            BigDecimal origAmt = GlUtils.zero;
            BigDecimal locAmt = GlUtils.zero;
            BigDecimal rptAmt = GlUtils.zero;
            boolean bl = isLastEntry = i == targetAccountSize - 1;
            if (isLastEntry) {
                origAmt = leftTargetAccountOrigAmt;
                locAmt = lefTargetAccountLocAmt;
                rptAmt = lefTargetAccountRptAmt;
            } else {
                origAmt = targetAccount.getPlanAmount().multiply(policy.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, schemeCurrency.getPrecision(), 4);
                BigDecimal[] schemeToLocArr = this.exchangeCurrency(schemeToLocRate, locCurrency, origAmt);
                locAmt = schemeToLocArr[0];
                if (isEnableRpt) {
                    if (3 == curCompany.getReportConvertMode().getValue()) {
                        BigDecimal[] locToRpt = this.exchangeCurrency(totalRptComputeRate, rptCurrency, locAmt);
                        rptAmt = locToRpt[0];
                    } else {
                        BigDecimal[] schemeToRpt = this.exchangeCurrency(totalRptComputeRate, rptCurrency, origAmt);
                        rptAmt = schemeToRpt[0];
                    }
                }
                leftTargetAccountOrigAmt = leftTargetAccountOrigAmt.subtract(origAmt);
                lefTargetAccountLocAmt = lefTargetAccountLocAmt.subtract(locAmt);
                lefTargetAccountRptAmt = lefTargetAccountRptAmt.subtract(rptAmt);
            }
            newTargetAccountEntry.setOriginalAmount(origAmt);
            newTargetAccountEntry.setLocalAmount(locAmt);
            newTargetAccountEntry.setReportingAmount(rptAmt);
            newTargetAccountEntry.setLocalExchangeRate(schemeToLocRate);
            newTargetAccountEntry.setReportingExchangeRate(totalRptComputeRate);
            VchAmortTargetAssistCollection assists = targetAccount.getAssists();
            if (assists != null && assists.size() > 0) {
                VoucherAssistRecordInfo assist = null;
                VchAmortTargetAssistInfo targetAssist = null;
                BigDecimal leftAssistOrigAmt = origAmt;
                BigDecimal leftAssistLocAmt = locAmt;
                BigDecimal leftAssistRptAmt = rptAmt;
                VoucherAssistRecordCollection records = new VoucherAssistRecordCollection();
                newTargetAccountEntry.setAssistRecords((AbstractObjectCollection)records);
                int assistSize = assists.size();
                for (int j = 0; j < assistSize; ++j) {
                    targetAssist = assists.get(j);
                    assist = new VoucherAssistRecordInfo();
                    assist.setId(null);
                    assist.setSeq(targetAssist.getSeq());
                    assist.setDescription(scheme.getAmortAbstract());
                    assist.setBizDate((Date)time);
                    assist.setOprStatus(1);
                    this.checkAssitInfo(ctx, targetAssist.getAssGrp().getId().toString(), curCompany.getId().toString(), curUser.getId().toString(), false, false);
                    assist.setAssGrp(targetAssist.getAssGrp());
                    assist.setBill(newVch);
                    assist.setEntry(newTargetAccountEntry);
                    boolean isLastAssist = j == assistSize - 1;
                    BigDecimal assistAmortOrigAmt = GlUtils.zero;
                    BigDecimal assistAmortLocAmt = GlUtils.zero;
                    BigDecimal assistAmortRptAmt = GlUtils.zero;
                    if (isLastAssist) {
                        assistAmortOrigAmt = leftAssistOrigAmt;
                        assistAmortLocAmt = leftAssistLocAmt;
                        assistAmortRptAmt = leftAssistRptAmt;
                    } else {
                        assistAmortOrigAmt = targetAssist.getPlanAmount().multiply(policy.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, schemeCurrency.getPrecision(), 4);
                        BigDecimal[] schemeToLoc = this.exchangeCurrency(schemeToLocRate, locCurrency, assistAmortOrigAmt);
                        assistAmortLocAmt = schemeToLoc[0];
                        if (isEnableRpt) {
                            if (3 == curCompany.getReportConvertMode().getValue()) {
                                BigDecimal[] locToRpt = this.exchangeCurrency(totalRptComputeRate, rptCurrency, assistAmortLocAmt);
                                assistAmortRptAmt = locToRpt[0];
                            } else {
                                BigDecimal[] schemeToRpt = this.exchangeCurrency(totalRptComputeRate, rptCurrency, assistAmortOrigAmt);
                                assistAmortRptAmt = schemeToRpt[0];
                            }
                        }
                        leftAssistOrigAmt = leftAssistOrigAmt.subtract(assistAmortOrigAmt);
                        leftAssistLocAmt = leftAssistLocAmt.subtract(assistAmortLocAmt);
                        leftAssistRptAmt = leftAssistRptAmt.subtract(assistAmortRptAmt);
                    }
                    assist.setOriginalAmount(assistAmortOrigAmt);
                    assist.setLocalAmount(assistAmortLocAmt);
                    assist.setReportingAmount(assistAmortRptAmt);
                    records.add(assist);
                }
            }
            if (newTargetAccountEntry.getEntryDC() == EntryDC.CREDIT) {
                newVch.setLocalCreditAmount(newVch.getLocalCreditAmount().add(newTargetAccountEntry.getLocalAmount()));
                newVch.setReportingCreditAmount(newVch.getReportingCreditAmount().add(newTargetAccountEntry.getReportingAmount()));
            } else if (newTargetAccountEntry.getEntryDC() == EntryDC.DEBIT) {
                newVch.setLocalDebitAmount(newVch.getLocalDebitAmount().add(newTargetAccountEntry.getLocalAmount()));
                newVch.setReportingDebitAmount(newVch.getReportingDebitAmount().add(newTargetAccountEntry.getReportingAmount()));
            }
            VoucherEntryCollection tempEntries = new VoucherEntryCollection();
            this.constructVchEntryWithDestAccount(ctx, entrySeq, newTargetAccountEntry.getLocalAmount(), newTargetAccountEntry.getReportingAmount(), scheme, policy, newVch, tempEntries, isEnableRpt, schemeToLocRate, schemeToRptRate, locToRptRate, newTargetAccountEntry.getEntryDC(), targetAccount.getProfitCenter(), params);
            if (newTargetAccountEntry.getEntryDC() == EntryDC.CREDIT ^ entryOrder == VchAmortEntryOrder.CREDITFIRST) {
                int size = tempEntries.size();
                newTargetAccountEntry.setSeq(newTargetAccountEntry.getSeq() + size);
                for (int j = 0; j < size; ++j) {
                    VoucherEntryInfo entry = tempEntries.get(j);
                    entry.setSeq(entry.getSeq() - 1);
                }
                entries.addCollection(tempEntries);
                entries.add(newTargetAccountEntry);
            } else {
                entries.add(newTargetAccountEntry);
                entries.addCollection(tempEntries);
            }
            entrySeq = entries.size() + 1;
        }
    }

    private void constructVchEntryWithDestAccount(Context ctx, int entrySeq, BigDecimal targetAccountEntryLocAmt, BigDecimal targetAccountEntryRptAmt, VchAmortSchemeInfo scheme, VchAmortPolicyInfo policy, VoucherInfo newVch, VoucherEntryCollection entries, boolean isEnableRpt, BigDecimal schemeToLocRate, BigDecimal schemeToRptRate, BigDecimal locToRptRate, EntryDC targetAccountEntryDC, ProfitCenterOrgUnitInfo targetAccountProfitCenter, Map params) throws EASBizException, BOSException {
        CurrencyInfo schemeCurrency = scheme.getCurrency();
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        PeriodInfo curPeriod = policy.getPeriod();
        Timestamp time = curPeriod.getEndDate();
        Boolean syncProfitcenterToVoucher = (Boolean)params.get("syncProfitcenterToVoucher");
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)params.get("CurCompany");
        CurrencyInfo locCurrency = (CurrencyInfo)params.get("BaseCurrency");
        CurrencyInfo rptCurrency = (CurrencyInfo)params.get("RptCurrency");
        VchAmortDestAccountCollection destAccounts = scheme.getDestAccounts();
        int destAccountSize = destAccounts.size();
        BigDecimal leftDestAccountLocAmt = targetAccountEntryLocAmt;
        BigDecimal leftDestAccountRptAmt = targetAccountEntryRptAmt;
        VoucherEntryInfo newDestAccountEntry = null;
        VchAmortDestAccountInfo destAccount = null;
        for (int i = 0; i < destAccountSize; ++i) {
            boolean isLastEntry;
            destAccount = destAccounts.get(i);
            newDestAccountEntry = new VoucherEntryInfo();
            newDestAccountEntry.setSeq(entrySeq++);
            newDestAccountEntry.setId(null);
            newDestAccountEntry.setDescription(scheme.getAmortAbstract());
            newDestAccountEntry.setOprStatus(1);
            newDestAccountEntry.setIsCheck(false);
            newDestAccountEntry.setIsHand(true);
            if (syncProfitcenterToVoucher.booleanValue()) {
                newDestAccountEntry.setProfitCenter(targetAccountProfitCenter);
            }
            newDestAccountEntry.setAccount(destAccount.getAccount());
            newDestAccountEntry.setCAA(destAccount.getAccount().getCAA());
            newDestAccountEntry.setBill(newVch);
            if (targetAccountEntryDC == EntryDC.CREDIT) {
                newDestAccountEntry.setEntryDC(EntryDC.DEBIT);
            } else if (targetAccountEntryDC == EntryDC.DEBIT) {
                newDestAccountEntry.setEntryDC(EntryDC.CREDIT);
            }
            BigDecimal origAmt = GlUtils.zero;
            BigDecimal rptAmt = GlUtils.zero;
            BigDecimal locAmt = GlUtils.zero;
            BigDecimal destAccountLocRate = GlUtils.one;
            boolean bl = isLastEntry = i == destAccountSize - 1;
            if (isLastEntry) {
                locAmt = leftDestAccountLocAmt;
                rptAmt = leftDestAccountRptAmt;
            } else {
                locAmt = targetAccountEntryLocAmt.multiply(destAccount.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, locCurrency.getPrecision(), 4);
                if (isEnableRpt) {
                    rptAmt = targetAccountEntryRptAmt.multiply(destAccount.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, rptCurrency.getPrecision(), 4);
                }
                leftDestAccountLocAmt = leftDestAccountLocAmt.subtract(locAmt);
                leftDestAccountRptAmt = leftDestAccountRptAmt.subtract(rptAmt);
            }
            AccountingCurrencyEnum ace = destAccount.getAccount().getAccountingcurrency();
            if (AccountingCurrencyEnum.ALLCURRENCY.equals((Object)ace)) {
                newDestAccountEntry.setCurrency(schemeCurrency);
            } else if (AccountingCurrencyEnum.NOCURRENCY.equals((Object)ace)) {
                newDestAccountEntry.setCurrency(locCurrency);
            } else {
                boolean found = true;
                if (found) {
                    newDestAccountEntry.setCurrency(schemeCurrency);
                } else {
                    newDestAccountEntry.setCurrency(locCurrency);
                }
            }
            if (newDestAccountEntry.getCurrency() == schemeCurrency) {
                origAmt = locAmt.divide(schemeToLocRate, schemeCurrency.getPrecision(), 4);
                destAccountLocRate = schemeToLocRate;
            } else if (newDestAccountEntry.getCurrency() == locCurrency) {
                origAmt = locAmt;
                destAccountLocRate = GlUtils.one;
            } else {
                origAmt = GlUtils.zero;
                destAccountLocRate = GlUtils.one;
            }
            BigDecimal destAccountRptRate = GlUtils.one;
            if (isEnableRpt) {
                destAccountRptRate = 3 == curCompany.getReportConvertMode().getValue() ? locToRptRate : (newDestAccountEntry.getCurrency() == schemeCurrency ? schemeToRptRate : (newDestAccountEntry.getCurrency() == locCurrency ? locToRptRate : GlUtils.one));
            }
            newDestAccountEntry.setOriginalAmount(origAmt);
            newDestAccountEntry.setLocalAmount(locAmt);
            newDestAccountEntry.setReportingAmount(rptAmt);
            newDestAccountEntry.setLocalExchangeRate(destAccountLocRate);
            newDestAccountEntry.setReportingExchangeRate(destAccountRptRate);
            VchAmortDestAssistCollection assists = destAccount.getAssists();
            if (assists != null && assists.size() > 0) {
                VoucherAssistRecordInfo assist = null;
                VchAmortDestAssistInfo destAssist = null;
                BigDecimal leftAssistOrigAmt = origAmt;
                BigDecimal leftAssistLocAmt = locAmt;
                BigDecimal leftAssistRptAmt = rptAmt;
                VoucherAssistRecordCollection records = new VoucherAssistRecordCollection();
                newDestAccountEntry.setAssistRecords((AbstractObjectCollection)records);
                int assistSize = assists.size();
                for (int j = 0; j < assistSize; ++j) {
                    destAssist = assists.get(j);
                    assist = new VoucherAssistRecordInfo();
                    assist.setId(null);
                    assist.setSeq(destAssist.getSeq());
                    assist.setDescription(scheme.getAmortAbstract());
                    assist.setBizDate((Date)time);
                    assist.setOprStatus(1);
                    this.checkAssitInfo(ctx, destAssist.getAssGrp().getId().toString(), curCompany.getId().toString(), curUser.getId().toString(), false, false);
                    assist.setAssGrp(destAssist.getAssGrp());
                    assist.setBill(newVch);
                    assist.setEntry(newDestAccountEntry);
                    boolean isLastAssist = j == assistSize - 1;
                    BigDecimal assistAmortOrigAmt = GlUtils.zero;
                    BigDecimal assistAmortLocAmt = GlUtils.zero;
                    BigDecimal assistAmortRptAmt = GlUtils.zero;
                    if (isLastAssist) {
                        assistAmortOrigAmt = leftAssistOrigAmt;
                        assistAmortLocAmt = leftAssistLocAmt;
                        assistAmortRptAmt = leftAssistRptAmt;
                    } else {
                        assistAmortOrigAmt = origAmt.multiply(destAssist.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, newDestAccountEntry.getCurrency().getPrecision(), 4);
                        assistAmortLocAmt = locAmt.multiply(destAssist.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, newDestAccountEntry.getCurrency().getPrecision(), 4);
                        assistAmortRptAmt = rptAmt.multiply(destAssist.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, newDestAccountEntry.getCurrency().getPrecision(), 4);
                        leftAssistOrigAmt = leftAssistOrigAmt.subtract(assistAmortOrigAmt);
                        leftAssistLocAmt = leftAssistLocAmt.subtract(assistAmortLocAmt);
                        leftAssistRptAmt = leftAssistRptAmt.subtract(assistAmortRptAmt);
                    }
                    assist.setOriginalAmount(assistAmortOrigAmt);
                    assist.setLocalAmount(assistAmortLocAmt);
                    assist.setReportingAmount(assistAmortRptAmt);
                    records.add(assist);
                }
            }
            entries.add(newDestAccountEntry);
            if (newDestAccountEntry.getEntryDC() == EntryDC.CREDIT) {
                newVch.setLocalCreditAmount(newVch.getLocalCreditAmount().add(newDestAccountEntry.getLocalAmount()));
                newVch.setReportingCreditAmount(newVch.getReportingCreditAmount().add(newDestAccountEntry.getReportingAmount()));
                continue;
            }
            if (newDestAccountEntry.getEntryDC() != EntryDC.DEBIT) continue;
            newVch.setLocalDebitAmount(newVch.getLocalDebitAmount().add(newDestAccountEntry.getLocalAmount()));
            newVch.setReportingDebitAmount(newVch.getReportingDebitAmount().add(newDestAccountEntry.getReportingAmount()));
        }
    }

    private BigDecimal[] exchangeCurrency(BigDecimal exchangeRate, CurrencyInfo destCurrency, BigDecimal origAmt) {
        BigDecimal[] result = new BigDecimal[]{GlUtils.getScaleBigDecimal(origAmt.multiply(exchangeRate), destCurrency.getPrecision()), exchangeRate};
        return result;
    }

    private Map prepareParams(Context ctx, PeriodInfo periodInfo, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        HashMap result = new HashMap();
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
        PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, company.getId().toString());
        PeriodCollection periods = this.getPeriodsNotBeforeCurrentPeriod(ctx, periodInfo, company);
        HashMap<String, PeriodInfo> availablePeriod = new HashMap<String, PeriodInfo>();
        PeriodInfo period = null;
        int size = periods.size();
        for (int i = 0; i < size; ++i) {
            period = periods.get(i);
            availablePeriod.put(VchAmortUtils.getPeriodString(period.getPeriodYear(), period.getPeriodNumber()), period);
        }
        result.put("Periods", availablePeriod);
        result.put("CurPeriod", curPeriod);
        return result;
    }

    private void processBeforePersist(Context ctx, IObjectValue model, Map params) throws EASBizException, BOSException {
        BillEntryBaseInfo assistInfo;
        Serializable info;
        int i;
        int j;
        int size;
        VchAmortSchemeInfo schemeInfo = (VchAmortSchemeInfo)model;
        Locale[] locales = this.getAllLocales(ctx);
        VchAmortTargetAccountCollection targetAccounts = schemeInfo.getTargetAccounts();
        StringBuffer sbTarget = new StringBuffer();
        AccountViewInfo targetAccount = null;
        for (int i2 = 0; i2 < locales.length; ++i2) {
            sbTarget.delete(0, sbTarget.length());
            size = targetAccounts.size();
            for (j = 0; j < size; ++j) {
                targetAccount = targetAccounts.get(j).getAccount();
                sbTarget.append(targetAccount.getLongName(locales[i2])).append(";");
                if (sbTarget.length() > 100) break;
            }
            schemeInfo.setTargetAccountDesc(sbTarget.toString(), locales[i2]);
        }
        BigDecimal targetTotal = GlUtils.zero;
        size = targetAccounts.size();
        for (j = 0; j < size; ++j) {
            targetTotal = targetTotal.add(targetAccounts.get(j).getPlanAmount());
        }
        schemeInfo.setTotalAmount(targetTotal);
        VchAmortDestAccountCollection destAccounts = schemeInfo.getDestAccounts();
        StringBuffer sbDest = new StringBuffer();
        AccountViewInfo destAccount = null;
        for (int i3 = 0; i3 < locales.length; ++i3) {
            sbDest.delete(0, sbDest.length());
            int size2 = destAccounts.size();
            for (int j2 = 0; j2 < size2; ++j2) {
                destAccount = destAccounts.get(j2).getAccount();
                sbDest.append(destAccount.getLongName(locales[i3])).append(";");
                if (sbDest.length() > 100) break;
            }
            schemeInfo.setDestAccountDesc(sbDest.toString(), locales[i3]);
        }
        VchAmortPolicyCollection policies = schemeInfo.getPolicies();
        GlUtils.sortCollection((IObjectCollection)policies, "period.number");
        params.putAll(this.prepareParams(ctx, policies.get(0).getPeriod(), schemeInfo.getCompany()));
        Map periods = (Map)params.get("Periods");
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        boolean isSequence = false;
        for (i = 0; i < policies.size(); ++i) {
            info = policies.get(i);
            info.setSeq(i + 1);
            PeriodInfo period = info.getPeriod();
            if (isFirst) {
                sb.append(VchAmortUtils.getPeriodString(period.getPeriodYear(), period.getPeriodNumber()));
                isFirst = false;
            } else {
                VchAmortPolicyInfo prePolicy = policies.get(i - 1);
                PeriodInfo prePeriod = prePolicy.getPeriod();
                PeriodInfo nextPeriod = VchAmortUtils.getNextAvailabePeriod(periods, String.valueOf(prePeriod.getPeriodYear()), String.valueOf(prePeriod.getPeriodNumber()));
                if (nextPeriod == null || nextPeriod.getNumber() == period.getNumber()) {
                    isSequence = true;
                } else {
                    if (isSequence) {
                        sb.append("-");
                        sb.append(VchAmortUtils.getPeriodString(prePeriod.getPeriodYear(), prePeriod.getPeriodNumber()));
                        isSequence = false;
                    }
                    sb.append(";");
                    sb.append(VchAmortUtils.getPeriodString(period.getPeriodYear(), period.getPeriodNumber()));
                }
            }
            if (!isSequence || policies.size() - 1 != i) continue;
            VchAmortPolicyInfo info2 = policies.get(i);
            PeriodInfo period2 = info2.getPeriod();
            sb.append("-");
            sb.append(VchAmortUtils.getPeriodString(period2.getPeriodYear(), period2.getPeriodNumber()));
        }
        if (sb.length() > 200) {
            schemeInfo.setPeriodDesc(sb.substring(0, 201));
        } else {
            schemeInfo.setPeriodDesc(sb.toString());
        }
        for (i = 0; i < targetAccounts.size(); ++i) {
            info = targetAccounts.get(i);
            info.setSeq(i + 1);
            VchAmortTargetAssistCollection targetAssists = VchAmortUtils.getUsedTargetAssist((VchAmortTargetAccountInfo)info);
            if (targetAssists == null) continue;
            for (int j3 = 0; j3 < targetAssists.size(); ++j3) {
                assistInfo = targetAssists.get(j3);
                assistInfo.setSeq(j3 + 1);
            }
        }
        for (i = 0; i < destAccounts.size(); ++i) {
            info = destAccounts.get(i);
            info.setSeq(i + 1);
            VchAmortDestAssistCollection destAssists = VchAmortUtils.getUsedDestAssist((VchAmortDestAccountInfo)info);
            if (destAssists == null) continue;
            for (int j4 = 0; j4 < destAssists.size(); ++j4) {
                assistInfo = destAssists.get(j4);
                assistInfo.setSeq(j4 + 1);
            }
        }
    }

    private Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    private void checkSchemeValid(Context ctx, IObjectValue model, Map params) throws EASBizException, BOSException {
        VchAmortSchemeInfo schemeInfo = (VchAmortSchemeInfo)model;
        String number = schemeInfo.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{VchAmortUtils.getResource("SCHEME_NUMBER", null)});
        }
        String name = schemeInfo.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{VchAmortUtils.getResource(ctx, "SCHEME_NAME", null)});
        }
        this._checkNumberDup(ctx, null, (IObjectValue)schemeInfo);
        CompanyOrgUnitInfo curCompany = schemeInfo.getCompany();
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)curCompany.getId().toString()));
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, ex);
        }
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_108", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean mustNeedProfitCenter = Boolean.valueOf(hmAllParam.get("GL_108").toString());
        VchAmortUtils.checkTargetValid(schemeInfo, params, mustNeedProfitCenter);
        VchAmortUtils.checkDestValid(schemeInfo, params);
        VchAmortUtils.checkPolicyValid(schemeInfo, params);
        if (schemeInfo.getId() != null) {
            String sql = "SELECT policy.FPeriodId period,policy.FISVOUCHERED isVouchered,scheme.FAmortAmount amortAmount,scheme.FStatus status FROM T_GL_VCHAMORTSCHEME scheme inner join T_GL_VCHAMORTPOLICY  policy on scheme.fid=policy.FAmortSchemeID  where scheme.fid = ?";
            VchAmortPolicyCollection copyPolicies = new VchAmortPolicyCollection();
            copyPolicies.addCollection(schemeInfo.getPolicies());
            VchAmortPolicyInfo policy = null;
            IRowSet rowset = null;
            try {
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeInfo.getId().toString()});
                boolean flag = false;
                block4: while (rowset != null && rowset.next()) {
                    if (!flag) {
                        schemeInfo.setAmortAmount(rowset.getBigDecimal("amortAmount"));
                        schemeInfo.setStatus(VchAmortSchemeStatusEnum.getEnum(rowset.getString("status")));
                        flag = true;
                    }
                    String periodId = rowset.getString("period");
                    Iterator iter = copyPolicies.iterator();
                    while (iter.hasNext()) {
                        policy = (VchAmortPolicyInfo)iter.next();
                        if (periodId == null || !periodId.equals(policy.getPeriod().getId().toString())) continue;
                        policy.setIsVouchered(rowset.getInt("isVouchered") == 1);
                        iter.remove();
                        continue block4;
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        VchAmortSchemeInfo schemeInfo = (VchAmortSchemeInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)schemeInfo.getCompany().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    private IObjectPK persistScheme(Context ctx, IObjectValue model, Map params) throws EASBizException, BOSException {
        VchAmortSchemeInfo schemeInfo = (VchAmortSchemeInfo)model;
        IObjectPK objectPK = null;
        objectPK = schemeInfo.getId() == null ? this.addNewScheme(ctx, schemeInfo, params) : this.updateScheme(ctx, schemeInfo, params);
        return objectPK;
    }

    private IObjectPK addNewScheme(Context ctx, VchAmortSchemeInfo schemeInfo, Map params) throws EASBizException, BOSException {
        schemeInfo.setVersion(1);
        IObjectPK schemePK = super.addnew(ctx, (CoreBaseInfo)schemeInfo);
        schemeInfo.put("id", schemePK.getKeyValue("id"));
        this.addNewTarget(ctx, schemeInfo);
        this.addNewDest(ctx, schemeInfo);
        this.addNewPolicy(ctx, schemeInfo);
        return schemePK;
    }

    private void addNewTarget(Context ctx, VchAmortSchemeInfo schemeInfo) throws BOSException, EASBizException {
        int i;
        VchAmortTargetAccountCollection targetAccounts = schemeInfo.getTargetAccounts();
        if (targetAccounts == null) {
            return;
        }
        int acctounSize = targetAccounts.size();
        IVchAmortTargetAccount iTargetAccount = VchAmortTargetAccountFactory.getLocalInstance(ctx);
        IObjectPK taPK = null;
        for (int i2 = 0; i2 < acctounSize; ++i2) {
            VchAmortTargetAccountInfo targetAccount = targetAccounts.get(i2);
            targetAccount.setAmortScheme(schemeInfo);
            targetAccount.setId(null);
            taPK = iTargetAccount.addnew(targetAccount);
            targetAccount.put("id", taPK.getKeyValue("id"));
        }
        IVchAmortTargetAssist iTargetAssist = VchAmortTargetAssistFactory.getLocalInstance(ctx);
        VchAmortTargetAssistCollection deletedAssists = new VchAmortTargetAssistCollection();
        for (i = 0; i < acctounSize; ++i) {
            VchAmortTargetAccountInfo targetAccount = targetAccounts.get(i);
            VchAmortTargetAssistCollection assists = targetAccount.getAssists();
            if (assists == null) continue;
            for (int j = 0; j < assists.size(); ++j) {
                VchAmortTargetAssistInfo targetAssist = assists.get(j);
                Object status = targetAssist.get("Status");
                if (status instanceof Integer && VchAmortUtils.STATUS_DELETED.intValue() == ((Integer)status).intValue()) {
                    deletedAssists.add(targetAssist);
                    continue;
                }
                targetAssist.setAmortScheme(schemeInfo);
                targetAssist.setTargetAccount(targetAccount);
                targetAssist.setId(null);
                iTargetAssist.addnew(targetAssist);
            }
        }
        for (i = 0; i < deletedAssists.size(); ++i) {
            VchAmortTargetAssistInfo targetAssist = deletedAssists.get(i);
            if (targetAssist.getId() == null) continue;
            iTargetAssist.delete((IObjectPK)new ObjectUuidPK(targetAssist.getId().toString()));
        }
    }

    private void addNewDest(Context ctx, VchAmortSchemeInfo schemeInfo) throws BOSException, EASBizException {
        int i;
        VchAmortDestAccountCollection destAccounts = schemeInfo.getDestAccounts();
        if (destAccounts == null) {
            return;
        }
        int accountSize = destAccounts.size();
        IVchAmortDestAccount iDestAccount = VchAmortDestAccountFactory.getLocalInstance(ctx);
        IObjectPK daPK = null;
        for (int i2 = 0; i2 < accountSize; ++i2) {
            VchAmortDestAccountInfo destAccount = destAccounts.get(i2);
            destAccount.setAmortScheme(schemeInfo);
            destAccount.setId(null);
            daPK = iDestAccount.addnew(destAccount);
            destAccount.put("id", daPK.getKeyValue("id"));
        }
        IVchAmortDestAssist iDestAssist = VchAmortDestAssistFactory.getLocalInstance(ctx);
        VchAmortDestAssistCollection deletedAssists = new VchAmortDestAssistCollection();
        for (i = 0; i < accountSize; ++i) {
            VchAmortDestAccountInfo destAccount = destAccounts.get(i);
            VchAmortDestAssistCollection assists = destAccount.getAssists();
            if (assists == null) continue;
            for (int j = 0; j < assists.size(); ++j) {
                VchAmortDestAssistInfo destAssist = assists.get(j);
                Object status = destAssist.get("Status");
                if (status instanceof Integer && VchAmortUtils.STATUS_DELETED.intValue() == ((Integer)status).intValue()) {
                    deletedAssists.add(destAssist);
                    continue;
                }
                destAssist.setAmortScheme(schemeInfo);
                destAssist.setDestAccount(destAccount);
                destAssist.setId(null);
                iDestAssist.addnew(destAssist);
            }
        }
        for (i = 0; i < deletedAssists.size(); ++i) {
            VchAmortDestAssistInfo destAssist = deletedAssists.get(i);
            if (destAssist.getId() == null) continue;
            iDestAssist.delete((IObjectPK)new ObjectUuidPK(destAssist.getId().toString()));
        }
    }

    private void addNewPolicy(Context ctx, VchAmortSchemeInfo schemeInfo) throws BOSException, EASBizException {
        VchAmortPolicyInfo policy = null;
        IVchAmortPolicy iPolicy = VchAmortPolicyFactory.getLocalInstance(ctx);
        Iterator itPolicy = schemeInfo.getPolicies().iterator();
        while (itPolicy.hasNext()) {
            policy = (VchAmortPolicyInfo)itPolicy.next();
            policy.setAmortScheme(schemeInfo);
            policy.setId(null);
            iPolicy.addnew(policy);
        }
    }

    private IObjectPK updateScheme(Context ctx, VchAmortSchemeInfo schemeInfo, Map params) throws BOSException, EASBizException {
        String sqlUpdate = "update t_gl_vchamortscheme set fversion=fversion+1 where fid=? and fversion=?";
        Connection conn = null;
        PreparedStatement psUpdate = null;
        PreparedStatement psSelect = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            psUpdate = conn.prepareStatement(sqlUpdate);
            DbUtil.prepareVarcharParam((PreparedStatement)psUpdate, (int)1, (String)schemeInfo.getId().toString());
            psUpdate.setInt(2, schemeInfo.getVersion());
            int count = psUpdate.executeUpdate();
            if (count != 1) {
                throw new VchAmortException(VchAmortException.SCHEME_MODIFY_REFRESH);
            }
            String sqlSelect = "select fid from t_gl_vchamortscheme where fid=? and fstatus = 3";
            psSelect = conn.prepareStatement(sqlSelect);
            DbUtil.prepareVarcharParam((PreparedStatement)psSelect, (int)1, (String)schemeInfo.getId().toString());
            rs = psSelect.executeQuery();
            if (rs.next()) {
                throw new VchAmortException(VchAmortException.SCHEME_FINISHED);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psSelect);
                SQLUtils.cleanup((Statement)psUpdate, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psSelect);
        SQLUtils.cleanup((Statement)psUpdate, (Connection)conn);
        this.deleteSchemeRelatedData(ctx, schemeInfo.getId().toString());
        ObjectUuidPK schemePK = new ObjectUuidPK(schemeInfo.getId());
        schemeInfo.setVersion(schemeInfo.getVersion() + 1);
        schemeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        schemeInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        super.update(ctx, (IObjectPK)schemePK, (CoreBaseInfo)schemeInfo);
        this.addNewTarget(ctx, schemeInfo);
        this.addNewDest(ctx, schemeInfo);
        this.addNewPolicy(ctx, schemeInfo);
        return schemePK;
    }

    private PeriodCollection getPeriodsNotBeforeCurrentPeriod(Context ctx, PeriodInfo curPeriod, CompanyOrgUnitInfo curCompany) throws BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(curPeriod.getNumber()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)curCompany.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        return iPeriod.getPeriodCollection(evi);
    }

    @Override
    protected Map _queryNotGenVoucherScheme(Context ctx, IObjectValue period, IObjectValue company) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select s.fnumber,s.fname from t_gl_vchamortscheme s \r\n");
        sql.append("inner join t_gl_vchamortpolicy p on p.famortschemeid=s.fid \r\n");
        sql.append("where s.fcompanyid=? and p.fperiodid=? and p.fisvouchered=0 and s.FStatus <> 4");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.get("id").toString(), period.get("id").toString()});
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                Object[] record = new Object[]{rs.getString("fnumber"), rs.getString("fname")};
                records.add(record);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        HashMap<String, ArrayList<Object[]>> result = new HashMap<String, ArrayList<Object[]>>();
        result.put("result", records);
        return result;
    }

    protected void checkAssitInfo(Context ctx, String asstGrpid, String companyId, String userId, boolean isOrgPermission, boolean isChooseAsstCom) throws BOSException, EASBizException {
        String fnameloc = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select fid," + fnameloc + ",fmappingfieldname,frealtiondataobject,FasstHGAttribute from t_bd_asstacttype  where  fid in ( select fasstacttypeid from t_bd_asstactgroupdetail \twhere \tfasstaccountid =(select fasstaccountid from t_bd_assistanthg where fid=?) )";
        String freeze = null;
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstGrpid});
            while (rowset != null && rowset.next()) {
                String sql3;
                IRowSet rowset3;
                String fid2;
                String sql2;
                IRowSet rowset2;
                String fname = rowset.getString(fnameloc);
                String fmappingfieldname = rowset.getString("fmappingfieldname");
                String frealtiondataobject = rowset.getString("frealtiondataobject");
                String asstHGAttribute = rowset.getString("FasstHGAttribute");
                int isAsstValueDC = 1;
                if (asstHGAttribute.equals("customer")) {
                    freeze = "FUsedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("provider")) {
                    freeze = "FUsedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("material")) {
                    freeze = "FStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("person")) {
                    freeze = "FDeletedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("ntType")) {
                    freeze = "FIsUsed";
                } else if (asstHGAttribute.equals("innerAccount")) {
                    freeze = "FIsUsed";
                } else if (asstHGAttribute.equals("")) {
                    freeze = null;
                } else if (asstHGAttribute.startsWith("generalAssActType")) {
                    freeze = "FIsEnabled";
                } else if (asstHGAttribute.startsWith("bankAccount")) {
                    freeze = "FIsClosed";
                } else if (asstHGAttribute.equals("region")) {
                    freeze = "FDeletedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg") || asstHGAttribute.equals("adminOrg")) {
                    freeze = "FIsSealUp";
                    isAsstValueDC = 0;
                } else {
                    freeze = null;
                }
                if (freeze == null || (rowset2 = DbUtil.executeQuery((Context)ctx, (String)(sql2 = "select " + fmappingfieldname + " from t_bd_assistanthg where fid =?"), (Object[])new Object[]{asstGrpid})) == null || !rowset2.next() || (fid2 = rowset2.getString(fmappingfieldname)) == null || (rowset3 = DbUtil.executeQuery((Context)ctx, (String)(sql3 = "select " + fnameloc + "," + freeze + ", fnumber from " + frealtiondataobject + " where fid=?"), (Object[])new Object[]{fid2})) == null || !rowset3.next()) continue;
                int state = rowset3.getInt(freeze);
                if (isAsstValueDC == 0) {
                    state = 1 - state;
                } else if (isAsstValueDC == 2) {
                    state = 2 - state;
                }
                if (!asstHGAttribute.startsWith("bankAccount") && state == 0 || asstHGAttribute.startsWith("bankAccount") && state == 1) {
                    if (asstHGAttribute.startsWith("bankAccount")) {
                        throw new VoucherException(VoucherException.VOUCHERBANDDISABLE, new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                    }
                    if (asstHGAttribute.equals("region")) {
                        throw new VoucherException(new NumericExceptionSubItem("999", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"533_GLGeneralFacadeControllerBean", (Locale)ctx.getLocale())), new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                    }
                    throw new VoucherException(VoucherException.VOUCHERASSTFREESED, new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                }
                AssistCuSuStatusValidator cusuValidator = null;
                int result = 0;
                if (asstHGAttribute.equals("customer")) {
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(ctx);
                    }
                    result = cusuValidator.customerValidator(fid2, companyId);
                } else if (asstHGAttribute.equals("provider")) {
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(ctx);
                    }
                    result = cusuValidator.supplierValidator(fid2, companyId);
                }
                if (result == 1) {
                    throw new VoucherException(VoucherException.VOUCHERASSTFREESED, new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                }
                if (!asstHGAttribute.equals("saleOrg") && !asstHGAttribute.equals("profitOrg") && !asstHGAttribute.equals("purchaseOrg") && !asstHGAttribute.equals("storeageOrg") && !asstHGAttribute.equals("adminOrg") && !asstHGAttribute.equals("costOrg") || GLOrgUtil.isOrgValid(ctx, asstHGAttribute, fid2, companyId, userId, isChooseAsstCom, isOrgPermission)) continue;
                throw new VoucherException(VoucherException.VOUCHERASSTFREESED, new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    @Override
    protected Map _genVoucherForWeb(Context ctx, List amortSchemeIDs) throws BOSException, EASBizException {
        return this._genVoucherForWebBySum(ctx, amortSchemeIDs, false);
    }

    @Override
    protected Map _genVoucherForWebBySum(Context ctx, List amortSchemeIDs, boolean isSumGenVchs) throws BOSException, EASBizException {
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        HashMap cachedExchangeReate = new HashMap();
        HashMap vchMap = new HashMap();
        VoucherCollection vouchers = new VoucherCollection();
        int schemeSize = amortSchemeIDs.size();
        for (int i = 0; i < schemeSize; ++i) {
            Object[] record;
            block34: {
                record = new Object[7];
                record[6] = amortSchemeIDs.get(i).toString();
                VchAmortSchemeInfo scheme = null;
                scheme = (VchAmortSchemeInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(amortSchemeIDs.get(i).toString()), VchAmortSchemeInfo.getEditSelector());
                CompanyOrgUnitInfo curCompany = scheme.getCompany();
                ObjectUuidPK comPK = null;
                try {
                    comPK = new ObjectUuidPK(BOSUuid.read((String)curCompany.getId().toString()));
                }
                catch (Exception ex) {
                    throw new GLException(GLException.NOCOMPANY, ex);
                }
                HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
                hmParamIn.put("GL_111", comPK);
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
                boolean paramCommonVoucherProcess = Boolean.valueOf(hmAllParam.get("GL_111").toString());
                try {
                    boolean isHasPerm;
                    if (VchAmortSchemeStatusEnum.Closed.equals((Object)scheme.getStatus())) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = scheme;
                        record[3] = VchAmortUtils.getResource(ctx, "SCHEME_CLOSED", null);
                        records.add(record);
                        continue;
                    }
                    UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                    if (user != null && user.getId() != null && !(isHasPerm = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "gl_vchamort_gen"))) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = scheme;
                        record[3] = VchAmortUtils.getResource(ctx, "PERM_ERROR", new Object[]{curCompany.getName()});
                        records.add(record);
                        continue;
                    }
                    PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, curCompany.getId().toString());
                    CurrencyInfo locCurrency = curCompany.getBaseCurrency();
                    CurrencyInfo rptCurrency = curCompany.getReportCurrency();
                    boolean isEnableRpt = rptCurrency != null;
                    ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    locCurrency = (CurrencyInfo)iCurrency.getValue((IObjectPK)new ObjectUuidPK(locCurrency.getId()));
                    if (isEnableRpt) {
                        rptCurrency = (CurrencyInfo)iCurrency.getValue((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
                    }
                    HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                    params.put("syncProfitcenterToVoucher", paramCommonVoucherProcess);
                    params.put("CurCompany", (Boolean)curCompany);
                    params.put("CurPeriod", (Boolean)curPeriod);
                    params.put("BaseCurrency", (Boolean)locCurrency);
                    params.put("RptCurrency", (Boolean)rptCurrency);
                    if (scheme == null) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = null;
                        record[3] = VchAmortUtils.getResource(ctx, "SCHEME_DELETED", null);
                        records.add(record);
                        continue;
                    }
                    VchAmortTargetAccountCollection targetAccount = scheme.getTargetAccounts();
                    boolean isTrue = true;
                    for (int j = 0; j < targetAccount.size(); ++j) {
                        AccountViewInfo tarAccNew;
                        VchAmortTargetAccountInfo tarAcc = targetAccount.get(j);
                        if (scheme.getCurrency().getId().toString().equals(locCurrency.getId().toString()) || (rptCurrency == null || scheme.getCurrency().getId().toString().equals(rptCurrency.getId().toString())) && rptCurrency != null || (tarAccNew = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(tarAcc.getAccount().getId().toString()))).getAccountingcurrency().getValue() != 0) continue;
                        isTrue = false;
                        break;
                    }
                    if (!isTrue) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = scheme;
                        record[3] = EASResource.getString((String)this.resClassName, (String)"currency_is_foreign");
                        records.add(record);
                        continue;
                    }
                    if (VchAmortSchemeStatusEnum.Finished.equals((Object)scheme.getStatus())) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = scheme;
                        record[3] = VchAmortUtils.getResource(ctx, "SCHEME_FINISHED", null);
                        records.add(record);
                        continue;
                    }
                    VchAmortPolicyCollection policies = scheme.getPolicies();
                    AbstractVchAmortPolicyInfo policy = null;
                    for (int j = 0; j < policies.size(); ++j) {
                        if (!policies.get(j).getPeriod().getId().toString().equals(curPeriod.getId().toString())) continue;
                        policy = policies.get(j);
                        break;
                    }
                    if (policy == null) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = scheme;
                        record[3] = VchAmortUtils.getResource(ctx, "PERIOD_NOT_VOUCHER", null);
                    } else if (policy.isIsVouchered()) {
                        record[0] = Boolean.FALSE;
                        record[1] = null;
                        record[2] = scheme;
                        record[3] = VchAmortUtils.getResource(ctx, "PERIOD_GEN_VOUCHER", null);
                    } else {
                        boolean isHasPerm2 = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "gl_voucher_add");
                        if (!isHasPerm2) {
                            record[0] = Boolean.FALSE;
                            record[1] = null;
                            record[2] = scheme;
                            record[3] = VchAmortUtils.getResource(ctx, "PERM_VOUCHER_ERROR", new Object[]{curCompany.getName()});
                            records.add(record);
                            continue;
                        }
                        isHasPerm2 = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getCU().getId().toString()), "bd_assistant_voucherType_view");
                        if (!isHasPerm2) {
                            record[0] = Boolean.FALSE;
                            record[1] = null;
                            record[2] = scheme;
                            record[3] = VchAmortUtils.getResource(ctx, "PERM_VCHTYPE_ERROR", new Object[]{curCompany.getName()});
                            records.add(record);
                            continue;
                        }
                        Object[] objs = this.checkAsstAccount(ctx, scheme, (VchAmortPolicyInfo)policy);
                        if (objs != null) {
                            record[0] = Boolean.FALSE;
                            record[1] = null;
                            record[2] = scheme;
                            record[3] = objs[8];
                            records.add(record);
                            continue;
                        }
                        VoucherInfo newVch = null;
                        if (isSumGenVchs) {
                            newVch = this.sumGenAmortVoucher(ctx, scheme, (VchAmortPolicyInfo)policy, params, cachedExchangeReate, vchMap);
                        } else {
                            newVch = this.generateAmortVoucher(ctx, scheme, (VchAmortPolicyInfo)policy, params, cachedExchangeReate);
                            vouchers.add(newVch);
                        }
                        record[0] = Boolean.TRUE;
                        record[1] = newVch;
                        record[2] = scheme;
                        record[3] = policy;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    record[0] = Boolean.FALSE;
                    record[1] = null;
                    record[2] = scheme;
                    record[3] = e.getMessage().toString();
                    if (!(e instanceof GLPeriodEndException) || !"89-042".equals(((GLPeriodEndException)((Object)e)).getCode())) break block34;
                    record[4] = "showVoucher";
                    if (curCompany == null) break block34;
                    PeriodInfo period = GlUtils.getCurrentPeriod(ctx, curCompany.getId().toString());
                    record[5] = period;
                }
            }
            records.add(record);
        }
        String sqlUpdate = "update t_gl_vchamortscheme set famortamount=famortamount + ?,fstatus=2  where fid=? and fversion=?";
        StringBuffer sbFinishedStatus = new StringBuffer();
        sbFinishedStatus.append("update t_gl_vchamortscheme set fstatus=");
        sbFinishedStatus.append("3");
        sbFinishedStatus.append(" where fid=? and famortamount=ftotalamount");
        Connection conn = null;
        PreparedStatement psUpdate = null;
        PreparedStatement psUpdateStatus = null;
        try {
            conn = this.getConnection(ctx);
            psUpdate = conn.prepareStatement(sqlUpdate);
            psUpdateStatus = conn.prepareStatement(sbFinishedStatus.toString());
            for (int i = 0; i < records.size(); ++i) {
                Object[] record = (Object[])records.get(i);
                if (record[0] == Boolean.FALSE) continue;
                VchAmortSchemeInfo schemeInfo = (VchAmortSchemeInfo)record[2];
                VchAmortPolicyInfo policy = (VchAmortPolicyInfo)record[3];
                psUpdate.setBigDecimal(1, policy.getAmount());
                DbUtil.prepareVarcharParam((PreparedStatement)psUpdate, (int)2, (String)schemeInfo.getId().toString());
                psUpdate.setInt(3, schemeInfo.getVersion());
                int count = psUpdate.executeUpdate();
                if (count != 1) {
                    VoucherInfo voucher = (VoucherInfo)record[1];
                    vouchers.remove(voucher);
                    record[0] = Boolean.FALSE;
                    record[1] = null;
                    record[2] = null;
                    record[3] = VchAmortUtils.getResource(ctx, "SCHEME_MODIFY_REFRESH_GEN_VOUCHER", null);
                    continue;
                }
                DbUtil.prepareVarcharParam((PreparedStatement)psUpdateStatus, (int)1, (String)schemeInfo.getId().toString());
                psUpdateStatus.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psUpdate);
                SQLUtils.cleanup(psUpdateStatus);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psUpdate);
        SQLUtils.cleanup((Statement)psUpdateStatus);
        SQLUtils.cleanup((Connection)conn);
        VchAmortLogCollection logs = new VchAmortLogCollection();
        for (int i = 0; i < records.size(); ++i) {
            Object[] record = (Object[])records.get(i);
            if (record[0] != Boolean.TRUE) continue;
            VchAmortLogInfo log = new VchAmortLogInfo();
            log.setId(null);
            log.setAmortScheme((VchAmortSchemeInfo)record[2]);
            log.setPeriod(((VchAmortPolicyInfo)record[3]).getPeriod());
            log.setVoucher((VoucherInfo)record[1]);
            logs.add(log);
        }
        if (isSumGenVchs) {
            Iterator it = vchMap.entrySet().iterator();
            while (it.hasNext()) {
                vouchers.add((VoucherInfo)it.next().getValue());
            }
        }
        IVoucher vchIface = VoucherFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < vouchers.size(); ++i) {
            VoucherInfo voucher = vouchers.get(i);
            vchIface.save((CoreBaseInfo)voucher);
        }
        IVchAmortLog logIface = VchAmortLogFactory.getLocalInstance(ctx);
        for (int i = 0; i < logs.size(); ++i) {
            logIface.addnew(logs.get(i));
        }
        SelectorItemCollection policyUpdateSic = new SelectorItemCollection();
        policyUpdateSic.add(new SelectorItemInfo("isVouchered"));
        IVchAmortPolicy policyIface = VchAmortPolicyFactory.getLocalInstance(ctx);
        for (int i = 0; i < records.size(); ++i) {
            Object[] record = (Object[])records.get(i);
            if (record[0] != Boolean.TRUE) continue;
            VchAmortPolicyInfo policy = (VchAmortPolicyInfo)record[3];
            policy.setIsVouchered(true);
            policyIface.updatePartial(policy, policyUpdateSic);
        }
        HashMap<String, ArrayList<Object[]>> result = new HashMap<String, ArrayList<Object[]>>();
        result.put("Records", records);
        return result;
    }

    @Override
    protected void _updateUseStates(Context ctx, Set idSet, String status) throws BOSException, EASBizException {
        if (idSet == null) {
            return;
        }
        Iterator it = idSet.iterator();
        String id = null;
        String sql = "update T_GL_VchAmortScheme set FSTATUS=? where Fid = ?";
        while (it.hasNext()) {
            id = (String)it.next();
            VchAmortSchemeInfo vchAmortSchemeInfo = null;
            if (status.equals("2") && (vchAmortSchemeInfo = VchAmortSchemeFactory.getLocalInstance(ctx).getVchAmortSchemeInfo((IObjectPK)new ObjectUuidPK(id))).getAmortAmount().signum() == 0) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", id});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, id});
        }
    }
}

