/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTReverseManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.bos.workflow.exception.AlreadyRunningException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.ContextJudgement;
import com.kingdee.eas.base.netctrl.DataLockParameter;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IVoucherTypeCtrlItem;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemFactory;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.VoucherBookNotifyByEntryBuilder;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedType;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.PostVoucherCheckPara;
import com.kingdee.eas.fi.gl.PostVoucherCheckReturn;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractVoucherControllerBean;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.WebVoucherTransfer;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.AuditVoucherCollectionService;
import com.kingdee.eas.fi.gl.app.voucher.AuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.app.voucher.IAntiAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAuditVoucherCollectionService;
import com.kingdee.eas.fi.gl.app.voucher.IAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISaveVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISubmitVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ITransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.SaveVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.SubmitAccountComparisonVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.VoucherServiceFactory;
import com.kingdee.eas.fi.gl.app.voucher.WebVoucherUtils;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.cslacct.CheckViewInfo;
import com.kingdee.eas.fi.gl.utils.SqlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VoucherControllerBean
extends AbstractVoucherControllerBean {
    private static final long serialVersionUID = 7968868040605954033L;
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherControllerBean");
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";
    private static final String NEW_VOUCHER_NUMBER = "newVoucherNumber";
    private static final boolean[][] voucherStatus = new boolean[][]{{true, false, false, false, false, false}, {true, true, false, false, false, false}, {true, true, true, false, false, false}, {false, true, false, false, true, false}, {false, false, false, true, false, false}, {false, true, false, true, false, true}, {false, true, false, true, true, true}, {false, false, false, true, false, false}, {false, false, false, false, false, true}, {false, true, false, false, false, false}, {false, false, true, false, false, false}, {false, false, false, false, false, true}};

    protected void checkStatusAndOperate(VoucherStatusEnum bizStatus, VoucherOperateStatusEnum operateStatus) throws EASBizException {
        int i = operateStatus.getValue();
        int j = bizStatus.getValue();
        Object[] info = new String[]{operateStatus.toString(), bizStatus.toString()};
        if (!voucherStatus[i][j]) {
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, info);
        }
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
    }

    protected void managerVoucherId(Context ctx, VoucherInfo voucherInfo, VoucherStatusEnum status) throws BOSException, EASBizException {
        if (voucherInfo.getId() == null || voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) {
            voucherInfo.setBizStatus(status);
            if (voucherInfo.getSourceType() != SourceType.OTHER_IMPORT || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && (voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0)) {
                voucherInfo.setNumber(this.genVoucherId(ctx, voucherInfo));
            }
        } else {
            int i;
            VoucherInfo previousVoucher = null;
            String[] value = null;
            if (GlUtils.isExisted(ctx, voucherInfo) && voucherInfo.isNotChanged()) {
                previousVoucher = voucherInfo;
            } else {
                value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
                if (value != null && value.length > 0) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    for (i = 0; i < value.length; ++i) {
                        sic.add(new SelectorItemInfo(value[i]));
                    }
                    previousVoucher = (VoucherInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                    previousVoucher.setNumber(voucherInfo.getNumber());
                    previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                } else {
                    previousVoucher = voucherInfo;
                }
            }
            if (!status.equals((Object)voucherInfo.getBizStatus())) {
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
                voucherInfo.setBizStatus(status);
                voucherInfo.setNumber(this.genVoucherId(ctx, voucherInfo));
            } else if (previousVoucher != voucherInfo) {
                boolean voucherEqual = true;
                if (value == null) {
                    value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
                }
                for (i = 0; i < value.length; ++i) {
                    if (GlUtils.CompareWithSelector((PropertyContainer)previousVoucher, (PropertyContainer)voucherInfo, value[i])) continue;
                    voucherEqual = false;
                    break;
                }
                if (!voucherEqual) {
                    this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
                    voucherInfo.setNumber(this.genVoucherId(ctx, voucherInfo));
                }
            }
        }
    }

    protected String genVoucherId(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (log.isDebugEnabled()) {
            if (voucherInfo.getCU() != null) {
                log.debug((Object)("Voucher Info:" + voucherInfo.getCompany().getNumber() + "--" + voucherInfo.getCU().getNumber()));
            } else {
                log.debug((Object)("Voucher Info:" + voucherInfo.getCompany().getNumber() + "--CU is null"));
            }
        }
        voucherInfo.setBizStatus(voucherInfo.getBizStatus());
        String voucherNumber = this.getCodingRuleCtrl(ctx).getVoucherNumber((BaseVoucherInfo)voucherInfo);
        boolean isLogVoucherNumber = false;
        if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
            isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
        }
        if (isLogVoucherNumber) {
            VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber(voucherInfo, voucherNumber, "getNumber", null);
        }
        return voucherNumber;
    }

    protected void recycleVoucherId(Context ctx, VoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            Throwable ex = null;
            try {
                this.getCodingRuleCtrl(ctx).recycleVoucherNumber((BaseVoucherInfo)voucherInfo, voucherNumber);
            }
            catch (BOSException e) {
                ex = e;
                throw e;
            }
            catch (EASBizException e) {
                ex = e;
                throw e;
            }
            finally {
                boolean isLogVoucherNumber = false;
                if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                    isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
                }
                if (isLogVoucherNumber) {
                    VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber(voucherInfo, voucherNumber, "recycleNumber", (Exception)ex);
                }
            }
        } else {
            VoucherInfo previousVoucher = null;
            String[] value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (VoucherInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    protected IVoucher getCodingRuleCtrl(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected ISaveVoucherService getSaveVoucherService(Context ctx) throws BOSException {
        return new SaveVoucherService(ctx);
    }

    @Override
    protected BaseVoucherInfo getInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return (VoucherInfo)this._getValue(ctx, pk, VoucherInfo.getDefaultSelector());
    }

    @Override
    protected ISubmitVoucherService getSubmitVoucherService(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException {
        return VoucherServiceFactory.getSubmitVoucherService(ctx, (VoucherInfo)baseVoucherInfo);
    }

    @Override
    protected IObjectPK _submitAccountAdjustVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        SubmitAccountComparisonVoucherService service = new SubmitAccountComparisonVoucherService(ctx);
        return service.submitVoucher(ctx, (BaseVoucherInfo)voucherInfo);
    }

    protected void checkVoucherVaildForSave(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, boolean zeroRowRemoved) throws BOSException, EASBizException {
        if (voucherInfo.getReportingCreditAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.getReportingDebitAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        this.checkVoucherHeadEmpty(ctx, voucherInfo, sysParam);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVoucherType(ctx, voucherInfo);
        this.checkVoucherAccount(ctx, voucherInfo);
        this.checkLineAndAssistForSave(ctx, voucherInfo, sysParam, zeroRowRemoved);
    }

    private void checkVoucherHeadEmpty(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        if (sysParam.isParamExisted("GL_008")) {
            throw new GLException(GLException.NOPARAM, new Object[]{"GL_008"});
        }
        boolean isFzz = sysParam.getBoolean("GL_008");
        if (isFzz && voucherInfo.getCurrency() == null) {
            throw new VoucherException(VoucherException.VOUCHER_CURRENCY_NULL);
        }
        if (voucherInfo.getCompany() == null) {
            throw new VoucherException(VoucherException.COMPANY_CANNOT_NULL);
        }
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        if (voucherInfo.getBookedDate() == null) {
            throw new VoucherException(VoucherException.BOOKEDDATE_NULL);
        }
        if (voucherInfo.getBizDate() == null) {
            throw new VoucherException(VoucherException.BIZDATE_NULL);
        }
        if (voucherInfo.getSourceSys() == null) {
            throw new VoucherException(VoucherException.SOUCESYS_NULL);
        }
        if (voucherInfo.getSourceType() == null) {
            throw new VoucherException(VoucherException.SOUCETYPE_NULL);
        }
    }

    protected boolean isVerify(AccountViewInfo acc, EntryDC entryDC) {
        BalanceDirectionEnum accDC;
        return acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }

    private void checkEntryDC(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo voucherEntryInfo, Integer[] lineSeq) throws VoucherException {
        if (voucherEntryInfo.get("entryDC") == null) {
            throw new VoucherException(VoucherException.ENTRYDC_CANNOT_NULL, lineSeq);
        }
    }

    private void checkLineAndAssistForSave(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, boolean zeroRowRemoved) throws EASBizException {
        VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        Iterator iteratorEntry = voucherEntryCollection.iterator();
        VoucherEntryInfo voucherEntryInfo = null;
        boolean includeCash = false;
        Integer[] lineSeq = new Integer[1];
        AccountViewInfo accountViewInfo = null;
        while (iteratorEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
            lineSeq[0] = new Integer(voucherEntryInfo.getSeq());
            this.checkEntryDC(ctx, voucherInfo, voucherEntryInfo, lineSeq);
            if (voucherEntryInfo.getReportingAmount() != null && voucherEntryInfo.getReportingAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
                throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
            }
            accountViewInfo = voucherEntryInfo.getAccount();
            if (accountViewInfo == null || !accountViewInfo.isIsCash() && !accountViewInfo.isIsBank() && !accountViewInfo.isIsCashEquivalent()) continue;
            includeCash = true;
        }
        int entryCount = voucherInfo.getEntryCount();
        if (entryCount == 0) {
            throw new VoucherException(VoucherException.ONE_ENTRY_AT_LEAST);
        }
        voucherInfo.setHasCashAccount(includeCash);
        voucherInfo.setIsAC(false);
    }

    protected void checkVoucherPeriod(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getPeriodYear() < currPeriod.getPeriodYear() || voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() && voucherInfo.getPeriod().getPeriodNumber() < currPeriod.getPeriodNumber()) {
            throw new VoucherException(VoucherException.PERIOD_NOT_VAILD);
        }
    }

    protected void checkPiaoJu(Context ctx, String id, boolean isFzz, boolean isSubmit) throws BOSException, EASBizException {
        if (!isFzz) {
            return;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("  select a.fnumber,a.fcompanyid,b.fcurrencyid,sum(c.foriginalamount) famount, c.fsettlementcode,d.fbankaccountid,f.fnttypeid  \r\n");
        sql.append("\tfrom  \t\r\n");
        sql.append("\tt_gl_voucher a,t_gl_voucherentry b ,t_gl_voucherassistrecord c, \t\t\r\n");
        sql.append("\tt_bd_assistanthg d ,t_bd_accountview e\t,t_bd_settlementtype f,T_NT_NTType g\t\t\t\r\n");
        sql.append(" where a.fid=b.fbillid \t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.fid=c.fentryid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.faccountid=e.fid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and c.fassgrpid=d.fid\tand d.fbankaccountid is not null\t\t\t\t\t\r\n");
        sql.append("  and c.fsettlementtypeid=f.fid\t\t\t\t\t\t\t\t\r\n");
        sql.append("  and f.fnttypeid=g.fid and g.fgroup=1 \t\t\t\t\t\t\t\r\n");
        sql.append(" and a.fsourcetype=0 and e.fisbank=1 and b.fentrydc=0\t\t\r\n");
        sql.append(" and a.fid=?\tgroup by a.fnumber,a.fcompanyid,b.fcurrencyid,c.fsettlementcode,d.fbankaccountid,f.fnttypeid\t\t\t\r\n");
        StringBuffer sqlCheck = new StringBuffer("");
        sqlCheck.append(" select f.fid,f.fstate,f.famount,h.fceiling,f.fpaymentbillnum \t from  \t\t\r\n");
        sqlCheck.append(" t_nt_cheque f,T_NT_NTType g ,T_NT_ChequeAppRec h \t\t\t\t\t\t\t\r\n");
        sqlCheck.append("  where f.fapplyrecid=h.fid and g.fid=f.fnttypeid and g.fgroup=1 \t\t\t\r\n");
        sqlCheck.append(" \tand f.fcompanyid=?\tand f.fbankacctid=?  \t\t\t\t\t\t\t\t\r\n");
        sqlCheck.append(" \tand f.fcurrencyid=?\tand f.fnumber=?\tand g.fid=? \t\t\t\t\t\t\r\n");
        String update = "update t_nt_cheque set fPaymentBillNum=? where fid=? ";
        String updateFalse = "update t_nt_cheque set fPaymentBillNum=null where fid=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        if (set != null) {
            try {
                while (set.next()) {
                    String number = set.getString("fnumber");
                    String comid = set.getString("fcompanyid");
                    String bankAccid = set.getString("fbankaccountid");
                    String curid = set.getString("fcurrencyid");
                    String settlementcode = set.getString("fsettlementcode");
                    String nttype = set.getString("fnttypeid");
                    BigDecimal amount = set.getBigDecimal("famount");
                    if (isSubmit && settlementcode == null) {
                        throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                    }
                    IRowSet checkset = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString(), (Object[])new Object[]{comid, bankAccid, curid, settlementcode, nttype});
                    if (checkset != null && checkset.next()) {
                        String chequeid = checkset.getString("fid");
                        BigDecimal checkamount = checkset.getBigDecimal("famount");
                        BigDecimal ceiling = checkset.getBigDecimal("fceiling");
                        int state = checkset.getInt("fstate");
                        String paymentbillnum = checkset.getString("fpaymentbillnum");
                        if (isSubmit) {
                            if (paymentbillnum != null) {
                                throw new VoucherException(VoucherException.TICKEDHASRELATED);
                            }
                            if (checkamount != null && ChequeStatusEnum.WRITTEN_OFF.getValue() == state && checkamount.compareTo(amount) != 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT2);
                            }
                            if (ceiling != null && ceiling.compareTo(amount) < 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT3);
                            }
                            DbUtil.execute((Context)ctx, (String)update, (Object[])new Object[]{number, chequeid});
                            continue;
                        }
                        DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{chequeid});
                        continue;
                    }
                    if (!isSubmit) continue;
                    throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                }
            }
            catch (SQLException e) {
                log.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void checkVoucherType(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        String cuId = null;
        if (voucherInfo.getCompany() != null && voucherInfo.getCompany().getCU() != null) {
            cuId = voucherInfo.getCompany().getCU().getId().toString();
        }
        if (!VoucherUtil.isExistedVoucherType(ctx, cuId, voucherInfo.getVoucherType().getId().toString())) {
            throw new VoucherException(VoucherException.VOUCHERTYOENOTSEE);
        }
    }

    protected void checkVoucherAccount(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getEntries() == null) {
            return;
        }
        CompanyOrgUnitInfo org = voucherInfo.getCompany();
        if (org == null || org.getCU() == null || org.getCU().getId() == null) {
            org = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        VoucherEntryCollection entrys = voucherInfo.getEntries();
        for (int i = 0; i < entrys.size(); ++i) {
            VoucherEntryInfo entryInfo = entrys.get(i);
            AccountViewInfo accountViewInfo = entryInfo.getAccount();
            if (accountViewInfo == null) continue;
            String number = accountViewInfo.getNumber();
            String companyId = accountViewInfo.getCompanyID().getId().toString();
            if (accountViewInfo.isIsGFreeze() || accountViewInfo.isIsCFreeze() || accountViewInfo.isIsSelfFreeze()) {
                throw new VoucherException(VoucherException.ACCOUNT_FREEZE, new Object[]{new Integer(entryInfo.getSeq()), accountViewInfo.getNumber()});
            }
            String accountbale = accountViewInfo.getAccountTableID().getId().toString();
            boolean isleaf = accountViewInfo.isIsLeaf();
            if (!isleaf) {
                throw new VoucherException(VoucherException.NOTACCOUNTOFCU, new String[]{String.valueOf(entryInfo.getSeq()), number});
            }
            if (org.getId().toString().equals(companyId) && org.getAccountTable().getId().toString().equals(accountbale)) continue;
            VoucherUtil.replaceAccount(ctx, org.getId().toString(), org.getAccountTable().getId().toString(), entryInfo);
        }
    }

    protected void checkVoucherPeriodForAudit(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getNumber() < currPeriod.getNumber()) {
            throw new VoucherException(VoucherException.AUDIT_CUR_PERIOD);
        }
    }

    private List getAssistRecordByEntryId(Context ctx, String entryId) throws BOSException, SQLException {
        ArrayList<String> assistAssistRecoreList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("select Assist.FID as assistID ");
        sql.append("\r\n from  ");
        sql.append("\r\n T_GL_VoucherAssistRecord Assist ");
        StringBuffer whereSql = new StringBuffer("\r\n  where");
        StringBuffer causeSQL = new StringBuffer();
        StringBuffer groupBySQL = new StringBuffer();
        causeSQL.append(" \r\n Assist.FEntryID=?");
        sql.append(whereSql).append(causeSQL).append(groupBySQL);
        Object[] params = new Object[]{entryId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        while (rs.next()) {
            assistAssistRecoreList.add(rs.getString("assistID"));
        }
        return assistAssistRecoreList;
    }

    @Override
    protected void _deleteWebService(Context ctx, Vector vctPK, IObjectValue companyOrgUnitInfomation) throws BOSException, EASBizException {
        String[] voucherIds = new String[vctPK.size()];
        int n = vctPK.size();
        for (int i = 0; i < n; ++i) {
            voucherIds[i] = vctPK.get(i).toString();
            this.delete(ctx, (IObjectPK)vctPK.get(i), false);
        }
    }

    @Override
    protected void _deleteBySys(Context ctx, Vector vecPK, SystemEnum sys) throws BOSException, EASBizException {
        if (!SystemEnum.GENERALLEDGER.equals((Object)sys)) {
            throw new BOSException("don't call me");
        }
        String[] voucherIds = new String[vecPK.size()];
        int n = vecPK.size();
        for (int i = 0; i < n; ++i) {
            voucherIds[i] = vecPK.get(i).toString();
            this.delete(ctx, (IObjectPK)vecPK.get(i), true);
        }
    }

    @Override
    protected IDeleteVoucherService getDeleteVoucherService(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        return VoucherServiceFactory.getDeleteVoucherService(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected IObjectPK _exteriorSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.submit(ctx, (CoreBaseInfo)((VoucherInfo)model));
    }

    @Override
    protected IObjectPK _exteriorSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.save(ctx, (CoreBaseInfo)((VoucherInfo)model));
    }

    private void auditVoucher(Context ctx, VoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException, EASBizException {
        HashMap sysParam = GlUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString());
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.AUDIT);
        this.checkVoucherPeriodForAudit(ctx, voucherInfo);
        if (auditorId == null) {
            auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        boolean useWorkflow = Boolean.valueOf(sysParam.get("GL_032").toString());
        boolean ishandAuditBack = Boolean.valueOf(sysParam.get("GL_099").toString());
        if (!useWorkflow && ishandAuditBack) {
            if (voucherInfo.isIsAuditBack()) {
                throw new VoucherException(VoucherException.ISAUDITBACK);
            }
            if (voucherInfo.getId().toString() != null) {
                DbUtil.execute((Context)ctx, (String)" update T_GL_Voucher set FIsAuditBack=0  where FID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
                DbUtil.execute((Context)ctx, (String)" delete from T_GL_AuditOpinion  where FVoucherID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
            }
        }
        int isCheckAfterAudit = Integer.valueOf(sysParam.get("GL_047").toString());
        if (!useWorkflow && isCheckAfterAudit == 1 && !voucherInfo.isIsCheck() && this._existsCashOrBankAccount(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId()))) {
            throw new VoucherException(VoucherException.VOUCHERCHECKBFAUD);
        }
        boolean ceatorNotAudit = Boolean.valueOf(sysParam.get("GL_0491").toString());
        boolean runningWorkflow = GlUtils.isRunningWorkflow(ctx, voucherInfo.getId().toString());
        if (!runningWorkflow && ceatorNotAudit && !SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType()) && auditorId.equals((Object)voucherInfo.getCreator().getId())) {
            throw new VoucherException(VoucherException.CEATORNOTAUDIT);
        }
        if (VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.AUDITTED)) {
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            ctx.put((Object)"GL_VOUCHERNUMBER_LOG", sysParam.get("GL_VOUCHERNUMBER_LOG"));
            this.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.AUDITTED);
            String sql = "update t_gl_voucher set fnumber=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getNumber(), voucherInfo.getId().toString()});
        }
        this.updateVoucherStatus(ctx, voucherInfo.getId().toString(), auditorId.toString(), VoucherStatusEnum.AUDITTED.getValue(), "FAuditorId");
        Object budgetParam = sysParam.get("GL_075");
        boolean isNoticeByAudit = Integer.valueOf(sysParam.get("GLG01_2").toString()) == 0;
        boolean useACNotice = Boolean.valueOf(sysParam.get("GLG01").toString());
        if (isNoticeByAudit && useACNotice) {
            AcNoticeUtil.dealAcNotice(ctx, null, voucherInfo, voucherInfo.getCompany().getId().toString());
        }
        boolean isCanCreateBook = false;
        if (sysParam.get("G012") != null) {
            isCanCreateBook = Boolean.valueOf(sysParam.get("G012").toString());
        }
        if (isCanCreateBook && BooksUtil.isMasterBook((Context)ctx, (String)voucherInfo.getCompany().getId().toString())) {
            boolean useReport = Boolean.valueOf(sysParam.get("G001").toString());
            boolean allowCussent = Boolean.valueOf(sysParam.get("GL_028").toString());
            boolean isInTimeVerify = Integer.parseInt(sysParam.get("GL_052").toString()) == 0;
            BookUtil._transferVoucher(ctx, 0, voucherInfo.getId().toString(), voucherInfo.getCompany().getId().toString(), useReport, allowCussent, isInTimeVerify);
        }
    }

    @Override
    protected void _checkVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private void checkVerifiedStatus(Context ctx, VoucherInfo voucherInfo, HashMap sysParam, VoucherOperateStatusEnum status) throws BOSException, VoucherException {
        boolean hasVerified;
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = Integer.parseInt(sysParam.get("GL_052").toString()) == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit() && voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    protected void _antiCheckVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        String sql = "select fid from  t_gl_voucher where  fischeck=0 and fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.NOTCHECKED);
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        HashMap param = GlUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString());
        boolean useWorkflow = Boolean.valueOf(param.get("GL_032").toString());
        boolean checkMustCheck = Boolean.valueOf(param.get("GL_0493").toString());
        if (!useWorkflow && checkMustCheck && !SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType()) && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(voucherInfo.getCashier().getId().toString())) {
            throw new VoucherException(VoucherException.CHECKMUSTCHECK);
        }
        voucherInfo.setCashier(null);
        voucherInfo.setIsCheck(false);
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        this.updateVoucherCheckStatus(ctx, voucherInfo.getId().toString(), null, 0, association);
    }

    protected void _bgAuditVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _antiBgAuditVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _bgAndAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _antiBgAndAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IObjectPK updateVoucerStatus(Context ctx, VoucherInfo voucherInfo, VoucherStatusEnum status) throws BOSException, EASBizException {
        if (voucherInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId()))) {
            if (status != null) {
                voucherInfo.setBizStatus(status);
            }
            ObjectUuidPK retValue = new ObjectUuidPK(voucherInfo.getId());
            this._update(ctx, (IObjectPK)retValue, (IObjectValue)voucherInfo);
            return retValue;
        }
        throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
    }

    private void updateVoucherStatus(Context ctx, String id, String userid, int status, String userFild) throws BOSException {
        if (userFild != null) {
            if (userid != null) {
                String sql = "update t_gl_voucher set " + userFild + "=?, fbizstatus=?, FLastUpdateTime = ? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            } else {
                String sql = "update t_gl_voucher set " + userFild + "=null, fbizstatus=?, FLastUpdateTime = ? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
            }
        } else {
            String sql = "update t_gl_voucher set fbizstatus=?, FLastUpdateTime = ? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
        }
    }

    private void updateVoucherCheckStatus(Context ctx, String id, String userid, int status, boolean association) throws BOSException {
        if (userid != null) {
            String sql = "update t_gl_voucher set fcashierid=?, fischeck=?, FLastUpdateTime=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            if (association) {
                sql = "update t_gl_voucherentry set fcashierid=?, fischeck=?, FCheckDate=? where fbillid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            }
        } else {
            String sql = "update t_gl_voucher set fcashierid=null, fischeck=?, FLastUpdateTime=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
            if (association) {
                sql = "update t_gl_voucherentry set fcashierid=null, fischeck=?, FCheckDate=null where fbillid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), id});
            }
        }
    }

    private void _setSubmitStatus(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        this.updateVoucerStatus(ctx, voucherInfo, VoucherStatusEnum.SUBMITTED);
    }

    private void _setCheckStatus(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        this.updateVoucherStatus(ctx, voucherInfo.getId().toString(), null, 1, "FAuditorid");
    }

    protected void _setAuditStatus(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        this.updateVoucherStatus(ctx, voucherInfo.getId().toString(), null, VoucherStatusEnum.AUDITTED.getValue(), null);
    }

    protected void postVoucher(Context ctx, String vchID, String comId, int balType, boolean isUnPost, boolean hasNotice, Map checkViews) throws BOSException, EASBizException {
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        iGLPeriodEndFacade.postVocher(vchID, comId, balType, isUnPost, hasNotice, checkViews);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        block8: {
            BOSUuid auditorId = null;
            if (model != null) {
                auditorId = ((VoucherInfo)model).getAuditor().getId();
            }
            VoucherInfo voucherInfo = (VoucherInfo)this._getValue(ctx, pk, VoucherInfo.getAuditVoucherSelector());
            try {
                this.auditVoucher(ctx, voucherInfo, auditorId);
            }
            catch (Exception e) {
                if (voucherInfo.get(NEW_VOUCHER_NUMBER) != null) {
                    try {
                        this.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get(NEW_VOUCHER_NUMBER));
                    }
                    catch (Exception ex) {
                        log.error((Object)"Recycle voucher number error when save voucher!", (Throwable)ex);
                    }
                }
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                if (!(e instanceof RuntimeException)) break block8;
                throw (RuntimeException)e;
            }
        }
    }

    @Override
    protected IAuditVoucherService getAuditVoucherServie(Context ctx) throws BOSException {
        return new AuditVoucherService(ctx);
    }

    @Override
    protected IAuditVoucherCollectionService getAuditVoucherCollectionServie(Context ctx) throws BOSException {
        return new AuditVoucherCollectionService(ctx);
    }

    @Override
    protected IAntiAuditVoucherService getAntiAuditService(Context ctx) throws BOSException {
        return VoucherServiceFactory.getAntiAuditVoucherService(ctx);
    }

    @Override
    protected void _checkVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.getCheckVoucherService(ctx).checkVoucher(ctx, pk.toString());
    }

    @Override
    protected IAntiCheckVoucherService getAntiCheckVoucherService(Context ctx) throws BOSException {
        return VoucherServiceFactory.getAntiCheckVoucherService(ctx);
    }

    @Override
    protected void _antiCheckVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._checkVoucherValidForChecking(ctx, pk.toString(), VoucherOperateStatusEnum.ANTICHECK);
        this.getAntiCheckVoucherService(ctx).antiCheckVoucher(ctx, pk);
    }

    private void checkParamIsChanged(Context ctx, String id) throws BOSException, EASBizException {
        String sql;
        IRowSet rowset;
        if (id == null || id.trim().equals("")) {
            return;
        }
        if (BOSUuid.read((String)id).getType().equals((Object)new VoucherInfo().getBOSType()) ? ((rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where FBillID=? ").toString(), (Object[])new Object[]{id})) == null || rowset.size() == 0) && (rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where fbillID in (select FID FROM T_GL_VoucherEntry WHERE FBillID=?  )").toString(), (Object[])new Object[]{id})) != null && rowset.size() > 0 : BOSUuid.read((String)id).getType().equals((Object)new VoucherEntryInfo().getBOSType()) && ((rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where FBillID=? ").toString(), (Object[])new Object[]{id})) == null || rowset.size() == 0) && (rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where fbillID in (select FBillID FROM T_GL_VoucherEntry WHERE FID=?  )").toString(), (Object[])new Object[]{id})) != null && rowset.size() > 0) {
            throw new VoucherException(VoucherException.CHECKPARAMCHANGED);
        }
    }

    @Override
    protected IAntiPostVoucherService getAntiPostService(Context ctx) throws BOSException {
        return VoucherServiceFactory.getAntiPostVoucherService(ctx);
    }

    @Override
    public void antiPostVoucher(Context ctx, IObjectPK pk, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        IObjectValue model = this._getValue(ctx, pk, VoucherInfo.getDefaultProcessSelector());
        boolean isUseWorkflow = GlUtils.getDefaultGLParam(ctx, ((VoucherInfo)model).getCompany().getId().toString(), "GL_032");
        boolean enbale = this.setWorkflowServiceState(ctx, isUseWorkflow, (CoreBaseInfo)((VoucherInfo)model));
        super.antiPostVoucher(ctx, pk, preStatus);
        if (enbale) {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected ICancelVoucherService getCancelVoucherService(Context ctx) throws BOSException {
        return VoucherServiceFactory.getCancelVoucherService(ctx);
    }

    @Override
    protected IAntiCancelVoucherService getAntiCancelVoucherService(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        return VoucherServiceFactory.getAntiCancelVoucherService(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected void _bgAuditVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _antiBgAuditVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _bgAndAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _antiBgAndAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _setSubmitStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!GlUtils.isRunningWorkflow(ctx, this.getBOSType(), pk.toString())) {
            throw new VoucherException(VoucherException.NO_MSG, new String[]{"The method setSubmitStatus has been abandoned and is not allowed to call!"});
        }
    }

    @Override
    protected void _setCheckStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.getCheckVoucherService(ctx).checkVoucher(ctx, pk.toString());
    }

    @Override
    protected void _setAuditStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VoucherFactory.getLocalInstance((Context)ctx).auditVoucher(pk, null);
    }

    protected BaseVoucherInfo _exteriorLazyLoad(Context ctx, BaseVoucherInfo voucherInfo, SelectorItemCollection selectorItemCollection) throws BOSException, EASBizException {
        String[] paramList = new String[]{"G001", "GL_008", "GL_002", "GL_003", "G010", "GL_0301", "GL_100"};
        GlParam sysParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)voucherInfo.getCompany().getId().toString());
        return VoucherUtil.lazyLoad(ctx, (VoucherInfo)voucherInfo, selectorItemCollection, sysParam, false);
    }

    protected IObjectCollection _fetchAssData(Context ctx, String entryId, Object[] info) throws BOSException, EASBizException {
        String propName;
        VoucherInfo.DynamicColumnInfo colInfo;
        int i;
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        VoucherInfo.DynamicColumnInfo[] propCols = (VoucherInfo.DynamicColumnInfo[])info[1];
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("verifiedCussent.id"));
        for (i = 0; i < propCols.length; ++i) {
            colInfo = propCols[i];
            propName = colInfo.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)colInfo.getDataType())) {
                sic.add(new SelectorItemInfo(propName + ".number"));
                sic.add(new SelectorItemInfo(propName + ".name"));
                continue;
            }
            sic.add(new SelectorItemInfo(propName));
        }
        for (i = 0; i < assItemCols.length; ++i) {
            colInfo = assItemCols[i];
            propName = colInfo.getMappingPropName();
            sic.add(new SelectorItemInfo("assGrp." + propName + ".number"));
            sic.add(new SelectorItemInfo("assGrp." + propName + ".name"));
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("entry.id", (Object)entryId));
        IVoucherAssistRecord recCtrl = VoucherAssistRecordFactory.getLocalInstance(ctx);
        VoucherAssistRecordCollection records = recCtrl.getVoucherAssistRecordCollection(view);
        return records;
    }

    protected Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    protected IObjectValue _confirmAssGrp(Context ctx, AssistantHGInfo assGrp, String typeGroupId, VoucherInfo.DynamicColumnInfo[] colInfo) throws BOSException, EASBizException {
        AsstActTypeCollection types = new AsstActTypeCollection();
        for (int i = 0; i < colInfo.length; ++i) {
            AsstActTypeInfo t = new AsstActTypeInfo();
            types.add(t);
            t.setAsstHGAttribute(colInfo[i].getMappingPropName());
            t.setName(colInfo[i].getColName());
            t.setNumber(colInfo[i].getColNumber());
            HashMap hmMultiLangColName = colInfo[i].getHmMultiLangColName();
            for (Map.Entry e : hmMultiLangColName.entrySet()) {
                Object name = e.getValue();
                t.setName(name == null ? null : name.toString(), (Locale)e.getKey());
            }
        }
        IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
        return igCtrl.getAssistantHG(assGrp, typeGroupId, types);
    }

    protected Object[] _fetchVoucherTypeDetail(Context ctx, String voucherTypeId, String comId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
        fic.add(new FilterItemInfo("company.id", (Object)comId));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("type"));
        sorters.add(new SorterItemInfo("account.longNumber"));
        SelectorItemCollection sicItem = view.getSelector();
        sicItem.add(new SelectorItemInfo("type"));
        sicItem.add(new SelectorItemInfo("level"));
        sicItem.add(new SelectorItemInfo("account.number"));
        sicItem.add(new SelectorItemInfo("account.longNumber"));
        IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
        VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
        return VoucherUtil.reorganizeCtrlItems(ciCol);
    }

    protected Object[] _fetchExchangeRate(Context ctx, Object[] info) throws BOSException, EASBizException {
        Object[] result = new Object[2];
        String localTable = (String)info[0];
        String repTable = (String)info[1];
        String orgCur = (String)info[2];
        String localCur = (String)info[3];
        String repCur = (String)info[4];
        Date now = new Date();
        Date vchBookDate = (Date)info[5];
        if (vchBookDate != null && now.compareTo(vchBookDate) >= 0) {
            now = vchBookDate;
        }
        now = new Date(now.getTime() + 86400000L - 1L);
        Date prdBegin = (Date)info[6];
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("exchangeAux.exchangeTable.id"));
        sic.add(new SelectorItemInfo("exchangeAux.targetCurrency.id"));
        sic.add(new SelectorItemInfo("exchangeAux.convertMode"));
        sic.add(new SelectorItemInfo("exchangeAux.exchangeRateType"));
        sic.add(new SelectorItemInfo("exchangeAux.precision"));
        sic.add(new SelectorItemInfo("convertRate"));
        sic.add(new SelectorItemInfo("availTime"));
        sic.add(new SelectorItemInfo("invalidTime"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)localTable));
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)repTable));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)orgCur));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)localCur));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)repCur));
        fic.add(new FilterItemInfo("isUsedBG", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("availTime", (Object)now, CompareType.LESS_EQUALS));
        filter.setMaskString("(#0 OR #1) AND #2 AND (#3 OR #4) AND #5 AND #6 )");
        IExchangeRate exCtrl = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateCollection exCol = exCtrl.getExchangeRateCollection(view);
        VoucherInfo.ExchangeRateWithValue lex = null;
        VoucherInfo.ExchangeRateWithValue rex = null;
        Iterator itrEx = exCol.iterator();
        Date maxTimelocal0 = null;
        Date maxTimelocal1 = null;
        Date maxTimerep0 = null;
        Date maxTimerep1 = null;
        while (itrEx.hasNext()) {
            ExchangeRateInfo ex = (ExchangeRateInfo)itrEx.next();
            ExchangeAuxInfo aux = ex.getExchangeAux();
            String table = aux.getExchangeTable().getId().toString();
            String cur = aux.getTargetCurrency().getId().toString();
            ExchangeTypeEnum type = aux.getExchangeRateType();
            Date availTime = ex.getAvailTime();
            ConvertModeEnum cm = aux.getConvertMode();
            int pre = aux.getPrecision();
            BigDecimal rate = ex.getConvertRate();
            if (localTable != null && localTable.equals(table) && localCur.equals(cur)) {
                if (ExchangeTypeEnum.FLOATEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimelocal0 == null || maxTimelocal0.compareTo(availTime) <= 0)) {
                    lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                    lex.setPresion(pre);
                    maxTimelocal0 = availTime;
                } else if (ExchangeTypeEnum.FIXEXCHANGERATE.equals((Object)type) && prdBegin.compareTo(availTime) >= 0 && (maxTimelocal1 == null || maxTimelocal1.compareTo(availTime) <= 0)) {
                    lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                    lex.setPresion(pre);
                    maxTimelocal1 = availTime;
                }
            }
            if (repTable == null || !repTable.equals(table) || !repCur.equals(cur)) continue;
            if (ExchangeTypeEnum.FLOATEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimerep0 == null || maxTimerep0.compareTo(availTime) <= 0)) {
                rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                rex.setPresion(pre);
                maxTimerep0 = availTime;
                continue;
            }
            if (!ExchangeTypeEnum.FIXEXCHANGERATE.equals((Object)type) || prdBegin.compareTo(availTime) < 0 || maxTimerep1 != null && maxTimerep1.compareTo(availTime) > 0) continue;
            rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
            rex.setPresion(pre);
            maxTimerep1 = availTime;
        }
        result[0] = lex;
        result[1] = rex;
        return result;
    }

    protected IObjectValue _fetchPeriod(Context ctx, String periodTypeId, Date time) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("beginDate", (Object)time, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)time, CompareType.GREATER_EQUALS));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection objs = prdCtrl.getCollection(view);
        if (objs.size() > 0) {
            return objs.getObject(0);
        }
        return null;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._getValue(ctx, pk, VoucherInfo.getDefaultSelector());
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        BOSUuid id;
        VoucherInfo voucherInfo;
        VoucherCollection vchColl;
        if (pk == null) {
            return null;
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && (vchColl = cache.getVoucherCollection(selector)) != null && (voucherInfo = vchColl.get((Object)(id = BOSUuid.read((String)pk.toString())))) != null) {
            voucherInfo.setExist(true);
            return voucherInfo;
        }
        return this.getVoucherInternal(ctx, pk, selector);
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        FilterItemCollection fis;
        FilterInfo filter = null;
        if (view != null && (filter = view.getFilter()) != null && (fis = filter.getFilterItems()) != null && fis.size() == 1 && "id".equals(fis.get(0).getPropertyName()) && view.getSelector() != null) {
            SelectorItemCollection[] sels = this.splitSelector(view.getSelector());
            view.getSelector().clear();
            view.getSelector().addObjectCollection((IObjectCollection)sels[0]);
            String key = ImplUtils.buildPermissionServiceKey((BOSObjectType)this.getBOSType(), (String)"getCollection", (Object[])new Object[]{view});
            EntityViewInfo vInfo = (EntityViewInfo)ctx.get((Object)key);
            if (vInfo != null) {
                filter.mergeFilter(vInfo.getFilter(), "and");
                view.getEntryFilters().addObjectCollection((IObjectCollection)vInfo.getEntryFilters());
                boolean flag = true;
                int n = view.getEntryFilters().size();
                for (int i = 0; i < n; ++i) {
                    FilterInfo filter1 = view.getEntryFilters().get(i);
                    EntryFilterType type = filter1.getEntryFilterType();
                    if (EntryFilterType.NORMAL.equals((Object)type)) continue;
                    flag = false;
                    break;
                }
                view.setEntryPermCol(flag);
            }
            VoucherCollection vchColl = (VoucherCollection)super._getCollection(ctx, svcCtx, view);
            this.mergeAssistRecord(ctx, vchColl, sels[1]);
            return vchColl;
        }
        return super._getCollection(ctx, svcCtx, view);
    }

    private VoucherInfo getVoucherInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.addObjectCollection((IObjectCollection)selector);
        VoucherInfo voucherInfo = null;
        try {
            SelectorItemCollection[] sels = this.splitSelector(sic);
            voucherInfo = (VoucherInfo)super._getValue(ctx, pk, sels[0]);
            if (!sels[1].isEmpty()) {
                VoucherCollection voucherColl = new VoucherCollection();
                voucherColl.add(voucherInfo);
                this.mergeAssistRecord(ctx, voucherColl, sels[1]);
            }
            voucherInfo.setExist(true);
            VoucherUtil.fillVoucherTypeCtrlItem(ctx, voucherInfo);
        }
        catch (Exception ex) {
            log.error((Object)"ERROR", (Throwable)ex);
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST, ex);
        }
        return voucherInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAssistRecord(Context ctx, VoucherCollection voucherColl, SelectorItemCollection selector) throws SQLDataException, DataAccessException {
        if (selector == null || selector.isEmpty()) {
            return;
        }
        HashSet<String> voucherIdSet = new HashSet<String>();
        for (int i = 0; i < voucherColl.size(); ++i) {
            voucherIdSet.add(voucherColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        selector.add(new SelectorItemInfo("entry.id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", voucherIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("entry.id"));
        view.getSorter().add(new SorterItemInfo("seq"));
        Connection cn = null;
        VoucherAssistRecordCollection recordColl = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new VoucherAssistRecordInfo().getBOSType(), (Context)ctx, (Connection)cn);
            recordColl = (VoucherAssistRecordCollection)dao.getCollection(view);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (recordColl != null && !recordColl.isEmpty()) {
            int i;
            HashMap<BOSUuid, VoucherAssistRecordCollection> recordMap = new HashMap<BOSUuid, VoucherAssistRecordCollection>();
            for (i = 0; i < recordColl.size(); ++i) {
                BOSUuid entryId = recordColl.get(i).getEntry().getId();
                VoucherAssistRecordCollection coll = (VoucherAssistRecordCollection)recordMap.get(entryId);
                if (coll == null) {
                    coll = new VoucherAssistRecordCollection();
                    recordMap.put(entryId, coll);
                }
                coll.add(recordColl.get(i));
            }
            for (i = 0; i < voucherColl.size(); ++i) {
                for (int j = 0; j < voucherColl.get(i).getEntries().size(); ++j) {
                    VoucherEntryInfo entry = voucherColl.get(i).getEntries().get(j);
                    VoucherAssistRecordCollection coll = (VoucherAssistRecordCollection)recordMap.get(entry.getId());
                    if (coll == null) continue;
                    entry.getAssistRecords().addCollection(coll);
                }
            }
        }
    }

    private SelectorItemCollection[] splitSelector(SelectorItemCollection selector) {
        SelectorItemCollection[] sel = new SelectorItemCollection[]{new SelectorItemCollection(), new SelectorItemCollection()};
        for (int i = 0; i < selector.size(); ++i) {
            if (selector.get(i).getPropertyName().startsWith("entries.assistRecords.")) {
                sel[1].add(new SelectorItemInfo(selector.get(i).getPropertyName().substring(22)));
                continue;
            }
            sel[0].add(selector.get(i));
        }
        return sel;
    }

    @Override
    protected IObjectValue _generateReverseVoucher(Context ctx, String srcVchId, Object[] genParam) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mappingPropName"));
        sic.add(new SelectorItemInfo("dataType"));
        IAssistCustomizedType typeCtrl = AssistCustomizedTypeFactory.getLocalInstance(ctx);
        AssistCustomizedTypeCollection typeCol = typeCtrl.getAssistCustomizedTypeCollection(view);
        sic = VoucherInfo.getDefaultSelector();
        Iterator itrType = typeCol.iterator();
        while (itrType.hasNext()) {
            AssistCustomizedTypeInfo type = (AssistCustomizedTypeInfo)itrType.next();
            String propName = "entries.assistRecords." + type.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)type.getDataType())) {
                propName = propName + ".id";
            }
            sic.add(new SelectorItemInfo(propName));
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)srcVchId));
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        VoucherInfo srcVch = (VoucherInfo)this.getValue(ctx, (IObjectPK)pk, sic);
        return this.reverseVoucherNew(ctx, srcVchId, genParam);
    }

    protected IObjectValue reverseVoucherNew(Context ctx, String srcVchId, Object[] genParam) throws BOSException, EASBizException {
        boolean isInTimeVerify;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mappingPropName"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
        sic.add(new SelectorItemInfo("entries.assistRecords.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.id"));
        boolean isBatch = Boolean.valueOf(genParam[3].toString());
        IAssistCustomizedType typeCtrl = AssistCustomizedTypeFactory.getLocalInstance(ctx);
        AssistCustomizedTypeCollection typeCol = typeCtrl.getAssistCustomizedTypeCollection(view);
        sic = VoucherInfo.getDefaultSelector();
        Iterator itrType = typeCol.iterator();
        while (itrType.hasNext()) {
            AssistCustomizedTypeInfo type = (AssistCustomizedTypeInfo)itrType.next();
            String propName = "entries.assistRecords." + type.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)type.getDataType())) {
                propName = propName + ".id";
            }
            sic.add(new SelectorItemInfo(propName));
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)srcVchId));
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        VoucherInfo srcVch = (VoucherInfo)this.getValue(ctx, (IObjectPK)pk, sic);
        this.updateOldReverseVoucher(ctx, srcVch);
        boolean bFlag = permission.hasDataPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), (IObjectPK)new ObjectUuidPK(srcVch.getCompany().getId()), "gl_voucher094_reverse", (IObjectPK)pk);
        if (!bFlag) {
            throw new VoucherException(VoucherException.VOUCHERREVERSE_NODATAPERMISSION, new Object[]{srcVch.getNumber()});
        }
        UserInfo user = (UserInfo)genParam[0];
        PeriodInfo prd = (PeriodInfo)genParam[2];
        Date time = prd.getEndDate();
        Date date = srcVch.getBookedDate();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = df.format(date);
        if (time.before(date)) {
            time = date;
            prd = srcVch.getPeriod();
        }
        this.checkSrcVch(ctx, srcVch, prd);
        String Verify = ResourceBase.getString((String)resource, (String)"Verify", (Locale)ctx.getLocale());
        String Number2 = ResourceBase.getString((String)resource, (String)"Number", (Locale)ctx.getLocale());
        String strEntryDesc = Verify + strDate + srcVch.getVoucherType().getName() + srcVch.getNumber() + Number2;
        String desc = MessageFormat.format(new VoucherException(VoucherException.CANCELLED_DESC).getMessage(), strDate, srcVch.getVoucherType().getName(), srcVch.getNumber());
        srcVch.setSourceBillId(srcVch.getId().toString());
        srcVch.setId(null);
        srcVch.setIsReverseVoucher(true);
        srcVch.setHasReversed(false);
        srcVch.setNumber(null);
        srcVch.setCreator(user);
        srcVch.setHandler(user);
        srcVch.setCashier(null);
        srcVch.setAuditor(null);
        srcVch.setPoster(null);
        srcVch.setCanceller(null);
        srcVch.setIsCheck(false);
        srcVch.setIsCussent(false);
        srcVch.setBizDate(time);
        srcVch.setBookedDate(time);
        srcVch.setPeriod(prd);
        srcVch.setSourceSys(SystemEnum.GENERALLEDGER);
        if (!SourceType.PROFIT_AND_LOSS.equals((Object)srcVch.getSourceType())) {
            srcVch.setSourceType(SourceType.HANDCRAFT);
        }
        srcVch.setDescription(desc);
        srcVch.setAttachments(0);
        srcVch.put("bizStatus", null);
        srcVch.put("bgStatus", null);
        srcVch.put("hasCashAccount", null);
        Map mapReverseVch = this.getReverseVoucherNew(ctx, null, srcVchId, true, srcVch.getCompany().getId().toString());
        BigDecimal localDebit = GlUtils.zero;
        BigDecimal localCredit = GlUtils.zero;
        BigDecimal rptDebit = GlUtils.zero;
        BigDecimal rptCredit = GlUtils.zero;
        HashMap<String, VoucherEntryInfo> hmEntryId = new HashMap<String, VoucherEntryInfo>();
        HashMap<String, VoucherAssistRecordInfo> hmRecordId = new HashMap<String, VoucherAssistRecordInfo>();
        CashflowFlag cfFlag = srcVch.getCashflowFlag();
        Iterator itrEntry = srcVch.getEntries().iterator();
        VoucherEntryCollection newEntrys = new VoucherEntryCollection();
        ArrayList<String> assistRecIdList = new ArrayList<String>();
        GlParam glParams = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_028", "GL_052"}, (String)srcVch.getCompany().getId().toString());
        boolean allowCussent = glParams.getBoolean("GL_028");
        boolean bl = isInTimeVerify = glParams.getInt("GL_052") == 0;
        while (itrEntry.hasNext()) {
            VoucherEntryInfo entry = (VoucherEntryInfo)itrEntry.next();
            if (isBatch && entry.getAccount().getControl().getValue() != 0) {
                Object[] params = new String[]{entry.getAccount().getNumber() + " " + entry.getAccount().getName()};
                throw new VoucherException(VoucherException.CONTROL_ACC_NOT_BATCH_REVERSE, params);
            }
            hmEntryId.put(entry.getId().toString(), entry);
            entry.setSourceBillId(entry.getId().toString());
            entry.setId(null);
            entry.setDescription(strEntryDesc + (entry.getDescription() != null ? entry.getDescription() : ""));
            entry.setOprStatus(1);
            entry.setIsCheck(false);
            entry.setIsHand(true);
            VoucherAssistRecordCollection recCol = entry.getAssistRecords();
            if (recCol != null && recCol.size() > 0) {
                BigDecimal origAmount = GlUtils.zero;
                BigDecimal localAmount = GlUtils.zero;
                BigDecimal reportingAmount = GlUtils.zero;
                BigDecimal quantity = GlUtils.zero;
                BigDecimal stdQuantity = GlUtils.zero;
                for (VoucherAssistRecordInfo rec : recCol) {
                    hmRecordId.put(rec.getId().toString(), rec);
                    if (allowCussent && isInTimeVerify && entry.getAccount().isAC()) {
                        assistRecIdList.add(rec.getId().toString());
                    }
                    rec.setSourceBillId(rec.getId().toString());
                    rec.setId(null);
                    rec.setDescription(strEntryDesc + (rec.getDescription() != null ? rec.getDescription() : ""));
                    rec.setOprStatus(1);
                    ReverseRecord reverseValue = (ReverseRecord)mapReverseVch.get(entry.getSourceBillId() + "_" + rec.getSourceBillId());
                    if (reverseValue == null) {
                        rec.setOriginalAmount(rec.getOriginalAmount().negate());
                        rec.setLocalAmount(rec.getLocalAmount().negate());
                        rec.setReportingAmount(rec.getReportingAmount().negate());
                        if (rec.getQuantity() != null) {
                            rec.setQuantity(rec.getQuantity().negate());
                            quantity = quantity.add(rec.getQuantity());
                        }
                        if (rec.getQuantity() != null) {
                            rec.setStandardQuantity(rec.getStandardQuantity().negate());
                            stdQuantity = stdQuantity.add(rec.getStandardQuantity());
                        }
                    } else {
                        rec.setOriginalAmount(rec.getOriginalAmount().add(reverseValue.getAssistOrigAmount()).negate());
                        rec.setLocalAmount(rec.getLocalAmount().add(reverseValue.getAssistLocalAmount()).negate());
                        rec.setReportingAmount(rec.getReportingAmount().add(reverseValue.getAssistReportingAmount()).negate());
                        if (rec.getQuantity() != null) {
                            rec.setQuantity(rec.getQuantity().add(reverseValue.getAssistQuantity()).negate());
                            quantity = quantity.add(rec.getQuantity());
                        }
                        if (rec.getStandardQuantity() != null) {
                            rec.setStandardQuantity(rec.getStandardQuantity().add(reverseValue.getAssistStdQantity()).negate());
                            stdQuantity = stdQuantity.add(rec.getStandardQuantity());
                        }
                    }
                    origAmount = origAmount.add(rec.getOriginalAmount());
                    localAmount = localAmount.add(rec.getLocalAmount());
                    reportingAmount = reportingAmount.add(rec.getReportingAmount());
                }
                entry.setOriginalAmount(origAmount);
                entry.setLocalAmount(localAmount);
                entry.setReportingAmount(reportingAmount);
                entry.setQuantity(quantity);
                entry.setStandardQuantity(stdQuantity);
            } else {
                ReverseRecord reverseValue = (ReverseRecord)mapReverseVch.get(entry.getSourceBillId() + "_0");
                if (reverseValue == null) {
                    entry.setOriginalAmount(entry.getOriginalAmount().negate());
                    entry.setLocalAmount(entry.getLocalAmount().negate());
                    entry.setReportingAmount(entry.getReportingAmount().negate());
                    if (entry.getQuantity() != null) {
                        entry.setQuantity(entry.getQuantity().negate());
                    }
                    if (entry.getStandardQuantity() != null) {
                        entry.setStandardQuantity(entry.getStandardQuantity().negate());
                    }
                } else {
                    entry.setOriginalAmount(entry.getOriginalAmount().add(reverseValue.getVeOrigAmount()).negate());
                    entry.setLocalAmount(entry.getLocalAmount().add(reverseValue.getVeLocalAmount()).negate());
                    entry.setReportingAmount(entry.getReportingAmount().add(reverseValue.getVeReportingAmount()).negate());
                    if (entry.getQuantity() != null) {
                        entry.setQuantity(entry.getQuantity().add(reverseValue.getVeQuantity()).negate());
                    }
                    if (entry.getStandardQuantity() != null) {
                        entry.setStandardQuantity(entry.getStandardQuantity().add(reverseValue.getVeStdQantity()).negate());
                    }
                }
            }
            if (entry.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                localDebit = localDebit.add(entry.getLocalAmount());
                rptDebit = rptDebit.add(entry.getReportingAmount());
            } else {
                localCredit = localCredit.add(entry.getLocalAmount());
                rptCredit = rptCredit.add(entry.getReportingAmount());
            }
            if (entry.getAccount().getControl().getValue() != 0) continue;
            newEntrys.add(entry);
        }
        srcVch.getEntries().clear();
        srcVch.getEntries().addCollection(newEntrys);
        srcVch.setLocalDebitAmount(localDebit);
        srcVch.setLocalCreditAmount(localCredit);
        srcVch.setReportingDebitAmount(rptDebit);
        srcVch.setReportingCreditAmount(rptCredit);
        if (CashflowFlag.FINISHED.equals((Object)cfFlag) && mapReverseVch.isEmpty()) {
            view = new EntityViewInfo();
            sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("voucher.id", (Object)srcVchId));
            ICashflowRecord recCtrl = CashflowRecordFactory.getLocalInstance(ctx);
            CashflowRecordCollection cfCol = recCtrl.getCashflowRecordCollection(view);
            for (CashflowRecordInfo cf : cfCol) {
                cf.setId(null);
                cf.setVoucher(srcVch);
                cf.setEntry((VoucherEntryInfo)hmEntryId.get(cf.getEntry().getId().toString()));
                cf.setOpposingAccountEntry((VoucherEntryInfo)hmEntryId.get(cf.getOpposingAccountEntry().getId().toString()));
                cf.setOriginalAmount(cf.getOriginalAmount().negate());
                cf.setLocalAmount(cf.getLocalAmount().negate());
                cf.setReportingAmount(cf.getReportingAmount().negate());
                if (cf.getOppVoucherAssistRecord() == null || cf.getOppVoucherAssistRecord().getId() == null) continue;
                cf.setOppVoucherAssistRecord((VoucherAssistRecordInfo)hmRecordId.get(cf.getOppVoucherAssistRecord().getId().toString()));
            }
            srcVch.setCashflowRecords((AbstractObjectCollection)cfCol);
            srcVch.setCashflowFetched(true);
            srcVch.put("cashflowFlag", (Object)CashflowFlag.FINISHED);
        }
        if (assistRecIdList.size() > 0 && allowCussent && isInTimeVerify) {
            String idStr = SqlUtils.getInFilter(new HashSet<String>(assistRecIdList));
            String sql = "select fid cussentId,FVCHASSISTRECORDID asstRecId from t_gl_acctcussent where FVCHASSISTRECORDID " + idStr + "";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (executeQuery.next()) {
                    String cussentId = executeQuery.getString("cussentId");
                    String asstRecId = executeQuery.getString("asstRecId");
                    AcctCussentInfo acctCussentInfo = new AcctCussentInfo();
                    acctCussentInfo.setId(BOSUuid.read((String)cussentId));
                    ((VoucherAssistRecordInfo)hmRecordId.get(asstRecId)).setVerifiedCussent(acctCussentInfo);
                }
            }
            catch (SQLException e) {
                log.error((Object)"query acctcussentid error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        VoucherUtil.computeVoucherAttribute(srcVch, this.getGlParam(ctx, srcVch.getCompany().getId().toString()), true, false, ctx);
        return srcVch;
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "ISaveVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"G001", "GL_002", "GL_008", "GL_003", "GLG01", "GL_031", "G010", "GL_VOUCHERNUMBER_LOG", "GL_0301", "GL_100", "GL_VchImp_LogApp", "GL_058", "GL_122"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private void checkSrcVch(Context ctx, VoucherInfo srcVch, PeriodInfo rp) throws BOSException, EASBizException {
        boolean hasVerified;
        if (!VoucherStatusEnum.POSTED.equals((Object)srcVch.getBizStatus())) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_POSTED);
        }
        if (srcVch.isIsReverseVoucher()) {
            throw new VoucherException(VoucherException.VOUCHER_IS_REVERSE);
        }
        if (!rp.getId().equals((Object)srcVch.getPeriod().getId())) {
            HashSet<String> accountIds = new HashSet<String>();
            for (int i = 0; i < srcVch.getEntries().size(); ++i) {
                VoucherEntryInfo entry = srcVch.getEntries().get(i);
                if (entry.getAccount() == null) continue;
                accountIds.add(entry.getAccount().getId().toString());
            }
            if (accountIds.size() > 0) {
                Map caas = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAIdsByPeriod(accountIds, rp.getId().toString());
                for (int i = 0; i < srcVch.getEntries().size(); ++i) {
                    VoucherEntryInfo entry = srcVch.getEntries().get(i);
                    if (entry.getAccount() == null) continue;
                    String newCaa = (String)caas.get(entry.getAccount().getId().toString());
                    String srcCaa = null;
                    if (entry.getCAA() != null) {
                        srcCaa = entry.getCAA().getId().toString();
                    }
                    if (srcCaa == null && newCaa == null) continue;
                    if (srcCaa != null && newCaa != null) {
                        if (srcCaa.equals(newCaa)) continue;
                        throw new VoucherException(VoucherException.ACCOUNT_ASSTACCOUNTCHANGE);
                    }
                    throw new VoucherException(VoucherException.ACCOUNT_ASSTACCOUNTCHANGE);
                }
            }
        }
        if (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(srcVch.getId().toString())) {
            throw new VoucherException(VoucherException.CANNOT_CANCEL_VERIFIED);
        }
        VoucherEntryCollection entries = srcVch.getEntries();
        VoucherEntryInfo entry = null;
        boolean hasPLAccount = false;
        String currentAcctTable = srcVch.getCompany().getAccountTable().getId().toString();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (!currentAcctTable.equals(entry.getAccount().getAccountTableID().getId().toString())) {
                throw new VoucherException(VoucherException.REV_FAILUE_FOR_ACCOUNT_CHANGED);
            }
            if (!AccountProperty.SUNYI.equals((Object)entry.getAccount().getAccountTypeID().getProperty())) continue;
            hasPLAccount = true;
        }
        if (hasPLAccount) {
            boolean canRerveseSunYiVch;
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)srcVch.getCompany());
            Object gl_120 = GlUtils.getParamByKey(ctx, srcVch.getCompany().getId().toString(), "GL_120");
            boolean bl = canRerveseSunYiVch = gl_120 == null ? false : Boolean.valueOf(gl_120.toString());
            if (srcVch.getPeriod().getPeriodYear() != currentPeriod.getPeriodYear() && !canRerveseSunYiVch) {
                throw new VoucherException(VoucherException.REV_FAILURE_FOR_PL);
            }
        }
    }

    public Object[] _fetchInitFilterData(Context ctx, Object[] param) throws BOSException, EASBizException {
        return VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchInitFilterData(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
    }

    @Override
    protected boolean _hasVoucherInCurrentPeriod(Context ctx, BOSUuid prdId, SystemEnum sys) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("period.id", (Object)prdId.toString()));
        fic.add(new FilterItemInfo("sourceSys", (Object)new Integer(sys.getValue())));
        filter.setMaskString("#0 AND #1");
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        VoucherCollection vchCol = this.getVoucherCollection(ctx, view);
        return vchCol.size() > 0;
    }

    @Override
    protected boolean _existsCashOrBankAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        IObjectValue model = super._getValue(ctx, pk, sic);
        return ((VoucherInfo)model).existsCashOrBankAccount();
    }

    @Override
    protected HashMap _fetchAllCustProp(Context ctx, Vector entryIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mappingPropName"));
        sic.add(new SelectorItemInfo("dataType"));
        IAssistCustomizedType typeCtrl = AssistCustomizedTypeFactory.getLocalInstance(ctx);
        AssistCustomizedTypeCollection typeCol = typeCtrl.getAssistCustomizedTypeCollection(view);
        sic = new SelectorItemCollection();
        Iterator itrType = typeCol.iterator();
        while (itrType.hasNext()) {
            AssistCustomizedTypeInfo type = (AssistCustomizedTypeInfo)itrType.next();
            String propName = "assistRecords." + type.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)type.getDataType())) {
                propName = propName + ".id";
            }
            sic.add(new SelectorItemInfo(propName));
        }
        view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer sb = new StringBuffer();
        int n = entryIds.size();
        for (int i = 0; i < n; ++i) {
            sb.append(entryIds.get(i) + ",");
        }
        sb.setLength(sb.length() - 1);
        fic.add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INCLUDE));
        IVoucherEntry entryCtrl = VoucherEntryFactory.getLocalInstance(ctx);
        VoucherEntryCollection colEntry = entryCtrl.getVoucherEntryCollection(view);
        HashMap<BOSUuid, VoucherAssistRecordCollection> hmResult = new HashMap<BOSUuid, VoucherAssistRecordCollection>();
        for (VoucherEntryInfo entry : colEntry) {
            hmResult.put(entry.getId(), entry.getAssistRecords());
        }
        return hmResult;
    }

    @Override
    protected boolean _isHandcraftVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = VoucherInfo.getDefaultProcessSelector();
        VoucherInfo vch = (VoucherInfo)this._getValue(ctx, pk, sic);
        return SourceType.HANDCRAFT.equals((Object)vch.getSourceType());
    }

    @Override
    protected Collection _getReq(Context ctx, BOSUuid vchId) throws BOSException, EASBizException {
        throw new BOSException("VoucherControllerbean doesn't support method _getReq(Context ctx, BOSUuid vchId)");
    }

    @Override
    protected Collection _getReq(Context ctx, CheckViewInfo cond) throws BOSException, EASBizException {
        throw new BOSException("VoucherControllerbean doesn't support method _getReq(Context ctx, CheckViewInfo cond)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        boolean isUseWorkflow = VoucherProcessCache.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_032");
        boolean enbale = this.setWorkflowServiceState(ctx, isUseWorkflow, model);
        try {
            if (voucherInfo.getId() != null) {
                String sql = "select fcreatorid from t_gl_voucher where fid = ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
                try {
                    if (this.isCheckPermission(ctx) && rs.next()) {
                        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            IObjectPK iObjectPK = super.save(ctx, model);
            return iObjectPK;
        }
        finally {
            if (enbale) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        boolean enbale = false;
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            boolean isUseWorkflow = VoucherProcessCache.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_032");
            enbale = this.setWorkflowServiceState(ctx, isUseWorkflow, model);
            model.put("disable_workflow", (Object)enbale);
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            if (this.isCheckPermission(ctx)) {
                boolean check = true;
                Object isCheckBizPerm = VoucherProcessCache.getCache(ctx).getDatas(ctx).get("isCheckBizPerm");
                if (isCheckBizPerm != null && isCheckBizPerm instanceof Boolean) {
                    check = (Boolean)isCheckBizPerm;
                }
                if (check) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
            }
            if (voucherInfo.getCreator() == null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
                voucherInfo.setCreator(userInfo);
            }
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (enbale) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    private boolean isCheckPermission(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"CHECK_SUBMITPERMISSION");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("DataPermissionError:  " + e.getMessage()));
        }
        return false;
    }

    protected boolean setWorkflowServiceState(Context ctx, boolean isUseWorkflow, CoreBaseInfo model) throws BOSException, EASBizException {
        if (model.getId() != null && GlUtils.isRunningWorkflow(ctx, model.getId().toString()) && model.getBoolean("isSSC")) {
            WfEventListenerStateManager.getInstance().disableEventListener();
            return true;
        }
        if (!isUseWorkflow && (model.getId() == null || model.getId() != null && !GlUtils.isRunningWorkflow(ctx, model.getId().toString()))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
            return true;
        }
        return false;
    }

    @Override
    protected void _checkVoucher(Context ctx, IObjectCollection journalCollection, IObjectPK pk) throws BOSException, EASBizException {
        this.lockVoucher(ctx, pk.toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("cashier.id"));
        VoucherInfo voucherInfo = (VoucherInfo)this._getValue(ctx, pk, sic);
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.CHECK);
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.bookBatch((JournalCollection)journalCollection);
        }
        voucherInfo.setCashier(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucherInfo.setIsCheck(true);
        this.updateVoucherCheckStatus(ctx, voucherInfo.getId().toString(), voucherInfo.getCashier().getId().toString(), 1, association);
        this.checkVoucher(ctx, pk);
    }

    @Override
    protected void _checkVoucherValidForChecking(Context ctx, String voucherId, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        block16: {
            String sql = "select fischeck,fbizstatus from  t_gl_voucher where  fid=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherId});
            ObjectUuidPK pk = new ObjectUuidPK(voucherId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("company.id"));
            VoucherInfo voucher = (VoucherInfo)this._getValue(ctx, (IObjectPK)pk, sic);
            String[] paramNumbers = new String[]{"GL_032", "GL_047", "GL_046"};
            HashMap param = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(paramNumbers, voucher.getCompany().getId().toString());
            if (status.equals((Object)VoucherOperateStatusEnum.CHECK)) {
                try {
                    if (!rs.next()) break block16;
                    boolean ischeck = rs.getBoolean("fischeck");
                    if (ischeck) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKED);
                    }
                    boolean useWorkflow = Boolean.valueOf(param.get("GL_032").toString());
                    int isCheckAfterAudit = Integer.valueOf(param.get("GL_047").toString());
                    boolean isCheckBeforPost = Boolean.valueOf(param.get("GL_046").toString());
                    int bizStatus = rs.getInt("fbizstatus");
                    if (!useWorkflow && isCheckBeforPost && bizStatus == 5) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKBFPOST);
                    }
                    if (!useWorkflow && isCheckAfterAudit == 2 && bizStatus < 3) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKAFAUD);
                    }
                    if (!useWorkflow && isCheckAfterAudit == 1 && bizStatus >= 3) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKBFAUD);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"error:", (Throwable)e);
                }
            } else if (status.equals((Object)VoucherOperateStatusEnum.ANTICHECK)) {
                try {
                    if (rs.next()) {
                        boolean ischeck = rs.getBoolean("fischeck");
                        if (!ischeck) {
                            throw new VoucherException(VoucherException.NOTCHECKED);
                        }
                        boolean useWorkflow = Boolean.valueOf(param.get("GL_032").toString());
                        int isCheckAfterAudit = Integer.valueOf(param.get("GL_047").toString());
                        boolean isCheckBeforPost = Boolean.valueOf(param.get("GL_046").toString());
                        int bizStatus = rs.getInt("fbizstatus");
                        if (!useWorkflow && isCheckBeforPost && bizStatus == 5) {
                            throw new VoucherException(VoucherException.VOUCHERCANCECHECKBFCANCEPOST);
                        }
                        if (!useWorkflow && isCheckAfterAudit == 2 && bizStatus < 3) {
                            throw new VoucherException(VoucherException.VOUCHERCANCECHECKBFCANCEAUD);
                        }
                        if (!useWorkflow && isCheckAfterAudit == 1 && bizStatus >= 3) {
                            throw new VoucherException(VoucherException.VOUCHERCANCECHECKAFCANCEAUD);
                        }
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"error:", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected ITransactVoucherColService getPostVoucherCollectionService() {
        return VoucherServiceFactory.getPostVoucherCollectionService();
    }

    private String checkVoucherCheck(Context ctx, String id) throws BOSException, SQLException, EASBizException {
        boolean hasCash;
        String sql = "select fsourcetype,fnumber,fischeck from t_gl_voucher where fid=?  ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        boolean notCheck = false;
        if (set.next()) {
            boolean bl = notCheck = set.getInt("fischeck") == 0;
        }
        if ((hasCash = this._existsCashOrBankAccount(ctx, (IObjectPK)new ObjectUuidPK(id))) && notCheck) {
            return set.getString("fnumber") + "," + ResourceBase.getString((String)resource, (String)"VOUCHERNOTCHECK", (Locale)ctx.getLocale());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String chcekVoucher(Context ctx, String fid, boolean isGLAcctCussent, String curCompanyID, boolean acNoLimited, boolean isInTimeVerify) throws BOSException, SQLDataException, GLPeriodEndException {
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int index = 1;
        StringBuffer errMsg = null;
        try {
            con = this.getConnection(ctx);
            if (!isGLAcctCussent) return null;
            if (!isInTimeVerify) return null;
            String number = null;
            if (acNoLimited) {
                sql = new StringBuffer();
                sql.append("select vch.fnumber,ve.FSeq as FEntrySeq,vast.FSeq as FAsstSeq,vast.FOriginalAmount\t\t\r\n");
                sql.append("from t_gl_VoucherAssistRecord vast,                                         \r\n");
                sql.append("\tt_gl_VoucherEntry ve,                                                   \r\n");
                sql.append("\tt_gl_Voucher vch,                                                   \r\n");
                sql.append("\tt_GL_AcctCussent cust                                                   \r\n");
                sql.append("where                                                                            \r\n");
                sql.append("    vch.FCompanyID = ?             \r\n");
                sql.append("\tand vch.FBizStatus = 3 \t       \r\n");
                sql.append("\tand vch.fid =? ");
                sql.append("  \tand ve.FBillID = vch.FID                                                       \r\n");
                sql.append("\tand vast.FEntryID = ve.FID                                                     \r\n");
                sql.append("    \tand vast.FAssGrpID is not null                                         \r\n");
                sql.append("    and ve.FIsVerify = 1                                                    \r\n");
                sql.append("    and vast.FVerifiedCussentID is not null                                 \r\n");
                sql.append("\tand vast.FVerifiedCussentID = cust.FID                                  \r\n");
                sql.append("\tand vast.FOriginalAmount <> 0\t\t\t\t\t\t        \t\t\t\r\n");
                sql.append("\tand ( SIGN(vast.FOriginalAmount) <> SIGN(cust.FUnVerifiedAmtFor) )        \r\n");
                sql.append("\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
                sql.append(";\r\n");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)fid);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    number = rs.getString("fnumber");
                    errMsg.append(this.getStr(ctx, "VoucherEntrySeq"));
                    errMsg.append(rs.getString("FEntrySeq"));
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "VoucherAssistSeq"));
                    errMsg.append(rs.getString("FAsstSeq"));
                    errMsg.append(";\r");
                }
                if (errMsg.length() > 0) {
                    Object[] info = new String[]{errMsg.toString()};
                    String string = number + "," + new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_AMT_ERRDC, info).getMessage();
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                    return string;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                sql = new StringBuffer();
                sql.append("select vch.fnumber,ve.FSeq as FEntrySeq,vast.FSeq as FAsstSeq,vast.FStandardQuantity    \r\n");
                sql.append("from t_gl_VoucherAssistRecord vast,                                         \r\n");
                sql.append("\tt_gl_VoucherEntry ve,                                                   \r\n");
                sql.append("\tt_gl_Voucher vch,                                                   \r\n");
                sql.append("\tt_GL_AcctCussent cust                                                   \r\n");
                sql.append("where                                                                            \r\n");
                sql.append("    vch.FCompanyID = ?             \r\n");
                sql.append("\tand vch.FBizStatus = 3 \t       \r\n");
                sql.append("\tand vch.fid =? ");
                sql.append("  \tand ve.FBillID = vch.FID                                                       \r\n");
                sql.append("\tand vast.FEntryID = ve.FID                                                     \r\n");
                sql.append("    \tand vast.FAssGrpID is not null                                         \r\n");
                sql.append("    and ve.FIsVerify = 1                                                    \r\n");
                sql.append("    and vast.FVerifiedCussentID is not null                                 \r\n");
                sql.append("\tand vast.FVerifiedCussentID = cust.FID                                  \r\n");
                sql.append("\tand vast.FStandardQuantity <> 0                                         \r\n");
                sql.append("\tand ( SIGN(vast.FStandardQuantity) <> SIGN(cust.FUnVerifiedStdQty) )      \r\n");
                sql.append("\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
                sql.append(";\r\n");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)fid);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    number = rs.getString("fnumber");
                    errMsg.append(this.getStr(ctx, "VoucherEntrySeq"));
                    errMsg.append(rs.getString("FEntrySeq"));
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "VoucherAssistSeq"));
                    errMsg.append(rs.getString("FAsstSeq"));
                    errMsg.append(";\r");
                }
                if (errMsg.length() > 0) {
                    Object[] info = new String[]{errMsg.toString()};
                    String string = number + "," + new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_QTY_ERRDC, info).getMessage();
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                    return string;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            sql = new StringBuffer();
            sql.append("select v.fnumber,v.FAccountNumber,v.FBizNumber from\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("(                                                                                   \r\n");
            sql.append("\tselect vch.fnumber,ve.FAccountID,acct.FNumber as FAccountNumber,isnull(vast.FBizNumber,' ') as FBizNumber,                            \r\n");
            sql.append("\t\tvast.FVerifiedCussentID, sum(vast.FOriginalAmount) as FSumAmount        \r\n");
            sql.append("\tfrom t_gl_VoucherAssistRecord vast,                                             \r\n");
            sql.append("\t\tt_gl_VoucherEntry ve,                                                   \r\n");
            sql.append("\t\tt_gl_Voucher vch,                                                   \r\n");
            sql.append("\t\tt_bd_accountview acct                                                   \r\n");
            sql.append("\twhere                                                                            \r\n");
            sql.append("        vch.FCompanyID = ?           \r\n");
            sql.append("\t\tand vch.FBizStatus = 3       \r\n");
            sql.append("\tand vch.fid =? ");
            sql.append("  \t\tand ve.FBillID = vch.FID                                                       \r\n");
            sql.append("\t\tand vast.FEntryID = ve.FID                                                     \r\n");
            sql.append("    \tand vast.FAssGrpID is not null                                         \r\n");
            sql.append("        and ve.FIsVerify = 1                                                   \r\n");
            sql.append("        and vast.FVerifiedCussentID is not null                                \r\n");
            sql.append("    \tand acct.FID = ve.FAccountID                                           \r\n");
            sql.append("        and (acct.FCAA is not null)                                            \r\n");
            sql.append("        and acct.FAC = 1                                                       \r\n");
            sql.append("\t\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
            sql.append("\tGroup By vch.fnumber,ve.FAccountID,acct.FNumber,vast.FVerifiedCussentID,vast.FBizNumber\t                \r\n");
            sql.append(")as v,                                                                              \r\n");
            sql.append("t_GL_AcctCussent cust                                                               \r\n");
            sql.append("Where v.FVerifiedCussentID = cust.FID                                               \r\n");
            sql.append("\tand v.FSumAmount <> 0                                                           \r\n");
            sql.append("\tand ( ABS(v.FSumAmount) > ABS(cust.FUnVerifiedAmtFor) )                         \r\n");
            sql.append(";\r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)fid);
            rs = stmt.executeQuery();
            errMsg = new StringBuffer();
            while (rs.next()) {
                number = rs.getString("fnumber");
                errMsg.append(this.getStr(ctx, "AccountNumber"));
                errMsg.append(rs.getString("FAccountNumber"));
                if (rs.getString("FBizNumber").compareToIgnoreCase(" ") != 0) {
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "CussentBizNumber"));
                    errMsg.append(rs.getString("FBizNumber"));
                }
                errMsg.append(";\r");
            }
            if (errMsg.length() > 0) {
                Object[] info = new String[]{errMsg.toString()};
                String string = number + "," + new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_AMT_TOOMUCH, info).getMessage();
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return string;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("select v.fnumber,v.FAccountNumber,v.FBizNumber from\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("(                                                                                   \r\n");
            sql.append("\tselect vch.fnumber,ve.FAccountID,acct.FNumber as FAccountNumber,isnull(vast.FBizNumber,' ') as FBizNumber,                            \r\n");
            sql.append("\t\tvast.FVerifiedCussentID, sum(vast.FStandardQuantity) as FSumStdQty        \r\n");
            sql.append("\tfrom t_gl_VoucherAssistRecord vast,                                             \r\n");
            sql.append("\t\tt_gl_VoucherEntry ve,                                                   \r\n");
            sql.append("\t\tt_gl_Voucher vch,                                                   \r\n");
            sql.append("\t\tt_bd_accountview acct                                                   \r\n");
            sql.append("\twhere                                                                            \r\n");
            sql.append("        vch.FCompanyID = ?             \r\n");
            sql.append("\t\tand vch.FBizStatus = 3 \t       \r\n");
            sql.append("\tand vch.fid =? ");
            sql.append("  \t\tand ve.FBillID = vch.FID                                                       \r\n");
            sql.append("\t\tand vast.FEntryID = ve.FID                                                     \r\n");
            sql.append("    \tand vast.FAssGrpID is not null                                         \r\n");
            sql.append("        and ve.FIsVerify = 1                                                   \r\n");
            sql.append("        and vast.FVerifiedCussentID is not null                                \r\n");
            sql.append("    \tand acct.FID = ve.FAccountID                                           \r\n");
            sql.append("        and (acct.FCAA is not null)                                            \r\n");
            sql.append("        and acct.FAC = 1                                                       \r\n");
            sql.append("\t\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
            sql.append("\tGroup By vch.fnumber,ve.FAccountID,acct.FNumber,vast.FVerifiedCussentID,vast.FBizNumber\t                \r\n");
            sql.append(")as v,                                                                              \r\n");
            sql.append("t_GL_AcctCussent cust                                                               \r\n");
            sql.append("Where v.FVerifiedCussentID = cust.FID                                               \r\n");
            sql.append("\tand v.FSumStdQty <> 0                                                           \r\n");
            sql.append("\tand ( ABS(v.FSumStdQty) > ABS(cust.FUnVerifiedStdQty) )                         \r\n");
            sql.append(";\r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)fid);
            rs = stmt.executeQuery();
            errMsg = new StringBuffer();
            while (rs.next()) {
                number = rs.getString("fnumber");
                errMsg.append(this.getStr(ctx, "AccountNumber"));
                errMsg.append(rs.getString("FAccountNumber"));
                if (rs.getString("FBizNumber").compareToIgnoreCase(" ") != 0) {
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "CussentBizNumber"));
                    errMsg.append(rs.getString("FBizNumber"));
                }
                errMsg.append(";\r");
            }
            if (errMsg.length() > 0) {
                Object[] info = new String[]{errMsg.toString()};
                String string = number + "," + new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_QTY_TOOMUCH, info).getMessage();
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return string;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return null;
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
    }

    private String getStr(Context ctx, String id) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)id, (Locale)ctx.getLocale());
    }

    private boolean checkCloseInit(Context ctx, boolean isCheckAccount, boolean isCheckAssist, boolean isCheckCussent, List pkList, String curCompanyID) throws BOSException, EASBizException {
        StringBuffer voucherids = new StringBuffer("");
        int count = 0;
        int n = pkList.size();
        for (int i = 0; i < n; ++i) {
            String vchid = pkList.get(i).toString();
            if (count > 0) {
                voucherids.append(",");
            }
            voucherids.append("'").append(vchid).append("'");
            ++count;
        }
        ObjectUuidPK comPK = new ObjectUuidPK(curCompanyID);
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, curCompanyID);
        PeriodInfo startPeriod = aryPrd[0];
        String startPeriodID = startPeriod.getId().toString();
        PeriodInfo period = aryPrd[1];
        String curPeriodID = period.getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        String loc = "_";
        loc = loc.concat(LocaleUtils.getLocaleString((Locale)ctx.getLocale()).trim());
        StringBuffer errMsg = null;
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_028", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        boolean isGLAcctCussent = bParam;
        try {
            con = this.getConnection(ctx);
            if (isCheckAccount && startPeriodID.equals(curPeriodID)) {
                sql = new StringBuffer();
                sql.append("select 1 where exists          \t\t\r\n");
                sql.append("(select 1 from t_GL_Flag          \t\r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("    and FName = 'glinit'            \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            if (isCheckAssist) {
                sql = new StringBuffer();
                sql.append("select v1.*\t\t\t\t\t\t\t\r\n");
                sql.append("from                                \r\n");
                sql.append("(                                   \r\n");
                sql.append("select distinct ve.FAccountID,      \r\n");
                sql.append("\tacct.FNumber as FAccountNumber, \r\n");
                sql.append("\tacct.FName");
                sql.append(loc);
                sql.append(" as FAccountName\t\t\t\t\t\r\n");
                sql.append("from t_gl_VoucherEntry ve,          \r\n");
                sql.append("\tt_gl_Voucher vch,               \r\n");
                sql.append("\tt_bd_accountview acct           \r\n");
                sql.append("where ve.FBillID = vch.FID    \t\t\r\n");
                sql.append("\tand ve.FAccountID = acct.FID    \r\n");
                sql.append("\tand acct.FCAA is not null       \r\n");
                sql.append("\tand vch.FID in (" + voucherids.toString() + ")           \t\t\r\n");
                sql.append(")v1                                 \r\n");
                sql.append("left join                           \r\n");
                sql.append("(                                   \r\n");
                sql.append("select FKey from t_GL_Flag          \r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("    and FName = 'astinit'           \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")v2                                 \r\n");
                sql.append("on v1.FAccountID = v2.FKey          \r\n");
                sql.append("                                    \r\n");
                sql.append("where v2.FKey is null               \r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(rs.getString("FAccountNumber"));
                    errMsg.append(" ");
                    errMsg.append(rs.getString("FAccountName"));
                    errMsg.append(";");
                }
                if (errMsg.length() > 0) {
                    errMsg.delete(errMsg.length() - 1, errMsg.length());
                    Object[] info = new String[]{errMsg.toString()};
                    throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_NOT_CLOSED, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            if (isCheckCussent && isGLAcctCussent) {
                sql = new StringBuffer();
                sql.append("select v1.*\t\t\t\t\t\t\t\r\n");
                sql.append("from                                \r\n");
                sql.append("(                                   \r\n");
                sql.append("select distinct ve.FAccountID,      \r\n");
                sql.append("\tacct.FNumber as FAccountNumber, \r\n");
                sql.append("\tacct.FName");
                sql.append(loc);
                sql.append(" as FAccountName\t\t\t\t\t\r\n");
                sql.append("from t_gl_VoucherEntry ve,          \r\n");
                sql.append("\tt_gl_Voucher vch,               \r\n");
                sql.append("\tt_bd_accountview acct           \r\n");
                sql.append("where ve.FBillID = vch.FID    \t\t\r\n");
                sql.append("\tand ve.FAccountID = acct.FID    \r\n");
                sql.append("\tand acct.FCAA is not null       \r\n");
                sql.append("    and acct.FAC = 1                \r\n");
                sql.append("\tand vch.FID  in (" + voucherids.toString() + ")              \t\t\r\n");
                sql.append(")v1                                 \r\n");
                sql.append("left join                           \r\n");
                sql.append("(                                   \r\n");
                sql.append("select FKey from t_GL_Flag          \r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("    and FName = 'cussentinit'       \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")v2                                 \r\n");
                sql.append("on v1.FAccountID = v2.FKey          \r\n");
                sql.append("                                    \r\n");
                sql.append("where v2.FKey is null               \r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(rs.getString("FAccountNumber"));
                    errMsg.append(" ");
                    errMsg.append(rs.getString("FAccountName"));
                    errMsg.append(";");
                }
                if (errMsg.length() > 0) {
                    errMsg.delete(errMsg.length() - 1, errMsg.length());
                    Object[] info = new String[]{errMsg.toString()};
                    throw new GLPeriodEndException(GLPeriodEndException.CUSSENT_INIT_NOT_CLOSED, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkPostVoucher(Context ctx, String fid, String companyid) {
        Connection con = null;
        StringBuffer sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int index = 1;
        try {
            con = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("Select FBizStatus from t_GL_Voucher \r\n");
            sql.append("Where FCompanyID = ? \r\n");
            sql.append("and  FID = ? \r\n");
            sql.append(";");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyid);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)fid);
            rs = stmt.executeQuery();
            if (rs == null || !rs.next()) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                String string = this.getVoucherNumber(ctx, fid) + "," + ResourceBase.getString((String)resource, (String)"NO_VOUCHER", (Locale)ctx.getLocale());
                return string;
            }
            int bizStatus = rs.getInt("FBizStatus");
            if (bizStatus != 3) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                String string = this.getVoucherNumber(ctx, fid) + "," + ResourceBase.getString((String)resource, (String)"NOTCOL_VOUCHERST1", (Locale)ctx.getLocale());
                return string;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            String sql2 = "select distinct vch.fcompanyid,vch.fperiodid from t_gl_voucher  vch \t\t\r\n\tinner join t_bd_period per on vch.fperiodid=per.fid \t\t\t\t\t\r\n\tinner join T_BD_SystemStatusCtrol ctr on ctr.fcompanyid=vch.fcompanyid\t\t\t\t\t\t\t\t\t\t\r\n\tinner join t_bd_period per2 on ctr.fcurrentperiodid=per2.fid \t\t\t\t\t\r\n\tinner join T_BD_SystemStatus sta on ctr.fsystemstatusid=sta.fid\t\t\t\r\n\twhere vch.FCompanyID=?\t\t\r\n\tand vch.FID=?\tand sta.fname=6  and ((per.FIsAdjustPeriod=0 and ctr.fcurrentperiodid=vch.fperiodid ) or  ( per.FIsAdjustPeriod=1 and (per.FPeriodyear=per2.FPeriodyear or per.FPeriodyear=per2.FPeriodyear-1) ))";
            stmt = con.prepareStatement(sql2);
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyid);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)fid);
            rs = stmt.executeQuery();
            if (rs == null || !rs.next()) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                String string = this.getVoucherNumber(ctx, fid) + "," + ResourceBase.getString((String)resource, (String)"VCH_NOT_IN_CURRENT_PERIOD", (Locale)ctx.getLocale());
                return string;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (Exception e) {
            log.error((Object)"ERROR", (Throwable)e);
            String string = ResourceBase.getString((String)resource, (String)"FINDERROR", (Locale)ctx.getLocale());
            return string;
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return null;
    }

    protected String getVoucherNumber(Context ctx, String vchid) throws BOSException, SQLException {
        String number = null;
        String sql = "select fnumber from t_gl_voucher where fid=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vchid});
        if (set != null && set.next()) {
            number = set.getString("fnumber");
        }
        return number;
    }

    @Override
    protected void _postVoucherCollection(Context ctx, List pkList, GLPeriodEndFilter filter, Map checkViews) throws BOSException, EASBizException {
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        iGLPeriodEndFacade.postVoucherCollection(filter, checkViews);
        ObjectUuidPK pk = null;
        int n = pkList.size();
        for (int i = 0; i < n; ++i) {
            pk = (ObjectUuidPK)pkList.get(i);
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            this.postVoucher(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected boolean _isAuditStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VoucherInfo vch = (VoucherInfo)this._getValue(ctx, pk);
        return vch.getBizStatus().getValue() == 3;
    }

    @Override
    protected boolean _isPostStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VoucherInfo vch = (VoucherInfo)this._getValue(ctx, pk);
        return vch.getBizStatus().getValue() == 5;
    }

    @Override
    protected boolean _unclosePeriod(Context ctx, IObjectValue model) throws BOSException {
        return true;
    }

    @Override
    protected ICheckVoucherService getCheckVoucherService(Context ctx) throws BOSException {
        return VoucherServiceFactory.getCheckVoucherService(ctx);
    }

    @Override
    protected void _checkVoucher(Context ctx, String id) throws BOSException, EASBizException {
        VoucherFactory.getLocalInstance((Context)ctx).checkVoucher((IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    protected void _checkVoucherCollection(Context ctx, List pkList) throws BOSException, EASBizException {
        ArrayList<ObjectUuidPK> canCheckList = new ArrayList<ObjectUuidPK>();
        this.lockVoucher(ctx, pkList);
        int n = pkList.size();
        for (int i = 0; i < n; ++i) {
            String vchid = pkList.get(i).toString();
            ObjectUuidPK voucherId = new ObjectUuidPK(vchid);
            if (!this._existsCashOrBankAccount(ctx, (IObjectPK)voucherId)) continue;
            String sql = "select 1 from  t_gl_voucher where  fid=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vchid});
            try {
                if (!rs.next()) continue;
                this._checkVoucherValidForChecking(ctx, vchid, VoucherOperateStatusEnum.CHECK);
                canCheckList.add(voucherId);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)"error:", (Throwable)e);
            }
        }
        if (canCheckList.size() <= 0) {
            throw new VoucherException(VoucherException.NONEEDCHECK);
        }
        this.chechVoucherBatch(ctx, canCheckList);
    }

    @Override
    protected void _chechVoucherBatch(Context ctx, List pkList) throws BOSException, EASBizException {
        int i;
        if (pkList == null || pkList.size() <= 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)pkList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.account.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("bizStatus"));
        evi.setSelector(sic);
        VoucherCollection coll = this.getVoucherCollection(ctx, evi);
        VoucherInfo vch = null;
        int size = coll.size();
        for (int i2 = 0; i2 < size; ++i2) {
            vch = coll.get(i2);
            this.checkStatusAndOperate(vch.getBizStatus(), VoucherOperateStatusEnum.CHECK);
        }
        this.setVoucherCollectioStatus(ctx, pkList);
        UserInfo cashier = ContextUtil.getCurrentUserInfo((Context)ctx);
        String cashierID = cashier != null ? cashier.getId().toString() : null;
        for (i = 0; i < coll.size(); ++i) {
            vch = coll.get(i);
            boolean association = VoucherUtil.isAssociationCashManagement(ctx, vch.getCompany());
            if (association) {
                IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
                VoucherEntryCollection entries = vch.getEntries();
                HashSet<String> entryids = new HashSet<String>();
                for (int k = 0; k < entries.size(); ++k) {
                    if (!entries.get(k).getAccount().isIsBank() && !entries.get(k).getAccount().isIsCash()) continue;
                    entryids.add(entries.get(k).getId().toString());
                }
                VoucherBookNotifyByEntryBuilder builder = new VoucherBookNotifyByEntryBuilder();
                JournalCollection ecoll = builder.getJournalColl(ctx, entryids);
                bookNotifyFacade.bookBatch(ecoll);
            }
            this.updateVoucherCheckStatus(ctx, vch.getId().toString(), cashierID, 1, association);
        }
        int n = pkList.size();
        for (i = 0; i < n; ++i) {
            ObjectUuidPK voucherId = (ObjectUuidPK)pkList.get(i);
            this.checkVoucher(ctx, (IObjectPK)voucherId);
        }
    }

    private void setVoucherCollectioStatus(Context ctx, List pkList) throws BOSException {
        StringBuffer voucherids = new StringBuffer();
        int count = 0;
        int n = pkList.size();
        for (int i = 0; i < n; ++i) {
            String vchid = pkList.get(i).toString();
            if (count > 0) {
                voucherids.append(",");
            }
            voucherids.append("'").append(vchid).append("'");
            ++count;
        }
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" Update t_GL_Voucher \r\n");
        sql.append(" Set FisCheck = 1 ,FCashierID = ? \r\n");
        sql.append(" Where FisCheck =0 \r\n");
        sql.append(" and fid in(").append(voucherids.toString()).append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curUserID});
    }

    @Override
    protected void _autoPostVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        List afterListeners;
        boolean isClosed;
        this.lockVoucher(ctx, pk.toString());
        IObjectValue model = this._getValue(ctx, pk, VoucherInfo.getDefaultProcessSelector());
        VoucherInfo voucherInfo = (VoucherInfo)model;
        String curCompanyID = voucherInfo.getCompany().getId().toString();
        List beforeListeners = this.getPostActionBeforeListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        if (!(isClosed = VoucherUtil.closeInit(ctx, voucherInfo.getCompany()))) {
            ArrayList<BOSUuid> pkList = new ArrayList<BOSUuid>();
            pkList.add(voucherInfo.getId());
            if (this.checkCloseInit(ctx, true, true, true, pkList, curCompanyID)) {
                throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
            }
        }
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.POST);
        boolean hasNotice = true;
        this.postVoucher(ctx, voucherInfo.getId().toString(), voucherInfo.getCompany().getId().toString(), 5, false, hasNotice, null);
        this.updateVoucherStatus(ctx, voucherInfo.getId().toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), 5, "FPosterID");
        GLBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 3, false, true);
        if (BooksUtil.canCreateBook((Context)ctx) && BooksUtil.isMasterBook((Context)ctx, (String)voucherInfo.getCompany().getId().toString())) {
            HashMap param = GlUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString());
            boolean useReport = Boolean.valueOf(param.get("G001").toString());
            boolean allowCussent = Boolean.valueOf(param.get("GL_028").toString());
            boolean isInTimeVerify = Integer.parseInt(param.get("GL_052").toString()) == 0;
            BookUtil._transferVoucher(ctx, 1, voucherInfo.getId().toString(), voucherInfo.getCompany().getId().toString(), useReport, allowCussent, isInTimeVerify);
        }
        if ((afterListeners = this.getPostActionAfterListeners(ctx)) != null) {
            for (Object afterListener : afterListeners) {
                ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
            }
        }
    }

    private List getPostActionBeforeListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherPost", "Before");
    }

    private List getPostActionAfterListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherPost", "After");
    }

    @Override
    protected void _postCheckValid(Context ctx, IObjectPK pk) throws BOSException {
        String fid = ctx.toString();
        StringBuffer sbSql = new StringBuffer("select * from t_gl_voucher where fid=");
        sbSql.append("'").append(fid).append("'");
        String checkVoucherEditUIPostSql = sbSql.toString();
    }

    @Override
    protected boolean _checkVoucherForAudit(Context ctx, IObjectPK pk, String accountNumber, int entryDc, String settlementTypeNumber, BigDecimal amount, String comparetype) throws BOSException, EASBizException {
        boolean canAudit = true;
        if (pk != null && accountNumber != null && settlementTypeNumber != null && amount != null && comparetype != null) {
            VoucherInfo info = (VoucherInfo)this._getValue(ctx, pk, VoucherInfo.getAuditorSelector());
            VoucherEntryCollection entries = info.getEntries();
            int count = entries.size();
            block0: for (int i = 0; i < count; ++i) {
                VoucherEntryInfo entryInfo = entries.get(i);
                AccountViewInfo account = entryInfo.getAccount();
                if (!accountNumber.equalsIgnoreCase(account.getNumber()) || entryDc != entryInfo.getEntryDC().getValue()) continue;
                VoucherAssistRecordCollection asstR = entryInfo.getAssistRecords();
                int countR = asstR.size();
                for (int j = 0; j < countR; ++j) {
                    VoucherAssistRecordInfo record = asstR.get(j);
                    SettlementTypeInfo type = record.getSettlementType();
                    if (type == null || !settlementTypeNumber.equalsIgnoreCase(type.getNumber())) continue;
                    BigDecimal amountLocal = record.getLocalAmount();
                    if (!(">=".equalsIgnoreCase(comparetype) && amountLocal.compareTo(amount) >= 0 || ">".equalsIgnoreCase(comparetype) && amountLocal.compareTo(amount) > 0 || "<=".equalsIgnoreCase(comparetype) && amountLocal.compareTo(amount) <= 0 || "<".equalsIgnoreCase(comparetype) && amountLocal.compareTo(amount) < 0) && (!"=".equalsIgnoreCase(comparetype) || amountLocal.compareTo(amount) != 0)) continue;
                    canAudit = false;
                    continue block0;
                }
            }
        }
        return canAudit;
    }

    @Override
    protected BigDecimal _getAmoutBySettlement(Context ctx, IObjectPK id, String accountNUmber, int entryDc, String settlementNumber, BigDecimal amount, String compareType) throws BOSException {
        BigDecimal amountLocal = null;
        if (id != null && accountNUmber != null && settlementNumber != null && amount != null && compareType != null) {
            VoucherInfo info = null;
            try {
                info = (VoucherInfo)this._getValue(ctx, id, VoucherInfo.getAuditorSelector());
            }
            catch (EASBizException e) {
                log.error((Object)e);
                return null;
            }
            VoucherEntryCollection entries = info.getEntries();
            int count = entries.size();
            block2: for (int i = 0; i < count; ++i) {
                VoucherEntryInfo entryInfo = entries.get(i);
                AccountViewInfo account = entryInfo.getAccount();
                if (!accountNUmber.equalsIgnoreCase(account.getNumber()) || entryDc != entryInfo.getEntryDC().getValue()) continue;
                VoucherAssistRecordCollection asstR = entryInfo.getAssistRecords();
                int countR = asstR.size();
                for (int j = 0; j < countR; ++j) {
                    VoucherAssistRecordInfo record = asstR.get(j);
                    SettlementTypeInfo type = record.getSettlementType();
                    if (type == null || !settlementNumber.equalsIgnoreCase(type.getNumber())) continue;
                    amountLocal = record.getLocalAmount();
                    if (">=".equalsIgnoreCase(compareType) && amountLocal.compareTo(amount) >= 0 || ">".equalsIgnoreCase(compareType) && amountLocal.compareTo(amount) > 0 || "<=".equalsIgnoreCase(compareType) && amountLocal.compareTo(amount) <= 0 || "<".equalsIgnoreCase(compareType) && amountLocal.compareTo(amount) < 0 || "=".equalsIgnoreCase(compareType) && amountLocal.compareTo(amount) == 0) continue block2;
                }
            }
        }
        return amountLocal;
    }

    @Override
    protected void _checkVoucherByEntry(Context ctx, String entryId) throws BOSException, EASBizException {
        VoucherEntryInfo entryinfo = this.getEntryInfo(ctx, entryId);
        this._checkVoucherValidForCheckingByEntry(ctx, entryId, VoucherOperateStatusEnum.CHECK);
        String sql = "update t_gl_voucherentry set fischeck =1, fcashierid=?, FCheckDate = ?  where fid=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), GlUtils.getTime(), entryId});
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, entryinfo.getBill().getCompany());
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.book(VoucherBookNotifyByEntryBuilder.class.getName(), entryId);
        }
        sql = "update t_gl_voucher set fischeck =1 ,   fcashierid=? where\u3000fid in (select fbillid from t_gl_voucherentry where fid=? )  ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), entryId});
    }

    private VoucherEntryInfo getEntryInfo(Context ctx, String entryId) throws BOSException, EASBizException {
        IVoucherEntry entry = VoucherEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("bill.*");
        sel.add("bill.company.*");
        VoucherEntryInfo entryinfo = (VoucherEntryInfo)entry.getValue((IObjectPK)new ObjectUuidPK(entryId), sel);
        return entryinfo;
    }

    @Override
    protected void _checkVoucherValidForCheckingByEntry(Context ctx, String entryid, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        VoucherEntryInfo entryinfo = this.getEntryInfo(ctx, entryid);
        if (status == VoucherOperateStatusEnum.CHECK) {
            if (entryinfo.isIsCheck()) {
                Object[] params = new String[]{status.getAlias(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"914_VoucherControllerBean", (Locale)ctx.getLocale())};
                throw new VoucherException(VoucherException.STATUS_AND_OPERATE, params);
            }
            this.checkStatusAndOperate(entryinfo.getBill().getBizStatus(), status);
            return;
        }
        if (status == VoucherOperateStatusEnum.ANTICHECK && !entryinfo.isIsCheck()) {
            Object[] params = new String[]{status.getAlias(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"915_VoucherControllerBean", (Locale)ctx.getLocale())};
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, params);
        }
    }

    @Override
    protected void _antiCheckVoucherByEntry(Context ctx, IObjectPK entryPK) throws BOSException, EASBizException {
        this._checkVoucherValidForCheckingByEntry(ctx, entryPK.toString(), VoucherOperateStatusEnum.ANTICHECK);
        String sql = "update t_gl_voucherentry set fischeck =0 , fcashierid=null, FCheckDate = null where fid=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{entryPK.toString()});
        IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookNotifyFacade.antiBook(entryPK.toString());
        sql = "select e.fischeck, e.fbillid, v.FISBANK , v.FISCASH from t_gl_voucherentry e inner join t_bd_accountview v on e.faccountid = v.fid where fbillid in ( select fbillid from t_gl_voucherentry where fid =? )";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{entryPK.toString()});
        boolean hasCheck = false;
        String bill = null;
        boolean isbank = false;
        boolean iscash = false;
        try {
            while (!hasCheck && row != null && row.next()) {
                isbank = row.getBoolean("FISBANK");
                iscash = row.getBoolean("FISCASH");
                if (isbank || iscash) {
                    hasCheck = row.getBoolean("fischeck");
                }
                bill = row.getString("fbillid");
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (!hasCheck) {
            sql = "update t_gl_voucher set fischeck =0 , fcashierid=null where fid=? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{bill});
        }
    }

    @Override
    protected void _checkVoucherByEntry(Context ctx, IObjectCollection journalCollection, IObjectPK pk) throws BOSException, EASBizException {
        VoucherEntryInfo entry = this.getEntryInfo(ctx, pk.toString());
        VoucherInfo voucherInfo = entry.getBill();
        this.checkStatusAndOperate(entry.getBill().getBizStatus(), VoucherOperateStatusEnum.CHECK);
        String sql = "update t_gl_voucherentry set fischeck =1 , fcashierid=?, FCheckDate = ? where fid=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), GlUtils.getTime(), pk.toString()});
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.bookBatch((JournalCollection)journalCollection);
        }
        sql = "update t_gl_voucher set fischeck =1 ,   fcashierid=? where\u3000fid in (select fbillid from t_gl_voucherentry where fid=? )  ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), pk.toString()});
    }

    @Override
    protected void _checkVoucherByEntries(Context ctx, Set idsset) throws BOSException, EASBizException {
        boolean association;
        VoucherEntryInfo entryinfo = null;
        for (String entryId : idsset) {
            entryinfo = this.getEntryInfo(ctx, entryId);
            this._checkVoucherValidForCheckingByEntry(ctx, entryId, VoucherOperateStatusEnum.CHECK);
        }
        if (entryinfo != null && (association = VoucherUtil.isAssociationCashManagement(ctx, entryinfo.getBill().getCompany()))) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            VoucherBookNotifyByEntryBuilder builder = new VoucherBookNotifyByEntryBuilder();
            JournalCollection coll = builder.getJournalColl(ctx, idsset);
            bookNotifyFacade.bookBatch(coll);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_gl_voucherentry set fischeck =1, fcashierid=?, FCheckDate = ? where ");
        sql.append(FMHelper.buildIn((String)" fid", (Object[])idsset.toArray()));
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), GlUtils.getTime()});
        sql = new StringBuffer();
        sql.append("update t_gl_voucher set fischeck =1 ,   fcashierid=?, FLastUpdateTime=?  where\u3000fid in (select fbillid from t_gl_voucherentry where   ");
        sql.append(FMHelper.buildIn((String)" fid", (Object[])idsset.toArray()));
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), GlUtils.getTime()});
    }

    @Override
    protected String _adjustNumber(Context ctx, String id, boolean isSystem, String number) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(id), VoucherInfo.getDefaultProcessSelector());
        String oldNumber = voucherInfo.getNumber();
        String newNumber = number;
        if (GlUtils.checkHasBillImageMapByVoucherId(ctx, id).booleanValue()) {
            throw new VoucherException(VoucherException.CAN_NOT_ADJUST_NUMBER);
        }
        if (GlUtils.isRunningWorkflow(ctx, id)) {
            throw new VoucherException(VoucherException.IN_WORK_FLOW_NO_ALLOW_ADJUST_NUMBER);
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = null;
        try {
            Map param;
            String companyId = voucherInfo.getCompany().getId().toString();
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            String cuid = company.getCU().getId().toString();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, "GL_ReSortNumber");
            boolean isLockSucceed = mutex.requestMutex(mp);
            if (!isLockSucceed) {
                String exStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLMutexResource", (String)"GL_ReSortNumber_Desc", (Locale)ctx.getLocale());
                throw new VoucherException(VoucherException.PERIOD_ERROR_WITH_GL074, new Object[]{exStr});
            }
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            ctx.put((Object)"GL_VOUCHERNUMBER_LOG", GlUtils.getParamByKey(ctx, null, "GL_VOUCHERNUMBER_LOG"));
            if (isSystem) {
                param = null;
                int count = 0;
                do {
                    voucherInfo.setNumber(null);
                    this.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.SUBMITTED);
                } while ((param = this.checkNumber(ctx, voucherInfo, newNumber = voucherInfo.getNumber())) != null && ++count < 10000);
            } else {
                param = this.checkNumber(ctx, voucherInfo, newNumber);
                if (param != null) {
                    throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                }
            }
            voucherInfo.setNumber(oldNumber);
            this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
            String resPath = resource;
            String strLogRes = ResourceBase.getString((String)resPath, (String)"vchResortNumber", (Locale)ctx.getLocale());
            String strLogMethod = ResourceBase.getString((String)resPath, (String)"logMetaod_AdjustNumber", (Locale)ctx.getLocale());
            String logDetail = MessageFormat.format(strLogRes, voucherInfo.getVoucherType().getName() + "-" + oldNumber, voucherInfo.getVoucherType().getName() + "-" + newNumber);
            IObjectPK logPk = LogUtil.beginLogWithDescription((Context)ctx, (String)strLogMethod, (BOSObjectType)voucherInfo.getBOSType(), null, (String)logDetail, (String)strLogMethod);
            String sql = "update t_gl_voucher set  fnumber=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{newNumber, id});
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            VoucherUtil.midifyVoucherNumber(ctx, id, oldNumber, newNumber);
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection botRelationCol = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
            boolean hasReversed = false;
            BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
            botReverseManager.setOprtState(BOTBillOperStateEnum.EDIT);
            VoucherCollection vcll = new VoucherCollection();
            voucherInfo.setNumber(newNumber);
            vcll.add(voucherInfo);
            int total = botRelationCol.size();
            for (int j = 0; j < total; ++j) {
                BOTRelationInfo botRelationInfo = botRelationCol.get(j);
                hasReversed = botRelationInfo.isIsEffected();
                BOTRelationCollection reBotRelaColl = new BOTRelationCollection();
                reBotRelaColl.add(botRelationInfo);
                botReverseManager.reverseWriteBatch((IObjectCollection)reBotRelaColl, (IObjectCollection)vcll, hasReversed);
            }
            VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber(voucherInfo, oldNumber, "recycleNumber", null);
            VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber(voucherInfo, newNumber, "getNumber", null);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != mutex && null != mp) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
        return newNumber;
    }

    private Map checkNumber(Context ctx, VoucherInfo voucherInfo, String number) throws BOSException, EASBizException {
        Map<String, String> param = new HashMap<String, String>();
        if (voucherInfo.getId() != null) {
            param.put("voucherid", voucherInfo.getId().toString());
        }
        param.put("vouchertypeid", voucherInfo.getVoucherType().getId().toString());
        param.put("period", (String)voucherInfo.getPeriod());
        param.put("number", number);
        param.put("companyid", voucherInfo.getCompany().getId().toString());
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
        param = facade.dealTask("getPreNumberRepeated", param);
        return param;
    }

    @Override
    protected void _deleteFun(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fnumber from T_gl_voucher where fid = '" + pk.toString() + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (set.next() && set.getString(1) != null) {
                this._delete(ctx, pk);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List _requisitionCheckData(Context ctx, String strPeriod, int unChecked, int checked) throws BOSException, EASBizException {
        if ("".equals(strPeriod) || strPeriod.indexOf(".") == -1) {
            throw new VoucherException(VoucherException.VCHIMPPERIODEXCEPTION);
        }
        int index = strPeriod.indexOf(".");
        int year = Integer.parseInt(strPeriod.substring(0, index));
        int periodNumber = Integer.parseInt(strPeriod.substring(index + 1, strPeriod.length()));
        String comid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String sql = "SELECT TCR.FNUMBER FROM T_CSL_Requisition TCR  INNER JOIN T_GL_Voucher TGV  ON TCR.FVoucherID = TGV.FID  INNER JOIN T_CSL_RequisitionEntry TCRE ON TCR.FID = TCRE.Frequisitionid  WHERE TGV.Fperiodid IN (SELECT FID FROM T_BD_PERIOD WHERE Fperiodyear < ? OR (FPERIODYEAR=? AND FperiodNumber <= ?) )  AND TCRE.FStatus = ?  and ( Fsrccompanyid=? or Ftargcompanyid=? )";
        IRowSet rsChecked = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(year), new Integer(year), new Integer(periodNumber), new Integer(checked), comid, comid});
        IRowSet rowsetUnChecked = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(year), new Integer(year), new Integer(periodNumber), new Integer(unChecked), comid, comid});
        int iUnChecked = rowsetUnChecked.size();
        int iChecked = rsChecked.size();
        String[] strUnChecked = new String[iUnChecked];
        int i = 0;
        try {
            while (rowsetUnChecked != null && rowsetUnChecked.next()) {
                strUnChecked[i] = rowsetUnChecked.getString("fnumber");
                ++i;
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        ArrayList<Object> litRequisitionCheckData = new ArrayList<Object>();
        int j = 0;
        litRequisitionCheckData.add(j++, new Integer(iUnChecked));
        litRequisitionCheckData.add(j++, new Integer(iChecked));
        litRequisitionCheckData.add(j++, strUnChecked);
        return litRequisitionCheckData;
    }

    @Override
    protected IObjectPK _reverseSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VoucherInfo srcVch = (VoucherInfo)this.getValue(ctx, pk, VoucherInfo.getReverseSelector());
        Object[] genParam = this.getReverseInitData(ctx, srcVch.getCompany().getId().toString());
        VoucherInfo vch = (VoucherInfo)this._generateReverseVoucher(ctx, pk.toString(), genParam);
        if (vch.getId() == null) {
            this.checkSrcVch(ctx, srcVch, vch.getPeriod());
            String des = srcVch.getDescription();
            String select = ResourceBase.getString((String)resource, (String)"HASREVERSED", (Locale)ctx.getLocale());
            if (des != null) {
                select = select + "_" + des;
            }
            srcVch.setDescription(srcVch.getNumber() + select + "(" + srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber() + ")");
            srcVch.setHasReversed(true);
            super._update(ctx, pk, (IObjectValue)srcVch);
        }
        IObjectPK pk1 = this._save(ctx, (IObjectValue)vch);
        VoucherUtil.saveBOTRelationInfo(ctx, pk.toString(), pk1, vch.getBOSType());
        return pk1;
    }

    private Object[] getReverseInitData(Context ctx, String companyId) throws BOSException, EASBizException {
        Object[] genParam = new Object[3];
        genParam[0] = ContextUtil.getCurrentUserInfo((Context)ctx);
        PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, companyId);
        Date now = new Date();
        Date beginDate = curPeriod.getBeginDate();
        Timestamp endDate = curPeriod.getEndDate();
        if (now.before(beginDate)) {
            now = beginDate;
        } else if (now.after(endDate)) {
            now = endDate;
        }
        now = DateTimeUtils.truncateDate((Date)now);
        genParam[1] = now;
        genParam[2] = curPeriod;
        return genParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK[] _batchSave(Context ctx, IObjectCollection voucherCols) throws BOSException, EASBizException {
        if (voucherCols == null || voucherCols.size() == 0) {
            return null;
        }
        GlParam sysParam = GlParam.getGlParams((Context)ctx, (String[])GlUtils.getDefaultGLParamList(), (String)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        VoucherInfo voucherInfo = null;
        Connection cn = null;
        try {
            IORMappingDAO iVoucher = ORMappingDAO.getInstance((BOSObjectType)new VoucherInfo().getBOSType(), (Context)ctx, cn);
            IORMappingDAO iVoucherEntry = ORMappingDAO.getInstance((BOSObjectType)new VoucherEntryInfo().getBOSType(), (Context)ctx, cn);
            IORMappingDAO iVoucherAssistRecord = ORMappingDAO.getInstance((BOSObjectType)new VoucherAssistRecordInfo().getBOSType(), (Context)ctx, cn);
            int size = voucherCols.size();
            for (int i = 0; i < size; ++i) {
                voucherInfo = (VoucherInfo)voucherCols.getObject(i);
                if (voucherInfo.getCU() == null) {
                    voucherInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
                VoucherUtil.lazyLoad(ctx, voucherInfo, VoucherInfo.getDefaultSelector(), sysParam, false);
                this.checkVoucherVaildForSave(ctx, voucherInfo, sysParam, false);
                if (voucherInfo.getBizStatus() == null) {
                    voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
                }
                ctx.put((Object)"GL_VOUCHERNUMBER_LOG", (Object)sysParam.getBoolean("GL_VOUCHERNUMBER_LOG"));
                this.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP);
                if (voucherInfo.getEntryCount() > 0) {
                    voucherInfo.setVoucherAbstract(voucherInfo.getEntries().get(0).getDescription());
                }
                voucherInfo.setIsMgCtrl(false);
                voucherInfo.setIsCussent(false);
                iVoucher.addNewBatch((IObjectValue)voucherInfo);
                VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
                Iterator iteratorEntry = voucherEntryCollection.iterator();
                VoucherEntryInfo voucherEntryInfo = null;
                VoucherAssistRecordCollection voucherAssistRecordCollection = null;
                while (iteratorEntry.hasNext()) {
                    voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
                    voucherEntryInfo.setBill(voucherInfo);
                    iVoucherEntry.addNewBatch((IObjectValue)voucherEntryInfo);
                    voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                    Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                    VoucherAssistRecordInfo voucherAssistRecordInfo = null;
                    while (iteratorAssist.hasNext()) {
                        voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                        voucherAssistRecordInfo.setBill(voucherInfo);
                        voucherAssistRecordInfo.setEntry(voucherEntryInfo);
                        iVoucherAssistRecord.addNewBatch((IObjectValue)voucherAssistRecordInfo);
                    }
                }
            }
            iVoucher.executeBatch();
            iVoucherEntry.executeBatch();
            iVoucherAssistRecord.executeBatch();
        }
        finally {
            SQLUtils.cleanup(cn);
        }
        return null;
    }

    @Override
    protected IObjectValue _generateReverseVoucherBatch(Context ctx, List srcVchIdList, Object[] genParam) throws BOSException, EASBizException {
        if (srcVchIdList == null || srcVchIdList.size() == 0) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mappingPropName"));
        sic.add(new SelectorItemInfo("dataType"));
        IAssistCustomizedType typeCtrl = AssistCustomizedTypeFactory.getLocalInstance(ctx);
        AssistCustomizedTypeCollection typeCol = typeCtrl.getAssistCustomizedTypeCollection(view);
        sic = VoucherInfo.getDefaultSelector();
        Iterator itrType = typeCol.iterator();
        while (itrType.hasNext()) {
            AssistCustomizedTypeInfo type = (AssistCustomizedTypeInfo)itrType.next();
            String propName = "entries.assistRecords." + type.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)type.getDataType())) {
                propName = propName + ".id";
            }
            sic.add(new SelectorItemInfo(propName));
        }
        UserInfo user = (UserInfo)genParam[0];
        Date time = (Date)genParam[1];
        time = DateTimeUtils.truncateDate((Date)time);
        PeriodInfo prd = (PeriodInfo)genParam[2];
        String strDate = this.periodToString(ctx, prd);
        if (time.before(prd.getBeginDate())) {
            time = prd.getBeginDate();
        } else if (time.after(prd.getEndDate())) {
            time = prd.getEndDate();
        }
        VoucherInfo srcVch = new VoucherInfo();
        srcVch.setId(null);
        srcVch.setIsReverseVoucher(true);
        srcVch.setHasReversed(false);
        srcVch.setNumber(null);
        srcVch.setCreator(user);
        srcVch.setHandler(user);
        srcVch.setCashier(null);
        srcVch.setAuditor(null);
        srcVch.setPoster(null);
        srcVch.setCanceller(null);
        srcVch.setBizDate(time);
        srcVch.setBookedDate(time);
        srcVch.setPeriod(prd);
        srcVch.setSourceSys(SystemEnum.GENERALLEDGER);
        srcVch.setAttachments(0);
        srcVch.put("bizStatus", null);
        srcVch.put("bgStatus", null);
        srcVch.put("hasCashAccount", null);
        srcVch.setCashflowRecords(null);
        srcVch.setCashflowFlag(CashflowFlag.NONE);
        String Verify = ResourceBase.getString((String)resource, (String)"Verify", (Locale)ctx.getLocale());
        String strEntryDesc = Verify + this.periodToString(ctx, prd);
        BigDecimal localDebit = GlUtils.zero;
        BigDecimal localCredit = GlUtils.zero;
        BigDecimal rptDebit = GlUtils.zero;
        BigDecimal rptCredit = GlUtils.zero;
        String number = "";
        String vchtypeid = null;
        int entrycount = 0;
        for (int i = 0; i < srcVchIdList.size(); ++i) {
            Object pk = null;
            pk = srcVchIdList.get(i) instanceof String ? new ObjectUuidPK((String)srcVchIdList.get(i)) : (IObjectPK)srcVchIdList.get(i);
            VoucherInfo vch = (VoucherInfo)this.getValue(ctx, (IObjectPK)pk, sic);
            this.checkSrcVch(ctx, vch, prd);
            number = number + (i > 0 ? "\u3001" : "") + vch.getNumber();
            if (!SourceType.PROFIT_AND_LOSS.equals((Object)srcVch.getSourceType())) {
                srcVch.setSourceType(SourceType.HANDCRAFT);
            }
            srcVch.setCompany(vch.getCompany());
            srcVch.setCU(vch.getCU());
            srcVch.setVoucherType(vch.getVoucherType());
            srcVch.setIsCheck(false);
            if (vch.getBizStatus().getValue() != 5) {
                throw new VoucherException(VoucherException.VOUCHER_NOT_POSTED);
            }
            if (vchtypeid == null) {
                vchtypeid = vch.getVoucherType().getId().toString();
            }
            String entrydesc = vch.getVoucherType().getName() + vch.getNumber();
            entrycount += vch.getEntries().size();
            localDebit = localDebit.add(vch.getLocalDebitAmount());
            localCredit = localCredit.add(vch.getLocalCreditAmount());
            rptDebit = rptDebit.add(vch.getReportingDebitAmount());
            rptCredit = rptCredit.add(vch.getReportingCreditAmount());
            for (VoucherEntryInfo entry : vch.getEntries()) {
                entry.setId(null);
                entry.setBill(srcVch);
                entry.setIsCheck(false);
                entry.setDescription(strEntryDesc + entrydesc + (entry.getDescription() != null ? entry.getDescription() : ""));
                entry.setOprStatus(1);
                if (entry.getQuantity() != null) {
                    entry.setQuantity(entry.getQuantity().negate());
                }
                entry.setOriginalAmount(entry.getOriginalAmount().negate());
                entry.setLocalAmount(entry.getLocalAmount().negate());
                entry.setReportingAmount(entry.getReportingAmount().negate());
                VoucherAssistRecordCollection recCol = entry.getAssistRecords();
                if (recCol == null) continue;
                for (VoucherAssistRecordInfo rec : recCol) {
                    rec.setId(null);
                    rec.setBill(srcVch);
                    rec.setDescription(strEntryDesc + entrydesc + (rec.getDescription() != null ? rec.getDescription() : ""));
                    rec.setOprStatus(1);
                    if (rec.getQuantity() != null) {
                        rec.setQuantity(rec.getQuantity().negate());
                    }
                    rec.setOriginalAmount(rec.getOriginalAmount().negate());
                    rec.setLocalAmount(rec.getLocalAmount().negate());
                    rec.setReportingAmount(rec.getReportingAmount().negate());
                }
            }
            srcVch.getEntries().addObjectCollection((IObjectCollection)vch.getEntries());
        }
        srcVch.setLocalDebitAmount(localDebit.negate());
        srcVch.setLocalCreditAmount(localCredit.negate());
        srcVch.setReportingDebitAmount(rptDebit.negate());
        srcVch.setReportingCreditAmount(rptCredit.negate());
        srcVch.setEntryCount(entrycount);
        String desc = MessageFormat.format(new VoucherException(VoucherException.CANCELLED_DESC).getMessage(), strDate, srcVch.getVoucherType().getName(), number);
        srcVch.setDescription(desc);
        return srcVch;
    }

    @Override
    protected IObjectPK _reverseSaveBatch(Context ctx, List pkList) throws BOSException, EASBizException {
        Object[] genParam = this.getReverseInitData(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        VoucherInfo vch = (VoucherInfo)this._generateReverseVoucherBatch(ctx, pkList, genParam);
        IObjectPK pk1 = this._save(ctx, (IObjectValue)vch);
        if (pk1 != null) {
            for (int i = 0; i < pkList.size(); ++i) {
                Object pk = null;
                pk = pkList.get(i) instanceof String ? new ObjectUuidPK((String)pkList.get(i)) : (IObjectPK)pkList.get(i);
                VoucherInfo srcVch = (VoucherInfo)this.getValue(ctx, (IObjectPK)pk, VoucherInfo.getReverseSelector());
                this.checkSrcVch(ctx, srcVch, vch.getPeriod());
                String des = srcVch.getDescription();
                String select = ResourceBase.getString((String)resource, (String)"HASREVERSED", (Locale)ctx.getLocale());
                if (des != null) {
                    select = select + "_" + des;
                }
                srcVch.setDescription(srcVch.getNumber() + select + "(" + srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber() + ")");
                srcVch.setHasReversed(true);
                super._update(ctx, pk, (IObjectValue)srcVch);
                VoucherUtil.saveBOTRelationInfo(ctx, pk.toString(), pk1, vch.getBOSType());
            }
        }
        return pk1;
    }

    public String periodToString(Context ctx, PeriodInfo prd) {
        String resFullName = resource;
        String ret = String.valueOf(prd.getPeriodYear()) + ResourceBase.getString((String)resFullName, (String)"Year", (Locale)ctx.getLocale()) + String.valueOf(prd.getPeriodNumber()) + ResourceBase.getString((String)resFullName, (String)"Period", (Locale)ctx.getLocale());
        if (prd.isIsAdjustPeriod()) {
            ret = ret + "(" + ResourceBase.getString((String)resFullName, (String)"Adjust", (Locale)ctx.getLocale()) + ")";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _postSingleVoucher(Context ctx, Map hmAllParam, String vchid, int index) throws BOSException, EASBizException {
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        VoucherInfo voucherInfo = (VoucherInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)vchid)));
        CompanyOrgUnitInfo curCompany = voucherInfo.getCompany();
        String curCompanyID = curCompany.getId().toString();
        boolean allowCussent = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        boolean useAC = Boolean.valueOf(hmAllParam.get("GLG01").toString());
        boolean useReport = Boolean.valueOf(hmAllParam.get("G001").toString());
        boolean acNoLimited = Boolean.valueOf(hmAllParam.get("GL_025").toString());
        boolean isCheckBeforPost = Boolean.valueOf(hmAllParam.get("GL_046").toString());
        boolean useWorkFlow = Boolean.valueOf(hmAllParam.get("GL_032").toString());
        boolean isInTimeVerify = Integer.parseInt(hmAllParam.get("GL_052").toString()) == 0;
        boolean isAsstQty = Boolean.valueOf(hmAllParam.get("G010").toString());
        StringBuffer exception = new StringBuffer();
        String select = ResourceBase.getString((String)resource, (String)"SELECTVOUCHER", (Locale)ctx.getLocale());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, (BaseVoucherInfo)voucherInfo, "GL_VoucherPost");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        try {
            String ermsg;
            PostVoucherCheckPara checkPara = new PostVoucherCheckPara();
            ArrayList<ObjectUuidPK> canPostList = new ArrayList<ObjectUuidPK>();
            StringBuffer voucherids = new StringBuffer("");
            int count = 0;
            this.lockVoucher(ctx, vchid);
            String canPost = this.checkPostVoucher(ctx, vchid, curCompanyID);
            if (canPost != null) {
                exception.append(StringUtils.replace((String)select, (String)"{0}", (String)("" + index)));
                exception.append(canPost).append("\r\n\r\n");
            }
            checkPara.setVoucherID(vchid);
            checkPara.setQtyByAsst(isAsstQty);
            checkPara.setUseRptCurrency(useReport);
            checkPara.setIncludePostedVch(true);
            PostVoucherCheckReturn[] checkReturn = iGLPeriodEndFacade.checkPostVoucher(checkPara);
            if (checkReturn != null) {
                exception.append(StringUtils.replace((String)select, (String)"{0}", (String)("" + index)));
                int size = checkReturn.length;
                for (int k = 0; k < size; ++k) {
                    exception.append(checkReturn[k].getVoucherNumber()).append(checkReturn[k].getErrorTip()).append("\r\n\r\n");
                }
            }
            if ((ermsg = this.chcekVoucher(ctx, vchid, allowCussent, curCompanyID, acNoLimited, isInTimeVerify)) != null) {
                exception.append(StringUtils.replace((String)select, (String)"{0}", (String)("" + index)));
                exception.append(ermsg).append("\r\n\r\n");
            }
            if (!useWorkFlow && isCheckBeforPost && (ermsg = this.checkVoucherCheck(ctx, vchid)) != null) {
                exception.append(StringUtils.replace((String)select, (String)"{0}", (String)("" + index)));
                exception.append(ermsg).append("\r\n\r\n");
            }
            if (ermsg == null && canPost == null && checkReturn == null) {
                canPostList.add(new ObjectUuidPK(BOSUuid.read((String)vchid)));
                if (count > 0) {
                    voucherids.append(",");
                }
                voucherids.append("'").append(vchid).append("'");
                ++count;
            }
            if (voucherids.length() != 0) {
                GLPeriodEndFilter filter = new GLPeriodEndFilter();
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                filter.setVoucherid(voucherids.toString());
                filter.setCurUser(user);
                filter.setCurCompany(curCompany);
                filter.setParamIsGLAcctCussent(allowCussent);
                filter.setParamUseAC(useAC);
                filter.setParamUseReportCurrency(useReport);
                filter.setHasNotice(true);
                this.postVoucherCollection(ctx, canPostList, filter, null);
                if (BooksUtil.canCreateBook((Context)ctx) && BooksUtil.isMasterBook((Context)ctx, (String)curCompany.getId().toString())) {
                    BookUtil._transferVoucherCollection(ctx, 1, canPostList, filter.getCurCompany().getId().toString(), useReport, allowCussent, isInTimeVerify);
                }
                GLBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{vchid}, 3, false, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"ERROR", (Throwable)e);
            exception.append(StringUtils.replace((String)select, (String)"{0}", (String)("" + index)));
            if (e instanceof MatchAssignmentException) {
                exception.append(ResourceBase.getString((String)resource, (String)"MatchAssignmentException", (Locale)ctx.getLocale()));
            } else if (e instanceof AlreadyBindProcessInstanceException || e instanceof AlreadyRunningException) {
                exception.append(ResourceBase.getString((String)resource, (String)"AlreadyBindProcessInstanceException", (Locale)ctx.getLocale()));
            } else if (e instanceof WfException) {
                exception.append(ResourceBase.getString((String)resource, (String)"WfException", (Locale)ctx.getLocale()));
            } else if (e instanceof PermissionServiceException) {
                String casu = e.getCause().toString();
                exception.append(casu.substring(casu.indexOf(":") + 1));
            } else {
                exception.append(e.getMessage());
            }
        }
        finally {
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
        if (exception.length() > 0) {
            throw new VoucherException(VoucherException.POSTBATCHEXC, new Object[]{exception.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _postVoucherOneByOne(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
        pkList.add(pk);
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        VoucherInfo voucherInfo = (VoucherInfo)this._getValue(ctx, pk, VoucherInfo.getDefaultSelector());
        CompanyOrgUnitInfo curCompany = voucherInfo.getCompany();
        String curCompanyID = curCompany.getId().toString();
        iGLPeriodEndFacade.checkAccountValid(curCompanyID);
        boolean isClosed = VoucherUtil.closeInit(ctx, curCompany);
        if (!isClosed && this.checkCloseInit(ctx, true, true, true, pkList, curCompanyID)) {
            throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
        }
        HashMap hmAllParam = GlUtils.getDefaultGLParam(ctx, curCompanyID);
        boolean allowCussent = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        boolean useAC = Boolean.valueOf(hmAllParam.get("GLG01").toString());
        boolean useReport = Boolean.valueOf(hmAllParam.get("G001").toString());
        boolean acNoLimited = Boolean.valueOf(hmAllParam.get("GL_025").toString());
        boolean isCheckBeforPost = Boolean.valueOf(hmAllParam.get("GL_046").toString());
        boolean useWorkFlow = Boolean.valueOf(hmAllParam.get("GL_032").toString());
        boolean isInTimeVerify = Integer.parseInt(hmAllParam.get("GL_052").toString()) == 0;
        boolean isAsstQty = Boolean.valueOf(hmAllParam.get("G010").toString());
        List beforeListeners = this.getPostActionBeforeListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        StringBuffer exception = new StringBuffer();
        int number = 1;
        String select = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"55_CashFlowDirectUI", (Locale)ctx.getLocale());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, (BaseVoucherInfo)voucherInfo, "GL_VoucherPost");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        try {
            PostVoucherCheckPara checkPara = new PostVoucherCheckPara();
            ArrayList<ObjectUuidPK> canPostList = new ArrayList<ObjectUuidPK>();
            StringBuffer voucherids = new StringBuffer("");
            int count = 0;
            this.lockVoucher(ctx, pkList);
            int n = pkList.size();
            for (int i = 0; i < n; ++i) {
                String vchid = pkList.get(i).toString();
                String canPost = this.checkPostVoucher(ctx, vchid, curCompanyID);
                if (canPost != null) {
                    number = i + 1;
                    exception.append(StringUtils.replace((String)select, (String)"{0}", (String)("" + number)));
                    exception.append(canPost).append("\r\n\r\n");
                    continue;
                }
                checkPara.setVoucherID(vchid);
                checkPara.setQtyByAsst(isAsstQty);
                checkPara.setUseRptCurrency(useReport);
                checkPara.setIncludePostedVch(true);
                PostVoucherCheckReturn[] checkReturn = iGLPeriodEndFacade.checkPostVoucher(checkPara);
                if (checkReturn != null) {
                    number = i + 1;
                    exception.append(select + number);
                    int size = checkReturn.length;
                    for (int k = 0; k < size; ++k) {
                        exception.append(checkReturn[k].getVoucherNumber()).append(checkReturn[k].getErrorTip()).append("\r\n\r\n");
                    }
                    continue;
                }
                String ermsg = this.chcekVoucher(ctx, vchid, allowCussent, curCompanyID, acNoLimited, isInTimeVerify);
                if (ermsg != null) {
                    number = i + 1;
                    exception.append(select + number);
                    exception.append(ermsg).append("\r\n\r\n");
                    continue;
                }
                if (!useWorkFlow && isCheckBeforPost && (ermsg = this.checkVoucherCheck(ctx, vchid)) != null) {
                    number = i + 1;
                    exception.append(select + number);
                    exception.append(ermsg).append("\r\n\r\n");
                    continue;
                }
                if (ermsg != null || canPost != null || checkReturn != null) continue;
                canPostList.add(new ObjectUuidPK(BOSUuid.read((String)vchid)));
                if (count > 0) {
                    voucherids.append(",");
                }
                voucherids.append("'").append(vchid).append("'");
                ++count;
            }
            if (voucherids.length() != 0) {
                GLPeriodEndFilter filter = new GLPeriodEndFilter();
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                filter.setVoucherid(voucherids.toString());
                filter.setCurUser(user);
                filter.setCurCompany(curCompany);
                filter.setParamIsGLAcctCussent(allowCussent);
                filter.setParamUseAC(useAC);
                filter.setParamUseReportCurrency(useReport);
                filter.setHasNotice(true);
                this.postVoucherCollection(ctx, canPostList, filter, null);
                if (BooksUtil.canCreateBook((Context)ctx) && BooksUtil.isMasterBook((Context)ctx, (String)curCompanyID)) {
                    BookUtil._transferVoucherCollection(ctx, 1, canPostList, filter.getCurCompany().getId().toString(), useReport, allowCussent, isInTimeVerify);
                }
                GLBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{pk.toString()}, 3, false, true);
                List afterListeners = this.getPostActionAfterListeners(ctx);
                if (afterListeners != null) {
                    for (Object afterListener : afterListeners) {
                        ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"ERROR", (Throwable)e);
            if (e instanceof MatchAssignmentException) {
                exception.append(ResourceBase.getString((String)resource, (String)"MatchAssignmentException", (Locale)ctx.getLocale()));
            } else if (e instanceof AlreadyBindProcessInstanceException || e instanceof AlreadyRunningException) {
                exception.append(ResourceBase.getString((String)resource, (String)"AlreadyBindProcessInstanceException", (Locale)ctx.getLocale()));
            } else if (e instanceof WfException) {
                exception.append(ResourceBase.getString((String)resource, (String)"WfException", (Locale)ctx.getLocale()));
            } else if (e instanceof PermissionServiceException) {
                if (e.getCause() != null) {
                    String casu = e.getCause().toString();
                    exception.append(casu.substring(casu.indexOf(":") + 1));
                } else {
                    exception.append(e.getMessage());
                }
            } else {
                exception.append(e.getMessage());
            }
        }
        finally {
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
        if (exception.length() > 0) {
            throw new VoucherException(VoucherException.POSTBATCHEXC, new Object[]{exception.toString()});
        }
    }

    private Map getReverseVoucher(Context ctx, VoucherInfo vch, String srcVchId, boolean isNew, String companyId) throws BOSException {
        ArrayList<String> sqlReverseParams = new ArrayList<String>();
        StringBuffer sqlReverseVch = new StringBuffer();
        sqlReverseVch.append("select ve.fseq fveseq,sum(ve.foriginalamount) fveoriginalamount,sum(ve.flocalamount) fvelocalamount,\r\n");
        sqlReverseVch.append("sum(ve.freportingamount) fvereportingamount, sum(ve.FQuantity) fvequantity,\r\n");
        sqlReverseVch.append("sum(ve.FStandardQuantity) FveStandardQuantity, \r\n");
        sqlReverseVch.append("assist.fseq fassistseq,sum(assist.foriginalamount) fassistoriginalamount,\r\n");
        sqlReverseVch.append("sum(assist.flocalamount) fassistlocalamount,sum(assist.freportingamount) fassistreportingamount, \r\n");
        sqlReverseVch.append("sum(assist.FQuantity) fassistquantity, \r\n");
        sqlReverseVch.append("sum(assist.FStandardQuantity) FassistStandardQuantity \r\n");
        sqlReverseVch.append("from t_gl_voucherentry ve \r\n");
        sqlReverseVch.append("inner join t_gl_voucher v on ve.fbillid=v.fid \r\n");
        sqlReverseVch.append("left join t_gl_voucherassistrecord assist on ve.fid=assist.fentryid \r\n");
        sqlReverseVch.append("where v.fsourcebillid = ? and v.fcompanyid = ? and v.FIsReverseVoucher=1 \r\n");
        sqlReverseParams.add(srcVchId);
        sqlReverseParams.add(companyId);
        if (!isNew) {
            sqlReverseVch.append("and v.fid <> ? \r\n");
            sqlReverseParams.add(vch.getId().toString());
        }
        sqlReverseVch.append(" and v.fbizstatus <> 2 and v.fbizstatus <> 0\r\n");
        sqlReverseVch.append("group by ve.fseq,assist.fseq\r\n");
        sqlReverseVch.append("order by ve.fseq,assist.fseq \r\n");
        IRowSet rsReverseVch = DbUtil.executeQuery((Context)ctx, (String)sqlReverseVch.toString(), (Object[])sqlReverseParams.toArray());
        HashMap<String, ReverseRecord> mapReverseVch = new HashMap<String, ReverseRecord>();
        try {
            ReverseRecord record = null;
            while (rsReverseVch.next()) {
                record = new ReverseRecord();
                record.setVeSeq(rsReverseVch.getInt(1));
                record.setVeOrigAmount(rsReverseVch.getBigDecimal(2) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(2));
                record.setVeLocalAmount(rsReverseVch.getBigDecimal(3) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(3));
                record.setVeReportingAmount(rsReverseVch.getBigDecimal(4) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(4));
                record.setVeQuantity(rsReverseVch.getBigDecimal(5) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(5));
                record.setVeStdQantity(rsReverseVch.getBigDecimal(6) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(6));
                record.setAssistSeq(rsReverseVch.getInt(7));
                record.setAssistOrigAmount(rsReverseVch.getBigDecimal(8) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(8));
                record.setAssistLocalAmount(rsReverseVch.getBigDecimal(9) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(9));
                record.setAssistReportingAmount(rsReverseVch.getBigDecimal(10) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(10));
                record.setAssistQuantity(rsReverseVch.getBigDecimal(11) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(11));
                record.setAssistStdQantity(rsReverseVch.getBigDecimal(12) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(12));
                mapReverseVch.put(String.valueOf(record.getVeSeq()) + "-" + String.valueOf(record.getAssistSeq()), record);
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        return mapReverseVch;
    }

    private Map getReverseVoucherNew(Context ctx, VoucherInfo vch, String srcVchId, boolean isNew, String companyId) throws BOSException {
        ArrayList<String> sqlReverseParams = new ArrayList<String>();
        StringBuffer sqlReverseVch = new StringBuffer();
        sqlReverseVch.append("select ve.fsourcebillid fentrysrcid,sum(ve.foriginalamount) fveoriginalamount,sum(ve.flocalamount) fvelocalamount,\r\n");
        sqlReverseVch.append("sum(ve.freportingamount) fvereportingamount, sum(ve.FQuantity) fvequantity,\r\n");
        sqlReverseVch.append("sum(ve.FStandardQuantity) FveStandardQuantity, \r\n");
        sqlReverseVch.append("assist.fsourcebillid fassistsrcid,sum(assist.foriginalamount) fassistoriginalamount,\r\n");
        sqlReverseVch.append("sum(assist.flocalamount) fassistlocalamount,sum(assist.freportingamount) fassistreportingamount, \r\n");
        sqlReverseVch.append("sum(assist.FQuantity) fassistquantity, \r\n");
        sqlReverseVch.append("sum(assist.FStandardQuantity) FassistStandardQuantity \r\n");
        sqlReverseVch.append("from t_gl_voucherentry ve \r\n");
        sqlReverseVch.append("inner join t_gl_voucher v on ve.fbillid=v.fid \r\n");
        sqlReverseVch.append("left join t_gl_voucherassistrecord assist on ve.fid=assist.fentryid \r\n");
        sqlReverseVch.append("where v.fsourcebillid = ? and v.fcompanyid = ? and v.FIsReverseVoucher=1 \r\n");
        sqlReverseParams.add(srcVchId);
        sqlReverseParams.add(companyId);
        if (!isNew) {
            sqlReverseVch.append("and v.fid <> ? \r\n");
            sqlReverseParams.add(vch.getId().toString());
        }
        sqlReverseVch.append(" and v.fbizstatus <> 2 and v.fbizstatus <> 0\r\n");
        sqlReverseVch.append("group by ve.fsourcebillid,assist.fsourcebillid\r\n");
        sqlReverseVch.append("order by ve.fsourcebillid,assist.fsourcebillid\r\n");
        IRowSet rsReverseVch = DbUtil.executeQuery((Context)ctx, (String)sqlReverseVch.toString(), (Object[])sqlReverseParams.toArray());
        HashMap<String, ReverseRecord> mapReverseVch = new HashMap<String, ReverseRecord>();
        try {
            ReverseRecord record = null;
            while (rsReverseVch.next()) {
                record = new ReverseRecord();
                record.setEntrySrcId(rsReverseVch.getString(1));
                record.setVeOrigAmount(rsReverseVch.getBigDecimal(2) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(2));
                record.setVeLocalAmount(rsReverseVch.getBigDecimal(3) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(3));
                record.setVeReportingAmount(rsReverseVch.getBigDecimal(4) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(4));
                record.setVeQuantity(rsReverseVch.getBigDecimal(5) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(5));
                record.setVeStdQantity(rsReverseVch.getBigDecimal(6) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(6));
                record.setAssistSrcId(rsReverseVch.getString(7));
                record.setAssistOrigAmount(rsReverseVch.getBigDecimal(8) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(8));
                record.setAssistLocalAmount(rsReverseVch.getBigDecimal(9) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(9));
                record.setAssistReportingAmount(rsReverseVch.getBigDecimal(10) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(10));
                record.setAssistQuantity(rsReverseVch.getBigDecimal(11) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(11));
                record.setAssistStdQantity(rsReverseVch.getBigDecimal(12) == null ? GlUtils.zero : rsReverseVch.getBigDecimal(12));
                String assistSrc = record.getAssistSrcId() == null ? "0" : record.getAssistSrcId();
                String key = record.getEntrySrcId() + "_" + assistSrc;
                mapReverseVch.put(key, record);
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        return mapReverseVch;
    }

    protected boolean isReverseNew(Context ctx, String companyId, String srcVchId) throws BOSException {
        ArrayList<String> sqlReverseParams = new ArrayList<String>();
        String sqlReverseVch = "select fid from T_GL_Voucher where fsourcebillid = ? and fcompanyid = ?  and FIsReverseVoucher = 1";
        sqlReverseParams.add(srcVchId);
        sqlReverseParams.add(companyId);
        IRowSet rsReverseVch = DbUtil.executeQuery((Context)ctx, (String)sqlReverseVch.toString(), (Object[])sqlReverseParams.toArray());
        try {
            if (!rsReverseVch.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        sqlReverseParams = new ArrayList();
        sqlReverseVch = "select 1 from T_GL_VoucherEntry where fbillid in (select fid from T_GL_Voucher where fsourcebillid = ? and fcompanyid = ?  and FIsReverseVoucher = 1) and fsourcebillid is not null";
        sqlReverseParams.add(srcVchId);
        sqlReverseParams.add(companyId);
        rsReverseVch = DbUtil.executeQuery((Context)ctx, (String)sqlReverseVch.toString(), (Object[])sqlReverseParams.toArray());
        try {
            if (rsReverseVch.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        return false;
    }

    private void updateOldReverseVoucher(Context ctx, VoucherInfo srcVoucher) throws VoucherException {
        try {
            String sourceBillId = srcVoucher.getId().toString();
            String companyid = srcVoucher.getCompany().getId().toString();
            int entryCnt = srcVoucher.getEntries().size();
            HashMap<Integer, VoucherEntryInfo> seq4EntryMap = new HashMap<Integer, VoucherEntryInfo>();
            for (int i = 0; i < entryCnt; ++i) {
                VoucherEntryInfo entry = srcVoucher.getEntries().get(i);
                seq4EntryMap.put(entry.getSeq(), entry);
            }
            String sql = "select fid from T_GL_Voucher where fsourcebillid = ? and fcompanyid = ? and FIsReverseVoucher = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId, companyid});
            while (rs.next()) {
                sql = "select fsourcebillid from t_gl_voucherentry where FBILLID = ? and fsourcebillid is not null";
                String reverVchId = rs.getString("fid");
                IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reverVchId});
                if (checkRs.next()) {
                    return;
                }
                for (int i = 1; i <= entryCnt; ++i) {
                    VoucherEntryInfo srcEntry = (VoucherEntryInfo)seq4EntryMap.get(i);
                    String srcEntryId = srcEntry.getId().toString();
                    sql = "update t_gl_voucherentry set fsourcebillid = ? where FBILLID = ? and FSEQ = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcEntryId, reverVchId, i});
                    if (srcEntry.getAssistRecords() == null || srcEntry.getAssistRecords().size() <= 0) continue;
                    this.updateReverseAssist(ctx, srcEntry, reverVchId, i);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new VoucherException(VoucherException.NO_MSG, new Object[]{"\u66f4\u65b0\u51b2\u9500\u51ed\u8bc1\u5931\u8d25!\n" + e.getMessage()});
        }
    }

    private void updateReverseAssist(Context ctx, VoucherEntryInfo srcEntryInfo, String reverVchId, int fseq) throws VoucherException {
        try {
            VoucherAssistRecordInfo assistInfo;
            int i;
            String sql = "select fid from t_gl_voucherentry where fbillid = ? and fseq = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reverVchId, fseq});
            String curReverseEntryId = "";
            if (rs.next()) {
                curReverseEntryId = rs.getString("fid");
            }
            VoucherAssistRecordCollection assistColl = srcEntryInfo.getAssistRecords();
            int assistCnt = assistColl.size();
            HashMap<Integer, VoucherAssistRecordInfo> seq4AssistMap = new HashMap<Integer, VoucherAssistRecordInfo>();
            for (i = 0; i < assistCnt; ++i) {
                assistInfo = assistColl.get(i);
                seq4AssistMap.put(assistInfo.getSeq(), assistInfo);
            }
            for (i = 1; i <= assistCnt; ++i) {
                assistInfo = (VoucherAssistRecordInfo)seq4AssistMap.get(i);
                sql = "update t_gl_voucherassistrecord set fsourcebillid = ? where FENTRYID = ? and FSEQ = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{assistInfo.getId().toString(), curReverseEntryId, i});
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new VoucherException(VoucherException.NO_MSG, new Object[]{"\u66f4\u65b0\u51b2\u9500\u51ed\u8bc1\u5931\u8d25!\n" + e.getMessage()});
        }
    }

    private String getResource(Context ctx, String resName, String key, Object[] params) {
        String message = ResourceBase.getString((String)resName, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    @Override
    protected boolean _auditBackVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue model = this._getValue(ctx, pk, VoucherInfo.getDefaultProcessSelector());
        VoucherInfo voucherinfo = (VoucherInfo)model;
        boolean isAuditBack = false;
        if (voucherinfo.isIsAuditBack()) {
            String sql = "update T_GL_Voucher set FIsAuditBack = 0 where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherinfo.getId().toString()});
            String auditSql = "delete from T_GL_AuditOpinion  where FVoucherID = ? ";
            DbUtil.execute((Context)ctx, (String)auditSql, (Object[])new Object[]{voucherinfo.getId().toString()});
            isAuditBack = false;
        } else {
            String sql = "update T_GL_Voucher set FIsAuditBack = 1 where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherinfo.getId().toString()});
            isAuditBack = true;
        }
        return isAuditBack;
    }

    @Override
    protected IObjectValue _getVoucherWithoutPermissionCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.getVoucherInternal(ctx, pk, VoucherInfo.getDefaultSelector());
    }

    @Override
    protected IObjectValue _getVoucherWithoutPermissionCheck(Context ctx, IObjectPK pk, SelectorItemCollection selectors) throws BOSException, EASBizException {
        return this.getVoucherInternal(ctx, pk, selectors == null ? VoucherInfo.getDefaultSelector() : selectors);
    }

    @Override
    protected String _getOpinionID(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fid from T_GL_AuditOpinion where fvoucherid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        String fid = null;
        try {
            if (rs.next()) {
                fid = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fid;
    }

    @Override
    protected void _checkACNoticeCorrelation(Context ctx, String vchId) throws BOSException, EASBizException {
        AcNoticeUtil.checkACNoticeCorrelation(ctx, vchId);
    }

    private void lockVoucher(Context ctx, String voucherId) throws BOSException {
        String sql = "update t_gl_voucher set  FCancellerID = FCancellerID where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherId});
    }

    private void lockVoucher(Context ctx, List pkList) throws BOSException {
        if (pkList.size() == 0) {
            return;
        }
        if (pkList.size() == 1) {
            this.lockVoucher(ctx, pkList.get(0).toString());
            return;
        }
        String voucherIDs = SQLUtil.collection2InList(pkList);
        String sql = "update t_gl_voucher set  FCancellerID = FCancellerID where fid in " + voucherIDs + " ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void _recycleNumber(Context ctx, IObjectValue bizObject, String org, String bindingproperty, String customString, String number) throws BOSException, EASBizException {
        boolean isNumberByHand = GlParam.getGlParams((Context)ctx, (String)"GL_031", (String)((VoucherInfo)bizObject).getCompany().getId().toString()).getBoolean("GL_031");
        if (!isNumberByHand) {
            this._recycleVoucherNumber(ctx, (BaseVoucherInfo)((VoucherInfo)bizObject), number);
        }
    }

    @Override
    protected ITransactVoucherColService getSubmitVoucherCollectionService() {
        return VoucherServiceFactory.getSubmitVoucherCollectionService();
    }

    @Override
    protected void _auditVoucherNewTrans(Context ctx, IObjectPK pk, BOSUuid auditorId) throws BOSException, EASBizException {
        VoucherFactory.getLocalInstance((Context)ctx).auditVoucher(pk, auditorId);
    }

    @Override
    public VoucherCollection getVoucherCollection(Context ctx, EntityViewInfo view) throws BOSException {
        Boolean isCashFlowPrintMe;
        SelectorItemCollection sic = view.getSelector();
        VoucherCollection vchColl = null;
        Boolean isCashFlowPrint = (Boolean)view.get("isCashFlowPrint");
        if (isCashFlowPrint == null) {
            isCashFlowPrint = false;
        }
        if ((isCashFlowPrintMe = (Boolean)view.get("isCashFlowPrintMe")) == null) {
            isCashFlowPrintMe = true;
        }
        try {
            SelectorItemCollection baseSic = new SelectorItemCollection();
            SelectorItemCollection recordSic = new SelectorItemCollection();
            SelectorItemCollection cfSic = new SelectorItemCollection();
            boolean hasEntryId = false;
            boolean hasOppEntryId = false;
            for (int i = 0; i < sic.size(); ++i) {
                String propertyName = sic.get(i).getPropertyName();
                if (propertyName.startsWith("entries.assistRecords.")) {
                    recordSic.add(new SelectorItemInfo(propertyName.substring(22)));
                    continue;
                }
                if (isCashFlowPrint.booleanValue()) {
                    String field;
                    if (isCashFlowPrintMe.booleanValue() && propertyName.startsWith("entries.cashflowEntry.")) {
                        field = propertyName.substring(22);
                        cfSic.add(new SelectorItemInfo(field));
                        if (!"entry.id".equals(field)) continue;
                        hasEntryId = true;
                        continue;
                    }
                    if (!isCashFlowPrintMe.booleanValue() && propertyName.startsWith("entries.cashflowRecords.")) {
                        field = propertyName.substring(24);
                        cfSic.add(new SelectorItemInfo(field));
                        if (!"opposingAccountEntry.id".equals(field)) continue;
                        hasOppEntryId = true;
                        continue;
                    }
                    baseSic.add(sic.get(i));
                    continue;
                }
                baseSic.add(sic.get(i));
            }
            view.setSelector(baseSic);
            vchColl = super.getVoucherCollection(ctx, view);
            HashSet<ObjectUuidPK> pkSet = new HashSet<ObjectUuidPK>();
            if (!recordSic.isEmpty()) {
                recordSic.add(new SelectorItemInfo("entry.id"));
                view.setSelector(recordSic);
                SorterItemCollection sort = view.getSorter();
                SorterItemCollection recordSort = new SorterItemCollection();
                for (int i = 0; i < sort.size(); ++i) {
                    if (!sort.get(i).getPropertyName().startsWith("entries.assistRecords.")) continue;
                    recordSort.add(new SorterItemInfo(sort.get(i).getPropertyName().substring(22)));
                }
                view.setSorter(recordSort);
                view.getSorter().add(new SorterItemInfo("entry.id"));
                if (!this.checkAssistRecordSorter(view.getSorter(), "seq")) {
                    view.getSorter().add(new SorterItemInfo("seq"));
                }
                VoucherAssistRecordCollection recordAll = new VoucherAssistRecordCollection();
                for (int i = 0; i < vchColl.size(); ++i) {
                    pkSet.add(new ObjectUuidPK(vchColl.get(i).getId()));
                    if (pkSet.size() < 50) continue;
                    this.getVoucherAssistRecordCollectionByBill(ctx, view, pkSet, recordAll);
                }
                if (pkSet.size() > 0) {
                    this.getVoucherAssistRecordCollectionByBill(ctx, view, pkSet, recordAll);
                }
                if (recordAll != null && !recordAll.isEmpty()) {
                    int i;
                    HashMap<BOSUuid, VoucherAssistRecordCollection> recordMap = new HashMap<BOSUuid, VoucherAssistRecordCollection>();
                    for (i = 0; i < recordAll.size(); ++i) {
                        BOSUuid entryId = recordAll.get(i).getEntry().getId();
                        VoucherAssistRecordCollection coll = (VoucherAssistRecordCollection)recordMap.get(entryId);
                        if (coll == null) {
                            coll = new VoucherAssistRecordCollection();
                            recordMap.put(entryId, coll);
                        }
                        coll.add(recordAll.get(i));
                    }
                    for (i = 0; i < vchColl.size(); ++i) {
                        VoucherInfo voucherInfo = vchColl.get(i);
                        for (int j = 0; j < voucherInfo.getEntries().size(); ++j) {
                            VoucherEntryInfo entry = voucherInfo.getEntries().get(j);
                            VoucherAssistRecordCollection coll = (VoucherAssistRecordCollection)recordMap.get(entry.getId());
                            if (coll == null) continue;
                            entry.getAssistRecords().addCollection(coll);
                        }
                    }
                }
            }
            if (isCashFlowPrint.booleanValue() && cfSic.size() > 0) {
                int i;
                if (isCashFlowPrintMe.booleanValue()) {
                    if (!hasEntryId) {
                        cfSic.add("entry.id");
                    }
                } else if (!hasOppEntryId) {
                    cfSic.add("opposingAccountEntry.id");
                }
                HashMap<String, CashflowRecordCollection> cfrss = new HashMap<String, CashflowRecordCollection>();
                HashSet<String> ids = new HashSet<String>();
                for (i = 0; i < vchColl.size(); ++i) {
                    ids.add(vchColl.get(i).getId().toString());
                    if (ids.size() < 50) continue;
                    this.fetchCashflowRecordCollection(ctx, ids, cfSic, cfrss, isCashFlowPrintMe);
                    ids.clear();
                }
                if (ids.size() > 0) {
                    this.fetchCashflowRecordCollection(ctx, ids, cfSic, cfrss, isCashFlowPrintMe);
                }
                for (i = 0; i < vchColl.size(); ++i) {
                    for (int j = 0; j < vchColl.get(i).getEntries().size(); ++j) {
                        String entryId = vchColl.get(i).getEntries().get(j).getId().toString();
                        if (!cfrss.containsKey(entryId)) continue;
                        if (isCashFlowPrintMe.booleanValue()) {
                            vchColl.get(i).getEntries().get(j).put("cashflowEntry", cfrss.get(entryId));
                            continue;
                        }
                        vchColl.get(i).getEntries().get(j).put("cashflowRecords", cfrss.get(entryId));
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"ERROR", (Throwable)ex);
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            cache.setVoucherCollection(view.getSelector(), vchColl);
        }
        return vchColl;
    }

    private boolean checkAssistRecordSorter(SorterItemCollection sorter, String value) {
        for (int i = 0; i < sorter.size(); ++i) {
            if (!sorter.get(i).getPropertyName().equals(value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoucherAssistRecordCollection getVoucherAssistRecordCollectionByBill(Context ctx, EntityViewInfo view, Set pkSet, VoucherAssistRecordCollection recordAll) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)pkSet, CompareType.INCLUDE));
        view.setFilter(filter);
        Connection cn = null;
        VoucherAssistRecordCollection recordColl = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new VoucherAssistRecordInfo().getBOSType(), (Context)ctx, (Connection)cn);
            recordColl = (VoucherAssistRecordCollection)dao.getCollection(view);
            if (recordColl != null && !recordColl.isEmpty()) {
                recordAll.addCollection(recordColl);
            }
            pkSet.clear();
        }
        catch (Exception ex) {
            log.error((Object)"ERROR", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return recordAll;
    }

    public void fetchCashflowRecordCollection(Context ctx, Set<String> ids, SelectorItemCollection selector, Map<String, CashflowRecordCollection> cfrss, boolean isCashFlowPrintMe) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        CashflowRecordCollection coll = CashflowRecordFactory.getLocalInstance(ctx).getCashflowRecordCollection(view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            CashflowRecordInfo cfr = coll.get(i);
            String entryId = null;
            if (isCashFlowPrintMe) {
                if (cfr.getEntry() != null) {
                    entryId = cfr.getEntry().getId().toString();
                }
            } else if (cfr.getOpposingAccountEntry() != null) {
                entryId = cfr.getOpposingAccountEntry().getId().toString();
            }
            if (entryId == null) continue;
            CashflowRecordCollection cfrs = cfrss.get(entryId);
            if (cfrs == null) {
                cfrs = new CashflowRecordCollection();
                cfrss.put(entryId, cfrs);
            }
            cfrs.add(cfr);
        }
    }

    public void disablePermission() throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_ENTRYS_SERVICE");
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
    }

    protected void computeCashflowFlag(VoucherInfo voucherInfo) {
        if (voucherInfo.getCashflowFlag() != CashflowFlag.FINISHED) {
            voucherInfo.setCashflowFlag(CashFlowUtils.computeCashflowFlag(voucherInfo));
        }
    }

    @Override
    protected ITransactVoucherColService getAntiCancelVoucherCollectionService() {
        return VoucherServiceFactory.getAntiCancelVoucherCollectionService();
    }

    @Override
    protected ITransactVoucherColService getDeleteVoucherCollectionService() {
        return VoucherServiceFactory.getDeleteVoucherCollectionService();
    }

    @Override
    protected IPostVoucherService getPostService(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        return VoucherServiceFactory.getPostVoucherService(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected boolean _isNumberAccordRule(Context ctx, VoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        CodingRuleInfo codingRuleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
        String strDbType = ContextUtil.getDbType((Context)ctx);
        if ("DM".equals(strDbType)) {
            return true;
        }
        if (codingRuleInfo == null) {
            return true;
        }
        CodingRuleInfo codingrule = codingRuleInfo;
        return VoucherUtil.isVoucherNumberPatternAccordRule(ctx, codingrule, voucherInfo, voucherNumber);
    }

    @Override
    protected String _getAvaiableVoucherNumber(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        String newNumber;
        Map param = null;
        int count = 0;
        while ((param = this.checkNumber(ctx, voucherInfo, newNumber = this._getVoucherNumber(ctx, (BaseVoucherInfo)voucherInfo))) != null && ++count < 10000) {
        }
        return newNumber;
    }

    @Override
    protected void logVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String number, String action, Exception ex) throws BOSException, EASBizException {
        VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber((VoucherInfo)voucherInfo, number, action, ex);
    }

    @Override
    protected MutexParameter buildModifyMutexParameter(Context ctx, BaseVoucherInfo voucherInfo, String actionResName) {
        if (voucherInfo.getSourceType() != null && SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return null;
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.isMutexLockModifyBalance()) {
            return null;
        }
        if (voucherInfo.getCompany() != null && voucherInfo.getCompany().getId() != null) {
            String companyId = voucherInfo.getCompany().getId().toString();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, actionResName, voucherInfo.getNumber(), MutexLockType.SHARE_LOCK);
            return mp;
        }
        return null;
    }

    @Override
    protected void _postVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        VoucherInfo voucherInfo = this.getVoucherInternal(ctx, pk, selector);
        VoucherPostProcessorInvokeFactory.invokeVoucherPostPostProcessor(ctx, voucherInfo);
    }

    @Override
    protected IObjectValue _generateReverseWebVoucher(Context ctx, String srcVchId, Object[] genParam) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mappingPropName"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("voucherType.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        IAssistCustomizedType typeCtrl = AssistCustomizedTypeFactory.getLocalInstance(ctx);
        AssistCustomizedTypeCollection typeCol = typeCtrl.getAssistCustomizedTypeCollection(view);
        Iterator itrType = typeCol.iterator();
        while (itrType.hasNext()) {
            AssistCustomizedTypeInfo type = (AssistCustomizedTypeInfo)itrType.next();
            String propName = "entries.assistRecords." + type.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)type.getDataType())) {
                propName = propName + ".id";
            }
            sic.add(new SelectorItemInfo(propName));
        }
        sic = VoucherInfo.fullSelector((SelectorItemCollection)sic);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)srcVchId));
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        VoucherInfo srcVch = (VoucherInfo)this.getValue(ctx, (IObjectPK)pk, sic);
        boolean bFlag = permission.hasDataPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), (IObjectPK)new ObjectUuidPK(srcVch.getCompany().getId()), "gl_voucher094_reverse", (IObjectPK)pk);
        if (!bFlag) {
            throw new VoucherException(VoucherException.VOUCHERREVERSE_NODATAPERMISSION, new Object[]{srcVch.getNumber()});
        }
        UserInfo user = (UserInfo)genParam[0];
        PeriodInfo prd = (PeriodInfo)genParam[2];
        Date time = prd.getEndDate();
        Date date = srcVch.getBookedDate();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = df.format(date);
        if (time.before(date)) {
            time = date;
            prd = srcVch.getPeriod();
        }
        this.checkSrcVch(ctx, srcVch, prd);
        String Verify = ResourceBase.getString((String)resource, (String)"Verify", (Locale)ctx.getLocale());
        String Number2 = ResourceBase.getString((String)resource, (String)"Number", (Locale)ctx.getLocale());
        String strEntryDesc = Verify + strDate + srcVch.getVoucherType().getName() + srcVch.getNumber() + Number2;
        String desc = MessageFormat.format(new VoucherException(VoucherException.CANCELLED_DESC).getMessage(), strDate, srcVch.getVoucherType().getName(), srcVch.getNumber());
        srcVch.setSourceBillId(srcVch.getId().toString());
        srcVch.setId(null);
        srcVch.setExist(false);
        srcVch.setIsReverseVoucher(true);
        srcVch.setHasReversed(false);
        srcVch.setNumber(null);
        srcVch.setCreator(user);
        srcVch.setHandler(user);
        srcVch.setCashier(null);
        srcVch.setAuditor(null);
        srcVch.setPoster(null);
        srcVch.setCanceller(null);
        srcVch.setIsCheck(false);
        srcVch.setIsCussent(false);
        srcVch.setBizDate(time);
        srcVch.setBookedDate(time);
        srcVch.setPeriod(prd);
        srcVch.setSourceSys(SystemEnum.GENERALLEDGER);
        if (!SourceType.PROFIT_AND_LOSS.equals((Object)srcVch.getSourceType())) {
            srcVch.setSourceType(SourceType.HANDCRAFT);
        }
        srcVch.setDescription(desc);
        srcVch.setAttachments(0);
        srcVch.put("bizStatus", null);
        srcVch.put("bgStatus", null);
        srcVch.put("hasCashAccount", null);
        Map mapReverseVch = this.getReverseVoucher(ctx, null, srcVchId, true, srcVch.getCompany().getId().toString());
        BigDecimal localDebit = GlUtils.zero;
        BigDecimal localCredit = GlUtils.zero;
        BigDecimal rptDebit = GlUtils.zero;
        BigDecimal rptCredit = GlUtils.zero;
        HashMap<String, VoucherEntryInfo> hmEntryId = new HashMap<String, VoucherEntryInfo>();
        CashflowFlag cfFlag = srcVch.getCashflowFlag();
        Iterator itrEntry = srcVch.getEntries().iterator();
        HashMap<BOSUuid, BOSUuid> entryIdMap = new HashMap<BOSUuid, BOSUuid>();
        while (itrEntry.hasNext()) {
            VoucherEntryInfo entry = (VoucherEntryInfo)itrEntry.next();
            BOSUuid srcEntryId = entry.getId();
            BOSUuid targEntryId = (BOSUuid)entryIdMap.get(srcEntryId);
            if (targEntryId == null) {
                targEntryId = BOSUuid.create((BOSObjectType)entry.getBOSType());
                entryIdMap.put(srcEntryId, targEntryId);
            }
            entry.setId(targEntryId);
            entry.setDescription(strEntryDesc + (entry.getDescription() != null ? entry.getDescription() : ""));
            entry.setOprStatus(1);
            entry.setIsCheck(false);
            entry.setIsHand(true);
            VoucherAssistRecordCollection recCol = entry.getAssistRecords();
            if (recCol != null && recCol.size() > 0) {
                BigDecimal origAmount = GlUtils.zero;
                BigDecimal localAmount = GlUtils.zero;
                BigDecimal reportingAmount = GlUtils.zero;
                BigDecimal quantity = GlUtils.zero;
                BigDecimal stdQuantity = GlUtils.zero;
                for (VoucherAssistRecordInfo rec : recCol) {
                    rec.setId(null);
                    rec.setDescription(strEntryDesc + (rec.getDescription() != null ? rec.getDescription() : ""));
                    rec.setBizDate(time);
                    rec.setOprStatus(1);
                    ReverseRecord reverseValue = (ReverseRecord)mapReverseVch.get(String.valueOf(entry.getSeq()) + "-" + String.valueOf(rec.getSeq()));
                    if (reverseValue == null) {
                        rec.setOriginalAmount(rec.getOriginalAmount().negate());
                        rec.setLocalAmount(rec.getLocalAmount().negate());
                        rec.setReportingAmount(rec.getReportingAmount().negate());
                        if (rec.getQuantity() != null) {
                            rec.setQuantity(rec.getQuantity().negate());
                            quantity = quantity.add(rec.getQuantity());
                        }
                        if (rec.getQuantity() != null) {
                            rec.setStandardQuantity(rec.getStandardQuantity().negate());
                            stdQuantity = stdQuantity.add(rec.getStandardQuantity());
                        }
                    } else {
                        rec.setOriginalAmount(rec.getOriginalAmount().add(reverseValue.getAssistOrigAmount()).negate());
                        rec.setLocalAmount(rec.getLocalAmount().add(reverseValue.getAssistLocalAmount()).negate());
                        rec.setReportingAmount(rec.getReportingAmount().add(reverseValue.getAssistReportingAmount()).negate());
                        if (rec.getQuantity() != null) {
                            rec.setQuantity(rec.getQuantity().add(reverseValue.getAssistQuantity()).negate());
                            quantity = quantity.add(rec.getQuantity());
                        }
                        if (rec.getStandardQuantity() != null) {
                            rec.setStandardQuantity(rec.getStandardQuantity().add(reverseValue.getAssistStdQantity()).negate());
                            stdQuantity = stdQuantity.add(rec.getStandardQuantity());
                        }
                    }
                    origAmount = origAmount.add(rec.getOriginalAmount());
                    localAmount = localAmount.add(rec.getLocalAmount());
                    reportingAmount = reportingAmount.add(rec.getReportingAmount());
                }
                entry.setOriginalAmount(origAmount);
                entry.setLocalAmount(localAmount);
                entry.setReportingAmount(reportingAmount);
                entry.setQuantity(quantity);
                entry.setStandardQuantity(stdQuantity);
            } else {
                ReverseRecord reverseValue = (ReverseRecord)mapReverseVch.get(String.valueOf(entry.getSeq()) + "-0");
                if (reverseValue == null) {
                    entry.setOriginalAmount(entry.getOriginalAmount().negate());
                    entry.setLocalAmount(entry.getLocalAmount().negate());
                    entry.setReportingAmount(entry.getReportingAmount().negate());
                    if (entry.getQuantity() != null) {
                        entry.setQuantity(entry.getQuantity().negate());
                    }
                    if (entry.getStandardQuantity() != null) {
                        entry.setStandardQuantity(entry.getStandardQuantity().negate());
                    }
                } else {
                    entry.setOriginalAmount(entry.getOriginalAmount().add(reverseValue.getVeOrigAmount()).negate());
                    entry.setLocalAmount(entry.getLocalAmount().add(reverseValue.getVeLocalAmount()).negate());
                    entry.setReportingAmount(entry.getReportingAmount().add(reverseValue.getVeReportingAmount()).negate());
                    if (entry.getQuantity() != null) {
                        entry.setQuantity(entry.getQuantity().add(reverseValue.getVeQuantity()).negate());
                    }
                    if (entry.getStandardQuantity() != null) {
                        entry.setStandardQuantity(entry.getStandardQuantity().add(reverseValue.getVeStdQantity()).negate());
                    }
                }
            }
            if (CashflowFlag.FINISHED.equals((Object)cfFlag)) {
                hmEntryId.put(String.valueOf(entry.getSeq()), entry);
            }
            if (entry.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                localDebit = localDebit.add(entry.getLocalAmount());
                rptDebit = rptDebit.add(entry.getReportingAmount());
                continue;
            }
            localCredit = localCredit.add(entry.getLocalAmount());
            rptCredit = rptCredit.add(entry.getReportingAmount());
        }
        srcVch.setLocalDebitAmount(localDebit);
        srcVch.setLocalCreditAmount(localCredit);
        srcVch.setReportingDebitAmount(rptDebit);
        srcVch.setReportingCreditAmount(rptCredit);
        if (CashflowFlag.FINISHED.equals((Object)cfFlag)) {
            view = new EntityViewInfo();
            sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("voucher.id", (Object)srcVchId));
            ICashflowRecord recCtrl = CashflowRecordFactory.getLocalInstance(ctx);
            CashflowRecordCollection cfCol = recCtrl.getCashflowRecordCollection(view);
            ArrayList cashFlowList = new ArrayList();
            Iterator itrCf = cfCol.iterator();
            while (itrCf.hasNext()) {
                HashMap<String, Number> cashMap = new HashMap<String, Number>();
                CashflowRecordInfo cf = (CashflowRecordInfo)itrCf.next();
                cashMap.put("ownAccount", cf.getEntry().getSeq());
                cashMap.put("oppAccount", cf.getOpposingAccountEntry().getSeq());
                cashMap.put("primaryItem", (Number)cf.getPrimaryItem());
                cashMap.put("supplementaryItem", (Number)cf.getSupplementaryItem());
                cashMap.put("itemFlag", cf.getItemFlag().getValue());
                cashMap.put("type", cf.getType().getValue());
                cashMap.put("originalAmount", cf.getOriginalAmount().negate());
                cashMap.put("localAmount", cf.getLocalAmount().negate());
                cashMap.put("reportingAmount", cf.getReportingAmount().negate());
                cf.setId(null);
                cf.setVoucher(srcVch);
                cf.setEntry((VoucherEntryInfo)hmEntryId.get(String.valueOf(cf.getEntry().getSeq())));
                cf.setOpposingAccountEntry((VoucherEntryInfo)hmEntryId.get(String.valueOf(cf.getOpposingAccountEntry().getSeq())));
                cf.setOriginalAmount(cf.getOriginalAmount().negate());
                cf.setLocalAmount(cf.getLocalAmount().negate());
                cf.setReportingAmount(cf.getReportingAmount().negate());
                cashFlowList.add(cashMap);
            }
            srcVch.put("cashflow", cashFlowList);
            srcVch.setCashflowFetched(true);
            srcVch.put("cashflowFlag", (Object)CashflowFlag.FINISHED);
        }
        VoucherInfo webVoucherInfo = new WebVoucherTransfer(ctx, srcVch).transferReverseVoucher();
        return webVoucherInfo;
    }

    @Override
    protected void _previewVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = WebVoucherUtils.toVoucherInfo(ctx, (VoucherInfo)model);
        ISubmitVoucherService service = this.getSubmitVoucherService(ctx, (BaseVoucherInfo)voucherInfo);
        service.submitVoucher(ctx, (BaseVoucherInfo)voucherInfo);
    }

    @Override
    protected boolean _canRequireMutex(Context ctx, String voucherId) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ObjectUpdateLock lock = mutexService.getObjectUpdateLock(voucherId);
        if (lock == null) {
            return true;
        }
        DataLockParameter dataLockParameter = new DataLockParameter(voucherId, null, null, "");
        dataLockParameter.setCtx(ctx);
        ContextJudgement judgement = new ContextJudgement();
        return judgement.isSameClinet(dataLockParameter, lock);
    }

    @Override
    protected boolean _requireMutex(Context ctx, String voucherId) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(voucherId);
    }

    private static class ReverseRecord {
        private int veSeq = 0;
        private String entrySrcId = null;
        private BigDecimal veOrigAmount = GlUtils.zero;
        private BigDecimal veLocalAmount = GlUtils.zero;
        private BigDecimal veReportingAmount = GlUtils.zero;
        private BigDecimal veQuantity = GlUtils.zero;
        private BigDecimal veStdQantity = GlUtils.zero;
        private int assistSeq = 0;
        private String assistSrcId = null;
        private BigDecimal assistOrigAmount = GlUtils.zero;
        private BigDecimal assistLocalAmount = GlUtils.zero;
        private BigDecimal assistReportingAmount = GlUtils.zero;
        private BigDecimal assistQuantity = GlUtils.zero;
        private BigDecimal assistStdQantity = GlUtils.zero;

        private ReverseRecord() {
        }

        public String getEntrySrcId() {
            return this.entrySrcId;
        }

        public void setEntrySrcId(String entrySrcId) {
            this.entrySrcId = entrySrcId;
        }

        public String getAssistSrcId() {
            return this.assistSrcId;
        }

        public void setAssistSrcId(String assistSrcId) {
            this.assistSrcId = assistSrcId;
        }

        public int getVeSeq() {
            return this.veSeq;
        }

        public void setVeSeq(int veSeq) {
            this.veSeq = veSeq;
        }

        public BigDecimal getVeOrigAmount() {
            return this.veOrigAmount;
        }

        public void setVeOrigAmount(BigDecimal veOrigAmount) {
            this.veOrigAmount = veOrigAmount;
        }

        public BigDecimal getVeLocalAmount() {
            return this.veLocalAmount;
        }

        public void setVeLocalAmount(BigDecimal veLocalAmount) {
            this.veLocalAmount = veLocalAmount;
        }

        public BigDecimal getVeReportingAmount() {
            return this.veReportingAmount;
        }

        public void setVeReportingAmount(BigDecimal veReportingAmount) {
            this.veReportingAmount = veReportingAmount;
        }

        public BigDecimal getVeQuantity() {
            return this.veQuantity;
        }

        public void setVeQuantity(BigDecimal veQuantity) {
            this.veQuantity = veQuantity;
        }

        public BigDecimal getVeStdQantity() {
            return this.veStdQantity;
        }

        public void setVeStdQantity(BigDecimal veStdQantity) {
            this.veStdQantity = veStdQantity;
        }

        public int getAssistSeq() {
            return this.assistSeq;
        }

        public void setAssistSeq(int assistSeq) {
            this.assistSeq = assistSeq;
        }

        public BigDecimal getAssistOrigAmount() {
            return this.assistOrigAmount;
        }

        public void setAssistOrigAmount(BigDecimal assistOrigAmount) {
            this.assistOrigAmount = assistOrigAmount;
        }

        public BigDecimal getAssistLocalAmount() {
            return this.assistLocalAmount;
        }

        public void setAssistLocalAmount(BigDecimal assistLocalAmount) {
            this.assistLocalAmount = assistLocalAmount;
        }

        public BigDecimal getAssistReportingAmount() {
            return this.assistReportingAmount;
        }

        public void setAssistReportingAmount(BigDecimal assistReportingAmount) {
            this.assistReportingAmount = assistReportingAmount;
        }

        public BigDecimal getAssistQuantity() {
            return this.assistQuantity;
        }

        public void setAssistQuantity(BigDecimal assistQuantity) {
            this.assistQuantity = assistQuantity;
        }

        public BigDecimal getAssistStdQantity() {
            return this.assistStdQantity;
        }

        public void setAssistStdQantity(BigDecimal assistStdQantity) {
            this.assistStdQantity = assistStdQantity;
        }
    }
}

