/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class VoucherExportService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WSVoucherControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.VoucherImport";
    public static final String COL_CompanyNumber = "companyNumber";
    public static final String COL_CompanyName = "companyName";
    public static final String COL_VoucherNumber = "voucherNumber";
    public static final String COL_VoucherId = "voucherId";
    public static final String COL_PeriodYear = "periodYear";
    public static final String COL_PeriodNumber = "periodNumber";
    public static final String COL_BookedDate = "bookedDate";
    public static final String COL_BizDate = "bizDate";
    public static final String COL_VoucherType = "voucherType";
    public static final String COL_BizStatus = "bizStatus";
    public static final String COL_Description = "description";
    public static final String COL_VoucherAbstract = "voucherAbstract";
    public static final String COL_Attaches = "attaches";
    public static final String COL_IsCheck = "isCheck";
    public static final String COL_Creator = "creator";
    public static final String COL_CreatorName = "creatorName";
    public static final String COL_Auditor = "auditor";
    public static final String COL_AuditorName = "auditorName";
    public static final String COL_Poster = "poster";
    public static final String COL_PosterName = "posterName";
    public static final String COL_Cashier = "cashier";
    public static final String COL_CashierName = "cashierName";
    public static final String COL_ImportKey = "importKey";
    public static final String COL_ExternalId = "externalId";
    public static final String COL_SourceSys = "sourceSys";
    public static final String COL_SourceType = "sourceType";
    public static final String COL_SourceBillId = "sourceBillId";
    public static final String COL_EntrySeq = "entrySeq";
    public static final String COL_ProfitCenterNumber = "profitCenterNumber";
    public static final String COL_AccountName = "accountName";
    public static final String COL_AccountLongName = "accountLongName";
    public static final String COL_AccountNumber = "accountNumber";
    public static final String COL_CurrencyNumber = "currencyNumber";
    public static final String COL_CurrencyName = "currencyName";
    public static final String COL_EntryDC = "entryDC";
    public static final String COL_Measurement = "measurement";
    public static final String COL_MeasurementName = "measurementName";
    public static final String COL_Cussent = "cussent";
    public static final String COL_CustomerNumber = "customerNumber";
    public static final String COL_LocalRate = "localRate";
    public static final String COL_OriginalAmount = "originalAmount";
    public static final String COL_DebitAmount = "debitAmount";
    public static final String COL_CreditAmount = "creditAmount";
    public static final String COL_Qty = "qty";
    public static final String COL_Price = "price";
    public static final String COL_AssGroupId = "assGroupId";
    public static final String COL_AsstSeq = "asstSeq";
    public static final String COL_AssistAbstract = "assistAbstract";
    public static final String COL_AssistBizDate = "assistBizDate";
    public static final String COL_AssistEndDate = "assistEndDate";
    public static final String COL_SettlementType = "settlementType";
    public static final String COL_SettlementNumber = "settlementNumber";
    public static final String COL_BizNumber = "bizNumber";
    public static final String COL_TicketNumber = "ticketNumber";
    public static final String COL_InvoiceNumber = "invoiceNumber";
    public static final String COL_CPCustomerNumber = "cpCustomerNumber";
    public static final String COL_CPSupplierNumber = "cpSupplierNumber";
    public static final String COL_CPOrgUnitNumber = "cpOrgUnitNumber";
    public static final String COL_CPMaterialNumber = "cpMaterialNumber";
    public static final String COL_ItemFlag = "itemFlag";
    public static final String COL_OppAccountSeq = "oppAccountSeq";
    public static final String COL_OppAsstSeq = "oppAsstSeq";
    public static final String COL_PrimaryItem = "primaryItem";
    public static final String COL_PrimaryCoef = "primaryCoef";
    public static final String COL_SupplyItem = "supplyItem";
    public static final String COL_SupplyCoef = "supplyCoef";
    public static final String COL_FullInfoItem = "fullInfoItem";
    public static final String COL_Type = "type";
    public static final String COL_CashflowAmountOriginal = "cashflowAmountOriginal";
    public static final String COL_CashflowAmountLocal = "cashflowAmountLocal";
    public static final String COL_CashflowAmountRpt = "cashflowAmountRpt";
    private final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat DF2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DateFormat DF3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    protected Map params = null;
    private Map<String, UserInfo> users = new HashMap<String, UserInfo>();
    private Map<String, VoucherTypeInfo> voucherTypes = new HashMap<String, VoucherTypeInfo>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, List<AsstActTypeInfo>> asstActTypess = null;
    private Map<String, Object> hgs = null;
    private Map<String, String> hgIdToAsstAccountIds = null;
    private Map<String, Integer> colIndex = null;
    private List<List<String>> vouchers = null;
    private HashMap<String, Object> result;
    protected List<String> errs = new ArrayList<String>();
    private int colCount = 0;
    private String companyNumber = null;
    private String errMsseg = null;
    private boolean isExpCashflow;
    private boolean isExpImportKey = true;
    private boolean isExpExternalId = false;
    protected boolean isExpEntry = true;
    protected boolean isExpRecord = true;
    protected boolean isExpAccountCustomizedProperty = true;
    protected boolean isExpExtendProperty = true;
    private boolean isExpCompanyName = true;
    private boolean isExpVoucherId = true;
    private boolean isExpAccountName = true;
    private boolean isExpAccountLongName = false;
    private boolean isExpUserName = false;
    private boolean isExpCurrencyName = false;
    private boolean isExpMeasurementName = false;
    private boolean isExpAssGroupId = false;
    private boolean isExpAsstActId = false;
    private boolean isExpAsstActName = true;
    private List<String> vExtendColNames = new ArrayList<String>();
    private List<String> eExtendColNames = new ArrayList<String>();
    private List<String> rExtendColNames = new ArrayList<String>();
    private Map<String, String> extendColAliases = new HashMap<String, String>();
    private Map<String, DataType> extendDataTypes = new HashMap<String, DataType>();
    private Map<String, BOSObjectType> extendObjectTypes = new HashMap<String, BOSObjectType>();

    public void init(Context ctx, Map params) throws EASBizException, BOSException {
        this.params = params;
        this.result = new HashMap();
        this.result.put("errs", this.errs);
        this.colIndex = new HashMap<String, Integer>();
        this.vouchers = new LinkedList<List<String>>();
        Object param = params.get("isExpEntry");
        if (param != null) {
            this.isExpEntry = "true".equalsIgnoreCase(param.toString());
        }
        if ((param = params.get("isExpRecord")) != null) {
            this.isExpRecord = "true".equalsIgnoreCase(param.toString());
        }
        if (!this.isExpEntry) {
            this.isExpRecord = false;
        }
        this.isExpCashflow = "true".equals(params.get("isExpCashflow") == null ? "false" : params.get("isExpCashflow").toString());
        if (!this.isExpRecord) {
            this.isExpCashflow = false;
        }
        if ((param = params.get("isExpAccountCustomizedProperty")) != null) {
            this.isExpAccountCustomizedProperty = "true".equalsIgnoreCase(param.toString());
        }
        if ((param = params.get("isExpExtendProperty")) != null) {
            this.isExpExtendProperty = "true".equalsIgnoreCase(param.toString());
        }
        if (this.isExpExtendProperty) {
            BOSObjectType objectType;
            DataType dataType;
            OwnPropertyInfo op;
            String extendColName;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo info = loader.getEntity(new VoucherInfo().getBOSType());
            PropertyCollection props = info.getInheritedNoDuplicatedProperties();
            for (PropertyInfo prop : props) {
                if (!prop.isConfigured()) continue;
                extendColName = "v." + prop.getName();
                this.vExtendColNames.add(extendColName);
                this.extendColAliases.put(extendColName, prop.getAlias());
                if (prop instanceof OwnPropertyInfo) {
                    op = (OwnPropertyInfo)prop;
                    dataType = op.getDataType();
                    this.extendDataTypes.put(extendColName, dataType);
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                op = (LinkPropertyInfo)prop;
                objectType = op.getBOSType();
                this.extendObjectTypes.put(extendColName, objectType);
            }
            info = loader.getEntity(new VoucherEntryInfo().getBOSType());
            props = info.getInheritedNoDuplicatedProperties();
            for (PropertyInfo prop : props) {
                if (!prop.isConfigured()) continue;
                extendColName = "e." + prop.getName();
                this.eExtendColNames.add(extendColName);
                this.extendColAliases.put(extendColName, prop.getAlias());
                if (prop instanceof OwnPropertyInfo) {
                    op = (OwnPropertyInfo)prop;
                    dataType = op.getDataType();
                    this.extendDataTypes.put(extendColName, dataType);
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                op = (LinkPropertyInfo)prop;
                objectType = op.getBOSType();
                this.extendObjectTypes.put(extendColName, objectType);
            }
            info = loader.getEntity(new VoucherAssistRecordInfo().getBOSType());
            props = info.getInheritedNoDuplicatedProperties();
            for (PropertyInfo prop : props) {
                if (!prop.isConfigured()) continue;
                extendColName = "r." + prop.getName();
                this.rExtendColNames.add(extendColName);
                this.extendColAliases.put(extendColName, prop.getAlias());
                if (prop instanceof OwnPropertyInfo) {
                    op = (OwnPropertyInfo)prop;
                    dataType = op.getDataType();
                    this.extendDataTypes.put(extendColName, dataType);
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                op = (LinkPropertyInfo)prop;
                objectType = op.getBOSType();
                this.extendObjectTypes.put(extendColName, objectType);
            }
        }
        if ((param = params.get("isExpImportKey")) != null && "false".equalsIgnoreCase(param.toString().trim())) {
            this.isExpImportKey = false;
        }
        if ((param = params.get("isExpExternalId")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpExternalId = true;
        }
        if ((param = params.get("isExpCompanyName")) != null && "false".equalsIgnoreCase(param.toString().trim())) {
            this.isExpCompanyName = false;
        }
        if ((param = params.get("isExpVoucherId")) != null && "false".equalsIgnoreCase(param.toString().trim())) {
            this.isExpVoucherId = false;
        }
        if ((param = params.get("isExpAccountName")) != null && "false".equalsIgnoreCase(param.toString().trim())) {
            this.isExpAccountName = false;
        }
        if ((param = params.get("isExpAccountLongName")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpAccountLongName = true;
        }
        if ((param = params.get("isExpUserName")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpUserName = true;
        }
        if ((param = params.get("isExpCurrencyName")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpCurrencyName = true;
        }
        if ((param = params.get("isExpMeasurementName")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpMeasurementName = true;
        }
        if ((param = params.get("isExpAssGroupId")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpAssGroupId = true;
        }
        if ((param = params.get("isExpAsstActId")) != null && "true".equalsIgnoreCase(param.toString().trim())) {
            this.isExpAsstActId = true;
        }
        if ((param = params.get("isExpAsstActName")) != null && "false".equalsIgnoreCase(param.toString().trim())) {
            this.isExpAsstActName = false;
        }
        if (this.isExpRecord) {
            this.hgs = new HashMap<String, Object>();
            this.hgIdToAsstAccountIds = new HashMap<String, String>();
        }
    }

    public Map exportVoucher(Context ctx, Map params) throws EASBizException, BOSException {
        boolean isBatch;
        this.init(ctx, params);
        boolean isCheckBizPerm = true;
        boolean isInterfaceInvoke = (Boolean)params.get("isInterfaceInvoke");
        if (isInterfaceInvoke) {
            boolean r;
            boolean isCheckUsePerm = false;
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcUsePerm_Enable");
                if (p != null && Boolean.valueOf(p.toString()).booleanValue()) {
                    isCheckUsePerm = true;
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (isCheckUsePerm && !(r = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), null, "gl_ifc_voucherExport"))) {
                this.appendErr("user", ContextUtil.getCurrentUserInfo((Context)ctx).getNumber(), MessageFormat.format(this.getString(ctx, "NO_IfcExport_UsePerm"), ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()));
                return this.result;
            }
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcBizPerm_Enable");
                if (p != null && "false".equalsIgnoreCase(p.toString())) {
                    isCheckBizPerm = false;
                }
            }
            catch (Exception p) {
                // empty catch block
            }
        }
        Object param = this.getParam(params, COL_VoucherId);
        Set<String> voucherIds = this.getParamStrings(param);
        if (param != null && voucherIds.size() == 0) {
            this.appendErr(COL_VoucherId, param.toString(), this.getString(ctx, "VoucherID_Error"));
            return this.result;
        }
        param = this.getParam(params, COL_ImportKey);
        Set<String> importKeys = this.getParamStrings(param);
        param = this.getParam(params, COL_CompanyNumber);
        Set<String> companyNumbers = this.getParamStrings(param);
        if (param != null && companyNumbers.size() == 0) {
            this.appendErr(COL_CompanyNumber, param.toString(), this.getString(ctx, "CompanyNumber_Error"));
            return this.result;
        }
        if (voucherIds.size() == 0 && companyNumbers.size() == 0) {
            this.appendErr(COL_CompanyNumber, "", this.getString(ctx, "MUST_COMPANY_NUMBER"));
            return this.result;
        }
        HashMap<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
        if (companyNumbers.size() > 0) {
            CompanyOrgUnitCollection coll = this.getCompanys(ctx, companyNumbers);
            for (Object company : coll) {
                companys.put(company.getNumber(), (CompanyOrgUnitInfo)company);
            }
            ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>(companys.size());
            for (String companyNumber : companyNumbers) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(companyNumber);
                if (company == null) {
                    this.appendErr(COL_CompanyNumber, companyNumber, this.getString(ctx, "NOT_FOUND_COMPANY"));
                    return this.result;
                }
                if (!company.isIsBizUnit()) {
                    this.appendErr(COL_CompanyNumber, companyNumber, this.getString(ctx, "NOT_BIZ_COMPANY"));
                    return this.result;
                }
                list.add(company);
            }
            if (isCheckBizPerm && !this.checkInterfacePermission(ctx, list)) {
                return this.result;
            }
        } else if (isCheckBizPerm) {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> sqlParams = new ArrayList<String>();
            sqlParams.addAll(voucherIds);
            sql.append("select distinct v.FCompanyID, c.FNumber FCompanyNumber \n");
            sql.append("from T_GL_Voucher v \n");
            sql.append("join T_ORG_Company c on c.FID = v.FCompanyID \n");
            sql.append("where v.FID in " + VoucherExportService.toInSql(voucherIds.size()));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
            ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
            try {
                while (rs.next()) {
                    CompanyOrgUnitInfo c = new CompanyOrgUnitInfo();
                    c.setId(BOSUuid.read((String)rs.getString("FCompanyID")));
                    c.setNumber(rs.getString("FCompanyNumber"));
                    list.add(c);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (list.size() > 0 && !this.checkInterfacePermission(ctx, list)) {
                return this.result;
            }
        }
        boolean bl = isBatch = "true".equals(params.get("batch")) && companyNumbers.size() == 1 && voucherIds.size() > 0;
        if (isBatch) {
            ArrayList<String> batch = new ArrayList<String>();
            batch.addAll(voucherIds);
            return this.exportVoucher(ctx, params, (CompanyOrgUnitInfo)companys.values().iterator().next(), batch);
        }
        param = this.getParam(params, COL_VoucherType);
        Set<String> voucherTypeNumbers = this.getParamStrings(param);
        param = this.getParam(params, COL_VoucherNumber);
        Set<String> voucherNumbers = this.getParamStrings(param);
        param = this.getParam(params, "excludeVoucherNumber");
        Set<String> excludeVoucherNumbers = this.getParamStrings(param);
        Object fromVoucherNumber = this.getParam(params, "fromVoucherNumber");
        Object toVoucherNumber = this.getParam(params, "toVoucherNumber");
        int fromPeriodNumber = -1;
        int toPeriodNumber = -1;
        param = this.getParam(params, "fromPeriodNumber");
        if (param != null) {
            if (param instanceof Integer) {
                fromPeriodNumber = (Integer)param;
            } else if (param instanceof String) {
                try {
                    fromPeriodNumber = Integer.parseInt(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fromPeriodNumber < 190000 || fromPeriodNumber > 999913) {
                this.appendErr("fromPeriodNumber", param.toString(), this.getString(ctx, "Period_Error"));
                return this.result;
            }
        }
        if ((param = this.getParam(params, "toPeriodNumber")) != null) {
            if (param instanceof Integer) {
                fromPeriodNumber = (Integer)param;
            } else if (param instanceof String) {
                try {
                    toPeriodNumber = Integer.parseInt(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (toPeriodNumber < 190000 || toPeriodNumber > 999913 || toPeriodNumber < fromPeriodNumber) {
                this.appendErr("toPeriodNumber", param.toString(), this.getString(ctx, "Period_Error"));
                return this.result;
            }
        }
        SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
        Date fromBookedDate = null;
        param = this.getParam(params, "fromBookedDate");
        if (param != null) {
            if (param instanceof Date) {
                fromBookedDate = (Date)param;
            } else if (param instanceof String) {
                try {
                    fromBookedDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fromBookedDate == null) {
                this.appendErr("fromBookedDate", param.toString(), this.getString(ctx, "Date10_Error"));
                return null;
            }
        }
        Date toBookedDate = null;
        param = this.getParam(params, "toBookedDate");
        if (param != null) {
            if (param instanceof Date) {
                toBookedDate = (Date)param;
            } else if (param instanceof String) {
                try {
                    toBookedDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (toBookedDate == null) {
                this.appendErr("toBookedDate", param.toString(), this.getString(ctx, "Date10_Error"));
                return null;
            }
        }
        Date fromBizDate = null;
        param = this.getParam(params, "fromBizDate");
        if (param != null) {
            if (param instanceof Date) {
                fromBizDate = (Date)param;
            } else if (param instanceof String) {
                try {
                    fromBizDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fromBizDate == null) {
                this.appendErr("fromBizDate", param.toString(), this.getString(ctx, "Date10_Error"));
                return null;
            }
        }
        Date toBizDate = null;
        param = this.getParam(params, "toBizDate");
        if (param != null) {
            if (param instanceof Date) {
                toBizDate = (Date)param;
            } else if (param instanceof String) {
                try {
                    toBizDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (toBizDate == null) {
                this.appendErr("toBizDate", param.toString(), this.getString(ctx, "Date10_Error"));
                return null;
            }
        }
        Set<Object> bizStatuses = new HashSet();
        param = this.getParam(params, COL_BizStatus);
        if (param != null && (bizStatuses = this.getParamIntegers(param)).size() == 0) {
            this.appendErr(COL_BizStatus, param.toString(), this.getString(ctx, "VoucherStatus_Error"));
            return this.result;
        }
        String isCheck = null;
        param = this.getParam(params, COL_IsCheck);
        if (param instanceof String) {
            if ("true".equals(param) || "1".equals(param)) {
                isCheck = "true";
            } else if ("false".equals(param) || "0".equals(param)) {
                isCheck = "false";
            }
        } else if (param instanceof Boolean) {
            isCheck = String.valueOf(param);
        }
        HashSet<String> creatorIds = new HashSet<String>();
        Set<String> creatorNumbers = this.getParamStrings(this.getParam(params, COL_Creator));
        if (creatorNumbers.size() > 0) {
            for (String number : creatorNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr(COL_Creator, number, this.getString(ctx, "NOT_FOUND_CREATOR"));
                    return this.result;
                }
                creatorIds.add(user.getId().toString());
            }
        }
        HashSet<String> auditorIds = new HashSet<String>();
        Set<String> auditorNumbers = this.getParamStrings(this.getParam(params, COL_Auditor));
        if (auditorNumbers.size() > 0) {
            for (String number : auditorNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr(COL_Auditor, number, this.getString(ctx, "NOT_FOUND_AUDITOR"));
                    return this.result;
                }
                auditorIds.add(user.getId().toString());
            }
        }
        HashSet<String> posterIds = new HashSet<String>();
        Set<String> posterNumbers = this.getParamStrings(this.getParam(params, COL_Poster));
        if (posterNumbers.size() > 0) {
            for (String number : posterNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr(COL_Poster, number, this.getString(ctx, "NOT_FOUND_POSTER"));
                    return this.result;
                }
                posterIds.add(user.getId().toString());
            }
        }
        HashSet<String> cashierIds = new HashSet<String>();
        Set<String> cashierNumbers = this.getParamStrings(this.getParam(params, COL_Cashier));
        if (cashierNumbers.size() > 0) {
            for (String number : cashierNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr(COL_Cashier, number, this.getString(ctx, "NOT_FOUND_CASHIER"));
                    return this.result;
                }
                cashierIds.add(user.getId().toString());
            }
        }
        Object description = this.getParam(params, COL_Description);
        Object voucherAbstract = this.getParam(params, COL_VoucherAbstract);
        HashSet<Integer> sourceSyses = new HashSet<Integer>();
        param = this.getParam(params, COL_SourceSys);
        if (param != null) {
            Set<String> strs = this.getParamStrings(param);
            for (String string : strs) {
                SystemEnum sys = this.getSourceSys(ctx, string);
                if (sys == null) continue;
                sourceSyses.add(sys.getValue());
            }
            if (sourceSyses.size() == 0) {
                this.appendErr(COL_SourceSys, param.toString(), this.getString(ctx, "SOURCE_SYS_ERROR"));
                return this.result;
            }
        }
        HashSet<Integer> sourceTypes = new HashSet<Integer>();
        param = this.getParam(params, COL_SourceType);
        if (param != null) {
            Set<String> strs = this.getParamStrings(param);
            for (String str : strs) {
                SourceType type = this.getSourceType(ctx, str);
                if (type == null) continue;
                sourceTypes.add(type.getValue());
            }
            if (sourceTypes.size() == 0) {
                this.appendErr(COL_SourceType, param.toString(), this.getString(ctx, "SOURCE_TYPE_ERROR"));
                return this.result;
            }
        }
        Set<Object> categories = new HashSet();
        param = this.getParam(params, "category");
        if (param != null && (categories = this.getParamIntegers(param)).contains(1) && categories.contains(2) && categories.contains(3)) {
            categories.clear();
        }
        Object object = this.getParam(params, "entryDescription");
        param = this.getParam(params, "currency");
        Set<String> currencys = this.getParamStrings(param);
        param = this.getParam(params, COL_AccountNumber);
        Set<String> accountNumbers = this.getParamStrings(param);
        Object fromAccountNumber = this.getParam(params, "fromAccountNumber");
        Object toAccountNumber = this.getParam(params, "toAccountNumber");
        param = this.getParam(params, "entryAmount");
        BigDecimal entryAmount = null;
        if (param != null && param.toString().trim().length() > 0) {
            try {
                entryAmount = new BigDecimal(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        param = this.getParam(params, "entryMinAmount");
        BigDecimal entryMinAmount = null;
        if (param != null && param.toString().trim().length() > 0) {
            try {
                entryMinAmount = new BigDecimal(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        param = this.getParam(params, "entryMaxAmount");
        BigDecimal entryMaxAmount = null;
        if (param != null && param.toString().trim().length() > 0) {
            try {
                entryMaxAmount = new BigDecimal(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean isColumnAlias = "true".equals(params.get("isColumnAlias") == null ? "false" : params.get("isColumnAlias").toString());
        this.buildTableHead(ctx, isColumnAlias, this.isExpCashflow);
        ArrayList<String> allVoucherIds = new ArrayList<String>();
        int voucherCount = 0;
        if (companyNumbers.size() == 0) {
            companyNumbers.add("noCompany");
        }
        for (String companyNumber : companyNumbers) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(companyNumber);
            StringBuffer sql = new StringBuffer();
            String selectFrom = null;
            ArrayList<Object> sqlParams = new ArrayList<Object>();
            sql.append("select \n");
            sql.append("    distinct v.FID, v.FNumber \n");
            sql.append("from T_GL_Voucher v \n");
            if (importKeys.size() > 0) {
                sql.append("join T_GL_VoucherImportKey k on k.FVoucherID = v.FID \n");
            }
            if (voucherTypeNumbers.size() > 0) {
                sql.append("join T_BD_VoucherTypes t on t.FID = v.FVoucherTypeID \n");
            }
            if (fromPeriodNumber > 0 || toPeriodNumber > 0) {
                sql.append("join T_BD_Period p on p.FID = v.FPeriodID \n");
            }
            if (object != null && object.toString().trim().length() > 0 || currencys.size() > 0 || accountNumbers.size() > 0 || fromAccountNumber != null && fromAccountNumber.toString().trim().length() > 0 || toAccountNumber != null && toAccountNumber.toString().trim().length() > 0 || entryAmount != null || entryMinAmount != null || entryMaxAmount != null) {
                sql.append("join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
                if (currencys.size() > 0) {
                    sql.append("join T_BD_Currency cy on cy.FID = ve.FCurrencyID \n");
                }
                if (accountNumbers.size() > 0 || fromAccountNumber != null && fromAccountNumber.toString().trim().length() > 0 || toAccountNumber != null && toAccountNumber.toString().trim().length() > 0) {
                    sql.append("join T_BD_AccountView av on av.FID = ve.FAccountID \n");
                }
                selectFrom = sql.toString();
            } else {
                selectFrom = sql.toString().replace("distinct", "");
            }
            sql.setLength(0);
            if (voucherIds.size() == 1) {
                sql.append("and v.FID = ? \n");
                sqlParams.add(voucherIds.iterator().next());
            } else if (voucherIds.size() > 1) {
                sql.append("and v.FID in " + VoucherExportService.toInSql(voucherIds.size()) + " \n");
                sqlParams.addAll(voucherIds);
            }
            if (importKeys.size() == 1) {
                sql.append("and k.FImportKey = ? \n");
                sqlParams.add(importKeys.iterator().next());
            } else if (importKeys.size() > 1) {
                sql.append("and k.FImportKey in " + VoucherExportService.toInSql(importKeys.size()) + " \n");
                sqlParams.addAll(importKeys);
            }
            if (company != null) {
                sql.append("and v.FCompanyID = ? \n");
                sqlParams.add(company.getId().toString());
            }
            if (voucherNumbers.size() == 1) {
                sql.append("and v.FNumber = ? \n");
                sqlParams.add(voucherNumbers.iterator().next());
            } else if (voucherNumbers.size() > 1) {
                sql.append("and v.FNumber in " + VoucherExportService.toInSql(voucherNumbers.size()) + " \n");
                sqlParams.addAll(voucherNumbers);
            }
            if (excludeVoucherNumbers.size() == 1) {
                sql.append("and v.FNumber <> ? \n");
                sqlParams.add(excludeVoucherNumbers.iterator().next());
            } else if (excludeVoucherNumbers.size() > 1) {
                sql.append("and v.FNumber not in " + VoucherExportService.toInSql(excludeVoucherNumbers.size()) + " \n");
                sqlParams.addAll(excludeVoucherNumbers);
            }
            if (fromVoucherNumber != null && fromVoucherNumber.toString().trim().length() > 0) {
                sql.append("and v.FNumber >= ? \n");
                sqlParams.add(fromVoucherNumber.toString().trim());
            }
            if (toVoucherNumber != null && toVoucherNumber.toString().trim().length() > 0) {
                sql.append("and v.FNumber <= ? \n");
                sqlParams.add(toVoucherNumber.toString().trim());
            }
            if (voucherTypeNumbers.size() == 1) {
                sql.append("and t.FNumber = ? \n");
                sqlParams.add(voucherTypeNumbers.iterator().next());
            } else if (voucherTypeNumbers.size() > 1) {
                sql.append("and t.FNumber in " + VoucherExportService.toInSql(voucherTypeNumbers.size()) + " \n");
                sqlParams.addAll(voucherTypeNumbers);
            }
            if (fromPeriodNumber > 0) {
                sql.append("and p.FNumber >= ? \n");
                sqlParams.add(fromPeriodNumber);
            }
            if (toPeriodNumber > 0) {
                sql.append("and p.FNumber <= ? \n");
                sqlParams.add(toPeriodNumber);
            }
            if (fromBookedDate != null) {
                sql.append("and v.FBookedDate >= ? \n");
                sqlParams.add(new java.sql.Date(fromBookedDate.getTime()));
            }
            if (toBookedDate != null) {
                sql.append("and v.FBookedDate <= ? \n");
                sqlParams.add(new java.sql.Date(toBookedDate.getTime()));
            }
            if (fromBizDate != null) {
                sql.append("and v.FBizDate >= ? \n");
                sqlParams.add(new java.sql.Date(fromBizDate.getTime()));
            }
            if (toBizDate != null) {
                sql.append("and v.FBizDate <= ? \n");
                sqlParams.add(new java.sql.Date(toBizDate.getTime()));
            }
            if (bizStatuses.size() == 1) {
                sql.append("and v.FBizStatus = ? \n");
                sqlParams.add(bizStatuses.iterator().next());
            } else if (bizStatuses.size() > 1) {
                sql.append("and v.FBizStatus in " + VoucherExportService.toInSql(bizStatuses.size()) + " \n");
                sqlParams.addAll(bizStatuses);
            }
            if (creatorIds.size() == 1) {
                sql.append("and v.FCreatorID = ? \n");
                sqlParams.add(creatorIds.iterator().next());
            } else if (creatorIds.size() > 1) {
                sql.append("and v.FCreatorID in " + VoucherExportService.toInSql(creatorIds.size()) + " \n");
                sqlParams.addAll(creatorIds);
            }
            if (auditorIds.size() == 1) {
                sql.append("and v.FAuditorID = ? \n");
                sqlParams.add(auditorIds.iterator().next());
            } else if (auditorIds.size() > 1) {
                sql.append("and v.FAuditorID in " + VoucherExportService.toInSql(auditorIds.size()) + " \n");
                sqlParams.addAll(auditorIds);
            }
            if (posterIds.size() == 1) {
                sql.append("and v.FPosterID = ? \n");
                sqlParams.add(posterIds.iterator().next());
            } else if (posterIds.size() > 1) {
                sql.append("and v.FPosterID in " + VoucherExportService.toInSql(posterIds.size()) + " \n");
                sqlParams.addAll(posterIds);
            }
            if (cashierIds.size() == 1) {
                sql.append("and v.FCashierID = ? \n");
                sqlParams.add(cashierIds.iterator().next());
            } else if (cashierIds.size() > 1) {
                sql.append("and v.FCashierID in " + VoucherExportService.toInSql(cashierIds.size()) + " \n");
                sqlParams.addAll(cashierIds);
            }
            if ("true".equals(isCheck)) {
                sql.append("and v.FIsCheck = 1 \n");
            } else if ("false".equals(isCheck)) {
                sql.append("and v.FIsCheck = 0 \n");
            }
            if (description != null && description.toString().trim().length() > 0) {
                sql.append("and v.FDescription like ? \n");
                sqlParams.add("%" + description.toString().trim() + "%");
            }
            if (voucherAbstract != null && voucherAbstract.toString().trim().length() > 0) {
                sql.append("and v.FAbstract like ? \n");
                sqlParams.add("%" + voucherAbstract.toString().trim() + "%");
            }
            if (sourceSyses.size() == 1) {
                sql.append("and v.FSourceSys = ? \n");
                sqlParams.add(sourceSyses.iterator().next());
            } else if (sourceSyses.size() > 1) {
                sql.append("and v.FSourceSys in " + VoucherExportService.toInSql(sourceSyses.size()) + " \n");
                sqlParams.addAll(sourceSyses);
            }
            if (sourceTypes.size() == 1) {
                sql.append("and v.FSourceType = ? \n");
                sqlParams.add(sourceTypes.iterator().next());
            } else if (sourceTypes.size() > 1) {
                sql.append("and v.FSourceType in " + VoucherExportService.toInSql(sourceTypes.size()) + " \n");
                sqlParams.addAll(sourceTypes);
            }
            if (categories.size() == 1) {
                sql.append("and v.FCategory = ? \n");
                sqlParams.add(categories.iterator().next());
            } else if (categories.size() > 1) {
                sql.append("and v.FCategory in " + VoucherExportService.toInSql(categories.size()) + " \n");
                sqlParams.addAll(categories);
            }
            if (object != null && object.toString().trim().length() > 0) {
                sql.append("and ve.FDescription like ? \n");
                sqlParams.add("%" + object.toString().trim() + "%");
            }
            if (currencys.size() == 1) {
                sql.append("and cy.FNumber = ? \n");
                sqlParams.add(currencys.iterator().next());
            } else if (currencys.size() > 1) {
                sql.append("and cy.FNumber in " + VoucherExportService.toInSql(currencys.size()) + " \n");
                sqlParams.addAll(currencys);
            }
            if (accountNumbers.size() == 1) {
                sql.append("and av.FNumber = ? \n");
                sqlParams.add(accountNumbers.iterator().next());
            } else if (accountNumbers.size() > 1) {
                sql.append("and av.FNumber in " + VoucherExportService.toInSql(accountNumbers.size()) + " \n");
                sqlParams.addAll(accountNumbers);
            }
            if (fromAccountNumber != null && fromAccountNumber.toString().trim().length() > 0) {
                sql.append("and av.FNumber >= ? \n");
                sqlParams.add(fromAccountNumber.toString().trim());
            }
            if (toAccountNumber != null && toAccountNumber.toString().trim().length() > 0) {
                sql.append("and av.FNumber <= ? \n");
                sqlParams.add(toAccountNumber.toString().trim());
            }
            if (entryAmount != null) {
                sql.append("and ve.FOriginalAmount = ? \n");
                sqlParams.add(entryAmount);
            }
            if (entryMinAmount != null) {
                sql.append("and ve.FOriginalAmount >= ? \n");
                sqlParams.add(entryMinAmount);
            }
            if (entryMaxAmount != null) {
                sql.append("and ve.FOriginalAmount <= ? \n");
                sqlParams.add(entryMaxAmount);
            }
            sql.append("order by v.FNumber \n");
            ArrayList<String> pkList = new ArrayList<String>();
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(selectFrom + "where" + sql.toString().substring(3));
                for (int i = 0; i < sqlParams.size(); ++i) {
                    pstmt.setObject(i + 1, sqlParams.get(i));
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    pkList.add(rs.getString("FID"));
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            if ("true".equalsIgnoreCase((String)params.get("onlyVoucherId"))) {
                allVoucherIds.addAll(pkList);
                continue;
            }
            int size = pkList.size();
            for (int i = 0; i < size; i += 100) {
                VoucherCollection voucherCollection = this.getVoucherColByPkList(ctx, null, i, size, pkList);
                this.buildList(ctx, voucherCollection);
                voucherCount += voucherCollection.size();
            }
        }
        if (!this.result.containsKey("err")) {
            this.result.put("err", "");
        }
        if ("true".equalsIgnoreCase((String)params.get("onlyVoucherId"))) {
            this.result.put("rows", allVoucherIds);
            this.result.put("voucherCount", allVoucherIds.size());
        } else {
            this.result.put("rows", this.vouchers);
            this.result.put("voucherCount", voucherCount);
        }
        return this.result;
    }

    private Map exportVoucher(Context ctx, Map params, CompanyOrgUnitInfo company, List<String> pkList) throws EASBizException, BOSException {
        boolean isColumnAlias = "true".equals(params.get("isColumnAlias") == null ? "false" : params.get("isColumnAlias").toString());
        this.buildTableHead(ctx, isColumnAlias, this.isExpCashflow);
        int size = pkList.size();
        int voucherCount = 0;
        for (int i = 0; i < size; i += 100) {
            VoucherCollection voucherCollection = this.getVoucherColByPkList(ctx, company, i, size, pkList);
            this.buildList(ctx, voucherCollection);
            voucherCount += voucherCollection.size();
        }
        if (!this.result.containsKey("err")) {
            this.result.put("err", "");
        }
        this.result.put("rows", this.vouchers);
        this.result.put("voucherCount", voucherCount);
        return this.result;
    }

    protected boolean checkInterfacePermission(Context ctx, List<CompanyOrgUnitInfo> companys) throws EASBizException, BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        ArrayList<ObjectUuidPK> orgPKs = new ArrayList<ObjectUuidPK>();
        for (CompanyOrgUnitInfo company : companys) {
            orgPKs.add(new ObjectUuidPK(company.getId()));
        }
        String permItemName = "gl_voucher_newExport";
        Set set = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(user.getId()), orgPKs.toArray(new IObjectPK[orgPKs.size()]), permItemName);
        if (set != null) {
            for (CompanyOrgUnitInfo company : companys) {
                if (set.contains(company.getId().toString())) continue;
                this.appendErr(COL_CompanyNumber, company.getNumber(), this.getString(ctx, "NO_NEWEXPORT_PERM"));
                return false;
            }
        }
        return true;
    }

    private void buildList(Context ctx, VoucherCollection voucherCollection) throws EASBizException, BOSException {
        if (voucherCollection == null || voucherCollection.size() == 0) {
            return;
        }
        Map<String, String> importKeys = null;
        Map<String, String> externalIds = null;
        if (this.isExpImportKey || this.isExpExternalId) {
            HashSet<String> voucherIds = new HashSet<String>();
            Iterator vit = voucherCollection.iterator();
            while (vit.hasNext()) {
                voucherIds.add(((VoucherInfo)vit.next()).getId().toString());
            }
            if (this.isExpImportKey) {
                importKeys = this.cacheImportKeys(ctx, voucherIds);
            }
            if (this.isExpExternalId) {
                externalIds = this.cacheExternalIds(ctx, voucherIds);
            }
        }
        if (this.isExpRecord) {
            HashSet<String> hgIds = new HashSet<String>();
            for (VoucherInfo voucher : voucherCollection) {
                if (voucher.getEntries() == null || voucher.getEntries().size() <= 0) continue;
                for (VoucherEntryInfo entry : voucher.getEntries()) {
                    if (entry.getAssistRecords() != null && entry.getAssistRecords().size() > 0) {
                        for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                            if (record.getAssGrp() == null) continue;
                            hgIds.add(record.getAssGrp().getId().toString());
                        }
                    }
                    if (!this.isExpCashflow || entry.getCashflowRecords() == null || entry.getCashflowRecords().size() <= 0) continue;
                    for (VoucherAssistRecordInfo record : entry.getCashflowRecords()) {
                        if (record.getAssGrp() == null) continue;
                        hgIds.add(record.getAssGrp().getId().toString());
                    }
                }
            }
            this.cacheHgs(ctx, this.groupHgIds(ctx, hgIds));
        }
        for (int i = 0; i < voucherCollection.size(); ++i) {
            VoucherInfo tmpVoucher = voucherCollection.get(i);
            if (this.isExpImportKey) {
                tmpVoucher.put(COL_ImportKey, (Object)importKeys.get(tmpVoucher.getId().toString()));
            }
            if (this.isExpExternalId) {
                tmpVoucher.put(COL_ExternalId, (Object)externalIds.get(tmpVoucher.getId().toString()));
            }
            String[] headRow = new String[this.colCount];
            int index1 = this.fillVoucherHeadCol(headRow, tmpVoucher);
            if (!this.isExpEntry) {
                this.vouchers.add(Arrays.asList(headRow));
                continue;
            }
            ArrayList<List<String>> cfrs = new ArrayList<List<String>>();
            for (int j = 0; j < tmpVoucher.getEntries().size(); ++j) {
                CashflowRecordCollection cashFlowRecordCollection;
                VoucherEntryInfo entryInfo = tmpVoucher.getEntries().get(j);
                String[] entryRow = new String[this.colCount];
                System.arraycopy(headRow, 0, entryRow, 0, index1);
                int index2 = this.fillVoucherEntryCol(entryRow, entryInfo, index1);
                if (this.isExpRecord && entryInfo.getAssistRecords() != null && entryInfo.getAssistRecords().size() > 0) {
                    for (int k = 0; k < entryInfo.getAssistRecords().size(); ++k) {
                        VoucherAssistRecordInfo recordInfo = entryInfo.getAssistRecords().get(k);
                        String[] assistRecordRow = new String[this.colCount];
                        System.arraycopy(entryRow, 0, assistRecordRow, 0, index2);
                        this.fillVoucherAssistRecordCol(assistRecordRow, entryInfo, recordInfo);
                        this.vouchers.add(Arrays.asList(assistRecordRow));
                    }
                } else {
                    this.vouchers.add(Arrays.asList(entryRow));
                }
                if (!this.isExpCashflow || (cashFlowRecordCollection = entryInfo.getCashflowRecords()) == null || cashFlowRecordCollection.size() <= 0) continue;
                String[] baseCashFlowRecordRow = new String[this.colCount];
                this.fillCFRecordBaseCol(baseCashFlowRecordRow, entryInfo, tmpVoucher);
                for (int l = 0; l < cashFlowRecordCollection.size(); ++l) {
                    CashflowRecordInfo cashFlowRecordInfo = cashFlowRecordCollection.get(l);
                    String[] cashFlowRecordRow = new String[this.colCount];
                    System.arraycopy(baseCashFlowRecordRow, 0, cashFlowRecordRow, 0, this.colCount);
                    this.fillCFRecordCol(cashFlowRecordRow, tmpVoucher, entryInfo, cashFlowRecordInfo);
                    cfrs.add(Arrays.asList(cashFlowRecordRow));
                }
            }
            if (cfrs.size() <= 0) continue;
            this.vouchers.addAll(cfrs);
        }
    }

    private static String toInSql(int count) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        return "(" + sql.toString() + ")";
    }

    private void fillCFRecordBaseCol(String[] baseCashFlowRecordRow, VoucherEntryInfo entryInfo, VoucherInfo tmpVoucher) {
        String voucherNumber;
        String comNumber;
        baseCashFlowRecordRow[this.colIndex.get((Object)COL_CompanyNumber).intValue()] = comNumber = tmpVoucher.getCompany().getNumber();
        baseCashFlowRecordRow[this.colIndex.get((Object)COL_VoucherNumber).intValue()] = voucherNumber = tmpVoucher.getNumber();
        if (this.isExpVoucherId) {
            String voucherId;
            baseCashFlowRecordRow[this.colIndex.get((Object)COL_VoucherId).intValue()] = voucherId = tmpVoucher.getId().toString();
        }
        if (this.isExpImportKey) {
            String importKey = (String)tmpVoucher.get(COL_ImportKey);
            if (importKey == null) {
                importKey = "";
            }
            baseCashFlowRecordRow[this.colIndex.get((Object)COL_ImportKey).intValue()] = importKey;
        }
        if (this.isExpExternalId) {
            String externalId = (String)tmpVoucher.get(COL_ExternalId);
            if (externalId == null) {
                externalId = "";
            }
            baseCashFlowRecordRow[this.colIndex.get((Object)COL_ExternalId).intValue()] = externalId;
        }
        if (tmpVoucher.getPeriod() != null) {
            String periodNumber;
            String periodYear;
            baseCashFlowRecordRow[this.colIndex.get((Object)COL_PeriodYear).intValue()] = periodYear = String.valueOf(tmpVoucher.getPeriod().getPeriodYear());
            baseCashFlowRecordRow[this.colIndex.get((Object)COL_PeriodNumber).intValue()] = periodNumber = String.valueOf(tmpVoucher.getPeriod().getPeriodNumber());
        }
        baseCashFlowRecordRow[this.colIndex.get((Object)COL_VoucherType).intValue()] = tmpVoucher.getVoucherType().getName();
        baseCashFlowRecordRow[this.colIndex.get((Object)COL_BizStatus).intValue()] = this.getVoucherStatusAlias(tmpVoucher.getBizStatus());
        baseCashFlowRecordRow[this.colIndex.get((Object)COL_Creator).intValue()] = tmpVoucher.getCreator().getNumber();
        baseCashFlowRecordRow[this.colIndex.get((Object)COL_EntrySeq).intValue()] = String.valueOf(entryInfo.getSeq());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillCFRecordCol(String[] cashFlowRecordRow, VoucherInfo tmpVoucher, VoucherEntryInfo entryInfo, CashflowRecordInfo cashFlowRecordInfo) throws EASBizException, BOSException {
        ItemFlag itemFlag = cashFlowRecordInfo.getItemFlag();
        if (itemFlag == null) {
            itemFlag = ItemFlag.PRIMARY;
        }
        String oppAccountSeq = String.valueOf(cashFlowRecordInfo.getOpposingAccountEntry().getSeq());
        String oppAsstSeq = "";
        if (cashFlowRecordInfo.getOppVoucherAssistRecord() != null) {
            oppAsstSeq = String.valueOf(cashFlowRecordInfo.getOppVoucherAssistRecord().getSeq());
        }
        CashFlowItemInfo primaryCashFlowItemInfo = cashFlowRecordInfo.getPrimaryItem();
        String primaryItem = null;
        if (primaryCashFlowItemInfo != null) {
            primaryItem = primaryCashFlowItemInfo.getNumber();
        }
        String primaryCoef = String.valueOf(cashFlowRecordInfo.getPrimaryCoefficient());
        CashFlowItemInfo subCashFlowItemInfo = cashFlowRecordInfo.getSupplementaryItem();
        String supplyItem = null;
        if (subCashFlowItemInfo != null) {
            supplyItem = subCashFlowItemInfo.getNumber();
        }
        String supplyCoef = String.valueOf(cashFlowRecordInfo.getSupplementaryCoefficient());
        String fullInfoItem = null;
        if (cashFlowRecordInfo.getFullInfoItem() != null) {
            fullInfoItem = cashFlowRecordInfo.getFullInfoItem().getNumber();
        }
        String cashflowAmountOriginal = cashFlowRecordInfo.getOriginalAmount().toString();
        String cashflowAmountLocal = cashFlowRecordInfo.getLocalAmount().toString();
        String cashflowAmountRpt = cashFlowRecordInfo.getReportingAmount().toString();
        cashFlowRecordRow[this.colIndex.get((Object)COL_ItemFlag).intValue()] = String.valueOf(itemFlag.getValue());
        cashFlowRecordRow[this.colIndex.get((Object)COL_OppAccountSeq).intValue()] = oppAccountSeq;
        cashFlowRecordRow[this.colIndex.get((Object)COL_OppAsstSeq).intValue()] = oppAsstSeq;
        cashFlowRecordRow[this.colIndex.get((Object)COL_PrimaryItem).intValue()] = primaryItem;
        cashFlowRecordRow[this.colIndex.get((Object)COL_PrimaryCoef).intValue()] = primaryCoef;
        cashFlowRecordRow[this.colIndex.get((Object)COL_SupplyItem).intValue()] = supplyItem;
        cashFlowRecordRow[this.colIndex.get((Object)COL_SupplyCoef).intValue()] = supplyCoef;
        cashFlowRecordRow[this.colIndex.get((Object)COL_FullInfoItem).intValue()] = fullInfoItem;
        cashFlowRecordRow[this.colIndex.get((Object)COL_Type).intValue()] = this.getCashflowTypeAlias(cashFlowRecordInfo.getType());
        cashFlowRecordRow[this.colIndex.get((Object)COL_CashflowAmountOriginal).intValue()] = cashflowAmountOriginal;
        cashFlowRecordRow[this.colIndex.get((Object)COL_CashflowAmountLocal).intValue()] = cashflowAmountLocal;
        cashFlowRecordRow[this.colIndex.get((Object)COL_CashflowAmountRpt).intValue()] = cashflowAmountRpt;
        if (cashFlowRecordInfo.getAssGrp() == null) return;
        String assGrpId = cashFlowRecordInfo.getAssGrp().getId().toString();
        if (this.isExpAssGroupId) {
            cashFlowRecordRow[this.colIndex.get((Object)COL_AssGroupId).intValue()] = assGrpId;
        }
        Map hg = (Map)this.hgs.get(assGrpId);
        List<AsstActTypeInfo> aats = this.getAsstActTypes(null, this.hgIdToAsstAccountIds.get(assGrpId));
        if (hg == null || aats == null) return;
        for (int k = 0; k < aats.size(); ++k) {
            String number;
            AsstActTypeInfo aat = aats.get(k);
            cashFlowRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActType").append((int)(k + 1)).toString()).intValue()] = aat.getNumber();
            if (this.isExpAsstActId) {
                cashFlowRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActId").append((int)(k + 1)).toString()).intValue()] = (String)hg.get(aat.getNumber() + ".id");
            }
            if (aat.isUseLongNumber()) {
                number = (String)hg.get(aat.getNumber() + ".longNumber");
                if (number != null) {
                    number = number.replace('!', '.');
                }
            } else {
                number = (String)hg.get(aat.getNumber() + ".number");
            }
            cashFlowRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActNumber").append((int)(k + 1)).toString()).intValue()] = number;
            if (!this.isExpAsstActName) continue;
            cashFlowRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActName").append((int)(k + 1)).toString()).intValue()] = (String)hg.get(aat.getNumber() + ".name");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fillVoucherAssistRecordCol(String[] assistRecordRow, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) throws EASBizException, BOSException {
        if (recordInfo.getOriginalAmount() != null) {
            assistRecordRow[this.colIndex.get((Object)"originalAmount").intValue()] = originalAmount = recordInfo.getOriginalAmount().toString();
        }
        assistRecordRow[this.colIndex.get((Object)"debitAmount").intValue()] = debitAmount = entryInfo.getEntryDC() == EntryDC.DEBIT ? String.valueOf(recordInfo.getLocalAmount()) : "";
        assistRecordRow[this.colIndex.get((Object)"creditAmount").intValue()] = creditAmount = entryInfo.getEntryDC() == EntryDC.CREDIT ? String.valueOf(recordInfo.getLocalAmount()) : "";
        assistRecordRow[this.colIndex.get((Object)"qty").intValue()] = recordInfo.getQuantity() != null && recordInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0 ? (qty = recordInfo.getQuantity().toString()) : "";
        assistRecordRow[this.colIndex.get((Object)"price").intValue()] = recordInfo.getPrice() != null && recordInfo.getPrice().compareTo(BigDecimal.ZERO) != 0 ? (price = recordInfo.getPrice().toString()) : "";
        if (recordInfo.getMeasureUnit() != null) {
            assistRecordRow[this.colIndex.get((Object)"measurement").intValue()] = measurement = recordInfo.getMeasureUnit().getNumber();
            if (this.isExpMeasurementName) {
                assistRecordRow[this.colIndex.get((Object)"measurementName").intValue()] = recordInfo.getMeasureUnit().getName();
            }
        }
        assistRecordRow[this.colIndex.get((Object)"asstSeq").intValue()] = asstSeq = String.valueOf(recordInfo.getSeq());
        assistRecordRow[this.colIndex.get((Object)"assistAbstract").intValue()] = assistAbstract = recordInfo.getDescription();
        assistRecordRow[this.colIndex.get((Object)"assistBizDate").intValue()] = assistBizDate = this.DF.format(recordInfo.getBizDate());
        if (recordInfo.getEndDate() != null) {
            assistRecordRow[this.colIndex.get((Object)"assistEndDate").intValue()] = this.DF.format(recordInfo.getEndDate());
        }
        if (this.isExpAccountCustomizedProperty) {
            if (recordInfo.getCustomer() != null) {
                assistRecordRow[this.colIndex.get((Object)"cpCustomerNumber").intValue()] = recordInfo.getCustomer().getNumber();
            }
            if (recordInfo.getSupplier() != null) {
                assistRecordRow[this.colIndex.get((Object)"cpSupplierNumber").intValue()] = recordInfo.getSupplier().getNumber();
            }
            if (recordInfo.getOrgUnit() != null) {
                assistRecordRow[this.colIndex.get((Object)"cpOrgUnitNumber").intValue()] = recordInfo.getOrgUnit().getNumber();
            }
            if (recordInfo.getMaterial() != null) {
                assistRecordRow[this.colIndex.get((Object)"cpMaterialNumber").intValue()] = recordInfo.getMaterial().getNumber();
            }
            if (recordInfo.getSettlementType() != null) {
                assistRecordRow[this.colIndex.get((Object)"settlementType").intValue()] = settlementType = recordInfo.getSettlementType().getNumber();
            }
            assistRecordRow[this.colIndex.get((Object)"settlementNumber").intValue()] = settlementNumber = recordInfo.getSettlementCode();
            assistRecordRow[this.colIndex.get((Object)"bizNumber").intValue()] = bizNumber = recordInfo.getBizNumber();
            assistRecordRow[this.colIndex.get((Object)"ticketNumber").intValue()] = recordInfo.getTicketNumber();
            assistRecordRow[this.colIndex.get((Object)"invoiceNumber").intValue()] = recordInfo.getInvoiceNumber();
        }
        if (recordInfo.getAssGrp() != null) {
            assGrpId = recordInfo.getAssGrp().getId().toString();
            if (this.isExpAssGroupId) {
                assistRecordRow[this.colIndex.get((Object)"assGroupId").intValue()] = assGrpId;
            }
            hg = (Map)this.hgs.get(assGrpId);
            aats = this.getAsstActTypes(null, this.hgIdToAsstAccountIds.get(assGrpId));
            ** if (hg == null || aats == null) goto lbl53
            for (k = 0; k < aats.size(); ++k) {
                aat = aats.get(k);
                assistRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActType").append((int)(k + 1)).toString()).intValue()] = aat.getNumber();
                if (this.isExpAsstActId) {
                    assistRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActId").append((int)(k + 1)).toString()).intValue()] = (String)hg.get(aat.getNumber() + ".id");
                }
                if (aat.isUseLongNumber()) {
                    number = (String)hg.get(aat.getNumber() + ".longNumber");
                    if (number != null) {
                        number = number.replace('!', '.');
                    }
                } else {
                    number = (String)hg.get(aat.getNumber() + ".number");
                }
                assistRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActNumber").append((int)(k + 1)).toString()).intValue()] = number;
                if (!this.isExpAsstActName) continue;
                assistRecordRow[this.colIndex.get((Object)new StringBuilder().append((String)"asstActName").append((int)(k + 1)).toString()).intValue()] = (String)hg.get(aat.getNumber() + ".name");
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl53:
        // 4 sources

        if (this.isExpExtendProperty) {
            for (String extendColName : this.rExtendColNames) {
                this.fillExtendProperty(null, null, entryInfo, recordInfo, assistRecordRow, extendColName);
            }
        }
    }

    private int fillVoucherEntryCol(String[] entryRow, VoucherEntryInfo entryInfo, int index) {
        String price;
        String qty;
        String creditAmount;
        String debitAmount;
        String entrySeq;
        String desc = entryInfo.getDescription();
        if (desc != null && desc.trim().length() > 0) {
            entryRow[this.colIndex.get((Object)COL_VoucherAbstract).intValue()] = desc.trim();
        }
        entryRow[this.colIndex.get((Object)COL_EntrySeq).intValue()] = entrySeq = String.valueOf(entryInfo.getSeq());
        ++index;
        if (entryInfo.getProfitCenter() != null) {
            String pcNumber;
            entryRow[this.colIndex.get((Object)COL_ProfitCenterNumber).intValue()] = pcNumber = entryInfo.getProfitCenter().getNumber();
        }
        ++index;
        if (this.isExpAccountName) {
            if (entryInfo.getAccount() != null) {
                String accountName;
                entryRow[this.colIndex.get((Object)COL_AccountName).intValue()] = accountName = entryInfo.getAccount().getName();
            }
            ++index;
        }
        if (this.isExpAccountLongName) {
            if (entryInfo.getAccount() != null) {
                entryRow[this.colIndex.get((Object)COL_AccountLongName).intValue()] = entryInfo.getAccount().getLongName();
            }
            ++index;
        }
        if (entryInfo.getAccount() != null) {
            String accountNumber;
            entryRow[this.colIndex.get((Object)COL_AccountNumber).intValue()] = accountNumber = entryInfo.getAccount().getNumber();
        }
        ++index;
        if (entryInfo.getCurrency() != null) {
            String currencyNumber;
            entryRow[this.colIndex.get((Object)COL_CurrencyNumber).intValue()] = currencyNumber = entryInfo.getCurrency().getNumber();
        }
        ++index;
        if (this.isExpCurrencyName) {
            if (entryInfo.getCurrency() != null) {
                entryRow[this.colIndex.get((Object)COL_CurrencyName).intValue()] = entryInfo.getCurrency().getName();
            }
            ++index;
        }
        entryRow[this.colIndex.get((Object)COL_EntryDC).intValue()] = this.getEntryDCAlias(entryInfo.getEntryDC());
        ++index;
        if (entryInfo.getMeasureUnit() != null) {
            String measurement;
            entryRow[this.colIndex.get((Object)COL_Measurement).intValue()] = measurement = entryInfo.getMeasureUnit().getNumber();
        }
        ++index;
        if (this.isExpMeasurementName) {
            if (entryInfo.getMeasureUnit() != null) {
                entryRow[this.colIndex.get((Object)COL_MeasurementName).intValue()] = entryInfo.getMeasureUnit().getName();
            }
            ++index;
        }
        if (entryInfo.getCussent() != null) {
            String cussent;
            entryRow[this.colIndex.get((Object)COL_Cussent).intValue()] = cussent = entryInfo.getCussent().getValue();
        }
        ++index;
        if (entryInfo.getCustomer() != null) {
            String customerNumber;
            entryRow[this.colIndex.get((Object)COL_CustomerNumber).intValue()] = customerNumber = entryInfo.getCustomer().getNumber();
        }
        ++index;
        if (entryInfo.getLocalExchangeRate() != null) {
            String localRate;
            entryRow[this.colIndex.get((Object)COL_LocalRate).intValue()] = localRate = entryInfo.getLocalExchangeRate().toString();
        }
        ++index;
        if (entryInfo.getOriginalAmount() != null) {
            String originalAmount;
            entryRow[this.colIndex.get((Object)COL_OriginalAmount).intValue()] = originalAmount = entryInfo.getOriginalAmount().toString();
        }
        ++index;
        entryRow[this.colIndex.get((Object)COL_DebitAmount).intValue()] = debitAmount = entryInfo.getEntryDC() == EntryDC.DEBIT ? String.valueOf(entryInfo.getLocalAmount()) : "";
        ++index;
        entryRow[this.colIndex.get((Object)COL_CreditAmount).intValue()] = creditAmount = entryInfo.getEntryDC() == EntryDC.CREDIT ? String.valueOf(entryInfo.getLocalAmount()) : "";
        ++index;
        entryRow[this.colIndex.get((Object)COL_Qty).intValue()] = entryInfo.getQuantity() != null && entryInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0 ? (qty = entryInfo.getQuantity().toString()) : "";
        ++index;
        entryRow[this.colIndex.get((Object)COL_Price).intValue()] = entryInfo.getPrice() != null && entryInfo.getPrice().compareTo(BigDecimal.ZERO) != 0 ? (price = entryInfo.getPrice().toString()) : "";
        ++index;
        if (this.isExpExtendProperty) {
            for (String extendColName : this.eExtendColNames) {
                this.fillExtendProperty(null, null, entryInfo, null, entryRow, extendColName);
                ++index;
            }
        }
        return index;
    }

    private int fillVoucherHeadCol(String[] headRow, VoucherInfo tmpVoucher) {
        String isCheck;
        String attaches;
        String voucherAbstract;
        String description;
        String voucherTypeNumber;
        String bizDate;
        String bookedDate;
        String voucherNumber;
        String comNumber;
        int index = 0;
        headRow[this.colIndex.get((Object)COL_CompanyNumber).intValue()] = comNumber = tmpVoucher.getCompany().getNumber();
        ++index;
        if (this.isExpCompanyName) {
            String comName;
            headRow[this.colIndex.get((Object)COL_CompanyName).intValue()] = comName = tmpVoucher.getCompany().getName();
            ++index;
        }
        headRow[this.colIndex.get((Object)COL_VoucherNumber).intValue()] = voucherNumber = tmpVoucher.getNumber();
        ++index;
        if (this.isExpVoucherId) {
            String voucherId = tmpVoucher.getId().toString();
            if (voucherId == null) {
                voucherId = "";
            }
            headRow[this.colIndex.get((Object)COL_VoucherId).intValue()] = voucherId;
            ++index;
        }
        if (this.isExpImportKey) {
            String importKey = (String)tmpVoucher.get(COL_ImportKey);
            if (importKey == null) {
                importKey = "";
            }
            headRow[this.colIndex.get((Object)COL_ImportKey).intValue()] = importKey;
            ++index;
        }
        if (this.isExpExternalId) {
            String externalId = (String)tmpVoucher.get(COL_ExternalId);
            if (externalId == null) {
                externalId = "";
            }
            headRow[this.colIndex.get((Object)COL_ExternalId).intValue()] = externalId;
            ++index;
        }
        if (tmpVoucher.getPeriod() != null) {
            String periodNumber;
            String periodYear;
            headRow[this.colIndex.get((Object)COL_PeriodYear).intValue()] = periodYear = String.valueOf(tmpVoucher.getPeriod().getPeriodYear());
            headRow[this.colIndex.get((Object)COL_PeriodNumber).intValue()] = periodNumber = String.valueOf(tmpVoucher.getPeriod().getPeriodNumber());
        }
        ++index;
        ++index;
        headRow[this.colIndex.get((Object)COL_BookedDate).intValue()] = bookedDate = this.DF.format(tmpVoucher.getBookedDate());
        ++index;
        headRow[this.colIndex.get((Object)COL_BizDate).intValue()] = bizDate = this.DF.format(tmpVoucher.getBizDate());
        ++index;
        headRow[this.colIndex.get((Object)COL_VoucherType).intValue()] = voucherTypeNumber = tmpVoucher.getVoucherType().getName();
        ++index;
        headRow[this.colIndex.get((Object)COL_BizStatus).intValue()] = this.getVoucherStatusAlias(tmpVoucher.getBizStatus());
        ++index;
        headRow[this.colIndex.get((Object)COL_Description).intValue()] = description = tmpVoucher.getDescription();
        ++index;
        headRow[this.colIndex.get((Object)COL_VoucherAbstract).intValue()] = voucherAbstract = tmpVoucher.getVoucherAbstract();
        ++index;
        headRow[this.colIndex.get((Object)COL_Attaches).intValue()] = attaches = String.valueOf(tmpVoucher.getAttachments());
        ++index;
        headRow[this.colIndex.get((Object)COL_IsCheck).intValue()] = isCheck = String.valueOf(tmpVoucher.isIsCheck() ? 1 : 0);
        ++index;
        if (tmpVoucher.getCreator() != null) {
            String creatorNumber;
            headRow[this.colIndex.get((Object)COL_Creator).intValue()] = creatorNumber = tmpVoucher.getCreator().getNumber();
        }
        ++index;
        if (this.isExpUserName) {
            if (tmpVoucher.getCreator() != null) {
                headRow[this.colIndex.get((Object)COL_CreatorName).intValue()] = tmpVoucher.getCreator().getName();
            }
            ++index;
        }
        if (tmpVoucher.getAuditor() != null) {
            String auditorNumber;
            headRow[this.colIndex.get((Object)COL_Auditor).intValue()] = auditorNumber = tmpVoucher.getAuditor().getNumber();
        }
        ++index;
        if (this.isExpUserName) {
            if (tmpVoucher.getAuditor() != null) {
                headRow[this.colIndex.get((Object)COL_AuditorName).intValue()] = tmpVoucher.getAuditor().getName();
            }
            ++index;
        }
        if (tmpVoucher.getPoster() != null) {
            String posterNumber;
            headRow[this.colIndex.get((Object)COL_Poster).intValue()] = posterNumber = tmpVoucher.getPoster().getNumber();
        }
        ++index;
        if (this.isExpUserName) {
            if (tmpVoucher.getPoster() != null) {
                headRow[this.colIndex.get((Object)COL_PosterName).intValue()] = tmpVoucher.getPoster().getName();
            }
            ++index;
        }
        if (tmpVoucher.getCashier() != null) {
            String cashierNumber;
            headRow[this.colIndex.get((Object)COL_Cashier).intValue()] = cashierNumber = tmpVoucher.getCashier().getNumber();
        }
        ++index;
        if (this.isExpUserName) {
            if (tmpVoucher.getCashier() != null) {
                headRow[this.colIndex.get((Object)COL_CashierName).intValue()] = tmpVoucher.getCashier().getName();
            }
            ++index;
        }
        if (tmpVoucher.getSourceSys() != null) {
            headRow[this.colIndex.get((Object)COL_SourceSys).intValue()] = this.getSystemAlias(tmpVoucher.getSourceSys());
        }
        ++index;
        if (tmpVoucher.getSourceType() != null) {
            headRow[this.colIndex.get((Object)COL_SourceType).intValue()] = this.getSourceTypeAlias(tmpVoucher.getSourceType());
        }
        ++index;
        if (tmpVoucher.getSourceBillId() != null) {
            String sourceBillId;
            headRow[this.colIndex.get((Object)COL_SourceBillId).intValue()] = sourceBillId = tmpVoucher.getSourceBillId();
        }
        ++index;
        if (this.isExpExtendProperty) {
            for (String extendColName : this.vExtendColNames) {
                this.fillExtendProperty(null, tmpVoucher, null, null, headRow, extendColName);
                ++index;
            }
        }
        return index;
    }

    protected void fillExtendProperty(Context ctx, VoucherInfo voucher, VoucherEntryInfo entry, VoucherAssistRecordInfo record, String[] row, String extendColName) {
        VoucherInfo info = null;
        if (extendColName.startsWith("v.")) {
            info = voucher;
        } else if (extendColName.startsWith("e.")) {
            info = entry;
        } else if (extendColName.startsWith("r.")) {
            info = record;
        } else {
            return;
        }
        Object value = info.get(extendColName.substring(2));
        if (value instanceof IntEnum) {
            value = ((IntEnum)value).getValue();
        } else if (value instanceof StringEnum) {
            value = ((StringEnum)value).getValue();
        } else if (value instanceof java.sql.Date) {
            value = this.DF2.format(value);
        } else if (value instanceof Timestamp) {
            String str = this.DF3.format(value);
            if (str.endsWith(":000")) {
                str = str.substring(0, 19);
            }
            value = str;
        } else if (value instanceof CoreBaseInfo) {
            CoreBaseInfo link = (CoreBaseInfo)value;
            value = link.getId() != null ? link.getId().toString() : "";
        }
        row[this.colIndex.get((Object)extendColName).intValue()] = value == null ? "" : String.valueOf(value);
    }

    private VoucherCollection getVoucherColByPkList(Context ctx, CompanyOrgUnitInfo company, int i, int size, List<String> pkList) throws BOSException {
        CashflowRecordCollection cashflowCollection;
        int j = 0;
        HashSet<String> subIds = new HashSet<String>();
        while (100 - j++ > 0 && i < size) {
            subIds.add(pkList.get(i));
            ++i;
        }
        VoucherCollection voucherCollection = this.getVoucherCollection(ctx, company, subIds);
        if (this.isExpCashflow && (cashflowCollection = this.getCashflowCollection(ctx, subIds)).size() > 0) {
            this.mergeVoucherAndCashflow(voucherCollection, cashflowCollection);
        }
        return voucherCollection;
    }

    private CashflowRecordCollection getCashflowCollection(Context ctx, Set<String> ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", ids, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("voucher.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo(COL_OriginalAmount));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("reportingAmount"));
        sic.add(new SelectorItemInfo("primaryCoefficient"));
        sic.add(new SelectorItemInfo("supplementaryCoefficient"));
        sic.add(new SelectorItemInfo("voucher.number"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("opposingAccountEntry.seq"));
        sic.add(new SelectorItemInfo("oppVoucherAssistRecord.seq"));
        sic.add(new SelectorItemInfo("primaryItem.number"));
        sic.add(new SelectorItemInfo("supplementaryItem.number"));
        sic.add(new SelectorItemInfo("fullInfoItem.number"));
        sic.add(new SelectorItemInfo("assGrp.id"));
        sic.add(new SelectorItemInfo(COL_Type));
        sic.add(new SelectorItemInfo(COL_ItemFlag));
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo info = new SorterItemInfo("seq");
        info.setSortType(SortType.ASCEND);
        sorter.add(info);
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        return CashflowRecordFactory.getLocalInstance(ctx).getCashflowRecordCollection(view);
    }

    private void mergeVoucherAndCashflow(VoucherCollection voucherCollection, CashflowRecordCollection cashflowCollection) {
        for (CashflowRecordInfo cashflowRecord : cashflowCollection) {
            BOSUuid vchEntryId;
            BOSUuid vchId = cashflowRecord.getVoucher().getId();
            VoucherInfo voucher = (VoucherInfo)voucherCollection.getObject((Object)vchId);
            if (voucher == null) continue;
            cashflowRecord.setVoucher(voucher);
            VoucherEntryCollection entries = voucher.getEntries();
            VoucherEntryInfo entry = (VoucherEntryInfo)entries.getObject((Object)(vchEntryId = cashflowRecord.getEntry().getId()));
            if (entry == null) continue;
            cashflowRecord.setEntry(entry);
            entry.getCashflowRecords().add(cashflowRecord);
        }
    }

    private IObjectPK[] getVoucherPkList(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        sort.add(new SorterItemInfo("entries.seq"));
        IObjectPK[] pkList = voucher.getPKList(filter, sort);
        return pkList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private FilterInfo getFilterInfo(Context ctx, Map params) throws BOSException {
        int index;
        StringBuffer strMask;
        FilterInfo filter;
        block15: {
            boolean isIncludeSaved;
            boolean isIncludePost;
            block16: {
                filter = new FilterInfo();
                strMask = new StringBuffer();
                index = 0;
                this.companyNumber = (String)params.get("company");
                CompanyOrgUnitInfo companyInfo = null;
                if (StringUtils.isEmpty((CharSequence)this.companyNumber)) {
                    this.errMsseg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1051_VoucherExportService", (Locale)ctx.getLocale());
                    logger.error((Object)this.errMsseg);
                    this.result.put("err", this.errMsseg);
                    return null;
                }
                companyInfo = GlWebServiceUtil.getCompany(ctx, this.companyNumber);
                if (companyInfo == null) {
                    this.errMsseg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1050_VoucherExportService", (Locale)ctx.getLocale());
                    logger.error((Object)this.errMsseg);
                    this.result.put("err", this.errMsseg);
                    return null;
                }
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)this.companyNumber));
                strMask.append("#" + index + " ");
                ++index;
                String beginDate = (String)params.get("beginDate");
                String endDate = (String)params.get("endDate");
                if (!StringUtils.isEmpty((CharSequence)beginDate) && !StringUtils.isEmpty((CharSequence)endDate)) {
                    filter.getFilterItems().add(new FilterItemInfo(COL_BookedDate, (Object)beginDate, CompareType.GREATER_EQUALS));
                    strMask.append(" and #" + index + " ");
                    filter.getFilterItems().add(new FilterItemInfo(COL_BookedDate, (Object)endDate, CompareType.LESS_EQUALS));
                    strMask.append("  and #" + ++index + "  ");
                    ++index;
                }
                String numberBegin = (String)params.get("numberBegin");
                String numberEnd = (String)params.get("numberEnd");
                if (!StringUtils.isEmpty((CharSequence)numberBegin) && !StringUtils.isEmpty((CharSequence)numberEnd)) {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberBegin, CompareType.GREATER_EQUALS));
                    strMask.append("  and #" + index + "  ");
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberEnd, CompareType.LESS_EQUALS));
                    strMask.append("  and #" + ++index + "  ");
                    ++index;
                }
                if (!StringUtils.isEmpty((CharSequence)((String)params.get(COL_VoucherType)))) {
                    VoucherTypeInfo voucherType = GlWebServiceUtil.findVouherTypeByNumber(ctx, (String)params.get(COL_VoucherType), companyInfo.getCU().getId());
                    if (voucherType == null) {
                        this.errMsseg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1052_VoucherExportService", (Locale)ctx.getLocale());
                        logger.error((Object)this.errMsseg);
                        this.result.put("err", this.errMsseg);
                        return null;
                    }
                    filter.getFilterItems().add(new FilterItemInfo("voucherType.number", (Object)((String)params.get(COL_VoucherType)), CompareType.EQUALS));
                    strMask.append("  and #" + index + "  ");
                    ++index;
                }
                boolean isIncludeNoPost = "true".equals(params.get("isIncludeNoPost") == null ? "false" : params.get("isIncludeNoPost").toString());
                isIncludePost = "true".equals(params.get("isIncludePost") == null ? "false" : params.get("isIncludePost").toString());
                isIncludeSaved = "true".equals(params.get("isIncludeSaved") == null ? "false" : params.get("isIncludeSaved").toString());
                if (!isIncludeNoPost) break block16;
                if (isIncludeSaved) {
                    if (!isIncludePost) {
                        filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(VoucherStatusEnum.POSTED.getValue()), CompareType.NOTEQUALS));
                        strMask.append("  and #" + index + "  ");
                        ++index;
                    }
                    break block15;
                } else {
                    filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(0), CompareType.NOTEQUALS));
                    strMask.append("  and #" + index + "  ");
                    ++index;
                    if (!isIncludePost) {
                        filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(VoucherStatusEnum.POSTED.getValue()), CompareType.NOTEQUALS));
                        strMask.append("  and #" + index + "  ");
                        ++index;
                    }
                }
                break block15;
            }
            if (isIncludeSaved) {
                if (!isIncludePost) {
                    filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(0), CompareType.EQUALS));
                    strMask.append("  and #" + index + "  ");
                    ++index;
                } else {
                    filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(VoucherStatusEnum.AUDITTED.getValue()), CompareType.NOTEQUALS));
                    strMask.append("  and #" + index + "  ");
                    filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(VoucherStatusEnum.SUBMITTED.getValue()), CompareType.NOTEQUALS));
                    strMask.append("  and #" + ++index + "  ");
                    ++index;
                }
            } else if (isIncludePost) {
                filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(VoucherStatusEnum.POSTED.getValue()), CompareType.EQUALS));
                strMask.append("  and #" + index + "  ");
                ++index;
            }
        }
        filter.getFilterItems().add(new FilterItemInfo(COL_BizStatus, (Object)new Integer(2), CompareType.NOTEQUALS));
        strMask.append("  and #" + index + "  ");
        ++index;
        filter.setMaskString(strMask.toString());
        return filter;
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    protected Object getParam(Map params, String key) {
        Object param = params.get(key);
        if (param instanceof Collection) {
            if (((Collection)param).size() == 0) {
                param = null;
            }
        } else if (param instanceof String) {
            String str = ((String)param).trim();
            param = str.length() == 0 ? null : str;
        }
        return param;
    }

    protected Set<String> getParamStrings(Object param) {
        HashSet<String> result;
        block2: {
            String[] strs;
            block3: {
                result = new HashSet<String>();
                if (param == null) break block2;
                if (!(param instanceof Collection)) break block3;
                for (Object item : (Collection)param) {
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    result.add(item.toString().trim());
                }
                break block2;
            }
            if (!(param instanceof String)) break block2;
            for (String str : strs = ((String)param).trim().split(";")) {
                if (str.trim().length() <= 0) continue;
                result.add(str.trim());
            }
        }
        return result;
    }

    protected Set<Integer> getParamIntegers(Object param) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (param != null) {
            if (param instanceof Collection) {
                for (Object item : (Collection)param) {
                    if (item instanceof Integer) {
                        result.add((Integer)item);
                        continue;
                    }
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    try {
                        result.add(Integer.parseInt(item.toString().trim()));
                    }
                    catch (Exception exception) {}
                }
            } else if (param instanceof String) {
                String[] strs;
                for (String str : strs = ((String)param).trim().split(";")) {
                    if (str.trim().length() <= 0) continue;
                    try {
                        result.add(Integer.parseInt(str.trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else if (param instanceof Integer) {
                result.add((Integer)param);
            }
        }
        return result;
    }

    protected CompanyOrgUnitCollection getCompanys(Context ctx, Set<String> companyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isBizUnit");
        selector.add("cu.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", companyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (coll == null) {
            coll = new CompanyOrgUnitCollection();
        }
        return coll;
    }

    private VoucherTypeInfo getVoucherType(Context ctx, String number, String cuId) throws BOSException {
        String key = number + "_" + cuId;
        if (this.voucherTypes.containsKey(key)) {
            return this.voucherTypes.get(key);
        }
        VoucherTypeInfo voucherType = GlWebServiceUtil.findVouherTypeByNumber(ctx, number, BOSUuid.read((String)cuId));
        if (voucherType == null) {
            voucherType = GlWebServiceUtil.findVouherTypeByName(ctx, number, BOSUuid.read((String)cuId));
        }
        this.voucherTypes.put(key, voucherType);
        return voucherType;
    }

    protected SystemEnum getSourceSys(Context ctx, String key) {
        List list = SystemEnum.getEnumList();
        for (SystemEnum item : list) {
            if (!String.valueOf(item.getValue()).equals(key) && !item.getName().equals(key) && !item.getAlias().equals(key)) continue;
            return item;
        }
        return null;
    }

    protected SourceType getSourceType(Context ctx, String key) {
        List list = SourceType.getEnumList();
        for (SourceType item : list) {
            if (!String.valueOf(item.getValue()).equals(key) && !item.getName().equals(key) && !item.getAlias().equals(key)) continue;
            return item;
        }
        return null;
    }

    private UserInfo getUser(Context ctx, String number) throws BOSException {
        if (this.users.containsKey(number)) {
            return this.users.get(number);
        }
        UserInfo user = GlWebServiceUtil.findUserUByName(ctx, number);
        this.users.put(number, user);
        return user;
    }

    private List<AsstActTypeInfo> getAsstActTypes(Context ctx, String asstAccountId) throws BOSException {
        if (this.asstActTypess == null) {
            this.asstActTypess = new HashMap<String, List<AsstActTypeInfo>>();
        }
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        AsstActTypeCollection aats = VoucherProcessCache.getAsstActTypes(ctx, asstAccountId);
        ArrayList<AsstActTypeInfo> asstActTypes = new ArrayList<AsstActTypeInfo>(aats.size());
        for (AsstActTypeInfo aat : aats) {
            aat.put("showId", (Object)this.isExpAsstActId);
            if (aat.isUseLongNumber()) {
                aat.put("showNumber", (Object)false);
                aat.put("showLongNumber", (Object)true);
            }
            aat.put("showName", (Object)this.isExpAsstActName);
            asstActTypes.add(aat);
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    private Map<String, Set<String>> groupHgIds(Context ctx, Set<String> hgIds) throws BOSException {
        HashMap<String, Set<String>> hgIdss = new HashMap<String, Set<String>>();
        if (hgIds.size() <= 0) {
            return hgIdss;
        }
        String sql = "select FID, FAsstAccountID from T_BD_AssistantHG where FID in ";
        List<Set<String>> batchs = GlUtils.split(hgIds, 100);
        try {
            for (Set<String> batch : batchs) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + SQLUtil.buildMarkSQL(batch.size())), (Object[])batch.toArray());
                while (rs.next()) {
                    String asstAccountId = rs.getString("FAsstAccountID");
                    if (asstAccountId == null) continue;
                    HashSet<String> set = (HashSet<String>)hgIdss.get(asstAccountId);
                    if (set == null) {
                        set = new HashSet<String>();
                        hgIdss.put(asstAccountId, set);
                    }
                    String hgId = rs.getString("FID");
                    set.add(hgId);
                    this.hgIdToAsstAccountIds.put(hgId, asstAccountId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hgIdss;
    }

    private Map<String, String> cacheImportKeys(Context ctx, Set<String> voucherIds) throws BOSException {
        HashMap<String, String> importKeys = new HashMap<String, String>();
        if (voucherIds.size() <= 0) {
            return importKeys;
        }
        String sql = "select FVoucherID, FImportKey from T_GL_VoucherImportKey where FVoucherID in ";
        List<Set<String>> batchs = GlUtils.split(voucherIds, 100);
        try {
            for (Set<String> batch : batchs) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + SQLUtil.buildMarkSQL(batch.size())), (Object[])batch.toArray());
                while (rs.next()) {
                    String importKey = rs.getString("FImportKey");
                    if (importKey == null) continue;
                    importKeys.put(rs.getString("FVoucherID"), importKey);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return importKeys;
    }

    private Map<String, String> cacheExternalIds(Context ctx, Set<String> voucherIds) throws BOSException {
        HashMap<String, String> externalIds = new HashMap<String, String>();
        if (voucherIds.size() <= 0) {
            return externalIds;
        }
        String sql = "select FEASID, FEXTERNALID from T_GL_ComparisonDetail where FEASID in ";
        List<Set<String>> batchs = GlUtils.split(voucherIds, 100);
        try {
            for (Set<String> batch : batchs) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + SQLUtil.buildMarkSQL(batch.size())), (Object[])batch.toArray());
                while (rs.next()) {
                    String externalId = rs.getString("FEXTERNALID");
                    if (externalId == null) continue;
                    externalIds.put(rs.getString("FEASID"), externalId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return externalIds;
    }

    private void cacheHgs(Context ctx, Map<String, Set<String>> hgIdss) throws BOSException {
        for (String asstAccountId : hgIdss.keySet()) {
            Set<String> tempIds = hgIdss.get(asstAccountId);
            Set<Object> hgIds = new HashSet();
            if (this.hgs.size() == 0) {
                hgIds = tempIds;
            } else {
                for (String tempId : tempIds) {
                    if (this.hgs.containsKey(tempId)) continue;
                    hgIds.add(tempId);
                }
            }
            if (hgIds.size() <= 0) continue;
            try {
                Map<String, Object> map = GLAsstAccountUtils.getAssistantHgs(ctx, asstAccountId, this.getAsstActTypes(ctx, asstAccountId), hgIds);
                this.hgs.putAll(map);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void buildTableHead(Context ctx, boolean isColumnAlias, boolean isExpCashflow) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> columnAliases = new ArrayList<String>();
        int idx = 0;
        list.add(COL_CompanyNumber);
        columnAliases.add(this.getString(ctx, "COL_CompanyNumber"));
        this.colIndex.put(COL_CompanyNumber, idx++);
        if (this.isExpCompanyName) {
            list.add(COL_CompanyName);
            columnAliases.add(this.getString(ctx, "COL_CompanyName"));
            this.colIndex.put(COL_CompanyName, idx++);
        }
        list.add(COL_VoucherNumber);
        columnAliases.add(this.getString(ctx, "COL_VoucherNumber"));
        this.colIndex.put(COL_VoucherNumber, idx++);
        if (this.isExpVoucherId) {
            list.add(COL_VoucherId);
            columnAliases.add(this.getString(ctx, "COL_VoucherId"));
            this.colIndex.put(COL_VoucherId, idx++);
        }
        if (this.isExpImportKey) {
            list.add(COL_ImportKey);
            columnAliases.add(this.getString(ctx, "COL_ImportKey"));
            this.colIndex.put(COL_ImportKey, idx++);
        }
        if (this.isExpExternalId) {
            list.add(COL_ExternalId);
            columnAliases.add(this.getString(ctx, "COL_ExternalId"));
            this.colIndex.put(COL_ExternalId, idx++);
        }
        list.add(COL_PeriodYear);
        columnAliases.add(this.getString(ctx, "COL_PeriodYear"));
        this.colIndex.put(COL_PeriodYear, idx++);
        list.add(COL_PeriodNumber);
        columnAliases.add(this.getString(ctx, "COL_PeriodNumber"));
        this.colIndex.put(COL_PeriodNumber, idx++);
        list.add(COL_BookedDate);
        columnAliases.add(this.getString(ctx, "COL_BookedDate"));
        this.colIndex.put(COL_BookedDate, idx++);
        list.add(COL_BizDate);
        columnAliases.add(this.getString(ctx, "COL_BizDate"));
        this.colIndex.put(COL_BizDate, idx++);
        list.add(COL_VoucherType);
        columnAliases.add(this.getString(ctx, "COL_VoucherType"));
        this.colIndex.put(COL_VoucherType, idx++);
        list.add(COL_BizStatus);
        columnAliases.add(this.getString(ctx, "COL_BizStatus"));
        this.colIndex.put(COL_BizStatus, idx++);
        list.add(COL_Description);
        columnAliases.add(this.getString(ctx, "COL_Description"));
        this.colIndex.put(COL_Description, idx++);
        list.add(COL_VoucherAbstract);
        columnAliases.add(this.getString(ctx, "COL_VoucherAbstract"));
        this.colIndex.put(COL_VoucherAbstract, idx++);
        list.add(COL_Attaches);
        columnAliases.add(this.getString(ctx, "COL_Attaches"));
        this.colIndex.put(COL_Attaches, idx++);
        list.add(COL_IsCheck);
        columnAliases.add(this.getString(ctx, "COL_IsCheck"));
        this.colIndex.put(COL_IsCheck, idx++);
        list.add(COL_Creator);
        columnAliases.add(this.getString(ctx, "COL_Creator"));
        this.colIndex.put(COL_Creator, idx++);
        if (this.isExpUserName) {
            list.add(COL_CreatorName);
            columnAliases.add(this.getString(ctx, "COL_CreatorName"));
            this.colIndex.put(COL_CreatorName, idx++);
        }
        list.add(COL_Auditor);
        columnAliases.add(this.getString(ctx, "COL_Auditor"));
        this.colIndex.put(COL_Auditor, idx++);
        if (this.isExpUserName) {
            list.add(COL_AuditorName);
            columnAliases.add(this.getString(ctx, "COL_AuditorName"));
            this.colIndex.put(COL_AuditorName, idx++);
        }
        list.add(COL_Poster);
        columnAliases.add(this.getString(ctx, "COL_Poster"));
        this.colIndex.put(COL_Poster, idx++);
        if (this.isExpUserName) {
            list.add(COL_PosterName);
            columnAliases.add(this.getString(ctx, "COL_PosterName"));
            this.colIndex.put(COL_PosterName, idx++);
        }
        list.add(COL_Cashier);
        columnAliases.add(this.getString(ctx, "COL_Cashier"));
        this.colIndex.put(COL_Cashier, idx++);
        if (this.isExpUserName) {
            list.add(COL_CashierName);
            columnAliases.add(this.getString(ctx, "COL_CashierName"));
            this.colIndex.put(COL_CashierName, idx++);
        }
        list.add(COL_SourceSys);
        columnAliases.add(this.getString(ctx, "COL_SourceSys"));
        this.colIndex.put(COL_SourceSys, idx++);
        list.add(COL_SourceType);
        columnAliases.add(this.getString(ctx, "COL_SourceType"));
        this.colIndex.put(COL_SourceType, idx++);
        list.add(COL_SourceBillId);
        columnAliases.add(this.getString(ctx, "COL_SourceBillId"));
        this.colIndex.put(COL_SourceBillId, idx++);
        if (this.isExpExtendProperty) {
            for (String extendColName : this.vExtendColNames) {
                list.add(extendColName);
                columnAliases.add(this.extendColAliases.get(extendColName));
                this.colIndex.put(extendColName, idx++);
            }
        }
        if (this.isExpEntry) {
            list.add(COL_EntrySeq);
            columnAliases.add(this.getString(ctx, "COL_EntrySeq"));
            this.colIndex.put(COL_EntrySeq, idx++);
            list.add(COL_ProfitCenterNumber);
            columnAliases.add(this.getString(ctx, "COL_ProfitCenterNumber"));
            this.colIndex.put(COL_ProfitCenterNumber, idx++);
            if (this.isExpAccountName) {
                list.add(COL_AccountName);
                columnAliases.add(this.getString(ctx, "COL_AccountName"));
                this.colIndex.put(COL_AccountName, idx++);
            }
            if (this.isExpAccountLongName) {
                list.add(COL_AccountLongName);
                columnAliases.add(this.getString(ctx, "COL_AccountLongName"));
                this.colIndex.put(COL_AccountLongName, idx++);
            }
            list.add(COL_AccountNumber);
            columnAliases.add(this.getString(ctx, "COL_AccountNumber"));
            this.colIndex.put(COL_AccountNumber, idx++);
            list.add(COL_CurrencyNumber);
            columnAliases.add(this.getString(ctx, "COL_CurrencyNumber"));
            this.colIndex.put(COL_CurrencyNumber, idx++);
            if (this.isExpCurrencyName) {
                list.add(COL_CurrencyName);
                columnAliases.add(this.getString(ctx, "COL_CurrencyName"));
                this.colIndex.put(COL_CurrencyName, idx++);
            }
            list.add(COL_EntryDC);
            columnAliases.add(this.getString(ctx, "COL_EntryDC"));
            this.colIndex.put(COL_EntryDC, idx++);
            list.add(COL_Measurement);
            columnAliases.add(this.getString(ctx, "COL_Measurement"));
            this.colIndex.put(COL_Measurement, idx++);
            if (this.isExpMeasurementName) {
                list.add(COL_MeasurementName);
                columnAliases.add(this.getString(ctx, "COL_MeasurementName"));
                this.colIndex.put(COL_MeasurementName, idx++);
            }
            list.add(COL_Cussent);
            columnAliases.add(this.getString(ctx, "COL_Cussent"));
            this.colIndex.put(COL_Cussent, idx++);
            list.add(COL_CustomerNumber);
            columnAliases.add(this.getString(ctx, "COL_CustomerNumber"));
            this.colIndex.put(COL_CustomerNumber, idx++);
            list.add(COL_LocalRate);
            columnAliases.add(this.getString(ctx, "COL_LocalRate"));
            this.colIndex.put(COL_LocalRate, idx++);
            list.add(COL_OriginalAmount);
            columnAliases.add(this.getString(ctx, "COL_OriginalAmount"));
            this.colIndex.put(COL_OriginalAmount, idx++);
            list.add(COL_DebitAmount);
            columnAliases.add(this.getString(ctx, "COL_DebitAmount"));
            this.colIndex.put(COL_DebitAmount, idx++);
            list.add(COL_CreditAmount);
            columnAliases.add(this.getString(ctx, "COL_CreditAmount"));
            this.colIndex.put(COL_CreditAmount, idx++);
            list.add(COL_Qty);
            columnAliases.add(this.getString(ctx, "COL_Qty"));
            this.colIndex.put(COL_Qty, idx++);
            list.add(COL_Price);
            columnAliases.add(this.getString(ctx, "COL_Price"));
            this.colIndex.put(COL_Price, idx++);
            if (this.isExpExtendProperty) {
                for (String extendColName : this.eExtendColNames) {
                    list.add(extendColName);
                    columnAliases.add(this.extendColAliases.get(extendColName));
                    this.colIndex.put(extendColName, idx++);
                }
            }
        }
        if (this.isExpRecord) {
            list.add(COL_AsstSeq);
            columnAliases.add(this.getString(ctx, "COL_AsstSeq"));
            this.colIndex.put(COL_AsstSeq, idx++);
            list.add(COL_AssistAbstract);
            columnAliases.add(this.getString(ctx, "COL_AssistAbstract"));
            this.colIndex.put(COL_AssistAbstract, idx++);
            list.add(COL_AssistBizDate);
            columnAliases.add(this.getString(ctx, "COL_AssistBizDate"));
            this.colIndex.put(COL_AssistBizDate, idx++);
            list.add(COL_AssistEndDate);
            columnAliases.add(this.getString(ctx, "COL_AssistEndDate"));
            this.colIndex.put(COL_AssistEndDate, idx++);
            if (this.isExpAccountCustomizedProperty) {
                list.add(COL_CPCustomerNumber);
                columnAliases.add(this.getString(ctx, "COL_CPCustomerNumber"));
                this.colIndex.put(COL_CPCustomerNumber, idx++);
                list.add(COL_CPSupplierNumber);
                columnAliases.add(this.getString(ctx, "COL_CPSupplierNumber"));
                this.colIndex.put(COL_CPSupplierNumber, idx++);
                list.add(COL_CPOrgUnitNumber);
                columnAliases.add(this.getString(ctx, "COL_CPOrgUnitNumber"));
                this.colIndex.put(COL_CPOrgUnitNumber, idx++);
                list.add(COL_CPMaterialNumber);
                columnAliases.add(this.getString(ctx, "COL_CPMaterialNumber"));
                this.colIndex.put(COL_CPMaterialNumber, idx++);
                list.add(COL_SettlementType);
                columnAliases.add(this.getString(ctx, "COL_SettlementType"));
                this.colIndex.put(COL_SettlementType, idx++);
                list.add(COL_SettlementNumber);
                columnAliases.add(this.getString(ctx, "COL_SettlementNumber"));
                this.colIndex.put(COL_SettlementNumber, idx++);
                list.add(COL_BizNumber);
                columnAliases.add(this.getString(ctx, "COL_BizNumber"));
                this.colIndex.put(COL_BizNumber, idx++);
                list.add(COL_TicketNumber);
                columnAliases.add(this.getString(ctx, "COL_TicketNumber"));
                this.colIndex.put(COL_TicketNumber, idx++);
                list.add(COL_InvoiceNumber);
                columnAliases.add(this.getString(ctx, "COL_InvoiceNumber"));
                this.colIndex.put(COL_InvoiceNumber, idx++);
            }
            if (this.isExpAssGroupId) {
                list.add(COL_AssGroupId);
                columnAliases.add(this.getString(ctx, "COL_AssGroupId"));
                this.colIndex.put(COL_AssGroupId, idx++);
            }
            for (int i = 1; i <= 8; ++i) {
                list.add("asstActType" + i);
                columnAliases.add(this.getString(ctx, "COL_AsstActType") + i);
                this.colIndex.put("asstActType" + i, idx++);
                if (this.isExpAsstActId) {
                    list.add("asstActId" + i);
                    columnAliases.add(this.getString(ctx, "COL_AsstActId") + i);
                    this.colIndex.put("asstActId" + i, idx++);
                }
                list.add("asstActNumber" + i);
                columnAliases.add(this.getString(ctx, "COL_AsstActNumber") + i);
                this.colIndex.put("asstActNumber" + i, idx++);
                if (!this.isExpAsstActName) continue;
                list.add("asstActName" + i);
                columnAliases.add(this.getString(ctx, "COL_AsstActName") + i);
                this.colIndex.put("asstActName" + i, idx++);
            }
            if (this.isExpExtendProperty) {
                for (String extendColName : this.rExtendColNames) {
                    list.add(extendColName);
                    columnAliases.add(this.extendColAliases.get(extendColName));
                    this.colIndex.put(extendColName, idx++);
                }
            }
        }
        if (isExpCashflow) {
            list.add(COL_ItemFlag);
            columnAliases.add(this.getString(ctx, "COL_ItemFlag"));
            this.colIndex.put(COL_ItemFlag, idx++);
            list.add(COL_OppAccountSeq);
            columnAliases.add(this.getString(ctx, "COL_OppAccountSeq"));
            this.colIndex.put(COL_OppAccountSeq, idx++);
            list.add(COL_OppAsstSeq);
            columnAliases.add(this.getString(ctx, "COL_OppAsstSeq"));
            this.colIndex.put(COL_OppAsstSeq, idx++);
            list.add(COL_PrimaryItem);
            columnAliases.add(this.getString(ctx, "COL_PrimaryItem"));
            this.colIndex.put(COL_PrimaryItem, idx++);
            list.add(COL_PrimaryCoef);
            columnAliases.add(this.getString(ctx, "COL_PrimaryCoef"));
            this.colIndex.put(COL_PrimaryCoef, idx++);
            list.add(COL_SupplyItem);
            columnAliases.add(this.getString(ctx, "COL_SupplyItem"));
            this.colIndex.put(COL_SupplyItem, idx++);
            list.add(COL_SupplyCoef);
            columnAliases.add(this.getString(ctx, "COL_SupplyCoef"));
            this.colIndex.put(COL_SupplyCoef, idx++);
            list.add(COL_FullInfoItem);
            columnAliases.add(this.getString(ctx, "COL_FullInfoItem"));
            this.colIndex.put(COL_FullInfoItem, idx++);
            list.add(COL_Type);
            columnAliases.add(this.getString(ctx, "COL_Type"));
            this.colIndex.put(COL_Type, idx++);
            list.add(COL_CashflowAmountOriginal);
            columnAliases.add(this.getString(ctx, "COL_CashflowAmountOriginal"));
            this.colIndex.put(COL_CashflowAmountOriginal, idx++);
            list.add(COL_CashflowAmountLocal);
            columnAliases.add(this.getString(ctx, "COL_CashflowAmountLocal"));
            this.colIndex.put(COL_CashflowAmountLocal, idx++);
            list.add(COL_CashflowAmountRpt);
            columnAliases.add(this.getString(ctx, "COL_CashflowAmountRpt"));
            this.colIndex.put(COL_CashflowAmountRpt, idx++);
        }
        this.colCount = list.size();
        this.vouchers.add(list);
        if (isColumnAlias) {
            this.vouchers.add(columnAliases);
        }
    }

    private VoucherCollection getVoucherCollection(Context ctx, CompanyOrgUnitInfo company, Set<String> ids) throws BOSException {
        EntityViewInfo e = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        if (company != null) {
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        }
        e.setFilter(f);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo(COL_Description));
        sic.add(new SelectorItemInfo(COL_VoucherAbstract));
        sic.add(new SelectorItemInfo(COL_BizDate));
        sic.add(new SelectorItemInfo(COL_BookedDate));
        sic.add(new SelectorItemInfo("attachments"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("isReverseVoucher"));
        sic.add(new SelectorItemInfo("hasReversed"));
        sic.add(new SelectorItemInfo("cashflowFlag"));
        sic.add(new SelectorItemInfo("isAC"));
        sic.add(new SelectorItemInfo(COL_BizStatus));
        sic.add(new SelectorItemInfo(COL_IsCheck));
        sic.add(new SelectorItemInfo(COL_SourceSys));
        sic.add(new SelectorItemInfo(COL_SourceType));
        if (this.isExpUserName) {
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("handler.name"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("cashier.name"));
            sic.add(new SelectorItemInfo("poster.name"));
            sic.add(new SelectorItemInfo("canceller.name"));
        }
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("poster.number"));
        sic.add(new SelectorItemInfo("canceller.number"));
        sic.add(new SelectorItemInfo("voucherType.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        if (this.isExpExtendProperty) {
            for (String extendColName : this.vExtendColNames) {
                sic.add(new SelectorItemInfo(extendColName.substring(2)));
            }
        }
        if (this.isExpEntry) {
            sic.add(new SelectorItemInfo("entries.seq"));
            sic.add(new SelectorItemInfo("entries.description"));
            sic.add(new SelectorItemInfo("entries.price"));
            sic.add(new SelectorItemInfo("entries.quantity"));
            sic.add(new SelectorItemInfo("entries.standardQuantity"));
            sic.add(new SelectorItemInfo("entries.originalAmount"));
            sic.add(new SelectorItemInfo("entries.entryDC"));
            sic.add(new SelectorItemInfo("entries.localExchangeRate"));
            sic.add(new SelectorItemInfo("entries.localAmount"));
            sic.add(new SelectorItemInfo("entries.reportingExchangeRate"));
            sic.add(new SelectorItemInfo("entries.reportingAmount"));
            sic.add(new SelectorItemInfo("entries.profitCenter.number"));
            sic.add(new SelectorItemInfo("entries.account.number"));
            if (this.isExpAccountName) {
                sic.add(new SelectorItemInfo("entries.account.name"));
            }
            if (this.isExpAccountLongName) {
                sic.add(new SelectorItemInfo("entries.account.longName"));
            }
            sic.add(new SelectorItemInfo("entries.currency.number"));
            if (this.isExpCurrencyName) {
                sic.add(new SelectorItemInfo("entries.currency.name"));
            }
            if (this.isExpMeasurementName) {
                sic.add(new SelectorItemInfo("entries.measureUnit.name"));
            }
            sic.add(new SelectorItemInfo("entries.measureUnit.number"));
            sic.add(new SelectorItemInfo("entries.account.AC"));
            sic.add(new SelectorItemInfo("entries.account.isQty"));
        }
        if (this.isExpRecord) {
            sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
            sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
            sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
            sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
            sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
            sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
            sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
            sic.add(new SelectorItemInfo("entries.assistRecords.customer.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.customer.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.feeType"));
            sic.add(new SelectorItemInfo("entries.assistRecords.handler.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.material.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.material.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.supplier.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.supplier.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.bizDate"));
            sic.add(new SelectorItemInfo("entries.assistRecords.endDate"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assistQty"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.name"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.description"));
            if (this.isExpMeasurementName) {
                sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.name"));
            }
            sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.number"));
            sic.add(new SelectorItemInfo("entries.assistRecords.price"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
        }
        if (this.isExpExtendProperty) {
            if (this.isExpEntry) {
                for (String extendColName : this.eExtendColNames) {
                    sic.add(new SelectorItemInfo("entries." + extendColName.substring(2)));
                }
            }
            if (this.isExpRecord) {
                for (String extendColName : this.rExtendColNames) {
                    sic.add(new SelectorItemInfo("entries.assistRecords." + extendColName.substring(2)));
                }
            }
        }
        e.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        if (this.isExpEntry) {
            sort.add(new SorterItemInfo("entries.seq"));
        }
        e.getSorter().addObjectCollection((IObjectCollection)sort);
        return VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(e);
    }

    private String getSystemAlias(SystemEnum item) {
        if (item == null) {
            return "";
        }
        String key = "System." + item.getValue();
        if (this.aliases.containsKey(key)) {
            return this.aliases.get(key);
        }
        String alias = item.getAlias();
        this.aliases.put(key, alias);
        return alias;
    }

    private String getSourceTypeAlias(SourceType item) {
        if (item == null) {
            return "";
        }
        String key = "SourceType." + item.getValue();
        if (this.aliases.containsKey(key)) {
            return this.aliases.get(key);
        }
        String alias = item.getAlias();
        this.aliases.put(key, alias);
        return alias;
    }

    private String getVoucherStatusAlias(VoucherStatusEnum item) {
        if (item == null) {
            return "";
        }
        String key = "VoucherStatus." + item.getValue();
        if (this.aliases.containsKey(key)) {
            return this.aliases.get(key);
        }
        String alias = item.getAlias();
        this.aliases.put(key, alias);
        return alias;
    }

    private String getEntryDCAlias(EntryDC item) {
        if (item == null) {
            return "";
        }
        String key = "EntryDC." + item.getValue();
        if (this.aliases.containsKey(key)) {
            return this.aliases.get(key);
        }
        String alias = item.getAlias();
        this.aliases.put(key, alias);
        return alias;
    }

    private String getCashflowTypeAlias(CashflowTypeEnum item) {
        if (item == null) {
            return "";
        }
        String key = "CashflowType." + item.getValue();
        if (this.aliases.containsKey(key)) {
            return this.aliases.get(key);
        }
        String alias = item.getAlias();
        this.aliases.put(key, alias);
        return alias;
    }

    protected String getString(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }
}

