/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.TransactionFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.TransactionInvoker;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class VoucherOperateService
implements TransactionInvoker {
    public static final String OPERATE_SUBMIT = "submit";
    public static final String OPERATE_AUDIT = "audit";
    public static final String OPERATE_POST = "post";
    public static final String OPERATE_ANTIPOST = "antiPost";
    public static final String OPERATE_ANTIAUDIT = "antiAudit";
    public static final String OPERATE_DELETE = "delete";
    public static final String OPERATE_CHECK = "check";
    public static final String OPERATE_ANTICHECK = "antiCheck";
    public static final String OPERATE_CANCEL = "cancel";
    public static final String OPERATE_ANTICANCEL = "antiCancel";
    public static final Set<String> OPERATES = new HashSet<String>();
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.VoucherOperateServiceResource";
    public static final boolean[][] voucherStatus;
    private Map<String, UserInfo> users = new HashMap<String, UserInfo>();
    private Map<String, VoucherTypeInfo> voucherTypes = new HashMap<String, VoucherTypeInfo>();
    private Map<String, Object> result = null;
    protected List<String> errs = new ArrayList<String>();
    protected Map<String, Map<String, String>> vchs = new HashMap<String, Map<String, String>>();
    private int exCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map operateVoucher(Context ctx, Map params) throws BOSException, EASBizException {
        Object param;
        this.init(ctx, params);
        boolean isInterfaceInvoke = (Boolean)params.get("isInterfaceInvoke");
        if (isInterfaceInvoke) {
            boolean r;
            boolean isCheckUsePerm = false;
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcUsePerm_Enable");
                if (p != null && Boolean.valueOf(p.toString()).booleanValue()) {
                    isCheckUsePerm = true;
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (isCheckUsePerm && !(r = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), null, "gl_ifc_voucherOperate"))) {
                this.appendErr("user", ContextUtil.getCurrentUserInfo((Context)ctx).getNumber(), MessageFormat.format(this.getResource(ctx, "NO_IfcVoucherOperate_UsePerm"), ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()));
                return this.result;
            }
        }
        if ((param = this.getParam(params, "operate")) == null) {
            this.appendErr("operate", "", this.getResource(ctx, "operate_is_null"));
            return this.result;
        }
        String operate = param.toString().trim();
        if (!OPERATES.contains(operate)) {
            this.appendErr("operate", operate, this.getResource(ctx, "operate_type_error"));
            return this.result;
        }
        boolean force = "true".equals(params.get("force"));
        param = this.getParam(params, "voucherId");
        Set<String> voucherIds = this.getParamStrings(param);
        if (param != null && voucherIds.size() == 0) {
            this.appendErr("voucherId", param.toString(), this.getResource(ctx, "voucherID_error"));
            return this.result;
        }
        param = this.getParam(params, "importKey");
        Set<String> importKeys = this.getParamStrings(param);
        param = this.getParam(params, "companyNumber");
        Set<String> companyNumbers = this.getParamStrings(param);
        if (param != null && companyNumbers.size() == 0) {
            this.appendErr("companyNumber", param.toString(), this.getResource(ctx, "company_number_error"));
            return this.result;
        }
        if (voucherIds.size() == 0 && importKeys.size() == 0 && companyNumbers.size() == 0) {
            this.appendErr("companyNumber", "", this.getResource(ctx, "company_number_is_null"));
            return this.result;
        }
        boolean isFilterCompany = companyNumbers.size() > 0;
        boolean isFilterVoucherId = false;
        boolean isFilterImportKey = false;
        if (!isFilterCompany) {
            if (voucherIds.size() > 0) {
                isFilterVoucherId = true;
            } else {
                isFilterImportKey = true;
            }
        }
        HashMap<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
        if (companyNumbers.size() > 0) {
            CompanyOrgUnitCollection coll = this.getCompanys(ctx, companyNumbers);
            for (Object company : coll) {
                companys.put(company.getNumber(), (CompanyOrgUnitInfo)company);
            }
            ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>(companys.size());
            for (String companyNumber : companyNumbers) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(companyNumber);
                if (company == null) {
                    this.appendErr("companyNumber", companyNumber, this.getResource(ctx, "can't_find_company"));
                    return this.result;
                }
                if (!company.isIsBizUnit()) {
                    this.appendErr("companyNumber", companyNumber, this.getResource(ctx, "company_isn't_bizUnit"));
                    return this.result;
                }
                list.add(company);
            }
            if (!isInterfaceInvoke && !this.checkInterfacePermission(ctx, list)) {
                return this.result;
            }
        }
        param = this.getParam(params, "voucherType");
        Set<String> voucherTypeNumbers = this.getParamStrings(param);
        param = this.getParam(params, "voucherNumber");
        Set<String> voucherNumbers = this.getParamStrings(param);
        Object fromVoucherNumber = this.getParam(params, "fromVoucherNumber");
        Object toVoucherNumber = this.getParam(params, "toVoucherNumber");
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        for (String companyNumber : companyNumbers) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(companyNumber);
            PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(company.getId()));
            if (current == null) {
                this.appendErr("companyNumber", companyNumber, this.getResource(ctx, "company_not_start"));
                return this.result;
            }
            periods.put(companyNumber, current);
        }
        int fromPeriodNumber = -1;
        int toPeriodNumber = -1;
        param = this.getParam(params, "fromPeriodNumber");
        if (param != null) {
            if (param instanceof Integer) {
                fromPeriodNumber = (Integer)param;
            } else if (param instanceof String) {
                try {
                    fromPeriodNumber = Integer.parseInt(((String)param).trim());
                }
                catch (Exception company) {
                    // empty catch block
                }
            }
            if (fromPeriodNumber < 190000 || fromPeriodNumber > 999913) {
                this.appendErr("fromPeriodNumber", param.toString(), this.getResource(ctx, "period_error"));
                return this.result;
            }
        }
        if ((param = this.getParam(params, "toPeriodNumber")) != null) {
            if (param instanceof Integer) {
                fromPeriodNumber = (Integer)param;
            } else if (param instanceof String) {
                try {
                    toPeriodNumber = Integer.parseInt(((String)param).trim());
                }
                catch (Exception company) {
                    // empty catch block
                }
            }
            if (toPeriodNumber < 190000 || toPeriodNumber > 999913 || toPeriodNumber < fromPeriodNumber) {
                this.appendErr("toPeriodNumber", param.toString(), this.getResource(ctx, "period_error"));
                return this.result;
            }
        }
        SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date fromBookedDate = null;
        param = this.getParam(params, "fromBookedDate");
        if (param != null) {
            if (param instanceof java.util.Date) {
                fromBookedDate = (java.util.Date)param;
            } else if (param instanceof String) {
                try {
                    fromBookedDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fromBookedDate == null) {
                this.appendErr("fromBookedDate", param.toString(), this.getResource(ctx, "date_format_error"));
                return null;
            }
        }
        java.util.Date toBookedDate = null;
        param = this.getParam(params, "toBookedDate");
        if (param != null) {
            if (param instanceof java.util.Date) {
                toBookedDate = (java.util.Date)param;
            } else if (param instanceof String) {
                try {
                    toBookedDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (toBookedDate == null) {
                this.appendErr("toBookedDate", param.toString(), this.getResource(ctx, "date_format_error"));
                return null;
            }
        }
        java.util.Date fromBizDate = null;
        param = this.getParam(params, "fromBizDate");
        if (param != null) {
            if (param instanceof java.util.Date) {
                fromBizDate = (java.util.Date)param;
            } else if (param instanceof String) {
                try {
                    fromBizDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fromBizDate == null) {
                this.appendErr("fromBizDate", param.toString(), this.getResource(ctx, "date_format_error"));
                return null;
            }
        }
        java.util.Date toBizDate = null;
        param = this.getParam(params, "toBizDate");
        if (param != null) {
            if (param instanceof java.util.Date) {
                toBizDate = (java.util.Date)param;
            } else if (param instanceof String) {
                try {
                    toBizDate = DF.parse(((String)param).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (toBizDate == null) {
                this.appendErr("toBizDate", param.toString(), this.getResource(ctx, "date_format_error"));
                return null;
            }
        }
        Set<Object> bizStatuses = new HashSet<Integer>();
        param = this.getParam(params, "bizStatus");
        if (param != null) {
            bizStatuses = this.getParamIntegers(param);
            if (bizStatuses.size() == 0) {
                this.appendErr("bizStatus", param.toString(), this.getResource(ctx, "voucher_status_error"));
                return this.result;
            }
        } else {
            bizStatuses.add(0);
            bizStatuses.add(1);
            bizStatuses.add(2);
            bizStatuses.add(3);
            bizStatuses.add(5);
        }
        String isCheck = null;
        param = this.getParam(params, "isCheck");
        if (param instanceof String) {
            if ("true".equals(param) || "1".equals(param)) {
                isCheck = "true";
            } else if ("false".equals(param) || "0".equals(param)) {
                isCheck = "false";
            }
        } else if (param instanceof Boolean) {
            isCheck = String.valueOf(param);
        }
        HashSet<Integer> statuses = new HashSet<Integer>();
        if (OPERATE_SUBMIT.equals(operate)) {
            if (bizStatuses.contains(0)) {
                statuses.add(0);
            }
        } else if (OPERATE_AUDIT.equals(operate)) {
            if (bizStatuses.contains(0) && force) {
                statuses.add(0);
            }
            if (bizStatuses.contains(1)) {
                statuses.add(1);
            }
        } else if (OPERATE_POST.equals(operate)) {
            if (bizStatuses.contains(0) && force) {
                statuses.add(0);
            }
            if (bizStatuses.contains(1) && force) {
                statuses.add(1);
            }
            if (bizStatuses.contains(3)) {
                statuses.add(3);
            }
        } else if (OPERATE_ANTIPOST.equals(operate)) {
            if (bizStatuses.contains(5)) {
                statuses.add(5);
            }
        } else if (OPERATE_ANTIAUDIT.equals(operate)) {
            if (bizStatuses.contains(3)) {
                statuses.add(3);
            }
            if (bizStatuses.contains(5) && force) {
                statuses.add(5);
            }
        } else if (OPERATE_DELETE.equals(operate)) {
            if (bizStatuses.contains(0)) {
                statuses.add(0);
            }
            if (bizStatuses.contains(1)) {
                statuses.add(1);
            }
            if (bizStatuses.contains(2)) {
                statuses.add(2);
            }
            if (bizStatuses.contains(3) && force) {
                statuses.add(3);
            }
            if (bizStatuses.contains(5) && force) {
                statuses.add(5);
            }
        } else if (OPERATE_CHECK.equals(operate)) {
            if (bizStatuses.contains(1)) {
                statuses.add(1);
            }
            if (bizStatuses.contains(3)) {
                statuses.add(3);
            }
            if (bizStatuses.contains(5)) {
                statuses.add(5);
            }
            if ("true".equals(isCheck)) {
                return this.result;
            }
            isCheck = "false";
        } else if (OPERATE_ANTICHECK.equals(operate)) {
            if (bizStatuses.contains(1)) {
                statuses.add(1);
            }
            if (bizStatuses.contains(3)) {
                statuses.add(3);
            }
            if (bizStatuses.contains(5)) {
                statuses.add(5);
            }
            if ("false".equals(isCheck)) {
                return this.result;
            }
            isCheck = "true";
        } else if (OPERATE_CANCEL.equals(operate)) {
            if (bizStatuses.contains(1)) {
                statuses.add(1);
            }
        } else if (OPERATE_ANTICANCEL.equals(operate) && bizStatuses.contains(2)) {
            statuses.add(2);
        }
        if (statuses.size() == 0) {
            return this.result;
        }
        bizStatuses = statuses;
        HashSet<String> creatorIds = new HashSet<String>();
        Set<String> creatorNumbers = this.getParamStrings(this.getParam(params, "creator"));
        if (creatorNumbers.size() > 0) {
            for (String number : creatorNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr("creator", number, this.getResource(ctx, "can_not_find_creator"));
                    return this.result;
                }
                creatorIds.add(user.getId().toString());
            }
        }
        HashSet<String> auditorIds = new HashSet<String>();
        Set<String> auditorNumbers = this.getParamStrings(this.getParam(params, "auditor"));
        if (auditorNumbers.size() > 0) {
            for (String number : auditorNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr("auditor", number, this.getResource(ctx, "can_not_find_auditor"));
                    return this.result;
                }
                auditorIds.add(user.getId().toString());
            }
        }
        HashSet<String> posterIds = new HashSet<String>();
        Set<String> posterNumbers = this.getParamStrings(this.getParam(params, "poster"));
        if (posterNumbers.size() > 0) {
            for (String number : posterNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr("poster", number, this.getResource(ctx, "can_not_find_postor"));
                    return this.result;
                }
                posterIds.add(user.getId().toString());
            }
        }
        HashSet<String> cashierIds = new HashSet<String>();
        Set<String> cashierNumbers = this.getParamStrings(this.getParam(params, "cashier"));
        if (cashierNumbers.size() > 0) {
            for (String number : cashierNumbers) {
                UserInfo user = this.getUser(ctx, number);
                if (user == null) {
                    this.appendErr("cashier", number, this.getResource(ctx, "can_not_find_cheker"));
                    return this.result;
                }
                cashierIds.add(user.getId().toString());
            }
        }
        Object description = this.getParam(params, "description");
        Object voucherAbstract = this.getParam(params, "voucherAbstract");
        HashSet<Integer> sourceSyses = new HashSet<Integer>();
        param = this.getParam(params, "sourceSys");
        if (param != null) {
            Set<String> strs = this.getParamStrings(param);
            for (String string : strs) {
                SystemEnum sys = this.getSourceSys(ctx, string);
                if (sys == null) continue;
                sourceSyses.add(sys.getValue());
            }
            if (sourceSyses.size() == 0) {
                this.appendErr("sourceSys", param.toString(), this.getResource(ctx, "sourceSys_error"));
                return this.result;
            }
        }
        HashSet<Integer> sourceTypes = new HashSet<Integer>();
        param = this.getParam(params, "sourceType");
        if (param != null) {
            Set<String> strs = this.getParamStrings(param);
            for (String str : strs) {
                SourceType type = this.getSourceType(ctx, str);
                if (type == null) continue;
                sourceTypes.add(type.getValue());
            }
            if (sourceTypes.size() == 0) {
                this.appendErr("sourceType", param.toString(), this.getResource(ctx, "sourceType_error"));
                return this.result;
            }
        }
        Set<Object> categories = new HashSet();
        param = this.getParam(params, "category");
        if (param != null && (categories = this.getParamIntegers(param)).contains(1) && categories.contains(2) && categories.contains(3)) {
            categories.clear();
        }
        Object object = this.getParam(params, "entryDescription");
        param = this.getParam(params, "currency");
        Set<String> currencys = this.getParamStrings(param);
        param = this.getParam(params, "accountNumber");
        Set<String> accountNumbers = this.getParamStrings(param);
        Object fromAccountNumber = this.getParam(params, "fromAccountNumber");
        Object toAccountNumber = this.getParam(params, "toAccountNumber");
        param = this.getParam(params, "entryAmount");
        BigDecimal entryAmount = null;
        if (param != null && param.toString().trim().length() > 0) {
            try {
                entryAmount = new BigDecimal(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        param = this.getParam(params, "entryMinAmount");
        BigDecimal entryMinAmount = null;
        if (param != null && param.toString().trim().length() > 0) {
            try {
                entryMinAmount = new BigDecimal(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        param = this.getParam(params, "entryMaxAmount");
        BigDecimal entryMaxAmount = null;
        if (param != null && param.toString().trim().length() > 0) {
            try {
                entryMaxAmount = new BigDecimal(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (companyNumbers.size() == 0) {
            companyNumbers.add("noCompany");
        }
        for (String companyNumber : companyNumbers) {
            HashMap<String, String> vch;
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(companyNumber);
            PeriodInfo current = (PeriodInfo)periods.get(companyNumber);
            StringBuffer sql = new StringBuffer();
            ArrayList<Object> sqlParams = new ArrayList<Object>();
            sql.append("select \n");
            sql.append("    distinct v.FID, v.FNumber, v.FBizStatus, v.FIsCheck, v.FHasCashAccount, \n");
            sql.append("    c.FID FCompanyID, c.FNumber FCompanyNumber, v.FCreatorID, c.FControlUnitID \n");
            if (isFilterImportKey) {
                sql.append("    , k.FImportKey \n");
            }
            sql.append("from T_GL_Voucher v \n");
            sql.append("join T_ORG_Company c on c.FID = v.FCompanyID \n");
            if (isFilterImportKey || isFilterCompany && importKeys.size() > 0) {
                sql.append("join T_GL_VoucherImportKey k on k.FVoucherID = v.FID \n");
            }
            if (isFilterCompany) {
                if (voucherTypeNumbers.size() > 0) {
                    sql.append("join T_BD_VoucherTypes t on t.FID = v.FVoucherTypeID \n");
                }
                if (fromPeriodNumber > 0 || toPeriodNumber > 0) {
                    sql.append("join T_BD_Period p on p.FID = v.FPeriodID \n");
                }
                if (object != null && object.toString().trim().length() > 0 || currencys.size() > 0 || accountNumbers.size() > 0 || fromAccountNumber != null && fromAccountNumber.toString().trim().length() > 0 || toAccountNumber != null && toAccountNumber.toString().trim().length() > 0 || entryAmount != null || entryMinAmount != null || entryMaxAmount != null) {
                    sql.append("join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
                    if (currencys.size() > 0) {
                        sql.append("join T_BD_Currency cy on cy.FID = ve.FCurrencyID \n");
                    }
                    if (accountNumbers.size() > 0 || fromAccountNumber != null && fromAccountNumber.toString().trim().length() > 0 || toAccountNumber != null && toAccountNumber.toString().trim().length() > 0) {
                        sql.append("join T_BD_AccountView av on av.FID = ve.FAccountID \n");
                    }
                }
            }
            sql.append("where 1=1 \n");
            if (isFilterVoucherId || isFilterCompany) {
                if (voucherIds.size() == 1) {
                    sql.append("and v.FID = ? \n");
                    sqlParams.add(voucherIds.iterator().next());
                } else if (voucherIds.size() > 1) {
                    sql.append("and v.FID in " + VoucherOperateService.toInSql(voucherIds.size()) + " \n");
                    sqlParams.addAll(voucherIds);
                }
            }
            if (isFilterImportKey || isFilterCompany) {
                if (importKeys.size() == 1) {
                    sql.append("and k.FImportKey = ? \n");
                    sqlParams.add(importKeys.iterator().next());
                } else if (importKeys.size() > 1) {
                    sql.append("and k.FImportKey in " + VoucherOperateService.toInSql(importKeys.size()) + " \n");
                    sqlParams.addAll(importKeys);
                }
            }
            if (isFilterCompany) {
                if (company != null) {
                    sql.append("and v.FCompanyID = ? \n");
                    sqlParams.add(company.getId().toString());
                }
                if (voucherNumbers.size() == 1) {
                    sql.append("and v.FNumber = ? \n");
                    sqlParams.add(voucherNumbers.iterator().next());
                } else if (voucherNumbers.size() > 1) {
                    sql.append("and v.FNumber in " + VoucherOperateService.toInSql(voucherNumbers.size()) + " \n");
                    sqlParams.addAll(voucherNumbers);
                }
                if (fromVoucherNumber != null && fromVoucherNumber.toString().trim().length() > 0) {
                    sql.append("and v.FNumber >= ? \n");
                    sqlParams.add(fromVoucherNumber.toString().trim());
                }
                if (toVoucherNumber != null && toVoucherNumber.toString().trim().length() > 0) {
                    sql.append("and v.FNumber <= ? \n");
                    sqlParams.add(toVoucherNumber.toString().trim());
                }
                if (voucherTypeNumbers.size() == 1) {
                    sql.append("and t.FNumber = ? \n");
                    sqlParams.add(voucherTypeNumbers.iterator().next());
                } else if (voucherTypeNumbers.size() > 1) {
                    sql.append("and t.FNumber in " + VoucherOperateService.toInSql(voucherTypeNumbers.size()) + " \n");
                    sqlParams.addAll(voucherTypeNumbers);
                }
                if (fromPeriodNumber > 0 || toPeriodNumber > 0 || fromBookedDate != null || toBookedDate != null) {
                    if (fromPeriodNumber > 0) {
                        sql.append("and p.FNumber >= ? \n");
                        sqlParams.add(fromPeriodNumber);
                    }
                    if (toPeriodNumber > 0) {
                        sql.append("and p.FNumber <= ? \n");
                        sqlParams.add(toPeriodNumber);
                    }
                    if (fromBookedDate != null) {
                        sql.append("and v.FBookedDate >= ? \n");
                        sqlParams.add(new Date(fromBookedDate.getTime()));
                    }
                    if (toBookedDate != null) {
                        sql.append("and v.FBookedDate <= ? \n");
                        sqlParams.add(new Date(toBookedDate.getTime()));
                    }
                } else if (current != null) {
                    sql.append("and v.FBookedDate >= ? \n");
                    sqlParams.add(new Date(current.getBeginDate().getTime()));
                }
                if (fromBizDate != null) {
                    sql.append("and v.FBizDate >= ? \n");
                    sqlParams.add(new Date(fromBizDate.getTime()));
                }
                if (toBizDate != null) {
                    sql.append("and v.FBizDate <= ? \n");
                    sqlParams.add(new Date(toBizDate.getTime()));
                }
                if (bizStatuses.size() == 1) {
                    sql.append("and v.FBizStatus = ? \n");
                    sqlParams.add(bizStatuses.iterator().next());
                } else if (bizStatuses.size() > 1) {
                    sql.append("and v.FBizStatus in " + VoucherOperateService.toInSql(bizStatuses.size()) + " \n");
                    sqlParams.addAll(bizStatuses);
                }
                if (creatorIds.size() == 1) {
                    sql.append("and v.FCreatorID = ? \n");
                    sqlParams.add(creatorIds.iterator().next());
                } else if (creatorIds.size() > 1) {
                    sql.append("and v.FCreatorID in " + VoucherOperateService.toInSql(creatorIds.size()) + " \n");
                    sqlParams.addAll(creatorIds);
                }
                if (auditorIds.size() == 1) {
                    sql.append("and v.FAuditorID = ? \n");
                    sqlParams.add(auditorIds.iterator().next());
                } else if (auditorIds.size() > 1) {
                    sql.append("and v.FAuditorID in " + VoucherOperateService.toInSql(auditorIds.size()) + " \n");
                    sqlParams.addAll(auditorIds);
                }
                if (posterIds.size() == 1) {
                    sql.append("and v.FPosterID = ? \n");
                    sqlParams.add(posterIds.iterator().next());
                } else if (posterIds.size() > 1) {
                    sql.append("and v.FPosterID in " + VoucherOperateService.toInSql(posterIds.size()) + " \n");
                    sqlParams.addAll(posterIds);
                }
                if (cashierIds.size() == 1) {
                    sql.append("and v.FCashierID = ? \n");
                    sqlParams.add(cashierIds.iterator().next());
                } else if (cashierIds.size() > 1) {
                    sql.append("and v.FCashierID in " + VoucherOperateService.toInSql(cashierIds.size()) + " \n");
                    sqlParams.addAll(cashierIds);
                }
                if ("true".equals(isCheck)) {
                    sql.append("and v.FIsCheck = 1 \n");
                } else if ("false".equals(isCheck)) {
                    sql.append("and v.FIsCheck = 0 \n");
                }
                if (description != null && description.toString().trim().length() > 0) {
                    sql.append("and v.FDescription like ? \n");
                    sqlParams.add("%" + description.toString().trim() + "%");
                }
                if (voucherAbstract != null && voucherAbstract.toString().trim().length() > 0) {
                    sql.append("and v.FAbstract like ? \n");
                    sqlParams.add("%" + voucherAbstract.toString().trim() + "%");
                }
                if (sourceSyses.size() == 1) {
                    sql.append("and v.FSourceSys = ? \n");
                    sqlParams.add(sourceSyses.iterator().next());
                } else if (sourceSyses.size() > 1) {
                    sql.append("and v.FSourceSys in " + VoucherOperateService.toInSql(sourceSyses.size()) + " \n");
                    sqlParams.addAll(sourceSyses);
                }
                if (sourceTypes.size() == 1) {
                    sql.append("and v.FSourceType = ? \n");
                    sqlParams.add(sourceTypes.iterator().next());
                } else if (sourceTypes.size() > 1) {
                    sql.append("and v.FSourceType in " + VoucherOperateService.toInSql(sourceTypes.size()) + " \n");
                    sqlParams.addAll(sourceTypes);
                }
                if (categories.size() == 1) {
                    sql.append("and v.FCategory = ? \n");
                    sqlParams.add(categories.iterator().next());
                } else if (categories.size() > 1) {
                    sql.append("and v.FCategory in " + VoucherOperateService.toInSql(categories.size()) + " \n");
                    sqlParams.addAll(categories);
                }
                if (object != null && object.toString().trim().length() > 0) {
                    sql.append("and ve.FDescription like ? \n");
                    sqlParams.add("%" + object.toString().trim() + "%");
                }
                if (currencys.size() == 1) {
                    sql.append("and cy.FNumber = ? \n");
                    sqlParams.add(currencys.iterator().next());
                } else if (currencys.size() > 1) {
                    sql.append("and cy.FNumber in " + VoucherOperateService.toInSql(currencys.size()) + " \n");
                    sqlParams.addAll(currencys);
                }
                if (accountNumbers.size() == 1) {
                    sql.append("and av.FNumber = ? \n");
                    sqlParams.add(accountNumbers.iterator().next());
                } else if (accountNumbers.size() > 1) {
                    sql.append("and av.FNumber in " + VoucherOperateService.toInSql(accountNumbers.size()) + " \n");
                    sqlParams.addAll(accountNumbers);
                }
                if (fromAccountNumber != null && fromAccountNumber.toString().trim().length() > 0) {
                    sql.append("and av.FNumber >= ? \n");
                    sqlParams.add(fromAccountNumber.toString().trim());
                }
                if (toAccountNumber != null && toAccountNumber.toString().trim().length() > 0) {
                    sql.append("and av.FNumber <= ? \n");
                    sqlParams.add(toAccountNumber.toString().trim());
                }
                if (entryAmount != null) {
                    sql.append("and ve.FOriginalAmount = ? \n");
                    sqlParams.add(entryAmount);
                }
                if (entryMinAmount != null) {
                    sql.append("and ve.FOriginalAmount >= ? \n");
                    sqlParams.add(entryMinAmount);
                }
                if (entryMaxAmount != null) {
                    sql.append("and ve.FOriginalAmount <= ? \n");
                    sqlParams.add(entryMaxAmount);
                }
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
            VoucherCollection vouchers = new VoucherCollection();
            ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
            HashSet<String> companyIds = new HashSet<String>();
            HashSet<String> vIds = new HashSet<String>();
            HashSet<String> keys = new HashSet<String>();
            try {
                while (rs.next()) {
                    VoucherInfo voucher = new VoucherInfo();
                    voucher.setId(BOSUuid.read((String)rs.getString("FID")));
                    voucher.setNumber(rs.getString("FNumber"));
                    voucher.setBizStatus(VoucherStatusEnum.getEnum((int)rs.getInt("FBizStatus")));
                    voucher.setIsCheck(rs.getInt("FIsCheck") == 1);
                    voucher.setHasCashAccount(rs.getInt("FHasCashAccount") == 1);
                    String companyId = rs.getString("FCompanyID");
                    if (companyId == null) continue;
                    if (isFilterVoucherId) {
                        vIds.add(rs.getString("FID"));
                    } else if (isFilterImportKey) {
                        keys.add(rs.getString("FImportKey"));
                        voucher.put("importKey", (Object)rs.getString("FImportKey"));
                    }
                    CompanyOrgUnitInfo c = new CompanyOrgUnitInfo();
                    c.setId(BOSUuid.read((String)companyId));
                    c.setNumber(rs.getString("FCompanyNumber"));
                    String cuId = rs.getString("FControlUnitID");
                    if (cuId != null) {
                        CtrlUnitInfo cu = new CtrlUnitInfo();
                        cu.setId(BOSUuid.read((String)cuId));
                        c.setCU(cu);
                    }
                    voucher.setCompany(c);
                    String creatorId = rs.getString("FCreatorID");
                    if (creatorId != null) {
                        UserInfo user = new UserInfo();
                        user.setId(BOSUuid.read((String)creatorId));
                        voucher.setCreator(user);
                    }
                    vouchers.add(voucher);
                    if (companyIds.contains(companyId)) continue;
                    companyIds.add(companyId);
                    list.add(voucher.getCompany());
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (isFilterVoucherId) {
                for (String voucherId : voucherIds) {
                    if (vIds.contains(voucherId)) continue;
                    vch = new HashMap<String, String>();
                    vch.put("id", voucherId);
                    vch.put("err", this.getResource(ctx, "can_not_find_voucher"));
                    this.vchs.put(voucherId, vch);
                }
            } else if (isFilterImportKey) {
                for (String importKey : importKeys) {
                    if (keys.contains(importKey)) continue;
                    vch = new HashMap();
                    vch.put("importKey", importKey);
                    vch.put("err", this.getResource(ctx, "can_not_find_voucher"));
                    this.vchs.put(importKey, vch);
                }
            }
            if (vouchers.size() == 0) continue;
            if (companys.size() == 0 && list.size() > 0 && !isInterfaceInvoke && !this.checkInterfacePermission(ctx, list)) {
                return this.result;
            }
            String cacheId = BOSUuid.create((String)"ABCD1234").toString();
            try {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).getDatas(ctx).put("isCheckBizPerm", params.get("isCheckBizPerm"));
                Iterator it = vouchers.iterator();
                while (it.hasNext()) {
                    VoucherInfo voucher;
                    block244: {
                        vch = new HashMap();
                        voucher = (VoucherInfo)it.next();
                        vch.put("id", voucher.getId().toString());
                        if (isFilterImportKey) {
                            vch.put("importKey", voucher.getString("importKey"));
                        }
                        vch.put("companyNumber", voucher.getCompany().getNumber());
                        vch.put("voucherNumber", voucher.getNumber());
                        try {
                            String msg = this.operateVoucher(ctx, voucher, params);
                            if (msg != null) {
                                vch.put("err", msg);
                            }
                        }
                        catch (Exception e) {
                            String retEx;
                            vch.put("err", e.getMessage());
                            if (this.exCount >= 10 || (retEx = GlUtils.printStackTrace(e)) == null) break block244;
                            vch.put("ex", retEx);
                            ++this.exCount;
                        }
                    }
                    if (isFilterImportKey) {
                        this.vchs.put(voucher.getString("importKey"), vch);
                        continue;
                    }
                    this.vchs.put(voucher.getId().toString(), vch);
                }
            }
            finally {
                VoucherProcessCache.clearCache(ctx, cacheId);
            }
        }
        return this.result;
    }

    protected void init(Context ctx, Map params) {
        this.result = new HashMap<String, Object>();
        this.result.put("errs", this.errs);
        this.result.put("vchs", this.vchs);
        this.exCount = 0;
        boolean isInterfaceInvoke = (Boolean)params.get("isInterfaceInvoke");
        boolean isCheckBizPerm = true;
        if (isInterfaceInvoke) {
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcBizPerm_Enable");
                if (p != null && "false".equalsIgnoreCase(p.toString())) {
                    isCheckBizPerm = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        params.put("isCheckBizPerm", isCheckBizPerm);
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    protected Object getParam(Map params, String key) {
        Object param = params.get(key);
        if (param instanceof Collection) {
            if (((Collection)param).size() == 0) {
                param = null;
            }
        } else if (param instanceof String) {
            String str = ((String)param).trim();
            param = str.length() == 0 ? null : str;
        }
        return param;
    }

    protected Set<String> getParamStrings(Object param) {
        HashSet<String> result;
        block2: {
            String[] strs;
            block3: {
                result = new HashSet<String>();
                if (param == null) break block2;
                if (!(param instanceof Collection)) break block3;
                for (Object item : (Collection)param) {
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    result.add(item.toString().trim());
                }
                break block2;
            }
            if (!(param instanceof String)) break block2;
            for (String str : strs = ((String)param).trim().split(";")) {
                if (str.trim().length() <= 0) continue;
                result.add(str.trim());
            }
        }
        return result;
    }

    protected Set<Integer> getParamIntegers(Object param) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (param != null) {
            if (param instanceof Collection) {
                for (Object item : (Collection)param) {
                    if (item instanceof Integer) {
                        result.add((Integer)item);
                        continue;
                    }
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    try {
                        result.add(Integer.parseInt(item.toString().trim()));
                    }
                    catch (Exception exception) {}
                }
            } else if (param instanceof String) {
                String[] strs;
                for (String str : strs = ((String)param).trim().split(";")) {
                    if (str.trim().length() <= 0) continue;
                    try {
                        result.add(Integer.parseInt(str.trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else if (param instanceof Integer) {
                result.add((Integer)param);
            }
        }
        return result;
    }

    protected boolean checkInterfacePermission(Context ctx, List<CompanyOrgUnitInfo> companys) throws EASBizException, BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        ArrayList<ObjectUuidPK> orgPKs = new ArrayList<ObjectUuidPK>();
        for (CompanyOrgUnitInfo company : companys) {
            orgPKs.add(new ObjectUuidPK(company.getId()));
        }
        String permItemName = "gl_voucher_newOperate";
        Set set = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(user.getId()), orgPKs.toArray(new IObjectPK[orgPKs.size()]), permItemName);
        if (set != null) {
            for (CompanyOrgUnitInfo company : companys) {
                if (set.contains(company.getId().toString())) continue;
                this.appendErr("companyNumber", company.getNumber(), this.getResource(ctx, "no_permission"));
                return false;
            }
        }
        return true;
    }

    private static String toInSql(int count) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        return "(" + sql.toString() + ")";
    }

    protected SelectorItemCollection getVoucherSelector(Context ctx, Map params) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bizStatus");
        selector.add("isCheck");
        selector.add("hasCashAccount");
        selector.add("company.id");
        selector.add("company.number");
        selector.add("creator.id");
        return selector;
    }

    protected CompanyOrgUnitCollection getCompanys(Context ctx, Set<String> companyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isBizUnit");
        selector.add("cu.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", companyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (coll == null) {
            coll = new CompanyOrgUnitCollection();
        }
        return coll;
    }

    private VoucherTypeInfo getVoucherType(Context ctx, String number, String cuId) throws BOSException {
        String key = number + "_" + cuId;
        if (this.voucherTypes.containsKey(key)) {
            return this.voucherTypes.get(key);
        }
        VoucherTypeInfo voucherType = GlWebServiceUtil.findVouherTypeByNumber(ctx, number, BOSUuid.read((String)cuId));
        if (voucherType == null) {
            voucherType = GlWebServiceUtil.findVouherTypeByName(ctx, number, BOSUuid.read((String)cuId));
        }
        this.voucherTypes.put(key, voucherType);
        return voucherType;
    }

    protected String operateVoucher(Context ctx, VoucherInfo voucher, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, Object> invokeParams = new HashMap<String, Object>();
        invokeParams.put("invoker", this);
        invokeParams.put("voucher", voucher);
        invokeParams.put("params", params);
        return (String)TransactionFacadeFactory.getLocalInstance(ctx).mRequired(invokeParams);
    }

    protected String beforeOperateVoucher(Context ctx, VoucherInfo voucher, Map<String, Object> params) throws EASBizException, BOSException {
        return null;
    }

    protected String afterOperateVoucher(Context ctx, VoucherInfo voucher, Map<String, Object> params) throws EASBizException, BOSException {
        return null;
    }

    @Override
    public final Object invoke(Context ctx, Map invokeParams) throws BOSException, EASBizException {
        VoucherInfo voucher = (VoucherInfo)invokeParams.get("voucher");
        Map params = (Map)invokeParams.get("params");
        boolean force = "true".equals(params.get("force"));
        String operate = params.get("operate").toString().trim();
        String result = this.beforeOperateVoucher(ctx, voucher, params);
        if (result != null) {
            return result;
        }
        if (OPERATE_SUBMIT.equals(operate)) {
            result = this.submitVoucher(ctx, voucher, force, params);
        } else if (OPERATE_AUDIT.equals(operate)) {
            result = this.auditVoucher(ctx, voucher, force, params);
        } else if (OPERATE_POST.equals(operate)) {
            result = this.postVoucher(ctx, voucher, force, params);
        } else if (OPERATE_ANTIPOST.equals(operate)) {
            result = this.antiPostVoucher(ctx, voucher, force, params);
        } else if (OPERATE_ANTIAUDIT.equals(operate)) {
            result = this.antiAuditVoucher(ctx, voucher, force, params);
        } else if (OPERATE_DELETE.equals(operate)) {
            result = this.deleteVoucher(ctx, voucher, force, params);
        } else if (OPERATE_CHECK.equals(operate)) {
            result = this.checkVoucher(ctx, voucher, force, params);
        } else if (OPERATE_ANTICHECK.equals(operate)) {
            result = this.antiCheckVoucher(ctx, voucher, force, params);
        } else if (OPERATE_CANCEL.equals(operate)) {
            result = this.cancelVoucher(ctx, voucher, force, params);
        } else if (OPERATE_ANTICANCEL.equals(operate)) {
            result = this.antiCancelVoucher(ctx, voucher, force, params);
        }
        if (result == null) {
            result = this.afterOperateVoucher(ctx, voucher, params);
        }
        return result;
    }

    protected SystemEnum getSourceSys(Context ctx, String key) {
        List list = SystemEnum.getEnumList();
        for (SystemEnum item : list) {
            if (!String.valueOf(item.getValue()).equals(key) && !item.getName().equals(key) && !item.getAlias().equals(key)) continue;
            return item;
        }
        return null;
    }

    protected SourceType getSourceType(Context ctx, String key) {
        List list = SourceType.getEnumList();
        for (SourceType item : list) {
            if (!String.valueOf(item.getValue()).equals(key) && !item.getName().equals(key) && !item.getAlias().equals(key)) continue;
            return item;
        }
        return null;
    }

    private UserInfo getUser(Context ctx, String number) throws BOSException {
        if (this.users.containsKey(number)) {
            return this.users.get(number);
        }
        UserInfo user = GlWebServiceUtil.findUserUByName(ctx, number);
        this.users.put(number, user);
        return user;
    }

    protected String checkStatusAndOperate(VoucherStatusEnum bizStatus, VoucherOperateStatusEnum operateStatus) throws EASBizException {
        int i = operateStatus.getValue();
        int j = bizStatus.getValue();
        Object[] info = new String[]{operateStatus.toString(), bizStatus.toString()};
        if (!voucherStatus[i][j]) {
            return new VoucherException(VoucherException.STATUS_AND_OPERATE, info).getMessage();
        }
        return null;
    }

    protected Context buildContext(Context ctx, CompanyOrgUnitInfo company, UserInfo user) {
        Context newCtx = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
        newCtx.setReadAIS(ctx.getReadAIS());
        newCtx.setClientHostIP(ctx.getClientHostIP());
        newCtx.setClientHostName(ctx.getClientHostName());
        newCtx.setUserName(ctx.getUserName());
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        ContextUtil.setCurrentFIUnit((Context)newCtx, (CompanyOrgUnitInfo)company);
        if (company.getCU() != null) {
            ContextUtil.setCurrentCtrlUnit((Context)newCtx, (CtrlUnitInfo)company.getCU());
        }
        if (user == null) {
            user = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        newCtx.setCaller((IObjectPK)new ObjectUuidPK(user.getId()));
        ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)user);
        return newCtx;
    }

    private String submitVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        UserInfo creator;
        if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus())) {
            boolean isCheckBizPerm = (Boolean)params.get("isCheckBizPerm");
            creator = null;
            Object param = this.getParam(params, "nCreator");
            if (param != null && (creator = this.getUser(ctx, param.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_creator");
            }
            if (creator == null) {
                creator = voucher.getCreator();
            }
        } else {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.SUBMIT);
        }
        Context newCtx = this.buildContext(ctx, voucher.getCompany(), creator);
        VoucherFactory.getLocalInstance((Context)newCtx).submitVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
        return null;
    }

    private String auditVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        Context newCtx;
        UserInfo auditor;
        if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus()) && force || VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus())) {
            Object param;
            Object checkAFAudit;
            Object useWorkflow;
            boolean isUseWorkflow;
            Object param2;
            boolean isCheckBizPerm = (Boolean)params.get("isCheckBizPerm");
            UserInfo creator = null;
            if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus()) && (param2 = this.getParam(params, "nCreator")) != null && (creator = this.getUser(ctx, param2.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_creator");
            }
            if (creator == null) {
                creator = voucher.getCreator();
            }
            if ((isUseWorkflow = Boolean.valueOf((useWorkflow = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_032")).toString()).booleanValue()) && (useWorkflow = params.get("isUseWorkflow")) != null && useWorkflow.toString().trim().length() > 0 && "false".equalsIgnoreCase(useWorkflow.toString().trim())) {
                isUseWorkflow = false;
            }
            if (isUseWorkflow) {
                return this.getResource(ctx, "work_flow_started");
            }
            int iCheckAFAudit = 0;
            UserInfo cashier = null;
            if (voucher.isHasCashAccount() && !voucher.isIsCheck() && (checkAFAudit = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_047")) != null && (iCheckAFAudit = Integer.parseInt(checkAFAudit.toString())) == 1 && (param = this.getParam(params, "nCashier")) != null && (cashier = this.getUser(ctx, param.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_cheker");
            }
            auditor = null;
            param = this.getParam(params, "nAuditor");
            if (param != null && (auditor = this.getUser(ctx, param.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_auditor");
            }
            if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus())) {
                newCtx = this.buildContext(ctx, voucher.getCompany(), creator);
                VoucherFactory.getLocalInstance((Context)newCtx).submitVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
            }
            if (iCheckAFAudit == 1) {
                newCtx = this.buildContext(ctx, voucher.getCompany(), cashier);
                if (isCheckBizPerm) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                VoucherFactory.getLocalInstance((Context)newCtx).checkVoucher(voucher.getId().toString());
            }
            if (auditor == null) {
                auditor = ContextUtil.getCurrentUserInfo((Context)ctx);
            }
            newCtx = this.buildContext(ctx, voucher.getCompany(), auditor);
            if (isCheckBizPerm) {
                ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            }
        } else {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.AUDIT);
        }
        VoucherFactory.getLocalInstance((Context)newCtx).auditVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), auditor.getId());
        return null;
    }

    private String postVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        Context newCtx;
        if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus()) && force || VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus()) && force || VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus())) {
            Object param;
            Object param2;
            Object useWorkflow;
            boolean isUseWorkflow;
            Object param3;
            boolean isCheckBizPerm = (Boolean)params.get("isCheckBizPerm");
            UserInfo creator = null;
            if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus()) && (param3 = this.getParam(params, "nCreator")) != null && (creator = this.getUser(ctx, param3.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_creator");
            }
            if (creator == null) {
                creator = voucher.getCreator();
            }
            if ((isUseWorkflow = Boolean.valueOf((useWorkflow = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_032")).toString()).booleanValue()) && (useWorkflow = params.get("isUseWorkflow")) != null && useWorkflow.toString().trim().length() > 0 && "false".equalsIgnoreCase(useWorkflow.toString().trim())) {
                isUseWorkflow = false;
            }
            if (isUseWorkflow) {
                return this.getResource(ctx, "work_flow_started");
            }
            int iCheckAFAudit = 0;
            boolean isCheckBFPost = false;
            UserInfo cashier = null;
            if (voucher.isHasCashAccount() && !voucher.isIsCheck()) {
                Object checkAFAudit = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_047");
                if (checkAFAudit != null && ((iCheckAFAudit = Integer.parseInt(checkAFAudit.toString())) == 1 || iCheckAFAudit == 2) && (param2 = this.getParam(params, "nCashier")) != null && (cashier = this.getUser(ctx, param2.toString().trim())) == null) {
                    return this.getResource(ctx, "can_not_find_cheker");
                }
                Object checkBFPost = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_046");
                if (checkBFPost != null && (isCheckBFPost = Boolean.valueOf(checkBFPost.toString()).booleanValue()) && (param = this.getParam(params, "nCashier")) != null && (cashier = this.getUser(ctx, param.toString().trim())) == null) {
                    return this.getResource(ctx, "can_not_find_cheker");
                }
            }
            UserInfo auditor = null;
            if ((VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus())) && (param2 = this.getParam(params, "nAuditor")) != null && (auditor = this.getUser(ctx, param2.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_auditor");
            }
            UserInfo poster = null;
            param = this.getParam(params, "nPoster");
            if (param != null && (poster = this.getUser(ctx, param.toString().trim())) == null) {
                return this.getResource(ctx, "can_not_find_postor");
            }
            if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus())) {
                newCtx = this.buildContext(ctx, voucher.getCompany(), creator);
                VoucherFactory.getLocalInstance((Context)newCtx).submitVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
                voucher.setBizStatus(VoucherStatusEnum.SUBMITTED);
            }
            if (iCheckAFAudit == 1) {
                newCtx = this.buildContext(ctx, voucher.getCompany(), cashier);
                if (isCheckBizPerm) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                VoucherFactory.getLocalInstance((Context)newCtx).checkVoucher(voucher.getId().toString());
                voucher.setIsCheck(true);
            }
            if (VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus())) {
                if (auditor == null) {
                    auditor = ContextUtil.getCurrentUserInfo((Context)ctx);
                }
                newCtx = this.buildContext(ctx, voucher.getCompany(), auditor);
                if (isCheckBizPerm) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                VoucherFactory.getLocalInstance((Context)newCtx).auditVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), auditor.getId());
                voucher.setBizStatus(VoucherStatusEnum.AUDITTED);
            }
            if ((iCheckAFAudit == 2 || isCheckBFPost) && !voucher.isIsCheck()) {
                newCtx = this.buildContext(ctx, voucher.getCompany(), cashier);
                if (isCheckBizPerm) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                VoucherFactory.getLocalInstance((Context)newCtx).checkVoucher(voucher.getId().toString());
                voucher.setIsCheck(true);
            }
            newCtx = this.buildContext(ctx, voucher.getCompany(), poster);
            if (isCheckBizPerm) {
                ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            }
        } else {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.POST);
        }
        VoucherFactory.getLocalInstance((Context)newCtx).post((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
        voucher.setBizStatus(VoucherStatusEnum.POSTED);
        return null;
    }

    private String antiPostVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus())) {
            Object useWorkflow = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_032");
            boolean isUseWorkflow = Boolean.valueOf(useWorkflow.toString());
            if (isUseWorkflow && (useWorkflow = params.get("isUseWorkflow")) != null && useWorkflow.toString().trim().length() > 0 && "false".equalsIgnoreCase(useWorkflow.toString().trim())) {
                isUseWorkflow = false;
            }
            if (isUseWorkflow) {
                return this.getResource(ctx, "work_flow_started");
            }
        } else {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.ANTIPOST);
        }
        VoucherFactory.getLocalInstance((Context)ctx).antiPostVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
        return null;
    }

    private String antiAuditVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus()) && force) {
            Object useWorkflow = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_032");
            boolean isUseWorkflow = Boolean.valueOf(useWorkflow.toString());
            if (isUseWorkflow && (useWorkflow = params.get("isUseWorkflow")) != null && useWorkflow.toString().trim().length() > 0 && "false".equalsIgnoreCase(useWorkflow.toString().trim())) {
                isUseWorkflow = false;
            }
            if (isUseWorkflow) {
                return this.getResource(ctx, "work_flow_started");
            }
            if (VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus())) {
                VoucherFactory.getLocalInstance((Context)ctx).antiPostVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
                voucher.setBizStatus(VoucherStatusEnum.AUDITTED);
            }
            int iCheckAFAudit = 0;
            boolean isCheckBFPost = false;
            if (voucher.isHasCashAccount() && voucher.isIsCheck()) {
                Object checkBFPost;
                Object checkAFAudit = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_047");
                if (checkAFAudit != null) {
                    iCheckAFAudit = Integer.parseInt(checkAFAudit.toString());
                }
                if ((checkBFPost = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_046")) != null) {
                    isCheckBFPost = Boolean.valueOf(checkBFPost.toString());
                }
            }
            if (voucher.isHasCashAccount() && voucher.isIsCheck() && (iCheckAFAudit == 2 || isCheckBFPost)) {
                VoucherFactory.getLocalInstance((Context)ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
                voucher.setIsCheck(false);
            }
            if (VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus())) {
                VoucherFactory.getLocalInstance((Context)ctx).antiAuditVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
            }
            if (voucher.isHasCashAccount() && voucher.isIsCheck() && iCheckAFAudit == 1) {
                VoucherFactory.getLocalInstance((Context)ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
                voucher.setIsCheck(false);
            }
        } else {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.ANTIAUDIT);
        }
        return null;
    }

    private String deleteVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.CANCELLED.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus()) && force || VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus()) && force) {
            if (VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus())) {
                Object useWorkflow = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_032");
                boolean isUseWorkflow = Boolean.valueOf(useWorkflow.toString());
                if (isUseWorkflow && (useWorkflow = params.get("isUseWorkflow")) != null && useWorkflow.toString().trim().length() > 0 && "false".equalsIgnoreCase(useWorkflow.toString().trim())) {
                    isUseWorkflow = false;
                }
                if (isUseWorkflow) {
                    return this.getResource(ctx, "work_flow_started");
                }
            }
            if (VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus())) {
                VoucherFactory.getLocalInstance((Context)ctx).antiPostVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
                voucher.setBizStatus(VoucherStatusEnum.AUDITTED);
            }
            int iCheckAFAudit = 0;
            boolean isCheckBFPost = false;
            if (voucher.isHasCashAccount() && voucher.isIsCheck()) {
                Object checkBFPost;
                Object checkAFAudit = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_047");
                if (checkAFAudit != null) {
                    iCheckAFAudit = Integer.parseInt(checkAFAudit.toString());
                }
                if ((checkBFPost = VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_046")) != null) {
                    isCheckBFPost = Boolean.valueOf(checkBFPost.toString());
                }
            }
            if (voucher.isHasCashAccount() && voucher.isIsCheck() && (iCheckAFAudit == 2 || isCheckBFPost)) {
                VoucherFactory.getLocalInstance((Context)ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
                voucher.setIsCheck(false);
            }
            if (VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus())) {
                VoucherFactory.getLocalInstance((Context)ctx).antiAuditVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
            }
            if (voucher.isHasCashAccount() && voucher.isIsCheck() && iCheckAFAudit == 1) {
                VoucherFactory.getLocalInstance((Context)ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
                voucher.setIsCheck(false);
            }
        } else {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.DELETE);
        }
        VoucherFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(voucher.getId()), SystemEnum.GENERALLEDGER);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (!voucher.isHasCashAccount() || voucher.isIsCheck()) return this.getResource(ctx, "not_need_check");
        if (!VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus()) && !VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus()) && !VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus())) return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.CHECK);
        boolean isCheckBizPerm = (Boolean)params.get("isCheckBizPerm");
        UserInfo cashier = null;
        Object param = this.getParam(params, "nCashier");
        if (param != null && (cashier = this.getUser(ctx, param.toString().trim())) == null) {
            return this.getResource(ctx, "can_not_find_cheker");
        }
        Context newCtx = this.buildContext(ctx, voucher.getCompany(), cashier);
        if (isCheckBizPerm) {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        }
        VoucherFactory.getLocalInstance((Context)newCtx).checkVoucher(voucher.getId().toString());
        return null;
    }

    private String antiCheckVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (voucher.isHasCashAccount() && voucher.isIsCheck()) {
            if (!(VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus()) || VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus()))) {
                return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.ANTICHECK);
            }
        } else {
            return this.getResource(ctx, "not_need_uncheck");
        }
        VoucherFactory.getLocalInstance((Context)ctx).antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
        return null;
    }

    private String cancelVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (!VoucherStatusEnum.SUBMITTED.equals((Object)voucher.getBizStatus())) {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.CANCLE);
        }
        VoucherFactory.getLocalInstance((Context)ctx).cancelVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()));
        return null;
    }

    private String antiCancelVoucher(Context ctx, VoucherInfo voucher, boolean force, Map<String, Object> params) throws BOSException, EASBizException {
        if (!VoucherStatusEnum.CANCELLED.equals((Object)voucher.getBizStatus())) {
            return this.checkStatusAndOperate(voucher.getBizStatus(), VoucherOperateStatusEnum.ANTICANCLE);
        }
        VoucherFactory.getLocalInstance((Context)ctx).antiCancelVoucher((IObjectPK)new ObjectUuidPK(voucher.getId()), null);
        return null;
    }

    public String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    static {
        OPERATES.add(OPERATE_SUBMIT);
        OPERATES.add(OPERATE_AUDIT);
        OPERATES.add(OPERATE_POST);
        OPERATES.add(OPERATE_ANTIPOST);
        OPERATES.add(OPERATE_ANTIAUDIT);
        OPERATES.add(OPERATE_DELETE);
        OPERATES.add(OPERATE_CHECK);
        OPERATES.add(OPERATE_ANTICHECK);
        OPERATES.add(OPERATE_CANCEL);
        OPERATES.add(OPERATE_ANTICANCEL);
        voucherStatus = new boolean[][]{{true, false, false, false, false, false}, {true, false, false, false, false, false}, {true, true, true, false, false, false}, {false, true, false, false, true, false}, {false, false, false, true, false, false}, {false, true, false, true, false, true}, {false, true, false, true, true, true}, {false, false, false, true, false, false}, {false, false, false, false, false, true}, {false, true, false, false, false, false}, {false, false, true, false, false, false}, {false, false, false, false, false, true}};
    }
}

