/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleEntryFactory;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.DirectionType;
import com.kingdee.eas.base.codingrule.ICodingRuleEntry;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IVoucherTypeCtrlItem;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemType;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlLevelFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlLevelInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.IMainAsstOrgRelation;
import com.kingdee.eas.fi.books.MainAsstOrgRelationCollection;
import com.kingdee.eas.fi.books.MainAsstOrgRelationFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowSplitRecord;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReqStatus;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VchAmortSchemeInfo;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.RegisteredServiceUtil;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.IPropertyContainer;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VoucherUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherUtil");

    public static Object[] reorganizeCtrlItems(VoucherTypeCtrlItemCollection ciCol) {
        Object[] result = new Object[7];
        HashMap debitMust = new HashMap();
        HashMap creditMust = new HashMap();
        HashMap debitOrCreditMust = new HashMap();
        HashMap debitNot = new HashMap();
        HashMap creditNot = new HashMap();
        HashMap debitAndCreditNot = new HashMap();
        if (ciCol != null) {
            for (VoucherTypeCtrlItemInfo ctrlItem : ciCol) {
                VoucherTypeCtrlItemType t = ctrlItem.getType();
                if (VoucherTypeCtrlItemType.DEBIT_MUST.equals((Object)t)) {
                    debitMust.put(ctrlItem.getAccount().getLongNumber(), null);
                    continue;
                }
                if (VoucherTypeCtrlItemType.CREDIT_MUST.equals((Object)t)) {
                    creditMust.put(ctrlItem.getAccount().getLongNumber(), null);
                    continue;
                }
                if (VoucherTypeCtrlItemType.DEBIT_OR_CREDIT_MUST.equals((Object)t)) {
                    debitOrCreditMust.put(ctrlItem.getAccount().getLongNumber(), null);
                    continue;
                }
                if (VoucherTypeCtrlItemType.DEBIT_MUST_NOT.equals((Object)t)) {
                    debitNot.put(ctrlItem.getAccount().getLongNumber(), null);
                    continue;
                }
                if (VoucherTypeCtrlItemType.CREDIT_MUST_NOT.equals((Object)t)) {
                    creditNot.put(ctrlItem.getAccount().getLongNumber(), null);
                    continue;
                }
                if (!VoucherTypeCtrlItemType.DEBIT_AND_CREDIT_MUST_NOT.equals((Object)t)) continue;
                debitAndCreditNot.put(ctrlItem.getAccount().getLongNumber(), null);
            }
        }
        if (debitMust.size() == 0) {
            debitMust = null;
        }
        if (creditMust.size() == 0) {
            creditMust = null;
        }
        if (debitOrCreditMust.size() == 0) {
            debitOrCreditMust = null;
        }
        if (debitNot.size() == 0) {
            debitNot = null;
        }
        if (creditNot.size() == 0) {
            creditNot = null;
        }
        if (debitAndCreditNot.size() == 0) {
            debitAndCreditNot = null;
        }
        result[0] = ciCol;
        result[1] = debitMust;
        result[2] = creditMust;
        result[3] = debitOrCreditMust;
        result[4] = debitNot;
        result[5] = creditNot;
        result[6] = debitAndCreditNot;
        return result;
    }

    public static boolean closeInit(Context ctx, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        String curCompanyID = curCompany.getId().toString();
        AccountTools.checkCompanyAccountTable((Context)ctx, (CompanyOrgUnitInfo)curCompany);
        String accounttableid = curCompany.getAccountTable().getId().toString();
        return VoucherUtil.closeInit(ctx, curCompanyID, accounttableid);
    }

    public static boolean closeInit(Context ctx, String curCompanyID, String accounttableid) throws BOSException {
        String sql = " select 1 from t_bd_systemstatus a ,t_bd_systemstatusctrol b  where a.fname=6 and b.fsystemstatusid=a.fid and b.fcompanyid=?  and b.fstartperiodid=b.fcurrentperiodid";
        boolean isCur = false;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{curCompanyID});
        try {
            if (set.next()) {
                isCur = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!isCur) {
            try {
                InitHelp.doColseInit(ctx, curCompanyID, accounttableid);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            return false;
        }
        return !isCur;
    }

    public static boolean hasCancelCodingRule(Context ctx, String curCompanyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompanyID));
        VoucherInfo info = new VoucherInfo();
        info.setBizStatus(VoucherStatusEnum.CANCELLED);
        info.setCompany(company);
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)info, curCompanyID, "bizStatus");
    }

    public static void midifyVoucherNumber(Context ctx, String vchId, String oldNumber, String newNumber) throws BOSException, EASBizException {
        HashMap<String, String[]> voucherMap = new HashMap<String, String[]>();
        String[] voucherNumbers = new String[]{oldNumber, newNumber};
        voucherMap.put(vchId, voucherNumbers);
        VoucherUtil.modifyVoucherNumberBatch(ctx, voucherMap);
    }

    public static void modifyVoucherNumberBatch(Context ctx, Map voucherMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement psUpdateVoucherDesc = null;
        PreparedStatement psUpdateRevVoucher = null;
        PreparedStatement psUpdateRevVoucher2 = null;
        PreparedStatement psUpdateRevVoucherEntry = null;
        PreparedStatement psUpdateHist = null;
        PreparedStatement psUpdateAcctCussent = null;
        PreparedStatement psUpdateAcctVerify = null;
        PreparedStatement psUpdateReq = null;
        PreparedStatement psUpdateReqEntry = null;
        PreparedStatement psReUpdateReq = null;
        PreparedStatement psUpdateJou = null;
        PreparedStatement psUpdateJouEntry = null;
        PreparedStatement psUpdateVoucherModifier = null;
        int BatchSize = 500;
        int count = 0;
        String updateVoucherDesc = "update t_gl_voucher set fdescription= substring(replace(fdescription, ?, ?),0,255) where fid=? and fdescription is not null";
        String updateRevVoucher = "update t_gl_voucher set  fdescription= replace(fdescription, ?, ?) where fsourcebillid=?  and fdescription is not null";
        String updateRevVoucher2 = "update t_gl_voucher set  fabstract= replace(fabstract, ?, ?)  where fsourcebillid=?  and fabstract is not null";
        String updateRevVoucherEntry = "update t_gl_voucherentry set  fdescription= replace(fdescription, ?, ?)  where fbillid in (select fid from t_gl_voucher where fsourcebillid=?) and fdescription is not null ";
        String updateHist = "update T_GL_AcctCussentHistory set  FVchNumber=? where FVoucherAsstIDID in ( select fid from t_gl_voucherassistrecord where fbillid =? )";
        String updateAcctCussent = "update t_gl_acctcussent set fvchnumber = ? where FVOUCHERID = ? ";
        String updateAcctVerify = "update t_gl_acctverify set fvchnumber = ? where FVOUCHERID = ? ";
        String updateReq = "update T_CSL_Requisition set FVchNumber=replace(FVchNumber, ?, ?) , FNumber= concat('$reqNum$',replace(FNumber, ?, ?)) where FVoucherID=? ";
        String updateReqEntry = "update T_CSL_RequisitionEntry set fvchnumber= replace(fvchnumber, ?, ?) where fchecknumber in ( select rtrim(fchecknumber) from t_gl_voucherassistrecord where fbillid = ?)";
        String reUpdateReq = "update T_CSL_Requisition set FNumber= replace(FNumber,'$reqNum$','') where FVoucherID = ?";
        String updateJou = "update t_cas_journal set fbillNumber=?, fvoucherNumber=?  where fbillid=?";
        String updateJouEntry = "update t_cas_journal set fbillNumber=?, fvoucherNumber=?  where fbillid in (select fid from t_gl_voucherentry where fbillid=? )";
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = user.getId().toString();
        String updateVoucherModifier = "update t_gl_voucher set flastupdatetime = ?, flastupdateuserid = ? where fid = ?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psUpdateVoucherDesc = conn.prepareStatement(updateVoucherDesc);
            psUpdateRevVoucher = conn.prepareStatement(updateRevVoucher);
            psUpdateRevVoucher2 = conn.prepareStatement(updateRevVoucher2);
            psUpdateRevVoucherEntry = conn.prepareStatement(updateRevVoucherEntry);
            psUpdateHist = conn.prepareStatement(updateHist);
            psUpdateAcctCussent = conn.prepareStatement(updateAcctCussent);
            psUpdateAcctVerify = conn.prepareStatement(updateAcctVerify);
            psUpdateReq = conn.prepareStatement(updateReq);
            psUpdateReqEntry = conn.prepareStatement(updateReqEntry);
            psReUpdateReq = conn.prepareStatement(reUpdateReq);
            psUpdateJou = conn.prepareStatement(updateJou);
            psUpdateJouEntry = conn.prepareStatement(updateJouEntry);
            psUpdateVoucherModifier = conn.prepareStatement(updateVoucherModifier);
            Iterator it = voucherMap.keySet().iterator();
            while (it.hasNext()) {
                String oldNumber;
                String vchId = it.next().toString();
                String[] values = (String[])voucherMap.get(vchId);
                String newNumber = values[1];
                if (newNumber.equals(oldNumber = values[0])) continue;
                psUpdateVoucherDesc.setString(1, oldNumber);
                psUpdateVoucherDesc.setString(2, newNumber);
                psUpdateVoucherDesc.setString(3, vchId);
                psUpdateVoucherDesc.addBatch();
                psUpdateRevVoucher.setString(1, oldNumber);
                psUpdateRevVoucher.setString(2, newNumber);
                psUpdateRevVoucher.setString(3, vchId);
                psUpdateRevVoucher.addBatch();
                psUpdateRevVoucher2.setString(1, oldNumber);
                psUpdateRevVoucher2.setString(2, newNumber);
                psUpdateRevVoucher2.setString(3, vchId);
                psUpdateRevVoucher2.addBatch();
                psUpdateRevVoucherEntry.setString(1, oldNumber);
                psUpdateRevVoucherEntry.setString(2, newNumber);
                psUpdateRevVoucherEntry.setString(3, vchId);
                psUpdateRevVoucherEntry.addBatch();
                psUpdateHist.setString(1, newNumber);
                psUpdateHist.setString(2, vchId);
                psUpdateHist.addBatch();
                psUpdateAcctCussent.setString(1, newNumber);
                psUpdateAcctCussent.setString(2, vchId);
                psUpdateAcctCussent.addBatch();
                psUpdateAcctVerify.setString(1, newNumber);
                psUpdateAcctVerify.setString(2, vchId);
                psUpdateAcctVerify.addBatch();
                psUpdateReq.setString(1, oldNumber);
                psUpdateReq.setString(2, newNumber);
                psUpdateReq.setString(3, oldNumber);
                psUpdateReq.setString(4, newNumber);
                psUpdateReq.setString(5, vchId);
                psUpdateReq.addBatch();
                psUpdateReqEntry.setString(1, oldNumber);
                psUpdateReqEntry.setString(2, newNumber);
                psUpdateReqEntry.setString(3, vchId);
                psUpdateReqEntry.addBatch();
                psReUpdateReq.setString(1, vchId);
                psReUpdateReq.addBatch();
                psUpdateJou.setString(1, newNumber);
                psUpdateJou.setString(2, newNumber);
                psUpdateJou.setString(3, vchId);
                psUpdateJou.addBatch();
                psUpdateJouEntry.setString(1, newNumber);
                psUpdateJouEntry.setString(2, newNumber);
                psUpdateJouEntry.setString(3, vchId);
                psUpdateJouEntry.addBatch();
                psUpdateVoucherModifier.setTimestamp(1, GlUtils.getTime());
                psUpdateVoucherModifier.setString(2, userId);
                psUpdateVoucherModifier.setString(3, vchId);
                if (++count < 500) continue;
                count = 0;
                psUpdateVoucherDesc.executeBatch();
                psUpdateVoucherDesc.clearBatch();
                psUpdateRevVoucher.executeBatch();
                psUpdateRevVoucher.clearBatch();
                psUpdateRevVoucher2.executeBatch();
                psUpdateRevVoucher2.clearBatch();
                psUpdateRevVoucherEntry.executeBatch();
                psUpdateRevVoucherEntry.clearBatch();
                psUpdateHist.executeBatch();
                psUpdateHist.clearBatch();
                psUpdateAcctCussent.executeBatch();
                psUpdateAcctCussent.clearBatch();
                psUpdateAcctVerify.executeBatch();
                psUpdateAcctVerify.clearBatch();
                psUpdateReq.executeBatch();
                psUpdateReq.clearBatch();
                psUpdateReqEntry.executeBatch();
                psUpdateReqEntry.clearBatch();
                psReUpdateReq.executeBatch();
                psReUpdateReq.clearBatch();
                psUpdateJou.executeBatch();
                psUpdateJou.clearBatch();
                psUpdateJouEntry.executeBatch();
                psUpdateJouEntry.clearBatch();
                psUpdateVoucherModifier.executeBatch();
                psUpdateVoucherModifier.clearBatch();
            }
            if (count > 0) {
                psUpdateVoucherDesc.executeBatch();
                psUpdateVoucherDesc.clearBatch();
                psUpdateRevVoucher.executeBatch();
                psUpdateRevVoucher.clearBatch();
                psUpdateRevVoucher2.executeBatch();
                psUpdateRevVoucher2.clearBatch();
                psUpdateRevVoucherEntry.executeBatch();
                psUpdateRevVoucherEntry.clearBatch();
                psUpdateHist.executeBatch();
                psUpdateHist.clearBatch();
                psUpdateAcctCussent.executeBatch();
                psUpdateAcctCussent.clearBatch();
                psUpdateAcctVerify.executeBatch();
                psUpdateAcctVerify.clearBatch();
                psUpdateReq.executeBatch();
                psUpdateReq.clearBatch();
                psUpdateReqEntry.executeBatch();
                psUpdateReqEntry.clearBatch();
                psReUpdateReq.executeBatch();
                psReUpdateReq.clearBatch();
                psUpdateJou.executeBatch();
                psUpdateJou.clearBatch();
                psUpdateJouEntry.executeBatch();
                psUpdateJouEntry.clearBatch();
                psUpdateVoucherModifier.executeBatch();
                psUpdateVoucherModifier.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psUpdateVoucherDesc, (Connection)conn);
                SQLUtils.cleanup(psUpdateRevVoucher, (Connection)conn);
                SQLUtils.cleanup(psUpdateRevVoucher2, (Connection)conn);
                SQLUtils.cleanup(psUpdateRevVoucherEntry, (Connection)conn);
                SQLUtils.cleanup(psUpdateHist, (Connection)conn);
                SQLUtils.cleanup(psUpdateAcctCussent, (Connection)conn);
                SQLUtils.cleanup(psUpdateAcctVerify, (Connection)conn);
                SQLUtils.cleanup(psUpdateReq, (Connection)conn);
                SQLUtils.cleanup(psUpdateReqEntry, (Connection)conn);
                SQLUtils.cleanup(psReUpdateReq, (Connection)conn);
                SQLUtils.cleanup(psUpdateJou, (Connection)conn);
                SQLUtils.cleanup(psUpdateJouEntry, (Connection)conn);
                SQLUtils.cleanup(psUpdateVoucherModifier, (Connection)conn);
                SQLUtils.cleanup((Connection)conn);
                psUpdateVoucherDesc = null;
                psUpdateRevVoucher = null;
                psUpdateRevVoucher2 = null;
                psUpdateRevVoucherEntry = null;
                psUpdateHist = null;
                psUpdateAcctCussent = null;
                psUpdateAcctVerify = null;
                psUpdateReq = null;
                psUpdateReqEntry = null;
                psReUpdateReq = null;
                psUpdateJou = null;
                psUpdateJouEntry = null;
                conn = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psUpdateVoucherDesc, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateRevVoucher, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateRevVoucher2, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateRevVoucherEntry, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateHist, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateAcctCussent, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateAcctVerify, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateReq, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateReqEntry, (Connection)conn);
        SQLUtils.cleanup((Statement)psReUpdateReq, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateJou, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateJouEntry, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdateVoucherModifier, (Connection)conn);
        SQLUtils.cleanup((Connection)conn);
        psUpdateVoucherDesc = null;
        psUpdateRevVoucher = null;
        psUpdateRevVoucher2 = null;
        psUpdateRevVoucherEntry = null;
        psUpdateHist = null;
        psUpdateAcctCussent = null;
        psUpdateAcctVerify = null;
        psUpdateReq = null;
        psUpdateReqEntry = null;
        psReUpdateReq = null;
        psUpdateJou = null;
        psUpdateJouEntry = null;
        conn = null;
        VoucherUtil.batchVoucherNumberChanged(ctx, voucherMap);
    }

    public static boolean isAssociationCashManagement(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String strValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "CS001");
        if (strValue == null || strValue.length() == 0) {
            return false;
        }
        int bookType = Integer.parseInt(strValue);
        if (bookType != 1) {
            return false;
        }
        return SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
    }

    public static boolean _checkHasTransfered(Context ctx, String vchid, String bookid) throws EASBizException, BOSException {
        return BookUtil._checkHasTransfered(ctx, vchid, bookid);
    }

    public static IObjectPK _addnewVoucher(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setIsCussent(false);
        voucherInfo.setIsAccountCopy(true);
        voucherInfo.setSourceType(SourceType.OTHER_ACCOUNT);
        ServiceStateManager.getInstance().enableNextCallServices();
        voucherInfo.put("id", null);
        IObjectPK voucherPK = VoucherFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)voucherInfo);
        voucherInfo.put("id", voucherPK.getKeyValue("id"));
        VoucherUtil.saveImportKey(ctx, voucherInfo, voucherPK.toString());
        VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        Iterator iteratorEntry = voucherEntryCollection.iterator();
        Connection cn = null;
        Statement ps = null;
        try {
            CashflowSplitRecordCollection cashflowSplitRecordCollection;
            cn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iVoucherEntry = ORMappingDAO.getInstance((BOSObjectType)new VoucherEntryInfo().getBOSType(), (Context)ctx, (Connection)cn);
            IORMappingDAO iVoucherAssistRecord = ORMappingDAO.getInstance((BOSObjectType)new VoucherAssistRecordInfo().getBOSType(), (Context)ctx, (Connection)cn);
            VoucherEntryInfo voucherEntryInfo = null;
            VoucherAssistRecordCollection voucherAssistRecordCollection = null;
            IMainAsstOrgRelation iMainAsstOrgRelation = MainAsstOrgRelationFactory.getLocalInstance((Context)ctx);
            IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            HashMap<BOSUuid, AsstActTypeCollection> asstAccMap = new HashMap<BOSUuid, AsstActTypeCollection>();
            boolean existCompanyOrg = false;
            AssistantHGCollection hgColl = null;
            MainAsstOrgRelationCollection relColl = null;
            while (iteratorEntry.hasNext()) {
                voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
                voucherEntryInfo.setCompany(voucherInfo.getCompany());
                voucherEntryInfo.setPeriod(voucherInfo.getPeriod());
                voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                VoucherAssistRecordInfo voucherAssistRecordInfo = null;
                voucherEntryInfo.setBill(voucherInfo);
                voucherEntryInfo.setId(BOSUuid.create((BOSObjectType)voucherEntryInfo.getBOSType()));
                iVoucherEntry.addNewBatch((IObjectValue)voucherEntryInfo);
                if (voucherEntryInfo.getCAA() == null && !voucherEntryInfo.getAccount().isHasUserProperty()) continue;
                AsstActTypeCollection types = null;
                if (voucherEntryInfo.getCAA() != null) {
                    int i;
                    if (asstAccMap.get(voucherEntryInfo.getCAA().getId()) == null) {
                        types = new AsstActTypeCollection();
                        Vector vec = iAsstAccount.getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(voucherEntryInfo.getCAA().getId().toString()));
                        int n = vec.size();
                        for (i = 0; i < n; ++i) {
                            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)vec.get(i);
                            types.add(asstActTypeInfo);
                        }
                        asstAccMap.put(voucherEntryInfo.getCAA().getId(), types);
                    } else {
                        types = (AsstActTypeCollection)asstAccMap.get(voucherEntryInfo.getCAA().getId());
                    }
                    existCompanyOrg = false;
                    EntityViewInfo view = new EntityViewInfo();
                    for (i = 0; i < types.size(); ++i) {
                        view.getSelector().add(new SelectorItemInfo(types.get(i).getAsstHGAttribute() + ".id"));
                        if (!"companyOrg".equals(types.get(i).getAsstHGAttribute())) continue;
                        existCompanyOrg = true;
                    }
                    hgColl = null;
                    relColl = null;
                    if (existCompanyOrg) {
                        view.getSelector().add(new SelectorItemInfo("id"));
                        FilterInfo filter = new FilterInfo();
                        HashSet<String> hgIdSet = new HashSet<String>();
                        for (int i2 = 0; i2 < voucherAssistRecordCollection.size(); ++i2) {
                            hgIdSet.add(voucherAssistRecordCollection.get(i2).getAssGrp().getId().toString());
                        }
                        filter.getFilterItems().add(new FilterItemInfo("id", hgIdSet, CompareType.INCLUDE));
                        view.setFilter(filter);
                        hgColl = iAssistantHG.getAssistantHGCollection(view);
                        HashSet<String> orgIdSet = new HashSet<String>();
                        for (int i3 = 0; i3 < hgColl.size(); ++i3) {
                            if (hgColl.get(i3).getCompanyOrg() == null) continue;
                            orgIdSet.add(hgColl.get(i3).getCompanyOrg().getId().toString());
                        }
                        view = new EntityViewInfo();
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", orgIdSet, CompareType.INCLUDE));
                        filter.getFilterItems().add(new FilterItemInfo("asstOrg.id", null, CompareType.NOTEQUALS));
                        view.setFilter(filter);
                        relColl = iMainAsstOrgRelation.getMainAsstOrgRelationCollection(view);
                    }
                }
                while (iteratorAssist.hasNext()) {
                    voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                    voucherAssistRecordInfo.setCompany(voucherInfo.getCompany());
                    voucherAssistRecordInfo.setPeriod(voucherInfo.getPeriod());
                    voucherAssistRecordInfo.setAccount(voucherEntryInfo.getAccount());
                    voucherAssistRecordInfo.setOprStatus(1);
                    voucherAssistRecordInfo.setReqStatus(ReqStatus.NONE);
                    voucherAssistRecordInfo.setEntry(voucherEntryInfo);
                    voucherAssistRecordInfo.setBill(voucherInfo);
                    voucherAssistRecordInfo.setId(BOSUuid.create((BOSObjectType)voucherAssistRecordInfo.getBOSType()));
                    if (voucherEntryInfo.getCAA() != null && existCompanyOrg && hgColl != null) {
                        block11: for (int i = 0; i < hgColl.size(); ++i) {
                            if (!voucherAssistRecordInfo.getAssGrp().getId().equals((Object)hgColl.get(i).getId())) continue;
                            if (hgColl.get(i).getCompanyOrg() == null) break;
                            for (int j = 0; j < relColl.size(); ++j) {
                                if (relColl.get(j).getAsstOrg() == null || !relColl.get(j).getMainOrg().getId().equals((Object)hgColl.get(i).getCompanyOrg().getId())) continue;
                                AssistantHGInfo hg = (AssistantHGInfo)hgColl.get(i).clone();
                                hg.setId(null);
                                hg.put("companyOrg", (Object)relColl.get(j).getAsstOrg());
                                hg.setAsstAccount(voucherEntryInfo.getCAA());
                                voucherAssistRecordInfo.setAssGrp(iAssistantHG.getAssistantHG(hg, voucherEntryInfo.getCAA().getId().toString(), types));
                                break block11;
                            }
                            break;
                        }
                    }
                    iVoucherAssistRecord.addNewBatch((IObjectValue)voucherAssistRecordInfo);
                }
            }
            iVoucherEntry.executeBatch();
            iVoucherAssistRecord.executeBatch();
            CashflowRecordCollection cashflowRecordCollection = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
            if (cashflowRecordCollection != null && cashflowRecordCollection.size() > 0) {
                IORMappingDAO iCashflowRecord = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)cn);
                for (CashflowRecordInfo cashflowRecordInfo : cashflowRecordCollection) {
                    CashFlowItemInfo pi = cashflowRecordInfo.getPrimaryItem();
                    if (ItemFlag.ADJUST.equals((Object)cashflowRecordInfo.getItemFlag())) continue;
                    if (pi != null && pi.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{pi.getNumber()});
                    }
                    if (cashflowRecordInfo.getAssGrp() != null) {
                        int i;
                        EntityViewInfo evi = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        if (pi.getAsstAccount() != null) {
                            filterInfo.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)pi.getAsstAccount().getId().toString(), CompareType.EQUALS));
                        }
                        evi.setFilter(filterInfo);
                        evi.getSelector().add(new SelectorItemInfo("asstActType.id"));
                        evi.getSelector().add(new SelectorItemInfo("asstActType.number"));
                        evi.getSelector().add(new SelectorItemInfo("asstActType.name"));
                        evi.getSelector().add(new SelectorItemInfo("asstActType.asstHGAttribute"));
                        evi.getSelector().add(new SelectorItemInfo("asstActType.useLongNumber"));
                        evi.getSelector().add(new SelectorItemInfo("asstActType.mappingFieldName"));
                        evi.getSelector().add(new SelectorItemInfo("asstActType.groupTableName"));
                        IAsstActGroupDetail iasstActGroupDt = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
                        EntityViewInfo view = new EntityViewInfo();
                        AsstActTypeCollection types = new AsstActTypeCollection();
                        if (pi.getAsstAccount() != null) {
                            AsstActGroupDetailCollection detailCol = iasstActGroupDt.getAsstActGroupDetailCollection(evi);
                            AsstActTypeInfo type = null;
                            for (i = 0; i < detailCol.size(); ++i) {
                                type = detailCol.get(i).getAsstActType();
                                types.add(detailCol.get(i).getAsstActType());
                                view.getSelector().add(new SelectorItemInfo(type.getAsstHGAttribute() + ".id"));
                                if (!"companyOrg".equals(type.getAsstHGAttribute())) continue;
                                existCompanyOrg = true;
                            }
                        }
                        hgColl = null;
                        relColl = null;
                        if (existCompanyOrg) {
                            view.getSelector().add(new SelectorItemInfo("id"));
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("id", (Object)cashflowRecordInfo.getAssGrp().getId().toString(), CompareType.EQUALS));
                            view.setFilter(filter);
                            hgColl = iAssistantHG.getAssistantHGCollection(view);
                            HashSet<String> orgIdSet = new HashSet<String>();
                            for (i = 0; i < hgColl.size(); ++i) {
                                if (hgColl.get(i).getCompanyOrg() == null) continue;
                                orgIdSet.add(hgColl.get(i).getCompanyOrg().getId().toString());
                            }
                            view = new EntityViewInfo();
                            filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", orgIdSet, CompareType.INCLUDE));
                            filter.getFilterItems().add(new FilterItemInfo("asstOrg.id", null, CompareType.NOTEQUALS));
                            view.setFilter(filter);
                            relColl = iMainAsstOrgRelation.getMainAsstOrgRelationCollection(view);
                            block16: for (i = 0; i < hgColl.size(); ++i) {
                                if (!cashflowRecordInfo.getAssGrp().getId().equals((Object)hgColl.get(i).getId())) continue;
                                if (hgColl.get(i).getCompanyOrg() == null) break;
                                for (int j = 0; j < relColl.size(); ++j) {
                                    if (relColl.get(j).getAsstOrg() == null || !relColl.get(j).getMainOrg().getId().equals((Object)hgColl.get(i).getCompanyOrg().getId())) continue;
                                    AssistantHGInfo hg = (AssistantHGInfo)hgColl.get(i).clone();
                                    hg.setId(null);
                                    hg.put("companyOrg", (Object)relColl.get(j).getAsstOrg());
                                    hg.setAsstAccount(pi.getAsstAccount());
                                    cashflowRecordInfo.setAssGrp(iAssistantHG.getAssistantHG(hg, pi.getAsstAccount().getId().toString(), types));
                                    break block16;
                                }
                                break;
                            }
                        }
                    }
                    cashflowRecordInfo.setAccount(cashflowRecordInfo.getEntry().getAccount());
                    cashflowRecordInfo.setEntryDC(cashflowRecordInfo.getEntry().getEntryDC());
                    cashflowRecordInfo.setOppAccount(cashflowRecordInfo.getOpposingAccountEntry().getAccount());
                    cashflowRecordInfo.setOppEntryDC(cashflowRecordInfo.getOpposingAccountEntry().getEntryDC());
                    CashFlowItemInfo si = cashflowRecordInfo.getSupplementaryItem();
                    if (si != null && si.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{si.getNumber()});
                    }
                    cashflowRecordInfo.setVoucher(voucherInfo);
                    if (voucherInfo.isPostedByUI()) {
                        cashflowRecordInfo.setId(null);
                    }
                    iCashflowRecord.addnew((IObjectValue)cashflowRecordInfo);
                }
            }
            if ((cashflowSplitRecordCollection = (CashflowSplitRecordCollection)voucherInfo.getCashflowSplitRecordCollection()) != null && cashflowSplitRecordCollection.size() > 0) {
                ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy("default");
                CashflowSplitRecordCollection splitResult = strategy.split(ctx, voucherInfo, new HashMap<String, Object>());
                ICashflowSplitRecord cfSplit = CashflowSplitRecordFactory.getLocalInstance(ctx);
                cfSplit.addBatch((IObjectCollection)splitResult);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)cn);
        }
        return voucherPK;
    }

    private static void saveImportKey(Context ctx, VoucherInfo voucherInfo, String voucherId) throws BOSException {
        String importKey = voucherInfo.getString("importKey");
        if (importKey != null && importKey.trim().length() > 0) {
            String sql = "insert into T_GL_VoucherImportKey (FVoucherID, FImportKey) values (?, ?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherId, importKey.trim()});
        }
    }

    public static void saveBOTRelationInfo(Context ctx, String srcVchId, IObjectPK pk, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        fic.add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        fic.add(new FilterItemInfo("srcObjectID", (Object)srcVchId));
        fic.add(new FilterItemInfo("destObjectID", (Object)pk.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col == null || col.size() == 0) {
            BOTRelationInfo bot = null;
            bot = new BOTRelationInfo();
            bot.setSrcEntityID(type.toString());
            bot.setDestEntityID(type.toString());
            bot.setSrcObjectID(srcVchId);
            bot.setOperatorID(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            bot.setDestObjectID(pk.toString());
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(bot);
        }
    }

    public static void _removeBotRelation(Context ctx, String srcVchId, String destId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcVchId));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col != null) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = col.get(i);
                BOTRelationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(bot.getId().toString()));
            }
        }
    }

    public static void _removeBotRelation(Context ctx, String destId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col != null) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = col.get(i);
                BOTRelationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(bot.getId().toString()));
            }
        }
    }

    public static BOTRelationCollection _getBotRelation(Context ctx, String destVchId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destVchId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col;
    }

    public static VoucherTypeCtrlItemCollection getVoucherTypeCtrlItemCollection(Context ctx, String voucherTypeId, String companyId) throws BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getVoucherTypeCtrlItem().get(voucherTypeId + companyId) != null) {
            return (VoucherTypeCtrlItemCollection)cache.getVoucherTypeCtrlItem().get(voucherTypeId + companyId);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
        fic.add(new FilterItemInfo("company.id", (Object)companyId));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("type"));
        sorters.add(new SorterItemInfo("account.number"));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.longNumber"));
        IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
        VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
        if (cache != null) {
            cache.getVoucherTypeCtrlItem().put(voucherTypeId + companyId, ciCol);
        }
        return ciCol;
    }

    public static boolean isExistedVoucherType(Context ctx, String cuId, String voucherTypeId) throws EASBizException, BOSException {
        boolean isExist;
        if (cuId == null) {
            cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        String key = cuId + (voucherTypeId == null ? "" : voucherTypeId);
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getVoucherTypes().get(key) != null) {
            return (Boolean)cache.getVoucherTypes().get(key);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        FilterInfo filter = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU");
        if (voucherTypeId != null) {
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)voucherTypeId));
            filter.mergeFilter(newFilter, "AND");
        }
        view.setFilter(filter);
        VoucherTypeCollection vchTypeCol = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypeCollection(view);
        boolean bl = isExist = vchTypeCol != null && vchTypeCol.size() > 0;
        if (cache != null) {
            cache.getVoucherTypes().put(key, isExist);
        }
        return isExist;
    }

    public static VoucherTypeCollection getVoucherTypeCollection(Context ctx, String cuId, String voucherTypeId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        if (cuId == null || cuId.trim().length() == 0) {
            cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        FilterInfo filter = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU");
        if (voucherTypeId != null) {
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)voucherTypeId));
            filter.mergeFilter(newFilter, "AND");
        }
        view.setFilter(filter);
        return VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypeCollection(view);
    }

    public static VoucherTypeCtrlLevelInfo getVoucherTypeCtrlLevelInfo(Context ctx, String companyId, String voucherTypeId) throws BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getVoucherTypeCtrlLevel().get(voucherTypeId + companyId) != null) {
            Object obj = cache.getVoucherTypeCtrlLevel().get(voucherTypeId + companyId);
            if (obj instanceof VoucherTypeCtrlLevelInfo) {
                return (VoucherTypeCtrlLevelInfo)obj;
            }
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucherType", (Object)voucherTypeId));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        view.setFilter(filter);
        CoreBaseCollection collection = VoucherTypeCtrlLevelFactory.getLocalInstance((Context)ctx).getCollection(view);
        VoucherTypeCtrlLevelInfo info = null;
        if (collection != null && collection.size() > 0) {
            info = (VoucherTypeCtrlLevelInfo)collection.get(0);
        }
        if (cache != null) {
            if (info == null) {
                cache.getVoucherTypeCtrlLevel().put(voucherTypeId + companyId, "");
            } else {
                cache.getVoucherTypeCtrlLevel().put(voucherTypeId + companyId, info);
            }
        }
        return info;
    }

    public static void replaceAccount(Context ctx, String companyId, String accountTableId, VoucherEntryInfo entryInfo) throws BOSException, VoucherException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("cu.name"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("companyID.name"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("mainCashFlowItem.*"));
        sic.add(new SelectorItemInfo("attCashFlowItem.*"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        String accountNumber = entryInfo.getAccount().getNumber();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)accountNumber));
        fic.add(new FilterItemInfo("companyID.id", (Object)companyId));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        AccountViewCollection col = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (col == null || col.size() <= 0) {
            throw new VoucherException(VoucherException.NOTACCOUNTOFCUORACC, new String[]{String.valueOf(entryInfo.getSeq()), accountNumber});
        }
        entryInfo.setAccount(col.get(0));
    }

    private static void replaceAccount(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo;
        CompanyOrgUnitInfo org = voucherInfo.getCompany();
        if (org == null) {
            org = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (org.getAccountTable() == null || org.getAccountTable().getId() == null) {
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("id");
            sel.add("accountTable.id");
            CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()), sel);
            if (org.getAccountTable() == null) {
                org.setAccountTable(c.getAccountTable());
            } else {
                org.getAccountTable().setId(c.getAccountTable().getId());
            }
        }
        HashSet<String> accountIds = new HashSet<String>();
        for (VoucherEntryInfo entryInfo : voucherInfo.getEntries()) {
            if (entryInfo == null || entryInfo.getAccount() == null || (accountViewInfo = entryInfo.getAccount()).getCompanyID() != null && accountViewInfo.getAccountTableID() != null && accountViewInfo.getAccountTableID().getId() != null && accountViewInfo.getCompanyID().getId() != null && accountViewInfo.getNumber() != null) continue;
            accountIds.add(accountViewInfo.getId().toString());
        }
        if (accountIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("id");
            sel.add("number");
            sel.add("name");
            sel.add("companyID.id");
            sel.add("accountTableID.id");
            view.setSelector(sel);
            AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            HashMap<String, AccountViewInfo> accounts = new HashMap<String, AccountViewInfo>();
            for (AccountViewInfo account : coll) {
                accounts.put(account.getId().toString(), account);
            }
            for (VoucherEntryInfo entryInfo : voucherInfo.getEntries()) {
                AccountViewInfo accountViewInfo2;
                AccountViewInfo account;
                if (entryInfo == null || entryInfo.getAccount() == null || (account = (AccountViewInfo)accounts.get((accountViewInfo2 = entryInfo.getAccount()).getId().toString())) == null) continue;
                if (accountViewInfo2.getCompanyID() == null) {
                    accountViewInfo2.setCompanyID(account.getCompanyID());
                } else {
                    accountViewInfo2.getCompanyID().setId(account.getCompanyID().getId());
                }
                if (accountViewInfo2.getAccountTableID() == null) {
                    accountViewInfo2.setAccountTableID(account.getAccountTableID());
                } else {
                    accountViewInfo2.getAccountTableID().setId(account.getAccountTableID().getId());
                }
                accountViewInfo2.setNumber(account.getNumber());
                accountViewInfo2.setName(account.getName());
            }
        }
        for (VoucherEntryInfo entryInfo : voucherInfo.getEntries()) {
            if (entryInfo == null || entryInfo.getAccount() == null || (accountViewInfo = entryInfo.getAccount()).getCompanyID() == null || accountViewInfo.getAccountTableID() == null || accountViewInfo.getAccountTableID().getId() == null || accountViewInfo.getCompanyID().getId() == null) continue;
            String companyId = accountViewInfo.getCompanyID().getId().toString();
            String accountbale = accountViewInfo.getAccountTableID().getId().toString();
            if (org.getId().toString().equals(companyId) && org.getAccountTable().getId().toString().equals(accountbale)) continue;
            VoucherUtil.replaceAccount(ctx, org.getId().toString(), org.getAccountTable().getId().toString(), entryInfo);
        }
    }

    public static HashMap getAccountUserProperty(Context ctx, VoucherCollection voucherColl) throws BOSException {
        HashMap<String, ArrayList<Object[]>> cachedUserPropertyMap = null;
        cachedUserPropertyMap = VoucherProcessCache.isCache(ctx) ? VoucherProcessCache.getCache(ctx).getAccountUserProperty() : new HashMap<String, ArrayList<Object[]>>();
        Iterator it = null;
        AccountViewInfo accountViewInfo = null;
        HashSet<String> avIds = new HashSet<String>();
        for (int i = 0; i < voucherColl.size(); ++i) {
            it = voucherColl.get(i).getEntries().iterator();
            while (it.hasNext()) {
                accountViewInfo = ((VoucherEntryInfo)it.next()).getAccount();
                if (accountViewInfo == null || !accountViewInfo.isHasUserProperty() || cachedUserPropertyMap.containsKey(accountViewInfo.getId().toString())) continue;
                avIds.add(accountViewInfo.getId().toString());
            }
        }
        if (avIds.size() == 0) {
            return cachedUserPropertyMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select c.fid,a.fisdebitnecessary,a.fiscreditnecessary,b.fmappingpropname \r\n");
        sql.append("from t_gl_assistcustomizedproperty a \r\n");
        sql.append("inner join t_gl_assistcustomizedtype b on b.fid=a.fcustomizedtypeid \r\n");
        sql.append("inner join t_bd_accountview c on a.faccountid=c.fid \r\n");
        sql.append("where a.fdeletedstatus=1 and c.fid in ").append(SQLUtil.collection2InList(avIds));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String avId = null;
            ArrayList<Object[]> list = null;
            while (rs.next()) {
                avId = rs.getString(1);
                list = (ArrayList<Object[]>)cachedUserPropertyMap.get(avId);
                if (list == null) {
                    list = new ArrayList<Object[]>();
                    cachedUserPropertyMap.put(avId, list);
                }
                list.add(new Object[]{rs.getBoolean(2), rs.getBoolean(3), rs.getString(4)});
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return cachedUserPropertyMap;
    }

    public static void fillVoucherTypeCtrlItem(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherTypeInfo vchType = voucherInfo.getVoucherType();
        if (vchType != null) {
            VoucherTypeCtrlItemCollection ciCol = VoucherUtil.getVoucherTypeCtrlItemCollection(ctx, vchType.getId().toString(), voucherInfo.getCompany().getId().toString());
            vchType.put("items", (Object)ciCol);
            voucherInfo.setVoucherTypeDetail(VoucherUtil.reorganizeCtrlItems(ciCol));
        } else {
            Object[] vtDetail = new Object[7];
            vtDetail[0] = new VoucherTypeCtrlItemCollection();
            voucherInfo.setVoucherTypeDetail(vtDetail);
        }
    }

    public static VoucherInfo lazyLoad(Context ctx, VoucherInfo voucherInfo, SelectorItemCollection selector, GlParam sysParam, boolean isCheckAsstAcctAmt) throws BOSException, EASBizException {
        boolean isFromDAP;
        PeriodInfo currPeriod;
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (voucherInfo.getCU() == null) {
            voucherInfo.setCU(company.getCU());
        }
        if ((currPeriod = VoucherProcessCache.getCurrentPeriod(ctx, company.getId().toString())) == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        VoucherUtil.replaceAccount(ctx, voucherInfo);
        Vector<String> vecVoucher = new Vector<String>();
        Vector<String> vecEntry = new Vector<String>();
        Vector<String> vecAssist = new Vector<String>();
        for (SelectorItemInfo selectorItemInfo : selector) {
            String strSelector = selectorItemInfo.getPropertyName();
            int pos = strSelector.indexOf(".");
            if (pos == -1) continue;
            String strFirstProperty = strSelector.substring(0, pos);
            if (strFirstProperty.equals("entries")) {
                if ((pos = (strSelector = strSelector.substring(pos + 1)).indexOf(".")) == -1) continue;
                strFirstProperty = strSelector.substring(0, pos);
                if (strFirstProperty.equals("assistRecords")) {
                    if ((pos = (strSelector = strSelector.substring(pos + 1)).indexOf(".")) == -1) continue;
                    vecAssist.addElement(strSelector);
                    continue;
                }
                vecEntry.addElement(strSelector);
                continue;
            }
            vecVoucher.addElement(strSelector);
        }
        int voucherSize = vecVoucher.size();
        int entrySize = vecEntry.size();
        int assistSize = vecAssist.size();
        if (voucherSize > 0) {
            VoucherUtil.setValuesBySelector(ctx, (IObjectValue)voucherInfo, vecVoucher);
        }
        if (entrySize > 0 || assistSize > 0) {
            VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
            Iterator iteratorEntry = voucherEntryCollection.iterator();
            VoucherAssistRecordCollection voucherAssistRecordCollection = null;
            VoucherEntryInfo voucherEntryInfo = null;
            while (iteratorEntry.hasNext()) {
                voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
                VoucherUtil.setValuesBySelector(ctx, (IObjectValue)voucherEntryInfo, vecEntry);
                if (assistSize <= 0) continue;
                voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                VoucherAssistRecordInfo voucherAssistRecordInfo = null;
                while (iteratorAssist.hasNext()) {
                    voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                    VoucherUtil.setValuesBySelector(ctx, (IObjectValue)voucherAssistRecordInfo, vecAssist);
                    if (voucherAssistRecordInfo.getEndDate() != null) continue;
                    voucherAssistRecordInfo.setEndDate(voucherInfo.getBizDate());
                }
            }
        }
        VoucherUtil.fillVoucherTypeCtrlItem(ctx, voucherInfo);
        boolean isRemoveentries = true;
        boolean bl = isFromDAP = SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT || voucherInfo.getSourceBillId() != null || voucherInfo.getSourceType() == SourceType.AUTO_TRANS;
        if (isFromDAP) {
            isRemoveentries = !sysParam.getBoolean("GL_0301");
        }
        VoucherUtil.fixAsstAccount(ctx, (BaseVoucherInfo)voucherInfo);
        GlUtils.setVoucherCategory(voucherInfo);
        VoucherUtil.computeVoucherAttribute(voucherInfo, sysParam, isRemoveentries, isCheckAsstAcctAmt, ctx);
        return voucherInfo;
    }

    private static void setValuesBySelector(Context ctx, IObjectValue value, Vector vecSelector) throws BOSException {
        int selectorSize = vecSelector.size();
        if (selectorSize > 0) {
            boolean[] bz = new boolean[selectorSize];
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            BOSObjectType companyBosType = new CompanyOrgUnitInfo().getBOSType();
            BOSObjectType cuBosType = new CtrlUnitInfo().getBOSType();
            for (int i = 0; i < selectorSize; ++i) {
                BOSUuid bOSUuid;
                String strSelector;
                if (bz[i] || GlUtils.propertyExist((IPropertyContainer)value, strSelector = (String)vecSelector.elementAt(i))) continue;
                int pos = strSelector.indexOf(".");
                String strFirstProperty = strSelector.substring(0, pos);
                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)value.get(strFirstProperty);
                BOSUuid bOSUuid2 = bOSUuid = coreBaseInfo == null ? null : coreBaseInfo.getId();
                if (bOSUuid == null) continue;
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int j = 0; j < selectorSize; ++j) {
                    String curFirstProperty;
                    if (bz[j] || !(curFirstProperty = (strSelector = (String)vecSelector.elementAt(j)).substring(0, pos = strSelector.indexOf("."))).equals(strFirstProperty)) continue;
                    sic.add(new SelectorItemInfo(strSelector.substring(pos + 1)));
                    bz[j] = true;
                }
                BOSObjectType bosType = "company".equalsIgnoreCase(strFirstProperty) ? companyBosType : bOSUuid.getType();
                BOSObjectType bOSObjectType = bosType = "cu".equalsIgnoreCase(strFirstProperty) ? cuBosType : bosType;
                if (strFirstProperty.equals("profitCenter")) {
                    bosType = BOSObjectType.create((String)"A70FCF6A");
                }
                IObjectValue iObjectValue = iDynamicObject.getValue(bosType, (IObjectPK)new ObjectUuidPK(bOSUuid), sic);
                value.put(strFirstProperty, (Object)iObjectValue);
            }
        }
    }

    public static void computeVoucherAttribute(VoucherInfo voucherInfo, GlParam sysParam, boolean removeZeroRow, boolean isCheckAsstAcctAmt, Context ctx) throws BOSException, EASBizException {
        Vector<BOSUuid> removedRecords;
        BigDecimal zero;
        Date bizDate;
        int pricePre;
        int qtyPre;
        boolean isFzz;
        boolean autoBalance;
        try {
            autoBalance = sysParam.getBoolean("GL_100");
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_100"});
        }
        try {
            isFzz = sysParam.getBoolean("GL_008");
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_008"});
        }
        try {
            qtyPre = sysParam.getInt("GL_002");
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_002"});
        }
        try {
            pricePre = sysParam.getInt("GL_003");
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_003"});
        }
        boolean isQtyByAcct = sysParam.getBoolean("G010");
        boolean canSaveZero = sysParam.getBoolean("GL_0301");
        boolean useReportingCurrency = false;
        boolean includeBWAcct = false;
        boolean includeBNAcct = false;
        boolean isAc = false;
        boolean isAcNotice = false;
        boolean hasCashAccount = false;
        int debitEntryCount = 0;
        int creditEntryCount = 0;
        int exPre = 10;
        CurrencyInfo cur = null;
        BOSUuid lcId = null;
        int lcPre = 0;
        BOSUuid rcurId = null;
        int rcurPre = 0;
        boolean adjEx = SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType());
        boolean isPL = SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType());
        boolean isBase = SystemEnum.BASICSYSTEM.equals((Object)voucherInfo.getSourceSys());
        boolean isAuto = SourceType.AUTO_TRANS.equals((Object)voucherInfo.getSourceType());
        boolean notAdjLnR = false;
        if (adjEx || isPL || isBase || isAuto) {
            removeZeroRow = false;
            notAdjLnR = true;
        }
        if (voucherInfo.getAttachments() < 1) {
            voucherInfo.setAttachments(0);
        }
        CompanyOrgUnitInfo com = voucherInfo.getCompany();
        CurrencyInfo localCur = com.getBaseCurrency();
        CurrencyInfo rCur = com.getReportCurrency();
        if (isFzz) {
            cur = voucherInfo.getCurrency();
            if (cur == null && voucherInfo.getEntries() != null && voucherInfo.getEntries().size() > 0 && voucherInfo.getEntries().get(0) != null) {
                cur = voucherInfo.getEntries().get(0).getCurrency();
            }
            lcPre = cur.getPrecision();
        } else {
            SelectorItemCollection selector;
            localCur = com.getBaseCurrency();
            if (localCur == null) {
                throw new GLException(GLException.NOLOCALCUR);
            }
            lcId = localCur.getId();
            if (localCur.get("precision") == null) {
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("precision"));
                localCur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(lcId), selector);
                com.setBaseCurrency(localCur);
            }
            lcPre = localCur.getPrecision();
            try {
                useReportingCurrency = sysParam.getBoolean("G001");
            }
            catch (Exception ex) {
                throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
            }
            if (useReportingCurrency) {
                rCur = com.getReportCurrency();
                if (rCur == null) {
                    throw new GLException(GLException.NOREPORTINGCUR);
                }
                rcurId = rCur.getId();
                if (rCur.get("precision") == null) {
                    selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("precision"));
                    rCur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(rcurId), selector);
                    com.setReportCurrency(rCur);
                }
                rcurPre = rCur.getPrecision();
            }
        }
        TimeZone timeZone = null;
        Date bookedDate = voucherInfo.getBookedDate();
        if (bookedDate != null) {
            voucherInfo.setBookedDate(VoucherUtil.getDateByTimeZone(timeZone, bookedDate));
        }
        if ((bizDate = voucherInfo.getBizDate()) != null) {
            voucherInfo.setBizDate(VoucherUtil.getDateByTimeZone(timeZone, bizDate));
        } else {
            voucherInfo.setBizDate(voucherInfo.getBookedDate());
        }
        Iterator iteratorEntry = voucherInfo.getEntries().iterator();
        VoucherAssistRecordCollection voucherAssistRecordCollection = null;
        VoucherEntryInfo voucherEntryInfo = null;
        BigDecimal voucherDebitLoc = zero = GlUtils.zero;
        BigDecimal voucherCreditLoc = zero;
        BigDecimal voucherDebitRep = zero;
        BigDecimal voucherCreditRep = zero;
        Vector<BOSUuid> removedEntries = voucherInfo.getRemovedEntries();
        if (removedEntries == null) {
            removedEntries = new Vector<BOSUuid>();
            voucherInfo.setRemovedEntries(removedEntries);
        }
        if ((removedRecords = voucherInfo.getRemovedRecords()) == null) {
            removedRecords = new Vector<BOSUuid>();
            voucherInfo.setRemovedRecords(removedRecords);
        }
        boolean isSettleByLocal = false;
        VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        if (useReportingCurrency && com.getReportExchangeTable() != null && com.getBaseExchangeTable() != null) {
            boolean bl = isSettleByLocal = 3 == com.getReportConvertMode().getValue();
            if (isSettleByLocal && (localToRpt = GlUtils.getLocalToReportingExchangeRate(com.getReportCurrency(), com.getReportExchangeTable().getId().toString(), com.getBaseCurrency(), com.getBaseExchangeTable().getId().toString(), voucherInfo.getBookedDate(), voucherInfo.getPeriod(), false, ctx)) == null) {
                localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            }
        }
        int entryCount = 0;
        while (iteratorEntry.hasNext()) {
            BigDecimal veLocalAmt;
            boolean hasRec;
            voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
            if (voucherEntryInfo.getOprStatus() == 3) {
                removedEntries.add(voucherEntryInfo.getId());
                iteratorEntry.remove();
                voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                VoucherAssistRecordInfo voucherAssistRecordInfo = null;
                while (iteratorAssist.hasNext()) {
                    voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                    BOSUuid rid = voucherAssistRecordInfo.getId();
                    if (rid == null) continue;
                    removedRecords.add(rid);
                }
                voucherAssistRecordCollection.clear();
                continue;
            }
            AccountViewInfo accountInfo = voucherEntryInfo.getAccount();
            boolean bl = hasRec = accountInfo != null && (voucherEntryInfo.getCAA() != null || accountInfo.isHasUserProperty());
            if (!hasRec) {
                voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                VoucherAssistRecordInfo voucherAssistRecordInfo = null;
                while (iteratorAssist.hasNext()) {
                    voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                    BOSUuid rid = voucherAssistRecordInfo.getId();
                    if (rid == null) continue;
                    removedRecords.add(rid);
                }
                voucherAssistRecordCollection.clear();
            }
            if (isFzz) {
                voucherEntryInfo.setCurrency(cur);
            }
            BigDecimal muCo = null;
            MeasureUnitInfo mu = voucherEntryInfo.getMeasureUnit();
            muCo = !isQtyByAcct && mu != null ? mu.getCoefficient() : GlUtils.one;
            CurrencyInfo entryCur = voucherEntryInfo.getCurrency();
            if (entryCur == null && !isFzz) {
                throw new GLException(GLException.ENTRY_NOCURRENCY);
            }
            int curPre = 0;
            if (entryCur != null) {
                curPre = entryCur.getPrecision();
            }
            boolean lnoEqual = false;
            boolean rnoSame = false;
            if (!isFzz && entryCur != null) {
                BOSUuid entryCurId = entryCur.getId();
                lnoEqual = entryCurId.equals((Object)lcId);
                rnoSame = entryCurId.equals((Object)rcurId);
            }
            if (notAdjLnR) {
                lnoEqual = false;
                rnoSame = false;
            }
            BigDecimal assistTotalQty = zero;
            BigDecimal assistTotalStdQty = zero;
            BigDecimal assistTotalOri = zero;
            BigDecimal assistTotalLoc = zero;
            BigDecimal assistTotalRep = zero;
            BigDecimal assistTotalHoldAmount = zero;
            int recordCount = 0;
            voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
            Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
            VoucherAssistRecordInfo voucherAssistRecordInfo = null;
            while (iteratorAssist.hasNext()) {
                voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                if (voucherAssistRecordInfo.getOprStatus() == 3) {
                    removedRecords.add(voucherAssistRecordInfo.getId());
                    iteratorAssist.remove();
                    continue;
                }
                Date rbDate = voucherAssistRecordInfo.getBizDate();
                if (rbDate != null) {
                    voucherAssistRecordInfo.setBizDate(VoucherUtil.getDateByTimeZone(timeZone, rbDate));
                } else {
                    voucherAssistRecordInfo.setBizDate(voucherInfo.getBizDate());
                }
                Date endDate = voucherAssistRecordInfo.getEndDate();
                if (endDate != null) {
                    voucherAssistRecordInfo.setEndDate(VoucherUtil.getDateByTimeZone(timeZone, endDate));
                }
                MeasureUnitInfo remu = voucherAssistRecordInfo.getMeasureUnit();
                if (isQtyByAcct && remu != null) {
                    muCo = remu.getCoefficient();
                }
                if (!SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
                    BigDecimal rq = GlUtils.setScale(voucherAssistRecordInfo.getQuantity(), qtyPre);
                    if (rq == null) {
                        rq = zero;
                    }
                    voucherAssistRecordInfo.setQuantity(rq);
                    voucherAssistRecordInfo.setStandardQuantity(GlUtils.setScale(GlUtils.mul(rq, muCo), qtyPre));
                    if (accountInfo != null && !accountInfo.isIsQty()) {
                        voucherAssistRecordInfo.setMeasureUnit(null);
                        voucherAssistRecordInfo.setQuantity(zero);
                        voucherAssistRecordInfo.setStandardQuantity(zero);
                    }
                } else {
                    if (voucherAssistRecordInfo.getQuantity() == null) {
                        voucherAssistRecordInfo.setQuantity(zero);
                    }
                    if (voucherAssistRecordInfo.getStandardQuantity() == null) {
                        voucherAssistRecordInfo.setStandardQuantity(zero);
                    }
                }
                voucherAssistRecordInfo.setOriginalAmount(GlUtils.setScale(voucherAssistRecordInfo.getOriginalAmount(), curPre));
                if ((voucherAssistRecordInfo.getPrice() == null || voucherAssistRecordInfo.getPrice().compareTo(GlUtils.zero) == 0) && voucherAssistRecordInfo.getQuantity() != null && voucherAssistRecordInfo.getQuantity().compareTo(GlUtils.zero) != 0) {
                    voucherAssistRecordInfo.setPrice(voucherAssistRecordInfo.getOriginalAmount().divide(voucherAssistRecordInfo.getQuantity(), pricePre, 4));
                }
                voucherAssistRecordInfo.setPrice(GlUtils.setScale(voucherAssistRecordInfo.getPrice(), pricePre));
                if (voucherAssistRecordInfo.getOriginalAmount() == null) {
                    voucherAssistRecordInfo.setOriginalAmount(GlUtils.zero);
                }
                if (SystemEnum.GENERALLEDGER.equals((Object)voucherInfo.getSourceSys())) {
                    voucherAssistRecordInfo.setMaCtrlAmount(voucherAssistRecordInfo.getOriginalAmount());
                } else if (voucherAssistRecordInfo.getMaHoldAmount() == null || voucherAssistRecordInfo.getMaHoldAmount().compareTo(GlUtils.zero) == 0) {
                    voucherAssistRecordInfo.setMaCtrlAmount(voucherAssistRecordInfo.getOriginalAmount());
                } else {
                    voucherAssistRecordInfo.setMaCtrlAmount(voucherAssistRecordInfo.getOriginalAmount().subtract(voucherAssistRecordInfo.getMaHoldAmount()));
                }
                if (isPL) {
                    voucherAssistRecordInfo.setMaCtrlAmount(GlUtils.zero);
                }
                if (isFzz) {
                    voucherAssistRecordInfo.setLocalAmount(voucherAssistRecordInfo.getOriginalAmount());
                    voucherAssistRecordInfo.setReportingAmount(zero);
                } else {
                    BigDecimal amnt = voucherAssistRecordInfo.getOriginalAmount();
                    if (lnoEqual && amnt != null && amnt.compareTo(GlUtils.zero) != 0) {
                        voucherAssistRecordInfo.setLocalAmount(amnt);
                    } else {
                        voucherAssistRecordInfo.setLocalAmount(GlUtils.setScale(voucherAssistRecordInfo.getLocalAmount(), lcPre));
                    }
                    if (adjEx) {
                        if (voucherAssistRecordInfo.getLocalAmount() == null) {
                            voucherAssistRecordInfo.setLocalAmount(GlUtils.zero);
                        }
                        if (voucherAssistRecordInfo.getReportingAmount() == null) {
                            voucherAssistRecordInfo.setReportingAmount(GlUtils.zero);
                        } else {
                            voucherAssistRecordInfo.setReportingAmount(GlUtils.setScale(voucherAssistRecordInfo.getReportingAmount(), rcurPre));
                        }
                    } else {
                        if (voucherAssistRecordInfo.getLocalAmount() == null) {
                            voucherAssistRecordInfo.setLocalAmount(GlUtils.zero);
                        }
                        if (!isSettleByLocal) {
                            if (rcurId == null || adjEx) {
                                voucherAssistRecordInfo.setReportingAmount(zero);
                            } else if (rnoSame) {
                                voucherAssistRecordInfo.setReportingAmount(amnt);
                            } else {
                                voucherAssistRecordInfo.setReportingAmount(GlUtils.setScale(voucherAssistRecordInfo.getReportingAmount(), rcurPre));
                            }
                        } else if (voucherAssistRecordInfo.getReportingAmount() == null) {
                            voucherAssistRecordInfo.setReportingAmount(GlUtils.setScale(voucherAssistRecordInfo.getLocalAmount().multiply(localToRpt.getValue()), rcurPre));
                        } else {
                            voucherAssistRecordInfo.setReportingAmount(GlUtils.setScale(voucherAssistRecordInfo.getReportingAmount(), rcurPre));
                        }
                    }
                }
                if (voucherInfo.getSourceType().getValue() != 1 && !adjEx && useReportingCurrency && localCur.getId().toString().equals(rCur.getId().toString()) && (voucherAssistRecordInfo.getReportingAmount() == null || GlUtils.zero.compareTo(voucherAssistRecordInfo.getReportingAmount()) == 0) && GlUtils.zero.compareTo(voucherAssistRecordInfo.getLocalAmount()) != 0) {
                    voucherAssistRecordInfo.setReportingAmount(voucherAssistRecordInfo.getLocalAmount());
                }
                if (!canSaveZero && removeZeroRow && GlUtils.isAllZeroOrNull(new BigDecimal[]{voucherAssistRecordInfo.getLocalAmount(), voucherAssistRecordInfo.getOriginalAmount(), voucherAssistRecordInfo.getReportingAmount(), voucherAssistRecordInfo.getQuantity()})) {
                    if (voucherAssistRecordInfo.getOprStatus() != 1) {
                        removedRecords.add(voucherAssistRecordInfo.getId());
                    }
                    iteratorAssist.remove();
                    continue;
                }
                voucherAssistRecordInfo.setSeq(++recordCount);
                assistTotalQty = GlUtils.add(assistTotalQty, voucherAssistRecordInfo.getQuantity());
                assistTotalStdQty = GlUtils.add(assistTotalStdQty, voucherAssistRecordInfo.getStandardQuantity());
                assistTotalOri = GlUtils.add(assistTotalOri, voucherAssistRecordInfo.getOriginalAmount());
                assistTotalLoc = GlUtils.add(assistTotalLoc, voucherAssistRecordInfo.getLocalAmount());
                assistTotalRep = GlUtils.add(assistTotalRep, voucherAssistRecordInfo.getReportingAmount());
                assistTotalHoldAmount = GlUtils.add(assistTotalHoldAmount, voucherAssistRecordInfo.getMaHoldAmount());
            }
            if (recordCount > 0 && !isPL) {
                voucherEntryInfo.setQuantity(assistTotalQty);
                voucherEntryInfo.setStandardQuantity(assistTotalStdQty);
                voucherEntryInfo.setOriginalAmount(assistTotalOri);
                voucherEntryInfo.setLocalAmount(assistTotalLoc);
                voucherEntryInfo.setReportingAmount(assistTotalRep);
                voucherEntryInfo.setMaHoldAmount(assistTotalHoldAmount);
            }
            if ((voucherEntryInfo.getPrice() == null || voucherEntryInfo.getPrice().compareTo(GlUtils.zero) == 0) && voucherEntryInfo.getQuantity() != null && voucherEntryInfo.getQuantity().compareTo(GlUtils.zero) != 0 && voucherEntryInfo.getOriginalAmount() != null) {
                voucherEntryInfo.setPrice(voucherEntryInfo.getOriginalAmount().divide(voucherEntryInfo.getQuantity(), pricePre, 4));
            }
            voucherEntryInfo.setPrice(GlUtils.setScale(voucherEntryInfo.getPrice(), pricePre));
            voucherEntryInfo.setLocalExchangeRate(GlUtils.setScale(voucherEntryInfo.getLocalExchangeRate(), exPre));
            if (!isSettleByLocal || voucherEntryInfo.getReportingExchangeRate() != null) {
                voucherEntryInfo.setReportingExchangeRate(GlUtils.setScale(voucherEntryInfo.getReportingExchangeRate(), exPre));
            } else {
                voucherEntryInfo.setReportingExchangeRate(localToRpt.getValue());
            }
            if (!isQtyByAcct && recordCount == 0 && !SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
                BigDecimal eq = GlUtils.setScale(voucherEntryInfo.getQuantity(), qtyPre);
                if (eq == null) {
                    eq = zero;
                }
                voucherEntryInfo.setQuantity(eq);
                voucherEntryInfo.setStandardQuantity(GlUtils.setScale(GlUtils.mul(eq, muCo), qtyPre));
            }
            voucherEntryInfo.setOriginalAmount(GlUtils.setScale(voucherEntryInfo.getOriginalAmount(), curPre));
            if (voucherEntryInfo.getOriginalAmount() == null) {
                voucherEntryInfo.setOriginalAmount(GlUtils.zero);
            }
            if (SystemEnum.GENERALLEDGER.equals((Object)voucherInfo.getSourceSys())) {
                voucherEntryInfo.setMaCtrlAmount(voucherEntryInfo.getOriginalAmount());
            } else if (voucherEntryInfo.getMaHoldAmount() == null || voucherEntryInfo.getMaHoldAmount().compareTo(GlUtils.zero) == 0) {
                voucherEntryInfo.setMaCtrlAmount(voucherEntryInfo.getOriginalAmount());
            } else {
                voucherEntryInfo.setMaCtrlAmount(voucherEntryInfo.getOriginalAmount().subtract(voucherEntryInfo.getMaHoldAmount()));
            }
            if (isPL) {
                voucherEntryInfo.setMaCtrlAmount(GlUtils.zero);
            }
            if (isFzz) {
                voucherEntryInfo.setLocalExchangeRate(GlUtils.one);
                voucherEntryInfo.setLocalAmount(voucherEntryInfo.getOriginalAmount());
                voucherEntryInfo.setReportingExchangeRate(zero);
                voucherEntryInfo.setReportingAmount(zero);
            } else {
                BigDecimal amnt = voucherEntryInfo.getOriginalAmount();
                BigDecimal localAmount = voucherEntryInfo.getLocalAmount();
                BigDecimal localExchangeRate = voucherEntryInfo.getLocalExchangeRate();
                if (amnt == null && localAmount != null && localExchangeRate != null) {
                    voucherEntryInfo.setOriginalAmount(localAmount.divide(localExchangeRate, 4));
                    amnt = voucherEntryInfo.getOriginalAmount();
                }
                if (lnoEqual && amnt != null && amnt.compareTo(GlUtils.zero) != 0) {
                    voucherEntryInfo.setLocalExchangeRate(GlUtils.one);
                    voucherEntryInfo.setLocalAmount(amnt);
                } else {
                    voucherEntryInfo.setLocalAmount(GlUtils.setScale(voucherEntryInfo.getLocalAmount(), lcPre));
                }
                if (adjEx) {
                    if (voucherEntryInfo.getReportingAmount() == null) {
                        voucherEntryInfo.setReportingAmount(GlUtils.zero);
                    } else {
                        voucherEntryInfo.setReportingAmount(GlUtils.setScale(voucherEntryInfo.getReportingAmount(), rcurPre));
                    }
                } else if (!isSettleByLocal) {
                    if (rcurId == null || adjEx) {
                        voucherEntryInfo.setReportingExchangeRate(zero);
                        voucherEntryInfo.setReportingAmount(zero);
                    } else if (rnoSame) {
                        voucherEntryInfo.setReportingExchangeRate(GlUtils.one);
                        voucherEntryInfo.setReportingAmount(amnt);
                    } else {
                        voucherEntryInfo.setReportingAmount(GlUtils.setScale(voucherEntryInfo.getReportingAmount(), rcurPre));
                    }
                } else {
                    if (voucherEntryInfo.getLocalAmount() == null) {
                        voucherEntryInfo.setLocalAmount(GlUtils.zero);
                    }
                    if (voucherEntryInfo.getReportingAmount() == null || voucherEntryInfo.getReportingAmount().compareTo(GlUtils.zero) == 0) {
                        if (!autoBalance && voucherEntryInfo.getReportingExchangeRate() != null && voucherEntryInfo.getReportingExchangeRate().compareTo(GlUtils.zero) != 0) {
                            voucherEntryInfo.setReportingAmount(GlUtils.setScale(voucherEntryInfo.getLocalAmount().multiply(localToRpt.getValue()), rcurPre));
                        }
                    } else {
                        voucherEntryInfo.setReportingAmount(GlUtils.setScale(voucherEntryInfo.getReportingAmount(), rcurPre));
                    }
                }
            }
            boolean isFromDAP = SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT || voucherInfo.getSourceBillId() != null || voucherInfo.getSourceType() == SourceType.AUTO_AMORTIZE;
            boolean onlyAssistRecord = false;
            if (voucherEntryInfo.getAssistRecords() != null && voucherEntryInfo.getAssistRecords().size() > 0) {
                onlyAssistRecord = true;
            }
            if (!onlyAssistRecord && removeZeroRow && (!canSaveZero && isFromDAP || voucherEntryInfo.getAccount() == null) && GlUtils.isAllZeroOrNull(new BigDecimal[]{voucherEntryInfo.getLocalAmount(), voucherEntryInfo.getOriginalAmount(), voucherEntryInfo.getReportingAmount(), voucherEntryInfo.getQuantity()})) {
                if (voucherEntryInfo.getOprStatus() != 1) {
                    removedEntries.add(voucherEntryInfo.getId());
                }
                iteratorEntry.remove();
                continue;
            }
            if (hasRec && recordCount == 0) {
                voucherAssistRecordInfo = new VoucherAssistRecordInfo();
                voucherAssistRecordInfo.setId(BOSUuid.create((BOSObjectType)voucherAssistRecordInfo.getBOSType()));
                voucherAssistRecordInfo.setOprStatus(1);
                voucherAssistRecordInfo.setBill(voucherInfo);
                voucherAssistRecordInfo.setEntry(voucherEntryInfo);
                voucherAssistRecordInfo.setSeq(++recordCount);
                voucherAssistRecordInfo.setBizDate(voucherInfo.getBizDate());
                voucherAssistRecordInfo.setEndDate(voucherInfo.getBizDate());
                voucherAssistRecordInfo.setDescription(voucherEntryInfo.getDescription());
                if (accountInfo != null && !accountInfo.isIsQty()) {
                    voucherAssistRecordInfo.setMeasureUnit(null);
                    voucherAssistRecordInfo.setQuantity(zero);
                    voucherAssistRecordInfo.setStandardQuantity(zero);
                } else {
                    voucherAssistRecordInfo.setQuantity(voucherEntryInfo.getQuantity());
                    voucherAssistRecordInfo.setMeasureUnit(voucherEntryInfo.getMeasureUnit());
                    voucherAssistRecordInfo.setStandardQuantity(voucherEntryInfo.getStandardQuantity());
                }
                voucherAssistRecordInfo.setPrice(voucherEntryInfo.getPrice());
                voucherAssistRecordInfo.setOriginalAmount(voucherEntryInfo.getOriginalAmount());
                voucherAssistRecordInfo.setLocalAmount(voucherEntryInfo.getLocalAmount());
                assistTotalLoc = GlUtils.add(assistTotalLoc, voucherAssistRecordInfo.getLocalAmount());
                voucherAssistRecordInfo.setReportingAmount(voucherEntryInfo.getReportingAmount());
                voucherAssistRecordCollection.add(voucherAssistRecordInfo);
            }
            voucherEntryInfo.setSeq(++entryCount);
            if (voucherEntryInfo.getReportingAmount() != null) {
                BigDecimal entryTotal = GlUtils.pointzero;
                entryTotal = voucherEntryInfo.getAssistRecords() != null && voucherEntryInfo.getAssistRecords().size() > 0 ? VoucherUtil.getTotalReportingAmountByAssistRecords(voucherEntryInfo.getAssistRecords()) : voucherEntryInfo.getReportingAmount();
                voucherEntryInfo.setReportingAmount(GlUtils.setScale(entryTotal, rcurPre));
            }
            if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                ++debitEntryCount;
                voucherDebitLoc = GlUtils.add(voucherDebitLoc, voucherEntryInfo.getLocalAmount());
                voucherDebitRep = GlUtils.add(voucherDebitRep, voucherEntryInfo.getReportingAmount());
            } else {
                ++creditEntryCount;
                voucherCreditLoc = GlUtils.add(voucherCreditLoc, voucherEntryInfo.getLocalAmount());
                voucherCreditRep = GlUtils.add(voucherCreditRep, voucherEntryInfo.getReportingAmount());
            }
            if (accountInfo != null) {
                if (accountInfo.isBw()) {
                    includeBWAcct = true;
                } else {
                    includeBNAcct = true;
                }
                if (accountInfo.isAC()) {
                    isAc = true;
                }
                if (accountInfo.isACNotice()) {
                    isAcNotice = true;
                }
                if (accountInfo.isIsCash() || accountInfo.isIsBank() || accountInfo.isIsCashEquivalent()) {
                    hasCashAccount = true;
                }
            }
            if (recordCount <= 0 || !isCheckAsstAcctAmt || (veLocalAmt = GlUtils.setScale(voucherEntryInfo.getLocalAmount(), lcPre)).compareTo(assistTotalLoc) == 0) continue;
            if (voucherInfo.getNumber() == null) {
                throw new VoucherException(VoucherException.VOUCHER_EQUAL_ASSIT_LOC, new Object[]{new Integer(voucherEntryInfo.getSeq()), voucherEntryInfo.getAccount().getNumber(), voucherEntryInfo.getLocalAmount(), assistTotalLoc});
            }
            throw new VoucherException(VoucherException.VCH_LINE_EQUAL_ASSIT_LOC, new Object[]{voucherInfo.getNumber(), new Integer(voucherEntryInfo.getSeq()), voucherEntryInfo.getAccount().getNumber(), voucherEntryInfo.getLocalAmount(), assistTotalLoc});
        }
        voucherInfo.setIncludeBWAccount(includeBWAcct);
        voucherInfo.setIncludeBNAccount(includeBNAcct);
        voucherInfo.setIsAC(isAc);
        voucherInfo.setIsACNotice(isAcNotice);
        voucherInfo.setHasCashAccount(hasCashAccount);
        voucherInfo.setDebitEntryCount(debitEntryCount);
        voucherInfo.setCreditEntryCount(creditEntryCount);
        voucherInfo.setEntryCount(entryCount);
        voucherInfo.setLocalDebitAmount(voucherDebitLoc.setScale(lcPre, 4));
        voucherInfo.setLocalCreditAmount(voucherCreditLoc.setScale(lcPre, 4));
        voucherInfo.setReportingDebitAmount(voucherDebitRep.setScale(rcurPre, 4));
        voucherInfo.setReportingCreditAmount(voucherCreditRep.setScale(rcurPre, 4));
    }

    public static TimeZone getCallerTimeZone(Context ctx) throws BOSException, EASBizException {
        TimeZone timezone = null;
        HashMap nationalConfig = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ctx.getCaller().toString(), null, null);
        if (nationalConfig != null) {
            timezone = TimeZone.getTimeZone((String)nationalConfig.get("timezone"));
        }
        return timezone;
    }

    public static Date getDateByTimeZone(TimeZone timezone, Date date) {
        if (timezone != null) {
            Calendar cal = Calendar.getInstance(timezone);
            cal.setTime(date);
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            return new Date(cal.getTimeInMillis() / 1000L * 1000L);
        }
        return DateTimeUtils.truncateDate((Date)date);
    }

    public static BigDecimal getTotalReportingAmountByAssistRecords(VoucherAssistRecordCollection assistRecords) {
        BigDecimal result = GlUtils.pointzero;
        int size = assistRecords.size();
        if (size == 0) {
            return result;
        }
        for (int i = 0; i < size; ++i) {
            result = result.add(assistRecords.get(i).getReportingAmount());
        }
        return result;
    }

    public static void requestBudgetSubstract(Context ctx, VoucherInfo voucherInfo, GlParam sysParams, int voucherAction) throws BOSException, BgCtrlException, EASBizException {
        boolean isMbgCtrl;
        if (voucherInfo.getId() == null) {
            return;
        }
        if (voucherInfo.getSourceType().getValue() == 1) {
            return;
        }
        int budgetParam = sysParams.getInt("GL_075");
        if ((voucherAction == 8 && budgetParam == 1 || voucherAction == 2 && budgetParam == 0) && (isMbgCtrl = sysParams.getBoolean("GL_029"))) {
            IControlResult result;
            String sql = "select fismgctrl from t_gl_voucher where fid=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
            boolean isMgCtrl = false;
            try {
                int result2;
                if (rs.next() && (result2 = rs.getInt("fismgctrl")) == 1) {
                    isMgCtrl = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (isMgCtrl && ((result = GlUtils.requestBudget(ctx, voucherInfo.getId())).getResult() == 3 || result.getResult() == 5 || result.getResult() == 6 || result.getResult() == 7)) {
                throw new VoucherException(VoucherException.ACCOUNT_MGCTRL_ERROR, new Object[]{result.getCause().toString()});
            }
        }
    }

    public static void recycleVoucherId(Context ctx, VoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            VoucherFactory.getLocalInstance((Context)ctx).recycleVoucherNumber((BaseVoucherInfo)voucherInfo, voucherNumber);
        } else {
            VoucherInfo previousVoucher = null;
            String[] value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                VoucherUtil.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    public static void updateAcctCussentBalance(Context ctx, String voucherId, boolean isUnpost) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement stmtUpdate = null;
        ResultSet rs = null;
        String coef = isUnpost ? "-1*" : "";
        String sql = null;
        String sqlUpdate = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql = "select vast.FVerifiedCussentID FVerifiedCussentID,             \r\n\t" + coef + "sum(vast.FOriginalAmount) FUnHoldedAmtForV,      \t   \t\r\n\t" + coef + "sum(vast.FLocalAmount) FUnHoldedAmtLocalV,       \t\t\r\n\t" + coef + "sum(vast.FReportingAmount) FUnHoldedAmtRptV,     \t\t\r\n\t" + coef + "sum(vast.FQuantity) FUnHoldedQtyV,               \t\t\r\n\t" + coef + "sum(vast.FStandardQuantity) FUnHoldedStdQtyV     \t\t\r\nfrom T_GL_Voucher vch                                          \r\ninner join T_GL_VoucherEntry ve                                \r\n\ton vch.FID = ve.FBillID                                 \t\r\ninner join T_GL_VoucherAssistRecord vast                       \r\n\ton ve.FID = vast.FEntryID                               \t\r\nwhere ve.FIsVerify = 1                                    \t\t\r\n\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)  \t\r\n\tand vast.FVerifiedCussentID is not null\t\t\t\t\t  \t\r\n\tand vch.FID = ?\tgroup by vast.FVerifiedCussentID\t\t\t\t\t\t\t\t\r\n";
            sqlUpdate = "update T_GL_AcctCussent\t\t\t\t\t\t\t\t\t\t\r\nset FUnHoldedAmtFor = FUnHoldedAmtFor - ?,\t\t\t\t\t\t\r\n\tFUnHoldedAmtLocal = FUnHoldedAmtLocal - ?,\t\t\t\t\t\r\n\tFUnHoldedAmtRpt = FUnHoldedAmtRpt - ?,\t\t\t\t\t\t\r\n\tFUnHoldedQty = FUnHoldedQty - ?,\t\t\t\t\t\t\t\r\n\tFUnHoldedStdQty = FUnHoldedStdQty - ?\t\t\t\t\t\t\r\nwhere FID = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, voucherId);
            rs = stmt.executeQuery();
            stmtUpdate = conn.prepareStatement(sqlUpdate);
            int count = 0;
            while (rs.next()) {
                stmtUpdate.setBigDecimal(1, rs.getBigDecimal(2));
                stmtUpdate.setBigDecimal(2, rs.getBigDecimal(3));
                stmtUpdate.setBigDecimal(3, rs.getBigDecimal(4));
                stmtUpdate.setBigDecimal(4, rs.getBigDecimal(5));
                stmtUpdate.setBigDecimal(5, rs.getBigDecimal(6));
                DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)6, (String)rs.getString(1));
                stmtUpdate.addBatch();
                if (++count < 2000) continue;
                count = 0;
                stmtUpdate.executeBatch();
                stmtUpdate.clearBatch();
            }
            if (count > 0) {
                stmtUpdate.executeBatch();
            }
            SQLUtils.cleanup((Statement)stmtUpdate);
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            stmt = null;
            stmtUpdate = null;
            rs = null;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate, (Connection)conn);
                SQLUtils.cleanup(rs, stmt);
                stmt = null;
                stmtUpdate = null;
                rs = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        stmt = null;
        stmtUpdate = null;
        rs = null;
    }

    public static void _deleteAllCashflowRecords(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        String sbSql = "delete from t_gl_cashflowrecord where fvoucherid = ?";
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public static void _deleteAllAcctcussent(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public static void _deleteAllCashflowSplitRecords(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        String sbSql = "delete from t_gl_cashflowsplitrecord where fvoucherid = ?";
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public static void _deleteAllAssistRecords(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        String sbSql = "delete from t_gl_voucherassistrecord where fbillid = ?";
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public static void _deleteAllEntries(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        String sbSql = "delete from t_gl_voucherentry where fbillid = ?";
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public static void _deleteVoucher(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        String sbSql = "delete from t_gl_voucher where fid = ?";
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public static void _saveVoucherMessage2(Context ctx, AcountSchemeInfo book, VoucherInfo srcVoucher, CompanyOrgUnitInfo transferOrgInfo, IObjectPK tagPK, boolean isSuc, String msg) throws EASBizException, BOSException {
        BookUtil._saveVoucherMessage2(ctx, book, srcVoucher, transferOrgInfo, tagPK, isSuc, msg);
    }

    public static boolean isExistVoucherCodingRule(Context ctx, String companyId, VoucherInfo voucherInfo, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getIsExistCodingRule().get(companyId + status.toString()) != null) {
            return (Boolean)cache.getIsExistCodingRule().get(companyId + status.toString());
        }
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        voucherInfo.setBizStatus(status);
        boolean isExistCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)voucherInfo, companyId, "bizStatus");
        voucherInfo.setBizStatus(oldStatus);
        if (cache != null) {
            cache.getIsExistCodingRule().put(companyId + status.toString(), isExistCodingRule);
        }
        return isExistCodingRule;
    }

    public static String preViewNumber(Context ctx, String companyId, BaseVoucherInfo voucherInfo, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        voucherInfo.setBizStatus(status);
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).readNumber((IObjectValue)voucherInfo, companyId, "bizStatus", "");
        voucherInfo.setBizStatus(oldStatus);
        return number;
    }

    public static String getNextNumber(Context ctx, String companyId, BaseVoucherInfo voucherInfo, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        voucherInfo.setBizStatus(status);
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)voucherInfo, companyId, "bizStatus", "");
        voucherInfo.setBizStatus(oldStatus);
        return number;
    }

    public static boolean isAmortVoucher(VoucherInfo voucherInfo) {
        if (voucherInfo.getSourceBillId() == null || voucherInfo.getSourceBillId().toString().length() < 1) {
            return false;
        }
        if (!SystemEnum.GENERALLEDGER.equals((Object)voucherInfo.getSourceSys()) || !SourceType.VOUCHER_AMORT.equals((Object)voucherInfo.getSourceType()) && !SourceType.HANDCRAFT.equals((Object)voucherInfo.getSourceType())) {
            return false;
        }
        BOSObjectType srcType = BOSUuid.read((String)voucherInfo.getSourceBillId().toString()).getType();
        BOSObjectType destType = new VchAmortSchemeInfo().getBOSType();
        if (srcType == null || destType == null) {
            return false;
        }
        return srcType.equals((Object)destType);
    }

    public static boolean isAccountInited(Context ctx, String curCompanyID) throws BOSException, EASBizException, EASBizException {
        PeriodInfo period;
        String curPeriodID;
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, curCompanyID);
        PeriodInfo startPeriod = aryPrd[0];
        String startPeriodID = startPeriod.getId().toString();
        if (startPeriodID.equals(curPeriodID = (period = aryPrd[1]).getId().toString())) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 1 where exists          \t\t\r\n");
            sql.append("(select 1 from t_GL_Flag          \t\r\n");
            sql.append("where FOrgUnitID = ?                \r\n");
            sql.append("    and FName = 'glinit'            \r\n");
            sql.append("\tand FValue = 'true'            \t\r\n");
            sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyID});
            try {
                if (!rs.next()) {
                    return false;
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
        }
        return true;
    }

    public static Map checkAssitInited(Context ctx, String voucherids, String curCompanyID) throws BOSException, EASBizException {
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  distinct v.FID FVoucherID, ve.FAccountID, av.FNumber FAccountNumber, av.FName" + loc + " FAccountName \n");
        sql.append("from T_GL_Voucher v \n");
        sql.append("join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("join T_bd_AccountView av on av.FID = ve.FAccountID \n");
        sql.append("where v.FID in (" + voucherids + ") \n");
        IRowSet vrs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> accounts = new HashMap<String, String>();
        HashMap<String, HashSet<String>> vouchers = new HashMap<String, HashSet<String>>();
        try {
            while (vrs.next()) {
                String voucherId;
                HashSet<String> voucher;
                String accountId = vrs.getString("FAccountID");
                if (!accounts.containsKey(accountId)) {
                    accounts.put(accountId, vrs.getString("FAccountNumber") + " " + vrs.getString("FAccountName"));
                }
                if ((voucher = (HashSet<String>)vouchers.get(voucherId = vrs.getString("FVoucherID"))) == null) {
                    voucher = new HashSet<String>();
                    vouchers.put(voucherId, voucher);
                }
                voucher.add(accountId);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        PeriodInfo period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(curCompanyID));
        Map<String, AsstAccountInfo> caas = GLAsstAccountUtils.getCAAs(ctx, accounts.keySet(), period.getId().toString(), null);
        HashSet<String> voucherIdsHasCaa = new HashSet<String>();
        for (String voucherId : caas.keySet()) {
            if (caas.get(voucherId) == null) continue;
            voucherIdsHasCaa.add(voucherId);
        }
        HashMap<String, StringBuffer> resultMap = new HashMap<String, StringBuffer>();
        if (voucherIdsHasCaa.size() == 0) {
            return resultMap;
        }
        sql.setLength(0);
        sql.append("select FKey \n");
        sql.append("from t_GL_Flag \n");
        sql.append("where FOrgUnitID = ? \n");
        sql.append("  and FName = 'astinit' \n");
        sql.append("  and FValue = 'true' \n");
        sql.append("  and FKey in " + SQLUtil.collection2InList(voucherIdsHasCaa) + " \n");
        IRowSet frs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyID});
        HashSet<String> initedVoucherIds = new HashSet<String>();
        try {
            while (frs.next()) {
                initedVoucherIds.add(frs.getString("FKey"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        for (String voucherId : vouchers.keySet()) {
            Set vch = (Set)vouchers.get(voucherId);
            StringBuffer errMsg = new StringBuffer();
            for (String accountId : vch) {
                if (caas.get(accountId) == null || initedVoucherIds.contains(accountId)) continue;
                if (errMsg.length() > 0) {
                    errMsg.append(";");
                }
                errMsg.append((String)accounts.get(accountId));
            }
            if (errMsg.length() <= 0) continue;
            resultMap.put(voucherId, errMsg);
        }
        return resultMap;
    }

    public static Map checkCussentInited(Context ctx, String voucherids, String curCompanyID) throws BOSException, EASBizException {
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select v1.*\t\t\t\t\t\t\t\r\n");
        sql.append("from                                \r\n");
        sql.append("(                                   \r\n");
        sql.append("select distinct vch.fid voucherId, ve.FAccountID,      \r\n");
        sql.append("\tacct.FNumber as FAccountNumber, \r\n");
        sql.append("\tacct.FName");
        sql.append(loc);
        sql.append(" as FAccountName\t\t\t\t\t\r\n");
        sql.append("from t_gl_VoucherEntry ve,          \r\n");
        sql.append("\tt_gl_Voucher vch,               \r\n");
        sql.append("\tt_bd_accountview acct           \r\n");
        sql.append("where ve.FBillID = vch.FID    \t\t\r\n");
        sql.append("\tand ve.FAccountID = acct.FID    \r\n");
        sql.append("\tand acct.FCAA is not null       \r\n");
        sql.append("    and acct.FAC = 1                \r\n");
        sql.append("\tand vch.FID  in (" + voucherids + ")              \t\t\r\n");
        sql.append("    and vch.FCompanyID = ?");
        sql.append(" \r\n");
        sql.append("    and exists(select 1                \r\n");
        sql.append("    from t_gl_flag                     \r\n");
        sql.append("    where FOrgUnitID = vch.fcompanyid\t\r\n");
        sql.append("\tand fname = 'cussentinit'\t\t\t\r\n");
        sql.append("\tand fkey = ve.FAccountID\t\t\t\r\n");
        sql.append("\tand fvalue = 'false'\t\t\t\t\r\n");
        sql.append("\tand finitperiodid = ?)\t\t\t\t\r\n");
        sql.append(") v1");
        PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(ctx, curCompanyID);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyID, currentPeriod.getId().toString()});
        HashMap<String, StringBuffer> resultMap = new HashMap<String, StringBuffer>();
        try {
            String voucherId = null;
            while (rs.next()) {
                StringBuffer accounts = null;
                voucherId = rs.getString("voucherId");
                if (resultMap.containsKey(voucherId)) {
                    accounts = (StringBuffer)resultMap.get(voucherId);
                } else {
                    accounts = new StringBuffer();
                    resultMap.put(voucherId, accounts);
                }
                if (accounts.length() > 0) {
                    accounts.append(";");
                }
                accounts.append(rs.getString("FAccountNumber")).append(" ").append(rs.getString("FAccountName"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return resultMap;
    }

    public static boolean isVoucherNumberPatternAccordRule(Context ctx, CodingRuleInfo codingrule, VoucherInfo voucherInfo, String voucherNumber) throws EASBizException, BOSException {
        int creIndex = VoucherUtil.getSNCREIndex(codingrule);
        String[] valueStrings = VoucherUtil.getValueStrings(ctx, (IObjectValue)voucherInfo, codingrule, null, creIndex);
        String sortItemValue = valueStrings[0];
        sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
        String beforeSNNumber = valueStrings[1];
        String afterSNNumber = valueStrings[2];
        long recycleNumber = VoucherUtil.getRecycleNumber(voucherNumber, beforeSNNumber, afterSNNumber, codingrule);
        return recycleNumber != -9999L;
    }

    /*
     * Unable to fully structure code
     */
    private static long getRecycleNumber(String number, String beforeSNNumber, String afterSNNumber, CodingRuleInfo codingrule) throws BOSException, CodingRuleException {
        dateIsBefore = false;
        dateIsAfter = false;
        creIndex = VoucherUtil.getSNCREIndex(codingrule);
        dateIndex = VoucherUtil.getDateCREIndex(codingrule);
        if (creIndex > 0 && dateIndex >= 0) {
            try {
                if (creIndex > dateIndex) {
                    dateIsBefore = true;
                } else {
                    dateIsAfter = true;
                }
                if (dateIsBefore || dateIsAfter) {
                    modelnumber = null;
                    if (dateIsBefore) {
                        if (number.length() > beforeSNNumber.length()) {
                            modelnumber = number.substring(beforeSNNumber.length(), number.length());
                        } else {
                            return -9999L;
                        }
                    }
                    if (dateIsAfter) {
                        if (number.length() > afterSNNumber.length()) {
                            modelnumber = number.substring(number.length() - afterSNNumber.length(), number.length());
                        } else {
                            return -9999L;
                        }
                    }
                    if (number.indexOf(modelnumber) < 0) {
                        return -9999L;
                    }
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                return -9999L;
            }
            beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
            afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
        } else {
            beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
            v0 = afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
            if (number.indexOf(beforeSNNumber) < 0 || number.indexOf(afterSNNumber) < 0) {
                return -9999L;
            }
        }
        if (number.indexOf("\\") != -1) {
            number = number.replaceAll("\\\\", "");
        }
        if (beforeSNNumber.indexOf("\\") != -1) {
            beforeSNNumber = beforeSNNumber.replaceAll("\\\\", "");
        }
        if (afterSNNumber.indexOf("\\") != -1) {
            afterSNNumber = afterSNNumber.replaceAll("\\\\", "");
        }
        if (dateIsBefore || dateIsAfter) {
            try {
                if (dateIsBefore) {
                    number = number.substring(beforeSNNumber.length(), number.length());
                    if (afterSNNumber != null && afterSNNumber.length() > 0) {
                        number = number.substring(0, number.length() - afterSNNumber.length());
                    }
                }
                if (!dateIsAfter) ** GOTO lbl56
                number = number.substring(0, number.length() - afterSNNumber.length());
                if (beforeSNNumber == null || beforeSNNumber.length() <= 0) ** GOTO lbl56
                number = number.substring(beforeSNNumber.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                return -9999L;
            }
        } else {
            number = number.substring(beforeSNNumber.length());
            number = number.substring(0, number.length() - afterSNNumber.length());
        }
lbl56:
        // 4 sources

        tempstr = "";
        if (codingrule.getSplitSign() != null && codingrule.getSplitSign().trim().length() > 0 && codingrule.getCodingRuleEntrys().size() != 0) {
            for (i = 0; i < codingrule.getCodingRuleEntrys().size(); ++i) {
                if (number.indexOf(codingrule.getSplitSign()) == -1) continue;
                num = number.indexOf("-");
                tempstr = tempstr + number.substring(0, num);
                number = number.substring(num + 1, number.length());
            }
            number = tempstr = tempstr + number;
        }
        flag = true;
        for (i = 0; i < codingrule.getCodingRuleEntrys().size(); ++i) {
            creVO = codingrule.getCodingRuleEntrys().get(i);
            if (creVO.getLength() == 0 || creVO.getCodeAttribute().trim().equals("sn")) continue;
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < codingrule.getCodingRuleEntrys().size(); ++i) {
                creVO = codingrule.getCodingRuleEntrys().get(i);
                if (!creVO.getCodeAttribute().trim().equals("sn") || number.length() == creVO.getLength()) continue;
                return -9999L;
            }
        }
        try {
            recycleNumbeObj = new Long(number);
            return recycleNumbeObj;
        }
        catch (NumberFormatException err) {
            return -9999L;
        }
    }

    private static int getDateCREIndex(CodingRuleInfo codingruleVO) throws BOSException, CodingRuleException {
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.getCodeAttribute().trim().equals("systime")) continue;
            return i;
        }
        return -9999;
    }

    private static int getSNCREIndex(CodingRuleInfo codingruleVO) throws BOSException, CodingRuleException {
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.getCodeAttribute().trim().equals("sn")) continue;
            return i;
        }
        throw new CodingRuleException(CodingRuleException.ERROR_SN_NOTEXIST);
    }

    private static String[] getValueStrings(Context ctx, IObjectValue caller, CodingRuleInfo codingruleVO, String customStr, int creIndex) throws BOSException, CodingRuleException, EASBizException {
        StringBuffer sortValue = new StringBuffer();
        StringBuffer sbCodeRuleBefore = new StringBuffer();
        StringBuffer sbCodeRuleAfter = new StringBuffer();
        boolean before = true;
        ICodingRuleEntry iCodingRuleEntry = CodingRuleEntryFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            creVO.setCodingRule(codingruleVO);
            if (before) {
                if (codingruleVO.getSplitSign() != null && codingruleVO.getSplitSign().trim().length() > 0 && creVO.getSerialNumber() != 1 && creVO.isIsSplitSign() && sbCodeRuleBefore.length() > 0) {
                    sbCodeRuleBefore.append(codingruleVO.getSplitSign());
                }
            } else if (codingruleVO.getSplitSign() != null && codingruleVO.getSplitSign().trim().length() > 0 && creVO.getSerialNumber() != 1 && creVO.isIsSplitSign()) {
                sbCodeRuleAfter.append(codingruleVO.getSplitSign());
            }
            String strCRE = "";
            if (creVO.getCodeAttribute().trim().equals("sn")) {
                strCRE = "";
                before = false;
            } else {
                strCRE = iCodingRuleEntry.getCREString(caller, creVO);
            }
            if ("isCustom == true".equals(strCRE)) {
                strCRE = customStr != null && customStr.trim().length() > 0 ? customStr.trim() : "";
            }
            strCRE = VoucherUtil.formatString(creVO, strCRE);
            if (!creVO.getCodeAttribute().trim().equals("sn") && creVO.isIsSortByItem()) {
                if (sortValue.toString().length() > 0) {
                    sortValue.append("_split_");
                }
                sortValue.append(strCRE);
            }
            if (!creVO.isIsDisplay()) continue;
            if (before) {
                sbCodeRuleBefore.append(strCRE);
                continue;
            }
            sbCodeRuleAfter.append(strCRE);
        }
        String[] values = new String[]{sortValue.toString(), sbCodeRuleBefore.toString() == null ? "" : sbCodeRuleBefore.toString(), sbCodeRuleAfter.toString() == null ? "" : sbCodeRuleAfter.toString()};
        return values;
    }

    private static String formatString(CodingRuleEntryInfo creVO, String initStr) throws BOSException, CodingRuleException {
        if (creVO.getCodeAttribute().equals("systime") || creVO.getCodeAttribute().equals("attribute") && (creVO.getAttUsingMode().equals("part") || creVO.getAttUsingMode().equals("reference")) || creVO.getCodeAttribute().equals("whole") && (creVO.getAttUsingMode().equals("part") || creVO.getAttUsingMode().equals("reference"))) {
            return initStr;
        }
        if (initStr == null || initStr.trim().length() == 0) {
            return "";
        }
        VoucherUtil.checkSerialNumberValid(creVO, initStr);
        if (creVO.getLength() > 0 && creVO.getLength() > initStr.length()) {
            if (creVO.getFillSign() != null && creVO.getFillSign().length() > 0 || creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn") && creVO.getLength() > initStr.length()) {
                int fillNumber = creVO.getLength() - initStr.length();
                if (creVO.getFillSignDirection() == DirectionType.Forward) {
                    if (creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn")) {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = "0" + initStr;
                        }
                    } else {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = creVO.getFillSign() + initStr;
                        }
                    }
                } else if (creVO.getFillSignDirection() == DirectionType.Backward) {
                    if (creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn")) {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = initStr + "0";
                        }
                    } else {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = initStr + creVO.getFillSign();
                        }
                    }
                }
            }
        } else if (creVO.getLength() > 0 && creVO.getLength() < initStr.length()) {
            initStr = "sn".equals(creVO.getCodeAttribute()) ? initStr.substring(initStr.length() - creVO.getLength(), initStr.length()) : initStr.substring(0, creVO.getLength());
        }
        return initStr;
    }

    private static void checkSerialNumberValid(CodingRuleEntryInfo creVO, String initStr) throws CodingRuleException {
        block4: {
            try {
                String crName;
                if (creVO.getCodeAttribute() == null || !creVO.getCodeAttribute().equals("sn") || !(creVO.getStep() > 0 && creVO.getLength() > 0 && (double)Long.parseLong(initStr.trim()) >= Math.pow(10.0, creVO.getLength())) && (creVO.getStep() >= 0 || Long.parseLong(initStr.trim()) >= 0L)) break block4;
                try {
                    crName = creVO.getCodingRule().getName();
                }
                catch (Exception ex) {
                    crName = "";
                }
                crName = crName == null ? "" : "\"" + crName + "\"";
                throw new CodingRuleException(CodingRuleException.INFO_NUMBERISUSEUP, new Object[]{crName});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static boolean isAddView(Context ctx, String comid) throws BOSException {
        return VoucherUtil.isAddView(ctx, comid, VoucherStatusEnum.SUBMITTED) || VoucherUtil.isAddView(ctx, comid, VoucherStatusEnum.TEMP);
    }

    private static boolean isAddView(Context ctx, String comid, VoucherStatusEnum status) throws BOSException {
        VoucherInfo voucher = new VoucherInfo();
        voucher.setBizStatus(status);
        try {
            boolean isAddNewCodingRule = false;
            boolean isAddNoBreakCodingRule = false;
            isAddNewCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isAddView((IObjectValue)voucher, comid, "bizStatus");
            isAddNoBreakCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getRuleStatus((IObjectValue)voucher, comid, "bizStatus").isAddNoBreak();
            return isAddNewCodingRule || isAddNoBreakCodingRule;
        }
        catch (EASBizException e) {
            throw new BOSException("Coding EASBIZException", (Throwable)e);
        }
    }

    public static void returnBudgetSubstract(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, BgCtrlException, EASBizException {
        boolean isExist = false;
        if (voucherInfo instanceof VoucherInfo) {
            isExist = voucherInfo.getId() != null && VoucherFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        } else if (voucherInfo instanceof PcVoucherInfo) {
            boolean bl = isExist = voucherInfo.getId() != null && PcVoucherFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
        if (isExist) {
            BgControlCaller bgControlCaller = new BgControlCaller();
            bgControlCaller.returnBudget(ctx, voucherInfo.getId());
        }
    }

    public static void fixAsstAccount(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        int i;
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (voucherInfo.getPeriod() == null) {
            return;
        }
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return;
        }
        if (voucherInfo.get("fixAsstAccount") != null && ((Boolean)voucherInfo.get("fixAsstAccount")).booleanValue()) {
            return;
        }
        HashSet<String> accountIds = new HashSet<String>();
        for (i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getAccount() == null) continue;
            accountIds.add(entry.getAccount().getId().toString());
        }
        if (accountIds.size() == 0) {
            return;
        }
        Map<String, AsstAccountInfo> caas = VoucherProcessCache.getCAAs(ctx, accountIds, voucherInfo.getPeriod());
        for (i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getAccount() == null) continue;
            String accountId = entry.getAccount().getId().toString();
            AsstAccountInfo newCaa = caas.get(accountId);
            AsstAccountInfo curCaa = entry.getCAA();
            if (newCaa == null && curCaa == null) continue;
            if (newCaa == null || curCaa == null) {
                entry.setCAA(newCaa);
                continue;
            }
            if (newCaa.getId().equals((Object)curCaa.getId())) continue;
            entry.setCAA(newCaa);
        }
        voucherInfo.put("fixAsstAccount", (Object)Boolean.TRUE);
    }

    public static boolean existVoucher(Context ctx, VoucherInfo voucherInfo, CompanyOrgUnitInfo transferOrg) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fis = filter.getFilterItems();
        fis.add(new FilterItemInfo("voucherType", (Object)voucherInfo.getVoucherType().getId().toString()));
        fis.add(new FilterItemInfo("number", (Object)voucherInfo.getNumber()));
        fis.add(new FilterItemInfo("company.id", (Object)transferOrg.getId().toString()));
        fis.add(new FilterItemInfo("period.id", (Object)voucherInfo.getPeriod().getId().toString()));
        return VoucherFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    private static void batchVoucherNumberChanged(Context ctx, Map voucherMap) throws BOSException {
        if (voucherMap == null || voucherMap.isEmpty()) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String[]> changedVoucherMap = new HashMap<String, String[]>();
        paramMap.put("ctx", ctx);
        paramMap.put("changedVoucher", changedVoucherMap);
        for (Object id : voucherMap.keySet()) {
            String oldNumber;
            String vchId = id.toString();
            String[] values = (String[])voucherMap.get(vchId);
            String newNumber = values[1];
            if (newNumber.equals(oldNumber = values[0])) continue;
            changedVoucherMap.put(vchId, new String[]{values[0], values[1]});
        }
        RegisteredServiceUtil.invokeService(ctx, "batchVoucherNumberChanged", paramMap);
    }

    public static boolean isGlStarted(Context ctx, CompanyOrgUnitInfo curCompany) throws EASBizException, BOSException {
        String curCompanyID = curCompany.getId().toString();
        AccountTools.checkCompanyAccountTable((Context)ctx, (CompanyOrgUnitInfo)curCompany);
        String accounttableid = curCompany.getAccountTable().getId().toString();
        String sql = " select 1 from t_bd_systemstatus a ,t_bd_systemstatusctrol b  where a.fname=6 and b.fsystemstatusid=a.fid and b.fcompanyid=?  and b.fstartperiodid=b.fcurrentperiodid";
        boolean isCur = false;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{curCompanyID});
        try {
            if (set.next()) {
                isCur = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (isCur) {
            return false;
        }
        isCur = InitHelp.existsAsstOrAcctcussentNotInit(ctx, curCompanyID, accounttableid);
        return !isCur;
    }

    public static String decodeSplitFlag(String srcString) {
        srcString = srcString.replace("\\u003b", ";").replaceAll("\\u003b", ";");
        return srcString;
    }
}

