/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AsstDataChangeEvent;
import com.kingdee.eas.fi.gl.AsstDataChangeResult;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.app.asstf7.IAsstDataChangeListener;
import com.kingdee.util.StringUtils;

public class BankChangedListener
implements IAsstDataChangeListener {
    @Override
    public AsstDataChangeResult dataChanged(Context ctx, AsstDataChangeEvent event) throws BOSException, EASBizException {
        return new AsstDataChangeResult(null, this.getAccountBankFilterInfo(ctx, event.getAsstDataId(), event.getCompanyId(), event.getAccountId(), event.getCurrencyId()));
    }

    public FilterInfo getAccountBankFilterInfo(Context ctx, String bankId, String companyId, String accountId, String currencyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)companyId));
        fic.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        if (accountId != null) {
            GlParam param = GlParam.getGlParams((Context)ctx, (String)"GL_0155", (String)companyId);
            boolean isCashEquivalentFilterAccount = param.getBoolean("GL_0155");
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("isBank"));
            selector.add(new SelectorItemInfo("isCashEquivalent"));
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
            if (account.isIsBank() || isCashEquivalentFilterAccount && account.isIsCashEquivalent()) {
                fic.add(new FilterItemInfo("account.id", (Object)account.getId().toString()));
            }
        }
        if (!StringUtils.isEmpty((String)bankId)) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankId));
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString(" (#0 or #1)");
            filter.mergeFilter(currencyFilter, "and");
        }
        return filter;
    }
}

