/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gl.app.check.CheckAppUtil;
import com.kingdee.eas.fi.gl.app.check.IClosePeriodCheck;
import com.kingdee.eas.fi.gl.check.BigDecimalCalcEngine;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.ClosePeriodCheckParam;
import com.kingdee.eas.fi.gl.check.GroupFilterEntity;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class BizObjClosePeriodCheck
implements IClosePeriodCheck {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.BizObjClosePeriodCheck");

    @Override
    public CheckResult check(ClosePeriodCheckParam checkParam) {
        Context ctx = checkParam.getCtx();
        FullOrgUnitInfo fullOrgUnitInfo = checkParam.getFullOrgUnitInfo();
        CheckSchemeInfo checkSchemeInfo = checkParam.getCheckSchemeInfo();
        String filter = checkSchemeInfo.getFilter();
        String groupFiler = checkSchemeInfo.getGroupFilter();
        if (checkSchemeInfo.getConfig() == null || StringUtils.isEmpty((String)checkSchemeInfo.getConfig().getBizQuery())) {
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noBizObj"));
        }
        try {
            Map<GroupFilterEntity, List<BigDecimal>> entityMap;
            boolean groupFilterResult;
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)checkSchemeInfo.getSubSystem(), (IObjectPK)new ObjectUuidPK(fullOrgUnitInfo.getId().toString()));
            if (periodInfo == null) {
                return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noCurrentPeriod"));
            }
            String defaultFilter = this.getDefaultFilter(fullOrgUnitInfo, periodInfo, checkSchemeInfo);
            String queryOql = "where " + filter + defaultFilter;
            String bizQuery = checkSchemeInfo.getConfig().getBizQuery();
            IQueryExecutor queryExecutor = CheckAppUtil.getQueryExecutor(ctx, bizQuery, queryOql);
            logger.error((Object)("check execute sql:" + queryExecutor.getSQL()));
            IRowSet queryResult = queryExecutor.executeQuery();
            if (StringUtils.isEmpty((String)groupFiler) ? queryResult.next() : (groupFilterResult = this.groupFilterResult(entityMap = this.getGroupFilterData(groupFiler, queryResult)))) {
                return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "checkFail"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"bizObj closePeriodCheck error.", (Throwable)e);
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "checkException"));
        }
        return CheckAppUtil.successResult(CheckAppUtil.getResource(ctx, "checkSuccess"));
    }

    private String getDefaultFilter(FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, CheckSchemeInfo checkSchemeInfo) {
        String defaultFilter = null;
        String bizNumber = checkSchemeInfo.getConfig().getBizNumber();
        if ("AcctCussent".equals(bizNumber) || "AcctVerify".equals(bizNumber)) {
            Timestamp endDate = periodInfo.getEndDate();
            defaultFilter = " and orgUnit.id = '" + fullOrgUnitInfo.getId().toString() + "' and (period.id='AAAAAAAAAAAAAAAAAAAAAII4jEw=' or bookedDate<= {" + new Date(endDate.getTime()) + "})";
        } else {
            defaultFilter = " and orgUnit.id = '" + fullOrgUnitInfo.getId().toString() + "' and period.id = '" + periodInfo.getId().toString() + "'";
        }
        return defaultFilter;
    }

    private Map<GroupFilterEntity, List<BigDecimal>> getGroupFilterData(String groupFiler, IRowSet queryResult) throws SQLException {
        List<GroupFilterEntity> groupFilterEntityList = CheckUtil.jsonToGroupFilterEntityList(groupFiler);
        LinkedHashMap<GroupFilterEntity, List<BigDecimal>> entityMap = new LinkedHashMap<GroupFilterEntity, List<BigDecimal>>();
        while (queryResult.next()) {
            for (GroupFilterEntity groupFilterEntity : groupFilterEntityList) {
                BigDecimal obj = queryResult.getBigDecimal(groupFilterEntity.getCompareObjSrc().getValue());
                if (obj == null) continue;
                if (entityMap.containsKey(groupFilterEntity)) {
                    ((List)entityMap.get(groupFilterEntity)).add(obj);
                    continue;
                }
                ArrayList<BigDecimal> values = new ArrayList<BigDecimal>();
                values.add(obj);
                entityMap.put(groupFilterEntity, values);
            }
        }
        if (entityMap.size() == 0) {
            for (GroupFilterEntity groupFilterEntity : groupFilterEntityList) {
                ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(1);
                values.add(BigDecimal.ZERO);
                entityMap.put(groupFilterEntity, values);
            }
        }
        return entityMap;
    }

    private boolean groupFilterResult(Map<GroupFilterEntity, List<BigDecimal>> entityMap) throws ScriptException {
        ArrayList<Map.Entry<GroupFilterEntity, List<BigDecimal>>> entryList = new ArrayList<Map.Entry<GroupFilterEntity, List<BigDecimal>>>(entityMap.entrySet());
        StringBuilder expSb = new StringBuilder();
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)entryList.get(i);
            GroupFilterEntity groupFilterEntity = (GroupFilterEntity)entry.getKey();
            String target = groupFilterEntity.getCompareObjTarget();
            List values = (List)entry.getValue();
            BigDecimal calcResult = BigDecimalCalcEngine.calc(groupFilterEntity.getGroupType(), values);
            boolean compareResult = CheckUtil.compareResult(groupFilterEntity.getCompareType(), calcResult, new BigDecimal(target));
            if (i == size - 1) {
                groupFilterEntity.setLogicType(null);
            }
            CheckUtil.setExp(groupFilterEntity, compareResult, expSb);
        }
        return CheckUtil.exeLogicExp(expSb.toString());
    }
}

