/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.check.AbstractCheckSchemeControllerBean;
import com.kingdee.eas.fi.gl.app.check.AsynRunEngine;
import com.kingdee.eas.fi.gl.app.check.CheckAppUtil;
import com.kingdee.eas.fi.gl.app.check.CheckJobService;
import com.kingdee.eas.fi.gl.app.check.CheckScheduleUtil;
import com.kingdee.eas.fi.gl.app.check.CheckTask;
import com.kingdee.eas.fi.gl.app.check.RunCheckTask;
import com.kingdee.eas.fi.gl.check.CheckConfigCollection;
import com.kingdee.eas.fi.gl.check.CheckConfigFactory;
import com.kingdee.eas.fi.gl.check.CheckConfigInfo;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.CheckSchemeAssignFacadeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeCollection;
import com.kingdee.eas.fi.gl.check.CheckSchemeException;
import com.kingdee.eas.fi.gl.check.CheckSchemeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobStatus;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationCollection;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeScheduleFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeScheduleInfo;
import com.kingdee.eas.fi.gl.check.ClosePeriodCheckParam;
import com.kingdee.eas.fi.gl.check.ConfigType;
import com.kingdee.eas.fi.gl.check.CtrlType;
import com.kingdee.eas.fi.gl.check.SchemeStatus;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckSchemeControllerBean
extends AbstractCheckSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.CheckSchemeControllerBean");
    private int limit = 1000;
    private AsynRunEngine asynEngine = new AsynRunEngine();

    @Override
    protected Map _fetchInitData(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap initData = new HashMap();
        HashSet<SystemEnum> systems = new HashSet<SystemEnum>();
        CheckConfigCollection checkConfigCol = CheckConfigFactory.getLocalInstance(ctx).getCollection();
        for (int i = 0; i < checkConfigCol.size(); ++i) {
            CheckConfigInfo checkConfigInfo = checkConfigCol.get(i);
            SystemEnum subSystem = checkConfigInfo.getSubSystem();
            systems.add(subSystem);
        }
        initData.put("allSubSystem", systems);
        return initData;
    }

    @Override
    protected void _startBackTask(Context ctx, String checkSchemeId) throws BOSException, EASBizException {
        WfEventListenerStateManager.getInstance().enableEventListener();
        ctx.put((Object)"isBack", (Object)true);
        try {
            this._checkByCheckScheme(ctx, checkSchemeId);
        }
        catch (CheckSchemeException e) {
            CheckSchemeInfo checkSchemeInfo = this.getCheckSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(checkSchemeId));
            CheckJobService.createFinishedJobInfo(ctx, null, checkSchemeInfo, CheckSchemeJobStatus.failed, e.getMessage());
        }
    }

    @Override
    protected void _checkByCheckScheme(Context ctx, String checkSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)checkSchemeId)) {
            return;
        }
        ArrayList<String> checkSchemeIds = new ArrayList<String>(1);
        checkSchemeIds.add(checkSchemeId);
        this._checkByCheckScheme(ctx, checkSchemeIds);
    }

    @Override
    protected void _checkByCheckScheme(Context ctx, List checkSchemeIds) throws BOSException, EASBizException {
        if (checkSchemeIds == null || checkSchemeIds.size() <= 0) {
            return;
        }
        List checkSchemeList = checkSchemeIds;
        StringBuilder errorMsg = new StringBuilder();
        CheckSchemeCollection checkSchemeCol = this.getCheckSchemes(ctx, new HashSet<String>(checkSchemeList));
        for (int i = 0; i < checkSchemeCol.size(); ++i) {
            CheckSchemeInfo checkSchemeInfo = checkSchemeCol.get(i);
            OrgType orgType = CheckUtil.getOrgTypeBySubSystem(checkSchemeInfo.getSubSystem());
            FullOrgUnitCollection orgs = this.getOrgsByCheckScheme(ctx, checkSchemeInfo.getId().toString(), orgType);
            if (orgs == null || orgs.size() <= 0) {
                errorMsg.append(CheckAppUtil.getResource(ctx, "schemeNotAssignOrg", (Object[])new String[]{checkSchemeInfo.getName()})).append("\r\n");
                continue;
            }
            this.runTask(ctx, this.createCheckTasks(ctx, orgs, checkSchemeInfo), ctx.get((Object)"isBack") == null);
        }
        if (errorMsg.length() > 0) {
            throw new CheckSchemeException(CheckSchemeException.CHECKEXCEPTION, new String[]{errorMsg.toString()});
        }
    }

    @Override
    protected List _checkByOrg(Context ctx, String orgId, OrgType orgType, CtrlType ctrlType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        Set<String> checkSchemeIds = this.getCheckSchemeIdsByOrg(ctx, orgId);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", checkSchemeIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("ctrlType", (Object)ctrlType.getValue()));
        CheckSchemeCollection checkSchemes = this.getCheckSchemes(ctx, this.getDefaultSelectors(), filterInfo);
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        List<CheckResult> checkResults = null;
        if (checkSchemes != null && checkSchemes.size() > 0) {
            checkResults = this.runTaskWithReturn(ctx, this.createCheckTasks(ctx, fullOrgUnitInfo, checkSchemes));
        }
        return checkResults;
    }

    @Override
    protected void _checkByOrgAndScheme(Context ctx, String orgId, String checkSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)checkSchemeId)) {
            return;
        }
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        if (fullOrgUnitInfo == null) {
            throw new CheckSchemeException(CheckSchemeException.ORGNOTEXISTS);
        }
        CheckSchemeInfo checkSchemeInfo = this.getCheckSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(checkSchemeId), this.getDefaultSelectors());
        if (checkSchemeInfo == null) {
            throw new CheckSchemeException(CheckSchemeException.SCHEMENOTEXISTS);
        }
        this.runTask(ctx, this.createCheckTasks(ctx, fullOrgUnitInfo, checkSchemeInfo, CheckUtil.getCheckJobName()), false);
    }

    private List<CheckResult> runTaskWithReturn(Context ctx, List<CheckTask> checkTasks) throws BOSException, EASBizException {
        ArrayList<CheckResult> checkResults = new ArrayList<CheckResult>(checkTasks.size());
        for (CheckTask checkTask : checkTasks) {
            CheckSchemeInfo checkSchemeInfo = checkTask.getCheckSchemeInfo();
            ClosePeriodCheckParam closeCheckParam = new ClosePeriodCheckParam(ctx, checkTask.getFullOrgUnitInfo(), checkSchemeInfo);
            CheckResult checkResult = checkTask.getClosePeriodCheckProcessor().check(closeCheckParam);
            checkResult.setMessage(CheckAppUtil.getResource(ctx, "checkSchemeResult", (Object[])new String[]{checkSchemeInfo.getName() + checkSchemeInfo.getNumber(), checkResult.getMessage()}));
            checkResults.add(checkResult);
        }
        return checkResults;
    }

    private void runTask(Context ctx, CheckTask checkTask, boolean isAsyn) throws BOSException, EASBizException {
        RunCheckTask runCheckTask = new RunCheckTask(ctx, checkTask);
        if (isAsyn) {
            this.asynEngine.asynRunTask(runCheckTask);
        } else {
            runCheckTask.runRask();
        }
    }

    private void runTask(Context ctx, List<CheckTask> checkTasks, boolean isAsyn) throws BOSException, EASBizException {
        for (CheckTask checkTask : checkTasks) {
            this.runTask(ctx, checkTask, isAsyn);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckSchemeOrgRelationInfo checkSchemeOrgRelationInfo;
        boolean isNewAdd;
        CheckSchemeInfo checkSchemeInfo = (CheckSchemeInfo)model;
        FullOrgUnitInfo createOrg = checkSchemeInfo.getCreateOrg();
        String createOrgId = createOrg.getId().toString();
        String currentOrgId = CheckUtil.getCurrentOrgId(ctx);
        ObjectUuidPK pk = null;
        boolean bl = isNewAdd = checkSchemeInfo.getId() == null;
        if (createOrgId.equals(currentOrgId)) {
            this.check(ctx, checkSchemeInfo);
            this.saveSchemeSchedule(ctx, checkSchemeInfo);
            pk = super._submit(ctx, model);
            if (isNewAdd) {
                CheckSchemeAssignFacadeFactory.getLocalInstance(ctx).assign(CheckUtil.getCurrentOrgId(ctx), pk.toString());
            }
        }
        if (checkSchemeInfo.getId() != null && (checkSchemeOrgRelationInfo = CheckSchemeOrgRelationFactory.getLocalInstance(ctx).getCheckSchemOrgRelationInfo(checkSchemeInfo.getId().toString(), currentOrgId)) != null) {
            checkSchemeOrgRelationInfo.setResponsibles(checkSchemeInfo.getResponsibles() == null ? null : checkSchemeInfo.getResponsibles().getId().toString());
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("responsibles"));
            CheckSchemeOrgRelationFactory.getLocalInstance(ctx).updatePartial(checkSchemeOrgRelationInfo, selectors);
        }
        return pk == null ? new ObjectUuidPK(checkSchemeInfo.getId().toString()) : pk;
    }

    private void saveSchemeSchedule(Context ctx, CheckSchemeInfo checkSchemeInfo) throws BOSException, EASBizException {
        CheckSchemeScheduleInfo scheduleInfo = checkSchemeInfo.getSchedule();
        if (scheduleInfo != null && scheduleInfo.getId() == null) {
            CheckSchemeScheduleFactory.getLocalInstance(ctx).submit((CoreBaseInfo)scheduleInfo);
        } else if (scheduleInfo != null && scheduleInfo.getId() != null) {
            CheckSchemeScheduleFactory.getLocalInstance(ctx).submit((IObjectPK)new ObjectUuidPK(scheduleInfo.getId()), (CoreBaseInfo)scheduleInfo);
        }
    }

    protected void check(Context ctx, CheckSchemeInfo checkSchemeInfo) throws BOSException, EASBizException {
        String schemeNumber = checkSchemeInfo.getNumber();
        if (StringUtils.isEmpty((String)schemeNumber)) {
            throw new CheckSchemeException(CheckSchemeException.NUMBERCANNOTNULL);
        }
        String sql = null;
        ArrayList<String> params = new ArrayList<String>();
        params.add(schemeNumber);
        if (checkSchemeInfo.getId() != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(checkSchemeInfo.getId().toString()))) {
            sql = "select top 1 1 from t_check_scheme where fnumber = ? and fid <> ?";
            params.add(checkSchemeInfo.getId().toString());
        } else {
            sql = "select top 1 1 from t_check_scheme where fnumber = ?";
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
        try {
            if (result.next()) {
                throw new CheckSchemeException(CheckSchemeException.EXISTSAMENUMBER);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query scheme number exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (ConfigType.formula == checkSchemeInfo.getCtrlConfigType()) {
            checkSchemeInfo.put("subSystem", null);
        }
    }

    @Override
    protected void _enable(Context ctx, List schemes) throws BOSException, EASBizException {
        if (schemes == null || schemes.size() <= 0) {
            return;
        }
        CheckSchemeCollection checkSchemes = this.getCheckSchemes(ctx, new HashSet<String>(schemes));
        if (checkSchemes == null || checkSchemes.size() <= 0) {
            return;
        }
        IObjectPK logPK = this.logAboutEnableOrDisable(ctx, checkSchemes, "schemeEnable");
        this.enableOrDisableSchedule(ctx, checkSchemes, true);
        this.changeSchemeStatus(ctx, this.getSchemeIdList(checkSchemes), SchemeStatus.enable);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private List<String> getSchemeIdList(CheckSchemeCollection checkSchemes) {
        ArrayList<String> schemeIdList = new ArrayList<String>(checkSchemes.size());
        for (int i = 0; i < checkSchemes.size(); ++i) {
            schemeIdList.add(checkSchemes.get(i).getId().toString());
        }
        return schemeIdList;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("createOrg"));
        selectors.add(new SelectorItemInfo("schedule.id"));
        selectors.add(new SelectorItemInfo("schedule.schemeXML"));
        selectors.add(new SelectorItemInfo("schedule.jobDefID"));
        CheckSchemeInfo checkSchemeInfo = this.getCheckSchemeInfo(ctx, pk, selectors);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_delete", (BOSObjectType)checkSchemeInfo.getBOSType(), (IObjectPK)pk, (String)checkSchemeInfo.getNumber(), (String)CheckAppUtil.getResource(ctx, "checkSchemeDel"));
        String currentOrgId = CheckUtil.getCurrentOrgId(ctx);
        String createOrgId = checkSchemeInfo.getCreateOrg().getId().toString();
        if (createOrgId.equals(currentOrgId)) {
            if (checkSchemeInfo.getSchedule() != null) {
                CheckScheduleUtil.disableSchedule(ctx, checkSchemeInfo.getSchedule());
                CheckSchemeScheduleFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(checkSchemeInfo.getSchedule().getId()));
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("schemeId", (Object)pk.toString()));
            CheckSchemeOrgRelationFactory.getLocalInstance(ctx).delete(filterInfo);
            super.innerDelete(ctx, pk);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("schemeId", (Object)pk.toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgId", (Object)currentOrgId));
            CheckSchemeOrgRelationFactory.getLocalInstance(ctx).delete(filterInfo);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void enableOrDisableSchedule(Context ctx, CheckSchemeCollection checkSchemeInfos, boolean enable) throws EASBizException, BOSException {
        OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        for (int i = 0; i < checkSchemeInfos.size(); ++i) {
            CheckSchemeInfo checkSchemeInfo = checkSchemeInfos.get(i);
            if (enable) {
                this.enableSchedule(ctx, checkSchemeInfo);
                continue;
            }
            if (checkSchemeInfo.getCreateOrg() == null || !checkSchemeInfo.getCreateOrg().getId().toString().equals(currentOrgUnit.getId().toString())) continue;
            this.disableSchedule(ctx, checkSchemeInfo);
        }
    }

    private void enableSchedule(Context ctx, CheckSchemeInfo checkSchemeInfo) throws EASBizException, BOSException {
        CheckSchemeScheduleInfo schedule = checkSchemeInfo.getSchedule();
        if (schedule != null && schedule.getId() != null) {
            String jobDefId = CheckScheduleUtil.enableSchedule(ctx, checkSchemeInfo);
            String sql = "update t_check_schedule set FJobDefID = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{jobDefId, schedule.getId().toString()});
        }
    }

    @Override
    protected void _disable(Context ctx, List schemes) throws BOSException, EASBizException {
        if (schemes == null || schemes.size() <= 0) {
            return;
        }
        CheckSchemeCollection checkSchemes = this.getCheckSchemes(ctx, new HashSet<String>(schemes));
        IObjectPK logPK = this.logAboutEnableOrDisable(ctx, checkSchemes, "schemeDisable");
        this.enableOrDisableSchedule(ctx, checkSchemes, false);
        this.changeSchemeStatus(ctx, this.getSchemeIdList(checkSchemes), SchemeStatus.disenable);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private IObjectPK logAboutEnableOrDisable(Context ctx, CheckSchemeCollection checkSchemes, String logItem) {
        StringBuilder logDetail = new StringBuilder();
        for (int i = 0; i < checkSchemes.size(); ++i) {
            logDetail.append(checkSchemes.get(i).getNumber()).append(",");
        }
        logDetail = logDetail.deleteCharAt(logDetail.length() - 1);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)logItem, (BOSObjectType)new CheckSchemeInfo().getBOSType(), null, (String)logDetail.toString(), (String)CheckAppUtil.getResource(ctx, logItem));
        return logPK;
    }

    private void disableSchedule(Context ctx, CheckSchemeInfo checkSchemeInfo) throws EASBizException, BOSException {
        CheckSchemeScheduleInfo schedule = checkSchemeInfo.getSchedule();
        if (schedule != null && schedule.getId() != null) {
            CheckScheduleUtil.disableSchedule(ctx, schedule);
            String sql = "update t_check_schedule set FJobDefID = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{schedule.getId().toString()});
        }
    }

    private void changeSchemeStatus(Context ctx, List<String> schemes, SchemeStatus status) throws BOSException {
        String updateSchemeStatusSql;
        String currentOrgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        if (schemes.size() > this.limit) {
            String tempTable = null;
            try {
                tempTable = CheckAppUtil.getTempTableByIds(ctx, schemes);
                updateSchemeStatusSql = "update t_check_companySchemeRelation set FSchemeStatus = ? where FCheckSchemeID in (select fid from " + tempTable + ") and FOrgId = ?";
                DbUtil.execute((Context)ctx, (String)updateSchemeStatusSql, (Object[])new Object[]{status.getValue(), currentOrgId});
            }
            catch (Exception e) {
                logger.error((Object)"enable scheme exception.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty((String)tempTable)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
            }
        }
        if (schemes.size() > 0) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(status.getValue());
            params.addAll(schemes);
            params.add(currentOrgId);
            updateSchemeStatusSql = "update t_check_companySchemeRelation set FSchemeStatus = ? where FCheckSchemeID in(" + CheckUtil.getSqlIn(schemes) + ") and FOrgId = ?";
            DbUtil.execute((Context)ctx, (String)updateSchemeStatusSql, (Object[])params.toArray());
        }
    }

    private CheckTask createCheckTasks(Context ctx, FullOrgUnitInfo orgUnitInfo, CheckSchemeInfo checkSchemeInfo, String jobName) throws EASBizException, BOSException {
        CheckSchemeOrgRelationInfo checkSchemOrgRelationInfo = CheckSchemeOrgRelationFactory.getLocalInstance(ctx).getCheckSchemOrgRelationInfo(checkSchemeInfo.getId().toString(), orgUnitInfo.getId().toString());
        CheckTask checkTask = new CheckTask(orgUnitInfo, checkSchemeInfo, checkSchemOrgRelationInfo, jobName);
        return checkTask;
    }

    private List<CheckTask> createCheckTasks(Context ctx, FullOrgUnitCollection orgs, CheckSchemeInfo checkSchemeInfo) throws EASBizException, BOSException {
        String jobName = CheckUtil.getCheckJobName();
        ArrayList<CheckTask> checkTasks = new ArrayList<CheckTask>();
        for (int i = 0; i < orgs.size(); ++i) {
            checkTasks.add(this.createCheckTasks(ctx, orgs.get(i), checkSchemeInfo, jobName));
        }
        return checkTasks;
    }

    private List<CheckTask> createCheckTasks(Context ctx, FullOrgUnitInfo orgUnitInfo, CheckSchemeCollection checkSchemes) throws EASBizException, BOSException {
        String jobName = CheckUtil.getCheckJobName();
        ArrayList<CheckTask> checkTasks = new ArrayList<CheckTask>();
        for (int i = 0; i < checkSchemes.size(); ++i) {
            checkTasks.add(this.createCheckTasks(ctx, orgUnitInfo, checkSchemes.get(i), jobName));
        }
        return checkTasks;
    }

    private CheckSchemeOrgRelationCollection getSchemeOrgRlationByOrg(Context ctx, String orgId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgId", (Object)orgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("schemeStatus", (Object)1));
        view.setFilter(filterInfo);
        CheckSchemeOrgRelationCollection csRs = CheckSchemeOrgRelationFactory.getLocalInstance(ctx).getCollection(view);
        return csRs;
    }

    private CheckSchemeCollection getCheckSchemesByOrg(Context ctx, String orgId) throws BOSException {
        Set<String> checkSchemeIds = this.getCheckSchemeIdsByOrg(ctx, orgId);
        return this.getCheckSchemes(ctx, checkSchemeIds);
    }

    private Set<String> getCheckSchemeIdsByOrg(Context ctx, String orgId) throws BOSException {
        CheckSchemeOrgRelationCollection csRs = this.getSchemeOrgRlationByOrg(ctx, orgId);
        HashSet<String> checkSchemeIds = new HashSet<String>();
        for (int i = 0; i < csRs.size(); ++i) {
            checkSchemeIds.add(csRs.get(i).getSchemeId().toString());
        }
        return checkSchemeIds;
    }

    private SelectorItemCollection getDefaultSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("config.*"));
        selectors.add(new SelectorItemInfo("schedule.id"));
        selectors.add(new SelectorItemInfo("schedule.schemeXML"));
        selectors.add(new SelectorItemInfo("schedule.jobDefID"));
        return selectors;
    }

    private CheckSchemeCollection getCheckSchemes(Context ctx, Set<String> checkSchemeIds) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", checkSchemeIds, CompareType.INCLUDE));
        return this.getCheckSchemes(ctx, this.getDefaultSelectors(), filterInfo);
    }

    private CheckSchemeCollection getCheckSchemes(Context ctx, SelectorItemCollection selectors, FilterInfo filterInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selectors);
        view.setFilter(filterInfo);
        CheckSchemeCollection checkSchemeCollection = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeCollection(view);
        return checkSchemeCollection;
    }

    private CheckSchemeOrgRelationCollection getSchemeOrgRlationByCheckScheme(Context ctx, String checkSchemeId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("schemeId", (Object)checkSchemeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("schemeStatus", (Object)1));
        view.setFilter(filterInfo);
        CheckSchemeOrgRelationCollection csRs = CheckSchemeOrgRelationFactory.getLocalInstance(ctx).getCollection(view);
        return csRs;
    }

    private FullOrgUnitCollection getOrgsByCheckScheme(Context ctx, String checkSchemeId, OrgType orgType) throws BOSException {
        CheckSchemeOrgRelationCollection csRs = this.getSchemeOrgRlationByCheckScheme(ctx, checkSchemeId);
        HashSet<String> orgIds = new HashSet<String>();
        for (int i = 0; i < csRs.size(); ++i) {
            orgIds.add(csRs.get(i).getOrgId().toString());
        }
        return this.getFullOrgUnits(ctx, orgIds, orgType);
    }

    private FullOrgUnitCollection getFullOrgUnits(Context ctx, Set<String> orgIds, OrgType orgType) throws BOSException {
        if (orgType == OrgType.Company) {
            EntityViewInfo companyView = new EntityViewInfo();
            companyView.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo companyFilterInfo = new FilterInfo();
            companyFilterInfo.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
            companyFilterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1));
            companyView.setFilter(companyFilterInfo);
            CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(companyView);
            orgIds = new HashSet<String>();
            for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
                orgIds.add(companyOrgUnitCollection.get(i).getId().toString());
            }
        }
        EntityViewInfo orgView = new EntityViewInfo();
        FilterInfo orgFilterInfo = new FilterInfo();
        orgFilterInfo.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
        orgView.setFilter(orgFilterInfo);
        FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(orgView);
        return fullOrgUnitCollection;
    }
}

