/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.check.CheckAppUtil;
import com.kingdee.eas.fi.gl.app.check.IClosePeriodCheck;
import com.kingdee.eas.fi.gl.check.CheckCompareType;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.ClosePeriodCheckParam;
import com.kingdee.eas.fi.gl.check.CommonFilterEntity;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.app.ReportFormulaFacade;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class FormulaClosePeriodCheck
implements IClosePeriodCheck {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.FormulaClosePeriodCheck");

    @Override
    public CheckResult check(ClosePeriodCheckParam checkParam) {
        Context ctx = checkParam.getCtx();
        FullOrgUnitInfo fullOrgUnitInfo = checkParam.getFullOrgUnitInfo();
        CheckSchemeInfo checkSchemeInfo = checkParam.getCheckSchemeInfo();
        String formulaFilter = checkSchemeInfo.getFormulaFilter();
        logger.error((Object)("calc formula check,org:" + fullOrgUnitInfo.getName() + ",checkScheme:" + checkSchemeInfo.getName()));
        if (StringUtils.isEmpty((CharSequence)formulaFilter)) {
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noFormula"));
        }
        try {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(fullOrgUnitInfo.getId().toString()));
            if (periodInfo == null) {
                return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noCurrentPeriod"));
            }
            Gson gson = new Gson();
            JsonArray filterJsonArray = (JsonArray)gson.fromJson(formulaFilter, JsonArray.class);
            StringBuilder expSb = new StringBuilder();
            int size = filterJsonArray.size();
            for (int i = 0; i < size; ++i) {
                CommonFilterEntity filterEntity = CheckUtil.jsonToFilterEntity(gson, filterJsonArray.get(i));
                String srcFormula = filterEntity.getCompareObjSrc().getValue();
                CheckCompareType compareType = filterEntity.getCompareType();
                String targetFormula = filterEntity.getCompareObjTarget();
                BigDecimal srcResult = this.calcFomula(ctx, fullOrgUnitInfo, periodInfo, srcFormula, OrgType.Company);
                logger.error((Object)("calc fomula[" + srcFormula + "] result:" + srcResult));
                if (srcResult == null) {
                    return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "formulaCalcError"));
                }
                BigDecimal targetResult = this.calcFomula(ctx, fullOrgUnitInfo, periodInfo, targetFormula, OrgType.Company);
                logger.error((Object)("calc fomula[" + targetFormula + "] result:" + targetResult));
                if (targetResult == null) {
                    return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "formulaError"));
                }
                boolean result = CheckUtil.compareResult(compareType, srcResult, targetResult);
                if (i == size - 1) {
                    filterEntity.setLogicType(null);
                }
                CheckUtil.setExp(filterEntity, result, expSb);
            }
            boolean filterResult = CheckUtil.exeLogicExp(expSb.toString());
            if (filterResult) {
                return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "checkFail"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"calcFormula closePeriodCheck exception.", (Throwable)e);
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "checkException"));
        }
        return CheckAppUtil.successResult(CheckAppUtil.getResource(ctx, "checkSuccess"));
    }

    private BigDecimal calcFomula(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, String formula, OrgType orgType) throws EASBizException, BOSException {
        ReportFormulaFacade iReportFacade = new ReportFormulaFacade();
        BigDecimal srcResult = null;
        if (CheckUtil.isFormula(formula)) {
            ReportInfo reportInfo = this.genReportInfo(ctx, formula, periodInfo, fullOrgUnitInfo, orgType);
            srcResult = iReportFacade.calcFomula(ctx, (IObjectValue)reportInfo, "=" + formula);
        } else if (CheckUtil.isDecimal(formula)) {
            srcResult = new BigDecimal(formula);
        }
        return srcResult;
    }

    private ReportInfo genReportInfo(Context ctx, String formula, PeriodInfo curPeriod, FullOrgUnitInfo curCompany, OrgType orgType) throws EASBizException, BOSException {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSourceType(RptSrcTypeEnum.NORMAL);
        reportInfo.setYear(curPeriod.getPeriodYear());
        reportInfo.setPeriod(new Integer(curPeriod.getPeriodNumber()).shortValue());
        reportInfo.setStartDate(curPeriod.getBeginDate());
        reportInfo.setEndDate((Date)curPeriod.getEndDate());
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        reportInfo.setCompany(curCompany);
        reportInfo.setOrgType(orgType);
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        rptSheetParamInfo.setStartYear(curPeriod.getPeriodYear());
        rptSheetParamInfo.setEndYear(curPeriod.getPeriodYear());
        rptSheetParamInfo.setSheetName("Sheet1");
        reportInfo.getSheetParam().add(rptSheetParamInfo);
        if (curCompany.isIsCompanyOrgUnit()) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("baseCurrency.id"));
            selectors.add(new SelectorItemInfo("baseCurrency.number"));
            selectors.add(new SelectorItemInfo("baseCurrency.name"));
            selectors.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompany.getId()), selectors);
            reportInfo.setCurrency(companyOrgUnitInfo.getBaseCurrency());
        }
        RptPeriodTypeEnum temp = RptPeriodTypeEnum.MONTHLY;
        String[] formulas = formula.split(",");
        if (formulas.length >= 7) {
            temp = "\"DAILY\"".equals(formulas[6]) ? RptPeriodTypeEnum.DAILY : ("\"WEEKLY\"".equals(formulas[6]) ? RptPeriodTypeEnum.WEEKLY : ("\"QUARTERLY\"".equals(formulas[6]) ? RptPeriodTypeEnum.QUARTERLY : ("\"SEMIYEARLY\"".equals(formulas[6]) ? RptPeriodTypeEnum.SEMIYEARLY : ("\"YEARLY\"".equals(formulas[6]) ? RptPeriodTypeEnum.YEARLY : RptPeriodTypeEnum.MONTHLY))));
        }
        reportInfo.setPeriodType(temp);
        Date nowDate = new Date();
        PeriodInfo sysPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)nowDate, (IObjectPK)new ObjectUuidPK(curCompany.getId()));
        int[] date = null;
        date = sysPeriod != null && curPeriod.getId().toString().equals(sysPeriod.getId().toString()) ? RPTDateUtil.getPeriod((Date)nowDate, (RptPeriodTypeEnum)temp) : RPTDateUtil.getPeriod((Date)curPeriod.getEndDate(), (RptPeriodTypeEnum)temp);
        reportInfo.setYear(date[0]);
        reportInfo.setPeriod(new Integer(date[1]).shortValue());
        if (RPTDate13Util.isPeriod13((int)curPeriod.getPeriodNumber(), (RptPeriodTypeEnum)temp)) {
            reportInfo.setPeriod(new Integer(curPeriod.getPeriodNumber()).shortValue());
        }
        return reportInfo;
    }
}

