/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gl.app.check.CheckAppUtil;
import com.kingdee.eas.fi.gl.app.check.IClosePeriodCheck;
import com.kingdee.eas.fi.gl.app.check.IPluginClosePeriodCheck;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.ClosePeriodCheckParam;
import com.kingdee.eas.fi.gl.check.ResultStatusCode;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PluginClosePeriodCheck
implements IClosePeriodCheck {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.PluginClosePeriodCheck");

    @Override
    public CheckResult check(ClosePeriodCheckParam checkParam) {
        Context ctx = checkParam.getCtx();
        FullOrgUnitInfo fullOrgUnitInfo = checkParam.getFullOrgUnitInfo();
        CheckSchemeInfo checkSchemeInfo = checkParam.getCheckSchemeInfo();
        if (checkSchemeInfo.getConfig() == null || StringUtils.isEmpty((String)checkSchemeInfo.getConfig().getBizQuery())) {
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noBizObj"));
        }
        try {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(fullOrgUnitInfo.getId().toString()));
            if (periodInfo == null) {
                return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noCurrentPeriod"));
            }
            String bizClass = checkSchemeInfo.getConfig().getBizQuery();
            IPluginClosePeriodCheck pluginInstance = (IPluginClosePeriodCheck)Class.forName(bizClass).newInstance();
            CheckResult checkResult = pluginInstance.check(ctx, fullOrgUnitInfo, periodInfo, checkParam.getExtendParam());
            if (checkResult.getStatusCode() == ResultStatusCode.SUCCESS) {
                checkResult.setMessage(CheckAppUtil.getResource(ctx, "checkSuccess"));
            }
            return checkResult;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error((Object)"PluginClosePeriodCheck plugin execute exception.", (Throwable)e);
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "pluginExecutorError"));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"PluginClosePeriodCheck can not found plugin.", (Throwable)e);
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "noPlugin"));
        }
        catch (Exception e) {
            logger.error((Object)"PluginClosePeriodCheck exception", (Throwable)e);
            return CheckAppUtil.failResult(CheckAppUtil.getResource(ctx, "checkException") + e.getMessage());
        }
    }
}

