/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.MessageSender;
import com.kingdee.eas.fi.gl.app.check.MessageInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class SendMessageUtil {
    public static void sendMessage(Context ctx, String[] receivers, MessageInfo message) throws BOSException {
        Set<String> userIdSet = SendMessageUtil.getUserIds(ctx, receivers, message.isAllNotice());
        if (userIdSet != null) {
            Message msg = SendMessageUtil.createMessage(ctx, userIdSet, message);
            MessageSender.getInstance().sendMessage(msg);
        }
    }

    public static Set<String> getUserIds(Context ctx, String[] receivers, boolean allNotice) throws BOSException {
        if (receivers == null || receivers.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fpersonid from t_pm_user where fpersonid in(");
        for (int i = 0; i < receivers.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(receivers[i]).append("'");
        }
        sql.append(")");
        ArrayList items = SQL.executeQuery((Context)ctx, (String)sql.toString());
        if (items.size() == 0) {
            return null;
        }
        HashSet<String> userSet = new HashSet<String>();
        HashSet<String> personSet = new HashSet<String>();
        for (int i = 0; i < items.size(); ++i) {
            String s = ((HashMap)items.get(i)).get("fpersonid").toString();
            if (!allNotice && personSet.contains(s)) continue;
            personSet.add(s);
            userSet.add(((HashMap)items.get(i)).get("fid").toString());
        }
        return userSet;
    }

    private static Message createMessage(Context ctx, Set<String> userIds, MessageInfo messageInfo) {
        Message message = MessageFactory.newMessage();
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("priority", 10);
        message.setIntHeader("sourceStatus", 0);
        Locale locale1 = new Locale("l1");
        Locale locale2 = new Locale("l2");
        Locale locale3 = new Locale("l3");
        message.setLocaleStringHeader("sender", messageInfo.getSender().get(locale1), locale1);
        message.setLocaleStringHeader("sender", messageInfo.getSender().get(locale2), locale2);
        message.setLocaleStringHeader("sender", messageInfo.getSender().get(locale3), locale3);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setBooleanHeader("isSendCommon", messageInfo.isSendCommonMsg());
        message.setBooleanHeader("isSendMobile", messageInfo.isSendMsgTxt());
        message.setBooleanHeader("isSendEmail", messageInfo.isSendEmail());
        message.setStringHeader("receiver", StringUtils.arrayToString((Object[])userIds.toArray(new String[0]), (String)";"));
        message.setLocaleStringHeader("title", messageInfo.getTitle(), ctx.getLocale());
        message.setLocaleStringHeader("body", messageInfo.getBody(), ctx.getLocale());
        return message;
    }
}

