/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataImport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowItem;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Set;

public class DataImportUtils {
    public static String convertSet2String(Set set) {
        StringBuffer result = new StringBuffer();
        for (String str : set) {
            result.append("'").append(str).append("',");
        }
        return result.substring(0, result.length() - 1);
    }

    public static StringBuffer getVoucherSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("select FCompanyID,FDate,FTransDate,FPeriod,FGroup,FNum,FEntryID,FExp,FAcctID,FCyID,FExchRate,FDC,FFcyAmt,FQty,");
        sql.append("       FPrice,FDebit,FCredit,FPrepare,FPoster,FAuditor,FAttchment,FPostflag,FSourcesys,FDeleteflag,");
        sql.append("       FSerialNO,FUnitName,FReference,FHasCashFlow,FCashFlow,FTransID,FSettlCode,FSettleNO,FAsstAbstract,");
        sql.append("       FClsName1,FObjID1,FObjName1,FClsName2,FObjID2,FObjName2,FClsName3,FObjID3,FObjName3,");
        sql.append("       FClsName4,FObjID4,FObjName4,FClsName5,FObjID5,FObjName5,FClsName6,FObjID6,FObjName6,");
        sql.append("       FClsName7,FObjID7,FObjName7,FClsName8,FObjID8,FObjName8,");
        sql.append("       FInvNum,FTicketNum,FCustomer,FFeeType,FHandler,");
        sql.append("       FMaterial,FOrgUnit,FSupplier,FBizDate,FEndDate,FProfitCenterID,");
        sql.append("       FAssistUnit,FAssistQty,lineNum,fileUuID ");
        return sql;
    }

    public static boolean constructAssistInfo(Context ctx, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo) throws Exception {
        AsstActTypeInfo asstActTypeInfo;
        boolean isAssit = false;
        if (strAsstActTypeName != null && strAsstActTypeName.trim().length() > 0) {
            isAssit = true;
            strAsstActTypeName = strAsstActTypeName.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstActID)) {
            isAssit = true;
            strAsstActID = strAsstActID.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstName)) {
            isAssit = true;
            strAsstName = strAsstName.trim();
        }
        if (isAssit && (asstActTypeInfo = GlWebServiceUtil.findAsstActtypeNumberByName(ctx, strAsstActTypeName)) != null) {
            arrayAsstActTypeInfo.add(asstActTypeInfo);
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            DataBaseInfo dataInfo = DataImportUtils.findAsstActObject(ctx, asstHGAttribute, assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstName, arrayAsstActTypeInfo);
            if (dataInfo != null) {
                CostCenterOrgUnitInfo info;
                if (strAsstName != null && !strAsstName.equals(dataInfo.getName())) {
                    throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1009_InitImportBase", (Locale)ctx.getLocale()));
                }
                assistantHGInfo.put(asstHGAttribute, (Object)dataInfo);
                if (asstHGAttribute.equals("costOrg") ? (info = (CostCenterOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("adminOrg") ? (info = (AdminOrgUnitInfo)dataInfo) != null && !info.isIsLeaf() : (asstHGAttribute.equals("companyOrg") ? (info = (CompanyOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("saleOrg") ? (info = (SaleOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("purchaseOrg") ? (info = (PurchaseOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("storeageOrg") ? (info = (StorageOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : asstHGAttribute.equals("profitOrg") && (info = (ProfitCenterOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit())))))) {
                    throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1008_InitImportBase", (Locale)ctx.getLocale()));
                }
            } else {
                throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1009_InitImportBase", (Locale)ctx.getLocale()));
            }
        }
        return isAssit;
    }

    public static DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo) throws BOSException {
        return GlWebServiceUtil.findAsstActObject(ctx, asstHGAttribute, strAsstActID, strAsstName, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ContextUtil.getCurrentFIUnit((Context)ctx));
    }

    public static String getValue(IRecord data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = data.get((String)fieldName).data;
        return obj == null ? null : obj.toString().trim();
    }

    public static CashFlowItemInfo findCashflowItemByName(Context ctx, String strName) throws BOSException {
        if (strName == null || strName.trim().equals("")) {
            return null;
        }
        ICashFlowItem cashFlowItem = CashFlowItemFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("isDealActivity"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("asstAccount.number"));
        sic.add(new SelectorItemInfo("isFreeze"));
        sic.add(new SelectorItemInfo("isEnable"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strName.trim()));
        view.setFilter(filter);
        CashFlowItemInfo cashFlowItemInfo = null;
        CashFlowItemCollection cashFlowItemCollection = cashFlowItem.getCashFlowItemCollection(view);
        if (cashFlowItemCollection != null && cashFlowItemCollection.size() != 0) {
            cashFlowItemInfo = cashFlowItemCollection.get(0);
        }
        return cashFlowItemInfo;
    }

    public static AsstActGroupDetailCollection getAsstAccountDetailCollection(Context ctx, String asstAccountNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        selectors.add(new SelectorItemInfo("asstActType.id"));
        selectors.add(new SelectorItemInfo("asstActType.name"));
        selectors.add(new SelectorItemInfo("asstActType.number"));
        selectors.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selectors.add(new SelectorItemInfo("asstActType.isMultilevel"));
        selectors.add(new SelectorItemInfo("asstActType.useLongNumber"));
        FilterInfo fi = new FilterInfo();
        view.setFilter(fi);
        FilterItemCollection filters = fi.getFilterItems();
        filters.add(new FilterItemInfo("asstAccount.number", (Object)asstAccountNumber));
        AsstActGroupDetailCollection detailColl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        return detailColl;
    }

    public static BigDecimal getBigDecimalValue(Object data) throws InitException {
        BigDecimal decimal = null;
        try {
            decimal = new BigDecimal(((DataToken)data).data.toString().trim());
        }
        catch (Exception e) {
            throw new InitException(InitException.NUMBER_ERROR);
        }
        return decimal;
    }
}

