/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataProcess;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.CompareType;
import com.kingdee.eas.fi.gl.app.dataProcess.FieldType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.DataSet;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.DateDiffType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.Field;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionResult;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.WhereExpresion;
import com.kingdee.eas.fi.gl.app.dataProcess.function.CommonFunction;
import com.kingdee.eas.fi.gl.app.dataProcess.function.DateDiffFunction;
import com.kingdee.eas.fi.gl.app.dataProcess.function.RoundFunction;
import com.kingdee.eas.fi.gl.app.dataProcess.util.DataProcessUtil;
import com.kingdee.eas.fi.gl.app.dataProcess.util.logic.LogicUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataProcessEngine {
    private static Logger logger = Logger.getLogger((String)DataProcessEngine.class.getClass().getName());
    public List<Map<String, Object>> sourceData = null;
    private String tempTable = null;
    private SourceDataType dataType = null;
    private List<Map<String, Object>> tmpData = null;
    private List<String> fieldList = null;
    private Context ctx = null;

    public DataProcessEngine(List<Map<String, Object>> data) {
        this.sourceData = data;
        this.dataType = SourceDataType.LIST;
    }

    public DataProcessEngine(Context ctx, String tempTable) {
        this.ctx = ctx;
        this.tempTable = tempTable;
        this.dataType = SourceDataType.TMPTABLE;
    }

    public void DataProceeEngin(Context ctx, String tempTable, List<String> fieldList) {
        this.ctx = ctx;
        this.tempTable = tempTable;
        this.fieldList = fieldList;
        this.dataType = SourceDataType.TMPTABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProcessEngine queryData() throws BOSException, SQLException {
        if (this.dataType == SourceDataType.TMPTABLE && this.tempTable != null) {
            this.sourceData = new ArrayList<Map<String, Object>>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = EJBFactory.getConnection((Context)this.ctx);
                String sql = "select * from " + this.tempTable;
                stmt = con.prepareStatement(sql.toString());
                stmt.setFetchSize(100);
                rs = stmt.executeQuery();
                List<String> fields = this.getFields(rs.getMetaData());
                while (rs.next()) {
                    HashMap<String, Object> rowData = new HashMap<String, Object>();
                    for (String field : fields) {
                        rowData.put(field.toLowerCase(), rs.getObject(field));
                    }
                    this.sourceData.add(rowData);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        }
        return this;
    }

    private List<String> getFields(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> fields = new ArrayList<String>();
        int count = metaData.getColumnCount();
        while (count > 0) {
            fields.add(metaData.getColumnName(count--));
        }
        Collections.reverse(fields);
        return fields;
    }

    public DataProcessEngine where(List<WhereExpresion> whereExps) {
        return this.where(whereExps, null);
    }

    public DataProcessEngine where(List<WhereExpresion> whereExps, String maskStr) {
        List<Map<String, Object>> data;
        this.tmpData = this.tmpData == null ? new ArrayList() : this.tmpData;
        boolean isTmpData = this.tmpData.size() > 0;
        List<Map<String, Object>> list = data = isTmpData ? this.tmpData : this.sourceData;
        if (data != null) {
            if (!StringUtils.isEmpty((String)maskStr)) {
                if (!this.validatorMaskStr(whereExps, maskStr)) {
                    throw new RuntimeException("maskStr is error.");
                }
                maskStr = maskStr.replaceAll("and", "&&").replaceAll("or", "||");
            }
            Iterator<Map<String, Object>> iterator = data.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> rowData = iterator.next();
                boolean flag = this.whereExpression(whereExps, rowData, maskStr);
                if (flag) {
                    if (isTmpData) continue;
                    this.tmpData.add(rowData);
                    continue;
                }
                if (!isTmpData) continue;
                iterator.remove();
            }
        }
        return this;
    }

    private boolean validatorMaskStr(List<WhereExpresion> whereExps, String maskStr) {
        String[] split = maskStr.split("and|or");
        if (split.length <= 0 || split.length != whereExps.size()) {
            return false;
        }
        int size = whereExps.size();
        for (int i = 0; i < size; ++i) {
            if (("#" + i).equals(split[i].trim())) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean whereExpression(List<WhereExpresion> whereExps, Map<String, Object> rowData, String maskStr) {
        int i = 0;
        boolean flag = false;
        boolean andLogicFlag = true;
        for (WhereExpresion whereExp : whereExps) {
            if (!andLogicFlag && StringUtils.isEmpty((String)maskStr)) {
                return false;
            }
            Object value = rowData.get(whereExp.getName());
            if (value == null) {
                value = "";
            }
            Object expValue = whereExp.getValue();
            if (whereExp.getType() == CompareType.EQUALS) {
                if (value.equals(expValue)) {
                    flag = true;
                }
            } else if (whereExp.getType() == CompareType.INCLUDE) {
                if (!(expValue instanceof Set)) throw new RuntimeException("CompareType is 'in',value muste 'Set' type.");
                if (((Set)expValue).contains(value)) {
                    flag = true;
                }
            } else if (whereExp.getType() == CompareType.LESS) {
                if (value instanceof String) {
                    flag = ((String)value).compareTo((String)expValue) < 0;
                } else if (value instanceof Date) {
                    flag = ((Date)value).compareTo((Date)expValue) < 0;
                } else if (value instanceof Timestamp) {
                    flag = ((Timestamp)value).compareTo((Timestamp)expValue) < 0;
                } else if (value instanceof BigDecimal) {
                    flag = ((BigDecimal)value).compareTo((BigDecimal)expValue) < 0;
                } else {
                    if (!(value instanceof Integer)) throw new RuntimeException("supported value type is String,Date,BigDecimal.");
                    flag = ((Integer)value).compareTo((Integer)expValue) < 0;
                }
            } else if (whereExp.getType() == CompareType.GREATER) {
                if (value instanceof String) {
                    flag = ((String)value).compareTo((String)expValue) > 0;
                } else if (value instanceof Date) {
                    flag = ((Date)value).compareTo((Date)expValue) > 0;
                } else if (value instanceof Timestamp) {
                    flag = ((Timestamp)value).compareTo((Timestamp)expValue) > 0;
                } else if (value instanceof BigDecimal) {
                    flag = ((BigDecimal)value).compareTo((BigDecimal)expValue) > 0;
                } else {
                    if (!(value instanceof Integer)) throw new RuntimeException("supported value type is String,Date,BigDecimal.");
                    flag = ((Integer)value).compareTo((Integer)expValue) > 0;
                }
            } else if (whereExp.getType() == CompareType.LESS_EQUALS) {
                if (value instanceof String) {
                    flag = ((String)value).compareTo((String)expValue) <= 0;
                } else if (value instanceof Date) {
                    flag = ((Date)value).compareTo((Date)expValue) <= 0;
                } else if (value instanceof Timestamp) {
                    flag = ((Timestamp)value).compareTo((Timestamp)expValue) <= 0;
                } else if (value instanceof BigDecimal) {
                    flag = ((BigDecimal)value).compareTo((BigDecimal)expValue) <= 0;
                } else {
                    if (!(value instanceof Integer)) throw new RuntimeException("supported value type is String,Date,BigDecimal.");
                    flag = ((Integer)value).compareTo((Integer)expValue) <= 0;
                }
            } else if (whereExp.getType() == CompareType.GREATER_EQUALS) {
                if (value instanceof String) {
                    flag = ((String)value).compareTo((String)expValue) >= 0;
                } else if (value instanceof Date) {
                    flag = ((Date)value).compareTo((Date)expValue) >= 0;
                } else if (value instanceof Timestamp) {
                    flag = ((Timestamp)value).compareTo((Timestamp)expValue) >= 0;
                } else if (value instanceof BigDecimal) {
                    flag = ((BigDecimal)value).compareTo((BigDecimal)expValue) >= 0;
                } else {
                    if (!(value instanceof Integer)) throw new RuntimeException("supported value type is String,Date,BigDecimal.");
                    flag = ((Integer)value).compareTo((Integer)expValue) >= 0;
                }
            } else {
                if (whereExp.getType() != CompareType.NOTEQUALS) throw new RuntimeException("not supported where expression type.");
                flag = !value.equals(expValue);
            }
            if (StringUtils.isEmpty((String)maskStr)) {
                andLogicFlag = andLogicFlag && flag;
            } else {
                maskStr = maskStr.replace("#" + i, String.valueOf(flag));
            }
            flag = false;
            ++i;
        }
        if (!StringUtils.isEmpty((String)maskStr)) return LogicUtil.parse2(maskStr);
        return andLogicFlag;
    }

    public DataProcessEngine join(DataSet dataSet, String leftField, String rightField) {
        List<Map<String, Object>> data = this.tmpData != null ? this.tmpData : this.sourceData;
        ArrayList<Map<String, Object>> tempData = new ArrayList<Map<String, Object>>(data.size());
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> rRowData : data) {
            for (Map<String, Object> tRowData1 : dataSet.getDataSource()) {
                if (!rRowData.get(leftField).equals(tRowData1.get(rightField))) continue;
                tempData.add(rRowData);
                for (Map.Entry<String, Object> entry : tRowData1.entrySet()) {
                    rRowData.put(sb.append(dataSet.getDataSourceName()).append(".").append(entry.getKey()).toString(), entry.getValue());
                    sb.setLength(0);
                }
            }
        }
        this.tmpData = tempData;
        return this;
    }

    public DataProcessEngine dateDiff(DateDiffFunction dateDiffFunction, java.util.Date compareDate) {
        List<Map<String, Object>> data = this.tmpData != null ? this.tmpData : this.sourceData;
        List<Object> tempData = this.tmpData == null ? new ArrayList(data.size()) : this.tmpData;
        DateDiffType dateDiffType = dateDiffFunction.getDateDiffType();
        Field field = dateDiffFunction.getField();
        if (field.getFieldType() != FieldType.Date) {
            throw new RuntimeException("DateDiff Function only support Date Type Field.");
        }
        String fieldName = field.getFieldName();
        for (Map<String, Object> rowData : data) {
            Object value = rowData.get(fieldName);
            if (!(value instanceof java.util.Date)) continue;
            switch (dateDiffType) {
                case D: {
                    long day = (compareDate.getTime() - ((java.util.Date)value).getTime()) / 86400000L;
                    rowData.put(field.getAliasName(), day);
                    if (this.tmpData != null) break;
                    tempData.add(rowData);
                }
            }
        }
        this.tmpData = tempData;
        return this;
    }

    public DataProcessEngine sum(CommonFunction sumFunction) {
        sumFunction.setFuntionType(FunctionType.Sum);
        return this.sum(sumFunction, null);
    }

    public DataProcessEngine sum(CommonFunction sumFunction, Map<String, Object> defaultCol) {
        sumFunction.setFuntionType(FunctionType.Sum);
        this.groupByFunction(sumFunction, defaultCol);
        return this;
    }

    public DataProcessEngine round(List<RoundFunction> roundFunctions) {
        List<Map<String, Object>> data;
        List<Map<String, Object>> list = data = this.tmpData != null ? this.tmpData : this.sourceData;
        if (data != null) {
            for (Map<String, Object> rowData : data) {
                for (RoundFunction roundFunction : roundFunctions) {
                    String fieldName = roundFunction.getField();
                    int scale = roundFunction.getPrecisionField() != null ? ((Integer)rowData.get(roundFunction.getPrecisionField())).intValue() : roundFunction.getScale();
                    Object value = rowData.get(fieldName);
                    if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).setScale(scale, 4);
                        rowData.put(fieldName, value);
                        continue;
                    }
                    throw new RuntimeException("only supported BigDecimal type.");
                }
            }
        }
        return this;
    }

    public DataProcessEngine max(CommonFunction commonFunctions) {
        commonFunctions.setFuntionType(FunctionType.Max);
        this.groupByFunction(commonFunctions, null);
        return this;
    }

    public DataProcessEngine min(CommonFunction commonFunctions) {
        commonFunctions.setFuntionType(FunctionType.Min);
        this.groupByFunction(commonFunctions, null);
        return this;
    }

    private void groupByFunction(CommonFunction commonFucntion, Map<String, Object> defaultCol) {
        List<Map<String, Object>> data;
        List<Map<String, Object>> list = data = this.tmpData != null ? this.tmpData : this.sourceData;
        if (data != null) {
            HashMap<String, Map<String, FunctionResult>> groupByMap = new HashMap<String, Map<String, FunctionResult>>();
            StringBuilder groupByKey = new StringBuilder();
            List<Field> groupByFieldList = commonFucntion.getGroupByFields();
            List<FunctionField> functionFields = commonFucntion.getFunctionFields();
            for (Map<String, Object> rowData : data) {
                ArrayList<Field> groupByFields = new ArrayList<Field>(groupByFieldList.size());
                for (Field groupByFieldTemp : groupByFieldList) {
                    Field groupByField = new Field(groupByFieldTemp.getFieldName(), groupByFieldTemp.getFieldType(), groupByFieldTemp.getAliasName());
                    Object value = rowData.get(groupByFieldTemp.getFieldName());
                    try {
                        FieldType fieldType = groupByFieldTemp.getFieldType();
                        value = value == null ? DataProcessUtil.getDefaultValue(fieldType) : value;
                    }
                    catch (ParseException e) {
                        logger.error((Object)"parse date error.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    groupByField.setValue(value);
                    groupByFields.add(groupByField);
                    groupByKey.append(value).append("$");
                }
                for (FunctionField functionField : functionFields) {
                    FunctionResult functionRs;
                    Map<String, FunctionResult> functionRsMap;
                    boolean flag;
                    List<WhereExpresion> whereExps;
                    Object value = rowData.get(functionField.getFieldName());
                    FieldType fieldType = functionField.getFieldType();
                    String groupByKeyStr = groupByKey.toString();
                    if (fieldType == FieldType.BigDecimal) {
                        value = value == null ? BigDecimal.ZERO : value;
                    } else if (fieldType == FieldType.Integer) {
                        value = value == null ? Integer.valueOf(0) : value;
                    } else {
                        throw new RuntimeException("only support BigDecimal,Integer data type.");
                    }
                    if ((whereExps = functionField.getWhereExpresions()) != null && !(flag = this.whereExpression(whereExps, rowData, functionField.getWhereMaskStr()))) continue;
                    if (groupByMap.containsKey(groupByKeyStr)) {
                        functionRsMap = (Map)groupByMap.get(groupByKeyStr);
                        if (functionRsMap.containsKey(functionField.getAliasName())) {
                            Number functionValue;
                            FunctionResult functionResult = (FunctionResult)functionRsMap.get(functionField.getAliasName());
                            if (value instanceof BigDecimal) {
                                functionValue = (BigDecimal)functionResult.getFunctionValue();
                                if (commonFucntion.getFuntionType() == FunctionType.Max) {
                                    this.maxFunction(value, functionResult, functionValue);
                                    continue;
                                }
                                if (commonFucntion.getFuntionType() == FunctionType.Min) {
                                    this.minFunction(value, functionResult, functionValue);
                                    continue;
                                }
                                if (commonFucntion.getFuntionType() == FunctionType.Sum) {
                                    functionResult.setFunctionValue(((BigDecimal)functionResult.getFunctionValue()).add((BigDecimal)value));
                                    continue;
                                }
                                throw new RuntimeException("not support this function.");
                            }
                            if (value instanceof Integer) {
                                functionValue = (Integer)functionResult.getFunctionValue();
                                if (commonFucntion.getFuntionType() == FunctionType.Max) {
                                    this.maxFunction(value, functionResult, functionValue);
                                    continue;
                                }
                                if (commonFucntion.getFuntionType() == FunctionType.Min) {
                                    this.minFunction(value, functionResult, functionValue);
                                    continue;
                                }
                                if (commonFucntion.getFuntionType() == FunctionType.Sum) {
                                    functionResult.setFunctionValue((Integer)functionResult.getFunctionValue() + (Integer)value);
                                    continue;
                                }
                                throw new RuntimeException("not support this function.");
                            }
                            throw new RuntimeException("only support BigDecimal,Integer data type.");
                        }
                        functionRs = new FunctionResult();
                        functionRs.setGroupByFields(groupByFields);
                        functionRs.setFunctionField(functionField);
                        functionRs.setFunctionValue(value);
                        functionRsMap.put(functionField.getAliasName(), functionRs);
                        continue;
                    }
                    functionRsMap = new HashMap();
                    functionRs = new FunctionResult();
                    functionRs.setGroupByFields(groupByFields);
                    functionRs.setFunctionField(functionField);
                    functionRs.setFunctionValue(value);
                    functionRsMap.put(functionField.getAliasName(), functionRs);
                    groupByMap.put(groupByKeyStr, functionRsMap);
                }
                groupByKey.setLength(0);
            }
            if (this.tmpData != null) {
                this.tmpData.clear();
            }
            ArrayList<Map<String, Object>> rowDatas = new ArrayList<Map<String, Object>>(groupByMap.size());
            for (Map.Entry entry : groupByMap.entrySet()) {
                Map value = (Map)entry.getValue();
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                List<Field> grpFields = null;
                for (Map.Entry functionEntry : value.entrySet()) {
                    FunctionResult functionValue = (FunctionResult)functionEntry.getValue();
                    rowData.put(functionValue.getFunctionField().getAliasName(), functionValue.getFunctionValue());
                    grpFields = functionValue.getGroupByFields();
                }
                if (grpFields != null) {
                    for (Field field : grpFields) {
                        rowData.put(field.getAliasName(), field.getValue());
                    }
                }
                if (defaultCol != null) {
                    rowData.putAll(defaultCol);
                }
                rowDatas.add(rowData);
            }
            this.tmpData = rowDatas;
        }
    }

    private void minFunction(Object value, FunctionResult functionResult, Object functionValue) {
        if (functionValue == null) {
            functionResult.setFunctionValue(value);
        } else if (functionValue instanceof BigDecimal) {
            if (((BigDecimal)value).compareTo((BigDecimal)functionValue) < 0) {
                functionResult.setFunctionValue(value);
            }
        } else if (functionValue instanceof Integer && (Integer)value < (Integer)functionValue) {
            functionResult.setFunctionValue(value);
        }
    }

    private void maxFunction(Object value, FunctionResult functionResult, Object functionValue) {
        if (functionValue == null) {
            functionResult.setFunctionValue(value);
        } else if (functionValue instanceof BigDecimal) {
            if (((BigDecimal)value).compareTo((BigDecimal)functionValue) > 0) {
                functionResult.setFunctionValue(value);
            }
        } else if (functionValue instanceof Integer && (Integer)value > (Integer)functionValue) {
            functionResult.setFunctionValue(value);
        }
    }

    public List<Map<String, Object>> select(List<String> selectFields) {
        List<Map<String, Object>> data;
        ArrayList resultList = null;
        List<Map<String, Object>> list = data = this.tmpData != null ? this.tmpData : this.sourceData;
        if (data != null) {
            resultList = new ArrayList();
            for (Map<String, Object> rowData : data) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (String field : selectFields) {
                    resultMap.put(field, rowData.get(field));
                }
                resultList.add(resultMap);
            }
        }
        return resultList;
    }

    public List<Map<String, Object>> select(List<String> selectFields, FieldType fieldType) {
        List<Map<String, Object>> data;
        ArrayList resultList = null;
        List<Map<String, Object>> list = data = this.tmpData != null ? this.tmpData : this.sourceData;
        if (data != null) {
            resultList = new ArrayList();
            for (Map<String, Object> rowData : data) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (String field : selectFields) {
                    resultMap.put(field, rowData.get(field) == null ? (fieldType == FieldType.BigDecimal ? BigDecimal.ZERO : null) : rowData.get(field));
                }
                resultList.add(resultMap);
            }
        }
        return resultList;
    }

    public DataProcessEngine update(Map<String, Object> fieldAndValue) {
        List<Map<String, Object>> data;
        List<Map<String, Object>> list = data = this.tmpData != null ? this.tmpData : this.sourceData;
        if (data != null) {
            for (Map<String, Object> rowData : data) {
                for (Map.Entry<String, Object> entry : fieldAndValue.entrySet()) {
                    String field = entry.getKey();
                    if (!rowData.containsKey(field)) continue;
                    rowData.put(field, entry.getValue());
                }
            }
        }
        return this;
    }

    public DataProcessEngine updateByField(Map<String, String> fieldMap) {
        List<Map<String, Object>> data;
        List<Map<String, Object>> list = data = this.tmpData != null ? this.tmpData : this.sourceData;
        if (data != null) {
            for (Map<String, Object> rowData : data) {
                for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                    String fieldName = entry.getValue();
                    if (!rowData.containsKey(fieldName)) continue;
                    rowData.put(entry.getKey(), rowData.get(fieldName));
                }
            }
        }
        return this;
    }

    public DataProcessEngine insert(List<Map<String, Object>> rowData) {
        if (rowData != null && rowData.size() > 0) {
            List<Map<String, Object>> data = this.tmpData != null ? this.tmpData : this.sourceData;
            data.addAll(rowData);
        }
        return this;
    }

    public DataProcessEngine delete(List<WhereExpresion> whereExps) {
        return this.delete(whereExps, null);
    }

    public DataProcessEngine delete(List<WhereExpresion> whereExps, String maskStr) {
        this.tmpData = this.tmpData == null ? new ArrayList() : this.tmpData;
        boolean isTmpData = this.tmpData.size() > 0;
        List<Map<String, Object>> data = isTmpData ? this.tmpData : this.sourceData;
        Iterator<Map<String, Object>> iterator = data.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> rowData = iterator.next();
            boolean flag = this.whereExpression(whereExps, rowData, maskStr);
            if (flag) {
                if (!isTmpData) continue;
                iterator.remove();
                continue;
            }
            if (isTmpData) continue;
            this.tmpData.add(rowData);
        }
        return this;
    }

    public void setTmpData(List<Map<String, Object>> tmpData) {
        this.tmpData = tmpData;
    }

    public List<Map<String, Object>> getTmpData() {
        return this.tmpData;
    }

    public void releaseTmpData() {
        this.tmpData = null;
    }

    public void release() {
        this.sourceData = null;
        this.tmpData = null;
    }

    public static enum SourceDataType {
        LIST,
        TMPTABLE;

    }
}

