/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataProcess.util.logic;

import com.kingdee.eas.fi.gl.app.dataProcess.util.logic.DateUtil;
import com.kingdee.eas.fi.gl.app.dataProcess.util.logic.OperandTypeEnum;
import com.kingdee.eas.fi.gl.app.dataProcess.util.logic.OperatorEnum;
import com.kingdee.util.StringUtils;
import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class LogicUtil {
    public static boolean parse2(String expression) {
        LinkedList<String> operands = new LinkedList<String>();
        LinkedList<String> operate = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = expression.getBytes("UTF-8");
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] < 0) {
                    if (i == bytes.length - 1) continue;
                    sb.append(new String(new byte[]{bytes[i], bytes[i + 1]}, "UTF-8"));
                    ++i;
                    continue;
                }
                String thisOp = new String(new byte[]{bytes[i]});
                if ("(".equals(thisOp)) {
                    LogicUtil.pushOperandIntoStack(operands, sb);
                    operate.addFirst(thisOp);
                    continue;
                }
                if (")".equals(thisOp)) {
                    LogicUtil.pushOperandIntoStack(operands, sb);
                    String topOp = (String)operate.pollFirst();
                    while (!"(".equals(topOp)) {
                        LogicUtil.calculate(operands, topOp);
                        if (operate.size() > 0) {
                            topOp = (String)operate.pollFirst();
                            continue;
                        }
                        return false;
                    }
                    continue;
                }
                if (OperatorEnum.isOperator(thisOp)) {
                    LogicUtil.pushOperandIntoStack(operands, sb);
                    String nextOp = new String(new byte[]{bytes[i + 1]});
                    if (!"(".equals(nextOp) && !")".equals(nextOp) && OperatorEnum.isOperator(nextOp)) {
                        thisOp = thisOp + nextOp;
                        ++i;
                    }
                    if (operate.size() > 0) {
                        String topOp = (String)operate.getFirst();
                        while (!"(".equals(topOp) && OperatorEnum.getEnumByName(topOp).getPriority() < OperatorEnum.getEnumByName(thisOp).getPriority()) {
                            topOp = (String)operate.pollFirst();
                            LogicUtil.calculate(operands, topOp);
                            if (operate.size() <= 0) break;
                            topOp = (String)operate.getFirst();
                        }
                    }
                    operate.addFirst(thisOp);
                    continue;
                }
                sb.append(thisOp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sb.length() > 0) {
            operands.addFirst(sb.toString());
        }
        while (operate.size() > 0) {
            String topOp = (String)operate.pollFirst();
            LogicUtil.calculate(operands, topOp);
        }
        if (operands.size() > 0) {
            String str = (String)operands.pollFirst();
            return !StringUtils.isEmpty((String)str) ? Boolean.parseBoolean(str) : false;
        }
        return false;
    }

    private static void pushOperandIntoStack(Deque operands, StringBuilder sb) {
        if (sb.length() > 0) {
            operands.addFirst(sb.toString());
            sb.setLength(0);
        }
    }

    private static void calculate(Deque<String> operands, String topOp) {
        OperandTypeEnum type2;
        String operand2 = operands.pollFirst().trim();
        String operand1 = operands.pollFirst().trim();
        OperandTypeEnum type1 = LogicUtil.judgeType(operand1);
        if (type1 == (type2 = LogicUtil.judgeType(operand2))) {
            switch (type1) {
                case NUM: {
                    operands.addFirst(LogicUtil.numCalculate(Long.parseLong(operand1), Long.parseLong(operand2), OperatorEnum.getEnumByName(topOp)) + "");
                    break;
                }
                case DATE: {
                    operands.addFirst(LogicUtil.dateCalculate(operand1, operand2, OperatorEnum.getEnumByName(topOp)) + "");
                    break;
                }
                case STR: {
                    operands.addFirst(LogicUtil.strCalculate(operand1, operand2, OperatorEnum.getEnumByName(topOp)) + "");
                }
            }
        } else {
            operands.addFirst("false");
        }
    }

    private static OperandTypeEnum judgeType(String operands) {
        if (Pattern.matches("^[-\\+]?[\\d]*$", operands = operands.trim())) {
            return OperandTypeEnum.NUM;
        }
        if (DateUtil.verifyDateLegal(operands)) {
            return OperandTypeEnum.DATE;
        }
        return OperandTypeEnum.STR;
    }

    private static boolean numCalculate(long operand1, long operand2, OperatorEnum operate) {
        switch (operate) {
            case LT: {
                return operand1 < operand2;
            }
            case ELT: {
                return operand1 <= operand2;
            }
            case GT: {
                return operand1 > operand2;
            }
            case EGT: {
                return operand1 >= operand2;
            }
            case EQ: {
                return operand1 == operand2;
            }
            case NEQ: {
                return operand1 != operand2;
            }
        }
        return true;
    }

    private static boolean strCalculate(String operand1, String operand2, OperatorEnum operate) {
        switch (operate) {
            case EQ: {
                return operand1.equals(operand2);
            }
            case NEQ: {
                return !operand1.equals(operand2);
            }
            case AND: {
                return "true".equals(operand1) && "true".equals(operand2);
            }
            case OR: {
                return "true".equals(operand1) || "true".equals(operand2);
            }
        }
        return true;
    }

    private static boolean dateCalculate(String operand1, String operand2, OperatorEnum operate) {
        switch (operate) {
            case LT: {
                return DateUtil.compareDate(operand1, operand2) == -1;
            }
            case ELT: {
                return DateUtil.compareDate(operand1, operand2) <= 0;
            }
            case GT: {
                return DateUtil.compareDate(operand1, operand2) == 1;
            }
            case EGT: {
                return DateUtil.compareDate(operand1, operand2) >= 0;
            }
            case EQ: {
                return DateUtil.compareDate(operand1, operand2) == 0;
            }
            case NEQ: {
                return DateUtil.compareDate(operand1, operand2) != 0;
            }
        }
        return true;
    }
}

