/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.gpt.service.cashflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowTAccountFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashFlowTAccountFacade;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashFlowApplyDefaultItemGptService {
    private static Logger logger = Logger.getLogger(CashFlowApplyDefaultItemGptService.class);
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.app.gpt.cashflow.ApplyDefault";

    public static Map execute(Map params) throws BOSException {
        return new CashFlowApplyDefaultItemGptService().applyDefaultItem(params);
    }

    private Map applyDefaultItem(Map params) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        Context ctx = (Context)params.get("bosCtx");
        String matchOrgsStr = (String)params.get("matchOrgs");
        String periodStr = (String)params.get("period");
        List<String> matchCompanys = this.buildCompanyParam(matchOrgsStr);
        int period = this.buildPeriodParam(periodStr);
        Map<String, Object> bizCompanyMap = this.classifyCompany(ctx, matchCompanys);
        List invalidCompany = (List)bizCompanyMap.get("invalid");
        ArrayList<String> noPermissionCompany = new ArrayList<String>();
        ArrayList<String> successCompany = new ArrayList<String>();
        ArrayList<String> failCompany = new ArrayList<String>();
        List validCompany = (List)bizCompanyMap.get("valid");
        if (validCompany != null && validCompany.size() > 0) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            String permissionItem = "gl_cashflow_taccount_add";
            ICashFlowTAccountFacade facade = CashFlowTAccountFacadeFactory.getLocalInstance(ctx);
            for (int i = 0; i < validCompany.size(); ++i) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)validCompany.get(i);
                ObjectUuidPK orgPk = new ObjectUuidPK(company.getId());
                boolean hasPermission = true;
                try {
                    hasPermission = iPermission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem);
                    if (hasPermission) {
                        boolean isSuccess = this.doApplyDefault(facade, company, period);
                        if (isSuccess) {
                            this.classify(company, successCompany);
                            continue;
                        }
                        this.classify(company, failCompany);
                        continue;
                    }
                    this.classify(company, noPermissionCompany);
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
            }
        }
        String msg = this.formatMsg(ctx, invalidCompany, noPermissionCompany, successCompany, failCompany);
        result.put("msg", msg);
        return result;
    }

    private String formatMsg(Context ctx, List<String> invalidCompany, List<String> noPermissionCompany, List<String> successCompany, List<String> failCompany) {
        StringBuilder msg = new StringBuilder();
        if (invalidCompany != null && invalidCompany.size() > 0) {
            if (msg.length() > 0) {
                msg.append("\n\n");
            }
            msg.append(EASResource.getString((String)RESOURCE, (String)"invalidCompany", (Locale)ctx.getLocale()));
            msg.append("\n\n").append(invalidCompany.toString());
        }
        if (noPermissionCompany != null && noPermissionCompany.size() > 0) {
            if (msg.length() > 0) {
                msg.append("\n\n");
            }
            msg.append(EASResource.getString((String)RESOURCE, (String)"noPermissionCompany", (Locale)ctx.getLocale()));
            msg.append("\n\n").append(noPermissionCompany.toString());
        }
        if (successCompany != null && successCompany.size() > 0) {
            if (msg.length() > 0) {
                msg.append("\n\n");
            }
            msg.append(EASResource.getString((String)RESOURCE, (String)"successCompany", (Locale)ctx.getLocale()));
            msg.append("\n\n").append(successCompany.toString());
        }
        if (failCompany != null && failCompany.size() > 0) {
            if (msg.length() > 0) {
                msg.append("\n\n");
            }
            msg.append(EASResource.getString((String)RESOURCE, (String)"failCompany", (Locale)ctx.getLocale()));
            msg.append("\n\n").append(failCompany.toString());
        }
        return msg.toString();
    }

    private void classify(CompanyOrgUnitInfo company, List<String> companyList) {
        companyList.add(company.getName());
    }

    private boolean doApplyDefault(ICashFlowTAccountFacade facade, CompanyOrgUnitInfo company, int period) {
        boolean isSuccess = true;
        try {
            facade.smartAccountApplyDefaultCashflowItem(company.getNumber(), period, period, true, false);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)e);
            isSuccess = false;
        }
        return isSuccess;
    }

    private Map<String, Object> classifyCompany(Context ctx, List<String> matchCompanys) {
        try {
            return GlUtils.getBizCompany(ctx, matchCompanys, true);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return new HashMap<String, Object>();
        }
    }

    private List<String> buildCompanyParam(String matchOrgsStr) {
        return Arrays.asList(matchOrgsStr.split(","));
    }

    private int buildPeriodParam(String periodStr) {
        int periodInvalidLength = 5;
        if (!StringUtils.isEmpty((String)periodStr) && periodStr.length() == periodInvalidLength) {
            periodStr = periodStr.substring(0, 4) + "0" + periodStr.substring(4);
        }
        return Integer.parseInt(periodStr);
    }
}

