/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractAntiAuditBaseVoucherService
extends AbstractOperateVoucherService
implements IAntiAuditVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractAntiAuditBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;
    private static final String NEW_VOUCHER_NUMBER = "newVoucherNumber";

    public AbstractAntiAuditBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void antiAuditVoucher(Context ctx, IObjectPK pk, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        this.operateSharer.lockVoucher(ctx, pk.toString());
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this.iVoucher.getValue(pk, this.getAnitAuditSelector());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"antiAuditVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)pk, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        List beforeListeners = this.getBeforeActionListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.ANTIAUDIT);
        try {
            this._antiAuditVoucher(ctx, (IObjectValue)voucherInfo, preStatus);
            List afterListeners = this.getAfterActionListeners(ctx);
            if (afterListeners != null) {
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
                }
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            if (voucherInfo.get(NEW_VOUCHER_NUMBER) != null) {
                try {
                    this.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get(NEW_VOUCHER_NUMBER));
                }
                catch (Exception ex) {
                    logger.error((Object)"Recycle voucher number error when save voucher!", (Throwable)ex);
                }
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BOSException((Throwable)e);
        }
    }

    protected abstract SelectorItemCollection getAnitAuditSelector();

    protected void _antiAuditVoucher(Context ctx, IObjectValue model, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)model;
        HashMap param = GlUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString());
        this.beforeAntiAudit(ctx, voucherInfo, param);
        this.processBudget(ctx, voucherInfo, param);
        ctx.put((Object)"GL_VOUCHERNUMBER_LOG", param.get("GL_VOUCHERNUMBER_LOG"));
        this.processCodingRule(ctx, model, voucherInfo);
        this.updateAntiAuditStatus(ctx, voucherInfo.getId().toString());
        this.afterAntiAudit(ctx, voucherInfo, param);
    }

    private void processBudget(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException {
        Object budgetParam = param.get("GL_075");
        if (budgetParam == null || !"0".equals(budgetParam)) {
            VoucherUtil.returnBudgetSubstract(ctx, voucherInfo);
        }
    }

    protected abstract void processCodingRule(Context var1, IObjectValue var2, BaseVoucherInfo var3) throws EASBizException, BOSException;

    protected void afterAntiAudit(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException {
    }

    protected void beforeAntiAudit(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException, VoucherException {
    }

    protected abstract void updateAntiAuditStatus(Context var1, String var2) throws BOSException;

    protected void recycleVoucherId(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            Throwable ex = null;
            try {
                this.iVoucher.recycleVoucherNumber(voucherInfo, voucherNumber);
            }
            catch (BOSException e) {
                ex = e;
                throw e;
            }
            catch (EASBizException e) {
                ex = e;
                throw e;
            }
            finally {
                boolean isLogVoucherNumber = false;
                if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                    isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
                }
                if (isLogVoucherNumber) {
                    this.logVoucherNumber(ctx, voucherInfo, voucherNumber, (Exception)ex);
                }
            }
        } else {
            BaseVoucherInfo previousVoucher = null;
            String[] value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    protected abstract void logVoucherNumber(Context var1, BaseVoucherInfo var2, String var3, Exception var4) throws BOSException, EASBizException;
}

