/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractAntiPostBaseVoucherService
extends AbstractOperateVoucherService
implements IAntiPostVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractAntiPostBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    private String resClassName = "com.kingdee.eas.fi.gl.GLResource";
    protected GlParam sysParam = null;

    public AbstractAntiPostBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void antiPostVoucher(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        String voucherId = null;
        ObjectUuidPK voucherPK = null;
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherPK = new ObjectUuidPK(voucherInfo.getId());
        voucherId = voucherInfo.getId().toString();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"antiPostVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)voucherPK, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        List beforeListeners = this.getBeforeActionListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        this.operateSharer.lockVoucher(ctx, voucherId);
        BaseVoucherInfo sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(voucherInfo.getId()));
        if (sVoucher == null) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
        }
        this.checkStatusAndOperate(sVoucher.getBizStatus(), VoucherOperateStatusEnum.ANTIPOST);
        if (this.isAdjustVoucher(voucherInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"903_VoucherControllerBean", (Locale)ctx.getLocale())));
        }
        HashMap param = GlUtils.getDefaultGLParam(ctx, this.getOrgID(voucherInfo));
        this.beforeAntiPost(ctx, voucherInfo, voucherId, param);
        this.postVoucher(ctx, voucherId, this.getOrgID(voucherInfo), 5, true, false, null);
        voucherInfo.setPoster(null);
        this.insertVoucherLog(ctx, voucherId);
        this.updateAntiPostStatus(ctx, voucherId);
        this.afterAntiPost(ctx, voucherInfo, voucherId, param);
        List afterListeners = this.getAfterActionListeners(ctx);
        if (afterListeners != null) {
            for (Object afterListener : afterListeners) {
                ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected boolean isAdjustVoucher(BaseVoucherInfo voucherInfo) {
        return SourceType.ACCOUNTADJUST.equals((Object)voucherInfo.getSourceType());
    }

    protected boolean isAsstAccountChangeVoucher(BaseVoucherInfo voucherInfo) {
        return SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType());
    }

    protected String getOrgID(BaseVoucherInfo voucherInfo) {
        return voucherInfo.getCompany().getId().toString();
    }

    protected abstract void updateAntiPostStatus(Context var1, String var2) throws BOSException;

    protected abstract void insertVoucherLog(Context var1, String var2) throws BOSException;

    protected void beforeAntiPost(Context ctx, BaseVoucherInfo voucherInfo, String voucherId, HashMap param) throws BOSException, EASBizException, VoucherException {
    }

    protected void afterAntiPost(Context ctx, BaseVoucherInfo voucherInfo, String voucherId, HashMap param) throws BOSException, EASBizException {
    }

    protected void checkIfVerified4VerifyModePost(Context ctx, String voucherId, HashMap param, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        int verifyMode = Integer.parseInt(param.get("GL_052").toString());
        if (verifyMode != 1) {
            return;
        }
        boolean hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(voucherId);
        if (hasVerified) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    protected abstract void postVoucher(Context var1, String var2, String var3, int var4, boolean var5, boolean var6, Map var7) throws BOSException, EASBizException;
}

