/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCancelBaseVoucherService
extends AbstractOperateVoucherService
implements ICancelVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractCancelBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;
    private static final String NEW_VOUCHER_NUMBER = "newVoucherNumber";

    public AbstractCancelBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void cancelVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.operateSharer.lockVoucher(ctx, pk.toString());
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this.iVoucher.getValue(pk, this.getCancelSelector());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"cancelVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)pk, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        List beforeListeners = this.getBeforeActionListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        if (voucherInfo.isIsCheck()) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"act_change_cancel", (Locale)ctx.getLocale())));
        }
        try {
            this._cancelVoucher(ctx, (IObjectValue)voucherInfo);
            List afterListeners = this.getAfterActionListeners(ctx);
            if (afterListeners != null) {
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
                }
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            if (voucherInfo.get(NEW_VOUCHER_NUMBER) != null) {
                try {
                    this.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get(NEW_VOUCHER_NUMBER));
                }
                catch (Exception ex) {
                    logger.error((Object)"Recycle voucher number error when save voucher!", (Throwable)ex);
                }
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BOSException((Throwable)e);
        }
    }

    protected abstract SelectorItemCollection getCancelSelector();

    protected void _cancelVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)model;
        HashMap hmAllParam = this.getParamMap(ctx, voucherInfo);
        this.beforeCancel(ctx, voucherInfo, hmAllParam);
        this.insertVoucherLog(ctx, voucherInfo);
        this.operateSharer.updateVoucherStatus(ctx, voucherInfo, VoucherStatusEnum.CANCELLED);
        this.afterCancel(ctx, voucherInfo);
        VoucherUtil.returnBudgetSubstract(ctx, voucherInfo);
    }

    private void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 5, true, voucherInfo.getBizStatus() == VoucherStatusEnum.POSTED);
    }

    protected void afterCancel(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    protected void beforeCancel(Context ctx, BaseVoucherInfo voucherInfo, Map hmAllParam) throws EASBizException, BOSException {
        String value;
        boolean removeDAP_void = Boolean.valueOf(hmAllParam.get("GL_019_1").toString());
        if (voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && !StringUtils.isEmpty((String)(value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "G003"))) && Boolean.valueOf(value).booleanValue()) {
            throw new VoucherException(VoucherException.CANNOT_CANCEL_IMP_VOUCHER);
        }
        if (voucherInfo.isIsCheck()) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.CANCLE);
        if (voucherInfo.getCashier() != null) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
        if (this.isFromOtherSystem(voucherInfo)) {
            int deleteCtrl = 0;
            try {
                deleteCtrl = Integer.parseInt(hmAllParam.get("GL_019").toString());
            }
            catch (Exception ex) {
                throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_019"});
            }
            if (deleteCtrl == 0) {
                throw new VoucherException(VoucherException.CANCELLED_CTRL_BYOTHER, new Object[]{voucherInfo.getVoucherType().getName(), voucherInfo.getNumber()});
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from " + this.getVoucherTable() + " where fsourcebillid=? and FIsReverseVoucher=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString(), new Integer(1)});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.REVERSED_VCH_NOT_CANCEL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (voucherInfo.isIsReverseVoucher()) {
            String srcVchId = voucherInfo.getSourceBillId();
            BaseVoucherInfo srcVch = this.newInfo();
            BOSUuid id = BOSUuid.read((String)srcVchId);
            srcVch.setId(id);
            srcVch.setHasReversed(false);
            this.iVoucher.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)srcVch);
        }
        this.processDap(ctx, voucherInfo, removeDAP_void);
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        if (this.existCodingRule(ctx, voucherInfo)) {
            ctx.put((Object)"GL_VOUCHERNUMBER_LOG", hmAllParam.get("GL_VOUCHERNUMBER_LOG"));
            this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
        }
        voucherInfo.setBizStatus(oldStatus);
        voucherInfo.setBizStatus(VoucherStatusEnum.CANCELLED);
        if (this.existCodingRule(ctx, voucherInfo)) {
            voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.CANCELLED));
        } else {
            voucherInfo.setBizStatus(VoucherStatusEnum.CANCELLED);
        }
        voucherInfo.setCanceller(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (!voucherInfo.isIsReverseVoucher()) {
            voucherInfo.setIsReverseVoucher(false);
            if (removeDAP_void) {
                voucherInfo.setSourceBillId(null);
            }
        }
    }

    protected abstract String getVoucherTable();

    protected abstract BaseVoucherInfo newInfo();

    protected abstract boolean isFromOtherSystem(BaseVoucherInfo var1);

    protected abstract boolean existCodingRule(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected abstract void processDap(Context var1, BaseVoucherInfo var2, boolean var3) throws BOSException, EASBizException;

    protected abstract HashMap getParamMap(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected void recycleVoucherId(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            Throwable ex = null;
            try {
                this.iVoucher.recycleVoucherNumber(voucherInfo, voucherNumber);
            }
            catch (BOSException e) {
                ex = e;
                throw e;
            }
            catch (EASBizException e) {
                ex = e;
                throw e;
            }
            finally {
                boolean isLogVoucherNumber = false;
                if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                    isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
                }
                if (isLogVoucherNumber) {
                    this.logVoucherNumber(ctx, voucherInfo, voucherNumber, (Exception)ex);
                }
            }
        } else {
            BaseVoucherInfo previousVoucher = null;
            String[] value = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    protected abstract void logVoucherNumber(Context var1, BaseVoucherInfo var2, String var3, Exception var4) throws BOSException, EASBizException;
}

