/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractOperateVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractOperateVoucherService.class);

    protected abstract IBaseVoucher getIBaseVoucher(Context var1) throws BOSException;

    protected BaseVoucherInfo getStatusVoucher(Context ctx, ObjectUuidPK pk) throws EASBizException, BOSException {
        String table = null;
        BOSUuid id = BOSUuid.read((String)pk.toString());
        if ("2652E01E".equals(id.getType().toString())) {
            table = "T_GL_Voucher";
        } else if ("D6952559".equals(id.getType().toString())) {
            table = "T_PCA_PCVoucher";
        } else {
            return null;
        }
        String sql = "select FBizStatus, FLastUpdateTime, FSourceSys, FSourceType, FNumber from " + table + " where FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{pk.toString()});
        try {
            if (rs.next()) {
                BaseVoucherInfo voucher = new BaseVoucherInfo();
                voucher.setId(id);
                voucher.setBizStatus(VoucherStatusEnum.getEnum((int)rs.getInt("FBizStatus")));
                voucher.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                voucher.setSourceSys(SystemEnum.getEnum((int)rs.getInt("FSourceSys")));
                voucher.setSourceType(SourceType.getEnum((int)rs.getInt("FSourceType")));
                voucher.setNumber(rs.getString("FNumber"));
                return voucher;
            }
            return null;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkStatusAndOperate(VoucherStatusEnum bizStatus, VoucherOperateStatusEnum operateStatus) throws EASBizException {
        int i = operateStatus.getValue();
        int j = bizStatus.getValue();
        Object[] info = new String[]{operateStatus.toString(), bizStatus.toString()};
        if (!IVoucherOprateSharer.voucherStatus[i][j]) {
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, info);
        }
    }

    protected String getLogDetail(Context ctx, BaseVoucherInfo voucherInfo) {
        String LogDetail = voucherInfo.getVoucherType() != null ? voucherInfo.getVoucherType().getName(ctx.getLocale()) : "?";
        LogDetail = LogDetail + "-";
        LogDetail = voucherInfo.getPeriod() != null ? (voucherInfo.getPeriod().getNumber() > 0 ? LogDetail + voucherInfo.getPeriod().getNumber() : (voucherInfo.getPeriod().getPeriodNumber() < 10 ? LogDetail + voucherInfo.getPeriod().getPeriodYear() + "0" + voucherInfo.getPeriod().getPeriodNumber() : LogDetail + voucherInfo.getPeriod().getPeriodYear() + "" + voucherInfo.getPeriod().getPeriodNumber())) : LogDetail + "?";
        LogDetail = LogDetail + "-";
        LogDetail = LogDetail + (voucherInfo.getNumber() != null ? voucherInfo.getNumber() : "?");
        return LogDetail;
    }

    protected String getLogItemName() {
        return null;
    }

    protected void afterLog(Context ctx, IObjectPK logPK, IObjectPK instancePK, String instanceDeatil) {
        if (logPK == null) {
            return;
        }
        try {
            AppLogInfo info = new AppLogInfo();
            info.setId(BOSUuid.read((String)logPK.toString()));
            info.setInstanceId(instancePK != null ? instancePK.toString() : null);
            info.setInstanceNo(instanceDeatil);
            GLGeneralFacadeFactory.getLocalInstance(ctx).updateAppLog(info);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
    }

    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return null;
    }

    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return null;
    }
}

