/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.app.voucher.IPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPostBaseVoucherService
extends AbstractOperateVoucherService
implements IPostVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractPostBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;

    public AbstractPostBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void postVoucher(Context ctx, BaseVoucherInfo voucherInfo, Map checkViews) throws BOSException, EASBizException {
        List beforeListeners;
        this.initGlParam(ctx, voucherInfo);
        ObjectUuidPK voucherPK = null;
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherPK = new ObjectUuidPK(voucherInfo.getId());
        IObjectPK logPK = null;
        if (!"WebService".equals(voucherInfo.getString("entrance")) || this.sysParam.getBoolean("GL_VchImp_LogApp")) {
            logPK = LogUtil.beginLog((Context)ctx, (String)"postVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)voucherPK, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        }
        if ((beforeListeners = this.getBeforeActionListeners(ctx)) != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        this.operateSharer.lockVoucher(ctx, voucherInfo.getId().toString());
        BaseVoucherInfo sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(voucherInfo.getId()));
        if (sVoucher == null) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
        }
        this.checkStatusAndOperate(sVoucher.getBizStatus(), VoucherOperateStatusEnum.POST);
        this.initVoucherValidator(ctx);
        voucherInfo.setBizStatus(sVoucher.getBizStatus());
        if (checkViews != null && checkViews.get("periodValidate") != null) {
            voucherInfo.put("periodValidate", checkViews.get("periodValidate"));
        }
        this.validatorVoucher(ctx, voucherInfo);
        this.doPost(ctx, voucherInfo, this.sysParam, checkViews);
        this.insertVoucherLog(ctx, voucherInfo);
        this.synVoucher2Books(ctx, voucherInfo, this.sysParam);
        this.submitworkflow(ctx, voucherInfo);
        this.invokeVoucherPostPostProcessor(ctx, voucherInfo);
        List afterListeners = this.getAfterActionListeners(ctx);
        if (afterListeners != null) {
            for (Object afterListener : afterListeners) {
                ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_post";
    }

    private void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    protected abstract void initVoucherValidator(Context var1) throws EASBizException, BOSException;

    protected abstract void validatorVoucher(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    private void doPost(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, Map checkViews) throws EASBizException, BOSException {
        this.post(ctx, voucherInfo, sysParam, checkViews);
        this.updateVoucherPostedStatus(ctx, voucherInfo);
    }

    protected abstract void post(Context var1, BaseVoucherInfo var2, GlParam var3, Map var4) throws EASBizException, BOSException;

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IPostVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = this.getParamList();
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected String[] getParamList() {
        String[] paramList = new String[]{"G001", "G012", "G010", "GLG01", "GLG01_2", "GL_008", "GL_028", "GL_032", "GL_046", "GL_052", "GL_056", "GL_031", "GL_VCH_POST_CONTROL"};
        return paramList;
    }

    protected abstract void updateVoucherPostedStatus(Context var1, BaseVoucherInfo var2) throws BOSException;

    protected void synVoucher2Books(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        if (sysParam.getBoolean("G012")) {
            if (!this.isMasterBook(ctx, voucherInfo.getCompany())) {
                return;
            }
            boolean useReport = sysParam.getBoolean("G001");
            boolean allowCussent = sysParam.getBoolean("GL_028");
            boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
            BookUtil._transferVoucher(ctx, 1, voucherInfo.getId().toString(), voucherInfo.getCompany().getId().toString(), useReport, allowCussent, isInTimeVerify);
        }
    }

    private boolean isMasterBook(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        boolean isMasterBook = false;
        String companyId = company.getId().toString();
        if (cache != null) {
            if (cache.getMasterBookMap().containsKey(companyId)) {
                isMasterBook = (Boolean)cache.getMasterBookMap().get(companyId);
            } else {
                AcountSchemeInfo scheme = this.getAccountScheme(ctx, companyId);
                if (scheme != null) {
                    isMasterBook = scheme.isIsMaster();
                    cache.setMasterBook(companyId, isMasterBook);
                }
            }
        } else {
            AcountSchemeInfo scheme = this.getAccountScheme(ctx, companyId);
            if (scheme != null) {
                isMasterBook = scheme.isIsMaster();
            }
        }
        return isMasterBook;
    }

    private AcountSchemeInfo getAccountScheme(Context ctx, String companyId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountScheme.isMaster");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        return company.getAccountScheme();
    }

    private void submitworkflow(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.sysParam.getBoolean("GL_032")) {
            this.iVoucher.postVoucher((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    protected void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 3, false, true);
    }

    protected abstract void invokeVoucherPostPostProcessor(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;
}

