/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherServiceFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherServiceFacadeFactory;
import com.kingdee.eas.fi.gl.app.voucher.ITransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.TransactVoucherColParameter;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.Counter;
import com.kingdee.eas.fi.gl.common.GLExecutor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractTransactVoucherColService
implements ITransactVoucherColService {
    private final Counter counter = new Counter();
    private final Object synObj = new Object();
    protected boolean multiThread = false;
    private boolean shareCache = false;
    private int threadCount = 2;
    private final Object synPer = new Object();
    private int VOUCHER_NUM = 20;
    protected static final Logger log = Logger.getLogger(AbstractTransactVoucherColService.class);
    private IVoucher iVoucher = null;
    protected Hashtable<String, String> commonErrors = new Hashtable();
    protected Hashtable<String, String> noPermErrors = new Hashtable();
    protected boolean throwError = true;
    protected Map<String, String> errors = new HashMap<String, String>();

    public void transactVoucherColMyself(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        LinkedHashSet[] IdSets = this.splitIdList2Idstr(parameterObject.getPkList(), this.VOUCHER_NUM);
        for (int i = 0; i < IdSets.length; ++i) {
            TransactVoucherColParameter tmpParaObj = new TransactVoucherColParameter();
            tmpParaObj.setCtx(parameterObject.getCtx());
            tmpParaObj.setIdSet(IdSets[i]);
            tmpParaObj.setSys(parameterObject.getSys());
            tmpParaObj.setPreStatus(parameterObject.getPreStatus());
            tmpParaObj.setCheckViews(parameterObject.getCheckViews());
            this.batchVoucherCollection(tmpParaObj);
        }
        this.processError(parameterObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactVoucherCol(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        if (parameterObject.getPkList() == null || parameterObject.getPkList().size() == 0) {
            return;
        }
        Context ctx = parameterObject.getCtx();
        ArrayList<MutexParameter> mps = new ArrayList<MutexParameter>();
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache cache;
            boolean mutexLockModifyBalance = false;
            String actionResName = this.getMutexActionResName();
            if (actionResName != null) {
                Set<String> companyIds = this.getCompanyIds(parameterObject);
                if (companyIds.size() == 0) {
                    return;
                }
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                Iterator<String> mp = companyIds.iterator();
                while (mp.hasNext()) {
                    boolean isSucceed;
                    String companyId = mp.next();
                    MutexParameter mp2 = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, actionResName, null, MutexLockType.SHARE_LOCK);
                    MutexParameter current = mutex.requestMutex3(mp2);
                    boolean bl = isSucceed = current == null;
                    if (isSucceed) {
                        mps.add(mp2);
                        continue;
                    }
                    throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp2)));
                }
                mutexLockModifyBalance = true;
            }
            if (parameterObject.getPkList().size() <= 10) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).setMutexLockModifyBalance(mutexLockModifyBalance);
                this.transactVoucherColMyself(parameterObject);
                return;
            }
            this.initThreadParam(ctx);
            if (!this.multiThread || parameterObject.getPkList().size() <= this.VOUCHER_NUM) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).setMutexLockModifyBalance(mutexLockModifyBalance);
                this.transactVoucherColMyself(parameterObject);
                return;
            }
            LinkedHashSet[] IdSets = this.splitIdList2Idstr(parameterObject.getPkList(), this.VOUCHER_NUM);
            if (IdSets.length < this.threadCount) {
                this.threadCount = IdSets.length;
            }
            int tCount = 1;
            HashMap<Integer, ArrayList<LinkedHashSet>> map = new HashMap<Integer, ArrayList<LinkedHashSet>>();
            for (int i = 0; i < IdSets.length; ++i) {
                ArrayList<LinkedHashSet> list = (ArrayList<LinkedHashSet>)map.get(tCount);
                if (list == null) {
                    list = new ArrayList<LinkedHashSet>();
                    map.put(tCount, list);
                }
                list.add(IdSets[i]);
                if (++tCount <= this.threadCount) continue;
                tCount = 1;
            }
            if (this.shareCache) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).setMutexLockModifyBalance(mutexLockModifyBalance);
            }
            if ((cache = VoucherProcessCache.getCache(ctx)) != null) {
                cache.setMultiThread(true);
            }
            ArrayList<OptTask> tasks = new ArrayList<OptTask>();
            for (int i = 1; i <= this.threadCount; ++i) {
                List list = (List)map.get(i);
                OptTask task = new OptTask(parameterObject, list, cache, mutexLockModifyBalance);
                tasks.add(task);
                GLExecutor.execute(task);
            }
            Iterator iterator = this.synObj;
            synchronized (iterator) {
                while (this.counter.i < tasks.size()) {
                    try {
                        this.synObj.wait();
                    }
                    catch (InterruptedException list) {}
                }
            }
            for (OptTask task : tasks) {
                if (task.ex == null) continue;
                if (task.ex instanceof EASBizException) {
                    throw (EASBizException)task.ex;
                }
                if (task.ex instanceof BOSException) {
                    throw (BOSException)task.ex;
                }
                throw new BOSException(task.ex);
            }
        }
        finally {
            for (MutexParameter mp : mps) {
                try {
                    mutex.releaseMutex(mp.getRequestId());
                }
                catch (Throwable throwable) {}
            }
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
        this.processError(parameterObject);
    }

    @Override
    public Map transactVouchers(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        this.throwError = false;
        this.transactVoucherCol(parameterObject);
        return this.errors;
    }

    protected void initThreadParam(Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> paramKeys = new HashMap<String, Object>();
        paramKeys.put("GL_VchOpt_MultiThread", null);
        paramKeys.put("GL_VchSubmit_MultiThread", null);
        paramKeys.put("GL_VchOpt_ShareCache", null);
        paramKeys.put("GL_VchOpt_ThreadCount", null);
        paramKeys.put("GL_VchOpt_BatchCount", null);
        HashMap params = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(paramKeys);
        this.processThreadParam(params);
    }

    protected void processThreadParam(Map params) {
        String str;
        if (params.get("GL_VchOpt_MultiThread") != null && "true".equals(str = params.get("GL_VchOpt_MultiThread").toString())) {
            this.multiThread = true;
        }
        if (params.get("GL_VchOpt_ShareCache") != null && "true".equals(str = params.get("GL_VchOpt_ShareCache").toString())) {
            this.shareCache = true;
        }
        if (params.get("GL_VchOpt_ThreadCount") != null) {
            try {
                str = params.get("GL_VchOpt_ThreadCount").toString();
                this.threadCount = Integer.parseInt(str);
            }
            catch (Exception str2) {
                // empty catch block
            }
            if (this.threadCount < 2 || this.threadCount > 16) {
                this.threadCount = 2;
            }
        }
        if (params.get("GL_VchOpt_BatchCount") != null) {
            try {
                str = params.get("GL_VchOpt_BatchCount").toString();
                this.VOUCHER_NUM = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.VOUCHER_NUM < 10 || this.VOUCHER_NUM > 100) {
                this.VOUCHER_NUM = 20;
            }
        }
    }

    protected void processError(TransactVoucherColParameter parameterObject) throws EASBizException, BOSException {
        if (this.commonErrors.size() <= 0 && this.noPermErrors.size() <= 0) {
            return;
        }
        VoucherCollection vchCol = null;
        if (this.noPermErrors.size() > 0) {
            vchCol = this.getNoPermVouchers(parameterObject.getCtx(), this.noPermErrors.keySet());
        }
        StringBuffer errMsg = new StringBuffer();
        for (Object pk : parameterObject.getPkList()) {
            VoucherInfo voucher;
            String id = pk.toString();
            if (this.commonErrors.containsKey(id)) {
                if (this.throwError) {
                    errMsg.append("\r\n").append(this.commonErrors.get(id));
                    continue;
                }
                this.errors.put(id, this.commonErrors.get(id));
                continue;
            }
            if (!this.noPermErrors.containsKey(id) || vchCol == null || (voucher = vchCol.get((Object)BOSUuid.read((String)id))) == null) continue;
            String msg = voucher.getVoucherType().getName() + " " + voucher.getNumber() + " " + this.noPermErrors.get(id);
            if (this.throwError) {
                errMsg.append("\r\n").append(msg);
                continue;
            }
            this.errors.put(id, msg);
        }
        if (this.throwError) {
            throw this.getVoucherException(errMsg.toString());
        }
    }

    protected abstract EntityViewInfo getEntityView(Set var1);

    protected VoucherException getVoucherException(String errMsg) {
        return new VoucherException(VoucherException.VOUCHER_FAIL, new Object[]{errMsg});
    }

    protected void machiningVoucherCollection(Context ctx, Set idSet, VoucherCollection voucherCollection) throws BOSException, EASBizException {
    }

    protected abstract void beforeTransactVoucherNewTrans(Context var1, VoucherInfo var2) throws BOSException, EASBizException;

    protected abstract void transactVoucherNewTrans(Context var1, TransactVoucherColParameter var2, VoucherInfo var3) throws BOSException, EASBizException;

    protected abstract void catchTransactException(Context var1, VoucherInfo var2, String var3, Exception var4);

    protected LinkedHashSet[] splitIdList2Idstr(List voucherIDList, int batchSize) {
        if (voucherIDList == null || voucherIDList.size() == 0) {
            return null;
        }
        LinkedHashSet idLinkedSet = new LinkedHashSet(voucherIDList);
        LinkedHashSet[] idSets = new LinkedHashSet[idLinkedSet.size() / batchSize + (idLinkedSet.size() % batchSize > 0 ? 1 : 0)];
        LinkedHashSet idSet = null;
        int num = 0;
        int index = 0;
        Iterator it = idLinkedSet.iterator();
        while (it.hasNext()) {
            if (index == num * batchSize) {
                idSet = new LinkedHashSet();
                idSets[num++] = idSet;
            }
            idSet.add(it.next());
            ++index;
        }
        return idSets;
    }

    protected void batchVoucherCollection(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        if (parameterObject.getCtx() == null || parameterObject.getIdSet() == null) {
            return;
        }
        Context ctx = parameterObject.getCtx();
        IVoucher iVoucher = this.getVoucherService(ctx);
        VoucherCollection allVoucherColl = iVoucher.getVoucherCollection(this.getEntityView(parameterObject.getIdSet()));
        VoucherCollection hasPermissionVoucherColl = this.getHasPermissionVoucherCollection(ctx, allVoucherColl);
        this.machiningVoucherCollection(ctx, parameterObject.getIdSet(), hasPermissionVoucherColl);
        VoucherInfo voucherInfo = null;
        Iterator idIter = parameterObject.getIdSet().iterator();
        while (idIter.hasNext()) {
            String voucherid = idIter.next().toString();
            voucherInfo = hasPermissionVoucherColl.get((Object)BOSUuid.read((String)voucherid));
            String oldNumber = "";
            try {
                if (voucherInfo == null) {
                    voucherInfo = allVoucherColl.get((Object)BOSUuid.read((String)voucherid));
                    if (!iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherid))) continue;
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getPermItemName());
                    Object[] object = new Object[]{voucherInfo.getCompany().getName(), permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_DATA_PERMISSION, object);
                    throw pe;
                }
                oldNumber = voucherInfo.getNumber();
                this.beforeTransactVoucherNewTrans(ctx, voucherInfo);
                this.checkPermission(ctx, voucherInfo);
                this.disablePermission();
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                this.transactVoucherNewTrans(ctx, parameterObject, voucherInfo);
            }
            catch (Exception e) {
                log.error((Object)"ERROR", (Throwable)e);
                if (e instanceof PermissionException) {
                    this.noPermErrors.put(voucherid, e.getMessage());
                    continue;
                }
                this.catchTransactException(ctx, voucherInfo, oldNumber, e);
            }
        }
    }

    protected VoucherCollection getHasPermissionVoucherCollection(Context ctx, VoucherCollection allVoucherColl) throws BOSException, EASBizException {
        VoucherCollection hasPermissionVoucherColl = new VoucherCollection();
        HashMap compamyMap = new HashMap();
        int size = allVoucherColl.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo vch = allVoucherColl.get(i);
            String companyID = vch.getCompany().getId().toString();
            Set<String> idSet = null;
            if (compamyMap.get(companyID) == null) {
                idSet = new HashSet();
                compamyMap.put(companyID, idSet);
            } else {
                idSet = (Set)compamyMap.get(companyID);
            }
            idSet.add(vch.getId().toString());
        }
        Iterator companyIter = compamyMap.keySet().iterator();
        while (companyIter.hasNext()) {
            String companyID = companyIter.next().toString();
            Set idSet = (Set)compamyMap.get(companyID);
            hasPermissionVoucherColl.addCollection(this.queryHasDataPermVoucherCollection(ctx, this.getQueryPermissionSql(ctx, companyID), this.getVoucherService(ctx), this.getEntityView(idSet)));
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            cache.setVoucherCollection(this.getEntityView(new HashSet()).getSelector(), hasPermissionVoucherColl);
        }
        return hasPermissionVoucherColl;
    }

    private String getQueryPermissionSql(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(companyID);
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, this.getPermItemName());
        if (StringUtils.isEmpty((String)rule)) {
            return null;
        }
        return PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, this.getPermItemName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPermission(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Object object = this.synPer;
        synchronized (object) {
            String companyid = voucherInfo.getCompany().getId().toString();
            VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
            if (cache.getFunctionPermMap().get(companyid) == null) {
                cache.getFunctionPermMap().put(companyid, false);
                this.checkFunctionPermission(ctx, (IObjectPK)new ObjectUuidPK(companyid), this.getPermItemName());
                cache.getFunctionPermMap().put(companyid, true);
            } else {
                Boolean hasFunctionPermission = (Boolean)cache.getFunctionPermMap().get(companyid);
                if (!hasFunctionPermission.booleanValue()) {
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getPermItemName());
                    Object[] object2 = new Object[]{permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, object2);
                    throw pe;
                }
            }
        }
    }

    abstract String getPermItemName();

    protected VoucherCollection queryHasDataPermVoucherCollection(Context ctx, String queryPermissionSql, IVoucher ivoucher, EntityViewInfo view) throws BOSException, EASBizException {
        if (queryPermissionSql != null && queryPermissionSql.trim().length() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)queryPermissionSql, CompareType.INNER));
            filterInfo.mergeFilter(view.getFilter(), "and");
            view.setFilter(filterInfo);
        }
        VoucherCollection vchColl = ivoucher.getVoucherCollection(view);
        return vchColl;
    }

    public void disablePermission() throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_ENTRYS_SERVICE");
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
    }

    private void checkFunctionPermission(Context ctx, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        permission.checkFunctionPermission((IObjectPK)userPK, orgPK, permItemName);
    }

    protected IVoucherServiceFacade getVoucherServiceFacade(Context ctx) throws BOSException {
        return VoucherServiceFacadeFactory.getLocalInstance(ctx);
    }

    private VoucherCollection getNoPermVouchers(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        return this.getVoucherService(ctx).getVoucherCollection(view);
    }

    protected IVoucher getVoucherService(Context ctx) throws BOSException {
        if (this.iVoucher == null) {
            this.iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        }
        return this.iVoucher;
    }

    public String getMutexActionResName() {
        return null;
    }

    protected Set<String> getCompanyIds(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        int i;
        HashSet<String> companyIds = new HashSet<String>();
        int batchCount = 100;
        String fullSql = "select FID, FCompanyID from T_GL_Voucher where FID in (" + AbstractTransactVoucherColService.buildMark(batchCount) + ")";
        String lessSql = null;
        Context ctx = parameterObject.getCtx();
        List list = parameterObject.getPkList();
        ArrayList idss = new ArrayList();
        Set ids = new HashSet<String>();
        for (i = 0; i < list.size(); ++i) {
            Object pk = list.get(i);
            if (pk == null) continue;
            ids.add(pk.toString());
            if (ids.size() != 100) continue;
            idss.add(ids);
            ids = new HashSet();
        }
        if (ids.size() > 0) {
            idss.add(ids);
            lessSql = "select distinct FCompanyID from T_GL_Voucher where FID in (" + AbstractTransactVoucherColService.buildMark(ids.size()) + ")";
        }
        try {
            for (i = 0; i < idss.size(); ++i) {
                ids = (Set)idss.get(i);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(ids.size() == batchCount ? fullSql : lessSql), (Object[])ids.toArray());
                while (rs.next()) {
                    companyIds.add(rs.getString("FCompanyID"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyIds;
    }

    public static String buildMark(int count) {
        StringBuffer mark = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                mark.append("?");
                continue;
            }
            mark.append(", ?");
        }
        return mark.toString();
    }

    class OptTask
    implements Runnable {
        TransactVoucherColParameter srcParam = null;
        List<LinkedHashSet> idSets;
        VoucherProcessCache cache = null;
        boolean mutexLockModifyBalance;
        Throwable ex;

        OptTask(TransactVoucherColParameter srcParam, List<LinkedHashSet> idSets, VoucherProcessCache cache, boolean mutexLockModifyBalance) {
            this.srcParam = srcParam;
            this.idSets = idSets;
            this.cache = cache;
            this.mutexLockModifyBalance = mutexLockModifyBalance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String cacheId = BOSUuid.create((String)"ABCD1234").toString();
            if (this.cache != null) {
                cacheId = this.cache.getCacheId();
                VoucherProcessCache.initCache(this.srcParam.getCtx(), this.cache);
            } else {
                VoucherProcessCache.initCache(this.srcParam.getCtx(), cacheId);
                VoucherProcessCache.getCache(this.srcParam.getCtx()).setMultiThread(true);
                VoucherProcessCache.getCache(this.srcParam.getCtx()).setMutexLockModifyBalance(this.mutexLockModifyBalance);
            }
            try {
                for (LinkedHashSet idSet : this.idSets) {
                    TransactVoucherColParameter param = new TransactVoucherColParameter();
                    param.setCtx(this.srcParam.getCtx());
                    param.setIdSet(idSet);
                    param.setSys(this.srcParam.getSys());
                    param.setPreStatus(this.srcParam.getPreStatus());
                    param.setCheckViews(this.srcParam.getCheckViews());
                    AbstractTransactVoucherColService.this.batchVoucherCollection(param);
                }
            }
            catch (Throwable ex) {
                this.ex = ex;
            }
            finally {
                VoucherProcessCache.clearCache(this.srcParam.getCtx(), cacheId);
            }
            Object object = AbstractTransactVoucherColService.this.synObj;
            synchronized (object) {
                ++((AbstractTransactVoucherColService)AbstractTransactVoucherColService.this).counter.i;
                AbstractTransactVoucherColService.this.synObj.notifyAll();
            }
        }
    }
}

