/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.voucher.IAuditVoucherCollectionService;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AuditBaseVoucherCollectionService
implements IAuditVoucherCollectionService {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.voucher.AuditVoucherCollectionService");
    protected int VOUCHER_NUM = 20;
    protected Hashtable<String, String> commonErrors = new Hashtable();
    protected Hashtable<String, String> noPermErrors = new Hashtable();

    public AuditBaseVoucherCollectionService(Context ctx) throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit(Context ctx, List voucherIdList, BOSUuid auditorId) throws BOSException, EASBizException {
        if (voucherIdList == null || voucherIdList.size() == 0) {
            return;
        }
        LinkedHashSet[] idSets = this.splitIdList2Idstr(voucherIdList, this.VOUCHER_NUM);
        this.initCache(ctx);
        try {
            for (int i = 0; i < idSets.length; ++i) {
                this.auditVoucherCollection(ctx, idSets[i], auditorId);
            }
        }
        finally {
            this.clearCache(ctx);
        }
        this.processError(ctx, voucherIdList);
    }

    @Override
    public void audit(Context ctx, List voucherIdList) throws BOSException, EASBizException {
        BOSUuid auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        this.audit(ctx, voucherIdList, auditorId);
    }

    protected abstract void processError(Context var1, List var2) throws EASBizException, BOSException;

    protected abstract void auditVoucherCollection(Context var1, LinkedHashSet var2, BOSUuid var3) throws BOSException, EASBizException;

    protected abstract void clearCache(Context var1);

    protected abstract void initCache(Context var1);

    protected EntityViewInfo getEntityView(SelectorItemCollection selectorItemCollection, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    protected abstract String getAuditPermissionItem();

    protected void checkFunctionPermission(Context ctx, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        permission.checkFunctionPermission((IObjectPK)userPK, orgPK, permItemName);
    }

    protected LinkedHashSet[] splitIdList2Idstr(List voucherIDList, int batchSize) {
        if (voucherIDList == null || voucherIDList.size() == 0) {
            return null;
        }
        LinkedHashSet idLinkedSet = new LinkedHashSet(voucherIDList);
        LinkedHashSet[] idSets = new LinkedHashSet[idLinkedSet.size() / batchSize + (idLinkedSet.size() % batchSize > 0 ? 1 : 0)];
        LinkedHashSet idSet = null;
        int num = 0;
        int index = 0;
        Iterator it = idLinkedSet.iterator();
        while (it.hasNext()) {
            if (index == num * batchSize) {
                idSet = new LinkedHashSet();
                idSets[num++] = idSet;
            }
            idSet.add(it.next());
            ++index;
        }
        return idSets;
    }

    public void disablePermission() throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_ENTRYS_SERVICE");
        ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
    }

    protected String getQueryPermissionSql(Context ctx, String permItem, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(companyID);
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, permItem);
        if (StringUtils.isEmpty((String)rule)) {
            return null;
        }
        return PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, permItem);
    }
}

