/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AuditBaseVoucherService
extends AbstractOperateVoucherService
implements IAuditVoucherService {
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected static final Logger logger = Logger.getLogger(AuditBaseVoucherService.class);
    protected GlParam sysParam = null;

    public AuditBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void audit(Context ctx, IObjectPK pk, BOSUuid auditorId) throws BOSException, EASBizException {
        this.operateSharer.lockVoucher(ctx, pk.toString());
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this.iVoucher.getValue(pk, this.getAuditSelector());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"auditVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)pk, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        List beforeListeners = this.getBeforeActionListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        this.initGlParam(ctx, voucherInfo);
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.AUDIT);
        this.validate(ctx, voucherInfo, auditorId);
        this.clearAuditBack(ctx, voucherInfo, this.sysParam);
        try {
            this.handleAuditVoucherNumber(ctx, voucherInfo);
            this.updateAuditStatus(ctx, voucherInfo, auditorId);
            this.afterAudit(ctx, voucherInfo);
            List afterListeners = this.getAfterActionListeners(ctx);
            if (afterListeners != null) {
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
                }
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            if (voucherInfo.get("newVoucherNumber") != null) {
                try {
                    this.operateSharer.recycleVoucherId(ctx, voucherInfo, (String)voucherInfo.get("newVoucherNumber"));
                }
                catch (Exception ex) {
                    logger.error((Object)"Recycle voucher number error when audit voucher!", (Throwable)ex);
                }
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_audit";
    }

    protected abstract SelectorItemCollection getAuditSelector();

    protected void updateAuditStatus(Context ctx, BaseVoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException {
        VoucherOprateSharer.updateVoucherStatus(ctx, voucherInfo.getId().toString(), auditorId.toString(), VoucherStatusEnum.AUDITTED.getValue(), "FAuditorId");
    }

    protected void afterAudit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, BgCtrlException, EASBizException {
    }

    protected abstract void validate(Context var1, BaseVoucherInfo var2, BOSUuid var3) throws BOSException, EASBizException;

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAuditVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramItems = new String[]{"G001", "GL_028", "GLG01", "GLG01_2", "GL_052", "G012", "GL_029", "GL_032", "GL_047", "GL_099", "GL_075", "GL_0491"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramItems, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected abstract String getVoucherTable();

    private void handleAuditVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.existCodingRule(ctx, voucherInfo)) {
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            this.operateSharer.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.AUDITTED);
            String sql = "update " + this.getVoucherTable() + " set fnumber=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getNumber(), voucherInfo.getId().toString()});
        }
    }

    protected abstract boolean existCodingRule(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected void clearAuditBack(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
    }
}

